/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IntList;
import com.android.dx.util.LabeledItem;
import java.util.Arrays;

public class LabeledList
extends FixedSizeList {
    private final IntList labelToIndex;

    public LabeledList(int size) {
        super(size);
        this.labelToIndex = new IntList(size);
    }

    public LabeledList(LabeledList old) {
        super(old.size());
        this.labelToIndex = old.labelToIndex.mutableCopy();
        int sz4 = old.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            Object one = old.get0(i15);
            if (one == null) continue;
            this.set0(i15, one);
        }
    }

    public final int getMaxLabel() {
        int i15;
        int sz4 = this.labelToIndex.size();
        for (i15 = sz4 - 1; i15 >= 0 && this.labelToIndex.get(i15) < 0; --i15) {
        }
        int newSize = i15 + 1;
        this.labelToIndex.shrink(newSize);
        return newSize;
    }

    private void removeLabel(int oldLabel) {
        this.labelToIndex.set(oldLabel, -1);
    }

    private void addLabelIndex(int label, int index) {
        int origSz = this.labelToIndex.size();
        for (int i15 = 0; i15 <= label - origSz; ++i15) {
            this.labelToIndex.add(-1);
        }
        this.labelToIndex.set(label, index);
    }

    public final int indexOfLabel(int label) {
        if (label >= this.labelToIndex.size()) {
            return -1;
        }
        return this.labelToIndex.get(label);
    }

    public final int[] getLabelsInOrder() {
        int sz4 = this.size();
        int[] result = new int[sz4];
        for (int i15 = 0; i15 < sz4; ++i15) {
            LabeledItem li4 = (LabeledItem)this.get0(i15);
            if (li4 == null) {
                throw new NullPointerException("null at index " + i15);
            }
            result[i15] = li4.getLabel();
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public void shrinkToFit() {
        super.shrinkToFit();
        this.rebuildLabelToIndex();
    }

    private void rebuildLabelToIndex() {
        int szItems = this.size();
        for (int i15 = 0; i15 < szItems; ++i15) {
            LabeledItem li4 = (LabeledItem)this.get0(i15);
            if (li4 == null) continue;
            this.labelToIndex.set(li4.getLabel(), i15);
        }
    }

    protected void set(int n15, LabeledItem item) {
        LabeledItem old = (LabeledItem)this.getOrNull0(n15);
        this.set0(n15, item);
        if (old != null) {
            this.removeLabel(old.getLabel());
        }
        if (item != null) {
            this.addLabelIndex(item.getLabel(), n15);
        }
    }
}

