/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.util.IntList;
import java.util.BitSet;

public class IdenticalBlockCombiner {
    private final RopMethod ropMethod;
    private final BasicBlockList blocks;
    private final BasicBlockList newBlocks;

    public IdenticalBlockCombiner(RopMethod rm4) {
        this.ropMethod = rm4;
        this.blocks = this.ropMethod.getBlocks();
        this.newBlocks = this.blocks.getMutableCopy();
    }

    public RopMethod process() {
        int szBlocks = this.blocks.size();
        BitSet toDelete = new BitSet(this.blocks.getMaxLabel());
        for (int bindex = 0; bindex < szBlocks; ++bindex) {
            BasicBlock b15 = this.blocks.get(bindex);
            if (toDelete.get(b15.getLabel())) continue;
            IntList preds = this.ropMethod.labelToPredecessors(b15.getLabel());
            int szPreds = preds.size();
            for (int i15 = 0; i15 < szPreds; ++i15) {
                int iLabel = preds.get(i15);
                BasicBlock iBlock = this.blocks.labelToBlock(iLabel);
                if (toDelete.get(iLabel) || iBlock.getSuccessors().size() > 1 || iBlock.getFirstInsn().getOpcode().getOpcode() == 55) continue;
                IntList toCombine = new IntList();
                for (int j15 = i15 + 1; j15 < szPreds; ++j15) {
                    int jLabel = preds.get(j15);
                    BasicBlock jBlock = this.blocks.labelToBlock(jLabel);
                    if (jBlock.getSuccessors().size() != 1 || !IdenticalBlockCombiner.compareInsns(iBlock, jBlock)) continue;
                    toCombine.add(jLabel);
                    toDelete.set(jLabel);
                }
                this.combineBlocks(iLabel, toCombine);
            }
        }
        for (int i16 = szBlocks - 1; i16 >= 0; --i16) {
            if (!toDelete.get(this.newBlocks.get(i16).getLabel())) continue;
            this.newBlocks.set(i16, null);
        }
        this.newBlocks.shrinkToFit();
        this.newBlocks.setImmutable();
        return new RopMethod(this.newBlocks, this.ropMethod.getFirstLabel());
    }

    private static boolean compareInsns(BasicBlock a15, BasicBlock b15) {
        return a15.getInsns().contentEquals(b15.getInsns());
    }

    private void combineBlocks(int alphaLabel, IntList betaLabels) {
        int szBetas = betaLabels.size();
        for (int i15 = 0; i15 < szBetas; ++i15) {
            int betaLabel = betaLabels.get(i15);
            BasicBlock bb5 = this.blocks.labelToBlock(betaLabel);
            IntList preds = this.ropMethod.labelToPredecessors(bb5.getLabel());
            int szPreds = preds.size();
            for (int j15 = 0; j15 < szPreds; ++j15) {
                BasicBlock predBlock = this.newBlocks.labelToBlock(preds.get(j15));
                this.replaceSucc(predBlock, betaLabel, alphaLabel);
            }
        }
    }

    private void replaceSucc(BasicBlock block, int oldLabel, int newLabel) {
        IntList newSuccessors = block.getSuccessors().mutableCopy();
        newSuccessors.set(newSuccessors.indexOf(oldLabel), newLabel);
        int newPrimarySuccessor = block.getPrimarySuccessor();
        if (newPrimarySuccessor == oldLabel) {
            newPrimarySuccessor = newLabel;
        }
        newSuccessors.setImmutable();
        BasicBlock newBB = new BasicBlock(block.getLabel(), block.getInsns(), newSuccessors, newPrimarySuccessor);
        this.newBlocks.set(this.newBlocks.indexOfLabel(block.getLabel()), newBB);
    }
}

