
use builtin;
use str;

set edit:completion:arg-completer[delta] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'delta'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'delta'= {
            cand --blame-code-style 'Style string for the code section of a git blame line'
            cand --blame-format 'Format string for git blame commit metadata'
            cand --blame-palette 'Background colors used for git blame lines (space-separated string)'
            cand --blame-separator-format 'Separator between the blame format and the code section of a git blame line'
            cand --blame-separator-style 'Style string for the blame-separator-format'
            cand --blame-timestamp-format 'Format of `git blame` timestamp in raw git output received by delta'
            cand --blame-timestamp-output-format 'Format string for git blame timestamp output'
            cand --config 'Load the config file at PATH instead of ~/.gitconfig'
            cand --commit-decoration-style 'Style string for the commit hash decoration'
            cand --commit-regex 'Regular expression used to identify the commit line when parsing git output'
            cand --commit-style 'Style string for the commit hash line'
            cand --default-language 'Default language used for syntax highlighting'
            cand --detect-dark-light 'Detect whether or not the terminal is dark or light by querying for its colors'
            cand -@ 'Extra arguments to pass to `git diff` when using delta to diff two files'
            cand --diff-args 'Extra arguments to pass to `git diff` when using delta to diff two files'
            cand --diff-stat-align-width 'Width allocated for file paths in a diff stat section'
            cand --features 'Names of delta features to activate (space-separated)'
            cand --file-added-label 'Text to display before an added file path'
            cand --file-copied-label 'Text to display before a copied file path'
            cand --file-decoration-style 'Style string for the file decoration'
            cand --file-modified-label 'Text to display before a modified file path'
            cand --file-removed-label 'Text to display before a removed file path'
            cand --file-renamed-label 'Text to display before a renamed file path'
            cand --file-style 'Style string for the file section'
            cand --file-transformation 'Sed-style command transforming file paths for display'
            cand --generate-completion 'Print completion file for the given shell'
            cand --grep-context-line-style 'Style string for non-matching lines of grep output'
            cand --grep-file-style 'Style string for file paths in grep output'
            cand --grep-header-decoration-style 'Style string for the header decoration in grep output'
            cand --grep-header-file-style 'Style string for the file path part of the header in grep output'
            cand --grep-line-number-style 'Style string for line numbers in grep output'
            cand --grep-output-type 'Grep output format. Possible values: "ripgrep" - file name printed once, followed by matching lines within that file, each preceded by a line number. "classic" - file name:line number, followed by matching line. Default is "ripgrep" if `rg --json` format is detected, otherwise "classic"'
            cand --grep-match-line-style 'Style string for matching lines of grep output'
            cand --grep-match-word-style 'Style string for the matching substrings within a matching line of grep output'
            cand --grep-separator-symbol 'Separator symbol printed after the file path and line number in grep output'
            cand --hunk-header-decoration-style 'Style string for the hunk-header decoration'
            cand --hunk-header-file-style 'Style string for the file path part of the hunk-header'
            cand --hunk-header-line-number-style 'Style string for the line number part of the hunk-header'
            cand --hunk-header-style 'Style string for the hunk-header'
            cand --hunk-label 'Text to display before a hunk header'
            cand --hyperlinks-commit-link-format 'Format string for commit hyperlinks (requires --hyperlinks)'
            cand --hyperlinks-file-link-format 'Format string for file hyperlinks (requires --hyperlinks)'
            cand --inline-hint-style 'Style string for short inline hint text'
            cand --inspect-raw-lines 'Kill-switch for --color-moved support'
            cand --line-buffer-size 'Size of internal line buffer'
            cand --line-fill-method 'Line-fill method in side-by-side mode'
            cand --line-numbers-left-format 'Format string for the left column of line numbers'
            cand --line-numbers-left-style 'Style string for the left column of line numbers'
            cand --line-numbers-minus-style 'Style string for line numbers in the old (minus) version of the file'
            cand --line-numbers-plus-style 'Style string for line numbers in the new (plus) version of the file'
            cand --line-numbers-right-format 'Format string for the right column of line numbers'
            cand --line-numbers-right-style 'Style string for the right column of line numbers'
            cand --line-numbers-zero-style 'Style string for line numbers in unchanged (zero) lines'
            cand --map-styles 'Map styles encountered in raw input to desired output styles'
            cand --max-line-distance 'Maximum line pair distance parameter in within-line diff algorithm'
            cand --max-syntax-highlighting-length 'Stop syntax highlighting lines after this many characters'
            cand --max-line-length 'Truncate lines longer than this'
            cand --merge-conflict-begin-symbol 'String marking the beginning of a merge conflict region'
            cand --merge-conflict-end-symbol 'String marking the end of a merge conflict region'
            cand --merge-conflict-ours-diff-header-decoration-style 'Style string for the decoration of the header above the ''ours'' merge conflict diff'
            cand --merge-conflict-ours-diff-header-style 'Style string for the header above the ''ours'' branch merge conflict diff'
            cand --merge-conflict-theirs-diff-header-decoration-style 'Style string for the decoration of the header above the ''theirs'' merge conflict diff'
            cand --merge-conflict-theirs-diff-header-style 'Style string for the header above the ''theirs'' branch merge conflict diff'
            cand --minus-empty-line-marker-style 'Style string for removed empty line marker'
            cand --minus-emph-style 'Style string for emphasized sections of removed lines'
            cand --minus-non-emph-style 'Style string for non-emphasized sections of removed lines that have an emphasized section'
            cand --minus-style 'Style string for removed lines'
            cand --navigate-regex 'Regular expression defining navigation stop points'
            cand --pager 'Which pager to use'
            cand --paging 'Whether to use a pager when displaying output'
            cand --plus-emph-style 'Style string for emphasized sections of added lines'
            cand --plus-empty-line-marker-style 'Style string for added empty line marker'
            cand --plus-non-emph-style 'Style string for non-emphasized sections of added lines that have an emphasized section'
            cand --plus-style 'Style string for added lines'
            cand --right-arrow 'Text to display with a changed file path'
            cand --syntax-theme 'The syntax-highlighting theme to use'
            cand --tabs 'The number of spaces to replace tab characters with'
            cand --true-color 'Whether to emit 24-bit ("true color") RGB color codes'
            cand --whitespace-error-style 'Style string for whitespace errors'
            cand -w 'The width of underline/overline decorations'
            cand --width 'The width of underline/overline decorations'
            cand --word-diff-regex 'Regular expression defining a ''word'' in within-line diff algorithm'
            cand --wrap-left-symbol 'End-of-line wrapped content symbol (left-aligned)'
            cand --wrap-max-lines 'How often a line should be wrapped if it does not fit'
            cand --wrap-right-percent 'Threshold for right-aligning wrapped content'
            cand --wrap-right-prefix-symbol 'Pre-wrapped content symbol (right-aligned)'
            cand --wrap-right-symbol 'End-of-line wrapped content symbol (right-aligned)'
            cand --zero-style 'Style string for unchanged lines'
            cand --24-bit-color 'Deprecated: use --true-color'
            cand --color-only 'Do not alter the input structurally in any way'
            cand --dark 'Use default colors appropriate for a dark terminal background'
            cand --diff-highlight 'Emulate diff-highlight'
            cand --diff-so-fancy 'Emulate diff-so-fancy'
            cand --hyperlinks 'Render commit hashes, file names, and line numbers as hyperlinks'
            cand --keep-plus-minus-markers 'Prefix added/removed lines with a +/- character, as git does'
            cand --light 'Use default colors appropriate for a light terminal background'
            cand -n 'Display line numbers next to the diff'
            cand --line-numbers 'Display line numbers next to the diff'
            cand --list-languages 'List supported languages and associated file extensions'
            cand --list-syntax-themes 'List available syntax-highlighting color themes'
            cand --navigate 'Activate diff navigation'
            cand --no-gitconfig 'Do not read any settings from git config'
            cand --parse-ansi 'Display ANSI color escape sequences in human-readable form'
            cand --raw 'Do not alter the input in any way'
            cand --relative-paths 'Output all file paths relative to the current directory'
            cand --show-colors 'Show available named colors'
            cand --show-config 'Display the active values for all Delta options'
            cand --show-syntax-themes 'Show example diff for available syntax-highlighting themes'
            cand --show-themes 'Show example diff for available delta themes'
            cand -s 'Display diffs in side-by-side layout'
            cand --side-by-side 'Display diffs in side-by-side layout'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
    ]
    $completions[$command]
}
