/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.squashfs.SquashConstants;
import ghidra.file.formats.squashfs.SquashFileSystem;
import ghidra.file.formats.squashfs.SquashUtils;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class SquashFileSystemFactory
implements GFileSystemFactoryByteProvider<SquashFileSystem>,
GFileSystemProbeBytesOnly {
    public static final int PROBE_BYTES_REQUIRED = SquashConstants.MAGIC.length;

    public SquashFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        SquashFileSystem fs = new SquashFileSystem(targetFSRL, fsService);
        try {
            fs.mount(byteProvider, monitor);
            return fs;
        }
        catch (IOException e) {
            FSUtilities.uncheckedClose((AutoCloseable)((Object)fs), null);
            throw e;
        }
    }

    public int getBytesRequired() {
        return PROBE_BYTES_REQUIRED;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return SquashUtils.isSquashFS(startBytes);
    }
}

