/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.data.LEB128;
import java.io.IOException;

class DebugInfoStateMachineReader {
    private static final int MAX_SIZE = 65536;

    DebugInfoStateMachineReader() {
    }

    static int computeLength(BinaryReader reader) throws IOException {
        long start = reader.getPointerIndex();
        while (reader.getPointerIndex() - start < 65536L) {
            byte opcode = reader.readNextByte();
            switch (opcode) {
                case 0: {
                    return (int)(reader.getPointerIndex() - start);
                }
                case 1: {
                    reader.readNext(LEB128::unsigned);
                    break;
                }
                case 2: {
                    reader.readNext(LEB128::unsigned);
                    break;
                }
                case 3: {
                    int register = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int name = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int type = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case 4: {
                    int register = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int name = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int type = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int signature = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case 5: {
                    int register = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case 6: {
                    int register = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    int name = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
            }
        }
        return 0;
    }
}

