/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Spliterator;
import java.util.function.Consumer;

public class MergeSortingSpliterator<T>
implements Spliterator<T> {
    private final Comparator<? super T> comparator;
    private final PriorityQueue<SpliteratorEntry<T>> queue;

    public MergeSortingSpliterator(Iterable<? extends Spliterator<? extends T>> spliterators, Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.queue = new PriorityQueue<SpliteratorEntry>(Comparator.comparing(se -> se.next, comparator));
        for (Spliterator<T> spliterator : spliterators) {
            SpliteratorEntry<T> se2 = new SpliteratorEntry<T>(spliterator);
            if (!se2.hasNext) continue;
            this.queue.add(se2);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        SpliteratorEntry<T> se = this.queue.poll();
        if (se == null) {
            return false;
        }
        Object next = se.next;
        if (se.tryNext()) {
            this.queue.add(se);
        }
        action.accept(next);
        return true;
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.queue.stream().mapToLong(se -> se.spliterator.estimateSize()).sum() + (long)this.queue.size();
    }

    @Override
    public int characteristics() {
        return 20;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    static class SpliteratorEntry<T> {
        final Spliterator<? extends T> spliterator;
        T next;
        boolean hasNext;

        SpliteratorEntry(Spliterator<? extends T> spliterator) {
            this.spliterator = spliterator;
            this.tryNext();
        }

        boolean tryNext() {
            this.hasNext = this.spliterator.tryAdvance(n -> {
                this.next = n;
            });
            return this.hasNext;
        }
    }
}

