/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.CursorPosition;

public class SearchLocation {
    private final int startIndexInclusive;
    private final int endIndexInclusive;
    private final String searchText;
    private final boolean forwardDirection;

    public SearchLocation(int startIndexInclusive, int endIndexInclusive, String searchText, boolean forwardDirection) {
        this.startIndexInclusive = startIndexInclusive;
        this.endIndexInclusive = endIndexInclusive;
        this.searchText = searchText;
        this.forwardDirection = forwardDirection;
    }

    public CursorPosition getCursorPosition() {
        return new CursorPosition(this.startIndexInclusive);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public int getEndIndexInclusive() {
        return this.endIndexInclusive;
    }

    public int getStartIndexInclusive() {
        return this.startIndexInclusive;
    }

    public int getMatchLength() {
        return this.endIndexInclusive - this.startIndexInclusive + 1;
    }

    public boolean isForwardDirection() {
        return this.forwardDirection;
    }

    public String toString() {
        return this.searchText + "[" + this.fieldsToString() + "]";
    }

    protected String fieldsToString() {
        return this.startIndexInclusive + ", end=" + this.endIndexInclusive;
    }
}

