/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingDialog;
import docking.DockingKeyBindingAction;
import docking.DockingWindowManager;
import docking.ExecutableAction;
import docking.KeyBindingPrecedence;
import docking.MultiActionDialog;
import docking.Tool;
import docking.action.ComponentBasedDockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.actions.KeyBindingUtils;
import generic.util.WindowUtilities;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.help.UnsupportedOperationException;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;

public class MultipleKeyAction
extends DockingKeyBindingAction {
    private List<ActionData> actions = new ArrayList<ActionData>();

    public MultipleKeyAction(Tool tool, ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        super(tool, action, keyStroke);
        this.addAction(provider, action);
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void addAction(ComponentProvider provider, DockingActionIf action) {
        for (ActionData actionData : this.actions) {
            if (!actionData.action.equals(action)) continue;
            return;
        }
        KeyStroke keyBinding = action.getKeyBinding();
        if (!this.keyStroke.equals(keyBinding)) {
            throw new IllegalArgumentException("KeyStrokes don't match - was: " + String.valueOf(this.keyStroke) + " new: " + String.valueOf(keyBinding));
        }
        this.actions.add(new ActionData(this, action, provider));
    }

    public void removeAction(DockingActionIf action) {
        Iterator<ActionData> iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            ActionData actionData = iterator.next();
            if (actionData.action != action) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void setEnabled(boolean newValue) {
        if (newValue != this.enabled) {
            boolean oldValue = this.enabled;
            this.enabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        throw new UnsupportedOperationException();
    }

    private boolean ignoreActionWhileMenuShowing(ExecutableAction action) {
        KeyBindingPrecedence precedence = action.getKeyBindingPrecedence();
        if (precedence == KeyBindingPrecedence.SystemActionsLevel) {
            return false;
        }
        MenuSelectionManager menuManager = MenuSelectionManager.defaultManager();
        return menuManager.getSelectedPath().length != 0;
    }

    private ExecutableAction createNonDialogExecutableAction(ActionContext localContext, Map<Class<? extends ActionContext>, ActionContext> contextMap) {
        MultiExecutableAction multiAction = new MultiExecutableAction();
        this.getLocalContextActions(localContext, multiAction);
        if (multiAction.isValid()) {
            return multiAction;
        }
        this.getLocalComponentActions(localContext, multiAction);
        if (multiAction.isValid()) {
            return multiAction;
        }
        this.getGlobalActions(localContext, multiAction);
        if (multiAction.isValid()) {
            return multiAction;
        }
        this.getGlobalDefaultContextActions(contextMap, multiAction);
        return multiAction;
    }

    private void getLocalContextActions(ActionContext localContext, MultiExecutableAction multiAction) {
        for (ActionData actionData : this.actions) {
            if (!actionData.isMyProvider(localContext) || !this.isValid(actionData, localContext)) continue;
            multiAction.setLocal(true);
            multiAction.setContext(localContext);
            multiAction.addValidAction(actionData.action);
            if (!this.isEnabled(actionData, localContext)) continue;
            multiAction.addEnabledAction(actionData.action);
        }
    }

    private void getLocalComponentActions(ActionContext localContext, MultiExecutableAction multiAction) {
        for (ActionData actionData : this.actions) {
            ComponentBasedDockingAction componentAction;
            DockingActionIf dockingActionIf = actionData.action;
            if (!(dockingActionIf instanceof ComponentBasedDockingAction) || !(componentAction = (ComponentBasedDockingAction)dockingActionIf).isValidComponentContext(localContext)) continue;
            multiAction.setContext(localContext);
            multiAction.addValidAction(actionData.action);
            if (!this.isEnabled(actionData, localContext)) continue;
            multiAction.addEnabledAction(actionData.action);
        }
    }

    private void getGlobalActions(ActionContext localContext, MultiExecutableAction multiAction) {
        for (ActionData actionData : this.actions) {
            if (!actionData.isGlobalAction() || !this.isValid(actionData, localContext)) continue;
            multiAction.setContext(localContext);
            multiAction.addValidAction(actionData.action);
            if (!this.isEnabled(actionData, localContext)) continue;
            multiAction.addEnabledAction(actionData.action);
        }
    }

    private void getGlobalDefaultContextActions(Map<Class<? extends ActionContext>, ActionContext> contextMap, MultiExecutableAction multiAction) {
        for (ActionData actionData : this.actions) {
            ActionContext defaultContext;
            if (!actionData.isGlobalAction() || !actionData.supportsDefaultContext() || !this.isValid(actionData, defaultContext = contextMap.get(actionData.getContextType()))) continue;
            multiAction.setContext(defaultContext);
            multiAction.addValidAction(actionData.action);
            if (!this.isEnabled(actionData, defaultContext)) continue;
            multiAction.addEnabledAction(actionData.action);
        }
    }

    private boolean isValid(ActionData actionData, ActionContext context) {
        if (context == null) {
            return false;
        }
        DockingActionIf a = actionData.action;
        return a.isValidContext(context);
    }

    private boolean isEnabled(ActionData actionData, ActionContext context) {
        if (context == null) {
            return false;
        }
        DockingActionIf a = actionData.action;
        return a.isEnabledForContext(context);
    }

    @Override
    public boolean isSystemKeybindingPrecedence() {
        return false;
    }

    @Override
    public ExecutableAction getExecutableAction(Component source) {
        ExecutableAction action = this.createExecutableAction(source);
        if (this.ignoreActionWhileMenuShowing(action)) {
            return new MultiExecutableAction();
        }
        return action;
    }

    private ExecutableAction createExecutableAction(Object eventSource) {
        DockingWindowManager dwm = this.tool.getWindowManager();
        Window window = this.getWindow(dwm, eventSource);
        if (window instanceof DockingDialog) {
            return this.createDialogActions(eventSource, window);
        }
        ComponentProvider localProvider = this.getProvider(dwm, eventSource);
        ActionContext localContext = this.getLocalContext(localProvider);
        localContext.setSourceObject(eventSource);
        Map<Class<? extends ActionContext>, ActionContext> contextMap = dwm.getDefaultActionContextMap();
        return this.createNonDialogExecutableAction(localContext, contextMap);
    }

    private ExecutableAction createDialogActions(Object eventSource, Window window) {
        MultiExecutableAction multiAction = new MultiExecutableAction();
        DockingDialog dockingDialog = (DockingDialog)window;
        DialogComponentProvider provider = dockingDialog.getDialogComponent();
        if (provider == null) {
            return multiAction;
        }
        ActionContext context = provider.getActionContext(null);
        if (context == null) {
            return multiAction;
        }
        this.getLocalComponentActions(context, multiAction);
        if (multiAction.isValid()) {
            return multiAction;
        }
        this.getGlobalActions(context, multiAction);
        if (provider.isModal()) {
            multiAction.filterAndKeepOnlyDialogActions(provider);
        }
        return multiAction;
    }

    private ComponentProvider getProvider(DockingWindowManager dwm, Object eventSource) {
        if (eventSource instanceof Component) {
            return dwm.getProvider((Component)eventSource);
        }
        return dwm.getActiveComponentProvider();
    }

    private Window getWindow(DockingWindowManager dwm, Object eventSource) {
        if (eventSource instanceof Component) {
            return WindowUtilities.windowForComponent((Component)((Component)eventSource));
        }
        return dwm.getActiveWindow();
    }

    @Override
    public List<DockingActionIf> getActions() {
        ArrayList<DockingActionIf> list = new ArrayList<DockingActionIf>(this.actions.size());
        for (ActionData actionData : this.actions) {
            list.add(actionData.action);
        }
        return list;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [\n\t" + this.getKeyBindingsAsString() + "\n]";
    }

    private String getKeyBindingsAsString() {
        StringBuilder buildy = new StringBuilder();
        for (ActionData data : this.actions) {
            buildy.append(data.action.toString()).append("\n\t");
        }
        if (this.actions.size() > 0) {
            buildy.delete(buildy.length() - 2, buildy.length());
        }
        return buildy.toString();
    }

    private class ActionData {
        DockingActionIf action;
        ComponentProvider provider;

        ActionData(MultipleKeyAction multipleKeyAction, DockingActionIf action, ComponentProvider provider) {
            this.action = action;
            this.provider = provider;
        }

        public Class<? extends ActionContext> getContextType() {
            return this.action.getContextClass();
        }

        public boolean supportsDefaultContext() {
            return this.action.supportsDefaultContext();
        }

        boolean isGlobalAction() {
            return this.provider == null;
        }

        boolean isMyProvider(ActionContext localContext) {
            if (this.provider == null) {
                return false;
            }
            ComponentProvider otherProvider = localContext.getComponentProvider();
            return this.provider == otherProvider;
        }

        public String toString() {
            String providerString = this.provider == null ? "" : this.provider.toString() + " - ";
            return providerString + String.valueOf(this.action);
        }
    }

    private class MultiExecutableAction
    implements ExecutableAction {
        private List<DockingActionIf> validActions = new ArrayList<DockingActionIf>();
        private List<DockingActionIf> enabledActions = new ArrayList<DockingActionIf>();
        private ActionContext context;
        private boolean isLocalAction;

        private MultiExecutableAction() {
        }

        @Override
        public void execute() {
            if (this.enabledActions.size() == 1) {
                DockingActionIf action = this.enabledActions.get(0);
                MultipleKeyAction.this.tool.setStatusInfo("");
                if (action instanceof ToggleDockingActionIf) {
                    ToggleDockingActionIf toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                }
                action.actionPerformed(this.context);
                return;
            }
            MultiActionDialog dialog = new MultiActionDialog(KeyBindingUtils.parseKeyStroke(MultipleKeyAction.this.keyStroke), this.enabledActions, this.context);
            Swing.runLater(() -> DockingWindowManager.showDialog(dialog));
        }

        @Override
        public KeyBindingPrecedence getKeyBindingPrecedence() {
            KeyBindingPrecedence precedence = KeyBindingPrecedence.DefaultLevel;
            if (this.enabledActions.size() == 1) {
                DockingActionIf action = this.enabledActions.get(0);
                precedence = action.getKeyBindingData().getKeyBindingPrecedence();
            }
            return precedence;
        }

        @Override
        public boolean isValid() {
            return !this.validActions.isEmpty();
        }

        @Override
        public boolean isEnabled() {
            return !this.enabledActions.isEmpty();
        }

        void setLocal(boolean isLocal) {
            this.isLocalAction = isLocal;
        }

        void setContext(ActionContext context) {
            if (this.context != null && this.context != context) {
                throw new IllegalArgumentException("Context cannot be changed once set");
            }
            this.context = context;
        }

        void addValidAction(DockingActionIf a) {
            this.validActions.add(a);
        }

        void addEnabledAction(DockingActionIf a) {
            this.enabledActions.add(a);
        }

        void filterAndKeepOnlyDialogActions(DialogComponentProvider provider) {
            Iterator<DockingActionIf> it = this.validActions.iterator();
            while (it.hasNext()) {
                DockingActionIf action = it.next();
                if (provider.isDialogKeyBindingAction(action)) continue;
                it.remove();
                this.enabledActions.remove(action);
            }
        }

        private String getContextText(Component focusOwner) {
            DockingWindowManager dwm = MultipleKeyAction.this.tool.getWindowManager();
            Window window = MultipleKeyAction.this.getWindow(dwm, focusOwner);
            if (window instanceof DockingDialog) {
                return "in this dialog";
            }
            if (!this.isLocalAction) {
                return null;
            }
            ComponentProvider provider = this.context.getComponentProvider();
            if (provider != null) {
                return "in " + provider.getName();
            }
            return "for context";
        }

        @Override
        public void reportNotEnabled(Component focusOwner) {
            String contextText = this.getContextText(focusOwner);
            if (contextText == null) {
                return;
            }
            DockingActionIf action = this.validActions.get(0);
            String actionName = action.getName();
            String ksText = KeyBindingUtils.parseKeyStroke(MultipleKeyAction.this.keyStroke);
            String message = "'%s' (%s) not currently enabled %s".formatted(actionName, ksText, contextText);
            MultipleKeyAction.this.tool.setStatusInfo(message, true);
            Toolkit.getDefaultToolkit().beep();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.validActions);
        }
    }
}

