/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.emulate.callother.OpBehaviorOtherNOP;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.util.Stack;

public class XtensaEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    private Stack<RegisterStash> stashStack = new Stack();

    public XtensaEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.registerPcodeOpBehavior("rotateRegWindow", new RotateRegWindow());
        this.registerPcodeOpBehavior("restoreRegWindow", new RestoreRegWindow());
        this.registerPcodeOpBehavior("swap4", (OpBehaviorOther)new OpBehaviorOtherNOP());
        this.registerPcodeOpBehavior("swap8", (OpBehaviorOther)new OpBehaviorOtherNOP());
        this.registerPcodeOpBehavior("swap12", (OpBehaviorOther)new OpBehaviorOtherNOP());
        this.registerPcodeOpBehavior("restore4", (OpBehaviorOther)new OpBehaviorOtherNOP());
        this.registerPcodeOpBehavior("restore8", (OpBehaviorOther)new OpBehaviorOtherNOP());
        this.registerPcodeOpBehavior("restore12", (OpBehaviorOther)new OpBehaviorOtherNOP());
    }

    private class RotateRegWindow
    implements OpBehaviorOther {
        private RotateRegWindow() {
        }

        public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
            Varnode in;
            if (inputs.length != 1) {
                throw new LowlevelError("rotateRegWindow: missing required CALLINC input");
            }
            MemoryState memoryState = emu.getMemoryState();
            long callinc = memoryState.getValue(in = inputs[0]);
            if (callinc == 0L) {
                return;
            }
            if (callinc < 0L || callinc > 3L) {
                throw new LowlevelError("rotateRegWindow: invalid value for CALLINC (0x" + Long.toHexString(callinc) + ")");
            }
            XtensaEmulateInstructionStateModifier.this.stashStack.push(new RegisterStash((int)callinc));
            Address baseARegAddr = XtensaEmulateInstructionStateModifier.this.language.getRegister("a0").getAddress();
            int count = (int)callinc << 2;
            long windowRegOffset = count * 4;
            count = 16 - count;
            for (int i = 0; i < count; ++i) {
                Varnode fromRegVarnode = new Varnode(baseARegAddr.add(windowRegOffset + (long)(i * 4)), 4);
                Varnode toRegVarnode = new Varnode(baseARegAddr.add((long)(i * 4)), 4);
                long value = memoryState.getValue(fromRegVarnode);
                memoryState.setValue(toRegVarnode, value);
            }
        }
    }

    private class RestoreRegWindow
    implements OpBehaviorOther {
        private RestoreRegWindow() {
        }

        public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
            Register a0Reg;
            if (inputs.length != 0) {
                throw new LowlevelError("restoreRegWindow: unexpected input varnodes");
            }
            MemoryState memoryState = emu.getMemoryState();
            long callinc = memoryState.getValue(a0Reg = XtensaEmulateInstructionStateModifier.this.language.getRegister("a0")) >> 30 & 3L;
            if (callinc == 0L) {
                return;
            }
            if (XtensaEmulateInstructionStateModifier.this.stashStack.isEmpty()) {
                throw new LowlevelError("restoreRegWindow: window register stash is empty");
            }
            RegisterStash stash = XtensaEmulateInstructionStateModifier.this.stashStack.peek();
            if (callinc != (long)stash.callinc) {
                throw new LowlevelError("restoreRegWindow: return address CALLINC (" + callinc + ") does not match last entry CALLINC value (" + stash.callinc + ")");
            }
            Address baseARegAddr = XtensaEmulateInstructionStateModifier.this.language.getRegister("a0").getAddress();
            int count = (int)callinc << 2;
            long windowRegOffset = count * 4;
            count = 16 - count;
            for (int i = 0; i < count; ++i) {
                Varnode fromRegVarnode = new Varnode(baseARegAddr.add((long)(i * 4)), 4);
                Varnode toRegVarnode = new Varnode(baseARegAddr.add(windowRegOffset + (long)(i * 4)), 4);
                long value = memoryState.getValue(fromRegVarnode);
                memoryState.setValue(toRegVarnode, value);
            }
            XtensaEmulateInstructionStateModifier.this.stashStack.pop();
            stash.restore();
        }
    }

    private class RegisterStash {
        private int callinc;
        private int[] values;

        RegisterStash(int callinc) {
            this.callinc = callinc;
            MemoryState memoryState = XtensaEmulateInstructionStateModifier.this.emu.getMemoryState();
            Address baseARegAddr = XtensaEmulateInstructionStateModifier.this.language.getRegister("a0").getAddress();
            int count = callinc << 2;
            this.values = new int[count];
            for (int i = 0; i < count; ++i) {
                Varnode regVarnode = new Varnode(baseARegAddr.add((long)(4 * i)), 4);
                this.values[i] = (int)memoryState.getValue(regVarnode);
            }
        }

        public void restore() {
            MemoryState memoryState = XtensaEmulateInstructionStateModifier.this.emu.getMemoryState();
            Address baseARegAddr = XtensaEmulateInstructionStateModifier.this.language.getRegister("a0").getAddress();
            for (int i = 0; i < this.values.length; ++i) {
                Varnode regVarnode = new Varnode(baseARegAddr.add((long)(4 * i)), 4);
                memoryState.setValue(regVarnode, (long)this.values[i]);
            }
        }
    }
}

