/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.main.ProgramaticUseOnly;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Content;
import org.jdom.Element;

public abstract class PluginsConfiguration {
    private Map<PluginPackage, List<PluginDescription>> descriptionsByPackage = new HashMap<PluginPackage, List<PluginDescription>>();
    private Map<String, PluginDescription> descriptionsByName = new HashMap<String, PluginDescription>();

    protected PluginsConfiguration() {
        this.populatePluginDescriptionMaps();
    }

    protected abstract boolean accepts(Class<? extends Plugin> var1);

    private Predicate<Class<? extends Plugin>> createFilter() {
        Predicate<Class> ignore = ProgramaticUseOnly.class::isAssignableFrom;
        return Predicate.not(ignore).and(c -> this.accepts((Class<? extends Plugin>)c));
    }

    private void populatePluginDescriptionMaps() {
        Predicate<Class<? extends Plugin>> classFilter = this.createFilter();
        List classes = ClassSearcher.getClasses(Plugin.class, classFilter);
        for (Class pluginClass : classes) {
            if (!this.isValidPluginClass(pluginClass)) {
                Msg.warn((Object)this, (Object)("Plugin does not have valid constructor! Skipping " + String.valueOf(pluginClass)));
                continue;
            }
            PluginDescription pd = PluginDescription.getPluginDescription(pluginClass);
            this.descriptionsByName.put(pluginClass.getName(), pd);
            PluginPackage pluginPackage = pd.getPluginPackage();
            List list = this.descriptionsByPackage.computeIfAbsent(pluginPackage, k -> new ArrayList());
            list.add(pd);
        }
    }

    private boolean isValidPluginClass(Class<? extends Plugin> pluginClass) {
        try {
            pluginClass.getConstructor(PluginTool.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public PluginDescription getPluginDescription(String className) {
        return this.descriptionsByName.get(className);
    }

    public void savePluginsToXml(Element root, List<Plugin> plugins) {
        Map<PluginPackage, List<Plugin>> pluginPackageMap = this.buildPluginPackageMap(plugins);
        for (PluginPackage pluginPackage : pluginPackageMap.keySet()) {
            root.addContent((Content)this.getPackageElement(pluginPackage, pluginPackageMap.get(pluginPackage)));
        }
    }

    private Element getPackageElement(PluginPackage pluginPackage, List<Plugin> pluginList) {
        String pluginClassName;
        Element packageElement = new Element("PACKAGE");
        packageElement.setAttribute("NAME", pluginPackage.getName());
        List<PluginDescription> pluginDescriptions = this.descriptionsByPackage.get(pluginPackage);
        HashSet<String> includedPluginClasses = new HashSet<String>();
        for (Plugin plugin : pluginList) {
            includedPluginClasses.add(plugin.getClass().getName());
        }
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (pluginDescription.getStatus() != PluginStatus.RELEASED || includedPluginClasses.contains(pluginClassName = pluginDescription.getPluginClass().getName())) continue;
            Element excludedPluginElement = new Element("EXCLUDE");
            excludedPluginElement.setAttribute("CLASS", pluginClassName);
            packageElement.addContent((Content)excludedPluginElement);
        }
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (pluginDescription.getStatus() == PluginStatus.RELEASED || !includedPluginClasses.contains(pluginClassName = pluginDescription.getPluginClass().getName())) continue;
            Element includedPluginElement = new Element("INCLUDE");
            includedPluginElement.setAttribute("CLASS", pluginClassName);
            packageElement.addContent((Content)includedPluginElement);
        }
        return packageElement;
    }

    private Map<PluginPackage, List<Plugin>> buildPluginPackageMap(List<Plugin> plugins) {
        HashMap<PluginPackage, List<Plugin>> pluginPackageMap = new HashMap<PluginPackage, List<Plugin>>();
        for (Plugin plugin : plugins) {
            PluginDescription pluginDescription = this.descriptionsByName.get(plugin.getClass().getName());
            if (pluginDescription == null) continue;
            PluginPackage pluginPackage = pluginDescription.getPluginPackage();
            ArrayList<Plugin> list = (ArrayList<Plugin>)pluginPackageMap.get(pluginPackage);
            if (list == null) {
                list = new ArrayList<Plugin>();
                pluginPackageMap.put(pluginPackage, list);
            }
            list.add(plugin);
        }
        return pluginPackageMap;
    }

    public Set<String> getPluginNamesByCurrentPackage(List<String> classNames) {
        HashSet<PluginPackage> packages = new HashSet<PluginPackage>();
        HashSet<String> adjustedClassNames = new HashSet<String>();
        for (String className : classNames) {
            PluginDescription pd = this.descriptionsByName.get(className);
            if (pd == null) continue;
            if (pd.getStatus() == PluginStatus.RELEASED) {
                packages.add(pd.getPluginPackage());
                continue;
            }
            adjustedClassNames.add(className);
        }
        for (PluginPackage pluginPackage : packages) {
            List<PluginDescription> packageDescriptions = this.descriptionsByPackage.get(pluginPackage);
            for (PluginDescription pd : packageDescriptions) {
                adjustedClassNames.add(pd.getPluginClass().getName());
            }
        }
        return adjustedClassNames;
    }

    public Set<String> getPluginClassNames(Element element) {
        HashSet<String> classNames = new HashSet<String>();
        List children = element.getChildren("PACKAGE");
        for (Object object : children) {
            Object obj2;
            Element child = (Element)object;
            String packageName = child.getAttributeValue("NAME");
            HashSet<String> excludedClasses = new HashSet<String>();
            List grandChildren = child.getChildren("EXCLUDE");
            for (Object obj2 : grandChildren) {
                Element grandChild = (Element)obj2;
                String excludedClassName = grandChild.getAttributeValue("CLASS");
                excludedClasses.add(excludedClassName);
            }
            HashSet<String> includedClasses = new HashSet<String>();
            grandChildren = child.getChildren("INCLUDE");
            obj2 = grandChildren.iterator();
            while (obj2.hasNext()) {
                Object obj3 = obj2.next();
                Element grandChild = (Element)obj3;
                String excludedClassName = grandChild.getAttributeValue("CLASS");
                includedClasses.add(excludedClassName);
            }
            if (!PluginPackage.exists(packageName)) {
                Msg.warn((Object)this, (Object)("Unable to find plugin package '" + packageName + "' while restoring plugins from xml"));
                continue;
            }
            PluginPackage pluginPackage = PluginPackage.getPluginPackage(packageName);
            List<PluginDescription> pluginDescriptionList = this.descriptionsByPackage.get(pluginPackage);
            if (pluginDescriptionList == null) continue;
            for (PluginDescription pluginDescription : pluginDescriptionList) {
                if (!this.shouldAddPlugin(pluginDescription, includedClasses, excludedClasses)) continue;
                classNames.add(pluginDescription.getPluginClass().getName());
            }
        }
        return classNames;
    }

    private boolean shouldAddPlugin(PluginDescription description, Set<String> include, Set<String> exclude) {
        String className = description.getPluginClass().getName();
        if (include.contains(className)) {
            return true;
        }
        if (exclude.contains(className)) {
            return false;
        }
        return description.getStatus() == PluginStatus.RELEASED;
    }

    public List<PluginPackage> getPluginPackages() {
        ArrayList<PluginPackage> list = new ArrayList<PluginPackage>(this.descriptionsByPackage.keySet());
        Collections.sort(list);
        return list;
    }

    public List<PluginDescription> getPluginDescriptions(PluginPackage pluginPackage) {
        ArrayList<PluginDescription> stableList = new ArrayList<PluginDescription>();
        List<PluginDescription> list = this.descriptionsByPackage.get(pluginPackage);
        if (list == null) {
            return stableList;
        }
        for (PluginDescription pluginDescription : list) {
            if (pluginDescription.getStatus() == PluginStatus.UNSTABLE || pluginDescription.getStatus() == PluginStatus.HIDDEN) continue;
            stableList.add(pluginDescription);
        }
        return stableList;
    }

    public List<PluginDescription> getUnstablePluginDescriptions() {
        ArrayList<PluginDescription> unstablePlugins = new ArrayList<PluginDescription>();
        for (PluginDescription pluginDescription : this.descriptionsByName.values()) {
            if (pluginDescription.getStatus() != PluginStatus.UNSTABLE) continue;
            unstablePlugins.add(pluginDescription);
        }
        return unstablePlugins;
    }

    public List<PluginDescription> getManagedPluginDescriptions() {
        ArrayList<PluginDescription> nonHiddenPlugins = new ArrayList<PluginDescription>();
        for (PluginDescription pluginDescription : this.descriptionsByName.values()) {
            if (pluginDescription.getStatus() == PluginStatus.HIDDEN) continue;
            nonHiddenPlugins.add(pluginDescription);
        }
        return nonHiddenPlugins;
    }
}

