/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;

public class OperandValue
extends PatternValue {
    private int index;
    private Constructor ct;

    public int hashCode() {
        int result = 0;
        result += this.index;
        result *= 31;
        return result += this.ct.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OperandValue)) {
            return false;
        }
        OperandValue that = (OperandValue)obj;
        if (this.index != that.index) {
            return false;
        }
        return this.ct.equals(that.ct);
    }

    public OperandValue() {
    }

    public OperandValue(int i, Constructor c) {
        this.index = i;
        this.ct = c;
    }

    public int getIndex() {
        return this.index;
    }

    public Constructor getConstructor() {
        return this.ct;
    }

    @Override
    public long minValue() {
        throw new SleighException("Operand used in pattern expression");
    }

    @Override
    public long maxValue() {
        throw new SleighException("Operand used in pattern expression");
    }

    @Override
    public long getValue(ParserWalker walker) throws MemoryAccessException {
        OperandSymbol sym = this.ct.getOperand(this.index);
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp == null) {
            TripleSymbol defSym = sym.getDefiningSymbol();
            if (defSym != null) {
                patexp = defSym.getPatternExpression();
            }
            if (patexp == null) {
                return 0L;
            }
        }
        ConstructState tempstate = new ConstructState(null);
        ParserWalker newwalker = new ParserWalker(walker.getParserContext());
        newwalker.setOutOfBandState(this.ct, this.index, tempstate, walker);
        long res = patexp.getValue(newwalker);
        return res;
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage lang) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_OPERAND_EXP);
        this.index = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_INDEX);
        int tabid = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_TABLE);
        int ctid = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_CT);
        SubtableSymbol sym = (SubtableSymbol)lang.getSymbolTable().findSymbol(tabid);
        this.ct = sym.getConstructor(ctid);
        decoder.closeElement(el);
    }

    @Override
    public String toString() {
        OperandSymbol sym = this.ct.getOperand(this.index);
        StringBuilder sb = new StringBuilder();
        sb.append("[opval:" + sym.getName());
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp != null) {
            sb.append(" exp ");
        } else {
            TripleSymbol defSym = sym.getDefiningSymbol();
            if (defSym != null) {
                sb.append(" sym ");
                patexp = defSym.getPatternExpression();
            } else {
                sb.append("]");
                return sb.toString();
            }
        }
        sb.append(patexp);
        sb.append("]");
        return sb.toString();
    }
}

