/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.util;

import io.sf.carte.util.SimpleWriter;

public class BufferSimpleWriter
implements SimpleWriter {
    private final StringBuilder buffer;

    public BufferSimpleWriter() {
        this.buffer = new StringBuilder(128);
    }

    public BufferSimpleWriter(int initialCapacity) {
        this.buffer = new StringBuilder(initialCapacity);
    }

    public BufferSimpleWriter(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public int length() {
        return this.buffer.length();
    }

    @Override
    public void newLine() {
        this.buffer.append('\n');
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void unwrite() {
        int len = this.buffer.length();
        if (len != 0) {
            this.buffer.setLength(len - 1);
        }
    }

    public void unwrite(int numChars) {
        int len = this.buffer.length() - numChars;
        if (len < 0) {
            len = 0;
        }
        this.buffer.setLength(len);
    }

    @Override
    public void write(CharSequence s) {
        this.buffer.append(s);
    }

    @Override
    public void write(char[] cbuf, int offset, int len) {
        this.buffer.append(cbuf, offset, len);
    }

    @Override
    public void write(char c) {
        this.buffer.append(c);
    }

    @Override
    public void write(int num) {
        this.buffer.append(num);
    }
}

