/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.IdentValue;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class FontFamilyManager
extends AbstractValueManager {
    protected static final ListValue DEFAULT_VALUE = FontFamilyManager.createDefaultValue();
    protected static final StringMap values = new StringMap();

    private static ListValue createDefaultValue() {
        ListValue def = new ListValue(',', 4);
        def.append(new StringValue("Arial"));
        def.append(new StringValue("Helvetica"));
        def.append(IdentValue.createConstant("sans-serif"));
        return def.createUnmodifiableView();
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 26;
    }

    @Override
    public String getPropertyName() {
        return "font-family";
    }

    @Override
    public Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lunit);
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
        }
        ListValue result = new ListValue();
        LexicalUnit lu = lunit;
        do {
            switch (lu.getLexicalUnitType()) {
                case STRING: {
                    result.append(new StringValue(lu.getStringValue()));
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case IDENT: {
                    StringBuilder sb = new StringBuilder(lu.getStringValue());
                    lu = lu.getNextLexicalUnit();
                    if (lu != null && this.isIdentOrNumber(lu)) {
                        do {
                            sb.append(' ');
                            switch (lu.getLexicalUnitType()) {
                                case IDENT: {
                                    sb.append(lu.getStringValue());
                                    break;
                                }
                                case INTEGER: {
                                    sb.append(Integer.toString(lu.getIntegerValue()));
                                }
                            }
                        } while ((lu = lu.getNextLexicalUnit()) != null && this.isIdentOrNumber(lu));
                        result.append(new StringValue(sb.toString()));
                        break;
                    }
                    String id = sb.toString();
                    String s = id.toLowerCase(Locale.ROOT).intern();
                    Value v = (Value)values.get(s);
                    result.append(v != null ? v : new StringValue(id));
                    break;
                }
                case VAR: 
                case ATTR: {
                    return this.createLexicalValue(lunit);
                }
            }
            if (lu == null) {
                return result;
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                return this.createLexicalValue(lunit);
            }
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        } while ((lu = lu.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    private boolean isIdentOrNumber(LexicalUnit lu) {
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        return type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.INTEGER;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value == DEFAULT_VALUE) {
            CSSContext ctx = engine.getCSSContext();
            value = ctx.getDefaultFontFamily();
        }
        return value;
    }

    static {
        values.put("cursive", ValueConstants.CURSIVE_VALUE);
        values.put("fantasy", ValueConstants.FANTASY_VALUE);
        values.put("monospace", ValueConstants.MONOSPACE_VALUE);
        values.put("serif", ValueConstants.SERIF_VALUE);
        values.put("sans-serif", ValueConstants.SANS_SERIF_VALUE);
    }
}

