/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSLexicalValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.AttrUtil;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class LexicalValue
extends ProxyValue
implements CSSLexicalValue {
    private static final long serialVersionUID = 1L;
    private LexicalUnit lexicalUnit;

    public LexicalValue() {
        super(CSSValue.Type.LEXICAL);
    }

    protected LexicalValue(LexicalValue copied) {
        super(copied);
        this.lexicalUnit = copied.lexicalUnit.clone();
    }

    @Override
    public LexicalUnit getLexicalUnit() {
        return this.lexicalUnit;
    }

    public void setLexicalUnit(LexicalUnit lexicalUnit) {
        this.lexicalUnit = lexicalUnit;
    }

    @Override
    public CSSValue.Type getFinalType() {
        CSSValue.Type type;
        LexicalUnit nlu = this.lexicalUnit.getNextLexicalUnit();
        if (nlu != null) {
            if (nlu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH && this.isRatioCompUnit(this.lexicalUnit.getLexicalUnitType()) && (nlu = nlu.getNextLexicalUnit()) != null && this.isRatioCompUnit(nlu.getLexicalUnitType())) {
                return CSSValue.Type.RATIO;
            }
            return CSSValue.Type.UNKNOWN;
        }
        switch (this.lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                type = CSSValue.Type.IDENT;
                break;
            }
            case ATTR: {
                type = AttrUtil.finalAttrType(this.lexicalUnit);
                break;
            }
            case STRING: {
                type = CSSValue.Type.STRING;
                break;
            }
            case URI: {
                type = CSSValue.Type.URI;
                break;
            }
            case SRC: {
                type = CSSValue.Type.SRC;
                break;
            }
            case DIMENSION: 
            case PERCENTAGE: 
            case REAL: 
            case INTEGER: {
                type = CSSValue.Type.NUMERIC;
                break;
            }
            case RGBCOLOR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: {
                type = CSSValue.Type.COLOR;
                break;
            }
            case CALC: {
                type = CSSValue.Type.EXPRESSION;
                break;
            }
            case FUNCTION: {
                String func = this.lexicalUnit.getFunctionName().toLowerCase(Locale.ROOT);
                if (func.endsWith("linear-gradient") || func.endsWith("radial-gradient") || func.endsWith("conic-gradient")) {
                    type = CSSValue.Type.GRADIENT;
                    break;
                }
                if ("env".equals(func)) {
                    type = CSSValue.Type.ENV;
                    break;
                }
                type = CSSValue.Type.FUNCTION;
                break;
            }
            case MATH_FUNCTION: {
                type = CSSValue.Type.MATH_FUNCTION;
                break;
            }
            case COLOR_MIX: {
                type = CSSValue.Type.COLOR_MIX;
                break;
            }
            case CUBIC_BEZIER_FUNCTION: {
                type = CSSValue.Type.CUBIC_BEZIER;
                break;
            }
            case STEPS_FUNCTION: {
                type = CSSValue.Type.STEPS;
                break;
            }
            case UNICODE_RANGE: {
                type = CSSValue.Type.UNICODE_RANGE;
                break;
            }
            case UNICODE_WILDCARD: {
                type = CSSValue.Type.UNICODE_WILDCARD;
                break;
            }
            case RECT_FUNCTION: {
                type = CSSValue.Type.RECT;
                break;
            }
            case COUNTER_FUNCTION: {
                type = CSSValue.Type.COUNTER;
                break;
            }
            case COUNTERS_FUNCTION: {
                type = CSSValue.Type.COUNTERS;
                break;
            }
            case ELEMENT_REFERENCE: {
                type = CSSValue.Type.ELEMENT_REFERENCE;
                break;
            }
            default: {
                type = CSSValue.Type.UNKNOWN;
            }
        }
        return type;
    }

    private boolean isRatioCompUnit(LexicalUnit.LexicalType lutype) {
        return lutype == LexicalUnit.LexicalType.INTEGER || lutype == LexicalUnit.LexicalType.REAL || lutype == LexicalUnit.LexicalType.CALC || lutype == LexicalUnit.LexicalType.FUNCTION;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        return this.lexicalUnit.matches(syntax);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        CSSValueSyntax synComp = syntax.shallowClone();
        return this.lexicalUnit.matches(synComp);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        CSSOMParser parser = new CSSOMParser();
        try {
            this.lexicalUnit = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (CSSException | IOException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public String getCssText() {
        return this.lexicalUnit.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getCssText());
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return LexicalValue.serializeMinifiedSequence(this.lexicalUnit);
    }

    public static String serializeMinifiedSequence(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getNextLexicalUnit() == null) {
            return LexicalValue.serializeMinified(lexicalUnit).toString();
        }
        StringBuilder buf = new StringBuilder(32);
        boolean needSpaces = false;
        for (LexicalUnit lu = lexicalUnit; lu != null; lu = lu.getNextLexicalUnit()) {
            switch (lu.getLexicalUnitType()) {
                case OPERATOR_EXP: 
                case OPERATOR_GE: 
                case OPERATOR_GT: 
                case OPERATOR_LE: 
                case OPERATOR_LT: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_SLASH: 
                case OPERATOR_TILDE: 
                case LEFT_BRACKET: 
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    needSpaces = false;
                    break;
                }
                case RIGHT_BRACKET: {
                    needSpaces = true;
                    break;
                }
                default: {
                    if (needSpaces) {
                        buf.append(' ');
                        break;
                    }
                    needSpaces = true;
                }
            }
            buf.append(LexicalValue.serializeMinified(lu));
        }
        return buf.toString();
    }

    private static CharSequence serializeMinified(LexicalUnit lexicalUnit) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case RGBCOLOR: {
                String cssText = lexicalUnit.getCssText();
                if (cssText.length() < 10) {
                    return cssText;
                }
            }
            case ATTR: 
            case SRC: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case CALC: 
            case FUNCTION: 
            case MATH_FUNCTION: 
            case COLOR_MIX: 
            case CUBIC_BEZIER_FUNCTION: 
            case STEPS_FUNCTION: 
            case RECT_FUNCTION: 
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: 
            case VAR: {
                StringBuilder buf = new StringBuilder();
                buf.append(lexicalUnit.getFunctionName()).append('(');
                LexicalUnit lu = lexicalUnit.getParameters();
                if (lu != null) {
                    buf.append(LexicalValue.serializeMinifiedSequence(lu));
                }
                buf.append(')');
                return buf;
            }
            case SUB_EXPRESSION: {
                StringBuilder buf = new StringBuilder();
                buf.append('(');
                LexicalUnit lu = lexicalUnit.getSubValues();
                if (lu != null) {
                    buf.append(LexicalValue.serializeMinifiedSequence(lu));
                }
                buf.append(')');
                return buf;
            }
            case URI: {
                LexicalUnit param = lexicalUnit.getParameters();
                if (param == null) break;
                CharSequence pserial = LexicalValue.serializeMinified(param);
                StringBuilder buf = new StringBuilder(pserial.length() + 5);
                buf.append("url(");
                buf.append(pserial);
                buf.append(')');
                return buf;
            }
        }
        return lexicalUnit.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LexicalValue other = (LexicalValue)obj;
        return this.getCssText().equals(other.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getCssText().hashCode();
        return result;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public LexicalValue clone() {
        return new LexicalValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LexicalValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalValue.this.lexicalUnit = lunit;
        }
    }
}

