/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.BooleanConditionFactory;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.MediaQueryFactory;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SupportsConditionFactory;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSMediaParseException;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.DeclarationPredicate;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SheetContext;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.parser.AbstractPageSelector;
import io.sf.carte.doc.style.css.parser.AnBExpression;
import io.sf.carte.doc.style.css.parser.CombinatorConditionImpl;
import io.sf.carte.doc.style.css.parser.ConditionalSelectorImpl;
import io.sf.carte.doc.style.css.parser.FunctionFactories;
import io.sf.carte.doc.style.css.parser.LangConditionImpl;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.LocatorImpl;
import io.sf.carte.doc.style.css.parser.MediaQueryDatabase;
import io.sf.carte.doc.style.css.parser.NSACMediaQueryFactory;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.PageSelectorListImpl;
import io.sf.carte.doc.style.css.parser.PageTypeSelector;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.PositionalConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoPageSelector;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorListImpl;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.parser.SyntaxUnitImpl;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler2;
import io.sf.carte.uparser.TokenHandler3;
import io.sf.carte.uparser.TokenProducer;
import io.sf.carte.util.agent.AgentUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class CSSParser
implements Parser,
Cloneable {
    private CSSHandler handler;
    private CSSErrorHandler errorHandler;
    private final EnumSet<Parser.Flag> parserFlags;
    private int streamSizeLimit = 0x6000000;

    public CSSParser() {
        this.parserFlags = EnumSet.noneOf(Parser.Flag.class);
        this.handler = null;
        this.errorHandler = null;
    }

    public CSSParser(EnumSet<Parser.Flag> parserFlags) {
        this.parserFlags = parserFlags;
    }

    protected CSSParser(CSSParser copyMe) {
        this.parserFlags = copyMe.parserFlags;
        this.handler = copyMe.handler;
        this.errorHandler = copyMe.errorHandler;
    }

    @Override
    public void setDocumentHandler(CSSHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setErrorHandler(CSSErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFlag(Parser.Flag flag) {
        this.parserFlags.add(flag);
    }

    @Override
    public void unsetFlag(Parser.Flag flag) {
        this.parserFlags.remove((Object)flag);
    }

    public void setStreamSizeLimit(int streamSizeLimit) {
        if (streamSizeLimit < 65536) {
            throw new IllegalArgumentException("Limit too low.");
        }
        this.streamSizeLimit = streamSizeLimit;
    }

    @Override
    public void parseStyleSheet(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        Parser.NamespaceMap nsMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            nsMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        SheetTokenHandler handler = new SheetTokenHandler(nsMap, true);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.setAcceptEofEndingQuoted(true);
        this.handler.parseStart(handler);
        tp.parse(reader, "/*", "*/");
    }

    @Override
    public void parseStyleSheet(String uri) throws CSSParseException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        URL url = new URL(uri);
        URLConnection ucon = url.openConnection();
        ucon.setConnectTimeout(15000);
        ucon.connect();
        InputStream is = ucon.getInputStream();
        is = new BufferedInputStream(is);
        String contentEncoding = ucon.getContentEncoding();
        String conType = ucon.getContentType();
        if (CSSUtil.isInvalidCSSContentType(url, conType) && !this.isRedirect(ucon)) {
            String msg;
            if (conType != null) {
                conType = conType.replaceAll("\\p{Cc}", "*CTRL*");
                msg = "Style sheet at " + url.toExternalForm() + " served with invalid type (" + conType + ").";
            } else {
                msg = "Style sheet at " + url.toExternalForm() + " has no valid content type.";
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(msg);
        }
        Parser.NamespaceMap nsMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            nsMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        SheetTokenHandler handler = new SheetTokenHandler(nsMap, false);
        int[] allowInWords = new int[]{45, 95};
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.setAcceptEofEndingQuoted(true);
        try (Reader re = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)StandardCharsets.UTF_8);){
            this.handler.parseStart(handler);
            tp.parse(re, "/*", "*/");
        }
    }

    private boolean isRedirect(URLConnection ucon) {
        if (ucon instanceof HttpURLConnection) {
            try {
                int code = ((HttpURLConnection)ucon).getResponseCode();
                return code > 300 && code < 400 && code != 304;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void parseStyleSheet(InputSource source) throws CSSParseException, IOException, IllegalStateException, IllegalArgumentException {
        if (source == null) {
            throw new NullPointerException("Null source.");
        }
        Reader re = source.getCharacterStream();
        if (re == null) {
            InputStream is = source.getByteStream();
            if (is == null) {
                String uri = source.getURI();
                if (uri == null) {
                    throw new IllegalArgumentException("Null character stream");
                }
                this.parseStyleSheet(uri);
                return;
            }
            String charset = source.getEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            re = new InputStreamReader(is, charset);
        }
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        int[] allowInWords = new int[]{45, 95};
        Parser.NamespaceMap nsMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            nsMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        SheetTokenHandler handler = new SheetTokenHandler(nsMap, true);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.setAcceptEofEndingQuoted(true);
        this.handler.parseStart(handler);
        tp.parse(re, "/*", "*/");
    }

    @Override
    public void parseStyleDeclaration(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler handler = new DeclarationTokenHandler(ShorthandDatabase.getInstance());
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        this.handler.parseStart(handler);
        tp.parse(reader, "/*", "*/");
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException, IllegalStateException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler handler = new DeclarationTokenHandler(ShorthandDatabase.getInstance());
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        Reader reader = this.getReaderFromSource(source);
        this.handler.parseStart(handler);
        tp.parse(reader, "/*", "*/");
    }

    private Reader getReaderFromSource(InputSource source) throws IOException {
        if (source == null) {
            throw new NullPointerException("Null source.");
        }
        Reader re = source.getCharacterStream();
        if (re == null) {
            InputStream is = source.getByteStream();
            if (is != null) {
                String encoding = source.getEncoding();
                Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
                re = new InputStreamReader(is, charset);
            } else {
                String uri = source.getURI();
                if (uri != null) {
                    URL url = new URL(uri);
                    URLConnection con = url.openConnection();
                    con.setConnectTimeout(30000);
                    con.connect();
                    is = con.getInputStream();
                    is = new BufferedInputStream(is);
                    String contentEncoding = con.getContentEncoding();
                    String conType = con.getContentType();
                    String encoding = source.getEncoding();
                    Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
                    re = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)charset);
                }
            }
        }
        return re;
    }

    public void parseDeclarationRule(Reader reader) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        if (!(this.handler instanceof DeclarationRuleHandler)) {
            throw new IllegalStateException("Document handler needs to implement DeclarationRuleHandler.");
        }
        DeclarationRuleTokenHandler handler = new DeclarationRuleTokenHandler(ShorthandDatabase.getInstance());
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        this.handler.parseStart(handler);
        tp.parse(reader, "/*", "*/");
    }

    public PageSelectorList parsePageSelectorList(String pageSelectorStr) throws DOMException {
        if (pageSelectorStr == null) {
            throw new NullPointerException("Null page selector");
        }
        PageSelectorListImpl list = new PageSelectorListImpl();
        StringTokenizer commast = new StringTokenizer(pageSelectorStr, ",");
        while (commast.hasMoreTokens()) {
            String selstr = commast.nextToken();
            selstr = ParseHelper.unescapeStringValue(selstr, true, false);
            StringTokenizer st = new StringTokenizer(selstr, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                AbstractPageSelector psitem = this.parsePageSelector(s);
                if (psitem != null) {
                    list.add(psitem);
                    continue;
                }
                throw new DOMException(12, "Bad page selector: " + s);
            }
        }
        return list;
    }

    private AbstractPageSelector parsePageSelector(String s) {
        AbstractPageSelector psitem = null;
        AbstractPageSelector ps = null;
        int colonidx = s.indexOf(58);
        if (colonidx == -1) {
            return new PageTypeSelector(s);
        }
        if (colonidx != 0) {
            String pts = s.substring(0, colonidx);
            if (!CSSParser.isValidIdentifier(pts)) {
                return null;
            }
            psitem = ps = new PageTypeSelector(pts);
        }
        ++colonidx;
        int len = s.length();
        while (colonidx < len) {
            String pp;
            int nextColonIdx = s.indexOf(58, colonidx);
            if (nextColonIdx == colonidx) {
                return null;
            }
            if (nextColonIdx == -1) {
                pp = s.substring(colonidx).toLowerCase(Locale.ROOT);
                colonidx = len;
            } else {
                pp = s.substring(colonidx, nextColonIdx).toLowerCase(Locale.ROOT);
                colonidx = nextColonIdx + 1;
            }
            if (this.containsOnlyLcLetters(pp)) {
                PseudoPageSelector pps = new PseudoPageSelector(pp);
                if (ps != null) {
                    ps.setNextSelector(pps);
                } else {
                    psitem = pps;
                }
                ps = pps;
                continue;
            }
            return null;
        }
        return psitem;
    }

    private boolean containsOnlyLcLetters(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    @Override
    public void parseRule(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(null);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        this.handler.parseStart(handler);
        tp.parse(reader, "/*", "*/");
    }

    @Override
    public void parseRule(Reader reader, Parser.NamespaceMap nsmap) throws CSSParseException, IOException, IllegalStateException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(nsmap);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        this.handler.parseStart(handler);
        tp.parse(reader, "/*", "*/");
    }

    public void parseRule(InputSource source) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(null);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        Reader re = this.getReaderFromSource(source);
        this.handler.parseStart(handler);
        tp.parse(re, "/*", "*/");
    }

    public void parsePageRuleBody(String blockList) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        PageTokenHandler handler = new PageTokenHandler();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        this.handler.parseStart(handler);
        tp.parse(blockList, "/*", "*/");
    }

    public void parseKeyFramesBody(String blockList) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        KeyFrameBlockListTH handler = new KeyFrameBlockListTH();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        this.handler.parseStart(handler);
        tp.parse(blockList, "/*", "*/");
    }

    public void parseFontFeatureValuesBody(String blockList) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        FontFeatureValuesTH handler = new FontFeatureValuesTH();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        this.handler.parseStart(handler);
        tp.parse(blockList, "/*", "*/");
    }

    public BooleanCondition parseSupportsCondition(String conditionText, CSSRule rule) throws CSSParseException, CSSBudgetException {
        AbstractCSSStyleSheet parentStyleSheet = null;
        if (rule != null) {
            parentStyleSheet = (AbstractCSSStyleSheet)rule.getParentStyleSheet();
        }
        return this.parseSupportsCondition(conditionText, rule, parentStyleSheet);
    }

    public BooleanCondition parseSupportsCondition(String conditionText, CSSRule rule, SheetContext parentStyleSheet) throws CSSParseException, CSSBudgetException {
        int[] allowInWords = new int[]{45, 46};
        SupportsTokenHandler handler = new SupportsTokenHandler(rule, parentStyleSheet);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        try {
            tp.parse(conditionText, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            throw new CSSBudgetException("Nested conditions exceed limit", e);
        }
        if (handler.errorCode == 0) {
            return handler.getCondition();
        }
        return null;
    }

    protected SupportsConditionFactory createSupportsConditionFactory(SheetContext parentSheet) {
        return new io.sf.carte.doc.style.css.om.SupportsConditionFactory(parentSheet);
    }

    @Override
    public void parseMediaQueryList(String media, MediaQueryFactory queryFactory, MediaQueryHandler mqhandler) throws CSSBudgetException {
        int[] allowInWords = new int[]{45, 46};
        MediaQueryTokenHandler handler = new MediaQueryTokenHandler(queryFactory, mqhandler);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        mqhandler.startQuery();
        try {
            tp.parse(media, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            CSSParseException ex = handler.createException(0, (byte)127, "Nested queries exceed limit.");
            ex.initCause(e);
            mqhandler.invalidQuery(ex);
            throw new CSSBudgetException("Nested queries exceed limit", e);
        }
    }

    @Override
    public MediaQueryList parseMediaQueryList(String media, Node owner) throws CSSBudgetException {
        int[] allowInWords = new int[]{45, 46};
        MediaQueryFactory mediaQueryFactory = this.getMediaQueryFactory();
        MediaQueryHandler mqhandler = mediaQueryFactory.createMediaQueryHandler(owner);
        MediaQueryTokenHandler handler = new MediaQueryTokenHandler(mediaQueryFactory, mqhandler);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        mqhandler.startQuery();
        try {
            tp.parse(media, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            CSSParseException ex = handler.createException(0, (byte)127, "Nested queries exceed limit.");
            ex.initCause(e);
            mqhandler.invalidQuery(ex);
            throw new CSSBudgetException("Nested queries exceed limit", e);
        }
        return mqhandler.getMediaQueryList();
    }

    protected MediaQueryFactory getMediaQueryFactory() {
        return new NSACMediaQueryFactory();
    }

    private MediaQueryList parseMediaQueryList(String media) {
        MediaQueryHandler mqhandler;
        block2: {
            int[] allowInWords = new int[]{45, 46};
            MediaQueryFactory mediaQueryFactory = this.getMediaQueryFactory();
            mqhandler = mediaQueryFactory.createMediaQueryHandler(null);
            MediaQueryTokenHandler handler = new MediaQueryTokenHandler(mediaQueryFactory, mqhandler);
            TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
            mqhandler.startQuery();
            try {
                tp.parse(media, "/*", "*/");
            }
            catch (IndexOutOfBoundsException e) {
                CSSParseException ex = handler.createException(0, (byte)127, "Nested queries exceed limit.");
                mqhandler.invalidQuery(ex);
                if (this.errorHandler == null) break block2;
                this.errorHandler.error(ex);
            }
        }
        return mqhandler.getMediaQueryList();
    }

    private static boolean isKnownFeature(String string) {
        return string.startsWith("min-") || string.startsWith("max-") || MediaQueryDatabase.isMediaFeature(string) || string.startsWith("device-");
    }

    private static boolean isValidFeatureSyntax(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public SelectorList parseSelectors(Reader reader) throws CSSParseException, CSSBudgetException, IOException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.parse(reader, "/*", "*/");
        return handler.getTrimmedSelectorList();
    }

    @Override
    public SelectorList parseSelectors(String selectorText, Parser.NamespaceMap nsmap) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(nsmap);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        tp.parse(selectorText);
        return handler.getTrimmedSelectorList();
    }

    public SelectorList parseSelectors(InputSource source) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        Reader re = this.getReaderFromSource(source);
        SelectorTokenHandler handler = new SelectorTokenHandler(null);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.parse(re, "/*", "*/");
        return handler.getTrimmedSelectorList();
    }

    public SelectorList parseSelectors(String seltext) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        tp.parse(seltext, "/*", "*/");
        return handler.getTrimmedSelectorList();
    }

    private SelectorList parseSelectors(String seltext, NSACSelectorFactory factory) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(factory);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        tp.parse(seltext);
        return handler.getTrimmedSelectorList();
    }

    private SelectorList parseSelectorArgument(String seltext, NSACSelectorFactory factory) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        SelectorArgumentTokenHandler handler = new SelectorArgumentTokenHandler(factory);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords);
        tp.parse(seltext);
        return handler.getTrimmedSelectorList();
    }

    @Override
    public Condition parsePseudoElement(String pseudoElement) throws CSSException {
        Selector sel;
        SelectorList peList = this.parseSelectors(pseudoElement);
        if (peList.getLength() == 1 && (sel = peList.item(0)).getSelectorType() == Selector.SelectorType.CONDITIONAL) {
            Condition cond = ((ConditionalSelector)sel).getCondition();
            Condition.ConditionType condType = cond.getConditionType();
            if (condType == Condition.ConditionType.PSEUDO_ELEMENT) {
                return cond;
            }
            if (condType == Condition.ConditionType.AND) {
                CombinatorCondition comb = (CombinatorCondition)cond;
                Condition first = comb.getFirstCondition();
                Condition second = comb.getSecondCondition();
                if (first.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT && second.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT) {
                    return cond;
                }
            }
        }
        throw new CSSException("No pseudo-element in: " + pseudoElement);
    }

    @Override
    public LexicalUnit parsePropertyValue(Reader reader) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        PropertyTokenHandler handler = new PropertyTokenHandler();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.parse(reader, "/*", "*/");
        return handler.getLexicalUnit();
    }

    private LexicalUnit parsePropertyValue(Reader reader, int currentLine, int prevLineLength) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        PropertyTokenHandler handler = new PropertyTokenHandler(currentLine, prevLineLength);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.parse(reader, "/*", "*/");
        return handler.getLexicalUnit();
    }

    public LexicalUnit parsePropertyValue(String propertyName, Reader reader) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        PropertyTokenHandler handler = new PropertyTokenHandler(propertyName);
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.parse(reader, "/*", "*/");
        return handler.getLexicalUnit();
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws CSSParseException, IOException {
        int[] allowInWords = new int[]{45, 95};
        Reader re = this.getReaderFromSource(source);
        PropertyTokenHandler handler = new PropertyTokenHandler();
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, this.streamSizeLimit);
        tp.parse(re, "/*", "*/");
        return handler.getLexicalUnit();
    }

    @Override
    public boolean parsePriority(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        int cp = reader.read();
        if (cp != -1) {
            int count = 0;
            StringBuilder buf = new StringBuilder(9);
            int parsingWord = 0;
            if (CSSParser.isNotSeparator(cp)) {
                buf.appendCodePoint(cp);
                parsingWord = 1;
                count = 1;
            }
            while ((cp = reader.read()) != -1 && parsingWord != 2) {
                if (CSSParser.isNotSeparator(cp)) {
                    buf.appendCodePoint(cp);
                    count = (short)(count + 1);
                    if (count == 10) {
                        return false;
                    }
                    parsingWord = 1;
                    continue;
                }
                if (parsingWord != 1) continue;
                parsingWord = 2;
            }
            return "important".equals(buf.toString().toLowerCase(Locale.ROOT));
        }
        return false;
    }

    static boolean bufferEndsWithEscapedCharOrWS(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len > 1 && (ParseHelper.isHexCodePoint(bufCp = buffer.codePointAt(len - 1)) || bufCp == 32)) {
            for (int i = 2; i <= Math.min(len, 6); ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (ParseHelper.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    static boolean bufferEndsWithEscapedChar(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len > 1 && ParseHelper.isHexCodePoint(bufCp = buffer.codePointAt(len - 1))) {
            for (int i = 2; i <= Math.min(len, 6); ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (ParseHelper.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isNotSeparator(int cp) {
        return cp != 32 && cp != 9 && cp != 10 && cp != 12 && cp != 13;
    }

    static boolean isValidIdentifier(String s) {
        int idx;
        int len = s.length();
        char c = s.charAt(0);
        if (c != '-') {
            if (!CSSParser.isNameStartChar(c) && c != '\\') {
                return false;
            }
            idx = 1;
        } else if (len > 1) {
            c = s.charAt(1);
            if (!CSSParser.isNameStartChar(c) && c != '-' && c != '\\') {
                return false;
            }
            idx = 2;
        } else {
            return false;
        }
        while (idx < len) {
            c = s.charAt(idx);
            if (!CSSParser.isNameChar(c)) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    private static boolean isNameChar(char cp) {
        return cp >= 'a' && cp <= 'z' || cp >= 'A' && cp <= 'Z' || cp >= '0' && cp <= '9' || cp == '-' || cp == '_' || cp > '\u0080' || cp == '\\';
    }

    private static boolean isNameStartChar(char cp) {
        return cp >= 'a' && cp <= 'z' || cp >= 'A' && cp <= 'Z' || cp == '_' || cp > '\u0080';
    }

    private static boolean equalSequences(CharSequence seq1, CharSequence seq2) {
        int len = seq1.length();
        if (len != seq2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (seq1.charAt(i) == seq2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public CSSParser clone() {
        CSSParser parser = new CSSParser(this);
        return parser;
    }

    class SheetTokenHandler
    extends ControlTokenHandler {
        CSSTokenHandler contextHandler;
        private final DeclarationTokenHandler declarationHandler;
        private final SelectorTokenHandler selectorHandler;
        private String ruleFirstPart;
        private String ruleSecondPart;
        private int curlyBracketDepth;
        private byte ruleType;
        private static final byte MEDIA_RULE = 4;
        private static final byte FONT_FACE_RULE = 5;
        private static final byte SUPPORTS_RULE = 12;
        private byte stage;
        private static final byte STAGE_INITIAL = 0;
        private static final byte STAGE_CHARSET_RULE = 32;
        private static final byte STAGE_NS_RULE_EXPECT_FIRST_TOKEN = 34;
        private static final byte STAGE_NS_RULE_EXPECT_SECOND_TOKEN = 35;
        private static final byte STAGE_NS_RULE_EXPECT_SECOND_TOKEN_AS_URL = 36;
        private static final byte STAGE_NS_RULE_RCVD_SECOND_TOKEN_AS_URL = 37;
        private static final byte STAGE_IMPORT_RULE_EXPECT_FIRST_TOKEN = 38;
        private static final byte STAGE_IMPORT_RULE_EXPECT_FIRST_TOKEN_AS_URL = 39;
        private static final byte STAGE_IMPORT_RULE_EXPECT_CLOSING_PAREN = 41;
        private static final byte STAGE_IMPORT_RULE_EXPECT_SECOND_TOKEN_OR_FINAL = 40;
        private static final byte STAGE_GROUPING_OR_FONTFACE_RULE = 2;
        private static final byte STAGE_UNKNOWN_RULE = 5;
        private static final byte STAGE_NESTED_RULE_INSIDE_GROUPING_OR_FONTFACE_EXCEPT_10 = 7;
        private static final byte STAGE_NESTED_FONTFACE_RULE_INSIDE_GROUPING = 10;
        private boolean rulesFound;
        private ConditionWrapper currentCondition;
        private final boolean topLevel;

        SheetTokenHandler(Parser.NamespaceMap nsMap, boolean topLevel) {
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.curlyBracketDepth = 0;
            this.ruleType = 0;
            this.stage = 0;
            this.rulesFound = false;
            this.currentCondition = null;
            this.topLevel = topLevel;
            this.buffer = new StringBuilder(512);
            this.declarationHandler = new MyDeclarationTokenHandler();
            this.selectorHandler = new MySelectorTokenHandler(nsMap);
            this.contextHandler = this.selectorHandler;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        public void word(int index, CharSequence word) {
            if (this.contextHandler != null) {
                this.contextHandler.word(index, word);
            } else if (this.stage == 41) {
                this.handleError(index, (byte)33, "Unexpected token: '" + word + '\'');
            } else {
                this.buffer.append(word);
            }
            this.prevcp = 65;
        }

        public void separator(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.separator(index, codepoint);
            } else {
                if (this.stage == 39) {
                    if (this.buffer.length() != 0) {
                        this.stage = (byte)41;
                    }
                } else if (this.stage != 41) {
                    if (this.stage == 38) {
                        if (this.buffer.length() != 0) {
                            this.processFirstPart(index);
                            this.stage = (byte)40;
                        }
                    } else if (this.stage == 34) {
                        if (this.ruleFirstPart == null) {
                            if (this.buffer.length() != 0) {
                                this.ruleFirstPart = this.buffer.toString();
                                this.buffer.setLength(0);
                                this.stage = (byte)35;
                            }
                        } else {
                            this.stage = (byte)35;
                        }
                    } else if (this.buffer.length() != 0 && (!this.isPrevCpWhitespace() || this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer))) {
                        this.buffer.append(' ');
                    }
                }
                this.setWhitespacePrevCp();
            }
        }

        @Override
        protected void setHandlerPreviousCp(int cp) {
            super.setHandlerPreviousCp(cp);
            if (this.contextHandler != null) {
                this.contextHandler.setHandlerPreviousCp(cp);
            }
        }

        @Override
        protected boolean isPreviousCpLF() {
            if (this.contextHandler != null) {
                return this.contextHandler.isPreviousCpLF();
            }
            return super.isPreviousCpLF();
        }

        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (this.contextHandler != null) {
                this.contextHandler.quoted(index, quoted, quoteCp);
            } else if (this.stage == 5 || this.stage == 7) {
                char c = (char)quoteCp;
                this.buffer.append(c).append(quoted).append(c);
            } else if (this.stage == 41 || this.stage == 39 && this.prevcp != 40 && !this.isPrevCpWhitespace()) {
                this.handleError(index, (byte)33, "Expected ')', found '" + quoted + '\'');
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = quoted.toString();
                    if (this.stage == 39) {
                        this.stage = (byte)41;
                    } else if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = quoted.toString();
                } else {
                    this.buffer.append(quoted);
                }
                this.prevcp = 65;
            }
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        public void leftCurlyBracket(int index) {
            if (this.contextHandler != null) {
                this.contextHandler.leftCurlyBracket(index);
            } else {
                this.prevcp = 123;
                ++this.curlyBracketDepth;
                if (this.stage == 2) {
                    if (this.curlyBracketDepth == 1) {
                        if (this.ruleType == 5) {
                            this.startFontFaceRule(index);
                        }
                        this.buffer.setLength(0);
                    }
                } else if (this.stage == 10 && this.curlyBracketDepth >= 2) {
                    this.startFontFaceRule(index);
                } else {
                    this.buffer.append('{');
                }
            }
        }

        public void leftParenthesis(int index) {
            if (this.contextHandler != null) {
                this.contextHandler.leftParenthesis(index);
            } else {
                this.prevcp = 40;
                this.parendepth = (short)(this.parendepth + 1);
                if (this.stage == 38) {
                    if (this.bufferEquals("url")) {
                        this.stage = (byte)39;
                    } else {
                        this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer);
                    }
                } else if (this.stage == 39) {
                    this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer);
                } else if (this.stage == 35) {
                    if (this.bufferEquals("url")) {
                        this.stage = (byte)36;
                    } else {
                        this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer);
                    }
                } else if (this.stage == 34) {
                    if (this.bufferEquals("url")) {
                        this.ruleFirstPart = "";
                        this.stage = (byte)36;
                    } else {
                        this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer);
                    }
                } else {
                    this.buffer.append('(');
                }
            }
        }

        public void leftSquareBracket(int index) {
            if (this.contextHandler != null) {
                this.contextHandler.leftSquareBracket(index);
            } else {
                this.buffer.append('[');
                this.prevcp = 91;
            }
        }

        private void startFontFaceRule(int index) {
            if (this.buffer.length() != 0) {
                this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in @font-face rule: " + this.buffer);
            } else {
                CSSParser.this.handler.startFontFace();
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
                --this.curlyBracketDepth;
            }
        }

        public void rightParenthesis(int index) {
            if (this.contextHandler != null) {
                this.contextHandler.rightParenthesis(index);
            } else {
                this.decrParenDepth(index);
                if (this.stage == 36) {
                    this.processBuffer(index);
                    if (this.ruleSecondPart != null) {
                        this.stage = (byte)37;
                    } else {
                        this.handleError(index, (byte)33, "Empty URI in namespace rule");
                    }
                } else if (this.stage == 39 || this.stage == 41) {
                    this.processFirstPart(index);
                    this.stage = (byte)40;
                } else {
                    this.buffer.append(')');
                }
                this.prevcp = 41;
            }
        }

        public void rightSquareBracket(int index) {
            if (this.contextHandler != null) {
                this.contextHandler.rightSquareBracket(index);
            } else {
                this.buffer.append(']');
                this.prevcp = 93;
            }
        }

        public void rightCurlyBracket(int index) {
            if (this.contextHandler != null) {
                this.contextHandler.rightCurlyBracket(index);
            } else {
                --this.curlyBracketDepth;
                this.buffer.append('}');
                if (this.curlyBracketDepth == 0) {
                    if (!this.parseError) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.stage = 0;
                    }
                    this.buffer.setLength(0);
                    this.endRuleBody();
                } else if (!this.parseError && this.curlyBracketDepth == 1 && this.stage == 7) {
                    CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                    this.buffer.setLength(0);
                    this.stage = (byte)2;
                    this.switchContextToStage2();
                }
                this.prevcp = 125;
            }
        }

        protected void endRuleBody() {
            this.setSelectorHandler();
        }

        void setSelectorHandler() {
            this.selectorHandler.resetHandler();
            this.contextHandler = this.selectorHandler;
            this.rulesFound = true;
        }

        private void switchContextToStage2() {
            if (this.ruleType == 4 || this.ruleType == 12) {
                this.contextHandler = this.selectorHandler;
                this.selectorHandler.prevcp = 32;
            } else if (this.ruleType == 5) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            }
        }

        public void character(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.character(index, codepoint);
            } else {
                this.prevcp = codepoint;
                if (codepoint == 59) {
                    if (this.curlyBracketDepth == 0) {
                        if (this.parendepth == 0) {
                            if (this.stage != 0) {
                                this.endOfAtRule(index);
                            } else {
                                this.handleError(index, (byte)33, "Empty @-rule.");
                                this.resetRuleState();
                            }
                        } else if (this.stage != 39) {
                            this.handleError(index, (byte)6, "Unmatched parentheses in rule.");
                            this.resetRuleState();
                        } else {
                            this.buffer.append(';');
                            this.prevcp = codepoint;
                            return;
                        }
                        this.setSelectorHandler();
                    } else {
                        this.buffer.append(';');
                    }
                } else if (this.isAllowedChar(codepoint)) {
                    this.bufferAppend(codepoint);
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            }
        }

        private void endOfAtRule(int index) {
            this.processBuffer(index);
            if (this.buffer.length() != 0) {
                this.handleError(index, (byte)9, "Malformed @-rule, unexpected <" + this.buffer.toString() + ">");
            }
            if (this.stage == 40 || this.stage == 38) {
                this.currentCondition = this.ruleSecondPart != null ? this.newMediaList(this.ruleSecondPart) : null;
                if (this.ruleFirstPart != null) {
                    if (this.currentCondition == null) {
                        this.currentCondition = this.newMediaListAll();
                    }
                    CSSParser.this.handler.importStyle(this.ruleFirstPart, this.currentCondition.getMediaList(), null);
                } else if (!this.parseError) {
                    this.handleError(index, (byte)33, "Malformed @-rule");
                }
            } else if (this.stage == 35 || this.stage == 37) {
                if (this.ruleSecondPart != null) {
                    this.namespaceDeclaration(this.ruleFirstPart, this.ruleSecondPart);
                } else {
                    this.handleError(index, (byte)33, "No URI in namespace rule");
                }
            } else if (this.stage == 34) {
                this.namespaceDeclaration("", this.ruleFirstPart);
            } else if (this.stage == 36) {
                this.handleError(index, (byte)33, "Bad URI in namespace rule");
            }
            this.resetRuleState();
            this.rulesFound = true;
        }

        private ConditionWrapper newMediaListAll() {
            MediaQueryFactory mediaQueryFactory = CSSParser.this.getMediaQueryFactory();
            MediaQueryList mqAll = mediaQueryFactory.createAllMedia();
            return new ConditionWrapper(mqAll, this.currentCondition);
        }

        private ConditionWrapper newMediaList(String media) {
            MediaQueryList list = CSSParser.this.parseMediaQueryList(media);
            return new ConditionWrapper(list, this.currentCondition);
        }

        void namespaceDeclaration(String prefix, String uri) {
            CSSParser.this.handler.namespaceDeclaration(prefix, uri);
            this.selectorHandler.factory.registerNamespacePrefix(prefix, uri);
        }

        void resetRuleState() {
            this.resetHandler();
            if (this.currentCondition != null) {
                this.currentCondition = this.currentCondition.getParent();
                if (this.currentCondition == null) {
                    this.stage = 0;
                } else {
                    this.ruleType = this.currentCondition.isMediaCondition() ? (byte)4 : (byte)12;
                }
            } else {
                this.stage = 0;
            }
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.buffer.setLength(0);
        }

        private boolean isAllowedChar(int codePoint) {
            switch (this.stage) {
                case 5: 
                case 7: 
                case 36: 
                case 39: {
                    return true;
                }
                case 40: {
                    return codePoint == 58 || this.isImportMediaRuleAllowedChar(codePoint);
                }
            }
            return false;
        }

        private boolean isImportMediaRuleAllowedChar(int codePoint) {
            int[] allowedChars = new int[]{37, 42, 43, 44, 45, 46, 47, 60, 61, 62};
            return Arrays.binarySearch(allowedChars, codePoint) >= 0;
        }

        private void processFirstPart(int index) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else {
                    this.handleError(index, (byte)33, "Unexpected token: " + this.buffer.toString());
                }
            } else if (this.ruleFirstPart == null) {
                this.handleError(index, (byte)33, "Empty rule.");
            }
        }

        private void processBuffer(int index) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = this.buffer.toString();
                    this.buffer.setLength(0);
                }
            }
        }

        private void trimBufferTail() {
            if (this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                this.buffer.setLength(this.buffer.length() - 1);
            }
        }

        private boolean bufferEquals(String lcWord) {
            if (ParseHelper.equalsIgnoreCase(this.buffer, lcWord)) {
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        public void escaped(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.escaped(index, codepoint);
            } else if (!this.parseError) {
                if (ParseHelper.isHexCodePoint(codepoint) || codepoint == 92) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                }
                this.bufferAppend(codepoint);
            }
            this.prevcp = 65;
        }

        public void endOfStream(int len) {
            if (this.contextHandler != null) {
                this.contextHandler.endOfStream(len);
                return;
            }
            if (this.ruleType == 5) {
                CSSParser.this.handler.endFontFace();
                if (this.stage == 10) {
                    this.closeGroupingRules();
                }
            } else if (this.ruleType == 4 || this.ruleType == 12) {
                this.closeGroupingRules();
            } else if (this.stage != 0 && !this.parseError) {
                if (this.curlyBracketDepth == 0) {
                    this.endOfAtRule(len);
                } else if (this.buffer.length() != 0) {
                    do {
                        --this.curlyBracketDepth;
                        this.buffer.append('}');
                    } while (this.curlyBracketDepth > 0);
                    CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                    this.handleError(len, (byte)10, "Unexpected end of stream");
                    this.endDocument();
                    return;
                }
            }
            if (this.curlyBracketDepth != 0 && !this.parseError) {
                this.handleWarning(len, (byte)10, "Unexpected end of stream");
            }
            this.endDocument();
        }

        private void closeGroupingRules() {
            while (this.currentCondition != null) {
                if (this.currentCondition.isMediaCondition()) {
                    CSSParser.this.handler.endMedia(this.currentCondition.getMediaList());
                } else {
                    CSSParser.this.handler.endSupports(this.currentCondition.getCondition());
                }
                this.currentCondition = this.currentCondition.getParent();
            }
        }

        private void setSelectorHandler(int prevcp) {
            this.contextHandler = this.selectorHandler;
            this.selectorHandler.parseError = false;
            this.selectorHandler.prevcp = 32;
            this.selectorHandler.stage = 0;
            this.prevcp = prevcp;
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (this.stage == 5 || this.stage == 7) {
                if (commentType == 0) {
                    this.buffer.append("/*").append(comment).append("*/");
                }
            } else if (this.contextHandler != null) {
                this.contextHandler.commented(index, commentType, comment);
            } else {
                this.separator(index, 12);
            }
        }

        @Override
        protected void handleError(CSSParseException ex) throws CSSParseException {
            if (this.contextHandler != null) {
                this.contextHandler.handleError(ex);
            } else {
                super.handleError(ex);
                this.buffer.setLength(0);
                this.stage = (byte)127;
            }
        }

        private void startNewRule(int index) {
            String atRule = this.unescapeBuffer(index);
            if (atRule.length() > 2) {
                if (this.stage == 0) {
                    this.startRule(index, atRule);
                } else {
                    this.startNestedRule(index, atRule);
                }
            } else {
                this.handleError(index, (byte)33, "Malformed @-rule.");
                this.contextHandler = null;
            }
        }

        private void startRule(int index, String word) {
            this.contextHandler = null;
            String ruleName = word.substring(1).toLowerCase(Locale.ROOT);
            if ("charset".equals(ruleName)) {
                if (!this.rulesFound) {
                    this.stage = (byte)32;
                    this.buffer.setLength(0);
                } else {
                    this.handleError(index - 8, (byte)33, "@charset must be the first rule");
                }
            } else if ("import".equals(ruleName)) {
                this.stage = (byte)38;
                this.buffer.setLength(0);
            } else if ("namespace".equals(ruleName)) {
                this.stage = (byte)34;
                this.buffer.setLength(0);
            } else if ("media".equals(ruleName)) {
                this.ruleType = (byte)4;
                this.stage = (byte)2;
                this.buffer.setLength(0);
                this.setMediaQueryHandler();
            } else if ("supports".equals(ruleName)) {
                this.ruleType = (byte)12;
                this.stage = (byte)2;
                this.buffer.setLength(0);
                this.contextHandler = new MySupportsTokenHandler();
            } else if ("font-face".equals(ruleName)) {
                this.ruleType = (byte)5;
                this.stage = (byte)2;
                this.buffer.setLength(0);
            } else if ("page".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyPageTH();
            } else if ("viewport".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new ViewportTokenHandler();
            } else if ("counter-style".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new CounterStyleTokenHandler();
            } else if ("keyframes".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyKeyFrameBlockListTH();
            } else if ("font-feature-values".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyFontFeatureValuesTH();
            } else if ("property".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new PropertyRuleTokenHandler();
            } else {
                this.buffer.append(word);
                if (this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                this.stage = (byte)5;
            }
        }

        private void startNestedRule(int index, String word) {
            this.contextHandler = null;
            String ruleName = word.substring(1).toLowerCase(Locale.ROOT);
            if ("page".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyPageTH();
            } else if ("font-face".equals(ruleName)) {
                if (this.ruleType == 4 || this.ruleType == 12) {
                    this.ruleType = (byte)5;
                    this.stage = (byte)10;
                    this.buffer.setLength(0);
                } else {
                    this.handleError(index, (byte)9, "Unexpected rule: @font-face.");
                }
            } else if ("media".equals(ruleName)) {
                if (this.ruleType == 12) {
                    this.ruleType = (byte)4;
                } else if (this.ruleType != 4) {
                    this.handleError(index, (byte)9, "Unexpected: @" + ruleName);
                    return;
                }
                this.buffer.setLength(0);
                this.setMediaQueryHandler();
            } else if ("supports".equals(ruleName)) {
                if (this.ruleType == 4) {
                    this.ruleType = (byte)12;
                } else if (this.ruleType != 12) {
                    this.handleError(index, (byte)9, "Unexpected: @" + ruleName);
                    return;
                }
                this.buffer.setLength(0);
                this.contextHandler = new MySupportsTokenHandler();
            } else if ("viewport".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new ViewportTokenHandler();
            } else if ("counter-style".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new CounterStyleTokenHandler();
            } else if ("keyframes".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyKeyFrameBlockListTH();
            } else if ("font-feature-values".equals(ruleName)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyFontFeatureValuesTH();
            } else if ("charset".equals(ruleName)) {
                this.handleError(index - 8, (byte)33, "@charset must be the first rule");
            } else if ("property".equals(ruleName)) {
                this.handleError(index - 9, (byte)33, "@property rules cannot be nested");
            } else {
                this.buffer.append(word);
                if (this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                this.stage = (byte)7;
            }
        }

        private void setMediaQueryHandler() {
            MediaQueryFactory mediaQueryFactory = CSSParser.this.getMediaQueryFactory();
            MediaQueryHandler mqhandler = mediaQueryFactory.createMediaQueryHandler(null);
            this.contextHandler = new MyMediaQueryTokenHandler(mediaQueryFactory, mqhandler);
        }

        private class MyDeclarationTokenHandler
        extends DeclarationTokenHandler {
            MyDeclarationTokenHandler() {
                super(ShorthandDatabase.getInstance());
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                SheetTokenHandler.this.setSelectorHandler(125);
                this.closeRule();
                SheetTokenHandler.this.rulesFound = true;
                this.resetHandler();
            }

            private void closeRule() {
                if (SheetTokenHandler.this.ruleType == 5) {
                    CSSParser.this.handler.endFontFace();
                    if (SheetTokenHandler.this.stage == 10) {
                        if (SheetTokenHandler.this.currentCondition.isMediaCondition()) {
                            SheetTokenHandler.this.ruleType = (byte)4;
                        } else {
                            SheetTokenHandler.this.ruleType = (byte)12;
                        }
                        this.buffer.setLength(0);
                        SheetTokenHandler.this.stage = (byte)2;
                    } else {
                        SheetTokenHandler.this.ruleType = (byte)0;
                        SheetTokenHandler.this.stage = (byte)0;
                    }
                } else {
                    CSSParser.this.handler.endSelector(((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.selist);
                    ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.selist = new CSSTokenHandler.MySelectorListImpl();
                }
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.propertyName == null && this.buffer.length() == 0 && this.getCurlyBracketDepth() == 1 && SheetTokenHandler.this.selectorHandler.getSelectorList().getLength() == 0) {
                    SheetTokenHandler.this.contextHandler = new AtRuleLauncherTH();
                    SheetTokenHandler.this.prevcp = 64;
                    SheetTokenHandler.this.buffer.append('@');
                } else {
                    this.unexpectedCharError(index, 64);
                }
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                if (this.curlyBracketDepth > 0) {
                    this.closeRule();
                    --this.curlyBracketDepth;
                    if (SheetTokenHandler.this.curlyBracketDepth == 0 && !this.parseError) {
                        this.handleWarning(len, (byte)10, "Unexpected end of stream");
                    }
                }
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            protected void endDeclarationList() {
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MySelectorTokenHandler
        extends SelectorTokenHandler {
            MySelectorTokenHandler(Parser.NamespaceMap nsMap) {
                super(nsMap);
            }

            @Override
            public void leftCurlyBracket(int index) {
                ((SheetTokenHandler)SheetTokenHandler.this).declarationHandler.curlyBracketDepth = 1;
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                if (!this.parseError) {
                    SheetTokenHandler.this.selectorHandler.processBuffer(index, 123, true);
                    if (!this.parseError) {
                        if (this.addCurrentSelector(index)) {
                            this.selist.trimToSize();
                            CSSParser.this.handler.startSelector(this.selist);
                        } else {
                            this.unexpectedCharError(index, 123);
                        }
                    }
                }
                this.stage = 0;
                if (this.parseError) {
                    this.buffer.setLength(0);
                    this.ignoreRule();
                }
            }

            private void ignoreRule() {
                this.selist.clear();
                this.currentsel = null;
                SheetTokenHandler.this.contextHandler = new MyIgnoredDeclarationTokenHandler();
            }

            @Override
            public void rightCurlyBracket(int index) {
                if (SheetTokenHandler.this.stage == 2) {
                    byte ruleType = SheetTokenHandler.this.ruleType;
                    if (ruleType == 4) {
                        CSSParser.this.handler.endMedia(SheetTokenHandler.this.currentCondition.getMediaList());
                        SheetTokenHandler.this.currentCondition = SheetTokenHandler.this.currentCondition.getParent();
                        if (SheetTokenHandler.this.currentCondition == null) {
                            this.resetSelectorHandler(true);
                        } else {
                            if (!SheetTokenHandler.this.currentCondition.isMediaCondition()) {
                                SheetTokenHandler.this.ruleType = (byte)12;
                            }
                            this.resetSelectorHandler(false);
                        }
                        return;
                    }
                    if (ruleType == 12) {
                        CSSParser.this.handler.endSupports(SheetTokenHandler.this.currentCondition.getCondition());
                        SheetTokenHandler.this.currentCondition = SheetTokenHandler.this.currentCondition.getParent();
                        if (SheetTokenHandler.this.currentCondition == null) {
                            this.resetSelectorHandler(true);
                        } else {
                            if (SheetTokenHandler.this.currentCondition.isMediaCondition()) {
                                SheetTokenHandler.this.ruleType = (byte)4;
                            }
                            this.resetSelectorHandler(false);
                        }
                        return;
                    }
                    if (SheetTokenHandler.this.curlyBracketDepth == 0) {
                        this.resetSelectorHandler(true);
                        return;
                    }
                }
                this.handleError(index, (byte)4, "Unexpected '}'");
                if (SheetTokenHandler.this.curlyBracketDepth <= 0) {
                    this.resetSelectorHandler(true);
                    SheetTokenHandler.this.curlyBracketDepth = 0;
                }
            }

            private void resetSelectorHandler(boolean resetSheetStage) {
                this.resetHandler();
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                SheetTokenHandler.this.curlyBracketDepth--;
                if (resetSheetStage) {
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                }
            }

            @Override
            boolean skipCharacterHandling() {
                return this.parseError && (this.prevcp != 59 || SheetTokenHandler.this.curlyBracketDepth != 0);
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.prevcp == 59) {
                    this.parseError = false;
                    this.stage = 0;
                } else if (this.stage > 0) {
                    int len = this.buffer.length();
                    if (len != 0) {
                        int cp = this.buffer.codePointAt(0);
                        String message = Character.isAlphabetic(cp) ? "Unknown token: " + this.buffer.toString() : "Unknown token starting with code point U+" + Integer.toHexString(cp);
                        this.handleError(index - len, (byte)9, message);
                    } else {
                        this.unexpectedCharError(index, 64);
                    }
                    return;
                }
                SheetTokenHandler.this.contextHandler = new AtRuleLauncherTH();
                SheetTokenHandler.this.prevcp = 64;
                SheetTokenHandler.this.buffer.append('@');
            }

            @Override
            boolean isTopLevel() {
                return SheetTokenHandler.this.topLevel;
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                if (this.stage != 0) {
                    this.handleError(len, (byte)10, "Unexpected end of stream");
                }
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                this.stage = (byte)127;
                if (!this.parseError) {
                    CSSParseException ex = this.prevcp == this.endcp ? this.createException(index, errCode, "Expected end of file") : this.createException(index, errCode, message);
                    this.handleError(ex);
                }
                this.selist.clear();
                this.buffer.setLength(0);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MySupportsTokenHandler
        extends SupportsTokenHandler {
            MySupportsTokenHandler() {
                super(null, (SheetContext)((Object)CSSParser.this.handler.getStyleSheet()));
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            void endOfCondition(int index) {
                super.endOfCondition(index);
                BooleanCondition cond = this.getCondition();
                SheetTokenHandler.this.currentCondition = new ConditionWrapper(cond, SheetTokenHandler.this.currentCondition);
                CSSParser.this.handler.startSupports(cond);
                SheetTokenHandler.this.setSelectorHandler();
            }

            @Override
            void handleLeftCurlyBracket(int index) {
                this.endOfCondition(index);
                SheetTokenHandler.this.curlyBracketDepth++;
            }

            @Override
            public void endOfStream(int len) {
                this.handleError(len, (byte)10, "Unexpected end of stream");
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MyPageTH
        extends PageTokenHandler {
            MyPageTH() {
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            void endBlockList(int index) {
                super.endBlockList(index);
                SheetTokenHandler.this.endRuleBody();
            }

            @Override
            protected void abortRule() {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.curlyBracketDepth += this.getCurlyBracketDepth();
                SheetTokenHandler.this.parseError = true;
                SheetTokenHandler.this.stage = (byte)127;
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class ViewportTokenHandler
        extends MyDeclarationRuleTokenHandler {
            private ViewportTokenHandler() {
                super(ShorthandDatabase.getInstance());
                this.setRuleName("viewport");
                this.setStage((byte)2);
            }

            @Override
            protected void startAtRule(int index, String ruleFirstPart, String ruleSecondPart) {
                if (ruleSecondPart == null) {
                    CSSParser.this.handler.startViewport();
                } else {
                    this.handleError(index, (byte)9, "Unexpected token after @viewport: " + ruleSecondPart);
                    this.setStage((byte)127);
                }
            }

            @Override
            protected void endAtRule(int index) {
                CSSParser.this.handler.endViewport();
                SheetTokenHandler.this.endRuleBody();
            }
        }

        private class CounterStyleTokenHandler
        extends MyDeclarationRuleTokenHandler {
            private CounterStyleTokenHandler() {
                super(ShorthandDatabase.getInstance());
                this.setRuleName("counter-style");
                this.setStage((byte)2);
            }

            @Override
            protected void startAtRule(int index, String ruleFirstPart, String ruleSecondPart) {
                if (ruleSecondPart != null && CSSParser.isValidIdentifier(ruleSecondPart)) {
                    try {
                        CSSParser.this.handler.startCounterStyle(ruleSecondPart);
                    }
                    catch (DOMException e) {
                        this.handleError(index, (byte)33, "Wrong name for @counter-style rule: " + ruleSecondPart, e);
                        this.setStage((byte)127);
                    }
                } else {
                    this.handleError(index, (byte)33, "Wrong name for @counter-style rule: " + ruleSecondPart);
                    this.setStage((byte)127);
                }
            }

            @Override
            protected void endAtRule(int index) {
                CSSParser.this.handler.endCounterStyle();
                SheetTokenHandler.this.endRuleBody();
            }
        }

        private class MyKeyFrameBlockListTH
        extends KeyFrameBlockListTH {
            MyKeyFrameBlockListTH() {
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            void endBlockList(int index) {
                super.endBlockList(index);
                SheetTokenHandler.this.endRuleBody();
            }

            @Override
            protected void abortRule() {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.curlyBracketDepth += this.getCurlyBracketDepth();
                SheetTokenHandler.this.parseError = true;
                SheetTokenHandler.this.stage = (byte)127;
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MyFontFeatureValuesTH
        extends FontFeatureValuesTH {
            MyFontFeatureValuesTH() {
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            void endBlockList(int index) {
                super.endBlockList(index);
                SheetTokenHandler.this.endRuleBody();
            }

            @Override
            protected void abortRule() {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.curlyBracketDepth += this.getCurlyBracketDepth();
                SheetTokenHandler.this.parseError = true;
                SheetTokenHandler.this.stage = (byte)127;
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class PropertyRuleTokenHandler
        extends MyDeclarationRuleTokenHandler {
            private CSSValueSyntax syntax;
            private boolean isUniversalSyntax;
            private boolean hasInherits;
            private LexicalUnit initialValue;

            private PropertyRuleTokenHandler() {
                super(ShorthandDatabase.getInstance());
                this.syntax = null;
                this.initialValue = null;
                this.setRuleName("property");
                this.setStage((byte)2);
            }

            @Override
            protected void startAtRule(int index, String ruleFirstPart, String ruleSecondPart) {
                if (ruleSecondPart == null) {
                    this.handleError(index, (byte)33, "Null name in @property rule.");
                    this.setStage((byte)127);
                } else {
                    try {
                        ruleSecondPart = ParseHelper.parseIdent(ruleSecondPart);
                    }
                    catch (DOMException e) {
                        this.handleError(index, (byte)33, "Bad name in @property rule: " + ruleSecondPart, e);
                        this.setStage((byte)127);
                        return;
                    }
                    CSSParser.this.handler.startProperty(ruleSecondPart);
                }
            }

            @Override
            protected void handleProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
                if ("syntax".equalsIgnoreCase(propertyName)) {
                    if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) {
                        this.handleError(index, (byte)33, "'syntax' descriptor in @property rule must be a string.");
                        return;
                    }
                    String s = lunit.getStringValue().trim();
                    SyntaxParser parser = new SyntaxParser();
                    try {
                        this.syntax = parser.parseSyntax(s);
                    }
                    catch (CSSException e) {
                        this.handleError(index, (byte)33, "Wrong 'syntax' descriptor in @property rule: '" + s + '\'');
                        return;
                    }
                    this.isUniversalSyntax = this.syntax.getCategory() == CSSValueSyntax.Category.universal;
                } else if ("inherits".equalsIgnoreCase(propertyName)) {
                    String s;
                    if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || !"true".equals(s = lunit.getStringValue().toLowerCase(Locale.ROOT)) && !"false".equals(s)) {
                        this.handleError(index, (byte)33, "'inherits' descriptor in @property rule must be either 'true' or 'false'.");
                        return;
                    }
                    this.hasInherits = true;
                } else if ("initial-value".equalsIgnoreCase(propertyName)) {
                    this.handleLexicalProperty(index, propertyName, lunit, priorityImportant);
                    this.initialValue = lunit;
                    return;
                }
                super.handleProperty(index, propertyName, lunit, priorityImportant);
            }

            @Override
            protected void endAtRule(int index) {
                if (this.syntax == null) {
                    this.handleError(index, (byte)33, "@property rule lacks mandatory 'syntax' descriptor.");
                    CSSParser.this.handler.endProperty(true);
                } else if (!this.hasInherits) {
                    this.handleError(index, (byte)33, "@property rule lacks mandatory 'inherits' descriptor.");
                    CSSParser.this.handler.endProperty(true);
                } else if (!this.isUniversalSyntax && (this.initialValue == null || this.initialValue.matches(this.syntax) != CSSValueSyntax.Match.TRUE || this.initialValue.getLexicalUnitType() == LexicalUnit.LexicalType.DIMENSION && CSSUnit.isRelativeLengthUnitType(this.initialValue.getCssUnit()))) {
                    this.handleError(index, (byte)33, "@property rule lacks a valid 'initial-value' descriptor.");
                    CSSParser.this.handler.endProperty(true);
                } else {
                    CSSParser.this.handler.endProperty(false);
                }
                SheetTokenHandler.this.endRuleBody();
            }
        }

        private class MyMediaQueryTokenHandler
        extends MediaQueryTokenHandler {
            MyMediaQueryTokenHandler(MediaQueryFactory conditionFactory, MediaQueryHandler mqhandler) {
                super(conditionFactory, mqhandler);
                mqhandler.startQuery();
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            void endOfCondition(int index) {
                super.endOfCondition(index);
                MediaQueryList mql = this.getPredicateHandler().getMediaQueryHandler().getMediaQueryList();
                SheetTokenHandler.this.currentCondition = new ConditionWrapper(mql, SheetTokenHandler.this.currentCondition);
                CSSParser.this.handler.startMedia(SheetTokenHandler.this.currentCondition.getMediaList());
                SheetTokenHandler.this.setSelectorHandler();
            }

            @Override
            void handleLeftCurlyBracket(int index) {
                this.endOfCondition(index);
                SheetTokenHandler.this.curlyBracketDepth++;
            }

            @Override
            public void endOfStream(int len) {
                this.handleError(len, (byte)10, "Unexpected end of stream");
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MyIgnoredDeclarationTokenHandler
        extends IgnoredDeclarationTokenHandler {
            MyIgnoredDeclarationTokenHandler() {
            }

            @Override
            protected void endDeclarationBlock() {
                SheetTokenHandler.this.setSelectorHandler(125);
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            public void endOfStream(int len) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }
        }

        private class MyDeclarationRuleTokenHandler
        extends DeclarationRuleTokenHandler {
            MyDeclarationRuleTokenHandler(ShorthandDatabase propertyDatabase) {
                super(propertyDatabase);
                this.setStage((byte)2);
            }

            @Override
            void setCurrentLocation(int index) {
                SheetTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void tokenStart(TokenControl control) {
                SheetTokenHandler.this.tokenStart(control);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void skipDeclarationBlock() {
                SheetTokenHandler.this.contextHandler = new MyIgnoredDeclarationTokenHandler();
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            protected void endDeclarationList() {
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class AtRuleLauncherTH
        extends ControlTokenHandler {
            private AtRuleLauncherTH() {
            }

            public void word(int index, CharSequence word) {
                SheetTokenHandler.this.buffer.append(word);
                SheetTokenHandler.this.prevcp = 65;
            }

            public void separator(int index, int codePoint) {
                if (SheetTokenHandler.this.isPrevCpWhitespace()) {
                    if (SheetTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(SheetTokenHandler.this.buffer)) {
                        SheetTokenHandler.this.buffer.append(' ');
                    } else {
                        SheetTokenHandler.this.startNewRule(index);
                    }
                } else {
                    SheetTokenHandler.this.setWhitespacePrevCp();
                    if (SheetTokenHandler.this.escapedTokenIndex == -1 || !CSSParser.bufferEndsWithEscapedChar(SheetTokenHandler.this.buffer)) {
                        SheetTokenHandler.this.startNewRule(index);
                    } else {
                        SheetTokenHandler.this.buffer.append(' ');
                    }
                }
            }

            public void quoted(int index, CharSequence quoted, int quote) {
                this.handleError(index, (byte)9, "Unexpected token: " + quote + quoted + quote);
            }

            public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
                this.quoted(index, quoted, quoteCp);
            }

            public void leftParenthesis(int index) {
                SheetTokenHandler.this.startNewRule(index);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.leftParenthesis(index);
                } else {
                    SheetTokenHandler.this.leftParenthesis(index);
                }
            }

            public void leftSquareBracket(int index) {
                this.unexpectedCharError(index, 91);
            }

            public void leftCurlyBracket(int index) {
                SheetTokenHandler.this.startNewRule(index);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.leftCurlyBracket(index);
                } else {
                    SheetTokenHandler.this.leftCurlyBracket(index);
                }
            }

            public void rightParenthesis(int index) {
                this.unexpectedCharError(index, 41);
            }

            public void rightSquareBracket(int index) {
                this.unexpectedCharError(index, 93);
            }

            public void rightCurlyBracket(int index) {
                this.unexpectedCharError(index, 125);
            }

            public void character(int index, int codePoint) {
                SheetTokenHandler.this.startNewRule(index);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.character(index, codePoint);
                } else {
                    SheetTokenHandler.this.character(index, codePoint);
                }
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                SheetTokenHandler.this.startNewRule(index);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.commented(index, commentType, comment);
                } else {
                    SheetTokenHandler.this.commented(index, commentType, comment);
                }
            }

            public void escaped(int index, int codePoint) {
                if (ParseHelper.isHexCodePoint(codePoint) || codePoint == 92) {
                    SheetTokenHandler.this.setEscapedTokenStart(index);
                    SheetTokenHandler.this.buffer.append('\\');
                }
                SheetTokenHandler.this.buffer.appendCodePoint(codePoint);
                SheetTokenHandler.this.prevcp = 65;
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            public void endOfStream(int len) {
                this.handleError(len, (byte)10, "Unexpected end of stream");
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            protected void handleError(CSSParseException ex) throws CSSParseException {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.handleError(ex);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }
    }

    class DeclarationTokenHandler
    extends ControlTokenHandler {
        private LexicalUnitImpl lunit;
        private LexicalUnitImpl currentlu;
        String propertyName;
        private final ShorthandDatabase propertyDatabase;
        private boolean hexColor;
        private boolean unicodeRange;
        private boolean readPriority;
        private boolean priorityImportant;
        int curlyBracketDepth;
        private int squareBracketDepth;
        private boolean functionToken;
        private final boolean flagIEValues;

        DeclarationTokenHandler(ShorthandDatabase propertyDatabase) {
            this(propertyDatabase, 1);
        }

        DeclarationTokenHandler(int currentLine, int prevLineLength) {
            super(currentLine, prevLineLength);
            this.lunit = null;
            this.currentlu = null;
            this.propertyName = null;
            this.hexColor = false;
            this.unicodeRange = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.functionToken = false;
            this.curlyBracketDepth = 1;
            this.flagIEValues = CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEVALUES);
            this.buffer = new StringBuilder(128);
            this.propertyDatabase = null;
        }

        DeclarationTokenHandler(ShorthandDatabase propertyDatabase, int initialCurlyBracketDepth) {
            this.lunit = null;
            this.currentlu = null;
            this.propertyName = null;
            this.hexColor = false;
            this.unicodeRange = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.functionToken = false;
            this.curlyBracketDepth = initialCurlyBracketDepth;
            this.flagIEValues = CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEVALUES);
            this.buffer = new StringBuilder(128);
            this.propertyDatabase = propertyDatabase;
        }

        LexicalUnit getLexicalUnit() {
            return this.parseError ? null : this.lunit;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        boolean allowSemicolonArgument() {
            return "switch".equalsIgnoreCase(this.currentlu.value);
        }

        public void word(int index, CharSequence word) {
            if (!this.parseError) {
                this.addWord(index, word);
            }
            this.prevcp = 65;
        }

        void addWord(int index, CharSequence word) {
            if (this.prevcp == 92) {
                this.buffer.append('\\');
            }
            this.buffer.append(word);
        }

        public void leftParenthesis(int index) {
            this.parendepth = (short)(this.parendepth + 1);
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(index, 40);
            } else if (!this.parseError) {
                if (this.prevcp != 65) {
                    if (!this.functionToken) {
                        this.unexpectedCharError(index, 40);
                        this.prevcp = 40;
                    } else if (this.buffer.length() == 0) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.SUB_EXPRESSION, true);
                    } else {
                        this.handleError(index, (byte)9, "Unexpected token: " + this.buffer.toString());
                        this.buffer.setLength(0);
                    }
                    this.prevcp = 40;
                } else {
                    this.newFunction(index);
                    this.prevcp = 32;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void newFunction(int index) {
            if (this.functionToken && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.URI) {
                this.buffer.setLength(0);
                this.escapedTokenIndex = -1;
                this.unexpectedCharError(index, 40);
                return;
            }
            String name = this.unescapeStringValue(index);
            String lcName = name.toLowerCase(Locale.ROOT);
            LexicalUnitFactory factory = FunctionFactories.getFactory(lcName);
            if (factory == null) {
                if (name.isEmpty()) {
                    this.handleError(index, (byte)5, "Unexpected character '('.");
                    this.buffer.setLength(0);
                    this.escapedTokenIndex = -1;
                    return;
                }
                String raw = this.buffer.toString();
                if (!this.isNotForbiddenIdentStart(raw)) {
                    this.handleError(index, (byte)5, "Unexpected: " + raw);
                    this.buffer.setLength(0);
                    this.escapedTokenIndex = -1;
                    return;
                }
                LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.FUNCTION, true);
                lu.value = name;
                this.functionToken = true;
            } else {
                LexicalUnitImpl lu = factory.createUnit();
                if (this.functionToken) {
                    this.currentlu.addFunctionParameter(lu);
                    this.currentlu = lu;
                } else {
                    if (this.currentlu != null) {
                        this.currentlu.nextLexicalUnit = lu;
                        lu.previousLexicalUnit = this.currentlu;
                    }
                    this.currentlu = lu;
                    if (this.lunit == null) {
                        this.lunit = lu;
                    }
                    this.functionToken = true;
                }
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.URI && lu.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE) {
                    lu.value = name;
                }
            }
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
        }

        public void leftCurlyBracket(int index) {
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(index, 123);
            } else if (!this.parseError) {
                this.handleLeftCurlyBracket(index);
            } else {
                this.skipDeclaration(index);
            }
            this.prevcp = 123;
        }

        protected void handleLeftCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '{'");
            this.skipDeclaration(index);
        }

        protected void skipDeclaration(int index) {
            CallbackIgnoredDeclarationTH ignoreth = new CallbackIgnoredDeclarationTH(this.getTokenControl());
            this.getTokenControl().setTokenHandler((TokenHandler3)ignoreth);
        }

        public void leftSquareBracket(int index) {
            ++this.squareBracketDepth;
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(index, 91);
            } else if (!this.parseError) {
                if (this.propertyName != null) {
                    this.processBuffer(index);
                    this.newLexicalUnit(LexicalUnit.LexicalType.LEFT_BRACKET, false);
                    this.prevcp = 32;
                } else {
                    this.unexpectedCharError(index, 91);
                }
            }
        }

        private LexicalUnitImpl newLexicalUnit(LexicalUnit.LexicalType unitType, boolean functionOrSubexpression) {
            LexicalUnitImpl lu;
            if (this.functionToken) {
                if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.URI && unitType != LexicalUnit.LexicalType.VAR) {
                    lu = this.currentlu;
                } else {
                    lu = new LexicalUnitImpl(unitType);
                    this.currentlu.addFunctionParameter(lu);
                    if (functionOrSubexpression) {
                        this.currentlu = lu;
                    }
                }
            } else {
                lu = new LexicalUnitImpl(unitType);
                if (this.currentlu != null) {
                    this.currentlu.nextLexicalUnit = lu;
                    lu.previousLexicalUnit = this.currentlu;
                }
                this.currentlu = lu;
                if (this.lunit == null) {
                    this.lunit = lu;
                }
            }
            return lu;
        }

        private SyntaxUnitImpl newSyntaxUnit() {
            assert (this.functionToken);
            SyntaxUnitImpl lu = new SyntaxUnitImpl();
            this.currentlu.addFunctionParameter(lu);
            return lu;
        }

        public void rightParenthesis(int index) {
            this.processBuffer(index);
            this.decrParenDepth(index);
            if (this.functionToken) {
                this.checkFunction(index);
                if (this.currentlu.ownerLexicalUnit != null) {
                    this.currentlu = this.currentlu.ownerLexicalUnit;
                } else {
                    this.functionToken = false;
                }
            }
            this.prevcp = 41;
        }

        private void checkFunction(int index) {
            String s;
            LexicalUnit.LexicalType type = this.currentlu.getLexicalUnitType();
            if (this.currentlu.parameters == null) {
                switch (type) {
                    case FUNCTION: 
                    case ELEMENT_REFERENCE: {
                        break;
                    }
                    case URI: {
                        if (this.currentlu.isParameter() || this.parendepth == 0) break;
                    }
                    default: {
                        this.unexpectedCharError(index, 41);
                    }
                }
                return;
            }
            if (!this.isVarOrLastParamIsOperand()) {
                this.unexpectedCharError(index, 41);
                return;
            }
            switch (type) {
                case RGBCOLOR: {
                    if (!this.isValidRGBColor(index)) break;
                    return;
                }
                case HSLCOLOR: {
                    if (!this.isValidHSLColor(index)) break;
                    return;
                }
                case LABCOLOR: {
                    if (!this.isValidLABColor(index, 100, 100.0f)) break;
                    return;
                }
                case OKLABCOLOR: {
                    if (!this.isValidLABColor(index, 1, 1.0f)) break;
                    return;
                }
                case LCHCOLOR: {
                    if (!this.isValidLCHColor(index, 100, 100.0f)) break;
                    return;
                }
                case OKLCHCOLOR: {
                    if (!this.isValidLCHColor(index, 1, 1.0f)) break;
                    return;
                }
                case HWBCOLOR: {
                    if (!this.isValidHWBColor(index)) break;
                    return;
                }
                case COLOR_FUNCTION: {
                    if (!this.isValidColorFunction(index)) break;
                    return;
                }
                case COLOR_MIX: {
                    if (!this.isValidColorMixFunction()) break;
                    return;
                }
                case VAR: {
                    s = this.currentlu.parameters.getStringValue();
                    if (s == null) break;
                    if (s.length() < 3 || s.charAt(0) != '-' || s.charAt(1) != '-') {
                        index -= s.length();
                        break;
                    }
                    LexicalUnit.LexicalType lastType = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
                    if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        LexicalUnitImpl empty = this.newLexicalUnit(LexicalUnit.LexicalType.EMPTY, false);
                        empty.value = "";
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                s = "Wrong color: " + this.currentlu.toString();
            }
            catch (Exception e) {
                s = "Wrong color.";
            }
            this.handleError(index, (byte)5, s);
        }

        private boolean isVarOrLastParamIsOperand() {
            if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                return true;
            }
            LexicalUnit.LexicalType type = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return type != LexicalUnit.LexicalType.OPERATOR_COMMA && !this.typeIsAlgebraicOperator(type);
        }

        private boolean lastParamIsAlgebraicOperator() {
            LexicalUnit.LexicalType type = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return this.typeIsAlgebraicOperator(type);
        }

        private boolean typeIsAlgebraicOperator(LexicalUnit.LexicalType type) {
            return type == LexicalUnit.LexicalType.OPERATOR_PLUS || type == LexicalUnit.LexicalType.OPERATOR_MINUS || type == LexicalUnit.LexicalType.OPERATOR_MULTIPLY || type == LexicalUnit.LexicalType.OPERATOR_SLASH;
        }

        private boolean lastParamIsMultOrSlashOperator() {
            LexicalUnit.LexicalType type = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return type == LexicalUnit.LexicalType.OPERATOR_MULTIPLY || type == LexicalUnit.LexicalType.OPERATOR_SLASH;
        }

        private boolean isValidRGBColor(int index) {
            LexicalUnitImpl lu = this.currentlu.parameters;
            int valCount = 0;
            LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
            boolean hasCommas = false;
            boolean hasNoCommas = false;
            boolean hasVar = false;
            do {
                LexicalUnit.LexicalType type;
                if ((type = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA || lastType == LexicalUnit.LexicalType.UNKNOWN || hasNoCommas) {
                        return false;
                    }
                    hasCommas = true;
                } else if (this.isComponentType(type)) {
                    if (type == LexicalUnit.LexicalType.VAR) {
                        hasVar = true;
                    }
                    if (type == LexicalUnit.LexicalType.INTEGER) {
                        int value = lu.getIntegerValue();
                        if (value < 0) {
                            lu.intValue = 0;
                            this.handleWarning(index, (byte)-5, "Color component has value under 0.");
                        } else if (valCount == 3 && value > 1) {
                            lu.intValue = 1;
                            this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                        }
                        if (value > 255) {
                            this.handleWarning(index, (byte)-5, "Color component has value over 255.");
                        }
                    } else if (type == LexicalUnit.LexicalType.REAL) {
                        float value = lu.getFloatValue();
                        if (value < 0.0f) {
                            lu.floatValue = 0.0f;
                            this.handleWarning(index, (byte)-5, "Color component has value under 0.");
                        }
                        if (valCount == 3) {
                            if (value > 1.0f) {
                                lu.floatValue = 1.0f;
                                this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                            }
                        } else if (lastType != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            type = LexicalUnit.LexicalType.INTEGER;
                        }
                        if (value > 255.0f) {
                            this.handleWarning(index, (byte)-5, "Color component has value over 255.");
                        }
                    } else if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                        float value = lu.getFloatValue();
                        if (value < 0.0f) {
                            lu.floatValue = 0.0f;
                            this.handleWarning(index, (byte)-5, "Color component has percentage under 0%.");
                        } else if (value > 100.0f) {
                            lu.floatValue = 100.0f;
                            this.handleWarning(index, (byte)-5, "Color component has percentage over 100%.");
                        }
                    } else if (type == LexicalUnit.LexicalType.IDENT) {
                        if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                            return false;
                        }
                        type = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                    if (hasCommas) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else if (lastType != type) {
                        if (valCount == 3 && lastType != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            return false;
                        }
                    } else {
                        hasNoCommas = true;
                    }
                    valCount = (short)(valCount + 1);
                } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    if (hasVar && valCount < 3) {
                        valCount = 3;
                    }
                    if (valCount == 4 || valCount < 3 || !this.isComponentType(lastType) || hasCommas) {
                        return false;
                    }
                    hasNoCommas = true;
                } else {
                    return false;
                }
                lastType = type;
            } while ((lu = lu.nextLexicalUnit) != null);
            return valCount == 3 || valCount == 4 || valCount < 3 && hasVar;
        }

        private boolean isComponentType(LexicalUnit.LexicalType type) {
            return type == LexicalUnit.LexicalType.INTEGER || type == LexicalUnit.LexicalType.PERCENTAGE || type == LexicalUnit.LexicalType.REAL || type == LexicalUnit.LexicalType.VAR || type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR;
        }

        private boolean isValidHSLColor(int index) {
            LexicalUnitImpl lu = this.currentlu.parameters;
            int slaCount = 0;
            LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
            boolean hasCommas = false;
            boolean hasNoCommas = false;
            boolean hasVar = false;
            do {
                LexicalUnit.LexicalType type;
                if ((type = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.PERCENTAGE || (type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR) && this.isPercentageUnit(lu)) {
                    if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    if (hasCommas) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else {
                        boolean bl = hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                    }
                    if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                        float value = lu.getFloatValue();
                        if (value < 0.0f) {
                            lu.floatValue = 0.0f;
                            this.handleWarning(index, (byte)-5, "Color component has value under 0%.");
                        } else if (value > 100.0f) {
                            lu.floatValue = 100.0f;
                            this.handleWarning(index, (byte)-5, "Color component has value over 100%.");
                        }
                    } else {
                        type = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                    slaCount = (short)(slaCount + 1);
                } else if (type == LexicalUnit.LexicalType.REAL) {
                    if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                        slaCount = (short)(slaCount + 1);
                        float value = lu.getFloatValue();
                        if (value < 0.0f) {
                            lu.floatValue = 0.0f;
                            this.handleWarning(index, (byte)-5, "Color component has value under 0.");
                        } else if (lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            if (value > 1.0f) {
                                lu.floatValue = 1.0f;
                                this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                            }
                        } else if (value > 100.0f) {
                            lu.floatValue = 100.0f;
                            this.handleWarning(index, (byte)-5, "Color component has value over 100%.");
                        }
                        if (hasCommas) {
                            if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                return false;
                            }
                        } else {
                            hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                        }
                    }
                } else if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA || lastType == LexicalUnit.LexicalType.UNKNOWN || hasNoCommas) {
                        return false;
                    }
                    hasCommas = true;
                } else if (type == LexicalUnit.LexicalType.INTEGER) {
                    if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                        int value = lu.getIntegerValue();
                        if (value < 0) {
                            lu.intValue = 0;
                            this.handleWarning(index, (byte)-5, "Color component has value under 0%.");
                        } else if (value > 100) {
                            lu.intValue = 100;
                            this.handleWarning(index, (byte)-5, "Color component has value over 100%.");
                        }
                        if (value > 1 && lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            lu.intValue = 1;
                        }
                        slaCount = (short)(slaCount + 1);
                        type = LexicalUnit.LexicalType.PERCENTAGE;
                        if (hasCommas) {
                            if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                return false;
                            }
                        } else {
                            hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                        }
                    }
                } else if (this.isAngleUnit(lu)) {
                    if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    type = LexicalUnit.LexicalType.EXT1;
                } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    if (slaCount != 2 && !hasVar || hasVar && slaCount > 2 || lastType != LexicalUnit.LexicalType.PERCENTAGE && lastType != LexicalUnit.LexicalType.REAL && lastType != LexicalUnit.LexicalType.VAR || hasCommas) {
                        return false;
                    }
                } else if (type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR) {
                    if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                        type = LexicalUnit.LexicalType.INTEGER;
                    } else if (lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        type = LexicalUnit.LexicalType.REAL;
                        slaCount = (short)(slaCount + 1);
                    } else {
                        if (hasCommas) {
                            if (lastType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                return false;
                            }
                        } else {
                            hasNoCommas = hasNoCommas || lastType == LexicalUnit.LexicalType.REAL || lastType == LexicalUnit.LexicalType.PERCENTAGE || lastType == LexicalUnit.LexicalType.INTEGER || lastType == LexicalUnit.LexicalType.EXT1;
                        }
                        slaCount = (short)(slaCount + 1);
                        type = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                } else if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else if (type == LexicalUnit.LexicalType.IDENT) {
                    if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                    slaCount = (short)(slaCount + 1);
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                } else {
                    return false;
                }
                lastType = type;
            } while ((lu = lu.nextLexicalUnit) != null);
            return slaCount == 2 || slaCount == 3 || hasVar && slaCount < 2;
        }

        private boolean isValidHWBColor(int index) {
            LexicalUnitImpl lu = this.currentlu.parameters;
            int pcntCount = 0;
            LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
            boolean hasVar = false;
            do {
                float value;
                LexicalUnit.LexicalType type;
                if ((type = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.PERCENTAGE) {
                    if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    pcntCount = (short)(pcntCount + 1);
                    value = lu.getFloatValue();
                    if (value < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.handleWarning(index, (byte)-5, "Color component has value under 0%.");
                    } else if (value > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.handleWarning(index, (byte)-5, "Color component has value over 100%.");
                    }
                } else if (type == LexicalUnit.LexicalType.INTEGER) {
                    if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_SLASH || pcntCount < 2 && !hasVar) {
                            return false;
                        }
                        int value2 = lu.getIntegerValue();
                        if (value2 < 0) {
                            lu.intValue = 0;
                            this.handleWarning(index, (byte)-5, "Color alpha has value under 0.");
                        } else if (value2 > 1) {
                            lu.intValue = 1;
                            this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                        }
                    }
                } else if (this.isAngleUnit(lu)) {
                    if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    type = LexicalUnit.LexicalType.EXT1;
                } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    if (pcntCount != 2 && !hasVar || hasVar && pcntCount > 2 || lastType != LexicalUnit.LexicalType.PERCENTAGE && lastType != LexicalUnit.LexicalType.VAR) {
                        return false;
                    }
                } else if (type == LexicalUnit.LexicalType.REAL) {
                    if (lastType != LexicalUnit.LexicalType.UNKNOWN) {
                        if (lastType != LexicalUnit.LexicalType.OPERATOR_SLASH || pcntCount != 2 && !hasVar || hasVar && pcntCount > 2) {
                            return false;
                        }
                        pcntCount = 3;
                        value = lu.getFloatValue();
                        if (value < 0.0f) {
                            lu.floatValue = 0.0f;
                            this.handleWarning(index, (byte)-5, "Color alpha has value under 0.");
                        } else if (value > 1.0f) {
                            lu.floatValue = 1.0f;
                            this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                        }
                    }
                } else if (type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR) {
                    if (lastType == LexicalUnit.LexicalType.UNKNOWN) {
                        type = LexicalUnit.LexicalType.INTEGER;
                    } else if (lastType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        type = LexicalUnit.LexicalType.REAL;
                        pcntCount = 3;
                    } else {
                        pcntCount = (short)(pcntCount + 1);
                        type = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                } else if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else if (type == LexicalUnit.LexicalType.IDENT) {
                    if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                    pcntCount = (short)(pcntCount + 1);
                    type = LexicalUnit.LexicalType.PERCENTAGE;
                } else {
                    return false;
                }
                lastType = type;
            } while ((lu = lu.nextLexicalUnit) != null);
            return pcntCount >= 2 || hasVar && pcntCount <= 1;
        }

        private boolean isAngleUnit(LexicalUnit lu) {
            short unit = lu.getCssUnit();
            if (!CSSUnit.isAngleUnitType(unit)) {
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    return false;
                }
                LexicalUnit lunit = lu.getNextLexicalUnit() == null ? lu : lu.shallowClone();
                return lunit.matches(SyntaxParser.createSimpleSyntax("angle")) == CSSValueSyntax.Match.TRUE;
            }
            return true;
        }

        private boolean isPercentageUnit(LexicalUnit unit) {
            LexicalUnit lunit = unit.getNextLexicalUnit() == null ? unit : unit.shallowClone();
            return lunit.matches(SyntaxParser.createSimpleSyntax("percentage")) == CSSValueSyntax.Match.TRUE;
        }

        private boolean isValidLABColor(int index, int iUpperLightness, float fUpperLightness) {
            LexicalUnitImpl lu = this.currentlu.parameters;
            boolean hasVar = false;
            if (lu == null) {
                return false;
            }
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                float fL = lu.getFloatValue();
                if (fL < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.handleWarning(index, (byte)-5, "Color lightness has percentage under 0%.");
                } else if (fL > 100.0f) {
                    lu.floatValue = 100.0f;
                    this.handleWarning(index, (byte)-5, "Color lightness has percentage over 100%.");
                }
            } else if (type == LexicalUnit.LexicalType.REAL) {
                float fL = lu.getFloatValue();
                if (fL < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.handleWarning(index, (byte)-5, "Color lightness has value under 0.");
                } else if (fL > fUpperLightness) {
                    lu.floatValue = fUpperLightness;
                    this.handleWarning(index, (byte)-5, "Color lightness has value over " + fUpperLightness);
                }
            } else if (type == LexicalUnit.LexicalType.INTEGER) {
                int iL = lu.getIntegerValue();
                if (iL < 0) {
                    lu.intValue = 0;
                    this.handleWarning(index, (byte)-5, "Color lightness has value under 0.");
                } else if (iL > iUpperLightness) {
                    lu.intValue = iUpperLightness;
                    this.handleWarning(index, (byte)-5, "Color lightness has value over " + iUpperLightness);
                }
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
                return false;
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
            int numericValueCount = 1;
            block7: do {
                type = lu.getLexicalUnitType();
                switch (type) {
                    case IDENT: {
                        if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                            return false;
                        }
                    }
                    case FUNCTION: 
                    case REAL: 
                    case INTEGER: 
                    case CALC: 
                    case MATH_FUNCTION: 
                    case ATTR: {
                        if (++numericValueCount <= 3) continue block7;
                        if (!hasVar || numericValueCount > 4) {
                            return false;
                        }
                        return this.isValidAlpha(index, lu);
                    }
                    case OPERATOR_SLASH: {
                        lu = lu.nextLexicalUnit;
                        if (lu == null || numericValueCount > 3 || numericValueCount < 3 && !hasVar) {
                            return false;
                        }
                        return this.isValidAlpha(index, lu);
                    }
                    case PERCENTAGE: {
                        if (++numericValueCount > 3) {
                            if (!hasVar || numericValueCount > 4) {
                                return false;
                            }
                            return this.isValidAlpha(index, lu);
                        }
                        if (hasVar) continue block7;
                        float fval = lu.getFloatValue();
                        if (fval < -100.0f) {
                            lu.floatValue = -100.0f;
                            this.handleWarning(index, (byte)-5, "Color component has percentage under -100%.");
                            break;
                        }
                        if (!(fval > 100.0f)) continue block7;
                        lu.floatValue = 100.0f;
                        this.handleWarning(index, (byte)-5, "Color component has percentage over 100%.");
                        break;
                    }
                    case VAR: {
                        hasVar = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } while ((lu = lu.nextLexicalUnit) != null);
            return numericValueCount == 3 || numericValueCount == 4 || hasVar && numericValueCount < 3;
        }

        private boolean isValidLCHColor(int index, int iUpperLightness, float fUpperLightness) {
            LexicalUnitImpl lu = this.currentlu.parameters;
            boolean hasVar = false;
            if (lu == null) {
                return false;
            }
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                float fL = lu.getFloatValue();
                if (fL < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.handleWarning(index, (byte)-5, "Color lightness has percentage under 0%.");
                } else if (fL > 100.0f) {
                    lu.floatValue = 100.0f;
                    this.handleWarning(index, (byte)-5, "Color lightness has percentage over 100%.");
                }
            } else if (type == LexicalUnit.LexicalType.REAL) {
                float fL = lu.getFloatValue();
                if (fL < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.handleWarning(index, (byte)-5, "Color lightness has value under 0.");
                } else if (fL > fUpperLightness) {
                    lu.floatValue = fUpperLightness;
                    this.handleWarning(index, (byte)-5, "Color lightness has value over " + fUpperLightness);
                }
            } else if (type == LexicalUnit.LexicalType.INTEGER) {
                int iL = lu.getIntegerValue();
                if (iL < 0) {
                    lu.intValue = 0;
                    this.handleWarning(index, (byte)-5, "Color lightness has value under 0.");
                } else if (iL > iUpperLightness) {
                    lu.intValue = iUpperLightness;
                    this.handleWarning(index, (byte)-5, "Color lightness has value over " + iUpperLightness);
                }
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
                return false;
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                float fC = lu.getFloatValue();
                if (fC < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.handleWarning(index, (byte)-5, "Color chroma has percentage under 0.");
                } else if (fC > 100.0f) {
                    lu.floatValue = 100.0f;
                    this.handleWarning(index, (byte)-5, "Color chroma has percentage over 100.");
                }
            } else if (type == LexicalUnit.LexicalType.REAL) {
                float fC;
                if (!hasVar && (fC = lu.getFloatValue()) < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.handleWarning(index, (byte)-5, "Color component has value under 0.");
                }
            } else if (type == LexicalUnit.LexicalType.INTEGER) {
                int iC;
                if (!hasVar && (iC = lu.getIntegerValue()) < 0) {
                    lu.intValue = 0;
                    this.handleWarning(index, (byte)-5, "Color component has value under 0.");
                }
            } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
                if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else if (hasVar) {
                    if (!CSSUnit.isAngleUnitType(lu.getCssUnit())) {
                        if (type == LexicalUnit.LexicalType.OPERATOR_SLASH && (lu = lu.nextLexicalUnit) == null) {
                            return false;
                        }
                        return this.isValidAlpha(index, lu);
                    }
                } else {
                    return false;
                }
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
            if (!(type == LexicalUnit.LexicalType.REAL || type == LexicalUnit.LexicalType.INTEGER || this.isAngleUnit(lu) || type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lu.getStringValue()))) {
                if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else {
                    if (hasVar) {
                        if (type == LexicalUnit.LexicalType.OPERATOR_SLASH && (lu = lu.nextLexicalUnit) == null) {
                            return false;
                        }
                        return this.isValidAlpha(index, lu);
                    }
                    return false;
                }
            }
            if ((lu = lu.nextLexicalUnit) != null) {
                type = lu.getLexicalUnitType();
                if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    lu = lu.nextLexicalUnit;
                    if (lu == null) {
                        return false;
                    }
                } else {
                    if (type == LexicalUnit.LexicalType.VAR) {
                        lu = lu.nextLexicalUnit;
                        while (lu != null) {
                            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                                return this.isValidAlpha(index, lu);
                            }
                            lu = lu.nextLexicalUnit;
                        }
                        return true;
                    }
                    if (!hasVar) {
                        return false;
                    }
                }
                return this.isValidAlpha(index, lu);
            }
            return true;
        }

        private boolean isValidColorFunction(int index) {
            LexicalUnitImpl lu = this.currentlu.parameters;
            if (lu == null) {
                return false;
            }
            boolean hasVar = false;
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type != LexicalUnit.LexicalType.IDENT) {
                if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else {
                    return false;
                }
            }
            if ((lu = lu.nextLexicalUnit) == null) {
                return hasVar;
            }
            boolean foundNumericValue = false;
            do {
                type = lu.getLexicalUnitType();
                switch (type) {
                    case IDENT: {
                        if (!"none".equalsIgnoreCase(lu.getStringValue())) {
                            return false;
                        }
                    }
                    case VAR: 
                    case REAL: 
                    case INTEGER: 
                    case CALC: 
                    case PERCENTAGE: {
                        foundNumericValue = true;
                        break;
                    }
                    case OPERATOR_SLASH: {
                        if (!foundNumericValue && !hasVar) {
                            return false;
                        }
                        lu = lu.nextLexicalUnit;
                        if (lu == null) {
                            return false;
                        }
                        return this.isValidAlpha(index, lu);
                    }
                    case FUNCTION: 
                    case MATH_FUNCTION: 
                    case ATTR: {
                        LexicalUnitImpl lunit = lu.getNextLexicalUnit() == null ? lu : lu.shallowClone();
                        CSSValueSyntax syn = new SyntaxParser().parseSyntax("<number> | <percentage>");
                        foundNumericValue = lunit.matches(syn) != CSSValueSyntax.Match.FALSE;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } while ((lu = lu.nextLexicalUnit) != null);
            return true;
        }

        private boolean isValidAlpha(int index, LexicalUnitImpl lu) {
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            switch (type) {
                case INTEGER: {
                    int iAlpha = lu.getIntegerValue();
                    if (iAlpha < 0) {
                        lu.intValue = 0;
                        this.handleWarning(index, (byte)-5, "Color alpha has value under 0.");
                        break;
                    }
                    if (iAlpha <= 1) break;
                    lu.intValue = 1;
                    this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                    break;
                }
                case REAL: {
                    float fAlpha = lu.getFloatValue();
                    if (fAlpha < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.handleWarning(index, (byte)-5, "Color alpha has value under 0.");
                        break;
                    }
                    if (!(fAlpha > 1.0f)) break;
                    lu.floatValue = 1.0f;
                    this.handleWarning(index, (byte)-5, "Color alpha has value over 1.");
                    break;
                }
                case PERCENTAGE: {
                    float fAlpha = lu.getFloatValue();
                    if (fAlpha < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.handleWarning(index, (byte)-5, "Color alpha has value under 0%.");
                        break;
                    }
                    if (!(fAlpha > 100.0f)) break;
                    lu.floatValue = 100.0f;
                    this.handleWarning(index, (byte)-5, "Color alpha has value over 100%.");
                    break;
                }
                case IDENT: {
                    if ("none".equalsIgnoreCase(lu.getStringValue())) break;
                    return false;
                }
                case FUNCTION: 
                case VAR: 
                case CALC: 
                case MATH_FUNCTION: 
                case ATTR: {
                    break;
                }
                default: {
                    return false;
                }
            }
            lu = lu.nextLexicalUnit;
            while (lu != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                    return false;
                }
                lu = lu.nextLexicalUnit;
            }
            return true;
        }

        private boolean isValidColorMixFunction() {
            boolean lastTypeIsComma;
            LexicalUnit lu = this.currentlu.parameters;
            if (lu == null) {
                return false;
            }
            boolean hasVar = false;
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type != LexicalUnit.LexicalType.IDENT) {
                if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else if (type != LexicalUnit.LexicalType.ATTR) {
                    return false;
                }
            } else if (!"in".equalsIgnoreCase(lu.getStringValue())) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
            if (lu == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
            if (type != LexicalUnit.LexicalType.IDENT) {
                if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else if (type != LexicalUnit.LexicalType.ATTR) {
                    return hasVar;
                }
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
            boolean bl = lastTypeIsComma = type == LexicalUnit.LexicalType.OPERATOR_COMMA;
            if (!lastTypeIsComma) {
                if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.ATTR) {
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        return hasVar;
                    }
                    type = lu.getLexicalUnitType();
                    if (type == LexicalUnit.LexicalType.IDENT) {
                        if (!hasVar && !"hue".equalsIgnoreCase(lu.getStringValue())) {
                            return false;
                        }
                        if ((lu = lu.getNextLexicalUnit()) == null) {
                            return hasVar;
                        }
                        type = lu.getLexicalUnitType();
                    }
                    lastTypeIsComma = type == LexicalUnit.LexicalType.OPERATOR_COMMA;
                } else if (type == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                } else if (!hasVar) {
                    return false;
                }
            }
            if (lastTypeIsComma) {
                lu = lu.getNextLexicalUnit();
            }
            if (lu == null) {
                return !lastTypeIsComma && hasVar;
            }
            CSSValueSyntax synColor = new SyntaxParser().parseSyntax("<color>");
            LexicalUnit.LexicalType uType = lu.getLexicalUnitType();
            if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION) {
                if ((lu = lu.getNextLexicalUnit()) == null || this.cannotBeColor(lu, synColor)) {
                    return false;
                }
                lu = lu.getNextLexicalUnit();
            } else if (uType == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
                lu = lu.getNextLexicalUnit();
            } else {
                if (this.cannotBeColor(lu, synColor)) {
                    return false;
                }
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    return hasVar;
                }
                uType = lu.getLexicalUnitType();
                if (uType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    switch (uType) {
                        case VAR: {
                            hasVar = true;
                        }
                        case FUNCTION: 
                        case CALC: 
                        case MATH_FUNCTION: 
                        case ATTR: 
                        case PERCENTAGE: {
                            lu = lu.getNextLexicalUnit();
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            if (lu == null) {
                return hasVar;
            }
            uType = lu.getLexicalUnitType();
            if (uType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                return hasVar && (!this.cannotBeColor(lu, synColor) || uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION || uType == LexicalUnit.LexicalType.VAR);
            }
            uType = (lu = lu.getNextLexicalUnit()).getLexicalUnitType();
            if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION) {
                if ((lu = lu.getNextLexicalUnit()) == null || this.cannotBeColor(lu, synColor)) {
                    return false;
                }
                lu = lu.getNextLexicalUnit();
            } else if (uType == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
                lu = lu.getNextLexicalUnit();
            } else {
                if (this.cannotBeColor(lu, synColor)) {
                    return false;
                }
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    return true;
                }
                uType = lu.getLexicalUnitType();
                if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.FUNCTION || uType == LexicalUnit.LexicalType.VAR || uType == LexicalUnit.LexicalType.ATTR) {
                    lu = lu.getNextLexicalUnit();
                } else {
                    return false;
                }
            }
            while (lu != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                    return false;
                }
                lu = lu.getNextLexicalUnit();
            }
            return true;
        }

        private boolean cannotBeColor(LexicalUnit lu, CSSValueSyntax syn) {
            LexicalUnit lunit = lu.getNextLexicalUnit() == null ? lu : lu.shallowClone();
            return lunit.matches(syn) == CSSValueSyntax.Match.FALSE;
        }

        public void rightCurlyBracket(int index) {
            if (this.parendepth != 0 || this.squareBracketDepth != 0) {
                this.parseError = true;
                this.parendepth = 0;
                this.squareBracketDepth = 0;
            }
            if (this.curlyBracketDepth == 1) {
                this.endOfPropertyDeclaration(index);
                this.handleRightCurlyBracket(index);
            } else if (this.curlyBracketDepth == 2) {
                int len = this.buffer.length();
                if (len != 0) {
                    this.unexpectedTokenError(index - len, this.buffer);
                    this.buffer.setLength(0);
                }
            } else {
                this.parseError = true;
            }
            --this.curlyBracketDepth;
            this.prevcp = 125;
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        public void rightSquareBracket(int index) {
            --this.squareBracketDepth;
            if (!this.parseError) {
                if (this.propertyName != null) {
                    this.processBuffer(index);
                    this.newLexicalUnit(LexicalUnit.LexicalType.RIGHT_BRACKET, false);
                } else {
                    this.unexpectedCharError(index, 93);
                }
                this.prevcp = 93;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void character(int index, int codepoint) {
            block45: {
                block54: {
                    block56: {
                        block68: {
                            block69: {
                                block67: {
                                    block63: {
                                        block65: {
                                            block66: {
                                                char c;
                                                block64: {
                                                    block62: {
                                                        block60: {
                                                            block61: {
                                                                block59: {
                                                                    block58: {
                                                                        block57: {
                                                                            block55: {
                                                                                block53: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            String compatText;
                                                                                            block48: {
                                                                                                block50: {
                                                                                                    block49: {
                                                                                                        block47: {
                                                                                                            block46: {
                                                                                                                if (!this.functionToken || this.currentlu.getLexicalUnitType() != LexicalUnit.LexicalType.URI) break block46;
                                                                                                                this.bufferAppend(codepoint);
                                                                                                                break block45;
                                                                                                            }
                                                                                                            if (codepoint != 59) break block47;
                                                                                                            this.handleSemicolon(index);
                                                                                                            break block45;
                                                                                                        }
                                                                                                        if (this.parseError) break block45;
                                                                                                        if (this.propertyName != null) break block48;
                                                                                                        if (codepoint != 45) break block49;
                                                                                                        this.buffer.append('-');
                                                                                                        codepoint = 65;
                                                                                                        break block45;
                                                                                                    }
                                                                                                    if (codepoint != 95) break block50;
                                                                                                    this.buffer.append('_');
                                                                                                    codepoint = 65;
                                                                                                    break block45;
                                                                                                }
                                                                                                if (codepoint == 58) {
                                                                                                    if (this.buffer.length() != 0) {
                                                                                                        this.setPropertyName(index);
                                                                                                        codepoint = 32;
                                                                                                        break block45;
                                                                                                    } else {
                                                                                                        this.handleError(index, (byte)4, "Unexpected ':'");
                                                                                                    }
                                                                                                    break block45;
                                                                                                } else {
                                                                                                    if (codepoint != 64) {
                                                                                                        this.badPropertyName(index, codepoint);
                                                                                                        return;
                                                                                                    }
                                                                                                    this.handleAtKeyword(index);
                                                                                                }
                                                                                                break block45;
                                                                                            }
                                                                                            if (!this.readPriority) break block51;
                                                                                            this.processBuffer(index);
                                                                                            if (codepoint == 33 && this.priorityImportant && CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIOCHAR) && (compatText = this.setFullIdentCompat()) != null) {
                                                                                                this.warnIdentCompat(index, compatText);
                                                                                                this.lunit.setUnitType(LexicalUnit.LexicalType.COMPAT_PRIO);
                                                                                                this.lunit.setCssUnit((short)255);
                                                                                                break block45;
                                                                                            } else {
                                                                                                this.unexpectedCharError(index, codepoint);
                                                                                            }
                                                                                            break block45;
                                                                                        }
                                                                                        if (codepoint != 44) break block52;
                                                                                        if (!this.functionToken || this.currentlu.parameters == null || !this.addToIdentCompat()) {
                                                                                            this.processBuffer(index);
                                                                                        }
                                                                                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_COMMA, false);
                                                                                        break block45;
                                                                                    }
                                                                                    if (codepoint != 33) break block53;
                                                                                    if (!this.functionToken) {
                                                                                        this.processBuffer(index);
                                                                                        this.readPriority = true;
                                                                                        break block45;
                                                                                    } else {
                                                                                        this.unexpectedCharError(index, codepoint);
                                                                                    }
                                                                                    break block45;
                                                                                }
                                                                                if (this.hexColor) break block54;
                                                                                if (codepoint != 45) break block55;
                                                                                if (!this.unicodeRange && this.prevcp != 65) {
                                                                                    this.processBuffer(index);
                                                                                }
                                                                                this.buffer.append('-');
                                                                                codepoint = 65;
                                                                                break block45;
                                                                            }
                                                                            if (this.unicodeRange) break block56;
                                                                            if (codepoint != 95) break block57;
                                                                            this.buffer.append('_');
                                                                            codepoint = 65;
                                                                            break block45;
                                                                        }
                                                                        if (codepoint != 46) break block58;
                                                                        this.handleFullStop(index);
                                                                        break block45;
                                                                    }
                                                                    if (codepoint != 37) break block59;
                                                                    if (this.prevcp == 65 && CSSParser.isDigit(this.buffer.charAt(this.buffer.length() - 1))) {
                                                                        this.buffer.append('%');
                                                                        break block45;
                                                                    } else {
                                                                        this.processBuffer(index);
                                                                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_MOD, false);
                                                                    }
                                                                    break block45;
                                                                }
                                                                if (codepoint != 35) break block60;
                                                                if (this.buffer.length() == 0) break block61;
                                                                if (this.functionToken && this.currentlu.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE) {
                                                                    this.buffer.append('#');
                                                                    break block45;
                                                                } else {
                                                                    this.unexpectedCharError(index, codepoint);
                                                                }
                                                                break block45;
                                                            }
                                                            if (this.currentlu == null || this.currentlu.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE) {
                                                                this.hexColor = true;
                                                                break block45;
                                                            } else if (this.currentlu.value == null) {
                                                                this.buffer.append('#');
                                                                break block45;
                                                            } else {
                                                                this.unexpectedCharError(index, codepoint);
                                                            }
                                                            break block45;
                                                        }
                                                        if (codepoint != 58) break block62;
                                                        this.handleColon(index);
                                                        break block45;
                                                    }
                                                    if (codepoint != 43) break block63;
                                                    if (this.buffer.length() != 1 || (c = this.buffer.charAt(0)) != 'U' && c != 'u') break block64;
                                                    this.buffer.setLength(0);
                                                    this.unicodeRange = true;
                                                    break block45;
                                                }
                                                if (this.buffer.length() != 0 && ((c = this.buffer.charAt(this.buffer.length() - 1)) == 'E' || c == 'e')) break block65;
                                                if (!this.functionToken) break block66;
                                                this.processBuffer(index);
                                                boolean prevCpWS = this.isPrevCpWhitespace();
                                                if ((prevCpWS && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.CALC || this.flagIEValues) && this.currentlu.parameters != null && !this.lastParamIsAlgebraicOperator()) {
                                                    this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_PLUS, false);
                                                    break block45;
                                                } else if (prevCpWS || this.currentlu.parameters == null || this.lastParamIsMultOrSlashOperator()) {
                                                    this.buffer.append('+');
                                                    codepoint = 65;
                                                    break block45;
                                                } else {
                                                    this.unexpectedCharError(index, codepoint);
                                                }
                                                break block45;
                                            }
                                            if (this.isPrevCpWhitespace()) {
                                                this.buffer.append('+');
                                                codepoint = 65;
                                                break block45;
                                            } else if (this.isCustomProperty()) {
                                                this.processBuffer(index);
                                                this.newCustomPropertyOperator(index, codepoint, LexicalUnit.LexicalType.OPERATOR_PLUS);
                                                break block45;
                                            } else {
                                                this.unexpectedCharError(index, codepoint);
                                            }
                                            break block45;
                                        }
                                        this.buffer.append('+');
                                        codepoint = 65;
                                        break block45;
                                    }
                                    if (codepoint != 47) break block67;
                                    this.processBuffer(index);
                                    if (!this.functionToken || this.currentlu.parameters != null && (this.isVarOrLastParamIsOperand() || this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR)) {
                                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SLASH, false);
                                        break block45;
                                    } else {
                                        this.unexpectedCharError(index, codepoint);
                                    }
                                    break block45;
                                }
                                if (!this.functionToken) break block68;
                                if (codepoint != 42) break block69;
                                this.processBuffer(index);
                                if (this.currentlu.parameters != null && this.isVarOrLastParamIsOperand()) {
                                    this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_MULTIPLY, false);
                                    break block45;
                                } else {
                                    this.unexpectedCharError(index, codepoint);
                                }
                                break block45;
                            }
                            if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.TYPE_FUNCTION) {
                                if (codepoint == 60 || codepoint == 62) {
                                    this.bufferAppend(codepoint);
                                    break block45;
                                } else {
                                    this.unexpectedCharError(index, codepoint);
                                }
                                break block45;
                            } else if (codepoint == 61 && this.handleEqualsSignInsideFunction(index)) {
                                codepoint = 65;
                                break block45;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                            break block45;
                        }
                        if (this.isCustomProperty()) {
                            if (codepoint == 42) {
                                this.processBuffer(index);
                                this.newCustomPropertyOperator(index, codepoint, LexicalUnit.LexicalType.OPERATOR_MULTIPLY);
                                break block45;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                            break block45;
                        } else if (codepoint != 64 && codepoint != 63 && codepoint != 42) {
                            this.bufferAppend(codepoint);
                            break block45;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                        break block45;
                    }
                    if (codepoint == 63 && this.buffer.length() < 6) {
                        this.bufferAppend(codepoint);
                        break block45;
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                    break block45;
                }
                this.unexpectedCharError(index, codepoint);
            }
            this.prevcp = codepoint;
        }

        private void setPropertyName(int index) {
            String raw = this.buffer.toString();
            if (this.escapedTokenIndex == -1) {
                if (this.isNotForbiddenIdentStart(raw) || raw.charAt(0) == '*' && CSSParser.this.parserFlags.contains((Object)Parser.Flag.STARHACK)) {
                    this.propertyName = raw;
                    this.buffer.setLength(0);
                    return;
                }
            } else if (this.isNotForbiddenIdentStart(raw)) {
                this.propertyName = this.unescapeBuffer(index);
                if (!this.parseError && !CSSParser.isValidIdentifier(this.propertyName)) {
                    this.handleWarning(index - this.buffer.length(), (byte)-4, "Suspicious property name: " + raw);
                }
                return;
            }
            this.handleError(index - this.buffer.length(), (byte)7, "Invalid property name: '" + raw + '\'');
        }

        private void newCustomPropertyOperator(int index, int codepoint, LexicalUnit.LexicalType operator) {
            if (this.currentlu == null) {
                this.newLexicalUnit(operator, false);
                return;
            }
            assert (this.currentlu.parameters == null);
            LexicalUnit.LexicalType type = this.currentlu.getLexicalUnitType();
            if (!this.typeIsAlgebraicOperator(type) && type != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                this.newLexicalUnit(operator, false);
                return;
            }
            this.unexpectedCharError(index, codepoint);
        }

        private boolean handleEqualsSignInsideFunction(int index) {
            if (this.flagIEValues && (this.propertyName.length() == 0 || this.propertyName.endsWith("filter") || "expression".equalsIgnoreCase(this.currentlu.getFunctionName())) && (this.prevcp == 65 || this.isPrevCpWhitespace() || this.prevcp == 93)) {
                int buflen = this.buffer.length();
                if (buflen != 0) {
                    if (this.escapedTokenIndex == -1) {
                        String s;
                        this.buffer.append('=');
                        this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = s = this.buffer.toString();
                        this.buffer.setLength(0);
                        this.hexColor = false;
                        this.warnIdentCompat(index - buflen, s);
                        return true;
                    }
                } else {
                    LexicalUnitImpl lu = this.currentlu.parameters;
                    if (lu != null) {
                        LexicalUnit.LexicalType lutype = (lu = this.findLastValue(lu)).getLexicalUnitType();
                        if (lutype == LexicalUnit.LexicalType.IDENT) {
                            lu.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                            String s = lu.getStringValue();
                            lu.value = lu.value + '=';
                            this.warnIdentCompat(index - s.length(), s);
                            return true;
                        }
                        if (lutype == LexicalUnit.LexicalType.COMPAT_IDENT) {
                            lu.value = lu.value + '=';
                            return true;
                        }
                        if (lutype == LexicalUnit.LexicalType.RIGHT_BRACKET) {
                            this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = "=";
                            this.warnIdentCompat(index, "=");
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private LexicalUnitImpl findLastValue(LexicalUnitImpl lu) {
            LexicalUnitImpl nextlu;
            while ((nextlu = lu.nextLexicalUnit) != null) {
                lu = nextlu;
            }
            return lu;
        }

        private boolean isCustomProperty() {
            return this.propertyName.startsWith("--");
        }

        private boolean addToIdentCompat() {
            LexicalUnitImpl lu;
            LexicalUnit.LexicalType lutype;
            if (this.escapedTokenIndex == -1 && (lutype = (lu = this.findLastValue(this.currentlu.parameters)).getLexicalUnitType()) == LexicalUnit.LexicalType.COMPAT_IDENT) {
                if (this.hexColor) {
                    lu.value = lu.value + '#';
                    this.hexColor = false;
                }
                if (this.buffer.length() != 0) {
                    lu.value = lu.value + this.buffer;
                    this.buffer.setLength(0);
                }
                this.prevcp = 65;
                return true;
            }
            return false;
        }

        private boolean checkLastIdentCompat() {
            LexicalUnitImpl lu = this.currentlu.parameters;
            if (lu != null && (lu = this.findLastValue(lu)).getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                if (this.hexColor) {
                    lu.value = lu.value + '#';
                    this.hexColor = false;
                }
                lu.value = lu.value + this.buffer;
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        private void handleFullStop(int index) {
            if (this.prevcp == 65) {
                this.buffer.append('.');
            } else if (this.buffer.length() == 0) {
                LexicalUnitImpl lastValue;
                if (this.prevcp == 45 && this.functionToken && this.escapedTokenIndex == -1 && this.currentlu.parameters != null && (lastValue = this.findLastValue(this.currentlu.parameters)).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_MINUS) {
                    LexicalUnitImpl prev = lastValue.previousLexicalUnit;
                    if (prev != null) {
                        prev.nextLexicalUnit = null;
                    } else {
                        this.currentlu.parameters = null;
                    }
                    this.buffer.append('-');
                }
                this.buffer.append('0').append('.');
            } else {
                this.handleError(index, (byte)4, "Unexpected '.'");
            }
        }

        private void handleColon(int index) {
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (buflen != 6 || !this.flagIEValues || !ParseHelper.equalsIgnoreCase(this.buffer, "progid")) {
                    this.handleError(index, (byte)4, "Unexpected ':'");
                } else {
                    this.buffer.append(':');
                    this.handleWarning(index, (byte)-3, "Progid hack applied");
                }
            }
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        private void handleSemicolon(int index) {
            if (this.isDeclarationContext() && this.squareBracketDepth == 0) {
                if (this.parendepth == 0) {
                    this.endOfPropertyDeclaration(index);
                    return;
                }
                if (this.parendepth == 1 && this.functionToken && this.allowSemicolonArgument()) {
                    this.processBuffer(index);
                    this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SEMICOLON, false);
                    return;
                }
            }
            this.handleError(index, (byte)4, "Unexpected ';'");
        }

        protected boolean isDeclarationContext() {
            return this.curlyBracketDepth == 1;
        }

        protected void badPropertyName(int index, int codepoint) {
            if (this.buffer.length() == 0 && codepoint == 42 && CSSParser.this.parserFlags.contains((Object)Parser.Flag.STARHACK)) {
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(this.createException(index, (byte)4, "Unexpected character: * (IE hack)"));
                }
                this.buffer.append('*');
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        protected void endOfPropertyDeclaration(int index) {
            if (this.propertyName != null) {
                this.processBuffer(index);
                if (!this.parseError) {
                    if (!this.isCustomProperty()) {
                        if (this.lunit != null) {
                            this.handleProperty(index, this.propertyName, this.lunit, this.priorityImportant);
                        } else {
                            this.handleError(index, (byte)32, "Found property name (" + this.propertyName + ") but no value");
                        }
                    } else {
                        if (this.lunit == null) {
                            this.lunit = new LexicalUnitImpl(LexicalUnit.LexicalType.EMPTY);
                            this.lunit.value = "";
                        }
                        this.handleLexicalProperty(index, this.propertyName, this.lunit, this.priorityImportant);
                    }
                }
                this.propertyName = null;
            } else if (this.buffer.length() != 0) {
                this.unexpectedTokenError(index, this.buffer);
            }
            this.resetHandler();
        }

        protected void handleProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
            this.setCurrentLocation(index);
            CSSParser.this.handler.property(propertyName, lunit, priorityImportant);
        }

        void handleLexicalProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
            this.setCurrentLocation(index);
            CSSParser.this.handler.lexicalProperty(propertyName, lunit, priorityImportant);
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.lunit = null;
            this.currentlu = null;
            this.priorityImportant = false;
            this.readPriority = false;
            this.functionToken = false;
            this.hexColor = false;
            this.unicodeRange = false;
            this.buffer.setLength(0);
        }

        protected void processBuffer(int index) {
            if (this.parseError) {
                this.buffer.setLength(0);
                return;
            }
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.propertyName == null) {
                    this.setPropertyName(index);
                } else if (this.readPriority) {
                    String prio = this.unescapeBuffer(index);
                    if ("important".equalsIgnoreCase(prio)) {
                        this.priorityImportant = true;
                    } else {
                        this.checkIEPrioHack(index - buflen, prio);
                    }
                } else if (this.functionToken) {
                    switch (this.currentlu.getLexicalUnitType()) {
                        case URI: {
                            if (this.currentlu.value == null) {
                                this.currentlu.value = this.rawBuffer();
                                break;
                            }
                            this.handleError(index, (byte)5, "Unexpected token in url: '" + this.rawBuffer() + '\'');
                            break;
                        }
                        case ELEMENT_REFERENCE: {
                            String s = this.unescapeStringValue(index);
                            if (s.length() > 1 && s.charAt(0) == '#') {
                                this.currentlu.value = s.substring(1);
                            } else {
                                this.handleError(index - buflen, (byte)5, "Wrong element reference: " + s);
                                this.functionToken = false;
                            }
                            this.buffer.setLength(0);
                            break;
                        }
                        case TYPE_FUNCTION: {
                            String syn = this.unescapeStringValue(index);
                            this.buffer.setLength(0);
                            SyntaxUnitImpl synLU = this.newSyntaxUnit();
                            try {
                                synLU.syntax = new SyntaxParser().parseSyntax(syn);
                            }
                            catch (CSSException e) {
                                this.handleError(index - buflen, (byte)5, "Invalid syntax: " + syn);
                            }
                            break;
                        }
                        default: {
                            if (this.escapedTokenIndex != -1 || !this.checkLastIdentCompat()) {
                                if (!this.hexColor) {
                                    this.parseNonHexcolorValue(index);
                                    break;
                                }
                                if (!this.parseHexColor(buflen)) {
                                    this.handleError(index - buflen, (byte)5, "Wrong color value #" + this.buffer);
                                }
                                this.buffer.setLength(0);
                                this.hexColor = false;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.hexColor) {
                    if (!this.parseHexColor(buflen)) {
                        this.handleError(index - buflen, (byte)5, "Wrong color value #" + this.buffer);
                    }
                    this.buffer.setLength(0);
                    this.hexColor = false;
                } else if (this.unicodeRange) {
                    this.parseUnicodeRange(index, buflen);
                } else {
                    this.parseNonHexcolorValue(index);
                }
            } else if (this.hexColor) {
                this.handleError(index, (byte)5, "Empty hex color value");
            } else if (this.unicodeRange) {
                this.handleError(index, (byte)9, "Bad unicode range");
            }
        }

        private void parseNonHexcolorValue(int index) {
            String raw = this.buffer.toString();
            int buflen = raw.length();
            if (this.escapedTokenIndex != -1) {
                String cssText;
                String str;
                int escsz = index - this.escapedTokenIndex;
                int nonescLen = buflen - escsz;
                if (nonescLen <= 0) {
                    try {
                        str = this.unescapeIdentifier(index, raw);
                        cssText = ParseHelper.safeEscape(str, true, true);
                    }
                    catch (DOMNullCharacterException e) {
                        if (this.flagIEValues) {
                            this.setIdentCompat(index - buflen, raw);
                            this.escapedTokenIndex = -1;
                            this.buffer.setLength(0);
                            return;
                        }
                        str = this.safeUnescapeIdentifier(index, raw);
                        cssText = this.safeNullEscape(raw);
                    }
                } else {
                    CharSequence rawPart = this.buffer.subSequence(0, nonescLen);
                    cssText = this.buffer.substring(nonescLen);
                    try {
                        str = this.unescapeIdentifier(index, cssText);
                        cssText = ParseHelper.safeEscape(str, true, true);
                    }
                    catch (DOMNullCharacterException e) {
                        if (this.flagIEValues) {
                            this.setIdentCompat(index - buflen, raw);
                            this.escapedTokenIndex = -1;
                            this.buffer.setLength(0);
                            return;
                        }
                        str = this.safeUnescapeIdentifier(index, cssText);
                        cssText = this.safeNullEscape(cssText);
                    }
                    str = rawPart + str;
                    rawPart = ParseHelper.escapeAllBackslash(rawPart);
                    cssText = ParseHelper.escapeCssCharsAndFirstChar(rawPart) + cssText;
                }
                this.escapedTokenIndex = -1;
                if (!this.createIdentifierOrKeyword(index, raw, str, cssText)) {
                    this.checkForIEValue(index, raw);
                }
            } else {
                String str = this.buffer.toString();
                String cssText = ParseHelper.escapeCssCharsAndFirstChar(raw).toString();
                this.createIdentifierOrNumberOrKeyword(index, raw, str, cssText);
            }
            this.buffer.setLength(0);
        }

        private void createIdentifierOrNumberOrKeyword(int index, String raw, String ident, String cssText) {
            int cp = ident.codePointAt(0);
            if (cp != 32) {
                int i;
                int len = ident.length();
                for (i = len - 1; i >= 0; --i) {
                    cp = ident.codePointAt(i);
                    if (Character.isLetter(cp) || cp == 37) continue;
                    if (cp >= 48 && cp <= 57 && this.parseNumber(index, ident, i + 1) || this.newIdentifier(raw, ident, cssText)) break;
                    if (raw.length() == 1) {
                        char c = raw.charAt(0);
                        if (c == '+') {
                            this.newOperator(index, 43, LexicalUnit.LexicalType.OPERATOR_PLUS);
                            return;
                        }
                        if (c != '-') break;
                        this.newOperator(index, 45, LexicalUnit.LexicalType.OPERATOR_MINUS);
                        return;
                    }
                    this.checkForIEValue(index, raw);
                    break;
                }
                if (i != -1) {
                    return;
                }
            }
            if (!this.createIdentifierOrKeyword(index, raw, ident, cssText)) {
                this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
            }
        }

        private boolean parseNumber(int index, String s, int i) {
            String unit = null;
            if (i != s.length()) {
                float flval;
                String strnum = s.substring(0, i);
                try {
                    flval = Float.parseFloat(strnum);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                unit = s.substring(i);
                unit = unit.trim().toLowerCase(Locale.ROOT);
                short cssUnit = UnitStringToId.unitFromString(unit);
                LexicalUnit.LexicalType unitType = cssUnit == 2 ? LexicalUnit.LexicalType.PERCENTAGE : LexicalUnit.LexicalType.DIMENSION;
                LexicalUnitImpl lu = this.newLexicalUnit(unitType, false);
                lu.floatValue = flval;
                lu.dimensionUnitText = unit;
                lu.setCssUnit(cssUnit);
            } else if (s.lastIndexOf(46, i) == -1) {
                int intval;
                try {
                    intval = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    float flval;
                    try {
                        flval = Float.parseFloat(s);
                    }
                    catch (NumberFormatException e1) {
                        return false;
                    }
                    LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.REAL);
                    lu.floatValue = flval;
                    return true;
                }
                LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.INTEGER);
                lu.intValue = intval;
            } else {
                float flval;
                try {
                    flval = Float.parseFloat(s);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (flval == 0.0f) {
                    LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.INTEGER);
                    lu.intValue = (int)flval;
                } else {
                    LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.REAL);
                    lu.floatValue = flval;
                }
            }
            return true;
        }

        private void newOperator(int index, int codePoint, LexicalUnit.LexicalType operator) {
            LexicalUnit.LexicalType type;
            if (this.currentlu == null) {
                if (this.isCustomProperty()) {
                    this.newLexicalUnit(operator, false);
                    return;
                }
            } else if (this.currentlu.parameters != null) {
                if (this.isVarOrLastParamIsOperand()) {
                    this.newLexicalUnit(operator, false);
                    return;
                }
            } else if (this.isCustomProperty() && !this.typeIsAlgebraicOperator(type = this.currentlu.getLexicalUnitType()) && type != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                this.newLexicalUnit(operator, false);
                return;
            }
            this.unexpectedCharError(index, codePoint);
        }

        private boolean createIdentifierOrKeyword(int index, String raw, String ident, String cssText) {
            if (ident.equalsIgnoreCase("inherit")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.INHERIT, false);
            } else if (ident.equalsIgnoreCase("initial")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.INITIAL, false);
            } else if (ident.equalsIgnoreCase("unset")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.UNSET, false);
            } else if (ident.equalsIgnoreCase("revert")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.REVERT, false);
            } else {
                return this.newIdentifier(raw, ident, cssText);
            }
            return true;
        }

        private boolean newIdentifier(String raw, String ident, String cssText) {
            if (this.isNotForbiddenIdentStart(raw)) {
                String lcident;
                if (this.propertyDatabase != null && (lcident = ident.toLowerCase(Locale.ROOT)) != ident) {
                    if (this.propertyDatabase.isShorthand(this.propertyName)) {
                        if (!this.isPreviousValueCustomIdent()) {
                            String[] longhands;
                            for (String longhand : longhands = this.propertyDatabase.getLonghandProperties(this.propertyName)) {
                                if (!this.isIdentifierValueOf(longhand, lcident)) continue;
                                ident = lcident;
                            }
                        }
                    } else if (this.isIdentifierValueOf(this.propertyName, lcident)) {
                        ident = lcident;
                    }
                }
                LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.IDENT, false);
                lu.value = ident;
                lu.identCssText = cssText;
                return true;
            }
            return false;
        }

        private boolean isIdentifierValueOf(String propertyName, String lcident) {
            return this.propertyDatabase.isIdentifierValue(propertyName, lcident) || "none".equals(lcident);
        }

        private boolean isPreviousValueCustomIdent() {
            String s;
            return this.currentlu != null && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && (s = this.currentlu.getStringValue()) != s.toLowerCase(Locale.ROOT);
        }

        private String safeNullEscape(String raw) {
            String cssText;
            int seqlen;
            CharSequence seq = ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(raw));
            if (seq.charAt((seqlen = seq.length()) - 1) == '0') {
                StringBuilder sb = new StringBuilder(seqlen + 1);
                sb.append(seq).append(' ');
                cssText = sb.toString();
            } else {
                cssText = seq.toString();
            }
            return cssText;
        }

        private void checkForIEValue(int index, String raw) {
            int rawlen = raw.length();
            if (!(this.flagIEValues && rawlen > 2 && raw.charAt(rawlen - 2) == '\\' && this.isIEHackSuffix(raw.codePointAt(rawlen - 1)) && this.setIdentCompat(index - rawlen, raw))) {
                this.handleError(index - rawlen, (byte)7, "Invalid identifier: " + raw);
            }
        }

        private boolean isIEHackSuffix(int codepoint) {
            return codepoint == 57 || codepoint == 48;
        }

        private void checkIEPrioHack(int index, String prio) {
            String compatText;
            this.buffer.append('!').append(prio);
            if (CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIO) && "ie".equals(prio) && (compatText = this.setFullIdentCompat()) != null) {
                this.warnIdentCompat(index, compatText);
            } else {
                this.handleError(index, (byte)9, "Invalid priority: " + prio);
            }
        }

        private boolean setIdentCompat(int index, String lastvalue) {
            if (this.currentlu != null) {
                String prev;
                try {
                    prev = this.currentlu.toString();
                }
                catch (RuntimeException e) {
                    this.lunit.reset();
                    return false;
                }
                this.currentlu.reset();
                this.currentlu.value = prev + ' ' + lastvalue;
                this.currentlu.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                this.currentlu.setCssUnit((short)255);
            } else {
                this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = lastvalue;
            }
            this.warnIdentCompat(index, lastvalue);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String setFullIdentCompat() {
            String newval;
            if (!this.hexColor) {
                newval = this.rawBuffer();
            } else {
                this.hexColor = false;
                newval = '#' + this.rawBuffer();
            }
            if (this.lunit != null) {
                try {
                    newval = this.lunit.toString() + newval;
                }
                catch (RuntimeException e) {
                    String string = null;
                    return string;
                }
                finally {
                    this.lunit.reset();
                }
                this.lunit.value = newval;
                this.lunit.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                this.lunit.setCssUnit((short)255);
            } else {
                this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = newval;
            }
            return newval;
        }

        private void warnIdentCompat(int index, String ident) {
            this.handleWarning(index, (byte)-2, "Found compat ident: " + ident);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseUnicodeRange(int index, int buflen) {
            LexicalUnitImpl lu1;
            LexicalUnitImpl lu2 = null;
            String s = this.rawBuffer();
            int idx = s.indexOf(45);
            if (idx == -1) {
                byte check = this.rangeLengthCheck(s);
                if (check == 1) {
                    lu1 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                    lu1.intValue = Integer.parseInt(s, 16);
                } else {
                    if (check != 2) {
                        this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                        return;
                    }
                    lu1 = new LexicalUnitImpl(LexicalUnit.LexicalType.UNICODE_WILDCARD);
                    lu1.value = s;
                }
            } else if (idx > 0 && idx < s.length() - 1) {
                String range1 = s.substring(0, idx);
                String range2 = s.substring(idx + 1);
                byte check = this.rangeLengthCheck(range1);
                if (check != 1) {
                    this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                    return;
                }
                lu1 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                lu1.intValue = Integer.parseInt(range1, 16);
                check = this.rangeLengthCheck(range2);
                if (check != 1) {
                    this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                    return;
                }
                lu2 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                lu2.intValue = Integer.parseInt(range2, 16);
            } else {
                this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                return;
            }
            LexicalUnitImpl range = this.newLexicalUnit(LexicalUnit.LexicalType.UNICODE_RANGE, false);
            range.addFunctionParameter(lu1);
            if (lu2 != null) {
                range.addFunctionParameter(lu2);
            }
            this.unicodeRange = false;
        }

        private byte rangeLengthCheck(String range) {
            int wildcardCount = 0;
            int len = range.length();
            if (len < 7) {
                for (int i = 0; i < len; ++i) {
                    if (range.charAt(i) == '?') {
                        wildcardCount = (byte)(wildcardCount + 1);
                        continue;
                    }
                    if (wildcardCount == 0) continue;
                    return 0;
                }
                if (wildcardCount == 0) {
                    return 1;
                }
                if (wildcardCount != 6) {
                    return 2;
                }
            }
            return 0;
        }

        private boolean parseHexColor(int buflen) {
            block6: {
                try {
                    if (buflen == 3) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.parseHexComponent(1, 2, true);
                        this.parseHexComponent(2, 3, true);
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    if (buflen == 6) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.parseHexComponent(2, 4, false);
                        this.parseHexComponent(4, 6, false);
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    if (buflen == 8) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.parseHexComponent(2, 4, false);
                        this.parseHexComponent(4, 6, false);
                        int comp = this.hexComponent(6, 8, false);
                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SLASH, false);
                        this.newNumberUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.REAL).floatValue = (float)comp / 255.0f;
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    if (buflen == 4) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.parseHexComponent(1, 2, true);
                        this.parseHexComponent(2, 3, true);
                        int comp = this.hexComponent(3, 4, true);
                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SLASH, false);
                        this.newNumberUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.REAL).floatValue = (float)comp / 255.0f;
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }

        private void parseHexComponent(int start, int end, boolean doubleDigit) {
            int comp;
            this.newNumberUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.INTEGER).intValue = comp = this.hexComponent(start, end, doubleDigit);
        }

        private LexicalUnitImpl newNumberUnit(LexicalUnit.LexicalType sacType) {
            LexicalUnitImpl lu = this.newLexicalUnit(sacType, false);
            lu.setCssUnit((short)0);
            return lu;
        }

        private int hexComponent(int start, int end, boolean doubleDigit) {
            String s;
            if (doubleDigit) {
                CharSequence seq = this.buffer.subSequence(start, end);
                s = new StringBuilder(2).append(seq).append(seq).toString();
            } else {
                s = this.buffer.substring(start, end);
            }
            return Integer.parseInt(s, 16);
        }

        private void recoverOwnerUnit() {
            this.currentlu.identCssText = "#" + this.buffer;
            if (this.currentlu.ownerLexicalUnit != null) {
                this.currentlu = this.currentlu.ownerLexicalUnit;
            }
        }

        public void quoted(int index, CharSequence quoted, int quoteChar) {
            if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                this.processBuffer(index);
                if (!this.parseError) {
                    String s = quoted.toString();
                    LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.STRING, false);
                    if (lu.value != null) {
                        this.handleError(index, (byte)5, "Unexpected string: " + quoteChar + quoted + quoteChar);
                    }
                    lu.value = this.safeUnescapeIdentifier(index, s);
                    char c = (char)quoteChar;
                    StringBuilder buf = new StringBuilder(s.length() + 2);
                    buf.append(c).append(s).append(c);
                    lu.identCssText = buf.toString();
                    this.prevcp = 65;
                }
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteChar) {
            if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                this.processBuffer(index);
                if (!this.parseError) {
                    String s = quoted.toString();
                    LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.STRING, false);
                    if (lu.value != null) {
                        this.handleError(index, (byte)5, "Unexpected string: " + quoteChar + quoted + quoteChar);
                    }
                    lu.value = this.safeUnescapeIdentifier(index, s);
                    char c = (char)quoteChar;
                    lu.identCssText = c + ParseHelper.escapeControl(s) + c;
                    this.prevcp = 65;
                }
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
        }

        public void escaped(int index, int codepoint) {
            if (!this.parseError && (this.unicodeRange || this.isEscapedContentError(index, codepoint))) {
                this.unexpectedCharError(index, codepoint);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isEscapedContentError(int index, int codepoint) {
            if (this.isEscapedContext(this.prevcp) && !this.hexColor) {
                if (ParseHelper.isHexCodePoint(codepoint) || codepoint == 92 || codepoint == 43 || codepoint == 45 || codepoint == 32) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                }
                this.prevcp = 65;
                this.bufferAppend(codepoint);
                return false;
            } else {
                if (!this.flagIEValues || !this.isIEHackSuffix(codepoint) || this.lunit == null && this.buffer.length() == 0) return true;
                this.buffer.append('\\');
                this.bufferAppend(codepoint);
                String compatText = this.setFullIdentCompat();
                this.escapedTokenIndex = -1;
                if (compatText == null) return true;
                this.warnIdentCompat(index, compatText);
                this.prevcp = codepoint;
            }
            return false;
        }

        private boolean isEscapedContext(int prevcp) {
            return prevcp == 65 || this.isPrevCpWhitespace() || prevcp == 58 || prevcp == 44 || prevcp == 59 || prevcp == 123 || this.readPriority && prevcp == 33;
        }

        public void separator(int index, int codepoint) {
            if (!this.parseError) {
                if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                    return;
                }
                this.processBuffer(index);
            }
            this.setWhitespacePrevCp();
        }

        @Override
        protected void highControl(int index, int codepoint) {
            if (!this.parseError) {
                if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                    this.bufferAppend(codepoint);
                } else {
                    this.handleError(index, (byte)4, "Unexpected control: " + codepoint);
                }
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (!this.parseError && this.buffer.length() == 0 && this.propertyName == null && this.curlyBracketDepth == 1 && this.parendepth == 0 && this.squareBracketDepth == 0) {
                super.commented(index, commentType, comment);
                this.prevcp = 12;
            } else {
                this.separator(index, 32);
                this.prevcp = 32;
            }
        }

        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (this.propertyName != null) {
                this.processBuffer(len);
                this.endOfPropertyDeclaration(len);
            } else if (this.buffer.length() != 0) {
                this.handleError(len, (byte)9, "Unexpected token: " + this.buffer);
            }
            this.endDeclarationList();
        }

        protected void endDeclarationList() {
            this.endDocument();
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
            this.lunit = null;
        }
    }

    public static interface DeclarationRuleHandler
    extends CSSHandler {
        public void startAtRule(String var1, String var2);

        public void endAtRule();
    }

    class DeclarationRuleTokenHandler
    extends DeclarationTokenHandler {
        private String ruleFirstPart;
        private byte stage;
        static final byte STAGE_FOUND_AT_CHAR = 1;
        static final byte STAGE_RULE_NAME_SELECTOR = 2;
        static final byte STAGE_RULE_BODY = 3;
        static final byte STAGE_RULE_END = 4;
        static final byte INVALID_RULE = 127;

        DeclarationRuleTokenHandler(ShorthandDatabase propertyDatabase) {
            super(propertyDatabase, 0);
            this.ruleFirstPart = null;
            this.stage = 0;
        }

        void setRuleName(String ruleName) {
            this.ruleFirstPart = ruleName;
        }

        void setStage(byte stage) {
            this.stage = stage;
        }

        @Override
        void addWord(int index, CharSequence word) {
            if (this.prevcp == 64 && this.stage == 1) {
                this.ruleFirstPart = word.toString().toLowerCase(Locale.ROOT);
                this.buffer.setLength(0);
                this.stage = (byte)2;
            } else if (this.stage != 127) {
                super.addWord(index, word);
                if (this.stage < 2) {
                    this.stage = (byte)2;
                }
            }
        }

        @Override
        protected void handleAtKeyword(int index) {
            if (this.propertyName != null || this.buffer.length() != 0 || this.stage != 0) {
                this.unexpectedCharError(index, 64);
            } else if (this.stage != 127) {
                this.buffer.append('@');
                this.stage = 1;
                this.prevcp = 64;
            }
        }

        @Override
        protected void handleLeftCurlyBracket(int index) {
            ++this.curlyBracketDepth;
            if (this.stage != 127) {
                if (this.stage == 2) {
                    String ruleSecondPart = null;
                    if (this.buffer.length() != 0) {
                        ruleSecondPart = this.unescapeBuffer(index);
                    }
                    this.prevcp = 32;
                    this.stage = (byte)3;
                    this.startAtRule(index, this.ruleFirstPart, ruleSecondPart);
                    if (this.stage == 127) {
                        this.skipDeclarationBlock();
                    }
                } else {
                    this.unexpectedCharError(index, 123);
                }
            } else {
                this.skipDeclarationBlock();
            }
        }

        void skipDeclarationBlock() {
            this.getTokenControl().setTokenHandler((TokenHandler3)new IgnoredDeclarationRuleTokenHandler());
        }

        protected void startAtRule(int index, String ruleFirstPart, String ruleSecondPart) {
            ((DeclarationRuleHandler)CSSParser.this.handler).startAtRule(ruleFirstPart, ruleSecondPart);
        }

        @Override
        protected void handleRightCurlyBracket(int index) {
            if (this.stage == 3) {
                this.endAtRule(index);
                this.resetHandler();
                this.ruleFirstPart = null;
                this.stage = (byte)4;
            } else if (this.stage != 127) {
                this.unexpectedCharError(index, 125);
            }
        }

        protected void endAtRule(int index) {
            ((DeclarationRuleHandler)CSSParser.this.handler).endAtRule();
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.stage != 127) {
                if (this.getCurlyBracketDepth() != 0) {
                    super.character(index, codepoint);
                } else if (codepoint == 64) {
                    this.handleAtKeyword(index);
                } else {
                    this.bufferAppend(codepoint);
                    this.prevcp = codepoint;
                }
            }
        }

        @Override
        protected void processBuffer(int index) {
            if (this.getCurlyBracketDepth() != 0) {
                super.processBuffer(index);
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (!(this.parseError || this.buffer.length() != 0 || this.propertyName != null || this.curlyBracketDepth != 1 && this.ruleFirstPart != null || this.parendepth != 0 || commentType != 0)) {
                CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
                this.prevcp = 12;
            } else {
                this.separator(index, 32);
                this.prevcp = 32;
            }
        }

        @Override
        public void endOfStream(int len) {
            super.endOfStream(len);
            if (this.stage != 4) {
                if (this.stage == 3) {
                    this.handleWarning(len, (byte)-6, "Unexpected end of stream");
                    this.endAtRule(len);
                } else if (!this.parseError) {
                    this.handleError(len, (byte)10, "Unexpected end of stream");
                }
            }
        }

        private class IgnoredDeclarationRuleTokenHandler
        extends IgnoredDeclarationTokenHandler {
            IgnoredDeclarationRuleTokenHandler() {
            }

            @Override
            protected void endDeclarationBlock() {
            }

            @Override
            public void control(int index, int codepoint) {
                DeclarationRuleTokenHandler.this.control(index, codepoint);
            }

            public void endOfStream(int len) {
                DeclarationRuleTokenHandler.this.endOfStream(len);
            }
        }
    }

    private class RuleTokenHandler
    extends SheetTokenHandler {
        RuleTokenHandler(Parser.NamespaceMap nsMap) {
            super(nsMap, false);
        }

        @Override
        protected void endRuleBody() {
            if (this.getCurlyBracketDepth() == 0) {
                this.contextHandler = new RuleEndContentHandler();
            } else {
                super.endRuleBody();
            }
        }

        @Override
        protected void resetRuleState() {
            super.resetRuleState();
            this.contextHandler = new RuleEndContentHandler();
        }

        private class RuleEndContentHandler
        extends CSSTokenHandler {
            private boolean foundControl;

            RuleEndContentHandler() {
                this.foundControl = false;
            }

            public void word(int index, CharSequence word) {
                this.reportError(index);
            }

            public void separator(int index, int codePoint) {
            }

            public void quoted(int index, CharSequence quoted, int quoteCp) {
                this.reportError(index);
            }

            public void quotedWithControl(int index, CharSequence quoted, int quote) {
                this.reportError(index);
            }

            public void leftParenthesis(int index) {
                this.reportError(index);
            }

            public void leftSquareBracket(int index) {
                this.reportError(index);
            }

            public void leftCurlyBracket(int index) {
                this.reportError(index);
            }

            public void rightParenthesis(int index) {
                this.reportError(index);
            }

            public void rightSquareBracket(int index) {
                this.reportError(index);
            }

            public void rightCurlyBracket(int index) {
                this.reportError(index);
            }

            public void character(int index, int codePoint) {
                this.reportError(index);
            }

            public void escaped(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            void setCurrentLocation(int index) {
                RuleTokenHandler.this.setCurrentLocation(index);
            }

            @Override
            public void control(int index, int codepoint) {
                RuleTokenHandler.this.control(index, codepoint);
                this.foundControl = true;
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                if (!this.foundControl && !this.parseError && commentType == 0) {
                    CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
                }
            }

            public void endOfStream(int len) {
                CSSParser.this.handler.endOfStream();
            }

            @Override
            public void error(int index, byte errCode, CharSequence context) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            private void reportError(int index) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                if (!this.parseError && CSSParser.this.errorHandler != null) {
                    this.handleError(this.createException(index, errCode, message));
                }
                this.parseError = true;
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return RuleTokenHandler.this.createException(index, errCode, message);
            }
        }
    }

    private class PageTokenHandler
    extends NestedRuleTH {
        private PageSelectorList pageSelectorList;
        private final DeclarationTokenHandler rootDeclarationHandler;

        private PageTokenHandler() {
            super(64, "@page");
            this.pageSelectorList = null;
            this.rootDeclarationHandler = new NestedRuleTH.RootDeclarationTokenHandler(this.getDeclarationHandler());
            this.setDeclarationHandler(this.rootDeclarationHandler);
        }

        @Override
        boolean processNestedSelector(int index) {
            String name = this.rawBuffer().trim();
            if (!this.isMarginRuleName(name)) {
                this.handleError(index, (byte)7, "Unknown margin rule name.");
                this.setStage((byte)10);
                return false;
            }
            CSSParser.this.handler.startMargin(name);
            return true;
        }

        @Override
        void processSelector(int index, String selector) {
            super.processSelector(index, selector);
            if (!this.parseError) {
                try {
                    this.pageSelectorList = CSSParser.this.parsePageSelectorList(selector);
                }
                catch (DOMException e) {
                    this.handleError(index, (byte)33, e.getMessage());
                    this.setStage((byte)9);
                    return;
                }
                CSSParser.this.handler.startPage(this.pageSelectorList);
            }
        }

        @Override
        protected void emptySelector(int index) {
            CSSParser.this.handler.startPage(null);
            this.setStage((byte)5);
        }

        @Override
        protected void startBlockList(int index) {
            this.setStage((byte)5);
        }

        @Override
        protected void endBlock() {
            CSSParser.this.handler.endMargin();
            this.setDeclarationHandler(this.rootDeclarationHandler);
            this.setStage((byte)5);
        }

        @Override
        void endBlockList(int index) {
            if (this.getStage() != 9) {
                if (this.buffer.length() > 0 || this.prevcp == 64) {
                    this.buffer.setLength(0);
                    this.handleError(index, (byte)33, "Unexpected end of rule.");
                }
                CSSParser.this.handler.endPage(this.pageSelectorList);
            }
            this.pageSelectorList = null;
        }

        @Override
        boolean isValidNestedSelectorCharacter(int codePoint) {
            return false;
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return codePoint == 58 || codePoint == 44;
        }

        private boolean isMarginRuleName(String ruleName) {
            StringTokenizer st = new StringTokenizer(ruleName, "-");
            while (st.hasMoreElements()) {
                String s = st.nextToken();
                if ("top".equals(s) || "left".equals(s) || "center".equals(s) || "right".equals(s) || "corner".equals(s) || "bottom".equals(s) || "middle".equals(s)) continue;
                return false;
            }
            return true;
        }
    }

    private class KeyFrameBlockListTH
    extends NestedRuleTH {
        KeyFrameBlockListTH() {
            super(64, "@keyframes");
        }

        @Override
        void checkNameSelector() {
            if (this.getStage() == 1 && (this.escapedTokenIndex == -1 || this.isPrevCpWhitespace())) {
                this.setStage((byte)2);
            }
        }

        @Override
        void waitSelectorQuoted(int index, CharSequence quoted, int quoteCp) {
            if (this.buffer.length() == 0) {
                this.buffer.append(quoted);
                this.setStage((byte)2);
                this.prevcp = 65;
            } else {
                this.handleError(index, (byte)9, "@keyframes name must be a single identifier or string");
            }
        }

        @Override
        boolean processNestedSelector(int index) {
            String selector = this.rawBuffer();
            try {
                LexicalUnit kfsel = CSSParser.this.parsePropertyValue(new StringReader(selector));
                CSSParser.this.handler.startKeyframe(kfsel);
            }
            catch (CSSException e) {
                this.handleError(index, (byte)5, e.getMessage());
                this.setStage((byte)9);
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }

        @Override
        void processSelector(int index, String name) {
            super.processSelector(index, name);
            if (!this.parseError) {
                CSSParser.this.handler.startKeyframes(name);
            }
        }

        @Override
        protected void endBlock() {
            super.endBlock();
            CSSParser.this.handler.endKeyframe();
        }

        @Override
        void endBlockList(int index) {
            CSSParser.this.handler.endKeyframes();
        }

        @Override
        boolean isValidNestedSelectorCharacter(int codePoint) {
            return codePoint == 37 || codePoint == 44 || codePoint == 46;
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return false;
        }
    }

    private class FontFeatureValuesTH
    extends NestedRuleTH {
        FontFeatureValuesTH() {
            super(32, "@font-feature-values");
        }

        @Override
        boolean processNestedSelector(int index) {
            String selector = this.unescapeBuffer(index);
            if (selector.length() <= 1 || selector.charAt(0) != '@') {
                this.handleError(index, (byte)33, "Bad feature name: " + selector);
                return false;
            }
            CSSParser.this.handler.startFeatureMap(selector.substring(1).trim());
            return true;
        }

        @Override
        void processSelector(int index, String name) {
            String[] familyName;
            for (String fontName : familyName = name.split("\\s*,\\s*")) {
                super.processSelector(index, fontName);
            }
            if (!this.parseError) {
                CSSParser.this.handler.startFontFeatures(familyName);
            }
        }

        @Override
        protected void endBlock() {
            super.endBlock();
            CSSParser.this.handler.endFeatureMap();
        }

        @Override
        void endBlockList(int index) {
            CSSParser.this.handler.endFontFeatures();
        }

        @Override
        boolean isValidNestedSelectorCharacter(int codePoint) {
            return codePoint == 64;
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return codePoint == 45 || codePoint == 44;
        }
    }

    private class SupportsTokenHandler
    extends ConditionTokenHandler<SupportsConditionFactory> {
        private byte errorCode;
        private CSSParseException errorException;
        private final CSSRule rule;

        SupportsTokenHandler(CSSRule rule, SheetContext parentStyleSheet) {
            super(CSSParser.this, (BooleanConditionFactory)CSSParser.this.createSupportsConditionFactory(parentStyleSheet));
            this.errorCode = 0;
            this.errorException = null;
            this.rule = rule;
            this.setPredicateHandler(new SupportsDelegateHandler());
        }

        BooleanCondition getCondition() {
            BooleanCondition condition = this.currentCond;
            if (condition != null) {
                while (condition.getParentCondition() != null) {
                    condition = condition.getParentCondition();
                }
            }
            return condition;
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                if (this.errorCode == 0) {
                    this.errorCode = errCode;
                    this.errorException = this.createException(index, errCode, message);
                    this.handleError(this.errorException);
                }
                this.parseError = true;
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message, Throwable cause) {
            if (!this.parseError) {
                if (this.errorCode == 0) {
                    this.errorCode = errCode;
                    this.errorException = this.createException(index, errCode, message);
                    this.errorException.initCause(cause);
                    this.handleError(this.errorException);
                }
                this.parseError = true;
            }
        }

        @Override
        protected void handleError(CSSParseException ex) throws CSSParseException {
            if (this.rule != null) {
                this.rule.getParentStyleSheet().getErrorHandler().ruleParseError(this.rule, this.errorException);
                this.parseError = true;
            } else {
                super.handleError(ex);
            }
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.errorCode = 0;
        }

        private class SupportsDelegateHandler
        extends DelegateHandler {
            private boolean readingValue;
            private boolean functionToken;
            private short valueParendepth;

            SupportsDelegateHandler() {
                this.readingValue = false;
                this.functionToken = false;
            }

            @Override
            boolean isAllowedTopLevel() {
                return this.functionToken;
            }

            public void word(int index, CharSequence word) {
                if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!this.readingValue && !this.functionToken) {
                        SupportsTokenHandler.this.unexpectedTokenError(index, word);
                        return;
                    }
                    if (SupportsTokenHandler.this.isPrevCpWhitespace()) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                }
                SupportsTokenHandler.this.buffer.append(word);
            }

            public void leftParenthesis(int index) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append('(');
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!SupportsTokenHandler.this.isPrevCpWhitespace()) {
                        String fname = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        if (!"selector".equalsIgnoreCase(fname)) {
                            SupportsTokenHandler.this.unexpectedTokenError(index, "Unknown function: " + fname);
                            return;
                        }
                        this.functionToken = true;
                        this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                        this.valueParendepth = (short)(this.valueParendepth - 1);
                    } else {
                        SupportsTokenHandler.this.unexpectedCharError(index, 40);
                    }
                }
                SupportsTokenHandler.this.prevcp = 40;
            }

            public void leftSquareBracket(int index) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append('[');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 91);
                }
            }

            public void leftCurlyBracket(int index) {
                SupportsTokenHandler.this.handleLeftCurlyBracket(index);
            }

            public void rightParenthesis(int index) {
                if (this.readingValue) {
                    if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                        String svalue = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        if (!svalue.isEmpty()) {
                            this.setDeclarationPredicate(index, svalue);
                        } else {
                            SupportsTokenHandler.this.unexpectedCharError(index, 41);
                        }
                        this.readingValue = false;
                        SupportsTokenHandler.this.readingPredicate = false;
                        SupportsTokenHandler.this.escapedTokenIndex = -1;
                    } else {
                        SupportsTokenHandler.this.buffer.append(')');
                    }
                } else if (this.functionToken) {
                    if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                        BooleanCondition newCond;
                        this.functionToken = false;
                        SupportsTokenHandler.this.readingPredicate = false;
                        SupportsTokenHandler.this.escapedTokenIndex = -1;
                        SupportsTokenHandler.this.prevcp = 41;
                        String s = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        try {
                            SelectorList list = CSSParser.this.parseSelectors(s);
                            if (!SupportsTokenHandler.this.parseError) {
                                newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createSelectorFunction(list);
                            } else {
                                newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + s + ')');
                                SupportsTokenHandler.this.parseError = false;
                            }
                        }
                        catch (CSSBudgetException e) {
                            SupportsTokenHandler.this.handleError(index, (byte)127, "Hit a limit while parsing @supports condition selector.", e);
                            newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + s + ')');
                        }
                        catch (CSSException e) {
                            SupportsTokenHandler.this.handleWarning(index, (byte)127, "Unkown selector in @supports condition.", e);
                            newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + s + ')');
                        }
                        if (SupportsTokenHandler.this.currentCond != null) {
                            SupportsTokenHandler.this.currentCond.addCondition(newCond);
                        }
                        SupportsTokenHandler.this.currentCond = newCond;
                    } else {
                        SupportsTokenHandler.this.buffer.append(')');
                    }
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 41);
                }
            }

            private void setDeclarationPredicate(int index, String value) {
                LexicalUnit lunit;
                String propertyName = ((DeclarationPredicate)SupportsTokenHandler.this.currentCond).getName();
                CSSParser parser = new CSSParser(CSSParser.this.parserFlags);
                StringReader re = new StringReader(value);
                try {
                    lunit = parser.parsePropertyValue(propertyName, re);
                }
                catch (Exception e) {
                    this.warnAndSetFalseCondition(index, propertyName, value, e);
                    return;
                }
                try {
                    ((DeclarationPredicate)SupportsTokenHandler.this.currentCond).setValue(lunit);
                }
                catch (Exception e) {
                    this.warnAndSetFalseCondition(index, propertyName, value, e);
                }
            }

            private void warnAndSetFalseCondition(int index, String propertyName, String svalue, Exception e) {
                SupportsTokenHandler.this.handleWarning(index, (byte)-5, "Bad @supports condition value.", e);
                StringBuilder buf = new StringBuilder(32);
                buf.append('(').append(propertyName).append(':').append(svalue).append(')');
                BooleanCondition newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition(buf.toString());
                newCond.setParentCondition(SupportsTokenHandler.this.currentCond.getParentCondition());
                SupportsTokenHandler.this.currentCond = newCond;
            }

            public void rightSquareBracket(int index) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append(']');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 93);
                }
            }

            public void rightCurlyBracket(int index) {
                if (this.readingValue) {
                    SupportsTokenHandler.this.buffer.append('}');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 125);
                }
            }

            public void character(int index, int codepoint) {
                if (this.readingValue) {
                    if (codepoint == 59) {
                        SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                    } else {
                        SupportsTokenHandler.this.bufferAppend(codepoint);
                    }
                } else if (this.functionToken) {
                    SupportsTokenHandler.this.bufferAppend(codepoint);
                } else if (codepoint == 58 && SupportsTokenHandler.this.getCurrentParenDepth() > 0) {
                    BooleanCondition newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createPredicate(SupportsTokenHandler.this.buffer.toString());
                    if (SupportsTokenHandler.this.currentCond != null) {
                        SupportsTokenHandler.this.currentCond.addCondition(newCond);
                    }
                    SupportsTokenHandler.this.currentCond = newCond;
                    SupportsTokenHandler.this.buffer.setLength(0);
                    this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                    this.valueParendepth = (short)(this.valueParendepth - 1);
                    this.readingValue = true;
                    SupportsTokenHandler.this.escapedTokenIndex = -1;
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                }
                SupportsTokenHandler.this.prevcp = codepoint;
            }

            public void quoted(int index, CharSequence quoted, int quoteCp) {
                if (this.readingValue || this.functionToken) {
                    if (SupportsTokenHandler.this.buffer.length() != 0) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                    char c = (char)quoteCp;
                    SupportsTokenHandler.this.buffer.append(c).append(quoted).append(c);
                    SupportsTokenHandler.this.prevcp = 65;
                } else {
                    SupportsTokenHandler.this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
                }
            }

            public void escaped(int index, int codepoint) {
                if (ParseHelper.isHexCodePoint(codepoint) || codepoint == 92) {
                    SupportsTokenHandler.this.setEscapedTokenStart(index);
                    SupportsTokenHandler.this.buffer.append('\\');
                }
                SupportsTokenHandler.this.bufferAppend(codepoint);
            }

            public void separator(int index, int cp) {
                if (SupportsTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(SupportsTokenHandler.this.buffer)) {
                    SupportsTokenHandler.this.buffer.append(' ');
                }
            }

            public void endOfStream(int len) {
                if (SupportsTokenHandler.this.readingPredicate) {
                    SupportsTokenHandler.this.handleError(len, (byte)10, "Unexpected end of file");
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    SupportsTokenHandler.this.handleError(len, (byte)9, "Unexpected token: " + SupportsTokenHandler.this.buffer);
                } else if (SupportsTokenHandler.this.currentCond == null) {
                    SupportsTokenHandler.this.handleError(len, (byte)10, "No condition found");
                }
            }
        }
    }

    private class MediaQueryTokenHandler
    extends ConditionTokenHandler<MediaQueryFactory> {
        private final HashSet<String> mediaTypes;

        MediaQueryTokenHandler(MediaQueryFactory conditionFactory, MediaQueryHandler mqhandler) {
            super(CSSParser.this, (BooleanConditionFactory)conditionFactory);
            this.mediaTypes = new HashSet(10);
            this.setPredicateHandler(new MediaQueryDelegateHandler(mqhandler));
            String[] mediaTypesArray = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
            Collections.addAll(this.mediaTypes, mediaTypesArray);
        }

        private boolean isValidMediaType(String lcmedia) {
            return this.mediaTypes.contains(lcmedia);
        }

        @Override
        MediaQueryDelegateHandler getPredicateHandler() {
            return (MediaQueryDelegateHandler)super.getPredicateHandler();
        }

        @Override
        void processImplicitAnd(int index) {
            MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
            String medium = mqhelper.mediaType;
            if (medium == null) {
                if (this.buffer.length() != 0) {
                    mqhelper.processMediaType(index);
                } else {
                    this.unexpectedTokenError(index, "and");
                    return;
                }
            }
            this.currentCond = ((MediaQueryFactory)this.conditionFactory).createMediaTypePredicate(medium);
            this.processOperation(index, BooleanCondition.Type.AND, "and");
        }

        @Override
        BooleanCondition createOperation(int index, BooleanCondition.Type opType) throws CSSParseException {
            if (opType == BooleanCondition.Type.AND) {
                return ((MediaQueryFactory)this.conditionFactory).createAndCondition();
            }
            if (this.getPredicateHandler().mediaType == null) {
                return ((MediaQueryFactory)this.conditionFactory).createOrCondition();
            }
            throw this.createException(index, (byte)9, "Unexpected 'OR'");
        }

        void emptyQuery(int index) {
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
                CSSParseException ex = this.createException(index, errCode, message);
                mqhelper.handler.invalidQuery(ex);
                if (!mqhelper.handler.reportsErrors() && CSSParser.this.errorHandler != null) {
                    this.handleError(ex);
                }
                this.parseError = true;
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message, Throwable cause) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
                CSSParseException ex = this.createException(index, errCode, message);
                ex.initCause(cause);
                mqhelper.handler.invalidQuery(ex);
                if (!mqhelper.handler.reportsErrors() && CSSParser.this.errorHandler != null) {
                    this.handleError(ex);
                }
                this.parseError = true;
            }
        }

        @Override
        void handleWarning(int index, byte errCode, String message, Throwable cause) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
                CSSParseException ex = this.createException(index, errCode, message);
                if (cause != null) {
                    ex.initCause(cause);
                }
                mqhelper.handler.compatQuery(ex);
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(ex);
                }
            }
        }

        @Override
        CSSParseException createException(int index, byte errCode, String message) {
            this.setCurrentLocation(index);
            Locator locator = this.createLocator();
            return new CSSMediaParseException(message, locator);
        }

        class MediaQueryDelegateHandler
        extends DelegateHandler {
            private final MediaQueryHandler handler;
            private byte stage;
            private boolean negativeQuery;
            private boolean spaceFound;
            private String mediaType;
            private String featureName;
            private String firstValue;
            private byte rangeType;
            private boolean functionToken;
            private static final int WORD_UNQUOTED = 0;

            private MediaQueryDelegateHandler(MediaQueryHandler handler) {
                this.stage = 0;
                this.negativeQuery = false;
                this.spaceFound = false;
                this.mediaType = null;
                this.featureName = null;
                this.firstValue = null;
                this.rangeType = 0;
                this.functionToken = false;
                this.handler = handler;
            }

            MediaQueryHandler getMediaQueryHandler() {
                return this.handler;
            }

            public void word(int index, CharSequence word) {
                if (this.stage == 127) {
                    return;
                }
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0 && MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.buffer.append(word);
                } else if (ParseHelper.equalsIgnoreCase(word, "not")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'not' at the wrong parsing stage");
                    } else {
                        this.negativeQuery = true;
                    }
                } else if (ParseHelper.equalsIgnoreCase(word, "only")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'only' at the wrong parsing stage");
                    } else {
                        this.handler.onlyPrefix();
                    }
                } else if (ParseHelper.equalsIgnoreCase(word, "or")) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'or'");
                } else if (!this.appendWord(index, word, 0)) {
                    return;
                }
                MediaQueryTokenHandler.this.prevcp = 65;
            }

            private boolean appendWord(int index, CharSequence word, int quote) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0 && MediaQueryTokenHandler.this.escapedTokenIndex == -1 && MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                    if (this.stage == 1) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found white space between media");
                        return false;
                    }
                    this.spaceFound = true;
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
                if (quote == 0) {
                    MediaQueryTokenHandler.this.buffer.append(word);
                } else {
                    char c = (char)quote;
                    MediaQueryTokenHandler.this.buffer.append(c).append(word).append(c);
                }
                if (!this.functionToken) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 5) {
                        this.stage = (byte)6;
                    }
                }
                return true;
            }

            @Override
            public void preBooleanHandling(int index, BooleanCondition.Type type) {
                switch (type) {
                    case AND: {
                        if (this.stage > 1) {
                            MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'and' at the wrong parsing stage");
                            return;
                        }
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.processMediaType(index);
                        }
                    }
                    case OR: {
                        this.stage = (byte)2;
                        break;
                    }
                }
            }

            private void processMediaType(int index) {
                if (this.mediaType == null && MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                    this.mediaType = this.rawBuffer().trim();
                    if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                        MediaQueryTokenHandler.this.currentCond = null;
                        this.negativeQuery = true;
                        this.handler.negativeQuery();
                    }
                    this.handler.mediaType(this.mediaType);
                }
            }

            private boolean isEmptyNotCondition() {
                return MediaQueryTokenHandler.this.currentCond.getType() == BooleanCondition.Type.NOT && MediaQueryTokenHandler.this.currentCond.getParentCondition() == null && MediaQueryTokenHandler.this.currentCond.getNestedCondition() == null;
            }

            public void leftParenthesis(int index) {
                if (this.functionToken) {
                    MediaQueryTokenHandler.this.buffer.append('(');
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (!MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        this.functionToken = true;
                        MediaQueryTokenHandler.this.buffer.append('(');
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, 40);
                    }
                } else if (this.stage == 2 || this.stage == 0) {
                    this.stage = (byte)3;
                }
                MediaQueryTokenHandler.this.prevcp = 40;
            }

            public void leftCurlyBracket(int index) {
                MediaQueryTokenHandler.this.handleLeftCurlyBracket(index);
                MediaQueryTokenHandler.this.prevcp = 123;
            }

            public void leftSquareBracket(int index) {
                MediaQueryTokenHandler.this.prevcp = 123;
                MediaQueryTokenHandler.this.unexpectedCharError(index, MediaQueryTokenHandler.this.prevcp);
            }

            public void rightParenthesis(int index) {
                if (this.functionToken) {
                    MediaQueryTokenHandler.this.buffer.append(')');
                    this.functionToken = false;
                } else {
                    if (this.stage == 6) {
                        String tempstr;
                        this.processBuffer(index);
                        if (this.firstValue != null && CSSParser.isKnownFeature(this.firstValue)) {
                            tempstr = this.firstValue;
                            this.firstValue = this.featureName;
                            this.featureName = tempstr;
                        } else if (!CSSParser.isKnownFeature(this.featureName)) {
                            if (CSSParser.isValidFeatureSyntax(this.firstValue)) {
                                tempstr = this.firstValue;
                                this.firstValue = this.featureName;
                                this.featureName = tempstr;
                            } else {
                                if (!CSSParser.isValidFeatureSyntax(this.featureName)) {
                                    MediaQueryTokenHandler.this.handleError(index, (byte)33, "Wrong feature expression near " + this.featureName + " " + this.firstValue + ")");
                                    MediaQueryTokenHandler.this.prevcp = 41;
                                    return;
                                }
                                this.reverseRangetype();
                            }
                        } else {
                            this.reverseRangetype();
                        }
                        LexicalUnit value1 = this.parseMediaFeature(index, this.firstValue);
                        this.handlePredicate(index, this.featureName, this.rangeType, value1, this.firstValue);
                    } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        if (this.stage == 4) {
                            String valueSer = MediaQueryTokenHandler.this.buffer.toString();
                            LexicalUnit value = this.parseMediaFeature(index, valueSer);
                            this.handlePredicate(index, this.featureName, (byte)0, value, valueSer);
                        } else if (this.stage == 7) {
                            LexicalUnit value1 = this.parseMediaFeature(index, this.firstValue);
                            LexicalUnit value2 = this.parseMediaFeature(index, MediaQueryTokenHandler.this.buffer.toString());
                            this.handlePredicate(index, this.featureName, this.rangeType, value1, value2);
                        } else if (this.stage == 3 && !this.spaceFound) {
                            this.handleMediaPredicate(index, MediaQueryTokenHandler.this.buffer.toString());
                        } else {
                            MediaQueryTokenHandler.this.handleError(index, (byte)32, MediaQueryTokenHandler.this.buffer.toString());
                        }
                        MediaQueryTokenHandler.this.buffer.setLength(0);
                        this.spaceFound = false;
                        MediaQueryTokenHandler.this.escapedTokenIndex = -1;
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, 41);
                    }
                    if (this.stage == 5) {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, 41);
                    } else {
                        this.rangeType = 0;
                        this.stage = 1;
                    }
                    MediaQueryTokenHandler.this.readingPredicate = false;
                }
                MediaQueryTokenHandler.this.prevcp = 41;
            }

            private LexicalUnit parseMediaFeature(int index, String feature) {
                LexicalUnit lunit;
                StringReader re = new StringReader(feature);
                try {
                    lunit = CSSParser.this.parsePropertyValue(re, MediaQueryTokenHandler.this.getCurrentLine(), MediaQueryTokenHandler.this.getPrevLineLength() - index);
                }
                catch (CSSException | IOException e) {
                    return null;
                }
                LexicalUnit nlu = lunit.getNextLexicalUnit();
                if (nlu != null && (nlu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH || nlu.getNextLexicalUnit() == null)) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)32, "Invalid feature value: " + feature);
                    lunit = null;
                }
                return lunit;
            }

            private void handleMediaPredicate(int index, String featureName) {
                String lcFeatureName;
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null && MediaQueryTokenHandler.this.isValidMediaType(lcFeatureName = featureName.toLowerCase(Locale.ROOT))) {
                    this.mediaType = lcFeatureName;
                    this.handler.mediaType(lcFeatureName);
                } else {
                    MediaFeaturePredicate predicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(featureName);
                    predicate.setRangeType((byte)0);
                    if (MediaQueryTokenHandler.this.currentCond == null) {
                        MediaQueryTokenHandler.this.currentCond = predicate;
                    } else {
                        MediaQueryTokenHandler.this.currentCond.addCondition(predicate);
                    }
                }
                this.clearPredicate();
            }

            private void handlePredicate(int index, String featureName, byte rangeType, LexicalUnit value, String valueSerialization) {
                if (value == null) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, valueSerialization);
                    this.clearPredicate();
                    return;
                }
                if (value.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                    MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                }
                MediaFeaturePredicate predicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(featureName);
                predicate.setRangeType(rangeType);
                try {
                    predicate.setValue(value);
                }
                catch (DOMException e) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, e.getMessage() + ": " + valueSerialization, e);
                    this.clearPredicate();
                    return;
                }
                MediaFeaturePredicate condition = predicate;
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = condition;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(condition);
                }
                this.clearPredicate();
            }

            private void handlePredicate(int index, String featureName, byte rangeType, LexicalUnit value1, LexicalUnit value2) {
                if (value1 == null) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, this.firstValue);
                    this.clearPredicate();
                    return;
                }
                if (value2 == null) {
                    String s = MediaQueryTokenHandler.this.buffer.toString();
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, s);
                    this.clearPredicate();
                    return;
                }
                if (value1.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT || value2.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                    MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                }
                MediaFeaturePredicate predicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(featureName);
                predicate.setRangeType(rangeType);
                try {
                    predicate.setValueRange(value1, value2);
                }
                catch (DOMException e) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, "Invalid value(s) in range media feature.", e);
                    this.clearPredicate();
                    return;
                }
                MediaFeaturePredicate condition = predicate;
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = condition;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(condition);
                }
                this.clearPredicate();
            }

            private void reverseRangetype() {
                if ((this.rangeType & 2) == 2) {
                    this.rangeType = (byte)(this.rangeType ^ 2);
                    this.rangeType = (byte)(this.rangeType | 4);
                } else if ((this.rangeType & 4) == 4) {
                    this.rangeType = (byte)(this.rangeType ^ 4);
                    this.rangeType = (byte)(this.rangeType | 2);
                }
            }

            public void rightSquareBracket(int index) {
                MediaQueryTokenHandler.this.prevcp = 93;
                MediaQueryTokenHandler.this.unexpectedCharError(index, MediaQueryTokenHandler.this.prevcp);
            }

            public void rightCurlyBracket(int index) {
                MediaQueryTokenHandler.this.prevcp = 125;
                MediaQueryTokenHandler.this.unexpectedCharError(index, MediaQueryTokenHandler.this.prevcp);
            }

            public void character(int index, int codepoint) {
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.bufferAppend(codepoint);
                } else {
                    if (codepoint == 58) {
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.featureName = this.rawBuffer();
                            this.stage = (byte)4;
                        } else {
                            MediaQueryTokenHandler.this.handleError(index, (byte)33, "Empty feature name");
                        }
                    } else if (codepoint == 44) {
                        if (!MediaQueryTokenHandler.this.parseError) {
                            if (MediaQueryTokenHandler.this.getCurrentParenDepth() != 0) {
                                MediaQueryTokenHandler.this.handleError(index, (byte)33, "Unmatched parenthesis");
                                return;
                            }
                            if (this.stage == 0) {
                                MediaQueryTokenHandler.this.handleError(index, (byte)33, "No media found");
                            }
                            this.processBuffer(index);
                            this.endQuery(index);
                        } else if (MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                            this.handler.endQuery();
                            this.clearQuery();
                        }
                        this.handler.startQuery();
                    } else if (codepoint == 46) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('.');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, 46);
                        }
                    } else if (codepoint == 47) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 6 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('/');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 59) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)4, ";");
                    } else if (codepoint == 60) {
                        if (this.stage < 3 || this.rangeType > 3 && ((this.rangeType & 0x10) != 0 || (this.rangeType & 4) != 0)) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 2);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 0x10);
                            this.stage = (byte)7;
                        }
                    } else if (codepoint == 61) {
                        if (this.stage < 3 || this.rangeType > 5 && (this.rangeType & 8) != 0) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 1);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 8);
                            this.stage = (byte)7;
                        }
                    } else if (codepoint == 62 || this.rangeType >= 4 && ((this.rangeType & 0x20) != 0 || (this.rangeType & 2) != 0)) {
                        if (this.stage < 3) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 4);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 0x20);
                            this.stage = (byte)7;
                        }
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                    }
                    if (this.stage == 5 && this.firstValue == null && MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.firstValue = this.rawBuffer();
                    }
                }
            }

            private void processBuffer(int index) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (this.stage == 1) {
                        this.processMediaType(index);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(index, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        MediaQueryTokenHandler.this.readingPredicate = false;
                    } else if (this.stage == 6) {
                        this.featureName = this.rawBuffer();
                    }
                }
            }

            private void endQuery(int index) {
                if (MediaQueryTokenHandler.this.currentCond != null) {
                    while (MediaQueryTokenHandler.this.currentCond.getParentCondition() != null) {
                        MediaQueryTokenHandler.this.currentCond = MediaQueryTokenHandler.this.currentCond.getParentCondition();
                    }
                    this.handler.condition(MediaQueryTokenHandler.this.currentCond);
                } else if (this.negativeQuery && this.mediaType == null) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)32, "Negative query without media.");
                }
                this.handler.endQuery();
                this.clearQuery();
            }

            private void clearQuery() {
                MediaQueryTokenHandler.this.currentCond = null;
                this.mediaType = null;
                this.stage = 0;
                this.negativeQuery = false;
                this.functionToken = false;
                MediaQueryTokenHandler.this.resetHandler();
                this.clearPredicate();
            }

            private void clearPredicate() {
                this.featureName = null;
                this.firstValue = null;
                this.rangeType = 0;
                this.spaceFound = false;
            }

            String rawBuffer() {
                this.spaceFound = false;
                return MediaQueryTokenHandler.this.rawBuffer();
            }

            public void quoted(int index, CharSequence quoted, int quoteCp) {
                MediaQueryTokenHandler.this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
            }

            public void escaped(int index, int codepoint) {
                if (ParseHelper.isHexCodePoint(codepoint) || codepoint == 92) {
                    MediaQueryTokenHandler.this.setEscapedTokenStart(index);
                    MediaQueryTokenHandler.this.buffer.append('\\');
                }
                MediaQueryTokenHandler.this.bufferAppend(codepoint);
                if (this.stage == 5) {
                    this.stage = (byte)6;
                } else if (this.stage == 0) {
                    this.stage = 1;
                }
            }

            public void separator(int index, int cp) {
                if (MediaQueryTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(MediaQueryTokenHandler.this.buffer)) {
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
            }

            public void endOfStream(int len) {
                if (this.stage == 1) {
                    this.processBuffer(len);
                }
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.processMediaType(len);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(len, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        this.handler.endQuery();
                        this.clearQuery();
                    } else if (this.stage == 0) {
                        MediaQueryTokenHandler.this.emptyQuery(len);
                    } else {
                        MediaQueryTokenHandler.this.handleError(len, (byte)10, "No valid query found");
                    }
                } else if (MediaQueryTokenHandler.this.readingPredicate || this.stage > 1) {
                    MediaQueryTokenHandler.this.handleError(len, (byte)10, "Unexpected end of file");
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    MediaQueryTokenHandler.this.handleError(len, (byte)9, "Unexpected token: " + MediaQueryTokenHandler.this.buffer);
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                    MediaQueryTokenHandler.this.handleError(len, (byte)10, "No valid query found");
                    this.handler.endQuery();
                } else {
                    this.endQuery(len);
                }
                this.handler.endQueryList();
            }
        }
    }

    class SelectorTokenHandler
    extends ControlTokenHandler {
        NSACSelectorFactory factory;
        private Parser.NamespaceMap nsMap;
        CSSTokenHandler.MySelectorListImpl selist;
        Selector currentsel;
        private String namespacePrefix;
        byte stage;
        private boolean functionToken;
        private static final byte STAGE_COMBINATOR_OR_END = 2;
        private static final byte STAGE_ATTR_START = 4;
        private static final byte STAGE_ATTR_EXPECT_SYMBOL_OR_CLOSE = 7;
        private static final byte STAGE_ATTR_SYMBOL = 5;
        private static final byte STAGE_ATTR_POST_SYMBOL = 6;
        private static final byte STAGE_EXPECT_ID_OR_CLASSNAME = 8;
        private static final byte STAGE_EXPECT_PSEUDOELEM_NAME = 9;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_NAME = 10;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_ARGUMENT = 11;

        SelectorTokenHandler() {
            this(new NSACSelectorFactory());
        }

        SelectorTokenHandler(Parser.NamespaceMap nsMap) {
            this.selist = new CSSTokenHandler.MySelectorListImpl();
            this.currentsel = null;
            this.namespacePrefix = null;
            this.stage = 0;
            this.factory = new NSACSelectorFactory();
            this.nsMap = nsMap == null ? this.factory : nsMap;
            this.buffer = new StringBuilder(64);
        }

        SelectorTokenHandler(NSACSelectorFactory factory) {
            this.selist = new CSSTokenHandler.MySelectorListImpl();
            this.currentsel = null;
            this.namespacePrefix = null;
            this.stage = 0;
            this.factory = factory;
            this.nsMap = factory;
            this.buffer = new StringBuilder(64);
        }

        SelectorListImpl getSelectorList() {
            return this.selist;
        }

        SelectorListImpl getTrimmedSelectorList() {
            this.selist.trimToSize();
            return this.selist;
        }

        public void word(int index, CharSequence word) {
            if (this.buffer.length() != 0 && this.isPrevCpWhitespace()) {
                this.buffer.append(' ');
            }
            if (this.stage == 4 && this.prevcp != 65 && this.prevcp != 124) {
                this.unexpectedTokenError(index, word);
            } else if (this.stage == 0) {
                this.stage = 1;
                this.buffer.append(word);
            } else if (this.stage == 2) {
                this.buffer.append(word);
                this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                this.stage = 1;
            } else if (this.stage == 6 && this.isPrevCpWhitespace()) {
                if (word.length() == 1) {
                    char c = word.charAt(0);
                    if (c == 'i' || c == 'I') {
                        this.setAttributeConditionFlag(AttributeCondition.Flag.CASE_I);
                    } else if (c == 's' || c == 'S') {
                        this.setAttributeConditionFlag(AttributeCondition.Flag.CASE_S);
                    } else {
                        this.handleError(index, (byte)4, "Expected 'i', found: '" + c + '\'');
                    }
                    if (this.buffer.length() != 0) {
                        this.handleError(index, (byte)9, "Expected 'i' or 's', found: '" + this.buffer.toString() + '\'');
                        this.buffer.setLength(0);
                    }
                } else {
                    this.handleError(index, (byte)9, "Expected 'i', found: '" + word + "'");
                }
            } else if (this.stage == 1) {
                if (this.prevcp != 42) {
                    this.buffer.append(word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else if (this.stage != 7) {
                this.buffer.append(word);
            } else {
                this.unexpectedTokenError(index, word);
            }
            this.prevcp = 65;
        }

        public void separator(int index, int codepoint) {
            if (!this.parseError) {
                if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                    return;
                }
                if (this.prevcp == 58 || this.prevcp == 46 || this.prevcp == 35 || this.prevcp == 124 && this.getActiveSelector() == null) {
                    this.unexpectedCharError(index, codepoint);
                    return;
                }
                if (this.stage == 5) {
                    if (this.buffer.length() != 0) {
                        this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                        this.stage = (byte)6;
                    }
                } else if (this.stage == 1 || this.stage == 8 || this.stage == 9 || this.stage == 10) {
                    this.processBuffer(index, codepoint, false);
                    if (this.prevcp == 65 || this.prevcp == 42 || this.prevcp == 41 || this.prevcp == 93) {
                        this.stage = (byte)2;
                    }
                } else if (this.stage == 4) {
                    if (this.buffer.length() != 0) {
                        this.stage = (byte)7;
                    } else if (this.namespacePrefix != null) {
                        this.unexpectedCharError(index, codepoint);
                    }
                    return;
                }
                if (this.prevcp != 44) {
                    this.setWhitespacePrevCp();
                }
            }
        }

        @Override
        String unescapeBuffer(int index) {
            String s;
            if (this.namespacePrefix == null) {
                s = this.unescapeStringValue(index);
            } else {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected token: " + this.namespacePrefix);
                this.namespacePrefix = null;
                s = "";
            }
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
            return s;
        }

        private void processBuffer(int index, int triggerCp, boolean lastStage) {
            if (this.prevcp == 42) {
                if (this.currentsel == null || this.currentsel.getSelectorType() != Selector.SelectorType.UNIVERSAL) {
                    this.setSimpleSelector(index, this.factory.getUniversalSelector(this.namespacePrefix));
                }
            } else if (this.stage == 2) {
                if (!lastStage) {
                    this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                    if (this.buffer.length() != 0) {
                        NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                        String raw = this.buffer.toString();
                        if (this.isNotForbiddenIdentStart(raw)) {
                            String s;
                            sel.localName = s = this.unescapeBuffer(index);
                            this.stage = 1;
                        } else {
                            this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                        }
                    }
                }
            } else if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    String uri;
                    String raw = this.buffer.toString();
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix == null) {
                        uri = this.getDefaultNamespaceURI();
                    } else {
                        uri = this.getNamespaceURI(index);
                        if (this.parseError) {
                            return;
                        }
                    }
                    sel.namespaceUri = uri;
                    if (this.isNotForbiddenIdentStart(raw)) {
                        String s;
                        sel.localName = s = this.unescapeBuffer(index);
                    } else {
                        this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                    }
                } else if (this.stage == 8) {
                    String raw = this.buffer.toString();
                    if (this.isNotForbiddenIdentStart(raw)) {
                        String s = this.unescapeBuffer(index).trim();
                        this.setAttributeSelectorValue(index, s);
                        this.stage = 1;
                    } else {
                        this.handleError(index - raw.length(), (byte)7, "Invalid class name: " + raw);
                    }
                } else if (this.stage == 10) {
                    this.newConditionalSelector(index, triggerCp, Condition.ConditionType.PSEUDO_CLASS);
                    this.stage = 1;
                } else if (this.stage == 9) {
                    this.newConditionalSelector(index, triggerCp, Condition.ConditionType.PSEUDO_ELEMENT);
                    this.stage = 1;
                } else if (this.stage != 11) {
                    if (this.stage == 6) {
                        this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    } else {
                        this.handleError(index, (byte)9, "Unexpected: <" + this.buffer + ">");
                        this.buffer.setLength(0);
                    }
                }
            } else if (this.namespacePrefix != null) {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected: " + this.namespacePrefix + "|");
                this.namespacePrefix = null;
            } else if (this.stage > 1 && this.stage != 11) {
                this.unexpectedCharError(index, triggerCp);
            }
        }

        public void quoted(int index, CharSequence quoted, int quoteChar) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else if (this.stage == 11) {
                if (this.buffer.length() != 0 && this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                char c = (char)quoteChar;
                this.buffer.append(c).append(quoted).append(c);
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
            this.prevcp = 65;
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else {
                this.handleError(index, (byte)9, "Quoted string contained unexpected control character: \"" + quoted + '\"');
            }
            this.prevcp = 65;
        }

        private void setAttributeSelectorValue(int index, CharSequence value) {
            NSACSelectorFactory.AttributeConditionImpl attrcond;
            Condition cond = null;
            if (this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                if (!(simple instanceof ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof ConditionalSelectorImpl) {
                cond = ((ConditionalSelectorImpl)this.currentsel).condition;
            }
            if (cond instanceof CombinatorConditionImpl) {
                cond = ((CombinatorConditionImpl)cond).getSecondCondition();
            }
            if (cond instanceof NSACSelectorFactory.AttributeConditionImpl && (attrcond = (NSACSelectorFactory.AttributeConditionImpl)cond) != null) {
                String oldValue = attrcond.getValue();
                if (oldValue == null) {
                    attrcond.setValue(value.toString());
                } else {
                    StringBuilder buf = new StringBuilder(oldValue.length() + value.length() + 1);
                    buf.append(oldValue);
                    if (this.isPrevCpWhitespace()) {
                        buf.append(' ');
                    }
                    attrcond.setValue(buf.append(value).toString());
                }
                return;
            }
            this.handleError(index, (byte)9, "Unexpected token in selector: <" + value + ">");
        }

        private void setAttributeConditionFlag(AttributeCondition.Flag flag) {
            Selector simple = this.getActiveSelector();
            if (simple == null || simple.getSelectorType() != Selector.SelectorType.CONDITIONAL) {
                throw new IllegalStateException("Processing attribute modifier of non-conditional selector");
            }
            Condition cond = ((ConditionalSelectorImpl)simple).getCondition();
            if (cond.getConditionType() == Condition.ConditionType.AND) {
                cond = ((CombinatorCondition)cond).getSecondCondition();
            }
            ((NSACSelectorFactory.AttributeConditionImpl)cond).setFlag(flag);
        }

        private Selector getActiveSelector() {
            Selector sel = this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl ? ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector() : this.currentsel;
            return sel;
        }

        private Condition getActiveCondition(Condition cond) {
            while (cond.getConditionType() == Condition.ConditionType.AND) {
                cond = ((CombinatorConditionImpl)cond).getSecondCondition();
            }
            return cond;
        }

        public void leftParenthesis(int index) {
            this.parendepth = (short)(this.parendepth + 1);
            if (this.stage == 11) {
                this.buffer.append('(');
                this.prevcp = 40;
            } else if (!this.parseError) {
                if (this.prevcp != 65 || this.buffer.length() == 0 || this.stage != 10) {
                    this.unexpectedCharError(index, 40);
                } else {
                    this.newConditionalSelector(index, 40, Condition.ConditionType.PSEUDO_CLASS);
                    if (!this.parseError) {
                        this.stage = (byte)11;
                        this.functionToken = true;
                    }
                }
            }
            this.prevcp = 40;
        }

        public void leftSquareBracket(int index) {
            if (this.stage == 11) {
                this.buffer.append('[');
                this.prevcp = 91;
            } else if (!this.parseError) {
                if (this.prevcp != 65 && CSSParser.isNotSeparator(this.prevcp) && this.prevcp != 42 && this.prevcp != 44 && this.prevcp != 93 && this.prevcp != 41 && this.prevcp != 43 && this.prevcp != 62 && this.prevcp != 125 && this.prevcp != 126 && this.prevcp != 124) {
                    this.unexpectedCharError(index, 91);
                } else {
                    this.processBuffer(index, 91, false);
                    this.stage = (byte)4;
                    this.prevcp = 65;
                }
            }
        }

        public void leftCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '{'");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rightParenthesis(int index) {
            block18: {
                block19: {
                    block20: {
                        this.decrParenDepth(index);
                        if (this.stage != 11) break block19;
                        if (this.parendepth != 0) {
                            this.buffer.append(')');
                            this.prevcp = 41;
                            return;
                        }
                        Selector sel = this.getActiveSelector();
                        if (sel.getSelectorType() != Selector.SelectorType.CONDITIONAL) break block20;
                        Condition cond = ((ConditionalSelectorImpl)sel).condition;
                        cond = this.getActiveCondition(cond);
                        Condition.ConditionType condtype = cond.getConditionType();
                        if (this.buffer.length() != 0) {
                            if (condtype == Condition.ConditionType.SELECTOR_ARGUMENT) {
                                try {
                                    ((SelectorArgumentConditionImpl)cond).arguments = CSSParser.this.parseSelectorArgument(this.rawBuffer(), this.factory);
                                }
                                catch (CSSParseException e) {
                                    byte errCode = e.getClass() == CSSNamespaceParseException.class ? (byte)15 : 32;
                                    CSSParseException ex = this.createException(index, errCode, e.getMessage());
                                    this.handleError(ex);
                                    this.stage = (byte)127;
                                }
                            } else if (condtype == Condition.ConditionType.POSITIONAL) {
                                String arg;
                                if (((PositionalConditionImpl)cond).hasArgument() && !this.parsePositionalArgument((PositionalConditionImpl)cond, arg = this.rawBuffer())) {
                                    this.handleError(index, (byte)32, "Wrong subexpression: " + arg);
                                }
                            } else if (condtype == Condition.ConditionType.LANG) {
                                int len;
                                String s = this.unescapeBuffer(index);
                                if (s.charAt((len = s.length()) - 1) == ',') {
                                    this.handleError(index - 2, (byte)9, "Unexpected functional argument: " + s);
                                    return;
                                }
                                ((LangConditionImpl)cond).lang = s;
                            } else if (condtype == Condition.ConditionType.PSEUDO_CLASS) {
                                String s = this.unescapeBuffer(index);
                                char c = s.charAt(0);
                                if (c != '\"' && c != '\'' && !this.isValidPseudoName(s)) {
                                    this.handleError(index - s.length() - 1, (byte)9, "Unexpected functional argument: " + s);
                                    return;
                                }
                                ((PseudoConditionImpl)cond).argument = s;
                            }
                            this.buffer.setLength(0);
                            this.stage = 1;
                            break block18;
                        } else if (condtype == Condition.ConditionType.LANG || condtype == Condition.ConditionType.SELECTOR_ARGUMENT || condtype == Condition.ConditionType.POSITIONAL) {
                            this.unexpectedCharError(index, 41);
                            break block18;
                        } else {
                            this.unexpectedCharError(index - 1, 41);
                        }
                        break block18;
                    }
                    this.unexpectedCharError(index, 41);
                    break block18;
                }
                this.unexpectedCharError(index, 41);
            }
            if (this.functionToken) {
                this.functionToken = false;
            }
            this.prevcp = 41;
        }

        public void rightSquareBracket(int index) {
            if (this.stage == 11) {
                this.buffer.append(']');
            } else if (this.stage == 6) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                }
                this.stage = 1;
            } else if (this.stage == 4 || this.stage == 7) {
                if (this.buffer.length() != 0) {
                    this.newConditionalSelector(index, 93, Condition.ConditionType.ATTRIBUTE);
                    this.stage = 1;
                } else {
                    this.handleError(index, (byte)4, "Unexpected ']', expected attribute name");
                }
            } else if (this.stage == 5) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    this.stage = 1;
                } else {
                    this.handleError(index, (byte)4, "Unexpected ']', expected attribute value");
                }
            } else {
                this.unexpectedCharError(index, 93);
            }
            this.prevcp = 93;
        }

        public void rightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        public void character(int index, int codepoint) {
            block110: {
                if (!this.skipCharacterHandling()) {
                    if (this.stage == 11) {
                        if (codepoint == 44 && (this.prevcp == 44 || this.buffer.length() == 0)) {
                            this.unexpectedCharError(index, codepoint);
                            return;
                        }
                        if (this.isPrevCpWhitespace() && this.buffer.length() != 0) {
                            this.buffer.append(' ');
                        }
                        this.bufferAppend(codepoint);
                    } else if (this.stage == 4 || this.stage == 7) {
                        if (codepoint == 124) {
                            if (this.stage == 4) {
                                if (this.namespacePrefix == null) {
                                    this.readNamespacePrefix(index, codepoint);
                                } else {
                                    this.unexpectedCharError(index, codepoint);
                                }
                            } else if (this.prevcp != 65) {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (codepoint == 61) {
                            if (this.prevcp == 124 && this.namespacePrefix != null && this.buffer.length() == 0) {
                                this.buffer.append(this.namespacePrefix);
                                this.namespacePrefix = null;
                            }
                            if (this.prevcp == 124) {
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.BEGIN_HYPHEN_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 126) {
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.ONE_OF_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 36) {
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.ENDS_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 94) {
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.BEGINS_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 42) {
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.SUBSTRING_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 65) {
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.ATTRIBUTE);
                                this.stage = (byte)5;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (this.buffer.length() == 0) {
                            if (codepoint != 126 && codepoint != 36 && codepoint != 94 && codepoint != 42) {
                                if (this.stage == 4 && ParseHelper.isValidXMLStartCharacter(codepoint)) {
                                    this.bufferAppend(codepoint);
                                    this.prevcp = 65;
                                    return;
                                }
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (codepoint != 126 && codepoint != 36 && codepoint != 94 && codepoint != 42) {
                            if (this.stage == 4 && ParseHelper.isValidXMLCharacter(codepoint)) {
                                this.bufferAppend(codepoint);
                                this.prevcp = 65;
                                return;
                            }
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 42) {
                        if (this.stage == 0) {
                            this.stage = 1;
                        } else if (this.stage == 2) {
                            this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                            ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.getUniversalSelector(this.namespacePrefix);
                            this.namespacePrefix = null;
                            this.stage = 1;
                        } else if (this.stage == 1 && this.namespacePrefix != null && this.prevcp == 124) {
                            this.setSimpleSelector(index, this.factory.createUniversalSelector(this.getNamespaceURI(index)));
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else {
                        if (this.prevcp == 124) {
                            if (codepoint == 124) {
                                this.handleColumnCombinator(index);
                                this.prevcp = 32;
                                return;
                            }
                            this.unexpectedCharError(index, codepoint);
                            return;
                        }
                        if (codepoint == 126) {
                            if (this.stage == 2) {
                                this.stage = 1;
                            } else {
                                this.processBuffer(index, codepoint, false);
                            }
                            this.newCombinatorSelector(index, Selector.SelectorType.SUBSEQUENT_SIBLING, codepoint);
                        } else if (codepoint == 46) {
                            if (this.stage != 8 || this.buffer.length() != 0) {
                                this.processBuffer(index, codepoint, false);
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.CLASS);
                                this.stage = (byte)8;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (codepoint == 35) {
                            if (this.stage != 8 || this.buffer.length() != 0) {
                                this.processBuffer(index, codepoint, false);
                                this.newConditionalSelector(index, codepoint, Condition.ConditionType.ID);
                                this.stage = (byte)8;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (codepoint == 58) {
                            if (this.prevcp == 58) {
                                this.stage = (byte)9;
                            } else {
                                this.processBuffer(index, codepoint, false);
                                this.stage = (byte)10;
                            }
                        } else if (codepoint == 62) {
                            if (this.stage == 2) {
                                this.stage = 1;
                            } else if (this.stage == 1 && CSSParser.equalSequences("--", this.buffer)) {
                                if (this.isTopLevel() && this.prevcp == 65 && this.escapedTokenIndex == -1 && !this.functionToken) {
                                    this.buffer.setLength(0);
                                    this.stage = 0;
                                    this.prevcp = 32;
                                    return;
                                }
                                this.unexpectedCharError(index, codepoint);
                            }
                            this.processBuffer(index, codepoint, false);
                            if (this.stage < 2) {
                                this.newCombinatorSelector(index, Selector.SelectorType.CHILD, codepoint);
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (codepoint == 43) {
                            if (this.stage == 2) {
                                this.stage = 1;
                            }
                            this.processBuffer(index, codepoint, false);
                            this.newCombinatorSelector(index, Selector.SelectorType.DIRECT_ADJACENT, codepoint);
                        } else if (codepoint == 124) {
                            if (this.stage == 8 || this.stage == 10 || this.stage == 9) {
                                this.processBuffer(index, codepoint, false);
                                try {
                                    int ncp = this.getTokenControl().skipNextCodepoint();
                                    if (ncp != 124) {
                                        if (ncp == -1) {
                                            this.handleError(index + 1, (byte)10, "EOF while processing column combinator selector");
                                        } else {
                                            this.unexpectedCharError(index + 1, ncp);
                                        }
                                        break block110;
                                    }
                                    this.newCombinatorSelector(index, Selector.SelectorType.COLUMN_COMBINATOR, 124);
                                    this.prevcp = 32;
                                    return;
                                }
                                catch (IOException e) {
                                    this.handleError(index + 1, (byte)11, "I/O Error when processing column combinator selector", e);
                                }
                            } else if (this.stage == 2) {
                                this.stage = 1;
                            } else if (this.stage == 1 && this.namespacePrefix == null) {
                                this.readNamespacePrefix(index, codepoint);
                            } else if (this.stage == 0 && this.namespacePrefix == null && this.buffer.length() == 0) {
                                this.namespacePrefix = "";
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (codepoint == 44) {
                            if (this.functionToken) {
                                if (this.prevcp == 44) {
                                    this.unexpectedCharError(index, codepoint);
                                } else {
                                    this.buffer.append(',');
                                }
                            } else {
                                this.processBuffer(index, codepoint, true);
                                if (!this.parseError) {
                                    if (this.addCurrentSelector(index)) {
                                        this.stage = 0;
                                    } else {
                                        this.unexpectedCharError(index, codepoint);
                                    }
                                }
                            }
                        } else if (codepoint == 64) {
                            this.handleAtKeyword(index);
                        } else if (codepoint == 45) {
                            this.buffer.append('-');
                        } else if (codepoint == 95) {
                            this.buffer.append('_');
                        } else {
                            if (this.stage < 8) {
                                if (this.stage == 0) {
                                    if (ParseHelper.isValidXMLStartCharacter(codepoint)) {
                                        this.bufferAppend(codepoint);
                                        this.stage = 1;
                                        this.prevcp = 65;
                                        return;
                                    }
                                } else if (ParseHelper.isValidXMLCharacter(codepoint)) {
                                    this.bufferAppend(codepoint);
                                    this.prevcp = 65;
                                    return;
                                }
                                if (codepoint == 60 && this.isTopLevel()) {
                                    this.processBuffer(index, codepoint, false);
                                    this.handleCDO();
                                    this.prevcp = 32;
                                    return;
                                }
                            } else if (!this.isUnexpectedCharacter(codepoint)) {
                                this.bufferAppend(codepoint);
                                this.prevcp = 65;
                                return;
                            }
                            this.unexpectedCharError(index, codepoint);
                        }
                    }
                }
            }
            this.prevcp = codepoint;
        }

        boolean skipCharacterHandling() {
            return this.parseError;
        }

        private void handleColumnCombinator(int index) {
            if (this.stage == 1) {
                if (this.currentsel == null) {
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix != null) {
                        sel.localName = this.namespacePrefix;
                        this.namespacePrefix = null;
                    } else if (this.buffer.length() != 0) {
                        sel.localName = this.unescapeBuffer(index);
                    } else {
                        this.unexpectedCharError(index, 124);
                        return;
                    }
                }
                this.newCombinatorSelector(index, Selector.SelectorType.COLUMN_COMBINATOR, 124);
            } else if (this.stage == 0 && this.buffer.length() == 0 && this.currentsel == null) {
                this.namespacePrefix = null;
                this.newCombinatorSelector(index, Selector.SelectorType.COLUMN_COMBINATOR, 124);
            } else {
                this.unexpectedCharError(index, 124);
            }
        }

        private boolean isUnexpectedCharacter(int cp) {
            return cp == 33 || cp == 36 || cp == 37 || cp == 38 || cp == 47 || cp >= 59 && cp <= 63 || cp == 94 || cp == 96;
        }

        private void handleCDO() {
            CDOTokenHandler cdoCdcTH = new CDOTokenHandler(this.getTokenControl());
            this.getTokenControl().setTokenHandler((TokenHandler3)cdoCdcTH);
        }

        private void readNamespacePrefix(int index, int codepoint) {
            if (this.prevcp == 65) {
                this.namespacePrefix = this.unescapeBuffer(index);
            } else if (this.prevcp == 42 && this.buffer.length() == 0) {
                this.namespacePrefix = "*";
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void newConditionalSelector(int index, int triggerCp, Condition.ConditionType condtype) {
            Condition condition;
            String lcname;
            String name;
            block26: {
                block27: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            name = this.rawBuffer();
                                                            lcname = name.toLowerCase(Locale.ROOT).intern();
                                                            if (condtype != Condition.ConditionType.PSEUDO_CLASS) break block27;
                                                            if (!"lang".equals(lcname)) break block28;
                                                            condition = this.factory.createCondition(Condition.ConditionType.LANG);
                                                            break block26;
                                                        }
                                                        if (!"first-child".equals(lcname)) break block29;
                                                        if (triggerCp == 40) {
                                                            this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                                                            return;
                                                        }
                                                        condition = this.factory.createPositionalCondition();
                                                        break block26;
                                                    }
                                                    if (!"nth-child".equals(lcname)) break block30;
                                                    condition = this.factory.createPositionalCondition(true);
                                                    break block26;
                                                }
                                                if (!"last-child".equals(lcname)) break block31;
                                                if (triggerCp == 40) {
                                                    this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                                                    return;
                                                }
                                                condition = this.factory.createPositionalCondition();
                                                ((PositionalConditionImpl)condition).offset = 1;
                                                ((PositionalConditionImpl)condition).forwardCondition = false;
                                                break block26;
                                            }
                                            if (!"nth-last-child".equals(lcname)) break block32;
                                            condition = this.factory.createPositionalCondition(true);
                                            ((PositionalConditionImpl)condition).offset = 1;
                                            ((PositionalConditionImpl)condition).forwardCondition = false;
                                            break block26;
                                        }
                                        if (!"first-of-type".equals(lcname)) break block33;
                                        condition = this.factory.createPositionalCondition();
                                        ((PositionalConditionImpl)condition).oftype = true;
                                        ((PositionalConditionImpl)condition).offset = 1;
                                        break block26;
                                    }
                                    if (!"last-of-type".equals(lcname)) break block34;
                                    if (triggerCp == 40) {
                                        this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                                        return;
                                    }
                                    condition = this.factory.createPositionalCondition();
                                    ((PositionalConditionImpl)condition).oftype = true;
                                    ((PositionalConditionImpl)condition).offset = 1;
                                    ((PositionalConditionImpl)condition).forwardCondition = false;
                                    break block26;
                                }
                                if (!"nth-of-type".equals(lcname)) break block35;
                                condition = this.factory.createPositionalCondition(true);
                                ((PositionalConditionImpl)condition).oftype = true;
                                break block26;
                            }
                            if (!"nth-last-of-type".equals(lcname)) break block36;
                            condition = this.factory.createPositionalCondition(true);
                            ((PositionalConditionImpl)condition).oftype = true;
                            ((PositionalConditionImpl)condition).forwardCondition = false;
                            break block26;
                        }
                        if (!"only-child".equals(lcname)) break block37;
                        if (triggerCp == 40) {
                            this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                            return;
                        }
                        condition = this.factory.createCondition(Condition.ConditionType.ONLY_CHILD);
                        break block26;
                    }
                    if ("only-of-type".equals(lcname)) {
                        if (triggerCp == 40) {
                            this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                            return;
                        }
                        condition = this.factory.createCondition(Condition.ConditionType.ONLY_TYPE);
                        break block26;
                    } else if ("not".equals(lcname) || "is".equals(lcname) || "has".equals(lcname) || "where".equals(lcname)) {
                        if (triggerCp != 40) {
                            StringBuilder buf = new StringBuilder(name.length() * 2 + 26);
                            buf.append("Expected ':").append(name).append("(', found ':").append(name).appendCodePoint(triggerCp).append('\'');
                            this.handleError(index, (byte)4, buf.toString());
                            return;
                        }
                        condition = this.factory.createCondition(Condition.ConditionType.SELECTOR_ARGUMENT);
                        ((SelectorArgumentConditionImpl)condition).setName(lcname);
                        break block26;
                    } else {
                        if ("first-line".equals(lcname) || "first-letter".equals(lcname) || "before".equals(lcname) || "after".equals(lcname)) {
                            condtype = Condition.ConditionType.PSEUDO_ELEMENT;
                        }
                        condition = this.factory.createCondition(condtype);
                    }
                    break block26;
                }
                condition = this.factory.createCondition(condtype);
            }
            if (condition.getConditionType() == Condition.ConditionType.PSEUDO_CLASS) {
                if (!this.isValidPseudoName(name)) {
                    this.handleError(index - name.length(), (byte)7, "Invalid pseudo-class: " + name);
                    return;
                }
                ((PseudoConditionImpl)condition).name = this.safeUnescapeIdentifier(index, name);
            } else if (condition.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT) {
                if (!this.isValidPseudoName(name)) {
                    this.handleError(index - name.length(), (byte)7, "Invalid pseudo-element: " + name);
                    return;
                }
                if (triggerCp == 40) {
                    this.handleError(index, (byte)4, "Invalid pseudo-element declaration: " + name + '(');
                    return;
                }
                ((PseudoConditionImpl)condition).name = this.safeUnescapeIdentifier(index, name);
            }
            if (name.length() != 0 && condition instanceof NSACSelectorFactory.AttributeConditionImpl) {
                switch (condition.getConditionType()) {
                    case ATTRIBUTE: 
                    case BEGIN_HYPHEN_ATTRIBUTE: 
                    case ONE_OF_ATTRIBUTE: 
                    case ENDS_ATTRIBUTE: 
                    case SUBSTRING_ATTRIBUTE: 
                    case BEGINS_ATTRIBUTE: {
                        if (this.namespacePrefix != null) {
                            ((NSACSelectorFactory.AttributeConditionImpl)condition).setNamespaceURI(this.getNamespaceURI(index));
                        }
                        if (!this.isNotForbiddenIdentStart(name)) {
                            this.handleError(index - name.length(), (byte)7, "Invalid pseudo-class: " + name);
                            return;
                        }
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).setLocalName(this.safeUnescapeIdentifier(index, name).trim());
                        break;
                    }
                    default: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).setValue(lcname.trim());
                    }
                }
            }
            if (this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                if (simple != null && simple.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                    CombinatorConditionImpl andcond = (CombinatorConditionImpl)this.factory.createCondition(Condition.ConditionType.AND);
                    andcond.first = ((ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((ConditionalSelectorImpl)simple).getSimpleSelector(), andcond);
                    return;
                }
                ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector, condition);
                return;
            }
            if (this.currentsel != null && this.currentsel.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                CombinatorConditionImpl andcond = (CombinatorConditionImpl)this.factory.createCondition(Condition.ConditionType.AND);
                andcond.first = ((ConditionalSelectorImpl)this.currentsel).getCondition();
                andcond.second = condition;
                this.currentsel = this.factory.createConditionalSelector(((ConditionalSelectorImpl)this.currentsel).getSimpleSelector(), andcond);
                return;
            }
            this.currentsel = this.factory.createConditionalSelector((SimpleSelector)this.currentsel, condition);
        }

        private boolean parsePositionalArgument(PositionalConditionImpl cond, String expression) {
            MyAnBExpression expr = new MyAnBExpression();
            try {
                expr.parse(expression);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            cond.offset = expr.getOffset();
            cond.slope = expr.getStep();
            cond.ofList = expr.getSelectorList();
            cond.hasKeyword = expr.isKeyword();
            return true;
        }

        private String getDefaultNamespaceURI() {
            String uri = this.nsMap.getNamespaceURI("");
            if (uri != null && this.factory != this.nsMap) {
                this.factory.registerNamespacePrefix("", uri);
            }
            return uri;
        }

        private String getNamespaceURI(int index) {
            String uri;
            if (this.namespacePrefix.length() != 0) {
                uri = this.nsMap.getNamespaceURI(this.namespacePrefix);
                if (uri != null) {
                    if (this.factory != this.nsMap) {
                        this.factory.registerNamespacePrefix(this.namespacePrefix, uri);
                    }
                } else if (!this.namespacePrefix.equals("*")) {
                    this.handleError(index - this.buffer.length() - this.namespacePrefix.length() - 1, (byte)15, "Unknown namespace prefix: " + this.namespacePrefix);
                }
            } else {
                uri = "";
            }
            this.namespacePrefix = null;
            return uri;
        }

        private NSACSelectorFactory.ElementSelectorImpl newElementSelector(int index) {
            NSACSelectorFactory.ElementSelectorImpl elemsel = this.factory.createElementSelector();
            this.setSimpleSelector(index, elemsel);
            return elemsel;
        }

        private void setSimpleSelector(int index, SimpleSelector simple) {
            if (this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl) {
                ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = simple;
            } else if (this.currentsel != null) {
                this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token after '" + this.currentsel.toString() + "': " + simple.toString());
            } else {
                this.currentsel = simple;
            }
        }

        protected void newCombinatorSelector(int index, Selector.SelectorType type, int triggerCp) {
            if (this.currentsel != null && this.isValidCurrentSelector()) {
                this.newCombinatorSelector(type);
            } else {
                this.unexpectedCharError(index, triggerCp);
            }
        }

        void newCombinatorSelector(Selector.SelectorType type) {
            this.currentsel = this.factory.createCombinatorSelector(type, this.currentsel);
            this.stage = 0;
        }

        public void escaped(int index, int codepoint) {
            if (this.stage == 4 || this.stage == 5 || this.stage == 8 || this.stage == 11 || this.stage == 0 || this.stage == 2) {
                if (ParseHelper.isHexCodePoint(codepoint) || codepoint == 92) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                } else {
                    Selector sel;
                    if (Character.isISOControl(codepoint)) {
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    if (this.stage == 11 && (sel = this.getActiveSelector()).getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                        Condition cond = ((ConditionalSelectorImpl)sel).condition;
                        if ((cond = this.getActiveCondition(cond)).getConditionType() == Condition.ConditionType.SELECTOR_ARGUMENT) {
                            this.buffer.append('\\');
                        }
                    }
                }
                this.bufferAppend(codepoint);
                if (this.stage == 0) {
                    this.stage = 1;
                }
                this.prevcp = 65;
            } else {
                this.unexpectedCharError(index - 1, 92);
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (this.stage == 0 && this.selist.size() == 0) {
                super.commented(index, commentType, comment);
            } else {
                this.separator(index, 12);
                if (this.prevcp != 44) {
                    this.prevcp = 12;
                }
            }
        }

        public void endOfStream(int len) {
            if (!this.parseError) {
                this.processBuffer(len, 32, true);
                if (!this.parseError && !this.addCurrentSelector(len)) {
                    this.handleError(len, (byte)10, "Unexpected end of stream");
                }
            }
        }

        boolean addCurrentSelector(int index) {
            if (this.currentsel != null) {
                if (this.isValidCurrentSelector()) {
                    this.selist.add(this.currentsel, index);
                    this.currentsel = null;
                    return true;
                }
                this.selist.clear();
                this.currentsel = null;
            }
            return false;
        }

        boolean isValidCurrentSelector() {
            SimpleSelector last = null;
            switch (this.currentsel.getSelectorType()) {
                case CHILD: 
                case DESCENDANT: 
                case COLUMN_COMBINATOR: 
                case DIRECT_ADJACENT: 
                case SUBSEQUENT_SIBLING: {
                    last = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                    break;
                }
                case CONDITIONAL: {
                    Condition cond = ((ConditionalSelectorImpl)this.currentsel).getCondition();
                    Condition.ConditionType condtype = cond.getConditionType();
                    while (condtype == Condition.ConditionType.AND) {
                        if ((cond = ((CombinatorCondition)cond).getSecondCondition()) == null) {
                            return false;
                        }
                        condtype = cond.getConditionType();
                    }
                    switch (condtype) {
                        case ATTRIBUTE: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getLocalName() != null) break;
                            return false;
                        }
                        case PSEUDO_CLASS: 
                        case PSEUDO_ELEMENT: {
                            if (((PseudoConditionImpl)cond).name != null) break;
                            return false;
                        }
                        case BEGIN_HYPHEN_ATTRIBUTE: 
                        case ONE_OF_ATTRIBUTE: 
                        case ENDS_ATTRIBUTE: 
                        case SUBSTRING_ATTRIBUTE: 
                        case BEGINS_ATTRIBUTE: 
                        case CLASS: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getValue() != null) break;
                            return false;
                        }
                        case LANG: {
                            if (((LangConditionImpl)cond).getLang() != null) break;
                            return false;
                        }
                        case SELECTOR_ARGUMENT: {
                            if (((SelectorArgumentConditionImpl)cond).getSelectors() != null) break;
                            return false;
                        }
                    }
                }
                default: {
                    return true;
                }
            }
            return last != null;
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.stage = 0;
            this.functionToken = false;
            this.escapedTokenIndex = -1;
            this.buffer.setLength(0);
            this.namespacePrefix = null;
            this.currentsel = null;
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            if (errCode == 1) {
                index -= context.length() + 1;
            }
            super.error(index, errCode, context);
            this.currentsel = null;
            this.selist.clear();
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                this.stage = (byte)127;
                if (this.prevcp == this.endcp && this.endcp != -1) {
                    throw this.createException(index, errCode, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
                }
                throw this.createException(index, errCode, message);
            }
        }

        class MyAnBExpression
        extends AnBExpression {
            private static final long serialVersionUID = 1L;

            MyAnBExpression() {
            }

            @Override
            protected SelectorList parseSelector(String selText) {
                CSSParser parser = CSSParser.this.clone();
                return parser.parseSelectors(selText, SelectorTokenHandler.this.factory);
            }
        }
    }

    private class SelectorArgumentTokenHandler
    extends SelectorTokenHandler {
        SelectorArgumentTokenHandler(NSACSelectorFactory factory) {
            super(factory);
        }

        @Override
        protected void newCombinatorSelector(int index, Selector.SelectorType type, int triggerCp) {
            if (this.currentsel == null) {
                this.currentsel = this.factory.createScopeSelector();
            } else if (!this.isValidCurrentSelector()) {
                this.unexpectedCharError(index, triggerCp);
                return;
            }
            this.newCombinatorSelector(type);
        }
    }

    class PropertyTokenHandler
    extends DeclarationTokenHandler {
        PropertyTokenHandler() {
            super(null);
            this.propertyName = "";
        }

        PropertyTokenHandler(int currentLine, int prevLineLength) {
            super(currentLine, prevLineLength);
            this.propertyName = "";
        }

        PropertyTokenHandler(String propertyName) {
            super(ShorthandDatabase.getInstance());
            this.propertyName = propertyName;
        }

        @Override
        protected void handleAtKeyword(int index) {
            throw this.createException(index, (byte)4, "Unexpected '@'");
        }

        @Override
        protected void endOfPropertyDeclaration(int index) {
            this.handleError(index, (byte)4, "Unexpected ';'");
        }

        @Override
        protected boolean isDeclarationContext() {
            return true;
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else {
                this.processBuffer(len);
                if (this.getLexicalUnit() == null) {
                    this.handleError(len, (byte)32, "No value found");
                }
            }
        }

        @Override
        protected void endDeclarationList() {
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (this.prevcp == this.endcp && this.endcp != -1) {
                throw this.createException(index, errCode, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
            }
            throw this.createException(index, errCode, message);
        }
    }

    abstract class CSSTokenHandler
    implements TokenHandler2,
    ParserControl {
        private int line;
        private int prevlinelength;
        private boolean foundCp13andNotYet10or12 = false;
        private int column;
        int prevcp = 32;
        int endcp = -1;
        short parendepth = 0;
        StringBuilder buffer;
        int escapedTokenIndex = -1;
        boolean parseError = false;

        CSSTokenHandler() {
            this.line = 1;
            this.prevlinelength = -1;
        }

        CSSTokenHandler(int currentLine, int prevLineLength) {
            this.line = currentLine;
            this.prevlinelength = prevLineLength;
        }

        boolean isTopLevel() {
            return false;
        }

        @Override
        public CSSErrorHandler getErrorHandler() {
            return CSSParser.this.errorHandler;
        }

        @Override
        public void setDocumentHandler(CSSHandler handler) {
            CSSParser.this.setDocumentHandler(handler);
        }

        @Override
        public void setErrorHandler(CSSErrorHandler handler) {
            CSSParser.this.setErrorHandler(handler);
        }

        @Override
        public Locator createLocator() {
            return new LocatorImpl(this.line, this.column);
        }

        int getCurrentLine() {
            return this.line;
        }

        int getPrevLineLength() {
            return this.prevlinelength;
        }

        void setCurrentLocation(int index) {
            this.column = index - this.prevlinelength;
        }

        public void tokenStart(TokenControl control) {
        }

        public void control(int index, int codepoint) {
            if (codepoint == 10) {
                this.separator(index, 10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                    this.prevlinelength = index;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                    ++this.prevlinelength;
                }
                this.setHandlerPreviousCp(10);
            } else if (codepoint == 12) {
                this.separator(index, 10);
                this.setHandlerPreviousCp(10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                }
                this.prevlinelength = index;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
                this.foundCp13andNotYet10or12 = true;
            } else if (codepoint == 9) {
                this.separator(index, 9);
            } else if (codepoint < 128) {
                this.unexpectedCharError(index, codepoint);
            } else {
                this.highControl(index, codepoint);
            }
        }

        protected void setHandlerPreviousCp(int cp) {
            this.prevcp = cp;
        }

        protected void highControl(int index, int codepoint) {
            if (!this.parseError) {
                this.handleError(index, (byte)4, "Unexpected control: " + codepoint);
            }
        }

        void decrParenDepth(int index) {
            this.parendepth = (short)(this.parendepth - 1);
            if (this.parendepth < 0 && !this.parseError) {
                this.handleError(index, (byte)4, "Unexpected character: ')'");
            }
        }

        boolean isPrevCpWhitespace() {
            return this.prevcp == 32 || this.prevcp == 10;
        }

        void setWhitespacePrevCp() {
            if (this.prevcp != 10) {
                this.prevcp = 32;
            }
        }

        public void quotedNewlineChar(int index, int codepoint) {
            if (codepoint == 10) {
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = index;
                }
            } else if (codepoint == 12) {
                ++this.line;
                this.prevlinelength = index;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
                this.prevcp = codepoint;
            }
        }

        public void commented(int index, int commentType, String comment) {
            if (commentType == 0) {
                CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
            }
            this.prevcp = 12;
        }

        protected boolean isPreviousCpLF() {
            return this.prevcp == 10;
        }

        void setEscapedTokenStart(int index) {
            if (this.escapedTokenIndex == -1) {
                this.escapedTokenIndex = index - 1;
            }
        }

        void bufferAppend(int codepoint) {
            this.buffer.appendCodePoint(codepoint);
        }

        String rawBuffer() {
            this.escapedTokenIndex = -1;
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }

        String unescapeBuffer(int index) {
            String s = this.unescapeStringValue(index);
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
            return s;
        }

        String unescapeStringValue(int index) {
            String s;
            if (this.escapedTokenIndex != -1) {
                int escsz = index - this.escapedTokenIndex;
                int rawlen = this.buffer.length() - escsz;
                if (rawlen <= 0) {
                    s = this.safeUnescapeIdentifier(index, this.buffer.toString());
                } else {
                    CharSequence rawseq = this.buffer.subSequence(0, rawlen);
                    s = rawseq + this.safeUnescapeIdentifier(index, this.buffer.substring(rawlen));
                }
            } else {
                s = this.buffer.toString();
            }
            return s;
        }

        String safeUnescapeIdentifier(int index, String inputString) {
            return ParseHelper.unescapeStringValue(inputString, true, true);
        }

        String unescapeIdentifier(int index, String inputString) throws DOMNullCharacterException {
            return ParseHelper.unescapeStringValue(inputString, true, false);
        }

        boolean isNotForbiddenIdentStart(String s) {
            char c = s.charAt(0);
            if (c != '-') {
                return !CSSParser.isDigit(c) && c != '+';
            }
            return s.length() > 1 && !CSSParser.isDigit(c = s.charAt(1)) || c == '\\';
        }

        boolean isValidPseudoName(String s) {
            int idx;
            int len = s.length();
            char c = s.charAt(0);
            if (c != '-') {
                if (!CSSParser.isNameStartChar(c)) {
                    return false;
                }
                idx = 1;
            } else if (len > 1) {
                c = s.charAt(1);
                if (!CSSParser.isNameStartChar(c)) {
                    return false;
                }
                idx = 2;
            } else {
                return false;
            }
            while (idx < len) {
                c = s.charAt(idx);
                if (!CSSParser.isNameChar(c)) {
                    return false;
                }
                ++idx;
            }
            return true;
        }

        void resetHandler() {
            this.prevcp = 32;
            this.parendepth = 0;
            this.parseError = false;
        }

        public void error(int index, byte errCode, CharSequence context) {
            this.handleError(index, errCode, "Syntax error near " + context);
        }

        protected void handleError(int index, byte errCode, String message) throws CSSParseException {
            if (!this.parseError) {
                CSSParseException ex = this.prevcp == this.endcp ? this.createException(index, errCode, "Unexpected end of file") : this.createException(index, errCode, message);
                this.handleError(ex);
            }
        }

        protected void handleError(int index, byte errCode, String message, Throwable cause) throws CSSParseException {
            if (!this.parseError) {
                CSSParseException ex = this.createException(index, errCode, message);
                ex.initCause(cause);
                this.handleError(ex);
            }
        }

        protected void handleError(CSSParseException ex) throws CSSParseException {
            if (CSSParser.this.errorHandler == null) {
                throw ex;
            }
            CSSParser.this.errorHandler.error(ex);
            this.parseError = true;
        }

        void unexpectedCharError(int index, int codepoint) {
            this.handleError(index, (byte)4, "Unexpected '" + new String(Character.toChars(codepoint)) + "'");
        }

        void unexpectedTokenError(int index, CharSequence token) {
            this.handleError(index, (byte)9, "Unexpected: " + token);
        }

        final void handleWarning(int index, byte errCode, String message) {
            this.handleWarning(index, errCode, message, null);
        }

        void handleWarning(int index, byte errCode, String message, Throwable cause) {
            if (!this.parseError && CSSParser.this.errorHandler != null) {
                CSSParseException ex = this.createException(index, errCode, message);
                if (cause != null) {
                    ex.initCause(cause);
                }
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(ex);
                }
            }
        }

        CSSParseException createException(int index, byte errCode, String message) {
            this.setCurrentLocation(index);
            Locator locator = this.createLocator();
            if (errCode == 15) {
                return new CSSNamespaceParseException(message, locator);
            }
            return new CSSParseException(message, locator);
        }

        void endDocument() {
            if (CSSParser.this.handler != null) {
                CSSParser.this.handler.endOfStream();
            }
        }

        class MySelectorListImpl
        extends SelectorListImpl {
            private static final long serialVersionUID = 1L;

            MySelectorListImpl() {
            }

            public boolean add(Selector sel, int index) {
                if (this.add(sel)) {
                    return true;
                }
                if (CSSParser.this.errorHandler != null) {
                    int selsz;
                    try {
                        selsz = sel.toString().length();
                    }
                    catch (RuntimeException e) {
                        selsz = 1;
                    }
                    String message = "Duplicate selector in list";
                    try {
                        message = message + ": " + sel.toString();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    CSSParser.this.errorHandler.warning(CSSTokenHandler.this.createException(index - selsz, (byte)-1, message));
                }
                return false;
            }
        }
    }

    abstract class ControlTokenHandler
    extends CSSTokenHandler {
        private TokenControl parserctl;

        ControlTokenHandler() {
            this.parserctl = null;
        }

        ControlTokenHandler(int currentLine, int prevLineLength) {
            super(currentLine, prevLineLength);
            this.parserctl = null;
        }

        @Override
        public void tokenStart(TokenControl control) {
            this.parserctl = control;
        }

        TokenControl getTokenControl() {
            return this.parserctl;
        }
    }

    private class CallbackIgnoredDeclarationTH
    extends IgnoredDeclarationTokenHandler {
        private final TokenControl parserctl;
        private final TokenHandler2 parent;

        CallbackIgnoredDeclarationTH(TokenControl parserctl) {
            this.parserctl = parserctl;
            this.parent = (TokenHandler2)parserctl.getTokenHandler();
        }

        @Override
        protected void endDeclarationBlock() {
            this.parserctl.setTokenHandler((TokenHandler3)this.parent);
        }

        @Override
        public void control(int index, int codepoint) {
            this.parent.control(index, codepoint);
        }

        public void endOfStream(int len) {
            this.parent.endOfStream(len);
        }
    }

    private abstract class IgnoredDeclarationTokenHandler
    extends CSSTokenHandler {
        private int curlyBracketDepth = 1;

        IgnoredDeclarationTokenHandler() {
        }

        public void word(int index, CharSequence word) {
        }

        public void separator(int index, int codePoint) {
        }

        public void quoted(int index, CharSequence quoted, int quoteCp) {
        }

        public void quotedWithControl(int index, CharSequence quoted, int quote) {
        }

        public void leftParenthesis(int index) {
        }

        public void leftSquareBracket(int index) {
        }

        public void rightParenthesis(int index) {
        }

        public void rightSquareBracket(int index) {
        }

        public void leftCurlyBracket(int index) {
            ++this.curlyBracketDepth;
        }

        public void rightCurlyBracket(int index) {
            --this.curlyBracketDepth;
            if (this.curlyBracketDepth == 0) {
                this.endDeclarationBlock();
            }
        }

        protected abstract void endDeclarationBlock();

        public void character(int index, int codePoint) {
        }

        public void escaped(int index, int codePoint) {
        }
    }

    static interface LexicalUnitFactory {
        public LexicalUnitImpl createUnit();
    }

    private class CDOTokenHandler
    extends CSSTokenHandler {
        private final TokenControl parserctl;
        private final CSSTokenHandler parent;

        CDOTokenHandler(TokenControl parserctl) {
            this.prevcp = 60;
            this.parserctl = parserctl;
            this.parent = (CSSTokenHandler)parserctl.getTokenHandler();
        }

        public void word(int index, CharSequence word) {
            if (!CSSParser.equalSequences("--", word) || this.prevcp != 33) {
                this.parent.unexpectedTokenError(index, word);
            }
            this.yieldHandling();
        }

        public void character(int index, int codePoint) {
            if (codePoint == 33 && this.prevcp == 60) {
                this.prevcp = codePoint;
                return;
            }
            this.parent.unexpectedCharError(index, codePoint);
            this.yieldHandling();
        }

        void yieldHandling() {
            this.parserctl.setTokenHandler((TokenHandler3)this.parent);
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            this.parent.unexpectedTokenError(index, comment);
            this.yieldHandling();
        }

        @Override
        public void control(int index, int codePoint) {
            this.parent.control(index, codePoint);
            this.parent.unexpectedCharError(index, codePoint);
            this.yieldHandling();
        }

        public void endOfStream(int len) {
            this.parent.handleError(len, (byte)10, "EOF while processing CDO/CDC.");
            this.parent.endOfStream(len);
        }

        public void separator(int index, int codePoint) {
            this.parent.unexpectedCharError(index, codePoint);
            this.yieldHandling();
        }

        public void quoted(int index, CharSequence quoted, int quote) {
            char quotec = (char)quote;
            StringBuilder buf = new StringBuilder(quoted.length() + 2);
            buf.append(quotec).append(quoted).append(quotec);
            this.parent.unexpectedTokenError(index, buf);
            this.yieldHandling();
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        public void leftParenthesis(int index) {
            this.parent.unexpectedCharError(index, 40);
            this.yieldHandling();
        }

        public void leftSquareBracket(int index) {
            this.parent.unexpectedCharError(index, 91);
            this.yieldHandling();
        }

        public void leftCurlyBracket(int index) {
            this.parent.unexpectedCharError(index, 123);
            this.yieldHandling();
        }

        public void rightParenthesis(int index) {
            this.parent.unexpectedCharError(index, 41);
            this.yieldHandling();
        }

        public void rightSquareBracket(int index) {
            this.parent.unexpectedCharError(index, 93);
            this.yieldHandling();
        }

        public void rightCurlyBracket(int index) {
            this.parent.unexpectedCharError(index, 125);
            this.yieldHandling();
        }

        public void escaped(int index, int codePoint) {
            this.parent.unexpectedCharError(index, codePoint);
            this.yieldHandling();
        }
    }

    abstract class NestedRuleTH
    extends ControlTokenHandler {
        private final String blockRuleName;
        private byte stage = 1;
        private int curlyBracketDepth = 0;
        private DeclarationTokenHandler declarationHandler;
        static final byte STAGE_WAIT_SELECTOR = 1;
        static final byte STAGE_WAIT_BLOCK_LIST = 2;
        private static final byte STAGE_WAIT_NESTED_SELECTOR = 3;
        private static final byte STAGE_FOUND_NESTED_SELECTOR = 4;
        static final byte STAGE_DECLARATION_LIST = 5;
        private static final byte STAGE_END_BLOCK_LIST = 6;
        static final byte STAGE_SELECTOR_ERROR = 9;
        static final byte STAGE_NESTED_SELECTOR_ERROR = 10;

        NestedRuleTH(int bufSize, String blockRuleName) {
            this.blockRuleName = blockRuleName;
            this.declarationHandler = new NestedRuleDeclarationTokenHandler();
            this.buffer = new StringBuilder(bufSize);
        }

        DeclarationTokenHandler getDeclarationHandler() {
            return this.declarationHandler;
        }

        void setDeclarationHandler(DeclarationTokenHandler declarationHandler) {
            this.declarationHandler = declarationHandler;
        }

        byte getStage() {
            return this.stage;
        }

        void setStage(byte stage) {
            this.stage = stage;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        public void word(int index, CharSequence word) {
            if (this.stage == 5) {
                this.declarationHandler.word(index, word);
            } else if (this.stage == 2 || this.stage == 6) {
                this.unexpectedTokenError(index, word);
            } else if (!this.parseError) {
                this.buffer.append(word);
                if (this.stage == 3) {
                    this.stage = (byte)4;
                }
                this.prevcp = 65;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void separator(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.separator(index, codePoint);
                return;
            } else {
                if (this.parseError) return;
                if (this.buffer.length() != 0) {
                    this.checkNameSelector();
                    if (this.prevcp == 32) return;
                    if (this.prevcp == 10) return;
                    this.buffer.append(' ');
                }
                this.prevcp = 32;
            }
        }

        void checkNameSelector() {
        }

        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (this.stage == 5) {
                this.declarationHandler.quoted(index, quoted, quoteCp);
            } else if (this.stage == 1) {
                this.waitSelectorQuoted(index, quoted, quoteCp);
            } else {
                this.handleError(index, (byte)9, "Expected " + this.blockRuleName + " selector, found '" + quoted + "'");
            }
        }

        void waitSelectorQuoted(int index, CharSequence quoted, int quoteCp) {
            this.buffer.append(quoted);
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        public void leftCurlyBracket(int index) {
            if (this.stage == 5) {
                this.declarationHandler.leftCurlyBracket(index);
            } else {
                ++this.curlyBracketDepth;
                if (this.stage == 1 || this.stage == 2) {
                    if (this.buffer.length() != 0) {
                        this.processSelector(index, this.unescapeBuffer(index).trim());
                        if (!this.parseError) {
                            this.prevcp = 123;
                            this.startBlockList(index);
                        }
                    } else {
                        this.emptySelector(index);
                    }
                } else if (this.stage == 4) {
                    if (this.processNestedSelector(index)) {
                        this.prevcp = 123;
                        this.stage = (byte)5;
                        this.declarationHandler.curlyBracketDepth = 1;
                    }
                } else if (!this.parseError) {
                    this.unexpectedCharError(index, 123, (byte)9);
                }
            }
        }

        public void leftParenthesis(int index) {
            if (this.stage == 5) {
                this.declarationHandler.leftParenthesis(index);
            } else {
                this.unexpectedCharError(index, 40, (byte)10);
            }
        }

        public void leftSquareBracket(int index) {
            if (this.stage == 5) {
                this.declarationHandler.leftSquareBracket(index);
            } else {
                this.unexpectedCharError(index, 91, (byte)10);
            }
        }

        protected void startBlockList(int index) {
            this.stage = (byte)3;
        }

        protected void emptySelector(int index) {
            this.handleError(index, (byte)4, this.blockRuleName + " must have a name.");
        }

        void processSelector(int index, String name) {
            if ("initial".equalsIgnoreCase(name) || "inherit".equalsIgnoreCase(name) || "unset".equalsIgnoreCase(name) || "none".equalsIgnoreCase(name) || "reset".equalsIgnoreCase(name)) {
                this.handleError(index, (byte)7, "A CSS keyword is not a valid custom ident.");
            }
        }

        abstract boolean processNestedSelector(int var1);

        abstract void endBlockList(int var1);

        public void rightCurlyBracket(int index) {
            if (this.stage == 5) {
                this.declarationHandler.rightCurlyBracket(index);
                if (this.curlyBracketDepth == 1) {
                    this.endBlock();
                } else if (this.curlyBracketDepth == 0) {
                    this.endBlockList(index);
                    this.stage = (byte)6;
                }
                this.prevcp = 125;
            } else {
                --this.curlyBracketDepth;
                this.handleRightCurlyBracket(index);
            }
        }

        protected void handleRightCurlyBracket(int index) {
            if (this.curlyBracketDepth == 0) {
                this.endBlockList(index);
                this.stage = (byte)6;
                this.prevcp = 125;
            } else if (this.curlyBracketDepth == 1 && this.stage == 10) {
                this.stage = (byte)3;
                this.parseError = false;
            }
        }

        public void rightParenthesis(int index) {
            if (this.stage == 5) {
                this.declarationHandler.rightParenthesis(index);
            } else if (this.stage == 1 || this.stage == 2) {
                this.unexpectedCharError(index, 41, (byte)9);
            } else {
                this.unexpectedCharError(index, 41, (byte)10);
            }
            this.prevcp = 41;
        }

        public void rightSquareBracket(int index) {
            if (this.stage == 5) {
                this.declarationHandler.rightSquareBracket(index);
            } else if (this.stage == 1 || this.stage == 2) {
                this.unexpectedCharError(index, 93, (byte)9);
            } else {
                this.unexpectedCharError(index, 93, (byte)10);
            }
            this.prevcp = 93;
        }

        protected void endBlock() {
            this.stage = (byte)3;
        }

        public void character(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.character(index, codePoint);
            } else if (!this.parseError) {
                char[] chars = Character.toChars(codePoint);
                if (this.stage == 3 || this.stage == 4) {
                    if (this.isValidNestedSelectorCharacter(codePoint)) {
                        this.buffer.append(chars);
                        this.prevcp = codePoint;
                    } else {
                        this.buffer.setLength(0);
                        this.unexpectedCharError(index, codePoint, (byte)10);
                    }
                    return;
                }
                if (this.stage == 1 && this.isValidSelectorCharacter(codePoint)) {
                    this.buffer.append(chars);
                    this.prevcp = codePoint;
                    return;
                }
                this.unexpectedCharError(index, codePoint, (byte)9);
            }
        }

        abstract boolean isValidNestedSelectorCharacter(int var1);

        abstract boolean isValidSelectorCharacter(int var1);

        public void escaped(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.escaped(index, codePoint);
            } else if (!this.parseError) {
                char[] chars = Character.toChars(codePoint);
                if (this.stage == 2 || this.stage == 6) {
                    this.unexpectedTokenError(index, new String(chars));
                } else {
                    if (ParseHelper.isHexCodePoint(codePoint)) {
                        this.setEscapedTokenStart(index);
                        this.buffer.append('\\');
                    }
                    this.buffer.append(chars);
                    if (this.stage == 3) {
                        this.stage = (byte)4;
                    }
                    this.prevcp = 65;
                }
            }
        }

        public void endOfStream(int len) {
            if (this.curlyBracketDepth != 0) {
                if (this.stage == 5) {
                    --this.curlyBracketDepth;
                    this.declarationHandler.endOfStream(len);
                    this.endBlock();
                } else if (this.stage == 6) {
                    return;
                }
                this.handleWarning(len, (byte)10, "Unexpected end of " + this.blockRuleName + " rule.");
                this.endBlockList(len);
            } else if (this.stage != 6) {
                this.handleError(len, (byte)10, "Malformed " + this.blockRuleName + " rule.", (byte)9);
                this.endBlockList(len);
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (!this.parseError && this.buffer.length() == 0 && this.curlyBracketDepth == 1 && this.parendepth == 0 && this.stage == 3) {
                super.commented(index, commentType, comment);
            } else {
                this.separator(index, 12);
                this.prevcp = 12;
            }
        }

        void unexpectedCharError(int index, int codepoint, byte stageToSet) {
            this.handleError(index, (byte)4, "Unexpected '" + new String(Character.toChars(codepoint)) + "'", stageToSet);
        }

        protected void handleError(int index, byte errCode, String message, byte stageToSet) throws CSSParseException {
            if (!this.parseError && this.stage != 9) {
                super.handleError(index, errCode, message);
                this.stage = stageToSet;
            }
        }

        @Override
        protected void handleError(CSSParseException ex) throws CSSParseException {
            super.handleError(ex);
            if (this.stage <= 2) {
                this.abortRule();
            }
        }

        protected void abortRule() {
        }

        private class NestedRuleDeclarationTokenHandler
        extends DeclarationTokenHandler {
            private NestedRuleDeclarationTokenHandler() {
                super(null);
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                this.resetHandler();
                NestedRuleTH.this.curlyBracketDepth--;
                NestedRuleTH.this.stage = (byte)3;
                NestedRuleTH.this.prevcp = 125;
            }

            @Override
            TokenControl getTokenControl() {
                return NestedRuleTH.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                NestedRuleTH.this.setCurrentLocation(index);
            }

            @Override
            protected void handleProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
                if (!priorityImportant) {
                    super.handleProperty(index, propertyName, lunit, priorityImportant);
                } else {
                    this.handleError(index, (byte)5, "Values with important priority are not accepted (" + propertyName + ':' + lunit.toString() + "!important).");
                }
            }

            @Override
            public void control(int index, int codepoint) {
                NestedRuleTH.this.control(index, codepoint);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return NestedRuleTH.this.createException(index, errCode, message);
            }
        }

        class RootDeclarationTokenHandler
        extends DeclarationTokenHandler {
            private final DeclarationTokenHandler nestedDeclarationHandler;

            RootDeclarationTokenHandler(DeclarationTokenHandler nestedDeclarationHandler) {
                super(ShorthandDatabase.getInstance());
                this.nestedDeclarationHandler = nestedDeclarationHandler;
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                NestedRuleTH.this.curlyBracketDepth--;
                NestedRuleTH.this.setStage((byte)6);
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.propertyName == null && this.buffer.length() == 0 && this.getCurlyBracketDepth() == 1) {
                    NestedRuleTH.this.declarationHandler = this.nestedDeclarationHandler;
                    NestedRuleTH.this.setStage((byte)3);
                    NestedRuleTH.this.prevcp = 64;
                } else {
                    this.unexpectedCharError(index, 64);
                }
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                NestedRuleTH.this.setStage((byte)6);
                NestedRuleTH.this.endOfStream(len);
            }

            @Override
            protected void endDeclarationList() {
            }

            @Override
            TokenControl getTokenControl() {
                return NestedRuleTH.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int index) {
                NestedRuleTH.this.setCurrentLocation(index);
            }

            @Override
            public void control(int index, int codepoint) {
                NestedRuleTH.this.control(index, codepoint);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return NestedRuleTH.this.createException(index, errCode, message);
            }
        }
    }

    private static class ConditionWrapper {
        private final Object condition;
        private final ConditionWrapper parent;
        private final boolean mediaCondition;

        ConditionWrapper(MediaQueryList mediaList, ConditionWrapper parent) {
            this.condition = mediaList;
            this.parent = parent;
            this.mediaCondition = true;
        }

        ConditionWrapper(BooleanCondition cond, ConditionWrapper parent) {
            this.condition = cond;
            this.parent = parent;
            this.mediaCondition = false;
        }

        MediaQueryList getMediaList() {
            return (MediaQueryList)this.condition;
        }

        BooleanCondition getCondition() {
            return (BooleanCondition)this.condition;
        }

        ConditionWrapper getParent() {
            return this.parent;
        }

        boolean isMediaCondition() {
            return this.mediaCondition;
        }

        public String toString() {
            return this.condition != null ? this.condition.toString() : "";
        }
    }

    private static class ConditionTokenHandler<F extends BooleanConditionFactory>
    extends CSSTokenHandler {
        final F conditionFactory;
        BooleanCondition currentCond = null;
        private int opDepthIndex = 0;
        private final short[] opParenDepth = new short[32];
        private boolean topLevel = true;
        private DelegateHandler predicateHandler;
        boolean readingPredicate = false;
        final /* synthetic */ CSSParser this$0;

        ConditionTokenHandler(F conditionFactory) {
            this.this$0 = var1_1;
            this.conditionFactory = conditionFactory;
            this.buffer = new StringBuilder(64);
        }

        DelegateHandler getPredicateHandler() {
            return this.predicateHandler;
        }

        void setPredicateHandler(DelegateHandler predicateHandler) {
            this.predicateHandler = predicateHandler;
        }

        public void word(int index, CharSequence word) {
            if (!this.parseError) {
                if (!this.readingPredicate) {
                    if (this.buffer.length() == 0) {
                        this.processWord(index, word.toString());
                    } else {
                        this.unexpectedTokenError(index, word);
                    }
                } else if (this.getCurrentParenDepth() > 1 || this.predicateHandler.isAllowedTopLevel()) {
                    this.predicateHandler.word(index, word);
                } else {
                    this.processWord(index, word.toString());
                }
                this.prevcp = 65;
            }
        }

        private void processWord(int index, String word) {
            String lctoken = word.toLowerCase(Locale.ROOT);
            if ("not".equals(lctoken)) {
                this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.NOT);
                BooleanCondition newCond = this.conditionFactory.createNotCondition();
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.setNestedCondition(newCond);
            } else if ("and".equals(lctoken)) {
                this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.AND);
                if (this.currentCond != null) {
                    this.processOperation(index, BooleanCondition.Type.AND, word);
                } else {
                    this.processImplicitAnd(index);
                }
            } else if ("or".equals(lctoken)) {
                if (this.currentCond != null) {
                    this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.OR);
                    this.processOperation(index, BooleanCondition.Type.OR, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else {
                this.readingPredicate = true;
                this.predicateHandler.word(index, word);
            }
        }

        void processOperation(int index, BooleanCondition.Type opType, String opname) {
            BooleanCondition operation = this.currentCond.getParentCondition();
            BooleanCondition.Type curType = this.currentCond.getType();
            if (curType == BooleanCondition.Type.PREDICATE || curType == BooleanCondition.Type.SELECTOR_FUNCTION) {
                if (operation == null) {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                } else if (operation.getType() == opType) {
                    this.currentCond = operation;
                } else {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    if (this.getCurrentParenDepth() != 0) {
                        BooleanCondition oldCond = operation.replaceLast(newCond);
                        newCond.addCondition(oldCond);
                    } else {
                        newCond.addCondition(operation);
                    }
                    this.setNestedCondition(newCond);
                }
            } else if (curType == BooleanCondition.Type.NOT) {
                if (operation != null) {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    BooleanCondition oldCond = operation.replaceLast(newCond);
                    newCond.addCondition(oldCond);
                    this.setNestedCondition(newCond);
                } else if (opType == BooleanCondition.Type.AND || opType == BooleanCondition.Type.OR) {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                } else {
                    this.unexpectedTokenError(index, opname);
                }
            } else if (curType != opType) {
                if (this.getCurrentParenDepth() != 0 || !this.topLevel) {
                    this.unexpectedTokenError(index, opname);
                } else {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                }
            }
        }

        BooleanCondition createOperation(int index, BooleanCondition.Type opType) throws CSSParseException {
            if (opType == BooleanCondition.Type.AND) {
                return this.conditionFactory.createAndCondition();
            }
            return this.conditionFactory.createOrCondition();
        }

        private void setNestedCondition(BooleanCondition newCond) {
            this.currentCond = newCond;
            ++this.opDepthIndex;
        }

        void processImplicitAnd(int index) {
            this.unexpectedTokenError(index, "and");
        }

        public void leftParenthesis(int index) {
            int n = this.opDepthIndex;
            this.opParenDepth[n] = (short)(this.opParenDepth[n] + 1);
            this.predicateHandler.leftParenthesis(index);
            this.readingPredicate = true;
            this.prevcp = 40;
        }

        public void leftSquareBracket(int index) {
            this.predicateHandler.leftSquareBracket(index);
            this.readingPredicate = true;
            this.prevcp = 91;
        }

        public void leftCurlyBracket(int index) {
            this.predicateHandler.leftCurlyBracket(index);
            this.readingPredicate = true;
            this.prevcp = 123;
        }

        void handleLeftCurlyBracket(int index) {
            this.unexpectedCharError(index, 123);
        }

        public void rightParenthesis(int index) {
            int n = this.opDepthIndex;
            this.opParenDepth[n] = (short)(this.opParenDepth[n] - 1);
            if (this.opParenDepth[this.opDepthIndex] < 0) {
                this.unexpectedCharError(index, 41);
            } else if (this.readingPredicate) {
                this.predicateHandler.rightParenthesis(index);
            } else if (this.buffer.length() != 0) {
                this.unexpectedCharError(index, 41);
            }
            this.topLevel = true;
            if (this.opParenDepth[this.opDepthIndex] == 0 && this.currentCond != null && this.opDepthIndex != 0) {
                --this.opDepthIndex;
                if (this.currentCond.getParentCondition() != null) {
                    this.currentCond = this.currentCond.getParentCondition();
                    this.topLevel = false;
                }
            }
            this.prevcp = 41;
        }

        public void rightSquareBracket(int index) {
            if (this.readingPredicate) {
                this.predicateHandler.rightSquareBracket(index);
                this.prevcp = 93;
            } else {
                this.unexpectedCharError(index, 93);
            }
        }

        public void rightCurlyBracket(int index) {
            if (this.readingPredicate) {
                this.predicateHandler.rightCurlyBracket(index);
                this.prevcp = 125;
            } else {
                this.unexpectedCharError(index, 125);
            }
        }

        short getCurrentParenDepth() {
            return this.opParenDepth[this.opDepthIndex];
        }

        public void character(int index, int codepoint) {
            if (!this.parseError) {
                if (!this.readingPredicate) {
                    if (codepoint == 44) {
                        this.predicateHandler.character(index, codepoint);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else {
                    this.predicateHandler.character(index, codepoint);
                }
            } else if (codepoint == 44) {
                this.predicateHandler.character(index, codepoint);
            }
        }

        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.quoted(index, quoted, quoteCp);
                    this.prevcp = 65;
                } else {
                    this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
                }
            }
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        public void escaped(int index, int codepoint) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.escaped(index, codepoint);
                } else if (this.prevcp == 40) {
                    this.readingPredicate = true;
                    this.predicateHandler.escaped(index, codepoint);
                } else {
                    this.handleError(index, (byte)9, "Unexpected escaped character: \\u" + Integer.toHexString(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        public void separator(int index, int codepoint) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.separator(index, codepoint);
                }
                this.setWhitespacePrevCp();
            }
        }

        @Override
        public void control(int index, int codepoint) {
            super.control(index, codepoint);
            if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer)) {
                this.escapedTokenIndex = -1;
                this.buffer.append(' ');
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            this.separator(index, 32);
            this.prevcp = 32;
        }

        public void endOfStream(int len) {
            this.endOfCondition(len);
        }

        void endOfCondition(int index) {
            if (this.opParenDepth[this.opDepthIndex] != 0) {
                this.handleError(index, (byte)6, "Unmatched parenthesis");
            } else if (!this.parseError) {
                this.predicateHandler.endOfStream(index);
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message) throws CSSParseException {
            throw this.createException(index, errCode, message);
        }

        @Override
        void resetHandler() {
            this.prevcp = 32;
            this.parseError = false;
            this.currentCond = null;
            this.buffer.setLength(0);
        }
    }

    private static abstract class DelegateHandler
    implements TokenHandler2 {
        private DelegateHandler() {
        }

        public void preBooleanHandling(int index, BooleanCondition.Type type) {
        }

        public void tokenStart(TokenControl control) {
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        }

        public void quotedNewlineChar(int index, int codePoint) {
        }

        public void control(int index, int codePoint) {
        }

        public void commented(int index, int commentType, String comment) {
        }

        public void error(int index, byte errCode, CharSequence context) {
        }

        boolean isAllowedTopLevel() {
            return false;
        }
    }
}

