/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class ViewportRule
extends BaseCSSDeclarationRule {
    private static final long serialVersionUID = 1L;

    public ViewportRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)15, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return "@viewport{" + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri, this.getPrecedingComments());
        wri.write((CharSequence)"@viewport");
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri, this.getTrailingComments());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        if (len < 15 || idx == -1) {
            throw new DOMException(12, "Invalid @viewport rule: " + cssText);
        }
        String empty = cssText.substring(9, idx).trim();
        if (empty.length() != 0) {
            throw new DOMException(12, "Invalid @viewport rule: " + cssText);
        }
        super.setCssText(cssText);
    }

    @Override
    void startAtRule(String name, String pseudoSelector) {
        if (!"viewport".equalsIgnoreCase(name)) {
            throw new DOMException(13, "Cannot set rule of type: " + name);
        }
    }

    @Override
    public ViewportRule clone(AbstractCSSStyleSheet parentSheet) {
        ViewportRule rule = new ViewportRule(parentSheet, this.getOrigin());
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }
}

