/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.Viewport;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class SimpleBoxModel {
    SimpleBoxModel() {
    }

    protected abstract ComputedCSSStyle getComputedStyle();

    protected abstract CSSComputedProperties getRevertStyle(Condition var1);

    private StyleDatabase getStyleDatabase() {
        return this.getComputedStyle().getStyleDatabase();
    }

    private void computeSharedBoxValues(MyBoxValues box) {
        box.marginTop = this.computeMarginTop(box.unitType);
        box.marginBottom = this.computeMarginBottom(box.unitType);
        ComputedCSSStyle styledecl = this.getComputedStyle();
        box.paddingTop = this.computePaddingSubproperty(styledecl, PADDING.TOP, box.unitType);
        box.paddingRight = this.computePaddingSubproperty(styledecl, PADDING.RIGHT, box.unitType);
        box.paddingBottom = this.computePaddingSubproperty(styledecl, PADDING.BOTTOM, box.unitType);
        box.paddingLeft = this.computePaddingSubproperty(styledecl, PADDING.LEFT, box.unitType);
        box.borderTopWidth = this.findBorderWidthProperty(styledecl, "border-top-width", box.unitType, "border-top-style");
        box.borderBottomWidth = this.findBorderWidthProperty(styledecl, "border-bottom-width", box.unitType, "border-bottom-style");
        box.borderLeftWidth = this.findBorderWidthProperty(styledecl, "border-left-width", box.unitType, "border-left-style");
        box.borderRightWidth = this.findBorderWidthProperty(styledecl, "border-right-width", box.unitType, "border-right-style");
    }

    private float computeMarginTop(short unitType) {
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCascadedValue("margin-top");
        if (cssval.getPrimitiveType() == CSSValue.Type.INHERIT && (styledecl = styledecl.getParentComputedStyle()) != null) {
            return styledecl.getBoxValues(unitType).getMarginTop();
        }
        if (styledecl != null && cssval.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSTypedValue typed = (CSSTypedValue)((Object)cssval);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength(typed)) {
                return this.computeMarginNumberValue(styledecl, "margin-top", typed, unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-top, found " + cssval.getCssText());
            if (styledecl == null) {
                styledecl = this.getComputedStyle();
            }
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-top", e);
        }
        return 0.0f;
    }

    private float computeMarginBottom(short unitType) {
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCascadedValue("margin-bottom");
        if (cssval.getPrimitiveType() == CSSValue.Type.INHERIT && (styledecl = styledecl.getParentComputedStyle()) != null) {
            return styledecl.getBoxValues(unitType).getMarginBottom();
        }
        if (styledecl != null && cssval.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSTypedValue typed = (CSSTypedValue)((Object)cssval);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength(typed)) {
                return this.computeMarginNumberValue(styledecl, "margin-bottom", typed, unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-bottom, found " + cssval.getCssText());
            if (styledecl == null) {
                styledecl = this.getComputedStyle();
            }
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-bottom", e);
        }
        return 0.0f;
    }

    private static boolean isTypedAutoOrInvalidLength(CSSTypedValue value) {
        return value.getPrimitiveType() == CSSValue.Type.IDENT && "auto".equalsIgnoreCase(value.getStringValue()) || value.isNegativeNumber() && !value.isCalculatedNumber();
    }

    void computeInlineBox(MyBoxValues box) throws StyleDatabaseRequiredException {
        CSSElement elm;
        CSSPropertyValueException e;
        CSSTypedValue typed;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCascadedValue("margin-right");
        while (cssval.getPrimitiveType() == CSSValue.Type.INHERIT && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCascadedValue("margin-right");
        }
        if (styledecl == null) {
            box.marginRight = 0.0f;
        } else if (cssval.getCssValueType() == CSSValue.CssType.TYPED) {
            typed = (CSSTypedValue)((Object)cssval);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength(typed)) {
                box.marginRight = this.computeMarginNumberValue(styledecl, "margin-right", typed, box.unitType);
            }
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-right, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-right", e);
            box.marginRight = 0.0f;
        }
        styledecl = this.getComputedStyle();
        cssval = styledecl.getCascadedValue("margin-left");
        while (cssval.getPrimitiveType() == CSSValue.Type.INHERIT && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCascadedValue("margin-left");
        }
        if (styledecl == null) {
            box.marginLeft = 0.0f;
        } else if (cssval.getCssValueType() == CSSValue.CssType.TYPED) {
            typed = (CSSTypedValue)((Object)cssval);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength(typed)) {
                box.marginLeft = this.computeMarginNumberValue(styledecl, "margin-left", typed, box.unitType);
            }
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-left, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-left", e);
            box.marginLeft = 0.0f;
        }
        CSSElement node = this.getComputedStyle().getOwnerNode();
        if (node != null && node.getNodeType() == 1 && "img".equals((elm = node).getTagName()) && elm.hasAttribute("width")) {
            String strWidth = elm.getAttribute("width");
            try {
                box.width = Float.parseFloat(strWidth);
            }
            catch (NumberFormatException e2) {
                String message = "Could not parse value of 'width' attribute for img element";
                CSSPropertyValueException ex = new CSSPropertyValueException(message, e2);
                ex.setValueText(strWidth);
                elm.getOwnerDocument().getErrorHandler().computedStyleError(elm, "width", ex);
            }
            if (box.unitType != 3) {
                box.width = NumberValue.floatValueConversion(box.width, (short)3, box.unitType);
            }
        }
    }

    public BoxValues getComputedBox(short unitType) throws DOMException, StyleDatabaseRequiredException {
        String display = this.getComputedStyle().getDisplay();
        if ("block".equalsIgnoreCase(display) || "list-item".equalsIgnoreCase(display)) {
            MyBoxValues box = new MyBoxValues(unitType);
            this.computeSharedBoxValues(box);
            this.computeBlockBox(box);
            return box;
        }
        if ("table".equalsIgnoreCase(display)) {
            MyTableBoxValues box = new MyTableBoxValues(unitType);
            this.computeSharedBoxValues(box);
            String tableLayout = this.getComputedStyle().getPropertyValue("table-layout");
            if ("auto".equalsIgnoreCase(tableLayout)) {
                this.computeTableBox(box);
                return box;
            }
            this.computeBlockBox(box);
            return box;
        }
        if ("table-cell".equalsIgnoreCase(display) || "table-row".equalsIgnoreCase(display)) {
            MyTableItemBoxValues box = new MyTableItemBoxValues(unitType);
            this.computeTableCellBox(box);
            return box;
        }
        MyBoxValues box = new MyBoxValues(unitType);
        this.computeSharedBoxValues(box);
        this.computeInlineBox(box);
        return box;
    }

    void computeBlockBox(MyBoxValues box) throws StyleDatabaseRequiredException {
        CSSTypedValue typed;
        boolean margin_right_auto = false;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCascadedValue("margin-right");
        while (cssval.getPrimitiveType() == CSSValue.Type.INHERIT && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCascadedValue("margin-right");
        }
        if (cssval.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSTypedValue typed2 = (CSSTypedValue)((Object)cssval);
            margin_right_auto = SimpleBoxModel.isTypedAutoOrInvalidLength(typed2);
            if (!margin_right_auto) {
                box.marginRight = this.computeMarginNumberValue(styledecl, "margin-right", typed2, box.unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-right, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-right", e);
            box.marginRight = 0.0f;
        }
        styledecl = this.getComputedStyle();
        boolean margin_left_auto = false;
        cssval = styledecl.getCascadedValue("margin-left");
        while (cssval.getPrimitiveType() == CSSValue.Type.INHERIT && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCascadedValue("margin-left");
        }
        if (cssval.getCssValueType() == CSSValue.CssType.TYPED) {
            typed = (CSSTypedValue)((Object)cssval);
            margin_left_auto = SimpleBoxModel.isTypedAutoOrInvalidLength(typed);
            if (!margin_left_auto) {
                box.marginLeft = this.computeMarginNumberValue(styledecl, "margin-left", typed, box.unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-left, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-left", e);
            box.marginLeft = 0.0f;
        }
        styledecl = this.getComputedStyle();
        cssval = styledecl.getCascadedValue("width");
        if (cssval == null || cssval.getCssValueType() != CSSValue.CssType.TYPED || SimpleBoxModel.isTypedAutoOrInvalidLength(typed = (CSSTypedValue)((Object)cssval))) {
            ComputedCSSStyle contblockStyledecl;
            if (margin_right_auto) {
                box.marginRight = 0.0f;
            }
            if (margin_left_auto) {
                box.marginLeft = 0.0f;
            }
            float contBlockWidth = (contblockStyledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) == null ? this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto", box.unitType) : this.computeWidth(contblockStyledecl, box.unitType);
            box.width = contBlockWidth - (box.marginLeft + box.marginRight + box.borderLeftWidth + box.borderRightWidth + box.paddingLeft + box.paddingRight);
        } else {
            box.width = this.computeNonAutoWidth(styledecl, typed, box.unitType);
            ComputedCSSStyle contblockStyledecl = SimpleBoxModel.findContainingBlockStyle(styledecl);
            float contBlockWidth = contblockStyledecl == null ? (this.isRootBox() ? box.width : this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto", box.unitType)) : this.computeWidth(contblockStyledecl, box.unitType);
            float remMargin = contBlockWidth - box.width;
            remMargin -= box.borderLeftWidth + box.borderRightWidth + box.paddingLeft + box.paddingRight;
            if (margin_right_auto) {
                if (remMargin < 0.0f) {
                    box.marginRight = 0.0f;
                    box.marginLeft = 0.0f;
                } else if (margin_left_auto) {
                    box.marginLeft = box.marginRight = remMargin / 2.0f;
                } else if (remMargin < box.marginLeft) {
                    box.marginLeft = remMargin;
                    box.marginRight = 0.0f;
                } else {
                    box.marginRight = remMargin - box.marginLeft;
                }
            } else if (margin_left_auto) {
                if (remMargin < 0.0f) {
                    box.marginRight = 0.0f;
                    box.marginLeft = 0.0f;
                } else if (remMargin < box.marginRight) {
                    box.marginRight = remMargin;
                    box.marginLeft = 0.0f;
                } else {
                    box.marginLeft = remMargin;
                }
            } else if ((remMargin -= box.marginLeft + box.marginRight) < 0.0f) {
                if ("ltr".equalsIgnoreCase(styledecl.getPropertyValue("direction"))) {
                    box.marginRight = (remMargin += box.marginRight) > 0.0f ? remMargin : 0.0f;
                } else {
                    box.marginLeft = (remMargin += box.marginLeft) > 0.0f ? remMargin : 0.0f;
                }
            }
        }
    }

    private void computeTableBox(MyTableBoxValues box) {
        block25: {
            float mincw;
            float[] minrcw;
            int ncol;
            float capmin;
            block23: {
                boolean unset;
                float maxcw;
                float[] maxrcw;
                block26: {
                    block24: {
                        this.computeBlockBox(box);
                        capmin = this.computeCapmin(box.unitType);
                        ComputedCSSStyle style = this.getComputedStyle();
                        CSSElement tbl = style.getOwnerNode();
                        NodeList nlist = tbl.getElementsByTagName("tbody");
                        nlist = nlist.getLength() > 0 ? nlist.item(0).getChildNodes() : tbl.getChildNodes();
                        ncol = 0;
                        int nrows = nlist.getLength();
                        for (int i = 0; i < nrows; ++i) {
                            int rowcols;
                            CSSElement elm;
                            Node node = nlist.item(i);
                            if (node.getNodeType() != 1 || !"tr".equalsIgnoreCase((elm = (CSSElement)node).getTagName()) || (rowcols = elm.getChildNodes().getLength()) <= ncol) continue;
                            ncol = rowcols;
                        }
                        minrcw = new float[ncol];
                        maxrcw = new float[ncol];
                        float maxRowSpacing = 0.0f;
                        for (int i = 0; i < nrows; ++i) {
                            CSSElement elm;
                            Node node = nlist.item(i);
                            if (node.getNodeType() != 1 || !"tr".equalsIgnoreCase((elm = (CSSElement)node).getTagName())) continue;
                            style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(elm, null);
                            BoxValues colbox = style.getBoxValues(box.unitType);
                            float rowSpacing = colbox.getBorderLeftWidth() + colbox.getBorderRightWidth() + colbox.getMarginLeft() + colbox.getMarginRight() + colbox.getPaddingLeft() + colbox.getPaddingRight();
                            if (maxRowSpacing < rowSpacing) {
                                maxRowSpacing = rowSpacing;
                            }
                            NodeList columns = elm.getChildNodes();
                            int nrowcols = columns.getLength();
                            int k = 0;
                            for (int j = 0; j < nrowcols; ++j) {
                                float[] contw;
                                Node colnode = columns.item(j);
                                if (colnode.getNodeType() != 1) continue;
                                CSSElement col = (CSSElement)colnode;
                                style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(col, null);
                                if (!"table-cell".equalsIgnoreCase(style.getPropertyValue("display"))) continue;
                                int colspan = 1;
                                String colspanStr = col.getAttribute("colspan");
                                if (colspanStr.length() != 0) {
                                    colspan = Integer.parseInt(colspanStr);
                                }
                                if ((contw = this.computeChildContentWidth(col, colspan, style, box.unitType))[0] > maxrcw[k]) {
                                    maxrcw[k] = contw[0];
                                }
                                if (contw[1] > minrcw[k]) {
                                    minrcw[k] = contw[1];
                                }
                                k += colspan;
                            }
                        }
                        mincw = maxRowSpacing += box.getBorderLeftWidth() + box.getBorderRightWidth() + box.getMarginLeft() + box.getMarginRight() + box.getPaddingLeft() + box.getPaddingRight();
                        maxcw = maxRowSpacing;
                        for (int i = 0; i < ncol; ++i) {
                            mincw += minrcw[i];
                            maxcw += maxrcw[i];
                        }
                        box.colwidth = new float[ncol];
                        StyleValue cssval = style.getCascadedValue("width");
                        if (cssval != null && cssval.getCssValueType() == CSSValue.CssType.TYPED && !SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)((Object)cssval))) break block23;
                        if (!(capmin < box.getWidth()) || !(maxcw < box.getWidth())) break block24;
                        if (maxcw > capmin) {
                            box.width = maxcw;
                            for (int i = 0; i < ncol; ++i) {
                                box.colwidth[i] = maxrcw[i];
                            }
                        } else {
                            box.width = capmin;
                            float factor = capmin / maxcw;
                            for (int i = 0; i < ncol; ++i) {
                                box.colwidth[i] = maxrcw[i] * factor;
                            }
                        }
                        break block25;
                    }
                    unset = true;
                    if (mincw > box.width) {
                        box.width = mincw;
                        for (int i = 0; i < ncol; ++i) {
                            box.colwidth[i] = minrcw[i];
                        }
                        unset = false;
                    }
                    if (!(capmin > box.width)) break block26;
                    float factor = capmin / box.width;
                    box.width = capmin;
                    int i = 0;
                    while (i < ncol) {
                        int n = i++;
                        box.colwidth[n] = box.colwidth[n] * factor;
                    }
                    break block25;
                }
                if (!unset) break block25;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = maxrcw[i];
                }
                BoxModelHelper.shrinkTo(box, minrcw, mincw, maxcw, box.width);
                float width = 0.0f;
                for (int i = 0; i < ncol; ++i) {
                    width += box.colwidth[i];
                }
                box.width = width;
                break block25;
            }
            if (mincw > box.width) {
                box.width = mincw;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = minrcw[i];
                }
            } else {
                float factor = box.width / mincw;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = minrcw[i] * factor;
                }
            }
            if (capmin > box.width) {
                float factor = capmin / box.width;
                box.width = capmin;
                int i = 0;
                while (i < ncol) {
                    int n = i++;
                    box.colwidth[n] = box.colwidth[n] * factor;
                }
            }
        }
    }

    private float computeCapmin(short unitType) {
        CSSCanvas canvas = this.getComputedStyle().getOwnerNode().getOwnerDocument().getCanvas();
        ComputedCSSStyle style = this.getComputedStyle();
        CSSElement tbl = style.getOwnerNode();
        NodeList nlist = tbl.getElementsByTagName("caption");
        float capmin = 0.0f;
        for (int i = 0; i < nlist.getLength(); ++i) {
            CSSElement elm = (CSSElement)nlist.item(i);
            NodeList chldlist = elm.getChildNodes();
            for (int j = 0; j < chldlist.getLength(); ++j) {
                String text;
                Node chldnode = chldlist.item(j);
                if (chldnode.getNodeType() == 1) {
                    CSSElement col = (CSSElement)chldnode;
                    style = (ComputedCSSStyle)col.getOwnerDocument().getStyleSheet().getComputedStyle(col, null);
                    if (!"inline".equalsIgnoreCase(style.getDisplay())) {
                        throw new DOMException(9, "Only inline elements are supported in caption");
                    }
                    text = chldnode.getTextContent();
                } else {
                    text = chldnode.getNodeType() == 3 || chldnode.getNodeType() == 4 ? chldnode.getTextContent() : null;
                }
                float minw = 0.0f;
                if (text != null) {
                    text = BoxModelHelper.contractSpaces(text.trim());
                    minw = canvas != null ? NumberValue.floatValueConversion(canvas.stringWidth(text, style), (short)6, unitType) : BoxModelHelper.computeNodeMinimumWidth(text, style, unitType);
                }
                if (!(minw > capmin)) continue;
                capmin = minw;
            }
        }
        return capmin;
    }

    private float[] computeChildContentWidth(CSSElement col, int colspan, ComputedCSSStyle style, short unitType) {
        float[] contw = new float[]{0.0f, 0.0f};
        NodeList nlist = col.getChildNodes();
        int sz = nlist.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() == 3) {
                float[] nodew = this.computeTextWidth(node.getTextContent(), colspan, style, unitType);
                contw[0] = contw[0] + nodew[0];
                contw[1] = contw[1] + nodew[1];
                continue;
            }
            if (node.getNodeType() != 1) continue;
            CSSElement elm = (CSSElement)node;
            style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(elm, null);
            float width = this.computeWidth(style, unitType);
            contw[0] = contw[0] + width;
            contw[1] = contw[1] + width;
        }
        return contw;
    }

    private float[] computeTextWidth(String text, int colspan, ComputedCSSStyle style, short unitType) {
        float[] contw = new float[]{0.0f, 0.0f};
        text = BoxModelHelper.contractSpaces(text.trim());
        CSSCanvas canvas = this.getComputedStyle().getOwnerNode().getOwnerDocument().getCanvas();
        contw[0] = canvas != null ? NumberValue.floatValueConversion(canvas.stringWidth(text, style), (short)6, unitType) : BoxModelHelper.computeTextWidth(text, style, unitType);
        BoxValues colbox = style.getBoxValues(unitType);
        float spacing = colbox.getBorderLeftWidth() + colbox.getBorderRightWidth() + colbox.getMarginLeft() + colbox.getMarginRight() + colbox.getPaddingLeft() + colbox.getPaddingRight();
        contw[0] = contw[0] + spacing;
        contw[1] = canvas != null ? BoxModelHelper.computeNodeMinimumWidth(text, style, canvas, unitType) / (float)colspan + spacing : BoxModelHelper.computeNodeMinimumWidth(text, style, unitType) / (float)colspan + spacing;
        return contw;
    }

    private void computeTableCellBox(MyBoxValues colbox) {
        this.computeSharedBoxValues(colbox);
        this.computeInlineBox(colbox);
    }

    private float deviceDocumentWidth(String failureReason, String value, short unitType) throws StyleDatabaseRequiredException {
        Viewport viewport;
        CSSCanvas canvas;
        StyleDatabase sdb = this.getStyleDatabase();
        Document doc = this.getComputedStyle().getOwnerNode().getOwnerDocument();
        if (doc != null && (canvas = doc.getCanvas()) != null && (viewport = canvas.getViewport()) != null) {
            float fv = viewport.getViewportWidth();
            return NumberValue.floatValueConversion(fv, sdb.getNaturalUnit(), unitType);
        }
        if (sdb == null) {
            String medium;
            if (doc != null && (medium = doc.getTargetMedium()) != null) {
                if ("print".equals(medium)) {
                    return 595.0f;
                }
                if ("screen".equals(medium)) {
                    return 1440.0f;
                }
                if ("handheld".equals(medium)) {
                    return 270.0f;
                }
            }
            StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, " + failureReason);
            pve.setValueText(value);
            throw pve;
        }
        return NumberValue.floatValueConversion(sdb.getDeviceWidth(), sdb.getNaturalUnit(), unitType);
    }

    private float computeMarginNumberValue(ComputedCSSStyle styledecl, String propertyName, CSSTypedValue cssval, short unitType) throws StyleDatabaseRequiredException {
        float fv;
        try {
            fv = this.floatValue(styledecl, propertyName, cssval, unitType, true);
            if (fv < 0.0f) {
                fv = 0.0f;
            }
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
            fv = 0.0f;
        }
        return fv;
    }

    private float floatValue(ComputedCSSStyle styledecl, String propertyName, CSSTypedValue cssval, short unitType, boolean useDeviceDocumentWidth) throws DOMException {
        float fv;
        CSSValue.Type declType;
        if (unitType < 0) {
            if (this.getStyleDatabase() == null) {
                StyleDatabaseRequiredException sdex = new StyleDatabaseRequiredException("Requested natural unit, but no style database was set.");
                sdex.setValueText(cssval.getCssText());
                throw sdex;
            }
            unitType = this.getStyleDatabase().getNaturalUnit();
        }
        if ((declType = cssval.getPrimitiveType()) == CSSValue.Type.EXPRESSION) {
            fv = this.calcValue(styledecl, propertyName, (ExpressionValue)cssval, unitType, useDeviceDocumentWidth);
        } else if (declType == CSSValue.Type.MATH_FUNCTION) {
            fv = this.functionValue(styledecl, propertyName, (CSSMathFunctionValue)cssval, unitType, useDeviceDocumentWidth);
        } else if (declType == CSSValue.Type.NUMERIC) {
            fv = cssval.getUnitType() == 2 ? this.percentageValue(styledecl, cssval, unitType, useDeviceDocumentWidth) : cssval.getFloatValue(unitType);
        } else {
            throw new DOMException(15, "Unable to evaluate value of type: " + (Object)((Object)declType));
        }
        return fv;
    }

    private float percentageValue(ComputedCSSStyle styledecl, CSSTypedValue cssval, short unitType, boolean useDeviceDocumentWidth) {
        if ((styledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) == null) {
            if (useDeviceDocumentWidth) {
                return this.deviceDocumentWidth("no enclosing block, and value is percentage.", cssval.getCssText(), unitType) * cssval.getFloatValue((short)2) / 100.0f;
            }
            this.getComputedStyle().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        return this.computeWidth(styledecl, unitType) * cssval.getFloatValue((short)2) / 100.0f;
    }

    private static ComputedCSSStyle findContainingBlockStyle(ComputedCSSStyle styledecl) {
        String position = styledecl.getPropertyValue("position");
        if ("fixed".equalsIgnoreCase(position)) {
            return null;
        }
        if ("absolute".equalsIgnoreCase(position)) {
            throw new DOMException(9, "position: absolute is not supported");
        }
        String display = styledecl.getPropertyValue("display");
        if ("table-cell".equalsIgnoreCase(display)) {
            while ((styledecl = styledecl.getParentComputedStyle()) != null && !"table".equalsIgnoreCase(display = styledecl.getPropertyValue("display"))) {
            }
        } else {
            while ((styledecl = styledecl.getParentComputedStyle()) != null) {
                display = styledecl.getPropertyValue("display");
                if (!"block".equals(display = display.toLowerCase(Locale.ROOT)) && !"list-item".equals(display) && !"table".equals(display) && !display.startsWith("table-")) continue;
            }
        }
        return styledecl;
    }

    private boolean isRootBox() {
        return this.getComputedStyle().getOwnerNode().getParentNode().getNodeType() != 1;
    }

    private float calcValue(ComputedCSSStyle styledecl, String propertyName, ExpressionValue cssCalc, short unitType, boolean useDeviceDocumentWidth) {
        BoxEvaluator ev = new BoxEvaluator(styledecl, propertyName, useDeviceDocumentWidth);
        CSSTypedValue result = ev.evaluateExpression(cssCalc);
        if (result.isNegativeNumber()) {
            return 0.0f;
        }
        return result.getFloatValue(unitType);
    }

    private float functionValue(ComputedCSSStyle styledecl, String propertyName, CSSMathFunctionValue function, short unitType, boolean useDeviceDocumentWidth) {
        BoxEvaluator ev = new BoxEvaluator(styledecl, propertyName, useDeviceDocumentWidth);
        return ev.evaluateFunction(function).getFloatValue(unitType);
    }

    private float computeWidth(ComputedCSSStyle styledecl, short unitType) throws StyleDatabaseRequiredException {
        CSSTypedValue typed;
        StyleValue cssval = styledecl.getCascadedValue("width");
        if (cssval == null || cssval.getCssValueType() != CSSValue.CssType.TYPED || SimpleBoxModel.isTypedAutoOrInvalidLength(typed = (CSSTypedValue)((Object)cssval))) {
            float contBlockWidth;
            StyleValue cssMarginLeft = styledecl.getCascadedValue("margin-left");
            StyleValue cssMarginRight = styledecl.getCascadedValue("margin-right");
            float marginLeft = this.findWidthautoBoxProperty(styledecl, "margin-left", cssMarginLeft, unitType);
            float borderLeftWidth = this.findBorderWidthProperty(styledecl, "border-left-width", unitType, "border-left-style");
            float paddingLeft = this.computePaddingSubproperty(styledecl, PADDING.LEFT, unitType);
            float paddingRight = this.computePaddingSubproperty(styledecl, PADDING.RIGHT, unitType);
            float borderRightWidth = this.findBorderWidthProperty(styledecl, "border-right-width", unitType, "border-right-style");
            float marginRight = this.findWidthautoBoxProperty(styledecl, "margin-right", cssMarginRight, unitType);
            ComputedCSSStyle contblockStyledecl = SimpleBoxModel.findContainingBlockStyle(styledecl);
            if (contblockStyledecl == null) {
                contBlockWidth = this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto", unitType);
            } else {
                String display = contblockStyledecl.getPropertyValue("display").toLowerCase(Locale.ROOT);
                if ("table".equals(display) || display.startsWith("table-")) {
                    cssval = contblockStyledecl.getCascadedValue("width");
                    if (cssval == null || cssval.getCssValueType() != CSSValue.CssType.TYPED || SimpleBoxModel.isTypedAutoOrInvalidLength(typed = (CSSTypedValue)((Object)cssval)) || typed.getUnitType() == 2) {
                        throw new DOMException(9, "Automatic tables not supported by this box model");
                    }
                    contBlockWidth = this.computeNonAutoWidth(contblockStyledecl, typed, unitType);
                } else {
                    contBlockWidth = this.computeWidth(contblockStyledecl, unitType);
                }
            }
            return contBlockWidth - (marginLeft + marginRight + borderLeftWidth + borderRightWidth + paddingLeft + paddingRight);
        }
        return this.computeNonAutoWidth(styledecl, typed, unitType);
    }

    private float computeNonAutoWidth(ComputedCSSStyle styledecl, CSSTypedValue cssWidth, short unitType) throws DOMException, StyleDatabaseRequiredException {
        float fv;
        try {
            fv = this.floatValue(styledecl, "width", cssWidth, unitType, true);
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + cssWidth.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("width", ex);
            fv = 0.0f;
        }
        return fv;
    }

    private float findWidthautoBoxProperty(ComputedCSSStyle styledecl, String propertyName, CSSValue cssval, short unitType) throws StyleDatabaseRequiredException, DOMException {
        if (cssval != null && !SimpleBoxModel.isAutoOrInvalidLength(cssval)) {
            while (cssval.getPrimitiveType() == CSSValue.Type.INHERIT) {
                if ((styledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) != null) {
                    cssval = styledecl.getCascadedValue(propertyName);
                    continue;
                }
                cssval = null;
                break;
            }
            if (cssval != null) {
                if (cssval.getCssValueType() != CSSValue.CssType.TYPED) {
                    throw new DOMException(12, "Unexpected width value: " + cssval.getCssText());
                }
                CSSTypedValue cssprim = (CSSTypedValue)cssval;
                return this.findNumericBoxProperty(styledecl, propertyName, cssprim, unitType);
            }
        }
        return 0.0f;
    }

    private static boolean isAutoOrInvalidLength(CSSValue cssval) {
        return cssval.getCssValueType() == CSSValue.CssType.TYPED && SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)cssval);
    }

    private float findBorderWidthProperty(ComputedCSSStyle styledecl, String propertyName, short unitType, String stylePropertyName) throws StyleDatabaseRequiredException, DOMException {
        StyleValue borderStyle = styledecl.getCascadedValue(stylePropertyName);
        if (borderStyle == null || borderStyle.getPrimitiveType() != CSSValue.Type.IDENT || "none".equalsIgnoreCase(((CSSTypedValue)((Object)borderStyle)).getStringValue())) {
            return 0.0f;
        }
        StyleValue cssval = styledecl.getCascadedValue(propertyName);
        if (cssval != null) {
            while (cssval.getPrimitiveType() == CSSValue.Type.INHERIT) {
                if ((styledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) != null) {
                    cssval = styledecl.getCascadedValue(propertyName);
                    continue;
                }
                cssval = null;
                break;
            }
            if (cssval != null) {
                float fval;
                if (cssval.getCssValueType() != CSSValue.CssType.TYPED) {
                    throw new DOMException(12, "Unexpected border-width value: " + cssval.getCssText());
                }
                CSSTypedValue cssprim = (CSSTypedValue)((Object)cssval);
                if (cssprim.getPrimitiveType() == CSSValue.Type.IDENT) {
                    short declType;
                    if (this.getStyleDatabase() == null) {
                        if (this.getComplianceMode() != CSSDocument.ComplianceMode.QUIRKS) {
                            StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, and " + propertyName + " value is an identifier.");
                            pve.setValueText(cssval.getCssText());
                            throw pve;
                        }
                        float sz = this.getComputedStyle().getComputedFontSize();
                        String sv = cssprim.getStringValue();
                        fval = sv.equalsIgnoreCase("thin") ? (float)Math.floor(1.0 + (double)sz * 0.05) : (sv.equalsIgnoreCase("thick") ? (float)Math.floor(4.0 + (double)sz * 0.15) : (float)Math.floor(2.0 + (double)sz * 0.1));
                        declType = 6;
                    } else {
                        declType = this.getStyleDatabase().getNaturalUnit();
                        fval = this.getStyleDatabase().getWidthSize(cssprim.getStringValue(), styledecl.getComputedFontSize());
                    }
                    if (unitType != declType) {
                        fval = NumberValue.floatValueConversion(fval, declType, unitType);
                    }
                } else {
                    fval = this.findNumericBoxProperty(styledecl, propertyName, cssprim, unitType);
                }
                return fval;
            }
        }
        return 0.0f;
    }

    private CSSDocument.ComplianceMode getComplianceMode() {
        CSSDocument document;
        CSSElement node = this.getComputedStyle().getOwnerNode();
        if (node != null && (document = (CSSDocument)node.getOwnerDocument()) != null) {
            return document.getComplianceMode();
        }
        return CSSDocument.ComplianceMode.STRICT;
    }

    private float findNumericBoxProperty(ComputedCSSStyle styledecl, String propertyName, CSSTypedValue cssprim, short unitType) throws StyleDatabaseRequiredException {
        float fv;
        try {
            fv = this.floatValue(styledecl, propertyName, cssprim, unitType, true);
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + cssprim.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
            fv = 0.0f;
        }
        return fv;
    }

    private float computePaddingSubproperty(ComputedCSSStyle styledecl, PADDING paddingProperty, short unitType) throws StyleDatabaseRequiredException {
        float fv;
        String propertyName;
        switch (paddingProperty.ordinal()) {
            case 0: {
                propertyName = "padding-top";
                break;
            }
            case 1: {
                propertyName = "padding-right";
                break;
            }
            case 2: {
                propertyName = "padding-bottom";
                break;
            }
            default: {
                propertyName = "padding-left";
            }
        }
        StyleValue cssval = styledecl.getCascadedValue(propertyName);
        if (cssval.getPrimitiveType() == CSSValue.Type.INHERIT) {
            if ((styledecl = styledecl.getParentComputedStyle()) != null) {
                float fv2;
                BoxValues ctbox = styledecl.getBoxValues(unitType);
                switch (paddingProperty.ordinal()) {
                    case 0: {
                        fv2 = ctbox.getPaddingTop();
                        break;
                    }
                    case 1: {
                        fv2 = ctbox.getPaddingRight();
                        break;
                    }
                    case 2: {
                        fv2 = ctbox.getPaddingBottom();
                        break;
                    }
                    default: {
                        fv2 = ctbox.getPaddingLeft();
                    }
                }
                return fv2;
            }
            this.getComputedStyle().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        if (cssval.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(12, "Unexpected padding value: " + cssval.getCssText());
        }
        CSSTypedValue csspri = (CSSTypedValue)((Object)cssval);
        try {
            fv = this.floatValue(styledecl, propertyName, csspri, unitType, false);
            if (fv < 0.0f) {
                fv = 0.0f;
            }
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + csspri.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
            fv = 0.0f;
        }
        return fv;
    }

    static class MyBoxValues
    implements BoxValues {
        final short unitType;
        float marginTop = 0.0f;
        float marginRight = 0.0f;
        float marginBottom = 0.0f;
        float marginLeft = 0.0f;
        float paddingTop = 0.0f;
        float paddingRight = 0.0f;
        float paddingBottom = 0.0f;
        float paddingLeft = 0.0f;
        float borderTopWidth = 0.0f;
        float borderBottomWidth = 0.0f;
        float borderRightWidth = 0.0f;
        float borderLeftWidth = 0.0f;
        float width = Float.MIN_VALUE;

        MyBoxValues(short unitType) {
            this.unitType = unitType;
        }

        @Override
        public float getMarginTop() {
            return this.marginTop;
        }

        @Override
        public float getMarginRight() {
            return this.marginRight;
        }

        @Override
        public float getMarginBottom() {
            return this.marginBottom;
        }

        @Override
        public float getMarginLeft() {
            return this.marginLeft;
        }

        @Override
        public float getPaddingTop() {
            return this.paddingTop;
        }

        @Override
        public float getPaddingRight() {
            return this.paddingRight;
        }

        @Override
        public float getPaddingBottom() {
            return this.paddingBottom;
        }

        @Override
        public float getPaddingLeft() {
            return this.paddingLeft;
        }

        @Override
        public float getBorderTopWidth() {
            return this.borderTopWidth;
        }

        @Override
        public float getBorderRightWidth() {
            return this.borderRightWidth;
        }

        @Override
        public float getBorderBottomWidth() {
            return this.borderBottomWidth;
        }

        @Override
        public float getBorderLeftWidth() {
            return this.borderLeftWidth;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public short getUnitType() {
            return this.unitType;
        }
    }

    private static enum PADDING {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }

    static class MyTableBoxValues
    extends MyBoxValues
    implements BoxValues.TableBoxValues {
        float[] colwidth;

        MyTableBoxValues(short unitType) {
            super(unitType);
        }

        @Override
        public float[] getColumnsContentWidth() {
            return this.colwidth;
        }
    }

    static class MyTableItemBoxValues
    extends MyBoxValues {
        MyTableItemBoxValues(short unitType) {
            super(unitType);
        }

        @Override
        public float getWidth() {
            throw new DOMException(9, "Operation not supported by this box model. Please compute box for table and cast to TableBoxValues.");
        }
    }

    private class BoxEvaluator
    extends Evaluator {
        private final ComputedCSSStyle styledecl;
        private final String propertyName;
        private final boolean useDeviceDocumentWidth;

        private BoxEvaluator(ComputedCSSStyle styledecl, String propertyName, boolean useDeviceDocumentWidth) {
            this.styledecl = styledecl;
            this.propertyName = propertyName;
            this.useDeviceDocumentWidth = useDeviceDocumentWidth;
        }

        @Override
        protected CSSTypedValue absoluteTypedValue(CSSTypedValue partialValue) {
            return this.styledecl.absoluteTypedValue(this.propertyName, (TypedValue)partialValue, false);
        }

        @Override
        protected StyleValue absoluteProxyValue(CSSPrimitiveValue partialValue) {
            return this.styledecl.replaceProxyValue(this.propertyName, partialValue);
        }

        @Override
        protected float percentage(CSSTypedValue value, short unitType) throws DOMException {
            return SimpleBoxModel.this.percentageValue(this.styledecl, value, unitType, this.useDeviceDocumentWidth);
        }
    }
}

