/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import org.apache.commons.lang.StringUtils;

class Remover {
    private final String processedText;
    private int begin;
    private int end;

    public String getProcessedText() {
        return this.processedText.substring(this.begin, this.end);
    }

    public Remover(String text) {
        this.processedText = text;
        this.begin = 0;
        this.end = text.length();
    }

    public Remover removeFirstAndBefore(String element) {
        this.begin = this.indexOfFirstCharacterAfter('<' + element);
        return this;
    }

    private int indexOfFirstCharacterAfter(String element) {
        int index = StringUtils.indexOfIgnoreCase((String)this.processedText, (String)element, (int)this.begin) + 1;
        if (index <= this.begin) {
            return this.begin;
        }
        if ((index = this.processedText.indexOf(62, index) + 1) <= this.begin) {
            return this.begin;
        }
        while (index < this.end && Character.isWhitespace(this.processedText.charAt(index))) {
            ++index;
        }
        return index;
    }

    public Remover removeLastAndAfter(String element) {
        this.end = this.indexOfLastCharacterBefore('<' + element);
        return this;
    }

    private int indexOfLastCharacterBefore(String element) {
        int index = StringUtils.lastIndexOfIgnoreCase((String)this.processedText, (String)element, (int)this.end) - 1;
        if (index < this.begin) {
            return this.end;
        }
        while (index > this.begin && Character.isWhitespace(this.processedText.charAt(index))) {
            --index;
        }
        return index + 1;
    }

    public static void main(String[] argv) {
        assert (new Remover("<html>\n\t<body> 1 </body>\\n\\t<html>").removeFirstAndBefore("body").removeLastAndAfter("/body").getProcessedText().equals("1"));
        assert (new Remover("<html>\n\t<body2> 1 </body>\\n\\t<html>").removeFirstAndBefore("body").removeLastAndAfter("/body").getProcessedText().equals("1"));
        assert (new Remover("<html>\n\t<body>4 1 5</body>\\n\\t<html>").removeFirstAndBefore("body").removeLastAndAfter("/body").getProcessedText().equals("4 1 5"));
        System.out.println("Success");
    }
}

