/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

class ViewerBorder
extends EmptyBorder {
    private final int borderWidth;
    private final Color borderColor;

    ViewerBorder(int width, Color borderColor) {
        super(0, 0, 0, 0);
        this.borderWidth = width;
        this.borderColor = borderColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c.getCursor().getType() == 5) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(this.borderColor);
            g.fillRect(0, 0, width - this.borderWidth, this.borderWidth);
            g.fillRect(0, this.borderWidth, this.borderWidth, height - this.borderWidth);
            g.fillRect(this.borderWidth, height - this.borderWidth, width - this.borderWidth, this.borderWidth);
            g.fillRect(width - this.borderWidth, 0, this.borderWidth, height - this.borderWidth);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    public static void repaintBorder(JComponent component) {
        int borderWidth = ((ViewerBorder)component.getBorder()).borderWidth;
        component.paintImmediately(0, 0, component.getWidth(), borderWidth);
        component.paintImmediately(0, component.getHeight() - borderWidth, component.getWidth(), borderWidth);
        component.paintImmediately(0, 0, borderWidth, component.getHeight());
        component.paintImmediately(component.getWidth() - borderWidth, 0, borderWidth, component.getHeight());
    }
}

