/*! @azure/msal-browser v4.28.1 2026-01-17 */
'use strict';
import { AuthFlowStateBase } from '../../../core/auth_flow/AuthFlowState.mjs';
import { GET_ACCOUNT_COMPLETED_STATE_TYPE, GET_ACCOUNT_FAILED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * The completed state of the get account flow.
 */
class GetAccountCompletedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = GET_ACCOUNT_COMPLETED_STATE_TYPE;
    }
}
/**
 * The failed state of the get account flow.
 */
class GetAccountFailedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = GET_ACCOUNT_FAILED_STATE_TYPE;
    }
}

export { GetAccountCompletedState, GetAccountFailedState };
//# sourceMappingURL=GetAccountState.mjs.map
