﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kms/KMS_EXPORTS.h>

namespace Aws {
namespace KMS {
namespace Model {
enum class KeyState { NOT_SET, Creating, Enabled, Disabled, PendingDeletion, PendingImport, PendingReplicaDeletion, Unavailable, Updating };

namespace KeyStateMapper {
AWS_KMS_API KeyState GetKeyStateForName(const Aws::String& name);

AWS_KMS_API Aws::String GetNameForKeyState(KeyState value);
}  // namespace KeyStateMapper
}  // namespace Model
}  // namespace KMS
}  // namespace Aws
