﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes an potential intermediate component of a feasible
 * path.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AlternatePathHint">AWS
 * API Reference</a></p>
 */
class AlternatePathHint {
 public:
  AWS_EC2_API AlternatePathHint() = default;
  AWS_EC2_API AlternatePathHint(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API AlternatePathHint& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The ID of the component.</p>
   */
  inline const Aws::String& GetComponentId() const { return m_componentId; }
  inline bool ComponentIdHasBeenSet() const { return m_componentIdHasBeenSet; }
  template <typename ComponentIdT = Aws::String>
  void SetComponentId(ComponentIdT&& value) {
    m_componentIdHasBeenSet = true;
    m_componentId = std::forward<ComponentIdT>(value);
  }
  template <typename ComponentIdT = Aws::String>
  AlternatePathHint& WithComponentId(ComponentIdT&& value) {
    SetComponentId(std::forward<ComponentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the component.</p>
   */
  inline const Aws::String& GetComponentArn() const { return m_componentArn; }
  inline bool ComponentArnHasBeenSet() const { return m_componentArnHasBeenSet; }
  template <typename ComponentArnT = Aws::String>
  void SetComponentArn(ComponentArnT&& value) {
    m_componentArnHasBeenSet = true;
    m_componentArn = std::forward<ComponentArnT>(value);
  }
  template <typename ComponentArnT = Aws::String>
  AlternatePathHint& WithComponentArn(ComponentArnT&& value) {
    SetComponentArn(std::forward<ComponentArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_componentId;

  Aws::String m_componentArn;
  bool m_componentIdHasBeenSet = false;
  bool m_componentArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
