﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dataexchange/DataExchangeRequest.h>
#include <aws/dataexchange/DataExchange_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DataExchange {
namespace Model {

/**
 */
class RevokeRevisionRequest : public DataExchangeRequest {
 public:
  AWS_DATAEXCHANGE_API RevokeRevisionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RevokeRevision"; }

  AWS_DATAEXCHANGE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier for a data set.</p>
   */
  inline const Aws::String& GetDataSetId() const { return m_dataSetId; }
  inline bool DataSetIdHasBeenSet() const { return m_dataSetIdHasBeenSet; }
  template <typename DataSetIdT = Aws::String>
  void SetDataSetId(DataSetIdT&& value) {
    m_dataSetIdHasBeenSet = true;
    m_dataSetId = std::forward<DataSetIdT>(value);
  }
  template <typename DataSetIdT = Aws::String>
  RevokeRevisionRequest& WithDataSetId(DataSetIdT&& value) {
    SetDataSetId(std::forward<DataSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for a revision.</p>
   */
  inline const Aws::String& GetRevisionId() const { return m_revisionId; }
  inline bool RevisionIdHasBeenSet() const { return m_revisionIdHasBeenSet; }
  template <typename RevisionIdT = Aws::String>
  void SetRevisionId(RevisionIdT&& value) {
    m_revisionIdHasBeenSet = true;
    m_revisionId = std::forward<RevisionIdT>(value);
  }
  template <typename RevisionIdT = Aws::String>
  RevokeRevisionRequest& WithRevisionId(RevisionIdT&& value) {
    SetRevisionId(std::forward<RevisionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A required comment to inform subscribers of the reason their access to the
   * revision was revoked.</p>
   */
  inline const Aws::String& GetRevocationComment() const { return m_revocationComment; }
  inline bool RevocationCommentHasBeenSet() const { return m_revocationCommentHasBeenSet; }
  template <typename RevocationCommentT = Aws::String>
  void SetRevocationComment(RevocationCommentT&& value) {
    m_revocationCommentHasBeenSet = true;
    m_revocationComment = std::forward<RevocationCommentT>(value);
  }
  template <typename RevocationCommentT = Aws::String>
  RevokeRevisionRequest& WithRevocationComment(RevocationCommentT&& value) {
    SetRevocationComment(std::forward<RevocationCommentT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_dataSetId;

  Aws::String m_revisionId;

  Aws::String m_revocationComment;
  bool m_dataSetIdHasBeenSet = false;
  bool m_revisionIdHasBeenSet = false;
  bool m_revocationCommentHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataExchange
}  // namespace Aws
