﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/autoscaling/AutoScalingRequest.h>
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AutoScaling {
namespace Model {

/**
 */
class DeleteLifecycleHookRequest : public AutoScalingRequest {
 public:
  AWS_AUTOSCALING_API DeleteLifecycleHookRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLifecycleHook"; }

  AWS_AUTOSCALING_API Aws::String SerializePayload() const override;

 protected:
  AWS_AUTOSCALING_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The name of the lifecycle hook.</p>
   */
  inline const Aws::String& GetLifecycleHookName() const { return m_lifecycleHookName; }
  inline bool LifecycleHookNameHasBeenSet() const { return m_lifecycleHookNameHasBeenSet; }
  template <typename LifecycleHookNameT = Aws::String>
  void SetLifecycleHookName(LifecycleHookNameT&& value) {
    m_lifecycleHookNameHasBeenSet = true;
    m_lifecycleHookName = std::forward<LifecycleHookNameT>(value);
  }
  template <typename LifecycleHookNameT = Aws::String>
  DeleteLifecycleHookRequest& WithLifecycleHookName(LifecycleHookNameT&& value) {
    SetLifecycleHookName(std::forward<LifecycleHookNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Auto Scaling group.</p>
   */
  inline const Aws::String& GetAutoScalingGroupName() const { return m_autoScalingGroupName; }
  inline bool AutoScalingGroupNameHasBeenSet() const { return m_autoScalingGroupNameHasBeenSet; }
  template <typename AutoScalingGroupNameT = Aws::String>
  void SetAutoScalingGroupName(AutoScalingGroupNameT&& value) {
    m_autoScalingGroupNameHasBeenSet = true;
    m_autoScalingGroupName = std::forward<AutoScalingGroupNameT>(value);
  }
  template <typename AutoScalingGroupNameT = Aws::String>
  DeleteLifecycleHookRequest& WithAutoScalingGroupName(AutoScalingGroupNameT&& value) {
    SetAutoScalingGroupName(std::forward<AutoScalingGroupNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_lifecycleHookName;

  Aws::String m_autoScalingGroupName;
  bool m_lifecycleHookNameHasBeenSet = false;
  bool m_autoScalingGroupNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
