/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.item;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemIterableToolkit;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;

public class ItemCollectionToolkit {
    public static final IItemCollection EMPTY = new StreamBackedItemCollection(() -> Stream.empty(), Collections.emptySet());

    static IItemCollection build(Stream<? extends IItem> items, Set<IRange<IQuantity>> chunkRanges) {
        Map<IType, List<IItem>> byTypeMap = items.collect(Collectors.groupingBy(ItemToolkit::getItemType));
        ArrayList<Map.Entry<IType, List<IItem>>> entryList = new ArrayList<Map.Entry<IType, List<IItem>>>(byTypeMap.entrySet());
        return ItemCollectionToolkit.build(() -> entryList.stream().map(e -> ItemIterableToolkit.build(((List)e.getValue())::stream, (IType)e.getKey())));
    }

    public static IItemCollection build(Stream<? extends IItem> items) {
        return ItemCollectionToolkit.build(items, Collections.emptySet());
    }

    public static IItemCollection build(Supplier<Stream<IItemIterable>> items, Set<IRange<IQuantity>> chunkRanges) {
        return new StreamBackedItemCollection(items, Collections.emptySet());
    }

    public static IItemCollection build(Supplier<Stream<IItemIterable>> items) {
        return ItemCollectionToolkit.build(items, Collections.emptySet());
    }

    public static IItemCollection merge(Supplier<Stream<IItemCollection>> items) {
        Set<IRange<IQuantity>> chunkRanges = items.get().flatMap(i -> i.getUnfilteredTimeRanges().stream()).collect(Collectors.toSet());
        return ItemCollectionToolkit.build(() -> ((Stream)items.get()).flatMap(i -> i.stream()), chunkRanges);
    }

    public static <V> Optional<IItemIterable> join(IItemCollection items, String withTypeId) {
        IItemCollection itemsWithType = items.apply(ItemFilters.type(withTypeId));
        return itemsWithType.stream().findAny().map(s -> ItemIterableToolkit.build(() -> itemsWithType.stream().flatMap(i -> i.stream()), s.getType()));
    }

    public static String getDescription(IItemCollection items) {
        Map<IType, Long> itemCountByType = items.stream().filter(IItemIterable::hasItems).collect(Collectors.toMap(IItemIterable::getType, IItemIterable::getItemCount, Long::sum));
        if (itemCountByType.size() < 4) {
            return itemCountByType.entrySet().stream().map(e -> e.getValue() + " " + ((IType)e.getKey()).getName()).sorted().collect(Collectors.joining(", "));
        }
        return MessageFormat.format("ITEM_COLLECTION_DESC", itemCountByType.values().stream().mapToLong(Long::longValue).sum(), itemCountByType.size());
    }

    public static IItemCollection filterIfNotNull(IItemCollection items, IItemFilter filter) {
        return filter == null ? items : items.apply(filter);
    }

    private static class StreamBackedItemCollection
    implements IItemCollection {
        private final Supplier<Stream<IItemIterable>> items;
        private final Set<IRange<IQuantity>> chunkRanges;

        StreamBackedItemCollection(Supplier<Stream<IItemIterable>> items, Set<IRange<IQuantity>> chunkRanges) {
            this.items = items;
            this.chunkRanges = chunkRanges;
        }

        @Override
        public Iterator<IItemIterable> iterator() {
            return this.items.get().iterator();
        }

        @Override
        public Spliterator<IItemIterable> spliterator() {
            return this.items.get().spliterator();
        }

        @Override
        public StreamBackedItemCollection apply(IItemFilter filter) {
            return new StreamBackedItemCollection(() -> ItemIterableToolkit.filter(this.items.get(), filter), this.chunkRanges);
        }

        @Override
        public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
            return ItemIterableToolkit.aggregate(aggregator, this.items.get());
        }

        @Override
        public boolean hasItems() {
            return this.items.get().anyMatch(IItemIterable::hasItems);
        }

        @Override
        public Set<IRange<IQuantity>> getUnfilteredTimeRanges() {
            return this.chunkRanges;
        }
    }
}

