/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.openide.modules.ModuleInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class ModuleCache
implements PropertyChangeListener,
LookupListener {
    private static ModuleCache INSTANCE;
    private final Lookup.Result<ModuleInfo> result;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private Map<String, ModuleInfo> infos;

    private ModuleCache() {
        this.result = Lookup.getDefault().lookupResult(ModuleInfo.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public static synchronized ModuleCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModuleCache();
        }
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.support.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.support.removeChangeListener(changeListener);
    }

    public ModuleInfo find(String string) {
        return this.infos.get(string);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        for (Object object : this.result.allInstances()) {
            object.removePropertyChangeListener((PropertyChangeListener)this);
            object.addPropertyChangeListener((PropertyChangeListener)this);
        }
        HashMap hashMap = new HashMap();
        for (ModuleInfo moduleInfo : this.result.allInstances()) {
            hashMap.put(moduleInfo.getCodeNameBase(), moduleInfo);
        }
        this.infos = hashMap;
        if (lookupEvent != null) {
            this.fireChange();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            ModuleInfo moduleInfo = (ModuleInfo)propertyChangeEvent.getSource();
        }
    }

    private void fireChange() {
        this.support.fireChange();
    }
}

