/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.ActionAddColumn;
import com.dickimawbooks.texparserlib.latex.datatool.ActionDisplay;
import com.dickimawbooks.texparserlib.latex.datatool.ActionNew;
import com.dickimawbooks.texparserlib.latex.datatool.ActionNewEntry;
import com.dickimawbooks.texparserlib.latex.datatool.ActionNewRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public abstract class Action {
    protected DataToolSty sty;
    protected String actionName;
    protected TeXParser parser;
    protected TeXObjectList stack;
    protected String[] dbNames;
    protected String dbName;
    protected String columnKey;
    protected String column2Key;
    protected int columnIndex = 0;
    protected int column2Index = 0;
    protected int rowIndex = 0;
    protected int row2Index = 0;
    protected DatumType dataType = DatumType.UNKNOWN;
    protected CsvList optionsList;
    protected CsvList assignList;
    protected TeXObject value;
    protected DataBase db;

    protected Action() {
    }

    public abstract void doAction() throws IOException;

    public static Action getAction(String string, DataToolSty dataToolSty, KeyValList keyValList, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string2;
        Numerical numerical;
        Action action;
        if (string.equals("new")) {
            action = new ActionNew();
        } else if (string.equals("new row")) {
            action = new ActionNewRow();
        } else if (string.equals("new entry")) {
            action = new ActionNewEntry();
        } else if (string.equals("add column")) {
            action = new ActionAddColumn();
        } else if (string.equals("display")) {
            action = new ActionDisplay();
        } else {
            throw new LaTeXSyntaxException(teXParser, "datatool.unsupported.action", string);
        }
        action.actionName = string;
        action.sty = dataToolSty;
        action.parser = teXParser;
        action.stack = teXObjectList;
        if (keyValList == null) {
            return action;
        }
        action.dbName = keyValList.getString("name", teXParser, teXObjectList);
        if (action.dbName != null) {
            action.dbNames = action.dbName.trim().split(" *, *");
            action.dbName = action.dbNames[0];
        }
        if ((numerical = keyValList.getNumerical("column", teXParser, teXObjectList)) != null) {
            action.columnIndex = numerical.number(teXParser);
        }
        if ((numerical = keyValList.getNumerical("column2", teXParser, teXObjectList)) != null) {
            action.column2Index = numerical.number(teXParser);
        }
        if ((numerical = keyValList.getNumerical("row", teXParser, teXObjectList)) != null) {
            action.rowIndex = numerical.number(teXParser);
        }
        if ((numerical = keyValList.getNumerical("row2", teXParser, teXObjectList)) != null) {
            action.row2Index = numerical.number(teXParser);
        }
        if ((string2 = keyValList.getString("type", teXParser, teXObjectList)) != null) {
            if ((string2 = string2.trim()).equals("string")) {
                action.dataType = DatumType.STRING;
            } else if (string2.equals("int") || string2.equals("integer")) {
                action.dataType = DatumType.INTEGER;
            } else if (string2.equals("decimal") || string2.equals("real")) {
                action.dataType = DatumType.DECIMAL;
            } else if (string2.equals("currency")) {
                action.dataType = DatumType.CURRENCY;
            } else if (string2.equals("datetime")) {
                action.dataType = DatumType.DATETIME;
            } else {
                throw new LaTeXSyntaxException(teXParser, "latex.invalid.option.value", "type", string2);
            }
        }
        action.columnKey = keyValList.getString("key", teXParser, teXObjectList);
        action.column2Key = keyValList.getString("key2", teXParser, teXObjectList);
        TeXObject teXObject = keyValList.getValue("options");
        if (teXObject != null) {
            action.optionsList = CsvList.getList(teXParser, teXObject);
        }
        if ((teXObject = keyValList.getValue("assign")) != null) {
            action.assignList = CsvList.getList(teXParser, teXObject);
        }
        if ((teXObject = keyValList.getValue("value")) != null) {
            action.value = teXObject;
        }
        if ((teXObject = keyValList.getValue("expand-once-value")) != null) {
            action.value = TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
        }
        if ((teXObject = keyValList.getValue("expand-value")) != null) {
            action.value = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
        }
        return action;
    }

    public String getDataBaseName() throws IOException {
        if (this.dbName == null) {
            this.dbName = TeXParserUtils.getControlSequenceValue("l__datatool_default_dbname_tl", "untitled", this.parser, this.stack);
        }
        return this.dbName;
    }

    public DataBase getDataBase() throws IOException {
        if (this.db != null) {
            return this.db;
        }
        this.db = this.sty.getDataBase(this.getDataBaseName());
        return this.db;
    }

    public String getColumnKey(boolean bl, boolean bl2) throws IOException {
        if (this.columnKey != null) {
            return this.columnKey;
        }
        if (this.columnIndex == 0) {
            if (bl) {
                throw new LaTeXSyntaxException(this.parser, "latex.error.missing_or", "key", "column");
            }
            return null;
        }
        if (this.getDataBase() == null) {
            throw new LaTeXSyntaxException(this.parser, "datatool.db_doesnt_exist", this.dbName);
        }
        DataToolHeaderRow dataToolHeaderRow = this.db.getHeaders();
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader(this.columnIndex);
        if (dataToolHeader == null) {
            if (bl2 && this.columnIndex == dataToolHeaderRow.getMaxIndex() + 1) {
                TeXObjectList teXObjectList = TeXParserUtils.createStack(this.parser, this.parser.getListener().getControlSequence("dtldefaultkey"), new UserNumber(this.columnIndex));
                String string = this.parser.expandToString(teXObjectList, this.stack);
                dataToolHeader = new DataToolHeader(this.sty, this.columnIndex, string, this.dataType, (TeXObject)this.parser.getListener().createString(string));
                dataToolHeaderRow.add(dataToolHeader);
            } else {
                throw new LaTeXSyntaxException(this.parser, "datatool.index.outofrange", this.columnIndex);
            }
        }
        this.columnKey = dataToolHeader.getColumnLabel();
        return this.columnKey;
    }
}

