/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;

public class ValueFeature
extends Feature {
    private float configValue = -1.0f;
    private String configValueStr = null;
    private Object value = null;
    private Boolean required = null;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        if (value instanceof String) {
            this.configValueStr = (String)value;
        } else if (value instanceof Double) {
            this.configValue = ((Double)value).floatValue();
        } else if (value instanceof Float) {
            this.configValue = ((Float)value).floatValue();
        } else if (value instanceof Integer) {
            this.configValue = ((Integer)value).floatValue();
        } else if (value instanceof Long) {
            this.configValue = ((Long)value).floatValue();
        } else {
            throw new FeatureException("Invalid type for 'value' in params for " + this);
        }
    }

    public boolean isRequired() {
        return Boolean.TRUE.equals(this.required);
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = this.defaultParamsToMap();
        params.put("value", this.value);
        if (this.required != null) {
            params.put("required", this.required);
        }
        return params;
    }

    @Override
    protected void validate() throws FeatureException {
        if (this.configValueStr != null && this.configValueStr.trim().isEmpty()) {
            throw new FeatureException("Empty field 'value' in params for " + this);
        }
    }

    public ValueFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public Feature.FeatureWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new ValueFeatureWeight(searcher, request, originalQuery, efi);
    }

    public class ValueFeatureWeight
    extends Feature.FeatureWeight {
        protected final Float featureValue;

        public ValueFeatureWeight(IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) {
            super(ValueFeature.this, searcher, request, originalQuery, efi);
            if (ValueFeature.this.configValueStr != null) {
                String expandedValue = this.macroExpander.expand(ValueFeature.this.configValueStr);
                if (expandedValue != null) {
                    this.featureValue = Float.valueOf(Float.parseFloat(expandedValue));
                } else {
                    if (ValueFeature.this.isRequired()) {
                        throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + " requires efi parameter that was not passed in request.");
                    }
                    this.featureValue = null;
                }
            } else {
                this.featureValue = Float.valueOf(ValueFeature.this.configValue);
            }
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            if (this.featureValue != null) {
                return new Feature.FeatureWeight.ValueFeatureScorer(this, this.featureValue.floatValue(), DocIdSetIterator.all((int)Integer.MAX_VALUE));
            }
            return null;
        }
    }
}

