/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpClusterStateProvider
implements ClusterStateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String urlScheme;
    volatile Set<String> liveNodes;
    long liveNodesTimestamp = 0L;
    volatile Map<String, List<String>> aliases;
    volatile Map<String, Map<String, String>> aliasProperties;
    long aliasesTimestamp = 0L;
    private int cacheTimeout = EnvUtils.getPropertyAsInteger("solr.solrj.cache.timeout.sec", 5);

    public void init(List<String> solrUrls) throws Exception {
        for (String solrUrl : solrUrls) {
            this.urlScheme = solrUrl.startsWith("https") ? "https" : "http";
            try (SolrClient initialClient = this.getSolrClient(solrUrl);){
                this.liveNodes = this.fetchLiveNodes(initialClient);
                this.liveNodesTimestamp = System.nanoTime();
                break;
            }
            catch (IOException | SolrServerException e) {
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)solrUrl, (Object)e);
            }
        }
        if (this.liveNodes == null || this.liveNodes.isEmpty()) {
            throw new RuntimeException("Tried fetching live_nodes using Solr URLs provided, i.e. " + solrUrls + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
    }

    protected abstract SolrClient getSolrClient(String var1);

    @Override
    public DocCollection getCollection(String collection) {
        return this.getState(collection).get();
    }

    @Override
    public ClusterState.CollectionRef getState(String collection) {
        for (String nodeName : this.liveNodes) {
            ClusterState.CollectionRef collectionRef;
            block12: {
                String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
                SolrClient client = this.getSolrClient(baseUrl);
                try {
                    DocCollection docCollection = this.fetchCollectionState(client, collection);
                    collectionRef = new ClusterState.CollectionRef(docCollection);
                    if (client == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | SolrServerException e) {
                        log.warn("Attempt to fetch cluster state from {} failed.", (Object)Utils.getBaseUrlForNodeName(nodeName, this.urlScheme), (Object)e);
                        continue;
                    }
                    catch (BaseHttpSolrClient.RemoteSolrException e) {
                        if ("NOT_FOUND".equals(e.getMetadata("CLUSTERSTATUS"))) {
                            return null;
                        }
                        log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
                        continue;
                    }
                    catch (NotACollectionException e) {
                        this.getAliases(true);
                        return null;
                    }
                }
                client.close();
            }
            return collectionRef;
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    private ClusterState fetchClusterState(SolrClient client) throws SolrServerException, IOException, NotACollectionException {
        SimpleOrderedMap<?> cluster = this.submitClusterStateRequest(client, null, ClusterStateRequestType.FETCH_CLUSTER_STATE);
        List liveNodesList = (List)cluster.get("live_nodes");
        if (liveNodesList != null) {
            this.liveNodes = Set.copyOf(liveNodesList);
            this.liveNodesTimestamp = System.nanoTime();
        }
        NamedList collectionsNl = (NamedList)cluster.get("collections");
        LinkedHashMap<String, DocCollection> collStateByName = CollectionUtil.newLinkedHashMap(collectionsNl.size());
        for (Map.Entry entry : collectionsNl) {
            collStateByName.put(entry.getKey(), this.getDocCollectionFromObjects(entry.getKey(), (Map)entry.getValue()));
        }
        return new ClusterState(this.liveNodes, collStateByName);
    }

    private DocCollection getDocCollectionFromObjects(String collectionName, Map<String, Object> collStateMap) {
        collStateMap.remove("health");
        int zNodeVersion = (Integer)collStateMap.remove("znodeVersion");
        Long creationTimeMillis = (Long)collStateMap.remove("creationTimeMillis");
        Instant creationTime = creationTimeMillis == null ? Instant.EPOCH : Instant.ofEpochMilli(creationTimeMillis);
        DocCollection.PrsSupplier prsSupplier = null;
        Map prs = (Map)collStateMap.remove("PRS");
        if (prs != null) {
            prsSupplier = () -> new PerReplicaStates((String)prs.get("path"), (Integer)prs.get("cversion"), (List)prs.get("states"));
        }
        return ClusterState.collectionFromObjects(collectionName, collStateMap, zNodeVersion, creationTime, prsSupplier);
    }

    private DocCollection fetchCollectionState(SolrClient client, String collection) throws SolrServerException, IOException, NotACollectionException {
        SimpleOrderedMap<?> cluster = this.submitClusterStateRequest(client, collection, ClusterStateRequestType.FETCH_COLLECTION);
        Map collStateMap = (Map)cluster.findRecursive("collections", collection);
        if (collStateMap == null) {
            throw new NotACollectionException();
        }
        return this.getDocCollectionFromObjects(collection, collStateMap);
    }

    private SimpleOrderedMap<?> submitClusterStateRequest(SolrClient client, String collection, ClusterStateRequestType requestType) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", "CLUSTERSTATUS");
        params.set("includeAll", false);
        switch (requestType) {
            case FETCH_CLUSTER_STATE: {
                params.set("includeAll", true);
                break;
            }
            case FETCH_COLLECTION: {
                if (collection == null) break;
                params.set("collection", collection);
                break;
            }
            case FETCH_LIVE_NODES: {
                params.set("liveNodes", true);
                break;
            }
            case FETCH_CLUSTER_PROP: {
                params.set("clusterProperties", true);
                break;
            }
            case FETCH_NODE_ROLES: {
                params.set("roles", true);
            }
        }
        params.set("prs", true);
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/collections", params);
        return (SimpleOrderedMap)client.request(request).get("cluster");
    }

    @Override
    public Set<String> getLiveNodes() {
        if (this.liveNodes == null) {
            throw new RuntimeException("We don't know of any live_nodes to fetch the latest live_nodes information from. If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        if (TimeUnit.SECONDS.convert(System.nanoTime() - this.liveNodesTimestamp, TimeUnit.NANOSECONDS) > (long)this.getCacheTimeout()) {
            for (String nodeName : this.liveNodes) {
                Set<String> set;
                block11: {
                    String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
                    SolrClient client = this.getSolrClient(baseUrl);
                    try {
                        Set<String> liveNodes = this.fetchLiveNodes(client);
                        this.liveNodes = liveNodes;
                        this.liveNodesTimestamp = System.nanoTime();
                        set = liveNodes;
                        if (client == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
                        }
                    }
                    client.close();
                }
                return set;
            }
            throw new RuntimeException("Tried fetching live_nodes using all the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        return this.liveNodes;
    }

    private Set<String> fetchLiveNodes(SolrClient client) throws Exception {
        SimpleOrderedMap<?> cluster = this.submitClusterStateRequest(client, null, ClusterStateRequestType.FETCH_LIVE_NODES);
        return Set.copyOf((List)cluster.get("live_nodes"));
    }

    @Override
    public List<String> resolveAlias(String aliasName) {
        return this.resolveAlias(aliasName, false);
    }

    public List<String> resolveAlias(String aliasName, boolean forceFetch) {
        return Aliases.resolveAliasesGivenAliasMap(this.getAliases(forceFetch), aliasName);
    }

    @Override
    public String resolveSimpleAlias(String aliasName) throws IllegalArgumentException {
        return Aliases.resolveSimpleAliasGivenAliasMap(this.getAliases(false), aliasName);
    }

    private Map<String, List<String>> getAliases(boolean forceFetch) {
        if (this.liveNodes == null) {
            throw new RuntimeException("We don't know of any live_nodes to fetch the latest aliases information from. If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        if (forceFetch || this.aliases == null || TimeUnit.SECONDS.convert(System.nanoTime() - this.aliasesTimestamp, TimeUnit.NANOSECONDS) > (long)this.getCacheTimeout()) {
            for (String nodeName : this.liveNodes) {
                Map<String, List<String>> map;
                block12: {
                    String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
                    SolrClient client = this.getSolrClient(baseUrl);
                    try {
                        CollectionAdminResponse response = (CollectionAdminResponse)new CollectionAdminRequest.ListAliases().process(client);
                        this.aliases = response.getAliasesAsLists();
                        this.aliasProperties = response.getAliasProperties();
                        this.aliasesTimestamp = System.nanoTime();
                        map = Collections.unmodifiableMap(this.aliases);
                        if (client == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
                            if (e instanceof BaseHttpSolrClient.RemoteSolrException && ((BaseHttpSolrClient.RemoteSolrException)e).code() == 400) {
                                log.warn("LISTALIASES not found, possibly using older Solr server. Aliases won't work {}", (Object)"unless you re-create the CloudSolrClient using zkHost(s) or upgrade Solr server", (Object)e);
                                this.aliases = Collections.emptyMap();
                                this.aliasProperties = Collections.emptyMap();
                                this.aliasesTimestamp = System.nanoTime();
                                return this.aliases;
                            }
                            log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
                        }
                    }
                    client.close();
                }
                return map;
            }
            throw new RuntimeException("Tried fetching aliases using all the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using a working solrUrl or zkHost.");
        }
        return Collections.unmodifiableMap(this.aliases);
    }

    @Override
    public Map<String, String> getAliasProperties(String alias) {
        this.getAliases(false);
        return Collections.unmodifiableMap(this.aliasProperties.getOrDefault(alias, Collections.emptyMap()));
    }

    @Override
    public ClusterState getClusterState() {
        for (String nodeName : this.liveNodes) {
            ClusterState clusterState;
            block10: {
                String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
                SolrClient client = this.getSolrClient(baseUrl);
                try {
                    clusterState = this.fetchClusterState(client);
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
                        log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
                        continue;
                    }
                    catch (NotACollectionException e) {
                        throw new RuntimeException("null should never cause NotACollectionException in fetchClusterState() Please report this as a bug!");
                    }
                }
                client.close();
            }
            return clusterState;
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    @Override
    public Map<String, Object> getClusterProperties() {
        for (String nodeName : this.liveNodes) {
            Map map;
            block9: {
                String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
                SolrClient client = this.getSolrClient(baseUrl);
                try {
                    SimpleOrderedMap<?> cluster = this.submitClusterStateRequest(client, null, ClusterStateRequestType.FETCH_CLUSTER_PROP);
                    map = (Map)cluster.get("properties");
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
                        log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
                    }
                }
                client.close();
            }
            return map;
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        throw new UnsupportedOperationException("Fetching cluster properties not supported using the HttpClusterStateProvider. ZkClientClusterStateProvider can be used for this.");
    }

    @Override
    public Object getClusterProperty(String propertyName) {
        if (propertyName.equals("urlScheme")) {
            return this.urlScheme;
        }
        return this.getClusterProperties().get(propertyName);
    }

    @Override
    public void connect() {
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    @Override
    public String getQuorumHosts() {
        if (this.liveNodes == null) {
            return null;
        }
        return String.join((CharSequence)",", this.liveNodes);
    }

    private static enum ClusterStateRequestType {
        FETCH_LIVE_NODES,
        FETCH_CLUSTER_PROP,
        FETCH_NODE_ROLES,
        FETCH_COLLECTION,
        FETCH_CLUSTER_STATE;

    }

    private static class NotACollectionException
    extends Exception {
        private NotACollectionException() {
        }
    }
}

