/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.io.IOException;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.join.GraphEdgeCollector;

public class GraphPointsCollector
extends GraphEdgeCollector {
    final LongSet set = new LongHashSet(256);
    SortedNumericDocValues values = null;

    public GraphPointsCollector(SchemaField collectField, DocSet skipSet, DocSet leafNodes) {
        super(collectField, skipSet, leafNodes);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        this.values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.collectField.getName());
    }

    @Override
    void addEdgeIdsToResult(int doc) throws IOException {
        int valuesDoc = this.values.docID();
        if (valuesDoc < doc) {
            valuesDoc = this.values.advance(doc);
        }
        if (valuesDoc == doc) {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = this.values.nextValue();
                this.set.add(v);
            }
        }
    }

    @Override
    public Query getResultQuery(SchemaField matchField, boolean useAutomaton) {
        if (this.set.isEmpty()) {
            return null;
        }
        Query q = null;
        NumberType ntype = this.collectField.getType().getNumberType();
        boolean multiValued = this.collectField.multiValued();
        if (ntype == NumberType.LONG || ntype == NumberType.DATE) {
            long[] vals = new long[this.set.size()];
            int i = 0;
            for (LongCursor c : this.set) {
                vals[i++] = c.value;
            }
            q = LongPoint.newSetQuery((String)matchField.getName(), (long[])vals);
        } else if (ntype == NumberType.INTEGER) {
            int[] vals = new int[this.set.size()];
            int i = 0;
            for (LongCursor c : this.set) {
                vals[i++] = (int)c.value;
            }
            q = IntPoint.newSetQuery((String)matchField.getName(), (int[])vals);
        } else if (ntype == NumberType.DOUBLE) {
            double[] vals = new double[this.set.size()];
            int i = 0;
            for (LongCursor c : this.set) {
                long bits = c.value;
                double v = multiValued ? NumericUtils.sortableLongToDouble((long)bits) : Double.longBitsToDouble(bits);
                vals[i++] = v;
            }
            q = DoublePoint.newSetQuery((String)matchField.getName(), (double[])vals);
        } else if (ntype == NumberType.FLOAT) {
            float[] vals = new float[this.set.size()];
            int i = 0;
            for (LongCursor c : this.set) {
                long bits = c.value;
                float v = multiValued ? NumericUtils.sortableIntToFloat((int)((int)bits)) : Float.intBitsToFloat((int)bits);
                vals[i++] = v;
            }
            q = FloatPoint.newSetQuery((String)matchField.getName(), (float[])vals);
        }
        return q;
    }
}

