/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.JacksonJsonWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public final class QueryResponseWriterUtil {
    private QueryResponseWriterUtil() {
    }

    public static void writeQueryResponse(OutputStream outputStream, QueryResponseWriter responseWriter, SolrQueryRequest solrRequest, SolrQueryResponse solrResponse, String contentType) throws IOException {
        if (responseWriter instanceof JacksonJsonWriter) {
            JacksonJsonWriter binWriter = (JacksonJsonWriter)responseWriter;
            BufferedOutputStream bos = new BufferedOutputStream(new NonFlushingStream(outputStream));
            binWriter.write(bos, solrRequest, solrResponse);
            bos.flush();
        } else if (responseWriter instanceof BinaryQueryResponseWriter) {
            BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
            binWriter.write(outputStream, solrRequest, solrResponse);
        } else {
            NonFlushingStream out = new NonFlushingStream(outputStream);
            Writer writer = QueryResponseWriterUtil.buildWriter(out, ContentStreamBase.getCharsetFromContentType((String)contentType));
            responseWriter.write(writer, solrRequest, solrResponse);
            writer.flush();
        }
    }

    private static Writer buildWriter(OutputStream outputStream, String charset) throws UnsupportedEncodingException {
        OutputStreamWriter writer = charset == null ? new OutputStreamWriter(outputStream, StandardCharsets.UTF_8) : new OutputStreamWriter(outputStream, charset);
        return new FastWriter((Writer)writer);
    }

    private static class NonFlushingStream
    extends OutputStream {
        private final OutputStream outputStream;

        public NonFlushingStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }
    }
}

