/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.Constants;
import org.apache.solr.common.util.EnvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrProcessManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<Long, SolrProcess> pidProcessMap = ProcessHandle.allProcesses().filter(p -> p.info().command().orElse("").contains("java")).filter(p -> SolrProcessManager.commandLine(p).orElse("").contains("-Djetty.port=")).filter(p -> !enableTestingMode || SolrProcessManager.commandLine(p).orElse("").contains("-DmockSolr=true")).collect(Collectors.toUnmodifiableMap(ProcessHandle::pid, ph -> new SolrProcess(ph.pid(), this.parsePortFromProcess((ProcessHandle)ph).orElseThrow(), this.isProcessSsl((ProcessHandle)ph))));
    private final Map<Integer, SolrProcess> portProcessMap = this.pidProcessMap.values().stream().collect(Collectors.toUnmodifiableMap(p -> p.port, p -> p));
    private final Path pidDir;
    private static final Pattern pidFilePattern = Pattern.compile("^solr-([0-9]+)\\.(pid|port)$");
    public static boolean enableTestingMode = false;

    public SolrProcessManager() {
        String solrInstallDir = EnvUtils.getProperty((String)"solr.install.dir");
        this.pidDir = Paths.get(EnvUtils.getProperty((String)"solr.pid.dir", (String)(solrInstallDir != null ? solrInstallDir + "/bin" : System.getProperty("java.io.tmpdir"))), new String[0]);
    }

    public boolean isRunningWithPort(Integer port) {
        return this.portProcessMap.containsKey(port);
    }

    public boolean isRunningWithPid(Long pid) {
        return this.pidProcessMap.containsKey(pid);
    }

    public Optional<SolrProcess> processForPort(Integer port) {
        return this.portProcessMap.containsKey(port) ? Optional.of(this.portProcessMap.get(port)) : Optional.empty();
    }

    public Optional<SolrProcess> getProcessForPid(Long pid) {
        return this.pidProcessMap.containsKey(pid) ? Optional.of(this.pidProcessMap.get(pid)) : Optional.empty();
    }

    public Collection<SolrProcess> scanSolrPidFiles() throws IOException {
        ArrayList<SolrProcess> processes = new ArrayList<SolrProcess>();
        try (Stream<Path> pidFiles = Files.list(this.pidDir).filter(p -> pidFilePattern.matcher(p.getFileName().toString()).matches());){
            for (Path p2 : pidFiles.collect(Collectors.toList())) {
                Optional<SolrProcess> process;
                if (p2.toString().endsWith(".port")) {
                    Integer port = Integer.valueOf(Files.readAllLines(p2).get(0));
                    process = this.processForPort(port);
                } else {
                    Long pid = Long.valueOf(Files.readAllLines(p2).get(0));
                    process = this.getProcessForPid(pid);
                }
                if (process.isPresent()) {
                    processes.add(process.get());
                    continue;
                }
                log.warn("PID file {} found, but no process running. Deleting PID file", (Object)p2.getFileName());
                Files.deleteIfExists(p2);
            }
            ArrayList<SolrProcess> arrayList = processes;
            return arrayList;
        }
    }

    public Collection<SolrProcess> getAllRunning() {
        return this.pidProcessMap.values();
    }

    private Optional<Integer> parsePortFromProcess(ProcessHandle ph) {
        Optional<String> portStr = SolrProcessManager.arguments(ph).stream().filter(a -> a.contains("-Djetty.port=")).map(s -> s.split("=")[1]).findFirst();
        return portStr.isPresent() ? portStr.map(Integer::parseInt) : Optional.empty();
    }

    private boolean isProcessSsl(ProcessHandle ph) {
        return SolrProcessManager.arguments(ph).stream().anyMatch(arg -> List.of("--module=https", "--module=ssl", "--module=ssl-reload").contains(arg));
    }

    /*
     * Exception decompiling
     */
    private static Optional<String> commandLine(ProcessHandle ph) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> arguments(ProcessHandle ph) {
        if (!Constants.WINDOWS) {
            return Arrays.asList(ph.info().arguments().orElse(new String[0]));
        }
        return Arrays.asList(SolrProcessManager.commandLine(ph).orElse("").split("\\s+"));
    }

    public static class SolrProcess {
        private final long pid;
        private final int port;
        private final boolean isHttps;

        public SolrProcess(long pid, int port, boolean isHttps) {
            this.pid = pid;
            this.port = port;
            this.isHttps = isHttps;
        }

        public long getPid() {
            return this.pid;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isHttps() {
            return this.isHttps;
        }

        public String getLocalUrl() {
            return String.format(Locale.ROOT, "%s://localhost:%s/solr", this.isHttps ? "https" : "http", this.port);
        }
    }
}

