/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.EnumMap;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.util.resources.Errors;

public class Colors
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 256160285861027191L;
    public static final Colors DEFAULT = new Colors();
    public static final Colors NAMING;
    private EnumMap<ElementKind, X364> map;
    private boolean isImmutable;

    public Colors() {
        this.map = new EnumMap(ElementKind.class);
    }

    public Colors(Colors colors) {
        this.map = new EnumMap<ElementKind, X364>(colors.map);
    }

    public void setName(ElementKind elementKind, String string) throws IllegalArgumentException {
        if (this.isImmutable) {
            throw new UnsupportedOperationException(Errors.format((short)153, "Colors"));
        }
        if (string == null) {
            this.map.remove((Object)elementKind);
        } else {
            this.map.put(elementKind, X364.forColorName(string));
        }
    }

    public final String getName(ElementKind elementKind) {
        X364 x364 = this.map.get((Object)elementKind);
        return x364 != null ? x364.color : null;
    }

    final String getAnsiSequence(ElementKind elementKind) {
        X364 x364 = this.map.get((Object)elementKind);
        return x364 != null ? x364.sequence() : null;
    }

    final Colors immutable() {
        if (this.isImmutable) {
            return this;
        }
        Colors colors = this.clone();
        colors.isImmutable = true;
        return colors;
    }

    public Colors clone() {
        Colors colors;
        try {
            colors = (Colors)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        colors.map = colors.map.clone();
        colors.isImmutable = false;
        return colors;
    }

    public boolean equals(Object object) {
        if (object instanceof Colors) {
            Colors colors = (Colors)object;
            return this.map.equals((Object)colors.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode() ^ 0x3C4F1D77;
    }

    final Object readResolve() throws ObjectStreamException {
        return this.isImmutable && this.map.equals((Object)Colors.DEFAULT.map) ? DEFAULT : this;
    }

    static {
        EnumMap<ElementKind, X364> enumMap = Colors.DEFAULT.map;
        enumMap.put(ElementKind.NUMBER, X364.FOREGROUND_YELLOW);
        enumMap.put(ElementKind.INTEGER, X364.FOREGROUND_YELLOW);
        enumMap.put(ElementKind.UNIT, X364.FOREGROUND_YELLOW);
        enumMap.put(ElementKind.AXIS, X364.FOREGROUND_CYAN);
        enumMap.put(ElementKind.CODE_LIST, X364.FOREGROUND_CYAN);
        enumMap.put(ElementKind.PARAMETER, X364.FOREGROUND_GREEN);
        enumMap.put(ElementKind.METHOD, X364.FOREGROUND_GREEN);
        enumMap.put(ElementKind.DATUM, X364.FOREGROUND_GREEN);
        enumMap.put(ElementKind.IDENTIFIER, X364.FOREGROUND_RED);
        enumMap.put(ElementKind.SCOPE, X364.FOREGROUND_GRAY);
        enumMap.put(ElementKind.EXTENT, X364.FOREGROUND_GRAY);
        enumMap.put(ElementKind.CITATION, X364.FOREGROUND_GRAY);
        enumMap.put(ElementKind.REMARKS, X364.FOREGROUND_GRAY);
        enumMap.put(ElementKind.ERROR, X364.BACKGROUND_RED);
        Colors.DEFAULT.isImmutable = true;
        NAMING = new Colors();
        enumMap = Colors.NAMING.map;
        enumMap.put(ElementKind.NAME, X364.FOREGROUND_GREEN);
        enumMap.put(ElementKind.IDENTIFIER, X364.FOREGROUND_YELLOW);
        Colors.NAMING.isImmutable = true;
    }
}

