/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.CriticalHeaderParamsAware;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEDecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.AESKW;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.PBKDF2;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.PRFParams;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.PasswordBasedCryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StandardCharset;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PasswordBasedDecrypter
extends PasswordBasedCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public PasswordBasedDecrypter(byte[] password) {
        super(password);
    }

    public PasswordBasedDecrypter(String password) {
        super(password.getBytes(StandardCharset.UTF_8));
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        if (encryptedKey == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        if (header.getPBES2Salt() == null) {
            throw new JOSEException("Missing JWE p2s header parameter");
        }
        byte[] salt = header.getPBES2Salt().decode();
        if (header.getPBES2Count() < 1) {
            throw new JOSEException("Missing JWE p2c header parameter");
        }
        int iterationCount = header.getPBES2Count();
        this.critPolicy.ensureHeaderPasses(header);
        JWEAlgorithm alg = header.getAlgorithm();
        byte[] formattedSalt = PBKDF2.formatSalt(alg, salt);
        PRFParams prfParams = PRFParams.resolve(alg, this.getJCAContext().getMACProvider());
        SecretKey psKey = PBKDF2.deriveKey(this.getPassword(), formattedSalt, iterationCount, prfParams);
        SecretKey cek = AESKW.unwrapCEK(psKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        return ContentCryptoProvider.decrypt(header, encryptedKey, iv, cipherText, authTag, cek, this.getJCAContext());
    }
}

