/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.OperandHandlers;
import org.apache.calcite.sql.type.SqlOperandHandler;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBasicFunction
extends SqlFunction {
    private final SqlSyntax syntax;
    private final boolean deterministic;
    private final SqlOperandHandler operandHandler;
    private final int callValidator;
    private final Function<SqlOperatorBinding, SqlMonotonicity> monotonicityInference;
    private final boolean dynamic;

    private SqlBasicFunction(String name, SqlKind kind, SqlSyntax syntax, boolean deterministic, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, SqlOperandHandler operandHandler, SqlOperandTypeChecker operandTypeChecker, Integer callValidator, SqlFunctionCategory category, Function<SqlOperatorBinding, SqlMonotonicity> monotonicityInference, boolean dynamic) {
        super(name, kind, Objects.requireNonNull(returnTypeInference, "returnTypeInference"), operandTypeInference, Objects.requireNonNull(operandTypeChecker, "operandTypeChecker"), category);
        this.syntax = Objects.requireNonNull(syntax, "syntax");
        this.deterministic = deterministic;
        this.operandHandler = Objects.requireNonNull(operandHandler, "operandHandler");
        this.callValidator = Objects.requireNonNull(callValidator, "callValidator");
        this.monotonicityInference = Objects.requireNonNull(monotonicityInference, "monotonicityInference");
        this.dynamic = dynamic;
    }

    public static SqlBasicFunction create(SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlBasicFunction(kind.name(), kind, SqlSyntax.FUNCTION, true, returnTypeInference, null, OperandHandlers.DEFAULT, operandTypeChecker, 0, SqlFunctionCategory.SYSTEM, call -> SqlMonotonicity.NOT_MONOTONIC, false);
    }

    public static SqlBasicFunction create(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlBasicFunction(name, SqlKind.OTHER_FUNCTION, SqlSyntax.FUNCTION, true, returnTypeInference, null, OperandHandlers.DEFAULT, operandTypeChecker, 0, SqlFunctionCategory.NUMERIC, call -> SqlMonotonicity.NOT_MONOTONIC, false);
    }

    public static SqlBasicFunction create(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        return new SqlBasicFunction(name, SqlKind.OTHER_FUNCTION, SqlSyntax.FUNCTION, true, returnTypeInference, null, OperandHandlers.DEFAULT, operandTypeChecker, 0, category, call -> SqlMonotonicity.NOT_MONOTONIC, false);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return Objects.requireNonNull(super.getReturnTypeInference(), "returnTypeInference");
    }

    @Override
    public SqlOperandTypeChecker getOperandTypeChecker() {
        return Objects.requireNonNull(super.getOperandTypeChecker(), "operandTypeChecker");
    }

    @Override
    public SqlSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return this.monotonicityInference.apply(call);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        return this.operandHandler.rewriteCall(validator, call);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
    }

    @Override
    public boolean isDynamicFunction() {
        return this.dynamic;
    }

    public SqlBasicFunction withName(String name) {
        return new SqlBasicFunction(name, this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withKind(SqlKind kind) {
        return new SqlBasicFunction(this.getName(), kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withFunctionType(SqlFunctionCategory category) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, category, this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withSyntax(SqlSyntax syntax) {
        return new SqlBasicFunction(this.getName(), this.kind, syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withReturnTypeInference(SqlReturnTypeInference returnTypeInference) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, returnTypeInference, this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withOperandTypeInference(SqlOperandTypeInference operandTypeInference) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), operandTypeInference, this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withOperandHandler(SqlOperandHandler operandHandler) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withDeterministic(boolean deterministic) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withMonotonicityInference(Function<SqlOperatorBinding, SqlMonotonicity> monotonicityInference) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withValidation(int callValidator) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }

    public SqlBasicFunction withDynamic(boolean dynamic) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.callValidator, this.getFunctionType(), this.monotonicityInference, dynamic);
    }

    public SqlBasicFunction withOperandTypeChecker(SqlOperandTypeChecker operandTypeChecker) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, operandTypeChecker, this.callValidator, this.getFunctionType(), this.monotonicityInference, this.dynamic);
    }
}

