# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 82 "lib/parser/lexer-F0.rb"
class << self
	attr_accessor :_lex_actions
	private :_lex_actions, :_lex_actions=
end
self._lex_actions = [
	0, 1, 0, 1, 16, 1, 17, 1, 
	18, 1, 19, 1, 32, 1, 33, 1, 
	34, 1, 35, 1, 37, 1, 38, 1, 
	39, 1, 40, 1, 41, 1, 42, 1, 
	43, 1, 44, 1, 45, 1, 46, 1, 
	47, 1, 48, 1, 49, 1, 50, 1, 
	51, 1, 52, 1, 53, 1, 54, 1, 
	55, 1, 56, 1, 57, 1, 61, 1, 
	62, 1, 63, 1, 64, 1, 65, 1, 
	66, 1, 67, 1, 68, 1, 69, 1, 
	70, 1, 71, 1, 72, 1, 73, 1, 
	74, 1, 75, 1, 76, 1, 77, 1, 
	78, 1, 79, 1, 80, 1, 81, 1, 
	82, 1, 83, 1, 84, 1, 85, 1, 
	86, 1, 87, 1, 88, 1, 89, 1, 
	90, 1, 91, 1, 93, 1, 94, 1, 
	95, 1, 100, 1, 101, 1, 102, 1, 
	103, 1, 104, 1, 105, 1, 106, 1, 
	107, 1, 112, 1, 113, 1, 114, 1, 
	115, 1, 116, 1, 119, 1, 120, 1, 
	121, 1, 122, 1, 125, 1, 126, 1, 
	128, 1, 129, 1, 130, 1, 131, 1, 
	132, 1, 133, 1, 135, 1, 136, 1, 
	139, 1, 140, 1, 141, 1, 142, 1, 
	144, 1, 145, 1, 155, 1, 156, 1, 
	157, 1, 158, 1, 159, 1, 160, 1, 
	161, 1, 162, 1, 163, 1, 164, 1, 
	165, 1, 166, 1, 168, 1, 169, 1, 
	170, 1, 171, 1, 172, 1, 173, 1, 
	174, 1, 176, 1, 178, 1, 179, 1, 
	180, 1, 184, 1, 186, 1, 187, 1, 
	189, 1, 190, 1, 191, 1, 192, 1, 
	193, 1, 194, 1, 195, 1, 196, 1, 
	197, 1, 198, 1, 199, 1, 200, 1, 
	201, 1, 203, 1, 204, 1, 205, 1, 
	206, 1, 207, 1, 208, 1, 210, 1, 
	211, 1, 230, 1, 231, 1, 232, 1, 
	233, 1, 234, 1, 235, 1, 236, 1, 
	237, 1, 238, 1, 240, 1, 241, 1, 
	242, 1, 243, 1, 244, 1, 246, 1, 
	247, 1, 248, 1, 250, 1, 252, 1, 
	254, 1, 255, 1, 256, 1, 258, 1, 
	259, 1, 260, 1, 263, 1, 264, 1, 
	266, 1, 267, 1, 268, 1, 269, 1, 
	270, 1, 271, 1, 274, 1, 275, 1, 
	276, 1, 277, 1, 278, 1, 279, 1, 
	280, 1, 281, 1, 282, 1, 283, 1, 
	286, 1, 287, 1, 288, 1, 289, 1, 
	290, 1, 291, 1, 292, 1, 293, 1, 
	294, 1, 295, 1, 296, 2, 0, 18, 
	2, 0, 100, 2, 0, 104, 2, 0, 
	105, 2, 0, 167, 2, 0, 169, 2, 
	0, 239, 2, 0, 284, 2, 0, 285, 
	2, 0, 288, 2, 0, 289, 2, 2, 
	249, 2, 3, 249, 2, 4, 249, 2, 
	5, 249, 2, 6, 249, 2, 7, 249, 
	2, 9, 251, 2, 10, 251, 2, 11, 
	251, 2, 12, 251, 2, 13, 251, 2, 
	14, 111, 2, 14, 134, 2, 14, 181, 
	2, 14, 245, 2, 15, 261, 2, 16, 
	0, 2, 16, 32, 2, 16, 33, 2, 
	16, 34, 2, 16, 75, 2, 16, 84, 
	2, 16, 94, 2, 16, 105, 2, 16, 
	116, 2, 16, 118, 2, 16, 135, 2, 
	16, 142, 2, 16, 143, 2, 16, 155, 
	2, 16, 168, 2, 16, 190, 2, 16, 
	201, 2, 16, 202, 2, 16, 208, 2, 
	16, 209, 2, 16, 264, 2, 16, 265, 
	2, 16, 292, 2, 17, 18, 2, 18, 
	0, 2, 18, 75, 2, 18, 84, 2, 
	18, 94, 2, 18, 117, 2, 18, 135, 
	2, 18, 142, 2, 18, 190, 2, 18, 
	201, 2, 18, 208, 2, 18, 264, 2, 
	18, 292, 2, 19, 92, 2, 19, 177, 
	2, 19, 188, 2, 19, 271, 2, 20, 
	92, 2, 20, 177, 2, 20, 188, 2, 
	20, 257, 2, 21, 177, 2, 21, 188, 
	2, 22, 177, 2, 22, 188, 2, 23, 
	177, 2, 23, 188, 2, 24, 177, 2, 
	24, 198, 2, 25, 177, 2, 25, 188, 
	2, 26, 177, 2, 27, 253, 2, 28, 
	110, 2, 28, 182, 2, 28, 262, 2, 
	29, 261, 2, 30, 108, 2, 30, 109, 
	2, 30, 127, 2, 30, 183, 2, 30, 
	260, 2, 31, 261, 2, 35, 0, 2, 
	36, 175, 2, 37, 179, 2, 38, 179, 
	2, 39, 185, 2, 41, 47, 2, 42, 
	47, 2, 43, 47, 2, 44, 47, 2, 
	45, 47, 2, 46, 47, 2, 47, 1, 
	2, 53, 0, 2, 53, 49, 2, 53, 
	58, 2, 53, 59, 2, 53, 60, 2, 
	53, 96, 2, 53, 97, 2, 53, 98, 
	2, 53, 99, 2, 53, 123, 2, 53, 
	124, 2, 53, 137, 2, 53, 138, 2, 
	53, 147, 2, 53, 148, 2, 53, 149, 
	2, 53, 150, 2, 53, 151, 2, 53, 
	152, 2, 53, 153, 2, 53, 154, 2, 
	53, 212, 2, 53, 213, 2, 53, 215, 
	2, 53, 216, 2, 53, 217, 2, 53, 
	218, 2, 53, 219, 2, 53, 220, 2, 
	53, 221, 2, 53, 223, 2, 53, 224, 
	2, 53, 225, 2, 53, 226, 2, 53, 
	227, 2, 53, 228, 2, 53, 229, 2, 
	53, 272, 2, 53, 273, 3, 17, 18, 
	0, 3, 17, 18, 75, 3, 17, 18, 
	84, 3, 17, 18, 94, 3, 17, 18, 
	117, 3, 17, 18, 135, 3, 17, 18, 
	142, 3, 17, 18, 190, 3, 17, 18, 
	201, 3, 17, 18, 208, 3, 17, 18, 
	264, 3, 17, 18, 292, 3, 45, 47, 
	1, 3, 46, 47, 1, 3, 47, 1, 
	249, 3, 48, 8, 251, 3, 49, 8, 
	251, 3, 53, 0, 99, 3, 53, 16, 
	98, 3, 53, 16, 124, 3, 53, 16, 
	272, 3, 53, 18, 146, 3, 53, 18, 
	214, 3, 53, 18, 272, 3, 53, 33, 
	97, 3, 53, 39, 152, 3, 53, 39, 
	153, 3, 53, 45, 221, 4, 41, 47, 
	1, 249, 4, 42, 47, 1, 249, 4, 
	43, 47, 1, 249, 4, 44, 47, 1, 
	249, 4, 45, 47, 1, 249, 4, 46, 
	47, 1, 249, 4, 53, 16, 33, 97, 
	4, 53, 17, 18, 146, 4, 53, 17, 
	18, 272, 4, 53, 47, 1, 222, 5, 
	53, 45, 47, 1, 222, 5, 53, 46, 
	47, 1, 222
]

class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 46, 46, 
	58, 58, 58, 58, 0, 127, 
	60, 60, 62, 62, 0, 
	127, 58, 58, 10, 10, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 
	101, 108, 116, 101, 101, 
	115, 115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 
	108, 0, 127, 58, 58, 
	10, 10, 0, 127, 98, 98, 
	101, 101, 103, 103, 105, 
	105, 110, 110, 0, 127, 
	61, 61, 9, 92, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 10, 10, 0, 127, 
	0, 127, 61, 126, 93, 93, 
	0, 127, 34, 34, 10, 
	10, 10, 10, 39, 39, 
	0, 127, 0, 127, 10, 96, 
	96, 96, 58, 58, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 9, 92, 
	10, 10, 9, 92, 58, 
	58, 58, 58, 0, 127, 
	0, 127, 43, 57, 48, 57, 
	48, 57, 48, 57, 48, 
	57, 115, 115, 99, 99, 
	117, 117, 101, 101, 99, 99, 
	117, 117, 101, 101, 0, 
	127, 58, 58, 9, 92, 
	9, 92, 9, 92, 9, 92, 
	9, 92, 9, 92, 60, 
	60, 10, 10, 9, 92, 
	9, 92, 10, 10, 10, 10, 
	10, 10, 10, 10, 46, 
	46, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 69, 
	78, 78, 68, 68, 95, 
	95, 95, 95, 0, 26, 
	0, 0, 36, 64, 48, 57, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 10, 
	10, 10, 0, 127, 48, 
	57, 0, 127, 115, 115, 
	38, 38, 42, 42, 64, 64, 
	58, 58, 60, 61, 62, 
	62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	93, 93, 10, 10, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 124, 124, 0, 127, 
	9, 32, 10, 10, 10, 10, 
	46, 46, 0, 127, 10, 
	10, 0, 0, 0, 127, 
	9, 32, 0, 0, 61, 126, 
	10, 10, 10, 10, 38, 
	38, 42, 42, 64, 64, 
	60, 61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 
	127, 61, 61, 0, 0, 
	93, 93, 10, 10, 0, 127, 
	124, 124, 0, 126, 0, 
	127, 0, 61, 9, 61, 
	9, 61, 0, 0, 9, 61, 
	9, 62, 46, 46, 46, 
	46, 58, 58, 9, 32, 
	0, 0, 0, 127, 0, 0, 
	9, 124, 0, 0, 10, 
	10, 10, 10, 0, 0, 
	9, 61, 58, 58, 60, 60, 
	62, 62, 9, 32, 10, 
	10, 0, 127, 102, 102, 
	101, 101, 110, 110, 104, 104, 
	0, 127, 0, 127, 0, 
	0, 0, 127, 0, 127, 
	10, 10, 0, 123, 9, 32, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 111, 111, 
	0, 0, 0, 127, 9, 32, 
	0, 0, 10, 10, 10, 
	10, 0, 127, 10, 10, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 9, 32, 
	61, 61, 9, 32, 61, 
	126, 10, 10, 10, 10, 
	0, 127, 38, 61, 0, 0, 
	42, 61, 61, 61, 9, 
	92, 9, 92, 9, 92, 
	46, 46, 46, 46, 10, 10, 
	0, 26, 0, 127, 61, 
	126, 48, 57, 0, 127, 
	38, 38, 42, 42, 64, 64, 
	60, 61, 62, 62, 61, 
	61, 61, 62, 0, 127, 
	48, 57, 0, 127, 0, 127, 
	61, 61, 0, 0, 61, 
	126, 61, 62, 0, 0, 
	0, 0, 0, 0, 0, 0, 
	124, 124, 64, 64, 60, 
	61, 10, 34, 0, 0, 
	10, 39, 96, 96, 62, 62, 
	61, 126, 61, 62, 0, 
	26, 0, 127, 58, 61, 
	0, 0, 61, 126, 61, 61, 
	0, 0, 0, 0, 0, 
	0, 0, 127, 0, 127, 
	0, 0, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 61, 126, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 0, 61, 124, 0, 
	92, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 10, 
	0, 0, 0, 127, 9, 
	32, 0, 0, 10, 10, 
	10, 10, 0, 127, 10, 10, 
	0, 0, 0, 127, 9, 
	32, 0, 0, 61, 126, 
	10, 10, 10, 10, 0, 127, 
	48, 57, 0, 127, 61, 
	61, 38, 61, 0, 0, 
	0, 0, 42, 61, 61, 62, 
	46, 57, 46, 46, 10, 
	10, 48, 101, 48, 95, 
	46, 120, 48, 114, 43, 57, 
	48, 105, 102, 102, 0, 
	0, 101, 105, 0, 0, 
	0, 0, 48, 114, 48, 114, 
	48, 114, 48, 114, 105, 
	114, 102, 102, 0, 0, 
	101, 105, 115, 115, 0, 0, 
	0, 0, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 114, 
	48, 114, 46, 114, 48, 
	114, 46, 114, 48, 114, 
	58, 58, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 
	62, 0, 127, 0, 127, 
	61, 61, 0, 0, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 0, 10, 10, 
	0, 0, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	9, 92, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	0, 61, 124, 0, 0, 
	9, 92, 9, 92, 9, 92, 
	46, 46, 46, 46, 10, 
	10, 46, 46, 10, 10, 
	10, 61, 10, 10, 10, 101, 
	10, 110, 10, 100, 10, 
	10, 0, 95, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	98, 98, 9, 32, 10, 
	10, 95, 95, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 128, 1, 1, 128, 1, 1, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 1, 1, 1, 1, 9, 1, 
	1, 1, 1, 1, 1, 1, 128, 1, 
	1, 128, 1, 1, 1, 1, 1, 128, 
	1, 84, 84, 84, 84, 84, 1, 128, 
	128, 66, 1, 128, 1, 1, 1, 1, 
	128, 128, 87, 1, 1, 128, 128, 128, 
	128, 128, 84, 1, 84, 1, 1, 128, 
	128, 15, 10, 10, 10, 10, 1, 1, 
	1, 1, 1, 1, 1, 128, 1, 84, 
	84, 84, 84, 84, 84, 1, 1, 84, 
	84, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 27, 
	0, 29, 10, 128, 128, 128, 128, 24, 
	0, 66, 1, 1, 128, 10, 128, 1, 
	1, 1, 1, 1, 2, 1, 66, 1, 
	2, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 1, 128, 
	24, 1, 1, 1, 128, 1, 0, 128, 
	24, 0, 66, 1, 1, 1, 1, 1, 
	2, 1, 66, 1, 2, 128, 1, 0, 
	1, 1, 128, 1, 127, 128, 62, 53, 
	53, 0, 53, 54, 1, 1, 1, 24, 
	0, 128, 0, 116, 0, 1, 1, 0, 
	53, 1, 1, 1, 24, 1, 128, 1, 
	1, 1, 1, 128, 128, 0, 128, 128, 
	1, 124, 24, 1, 1, 1, 0, 1, 
	0, 128, 24, 0, 1, 1, 128, 1, 
	0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 24, 1, 24, 66, 1, 1, 
	128, 24, 0, 20, 1, 84, 84, 84, 
	1, 1, 1, 27, 128, 66, 10, 128, 
	1, 1, 1, 2, 1, 1, 2, 128, 
	10, 128, 128, 1, 0, 66, 2, 0, 
	0, 0, 0, 1, 1, 2, 25, 0, 
	30, 1, 1, 66, 2, 27, 128, 4, 
	0, 66, 1, 0, 0, 0, 128, 128, 
	0, 1, 0, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 66, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 0, 64, 93, 24, 0, 
	1, 1, 1, 0, 128, 24, 0, 1, 
	1, 128, 1, 0, 128, 24, 0, 66, 
	1, 1, 128, 10, 128, 1, 24, 0, 
	0, 20, 2, 12, 1, 1, 54, 48, 
	75, 67, 15, 58, 1, 0, 5, 0, 
	0, 67, 67, 67, 67, 10, 1, 0, 
	5, 1, 0, 0, 67, 67, 67, 67, 
	67, 67, 67, 67, 69, 67, 69, 67, 
	1, 2, 1, 66, 1, 2, 128, 128, 
	1, 0, 0, 128, 128, 128, 128, 128, 
	128, 0, 1, 0, 0, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 84, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 0, 64, 0, 
	84, 84, 84, 1, 1, 1, 1, 1, 
	52, 1, 92, 101, 91, 1, 96, 24, 
	0, 1, 1, 1, 24, 1, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 129, 258, 387, 516, 645, 774, 
	776, 778, 780, 909, 911, 913, 1042, 1044, 
	1046, 1175, 1304, 1433, 1562, 1691, 1820, 1949, 
	2078, 2207, 2336, 2465, 2594, 2723, 2852, 2981, 
	3110, 3239, 3368, 3370, 3372, 3374, 3376, 3386, 
	3388, 3390, 3392, 3394, 3396, 3398, 3400, 3529, 
	3531, 3533, 3662, 3664, 3666, 3668, 3670, 3672, 
	3801, 3803, 3888, 3973, 4058, 4143, 4228, 4230, 
	4359, 4488, 4555, 4557, 4686, 4688, 4690, 4692, 
	4694, 4823, 4952, 5040, 5042, 5044, 5173, 5302, 
	5431, 5560, 5689, 5774, 5776, 5861, 5863, 5865, 
	5994, 6123, 6139, 6150, 6161, 6172, 6183, 6185, 
	6187, 6189, 6191, 6193, 6195, 6197, 6326, 6328, 
	6413, 6498, 6583, 6668, 6753, 6838, 6840, 6842, 
	6927, 7012, 7014, 7016, 7018, 7020, 7022, 7024, 
	7026, 7028, 7030, 7032, 7034, 7036, 7038, 7040, 
	7068, 7069, 7099, 7110, 7239, 7368, 7497, 7626, 
	7651, 7652, 7719, 7721, 7723, 7852, 7863, 7992, 
	7994, 7996, 7998, 8000, 8002, 8005, 8007, 8074, 
	8076, 8079, 8208, 8337, 8466, 8595, 8724, 8853, 
	8982, 8984, 8986, 9115, 9244, 9373, 9502, 9631, 
	9760, 9889, 10018, 10147, 10276, 10405, 10534, 10663, 
	10792, 10921, 11050, 11179, 11308, 11437, 11566, 11695, 
	11824, 11953, 12082, 12211, 12340, 12469, 12598, 12727, 
	12856, 12985, 13114, 13243, 13372, 13501, 13630, 13759, 
	13888, 14017, 14146, 14275, 14404, 14533, 14662, 14791, 
	14920, 15049, 15178, 15307, 15436, 15565, 15694, 15823, 
	15952, 16081, 16210, 16339, 16468, 16597, 16726, 16855, 
	16984, 17113, 17242, 17371, 17500, 17629, 17758, 17887, 
	18016, 18145, 18274, 18403, 18532, 18661, 18790, 18919, 
	19048, 19177, 19306, 19435, 19564, 19693, 19822, 19824, 
	19953, 19978, 19980, 19982, 19984, 20113, 20115, 20116, 
	20245, 20270, 20271, 20338, 20340, 20342, 20344, 20346, 
	20348, 20351, 20353, 20420, 20422, 20425, 20554, 20556, 
	20557, 20559, 20561, 20690, 20692, 20820, 20949, 21012, 
	21066, 21120, 21121, 21175, 21230, 21232, 21234, 21236, 
	21261, 21262, 21391, 21392, 21509, 21510, 21512, 21514, 
	21515, 21569, 21571, 21573, 21575, 21600, 21602, 21731, 
	21733, 21735, 21737, 21739, 21868, 21997, 21998, 22127, 
	22256, 22258, 22383, 22408, 22410, 22412, 22414, 22415, 
	22417, 22418, 22547, 22572, 22573, 22575, 22577, 22706, 
	22708, 22709, 22838, 22967, 23096, 23225, 23354, 23483, 
	23612, 23741, 23870, 23999, 24128, 24257, 24386, 24515, 
	24644, 24773, 24902, 24927, 24929, 24954, 25021, 25023, 
	25025, 25154, 25179, 25180, 25201, 25203, 25288, 25373, 
	25458, 25460, 25462, 25464, 25492, 25621, 25688, 25699, 
	25828, 25830, 25832, 25834, 25837, 25839, 25841, 25844, 
	25973, 25984, 26113, 26242, 26244, 26245, 26312, 26315, 
	26316, 26317, 26318, 26319, 26321, 26323, 26326, 26352, 
	26353, 26384, 26386, 26388, 26455, 26458, 26486, 26615, 
	26620, 26621, 26688, 26690, 26691, 26692, 26693, 26822, 
	26951, 26952, 26954, 26955, 27084, 27213, 27342, 27471, 
	27600, 27729, 27858, 27987, 28116, 28245, 28374, 28503, 
	28632, 28761, 28890, 29019, 29148, 29277, 29406, 29535, 
	29664, 29793, 29922, 30051, 30180, 30309, 30438, 30567, 
	30696, 30825, 30954, 31083, 31212, 31341, 31470, 31599, 
	31728, 31857, 31986, 32115, 32244, 32373, 32502, 32631, 
	32760, 32889, 33018, 33147, 33276, 33405, 33534, 33663, 
	33792, 33921, 34050, 34179, 34308, 34437, 34566, 34695, 
	34824, 34953, 35020, 35149, 35278, 35407, 35536, 35665, 
	35794, 35923, 36052, 36181, 36310, 36439, 36568, 36697, 
	36826, 36955, 37084, 37213, 37342, 37471, 37600, 37729, 
	37858, 37987, 38116, 38245, 38246, 38311, 38405, 38430, 
	38431, 38433, 38435, 38437, 38438, 38567, 38592, 38593, 
	38595, 38597, 38726, 38728, 38729, 38858, 38883, 38884, 
	38951, 38953, 38955, 39084, 39095, 39224, 39226, 39251, 
	39252, 39253, 39274, 39277, 39290, 39292, 39294, 39349, 
	39398, 39474, 39542, 39558, 39617, 39619, 39620, 39626, 
	39627, 39628, 39696, 39764, 39832, 39900, 39911, 39913, 
	39914, 39920, 39922, 39923, 39924, 39992, 40060, 40128, 
	40196, 40264, 40332, 40400, 40468, 40538, 40606, 40676, 
	40744, 40746, 40749, 40751, 40818, 40820, 40823, 40952, 
	41081, 41083, 41084, 41085, 41214, 41343, 41472, 41601, 
	41730, 41859, 41860, 41862, 41863, 41864, 41993, 42122, 
	42251, 42380, 42509, 42638, 42767, 42896, 43025, 43154, 
	43283, 43412, 43541, 43670, 43799, 43928, 44057, 44186, 
	44315, 44444, 44573, 44702, 44831, 44960, 45089, 45218, 
	45347, 45476, 45605, 45734, 45863, 45992, 46121, 46250, 
	46379, 46508, 46637, 46766, 46851, 46980, 47109, 47238, 
	47367, 47496, 47625, 47754, 47883, 48012, 48141, 48270, 
	48399, 48528, 48657, 48786, 48915, 49044, 49173, 49302, 
	49431, 49560, 49689, 49818, 49947, 50076, 50205, 50334, 
	50463, 50592, 50721, 50850, 50979, 51108, 51237, 51366, 
	51495, 51624, 51753, 51882, 52011, 52140, 52269, 52398, 
	52527, 52656, 52785, 52914, 53043, 53172, 53301, 53430, 
	53559, 53688, 53817, 53946, 54075, 54204, 54333, 54462, 
	54591, 54720, 54849, 54978, 55107, 55236, 55237, 55302, 
	55303, 55388, 55473, 55558, 55560, 55562, 55564, 55566, 
	55568, 55621, 55623, 55716, 55818, 55910, 55912, 56009, 
	56034, 56035, 56037, 56039, 56041, 56066, 56068
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 0, 0, 1, 0, 1, 0, 0, 
	1, 1, 0, 0, 0, 2, 0, 0, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 0, 0, 0, 0, 0, 0, 
	0, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 1, 0, 1, 1, 4, 
	0, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 1, 1, 1, 0, 1, 
	4, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 1, 1, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 1, 1, 
	1, 0, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 1, 1, 1, 1, 
	1, 1, 6, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 1, 1, 1, 
	1, 5, 1, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 1, 1, 1, 
	1, 1, 5, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 1, 1, 1, 
	1, 1, 1, 1, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 1, 1, 
	1, 1, 7, 1, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 1, 1, 
	1, 1, 1, 7, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 8, 8, 
	8, 8, 8, 8, 8, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 8, 
	8, 8, 8, 9, 8, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 8, 
	8, 8, 8, 8, 9, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 11, 
	11, 11, 11, 11, 11, 11, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	11, 11, 11, 11, 11, 11, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	11, 11, 11, 11, 11, 10, 13, 12, 
	14, 12, 12, 15, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 16, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 14, 12, 
	12, 12, 12, 16, 12, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 12, 
	12, 12, 12, 17, 12, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 12, 
	12, 12, 12, 12, 17, 19, 18, 20, 
	18, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 22, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 24, 21, 21, 21, 21, 
	22, 21, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 21, 21, 21, 21, 
	23, 21, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 21, 21, 21, 21, 
	21, 23, 24, 21, 25, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 26, 
	18, 26, 26, 26, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 26, 18, 
	18, 18, 18, 27, 28, 18, 29, 18, 
	30, 31, 32, 33, 34, 27, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	35, 18, 36, 32, 37, 38, 18, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 40, 41, 32, 42, 39, 18, 39, 
	39, 39, 39, 39, 39, 39, 39, 43, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	44, 39, 39, 45, 39, 46, 39, 39, 
	39, 47, 48, 18, 42, 18, 39, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	49, 18, 49, 49, 49, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 49, 
	18, 18, 18, 18, 50, 51, 18, 52, 
	18, 53, 54, 55, 56, 57, 50, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 58, 18, 59, 55, 60, 61, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 62, 63, 55, 20, 23, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	64, 23, 23, 23, 23, 23, 23, 23, 
	23, 65, 23, 23, 66, 23, 67, 23, 
	23, 23, 68, 69, 18, 20, 18, 23, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 22, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 24, 18, 18, 18, 18, 22, 
	18, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 18, 18, 18, 18, 23, 
	18, 23, 23, 23, 23, 23, 70, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 18, 18, 18, 18, 18, 
	23, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 22, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 24, 18, 18, 18, 18, 
	22, 18, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 18, 18, 18, 18, 
	23, 18, 23, 23, 23, 23, 71, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 18, 18, 18, 18, 
	18, 23, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 22, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 24, 18, 18, 18, 
	18, 22, 18, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 18, 18, 18, 
	18, 23, 18, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 72, 23, 23, 
	23, 23, 23, 23, 23, 18, 18, 18, 
	18, 18, 23, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 22, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 24, 18, 18, 
	18, 18, 22, 18, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 18, 18, 
	18, 18, 23, 18, 23, 23, 73, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 18, 18, 
	18, 18, 18, 23, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 22, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 24, 18, 
	18, 18, 18, 22, 18, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 18, 
	18, 18, 18, 23, 18, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 74, 23, 23, 23, 23, 23, 18, 
	18, 18, 18, 18, 23, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 22, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 24, 
	18, 18, 18, 18, 22, 18, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	18, 18, 18, 18, 23, 18, 23, 23, 
	23, 23, 70, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	18, 18, 18, 18, 18, 23, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 22, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	24, 18, 18, 18, 18, 22, 18, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 18, 18, 18, 18, 23, 18, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 75, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 18, 18, 18, 18, 18, 23, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	22, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 24, 18, 18, 18, 18, 22, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 18, 18, 18, 18, 23, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 76, 23, 23, 23, 23, 
	23, 23, 23, 77, 23, 23, 23, 23, 
	23, 23, 18, 18, 18, 18, 18, 23, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 22, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 24, 18, 18, 18, 18, 22, 
	18, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 18, 18, 18, 18, 23, 
	18, 23, 23, 23, 23, 78, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 18, 18, 18, 18, 18, 
	23, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 22, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 24, 18, 18, 18, 18, 
	22, 18, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 18, 18, 18, 18, 
	23, 18, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 79, 23, 23, 23, 
	23, 23, 23, 23, 18, 18, 18, 18, 
	18, 23, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 22, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 24, 18, 18, 18, 
	18, 22, 18, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 18, 18, 18, 
	18, 23, 18, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 70, 23, 23, 
	23, 23, 23, 23, 23, 18, 18, 18, 
	18, 18, 23, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 22, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 24, 18, 18, 
	18, 18, 22, 18, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 18, 18, 
	18, 18, 23, 18, 23, 23, 23, 23, 
	23, 23, 23, 23, 80, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 18, 18, 
	18, 18, 18, 23, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 22, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 24, 18, 
	18, 18, 18, 22, 18, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 18, 
	18, 18, 18, 23, 18, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	70, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 18, 
	18, 18, 18, 18, 23, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 22, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 24, 
	18, 18, 18, 18, 22, 18, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	18, 18, 18, 18, 23, 18, 23, 23, 
	23, 23, 23, 23, 23, 81, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	18, 18, 18, 18, 18, 23, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 22, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	24, 18, 18, 18, 18, 22, 18, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 18, 18, 18, 18, 23, 18, 23, 
	23, 23, 23, 23, 23, 23, 23, 82, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 18, 18, 18, 18, 18, 23, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	22, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 24, 18, 18, 18, 18, 22, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 18, 18, 18, 18, 23, 18, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 74, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 18, 18, 18, 18, 18, 23, 
	84, 83, 85, 83, 86, 83, 55, 83, 
	87, 83, 83, 83, 83, 83, 83, 83, 
	88, 83, 89, 83, 90, 83, 55, 83, 
	91, 83, 55, 83, 92, 83, 86, 83, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 94, 93, 94, 94, 94, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	94, 93, 93, 93, 93, 93, 93, 93, 
	95, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 93, 97, 93, 93, 96, 
	93, 96, 96, 96, 98, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 93, 93, 93, 93, 93, 
	96, 100, 99, 101, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 102, 93, 
	102, 102, 102, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 102, 93, 93, 
	93, 93, 93, 93, 93, 103, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	93, 105, 93, 93, 104, 93, 104, 104, 
	104, 106, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	93, 93, 93, 93, 93, 104, 108, 107, 
	109, 107, 110, 107, 111, 107, 112, 107, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 114, 114, 114, 114, 114, 114, 
	114, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 114, 114, 114, 114, 114, 
	114, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 114, 114, 114, 114, 114, 
	113, 116, 115, 117, 118, 117, 117, 117, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 117, 115, 115, 119, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 121, 115, 
	122, 123, 122, 122, 122, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 122, 
	115, 115, 124, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 125, 
	125, 125, 125, 125, 125, 125, 125, 125, 
	125, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 126, 115, 128, 129, 128, 
	128, 128, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 128, 127, 127, 130, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 131, 131, 131, 131, 
	131, 131, 131, 131, 131, 131, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	132, 127, 134, 135, 134, 134, 134, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 134, 133, 133, 136, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 137, 137, 137, 137, 137, 137, 137, 
	137, 137, 137, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 138, 133, 134, 
	139, 134, 134, 134, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 134, 133, 
	133, 136, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 138, 133, 118, 115, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 141, 
	141, 140, 141, 140, 141, 141, 140, 140, 
	141, 141, 141, 142, 141, 141, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	141, 141, 141, 141, 141, 141, 141, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 140, 141, 140, 140, 144, 141, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 140, 140, 140, 141, 140, 144, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 140, 140, 140, 140, 140, 140, 140, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 140, 140, 140, 140, 141, 140, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 140, 140, 140, 140, 140, 141, 
	145, 141, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 141, 140, 145, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 146, 
	140, 140, 140, 140, 147, 140, 140, 140, 
	140, 140, 148, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 116, 140, 140, 140, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	140, 140, 140, 140, 149, 150, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	140, 140, 140, 148, 140, 149, 153, 152, 
	155, 154, 157, 156, 153, 158, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	146, 140, 140, 140, 140, 147, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 140, 140, 140, 140, 149, 150, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 140, 140, 140, 140, 140, 149, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 155, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 154, 154, 154, 154, 154, 154, 154, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 154, 154, 154, 154, 159, 154, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 154, 154, 154, 154, 154, 159, 
	161, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 153, 160, 
	153, 161, 115, 162, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 163, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 165, 115, 
	115, 166, 115, 163, 115, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 115, 
	115, 115, 115, 164, 115, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 115, 
	115, 115, 115, 115, 164, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 163, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 165, 
	140, 140, 166, 140, 163, 140, 164, 164, 
	164, 164, 164, 164, 167, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	140, 140, 140, 140, 164, 140, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	140, 140, 140, 140, 140, 164, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 163, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	165, 140, 140, 166, 140, 163, 140, 164, 
	164, 164, 164, 164, 164, 164, 164, 168, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 140, 140, 140, 140, 164, 140, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 140, 140, 140, 140, 140, 164, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	163, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 165, 140, 140, 166, 140, 163, 140, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 169, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 140, 140, 140, 140, 164, 140, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 140, 140, 140, 140, 140, 164, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 163, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 165, 140, 140, 166, 140, 163, 
	140, 164, 164, 164, 169, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 140, 140, 140, 140, 164, 
	140, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 140, 140, 140, 140, 140, 
	164, 171, 170, 171, 171, 171, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	171, 170, 170, 170, 170, 170, 170, 170, 
	172, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 173, 170, 174, 170, 
	175, 170, 175, 175, 175, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 175, 
	170, 170, 170, 170, 170, 170, 170, 176, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 177, 170, 179, 178, 178, 
	180, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 181, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 179, 178, 178, 178, 178, 
	181, 178, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 178, 178, 178, 178, 
	182, 178, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 178, 178, 178, 178, 
	178, 182, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 183, 183, 183, 183, 
	183, 183, 183, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 183, 183, 183, 
	183, 184, 183, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 183, 183, 183, 
	183, 183, 184, 186, 185, 186, 185, 185, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 185, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 185, 188, 188, 
	188, 188, 188, 188, 188, 188, 188, 188, 
	185, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 189, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 189, 193, 
	192, 194, 192, 195, 192, 196, 192, 198, 
	197, 199, 197, 200, 197, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 183, 
	183, 183, 183, 183, 183, 183, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	183, 183, 183, 183, 201, 183, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	183, 183, 183, 183, 183, 201, 202, 189, 
	203, 204, 203, 203, 203, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 203, 
	189, 189, 205, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 206, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 207, 189, 208, 209, 208, 
	208, 208, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 208, 189, 189, 210, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	211, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	212, 189, 214, 215, 214, 214, 214, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 214, 213, 213, 216, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 217, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 218, 213, 220, 
	221, 220, 220, 220, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 220, 219, 
	219, 222, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 223, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 224, 219, 220, 221, 220, 220, 
	220, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 220, 219, 219, 222, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 225, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 224, 
	219, 220, 226, 220, 220, 220, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	220, 219, 219, 222, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 223, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 224, 219, 227, 189, 
	204, 189, 229, 230, 229, 229, 229, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 229, 228, 228, 231, 228, 228, 232, 
	228, 228, 228, 228, 228, 228, 228, 233, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 234, 228, 236, 
	230, 236, 236, 236, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 236, 235, 
	235, 231, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 234, 235, 239, 238, 241, 240, 
	242, 237, 243, 237, 244, 228, 246, 245, 
	247, 245, 248, 245, 249, 245, 250, 245, 
	251, 245, 252, 245, 253, 245, 254, 245, 
	255, 245, 245, 245, 255, 245, 245, 245, 
	245, 245, 256, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 255, 245, 257, 258, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 259, 1, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	260, 260, 260, 260, 260, 260, 260, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 260, 260, 260, 260, 4, 260, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 260, 260, 260, 260, 260, 4, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 261, 261, 261, 261, 261, 261, 261, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 261, 261, 261, 261, 5, 261, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 261, 261, 261, 261, 261, 5, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 262, 262, 262, 262, 262, 262, 
	262, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 262, 262, 262, 262, 7, 
	262, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 262, 262, 262, 262, 262, 
	7, 263, 264, 264, 264, 263, 264, 264, 
	264, 264, 265, 266, 265, 265, 265, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 263, 264, 264, 264, 264, 
	264, 265, 267, 264, 268, 269, 270, 271, 
	264, 264, 264, 272, 273, 264, 273, 264, 
	274, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 275, 264, 276, 277, 278, 
	264, 264, 279, 280, 279, 279, 281, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 282, 283, 264, 274, 
	284, 274, 285, 286, 287, 288, 289, 290, 
	291, 291, 292, 291, 291, 291, 293, 294, 
	295, 291, 291, 296, 297, 298, 299, 291, 
	300, 291, 301, 291, 264, 302, 264, 273, 
	264, 291, 265, 303, 265, 265, 265, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 265, 303, 304, 274, 305, 305, 274, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 305, 305, 305, 274, 305, 306, 
	307, 308, 309, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 9, 9, 310, 9, 
	310, 9, 9, 310, 310, 9, 9, 9, 
	311, 9, 9, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 9, 9, 9, 
	9, 9, 9, 9, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 310, 9, 
	310, 310, 313, 9, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 310, 310, 
	310, 9, 310, 313, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 314, 314, 314, 314, 314, 314, 314, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 314, 314, 314, 314, 313, 314, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 314, 314, 314, 314, 314, 313, 
	315, 305, 274, 305, 274, 305, 274, 305, 
	317, 316, 274, 318, 305, 274, 305, 319, 
	274, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	310, 310, 310, 310, 310, 310, 310, 310, 
	274, 310, 274, 305, 274, 274, 305, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	321, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 320, 320, 320, 321, 320, 321, 320, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 320, 320, 320, 320, 279, 320, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 320, 320, 320, 320, 320, 279, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 321, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 322, 322, 322, 321, 322, 321, 
	322, 279, 279, 279, 279, 323, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 322, 322, 322, 322, 279, 
	322, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 322, 322, 322, 322, 322, 
	279, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 321, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 322, 322, 322, 321, 322, 
	321, 322, 279, 279, 279, 279, 279, 279, 
	324, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 322, 322, 322, 322, 
	279, 322, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 322, 322, 322, 322, 
	322, 279, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 321, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 322, 322, 322, 321, 
	322, 321, 322, 279, 279, 279, 279, 279, 
	279, 279, 279, 325, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 322, 322, 322, 
	322, 279, 322, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 322, 322, 322, 
	322, 322, 279, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 321, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 322, 322, 322, 
	321, 322, 321, 322, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 326, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 322, 322, 
	322, 322, 279, 322, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 322, 322, 
	322, 322, 322, 279, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 321, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 322, 322, 
	322, 321, 322, 321, 322, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 327, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 322, 
	322, 322, 322, 279, 322, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 322, 
	322, 322, 322, 322, 279, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 321, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 322, 
	322, 322, 321, 322, 321, 322, 279, 279, 
	279, 326, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	322, 322, 322, 322, 279, 322, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	279, 279, 279, 279, 279, 279, 279, 279, 
	322, 322, 322, 322, 322, 279, 319, 310, 
	266, 310, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 329, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 321, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 320, 320, 320, 
	321, 320, 321, 320, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 320, 320, 
	320, 320, 291, 320, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 320, 320, 
	320, 320, 320, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 330, 331, 291, 291, 291, 291, 291, 
	332, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 333, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 334, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 335, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 336, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 337, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	338, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 339, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 340, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 341, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 342, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 343, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 339, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 344, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	343, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 345, 
	291, 346, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 347, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 348, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 341, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 341, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 349, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 350, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 291, 291, 
	351, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 352, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 341, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 353, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 354, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 341, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	355, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 356, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 357, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 341, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 358, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 348, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 359, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 341, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 291, 360, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 321, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	361, 361, 361, 321, 361, 321, 361, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 361, 361, 361, 361, 291, 361, 291, 
	291, 291, 291, 291, 291, 291, 291, 362, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 361, 361, 361, 361, 361, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 363, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 364, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 365, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 366, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 367, 
	291, 368, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 369, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 341, 291, 291, 291, 370, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 291, 341, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 341, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 371, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 372, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 357, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 373, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 295, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 355, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 341, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 291, 341, 291, 291, 291, 291, 
	291, 291, 291, 341, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 374, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 375, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 376, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 357, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 377, 
	291, 291, 291, 378, 291, 291, 291, 291, 
	291, 379, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 379, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	341, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 341, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 380, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 381, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 382, 383, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 341, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 384, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 357, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 385, 291, 291, 
	386, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 341, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 352, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 387, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 388, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 370, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	389, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 295, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 291, 
	291, 291, 390, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 384, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	352, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 391, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 392, 291, 291, 291, 291, 291, 291, 
	291, 393, 291, 291, 291, 291, 291, 291, 
	291, 394, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 321, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 321, 328, 321, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 291, 328, 291, 
	291, 291, 291, 370, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 328, 328, 291, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	321, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 328, 328, 328, 321, 328, 321, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 291, 328, 
	291, 291, 291, 291, 358, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 328, 328, 291, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 321, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 328, 328, 328, 321, 328, 321, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 291, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 378, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 328, 328, 
	291, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 321, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 328, 328, 328, 321, 328, 
	321, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	291, 328, 291, 291, 291, 291, 291, 291, 
	291, 395, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 328, 
	328, 291, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 321, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 328, 328, 328, 321, 
	328, 321, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 291, 328, 291, 291, 291, 291, 352, 
	291, 291, 291, 376, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	328, 328, 291, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 321, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 328, 328, 328, 
	321, 328, 321, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 291, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 396, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 328, 328, 291, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 321, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 328, 328, 
	328, 321, 328, 321, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 291, 328, 291, 291, 291, 
	291, 397, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 328, 328, 291, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 321, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 328, 
	328, 328, 321, 328, 321, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 291, 328, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 346, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	328, 328, 328, 328, 328, 291, 274, 305, 
	398, 399, 399, 399, 398, 399, 399, 399, 
	399, 400, 399, 400, 400, 400, 399, 399, 
	399, 399, 399, 399, 399, 399, 399, 399, 
	399, 399, 398, 399, 399, 399, 399, 399, 
	400, 399, 399, 401, 399, 399, 399, 399, 
	399, 399, 399, 399, 399, 399, 402, 399, 
	399, 399, 399, 399, 399, 399, 399, 399, 
	399, 399, 399, 399, 399, 399, 399, 399, 
	399, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 399, 404, 399, 399, 403, 
	399, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 399, 399, 399, 399, 399, 
	403, 400, 405, 400, 400, 400, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	400, 405, 406, 407, 408, 409, 411, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 16, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 14, 410, 410, 410, 410, 16, 
	410, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 410, 410, 410, 410, 17, 
	410, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 410, 410, 410, 410, 410, 
	17, 412, 410, 413, 414, 415, 415, 415, 
	414, 415, 415, 415, 415, 416, 417, 416, 
	416, 416, 415, 415, 415, 415, 415, 415, 
	415, 415, 415, 415, 415, 415, 414, 415, 
	415, 415, 415, 415, 416, 418, 415, 419, 
	415, 420, 421, 415, 415, 415, 422, 423, 
	415, 423, 415, 420, 415, 415, 415, 415, 
	415, 415, 415, 415, 415, 415, 415, 415, 
	424, 425, 426, 415, 415, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 428, 
	429, 415, 420, 430, 420, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 415, 
	431, 415, 423, 415, 430, 416, 432, 416, 
	416, 416, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 416, 432, 433, 420, 
	434, 434, 420, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	420, 434, 435, 436, 437, 438, 420, 434, 
	420, 434, 420, 434, 420, 439, 434, 420, 
	434, 441, 420, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 420, 440, 420, 434, 420, 420, 
	434, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 443, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 442, 442, 442, 442, 442, 
	443, 442, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 442, 442, 442, 442, 
	427, 442, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 442, 442, 442, 442, 
	442, 427, 445, 444, 446, 441, 440, 417, 
	440, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 443, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 447, 447, 447, 447, 447, 
	443, 447, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 447, 447, 447, 447, 
	430, 447, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 447, 447, 447, 447, 
	447, 430, 420, 434, 448, 449, 449, 449, 
	448, 449, 449, 449, 449, 450, 451, 450, 
	450, 450, 449, 449, 449, 449, 449, 449, 
	449, 449, 449, 449, 449, 449, 448, 449, 
	449, 449, 449, 449, 450, 449, 449, 452, 
	449, 20, 453, 449, 454, 449, 455, 20, 
	55, 456, 57, 20, 449, 449, 449, 449, 
	449, 449, 449, 449, 449, 449, 457, 449, 
	458, 55, 459, 460, 449, 449, 449, 449, 
	449, 449, 449, 449, 449, 449, 449, 449, 
	449, 449, 449, 449, 449, 449, 449, 449, 
	449, 449, 449, 449, 449, 449, 449, 55, 
	461, 55, 20, 449, 449, 449, 449, 449, 
	449, 449, 449, 449, 449, 462, 449, 449, 
	449, 449, 449, 449, 449, 449, 463, 449, 
	449, 464, 449, 465, 449, 449, 449, 68, 
	69, 449, 20, 449, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 450, 466, 450, 
	450, 450, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 450, 466, 466, 466, 
	466, 50, 51, 466, 52, 466, 53, 54, 
	55, 56, 57, 50, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 58, 466, 
	59, 55, 60, 61, 466, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 62, 
	63, 55, 20, 23, 466, 23, 23, 23, 
	23, 23, 23, 23, 23, 64, 23, 23, 
	23, 23, 23, 23, 23, 23, 65, 23, 
	23, 66, 23, 67, 23, 23, 23, 68, 
	69, 466, 20, 466, 23, 467, 468, 468, 
	468, 467, 468, 468, 468, 468, 55, 469, 
	55, 55, 55, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 467, 
	468, 468, 468, 468, 468, 55, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 55, 468, 55, 469, 55, 55, 
	55, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 55, 21, 21, 21, 21, 
	21, 20, 21, 21, 21, 21, 21, 21, 
	21, 55, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	55, 21, 55, 469, 55, 55, 55, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 55, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 55, 21, 
	470, 55, 469, 55, 55, 55, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	55, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 472, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 55, 471, 55, 
	469, 55, 55, 55, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 55, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 55, 55, 21, 473, 467, 
	55, 467, 475, 474, 477, 478, 477, 477, 
	477, 476, 476, 476, 476, 476, 476, 476, 
	476, 476, 476, 476, 476, 476, 476, 476, 
	476, 476, 476, 477, 476, 479, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 22, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	24, 467, 467, 467, 467, 22, 467, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 467, 467, 467, 467, 23, 467, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 467, 467, 467, 467, 467, 23, 480, 
	55, 469, 55, 55, 55, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 55, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 55, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 20, 467, 481, 482, 483, 
	484, 485, 486, 55, 469, 55, 55, 55, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 55, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 20, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 467, 55, 
	467, 55, 474, 20, 487, 20, 487, 488, 
	489, 488, 488, 488, 476, 476, 476, 476, 
	476, 476, 476, 476, 476, 476, 476, 476, 
	476, 476, 476, 476, 476, 476, 488, 476, 
	490, 487, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 26, 491, 26, 26, 26, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 26, 491, 491, 491, 491, 27, 
	28, 491, 29, 491, 30, 31, 32, 33, 
	34, 27, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 35, 491, 36, 32, 
	37, 38, 491, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 40, 41, 32, 
	42, 39, 491, 39, 39, 39, 39, 39, 
	39, 39, 39, 43, 39, 39, 39, 39, 
	39, 39, 39, 39, 44, 39, 39, 45, 
	39, 46, 39, 39, 39, 47, 48, 491, 
	42, 491, 39, 55, 487, 492, 487, 493, 
	487, 494, 487, 495, 100, 100, 100, 495, 
	100, 100, 100, 100, 496, 100, 496, 496, 
	496, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 495, 100, 100, 
	100, 100, 100, 496, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 100, 497, 
	100, 100, 96, 100, 96, 96, 96, 98, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 100, 100, 
	100, 100, 100, 96, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 94, 498, 94, 
	94, 94, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 94, 498, 498, 498, 
	498, 498, 498, 498, 95, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 498, 
	97, 498, 498, 96, 498, 96, 96, 96, 
	98, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 498, 
	498, 498, 498, 498, 96, 499, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 500, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	100, 99, 99, 99, 99, 500, 99, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 99, 99, 99, 99, 96, 99, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 99, 99, 99, 99, 99, 96, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	500, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 100, 498, 498, 498, 498, 500, 498, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 498, 498, 498, 498, 96, 498, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 501, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 498, 498, 498, 498, 498, 96, 
	101, 498, 502, 503, 503, 503, 502, 503, 
	503, 503, 503, 504, 503, 504, 504, 504, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 502, 503, 503, 503, 
	503, 503, 504, 503, 503, 505, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 506, 503, 
	503, 503, 503, 503, 503, 503, 507, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 508, 503, 504, 
	509, 504, 504, 504, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 504, 509, 
	510, 511, 512, 513, 515, 514, 516, 517, 
	514, 518, 519, 520, 520, 520, 519, 520, 
	520, 520, 520, 521, 522, 521, 521, 521, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 519, 520, 520, 520, 
	520, 520, 521, 520, 520, 523, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 520, 525, 520, 
	520, 524, 520, 524, 524, 524, 524, 524, 
	524, 524, 524, 526, 524, 524, 524, 524, 
	524, 524, 524, 524, 527, 524, 524, 528, 
	524, 529, 524, 524, 524, 520, 520, 520, 
	520, 520, 524, 521, 530, 521, 521, 521, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 521, 530, 531, 532, 533, 534, 
	535, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 536, 536, 536, 536, 536, 
	536, 536, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 536, 536, 536, 536, 
	524, 536, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 536, 536, 536, 536, 
	536, 524, 538, 537, 539, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 540, 
	540, 540, 540, 540, 540, 540, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	540, 540, 540, 540, 524, 540, 524, 524, 
	524, 524, 524, 541, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	540, 540, 540, 540, 540, 524, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	540, 540, 540, 540, 540, 540, 540, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 540, 540, 540, 540, 524, 540, 524, 
	524, 524, 524, 542, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 540, 540, 540, 540, 540, 524, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 540, 540, 540, 540, 540, 540, 540, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 540, 540, 540, 540, 524, 540, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 543, 524, 524, 524, 524, 524, 
	524, 524, 540, 540, 540, 540, 540, 524, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 540, 540, 540, 540, 540, 540, 
	540, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 540, 540, 540, 540, 524, 
	540, 524, 524, 544, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 540, 540, 540, 540, 540, 
	524, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 540, 540, 540, 540, 540, 
	540, 540, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 540, 540, 540, 540, 
	524, 540, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 545, 524, 
	524, 524, 524, 524, 540, 540, 540, 540, 
	540, 524, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 540, 540, 540, 540, 
	540, 540, 540, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 540, 540, 540, 
	540, 524, 540, 524, 524, 524, 524, 541, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 540, 540, 540, 
	540, 540, 524, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 540, 540, 540, 
	540, 540, 540, 540, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 540, 540, 
	540, 540, 524, 540, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 546, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 540, 540, 
	540, 540, 540, 524, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 540, 540, 
	540, 540, 540, 540, 540, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 540, 
	540, 540, 540, 524, 540, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	547, 524, 524, 524, 524, 524, 524, 524, 
	548, 524, 524, 524, 524, 524, 524, 540, 
	540, 540, 540, 540, 524, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 540, 
	540, 540, 540, 540, 540, 540, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	540, 540, 540, 540, 524, 540, 524, 524, 
	524, 524, 549, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	540, 540, 540, 540, 540, 524, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	540, 540, 540, 540, 540, 540, 540, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 540, 540, 540, 540, 524, 540, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 550, 524, 524, 524, 524, 524, 524, 
	524, 540, 540, 540, 540, 540, 524, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 540, 540, 540, 540, 540, 540, 540, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 540, 540, 540, 540, 524, 540, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 541, 524, 524, 524, 524, 524, 
	524, 524, 540, 540, 540, 540, 540, 524, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 540, 540, 540, 540, 540, 540, 
	540, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 540, 540, 540, 540, 524, 
	540, 524, 524, 524, 524, 524, 524, 524, 
	524, 551, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 540, 540, 540, 540, 540, 
	524, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 540, 540, 540, 540, 540, 
	540, 540, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 540, 540, 540, 540, 
	524, 540, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 541, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 540, 540, 540, 540, 
	540, 524, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 540, 540, 540, 540, 
	540, 540, 540, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 540, 540, 540, 
	540, 524, 540, 524, 524, 524, 524, 524, 
	524, 524, 552, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 540, 540, 540, 
	540, 540, 524, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 540, 540, 540, 
	540, 540, 540, 540, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 540, 540, 
	540, 540, 524, 540, 524, 524, 524, 524, 
	524, 524, 524, 524, 553, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 540, 540, 
	540, 540, 540, 524, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 540, 540, 
	540, 540, 540, 540, 540, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 540, 
	540, 540, 540, 524, 540, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	545, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 540, 
	540, 540, 540, 540, 524, 554, 116, 116, 
	116, 554, 116, 116, 116, 116, 555, 556, 
	555, 555, 555, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 554, 
	116, 116, 116, 116, 116, 555, 557, 116, 
	558, 116, 559, 560, 116, 561, 116, 562, 
	563, 116, 564, 565, 566, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 567, 
	116, 568, 569, 570, 571, 116, 572, 573, 
	572, 572, 574, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	575, 576, 116, 577, 578, 116, 579, 580, 
	581, 582, 583, 584, 585, 585, 586, 585, 
	585, 585, 587, 588, 589, 585, 585, 590, 
	591, 592, 593, 585, 594, 585, 595, 585, 
	596, 597, 116, 577, 116, 585, 555, 598, 
	555, 555, 555, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 555, 598, 600, 
	599, 602, 603, 602, 602, 602, 601, 601, 
	601, 601, 601, 601, 601, 601, 601, 601, 
	601, 601, 601, 601, 601, 601, 601, 601, 
	602, 601, 116, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 116, 604, 605, 606, 607, 
	608, 610, 610, 610, 610, 610, 610, 610, 
	610, 610, 610, 610, 610, 610, 610, 610, 
	610, 610, 610, 610, 610, 610, 610, 610, 
	610, 610, 610, 610, 610, 610, 610, 610, 
	610, 610, 610, 610, 610, 610, 610, 610, 
	610, 610, 610, 610, 610, 610, 610, 610, 
	610, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 610, 610, 610, 610, 610, 
	610, 610, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 610, 610, 610, 610, 
	610, 610, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 610, 610, 610, 610, 
	610, 609, 613, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 116, 612, 614, 616, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 116, 
	615, 116, 115, 117, 118, 117, 117, 117, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 117, 612, 612, 119, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 612, 612, 612, 116, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 121, 612, 
	134, 135, 134, 134, 134, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 134, 
	133, 133, 136, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	137, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 138, 133, 117, 118, 117, 
	117, 117, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 117, 612, 612, 119, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 612, 612, 
	612, 116, 116, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	612, 612, 612, 612, 612, 612, 612, 612, 
	121, 612, 618, 604, 620, 619, 622, 621, 
	604, 623, 623, 623, 604, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 604, 623, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 624, 625, 604, 
	626, 141, 627, 625, 604, 604, 628, 629, 
	604, 629, 604, 141, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 630, 604, 
	631, 632, 633, 604, 634, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 636, 
	604, 604, 141, 635, 141, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 604, 
	637, 604, 638, 604, 635, 141, 639, 639, 
	640, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 141, 639, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 639, 639, 639, 
	639, 639, 639, 639, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 639, 639, 
	639, 639, 144, 639, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 144, 144, 
	144, 144, 144, 144, 144, 144, 639, 639, 
	639, 639, 639, 144, 641, 639, 141, 639, 
	141, 639, 141, 642, 639, 141, 639, 141, 
	639, 141, 141, 639, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 643, 643, 643, 643, 
	643, 643, 643, 643, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 643, 643, 
	643, 643, 643, 643, 645, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 643, 
	643, 643, 643, 646, 643, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 643, 
	643, 643, 643, 643, 646, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 647, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	649, 649, 649, 649, 649, 649, 649, 649, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 649, 649, 649, 649, 649, 649, 
	649, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 649, 649, 649, 649, 651, 
	649, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 651, 651, 651, 651, 651, 
	651, 651, 651, 649, 649, 649, 649, 649, 
	651, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 639, 652, 639, 639, 639, 639, 639, 
	639, 639, 639, 639, 639, 639, 639, 639, 
	639, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 639, 639, 639, 653, 639, 
	652, 639, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 639, 639, 639, 639, 
	635, 639, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 635, 635, 635, 635, 
	635, 635, 635, 635, 639, 639, 639, 639, 
	639, 635, 655, 654, 656, 658, 659, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 660, 657, 
	662, 663, 661, 664, 665, 666, 667, 641, 
	639, 640, 639, 668, 669, 604, 152, 146, 
	146, 146, 146, 146, 146, 146, 146, 146, 
	146, 146, 146, 146, 146, 146, 146, 146, 
	146, 146, 146, 146, 146, 146, 153, 146, 
	671, 158, 147, 147, 147, 147, 147, 147, 
	147, 147, 147, 147, 147, 147, 147, 147, 
	147, 147, 147, 147, 147, 147, 147, 147, 
	147, 147, 147, 147, 147, 147, 153, 147, 
	153, 161, 116, 604, 577, 116, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 116, 604, 116, 
	613, 604, 673, 674, 674, 674, 673, 674, 
	674, 674, 674, 674, 674, 674, 674, 674, 
	674, 674, 674, 674, 674, 674, 674, 674, 
	674, 674, 674, 674, 673, 674, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 163, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	165, 115, 115, 166, 115, 163, 115, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 115, 115, 115, 115, 164, 115, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 115, 115, 115, 115, 115, 164, 676, 
	675, 675, 677, 675, 678, 680, 681, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 682, 679, 
	684, 683, 685, 686, 687, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 163, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 165, 
	604, 604, 166, 604, 163, 604, 164, 164, 
	164, 164, 688, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	604, 604, 604, 604, 164, 604, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	604, 604, 604, 604, 604, 164, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 163, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	165, 604, 604, 166, 604, 163, 604, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 689, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 604, 604, 604, 604, 164, 604, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 604, 604, 604, 604, 604, 164, 690, 
	691, 604, 599, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 695, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 696, 697, 585, 585, 585, 585, 
	585, 698, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 699, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 700, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 701, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 702, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 703, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 704, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 705, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 706, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 707, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	163, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 115, 115, 166, 115, 163, 115, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 115, 115, 115, 115, 585, 115, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 115, 115, 115, 115, 115, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 708, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 709, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 705, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 710, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 709, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 711, 585, 712, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 713, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	714, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 707, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 707, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 715, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 716, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	585, 585, 717, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 718, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 707, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 719, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	720, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 707, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 721, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 722, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 723, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	707, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 724, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	714, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 725, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 707, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 585, 707, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 726, 585, 727, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 728, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 707, 
	585, 585, 585, 725, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 707, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 729, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 730, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 723, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 731, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 589, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 721, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 707, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 585, 732, 
	585, 585, 585, 585, 585, 585, 585, 707, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 733, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 734, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 735, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 723, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 736, 585, 585, 585, 737, 
	585, 585, 585, 585, 585, 738, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 738, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 707, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 707, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 739, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 740, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 741, 742, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 707, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	743, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 744, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 745, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 747, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 749, 746, 746, 750, 746, 747, 
	746, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 746, 746, 746, 746, 748, 
	746, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 746, 746, 746, 746, 746, 
	748, 680, 751, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 679, 679, 679, 679, 679, 679, 
	679, 679, 682, 679, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 752, 585, 
	585, 753, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 707, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	718, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 754, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 755, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 725, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 756, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 589, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	585, 585, 585, 757, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 758, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 718, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 723, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 759, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 760, 585, 585, 585, 585, 
	585, 585, 585, 761, 585, 585, 585, 585, 
	585, 585, 585, 762, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 725, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 763, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 764, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 732, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 765, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 692, 
	693, 693, 693, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 163, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 165, 
	692, 692, 166, 692, 163, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 694, 692, 692, 585, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 732, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	692, 692, 692, 692, 692, 585, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	692, 693, 693, 693, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 693, 163, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	165, 692, 692, 166, 692, 163, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 694, 692, 692, 585, 692, 585, 
	585, 585, 585, 585, 585, 585, 766, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 692, 692, 692, 692, 692, 585, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 692, 693, 693, 693, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 693, 
	163, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 165, 692, 692, 166, 692, 163, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 694, 692, 692, 585, 692, 
	585, 585, 585, 585, 718, 585, 585, 585, 
	767, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 692, 692, 692, 692, 692, 585, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	693, 163, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 165, 692, 692, 166, 692, 163, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 694, 692, 692, 585, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 768, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 692, 692, 692, 692, 692, 
	585, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 692, 693, 693, 693, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 693, 163, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 165, 692, 692, 166, 692, 
	163, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 694, 692, 692, 
	585, 692, 585, 585, 585, 585, 732, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 692, 692, 692, 692, 
	692, 585, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 692, 693, 693, 693, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 693, 163, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 165, 692, 692, 166, 
	692, 163, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 694, 692, 
	692, 585, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 769, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 692, 692, 692, 
	692, 692, 585, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 692, 693, 693, 
	693, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 693, 163, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 165, 692, 692, 
	166, 692, 163, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 694, 
	692, 692, 585, 692, 585, 585, 585, 585, 
	770, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 692, 692, 
	692, 692, 692, 585, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 693, 692, 693, 
	693, 693, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 693, 163, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 165, 692, 
	692, 166, 692, 163, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	694, 692, 692, 585, 692, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 585, 
	712, 585, 585, 585, 585, 585, 585, 585, 
	585, 585, 585, 585, 585, 585, 585, 692, 
	692, 692, 692, 692, 585, 771, 116, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 772, 604, 773, 
	774, 774, 774, 773, 774, 774, 774, 774, 
	775, 776, 775, 775, 775, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 773, 774, 774, 774, 774, 774, 775, 
	774, 774, 777, 774, 774, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 774, 774, 774, 774, 774, 774, 774, 
	774, 774, 774, 778, 774, 775, 779, 775, 
	775, 775, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 779, 779, 779, 779, 
	779, 779, 779, 779, 775, 779, 780, 781, 
	782, 783, 784, 786, 785, 787, 788, 789, 
	789, 789, 788, 789, 789, 789, 789, 790, 
	791, 790, 790, 790, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	788, 789, 789, 789, 789, 789, 790, 789, 
	792, 793, 789, 789, 789, 792, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 794, 
	794, 794, 794, 794, 794, 794, 794, 794, 
	794, 794, 794, 794, 794, 794, 794, 794, 
	794, 794, 794, 794, 794, 794, 794, 794, 
	794, 789, 795, 789, 789, 794, 789, 794, 
	794, 794, 794, 794, 794, 794, 794, 794, 
	794, 794, 794, 794, 794, 794, 794, 794, 
	794, 794, 794, 794, 794, 794, 794, 794, 
	794, 789, 789, 789, 789, 789, 794, 790, 
	796, 790, 790, 790, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 790, 796, 
	797, 798, 799, 800, 801, 802, 802, 802, 
	802, 802, 802, 802, 802, 802, 802, 802, 
	802, 802, 802, 802, 802, 802, 802, 802, 
	802, 802, 802, 802, 802, 802, 802, 802, 
	802, 802, 802, 802, 802, 802, 181, 802, 
	802, 802, 802, 802, 802, 802, 802, 802, 
	802, 802, 802, 802, 802, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 179, 
	802, 802, 802, 802, 181, 802, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	802, 802, 802, 802, 182, 802, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	802, 802, 802, 802, 802, 182, 803, 802, 
	804, 805, 806, 806, 806, 805, 806, 806, 
	806, 806, 807, 808, 807, 807, 807, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 805, 806, 806, 806, 806, 
	806, 807, 809, 810, 811, 812, 813, 814, 
	810, 815, 816, 817, 813, 818, 819, 820, 
	813, 821, 822, 822, 822, 822, 822, 822, 
	822, 822, 822, 823, 824, 825, 826, 827, 
	828, 829, 830, 831, 830, 830, 832, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 833, 834, 835, 813, 
	836, 810, 837, 838, 839, 840, 841, 842, 
	843, 843, 844, 843, 843, 843, 845, 846, 
	847, 843, 843, 848, 849, 850, 851, 843, 
	852, 843, 853, 843, 854, 855, 856, 857, 
	806, 843, 807, 858, 807, 807, 807, 858, 
	858, 858, 858, 858, 858, 858, 858, 858, 
	858, 858, 858, 858, 858, 858, 858, 858, 
	858, 807, 858, 859, 861, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 861, 860, 862, 
	863, 864, 865, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 184, 184, 866, 184, 
	866, 184, 184, 866, 866, 184, 184, 184, 
	867, 184, 184, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 184, 184, 184, 
	184, 184, 184, 184, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 866, 184, 
	866, 866, 201, 184, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 866, 866, 
	866, 184, 866, 201, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 869, 869, 
	869, 869, 869, 869, 869, 869, 869, 869, 
	869, 869, 869, 869, 869, 869, 869, 869, 
	869, 869, 869, 869, 869, 869, 869, 869, 
	869, 869, 869, 869, 869, 869, 869, 869, 
	869, 869, 869, 869, 869, 869, 869, 869, 
	869, 869, 869, 869, 869, 869, 869, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 869, 869, 869, 869, 869, 869, 869, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 869, 869, 869, 869, 201, 869, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 869, 869, 869, 869, 869, 201, 
	870, 189, 813, 871, 871, 871, 871, 871, 
	871, 871, 872, 871, 871, 871, 871, 871, 
	871, 871, 871, 871, 871, 871, 871, 871, 
	871, 870, 871, 873, 874, 813, 875, 875, 
	875, 875, 875, 875, 875, 875, 875, 875, 
	875, 875, 875, 875, 875, 875, 875, 875, 
	870, 875, 870, 876, 871, 878, 877, 188, 
	188, 188, 188, 188, 188, 188, 188, 188, 
	188, 877, 880, 879, 881, 879, 188, 188, 
	188, 188, 188, 188, 188, 188, 188, 188, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 883, 882, 882, 882, 882, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 882, 882, 884, 882, 882, 
	882, 882, 882, 883, 882, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 882, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 882, 882, 882, 882, 882, 
	882, 882, 882, 882, 186, 882, 886, 885, 
	887, 887, 887, 887, 887, 887, 887, 887, 
	887, 887, 885, 885, 885, 885, 885, 885, 
	885, 885, 888, 885, 889, 890, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 891, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	892, 885, 885, 885, 885, 885, 885, 893, 
	885, 885, 888, 885, 889, 890, 885, 885, 
	885, 894, 885, 885, 885, 885, 885, 891, 
	885, 885, 895, 885, 885, 885, 885, 885, 
	892, 885, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 897, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 898, 896, 896, 896, 896, 896, 897, 
	896, 896, 896, 899, 896, 896, 896, 896, 
	896, 896, 896, 896, 900, 896, 901, 189, 
	901, 189, 189, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 189, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	902, 902, 902, 902, 902, 902, 902, 902, 
	902, 902, 902, 902, 902, 902, 902, 902, 
	902, 902, 902, 902, 902, 902, 902, 902, 
	902, 902, 902, 902, 902, 902, 902, 902, 
	902, 902, 902, 902, 902, 901, 902, 902, 
	902, 902, 902, 902, 902, 902, 902, 903, 
	902, 905, 904, 906, 908, 907, 907, 907, 
	909, 907, 910, 911, 887, 887, 887, 887, 
	887, 887, 887, 887, 887, 887, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 893, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 894, 885, 885, 
	885, 885, 885, 885, 885, 885, 895, 885, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 885, 885, 885, 885, 885, 885, 913, 
	885, 885, 885, 885, 885, 885, 885, 885, 
	885, 894, 885, 885, 885, 885, 885, 885, 
	885, 885, 895, 885, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 916, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 917, 914, 914, 
	914, 914, 914, 914, 914, 914, 918, 914, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 919, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 917, 914, 914, 914, 914, 914, 914, 
	914, 914, 918, 914, 917, 914, 914, 914, 
	914, 914, 914, 914, 914, 918, 914, 921, 
	920, 922, 924, 923, 923, 923, 925, 923, 
	927, 926, 928, 929, 931, 931, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 932, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 933, 930, 930, 
	930, 930, 930, 930, 930, 930, 934, 930, 
	935, 935, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 936, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 917, 914, 914, 914, 914, 914, 914, 
	914, 914, 918, 914, 935, 935, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 919, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 917, 914, 914, 
	914, 914, 914, 914, 914, 914, 918, 914, 
	938, 938, 938, 938, 938, 938, 938, 938, 
	938, 938, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 939, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 940, 937, 937, 937, 937, 937, 937, 
	937, 937, 941, 937, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 944, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 945, 942, 942, 
	942, 942, 942, 942, 942, 942, 946, 942, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 947, 947, 947, 947, 947, 947, 
	947, 948, 948, 948, 948, 948, 948, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 949, 
	947, 948, 948, 948, 948, 948, 948, 947, 
	947, 950, 947, 947, 947, 947, 947, 947, 
	947, 947, 951, 947, 952, 952, 952, 952, 
	952, 952, 952, 952, 952, 952, 914, 914, 
	914, 914, 914, 914, 914, 952, 952, 952, 
	952, 952, 952, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 953, 914, 952, 952, 952, 
	952, 952, 952, 914, 914, 917, 914, 914, 
	914, 914, 914, 914, 914, 914, 918, 914, 
	952, 952, 952, 952, 952, 952, 952, 952, 
	952, 952, 914, 914, 914, 914, 914, 914, 
	914, 952, 952, 952, 952, 952, 952, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 919, 
	914, 952, 952, 952, 952, 952, 952, 914, 
	914, 917, 914, 914, 914, 914, 914, 914, 
	914, 914, 918, 914, 955, 954, 956, 956, 
	956, 956, 956, 956, 956, 956, 956, 956, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 957, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 958, 954, 954, 
	954, 954, 954, 957, 954, 954, 954, 959, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	960, 954, 961, 961, 961, 961, 961, 961, 
	961, 961, 961, 961, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 962, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 959, 954, 954, 954, 954, 
	954, 954, 954, 954, 960, 954, 963, 914, 
	964, 964, 964, 964, 964, 964, 964, 964, 
	964, 964, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 965, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 966, 
	914, 914, 914, 914, 914, 965, 914, 914, 
	914, 917, 914, 914, 914, 914, 914, 914, 
	914, 914, 918, 914, 964, 964, 964, 964, 
	964, 964, 964, 964, 964, 964, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 919, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 917, 914, 914, 
	914, 914, 914, 914, 914, 914, 918, 914, 
	872, 879, 813, 967, 871, 861, 871, 968, 
	969, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	861, 879, 861, 871, 861, 813, 871, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 866, 
	866, 866, 866, 866, 866, 866, 866, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 866, 866, 866, 866, 866, 866, 970, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 866, 866, 866, 866, 201, 866, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 866, 866, 866, 866, 866, 201, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 971, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 972, 189, 189, 189, 189, 971, 
	189, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 189, 189, 189, 189, 830, 
	189, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 189, 189, 189, 189, 189, 
	830, 974, 973, 975, 976, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 971, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 972, 
	977, 977, 977, 977, 971, 977, 830, 830, 
	830, 830, 978, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	977, 977, 977, 977, 830, 977, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	977, 977, 977, 977, 977, 830, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 971, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	972, 977, 977, 977, 977, 971, 977, 830, 
	830, 830, 830, 830, 830, 979, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 977, 977, 977, 977, 830, 977, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 977, 977, 977, 977, 977, 830, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	971, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 972, 977, 977, 977, 977, 971, 977, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	980, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 977, 977, 977, 977, 830, 977, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 977, 977, 977, 977, 977, 830, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 971, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 972, 977, 977, 977, 977, 971, 
	977, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 981, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 977, 977, 977, 977, 830, 
	977, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 977, 977, 977, 977, 977, 
	830, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 971, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 972, 977, 977, 977, 977, 
	971, 977, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 982, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 977, 977, 977, 977, 
	830, 977, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 977, 977, 977, 977, 
	977, 830, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 971, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 972, 977, 977, 977, 
	977, 971, 977, 830, 830, 830, 981, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 977, 977, 977, 
	977, 830, 977, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 977, 977, 977, 
	977, 977, 830, 983, 985, 984, 986, 987, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 989, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 971, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 189, 189, 189, 189, 189, 
	971, 189, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 189, 189, 189, 189, 
	843, 189, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 189, 189, 189, 189, 
	189, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 990, 
	991, 843, 843, 843, 843, 843, 992, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 993, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 994, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 995, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 996, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	997, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 998, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	999, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 1000, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 1001, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 1002, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1003, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 1004, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 1005, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 1006, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 1007, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1003, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1008, 
	843, 1009, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 1010, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 1011, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1012, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 1013, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 1014, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1015, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	1016, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 1017, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1013, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 1018, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 1019, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1020, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	1021, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1022, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1023, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 1013, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 1024, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1025, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1026, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 1027, 203, 204, 
	203, 203, 203, 1027, 1027, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 203, 971, 1027, 
	205, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1027, 
	1027, 206, 1027, 1027, 971, 1027, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1027, 207, 1027, 1027, 843, 1027, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1027, 1027, 1027, 1027, 1027, 843, 220, 221, 
	220, 220, 220, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 220, 219, 219, 
	222, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 225, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 224, 219, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	1029, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1030, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 1031, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 971, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1032, 
	1032, 1032, 1032, 1032, 971, 1032, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1032, 1032, 1032, 1032, 843, 1032, 843, 843, 
	843, 843, 843, 843, 843, 843, 1033, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1032, 1032, 1032, 1032, 1032, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1034, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 1035, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 1036, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	1037, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1038, 843, 
	1039, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1040, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 1013, 843, 843, 843, 1041, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 843, 1013, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 1006, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1042, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1043, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1023, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 1044, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	847, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1045, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 1006, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1013, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 1047, 843, 843, 843, 
	843, 843, 843, 843, 1013, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1048, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 1049, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1050, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1023, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	1051, 843, 843, 843, 1052, 843, 843, 843, 
	843, 843, 1053, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1054, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1020, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1006, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1055, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 1056, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 1057, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1058, 1059, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1006, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 1060, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1061, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 1047, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1062, 843, 843, 1063, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1006, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1064, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1020, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 1065, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1066, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1067, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 1006, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1068, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 1069, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1055, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	1070, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1071, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 1017, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1072, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	1073, 843, 843, 843, 843, 843, 843, 843, 
	1074, 843, 843, 843, 843, 843, 843, 843, 
	1075, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 1076, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 1012, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 1077, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1078, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1047, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 1079, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1047, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 971, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 971, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 843, 988, 843, 843, 843, 
	843, 843, 843, 843, 1080, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 843, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 971, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 988, 
	988, 988, 988, 988, 971, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 843, 988, 843, 843, 
	843, 843, 1017, 843, 843, 843, 1081, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 843, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 971, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	988, 988, 988, 988, 988, 971, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 843, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1082, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 843, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	971, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 988, 988, 988, 988, 988, 971, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 843, 988, 
	843, 843, 843, 843, 1047, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 843, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 971, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 988, 988, 988, 988, 988, 971, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 843, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 1083, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	843, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 971, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 988, 988, 988, 988, 988, 
	971, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	843, 988, 843, 843, 843, 843, 1084, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 843, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 971, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 988, 988, 988, 988, 
	988, 971, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 843, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1085, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 843, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 971, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 988, 988, 988, 
	988, 988, 971, 988, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 843, 988, 843, 843, 843, 1055, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 988, 988, 
	988, 988, 988, 843, 1086, 870, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 860, 860, 860, 860, 
	860, 860, 860, 860, 813, 860, 1087, 1089, 
	1088, 1089, 1089, 1089, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1089, 1088, 
	1088, 1090, 1088, 1088, 1091, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 233, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1092, 1088, 229, 230, 229, 229, 
	229, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 229, 1093, 1093, 231, 1093, 
	1093, 232, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 233, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1093, 234, 
	1093, 236, 1094, 236, 236, 236, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	236, 1094, 1094, 231, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 234, 1094, 1096, 1095, 
	1098, 1097, 239, 238, 244, 1093, 242, 1093, 
	1100, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1101, 1099, 1100, 1099, 1100, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1103, 1099, 1100, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1104, 1099, 1100, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1105, 1099, 1107, 1105, 
	1108, 1109, 1109, 1109, 1108, 1109, 1109, 1109, 
	1109, 1110, 1111, 1110, 1110, 1110, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1108, 1109, 1109, 1109, 1109, 1109, 
	1110, 1109, 1109, 1112, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1113, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1114, 1109, 1109, 1115, 
	1109, 1110, 1116, 1110, 1110, 1110, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1110, 1116, 1117, 1118, 1119, 1120, 1121, 1123, 
	1122, 1125, 1126, 1125, 1125, 1125, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1125, 1124, 1111, 1122, 1127, 1122, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	129, 0, 2, 130, 131, 132, 4, 133, 
	134, 134, 134, 134, 247, 247, 9, 247, 
	8, 10, 276, 280, 280, 276, 14, 13, 
	276, 16, 17, 278, 279, 281, 282, 280, 
	276, 283, 284, 286, 11, 12, 287, 13, 
	288, 15, 280, 18, 19, 24, 31, 290, 
	291, 17, 278, 279, 281, 282, 280, 276, 
	283, 284, 286, 11, 12, 287, 288, 15, 
	18, 19, 24, 31, 290, 291, 289, 20, 
	21, 22, 23, 25, 26, 29, 27, 28, 
	30, 32, 33, 276, 35, 36, 37, 39, 
	42, 40, 41, 43, 45, 307, 46, 309, 
	310, 48, 311, 307, 307, 49, 46, 309, 
	310, 48, 311, 345, 51, 52, 53, 54, 
	348, 345, 345, 345, 345, 57, 58, 59, 
	345, 62, 57, 58, 59, 345, 62, 60, 
	60, 58, 59, 358, 61, 60, 60, 58, 
	59, 358, 61, 58, 345, 345, 64, 366, 
	367, 373, 390, 392, 72, 73, 74, 345, 
	68, 69, 70, 391, 70, 391, 71, 73, 
	393, 75, 345, 399, 77, 76, 401, 79, 
	80, 398, 345, 82, 345, 83, 84, 82, 
	345, 83, 508, 86, 508, 85, 87, 516, 
	516, 516, 90, 535, 534, 516, 537, 539, 
	516, 95, 96, 97, 543, 516, 99, 100, 
	554, 524, 578, 103, 104, 105, 109, 110, 
	103, 104, 105, 109, 110, 106, 106, 104, 
	105, 107, 108, 106, 106, 104, 105, 107, 
	108, 627, 104, 516, 696, 111, 698, 113, 
	117, 699, 115, 696, 112, 696, 114, 698, 
	114, 698, 116, 698, 696, 710, 119, 120, 
	121, 716, 123, 124, 125, 126, 127, 710, 
	710, 128, 1, 3, 129, 129, 129, 134, 
	134, 135, 136, 137, 138, 140, 143, 144, 
	145, 146, 134, 147, 148, 150, 152, 153, 
	154, 158, 160, 161, 162, 179, 184, 191, 
	196, 203, 210, 163, 213, 214, 218, 212, 
	222, 230, 234, 236, 241, 243, 246, 134, 
	134, 134, 134, 139, 134, 139, 134, 5, 
	141, 142, 134, 6, 134, 134, 149, 151, 
	134, 134, 134, 155, 156, 157, 153, 159, 
	134, 164, 165, 174, 177, 166, 167, 168, 
	169, 170, 171, 172, 173, 163, 175, 176, 
	178, 180, 183, 181, 182, 185, 188, 186, 
	187, 189, 190, 192, 194, 193, 195, 197, 
	198, 134, 199, 200, 201, 202, 134, 204, 
	207, 205, 206, 208, 209, 211, 215, 216, 
	217, 219, 221, 220, 223, 224, 225, 227, 
	226, 228, 229, 231, 232, 233, 235, 237, 
	238, 239, 240, 242, 244, 245, 247, 247, 
	248, 249, 251, 252, 253, 247, 247, 250, 
	247, 250, 247, 7, 254, 247, 255, 255, 
	256, 257, 258, 259, 255, 261, 262, 263, 
	264, 266, 268, 269, 272, 273, 274, 275, 
	255, 255, 255, 255, 260, 255, 260, 265, 
	255, 267, 255, 270, 255, 271, 255, 255, 
	276, 276, 277, 292, 293, 279, 295, 296, 
	283, 297, 298, 299, 300, 301, 303, 304, 
	305, 306, 276, 276, 276, 276, 276, 276, 
	280, 285, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 294, 276, 294, 276, 276, 
	276, 276, 302, 276, 34, 38, 44, 307, 
	308, 312, 307, 307, 47, 310, 313, 313, 
	314, 315, 317, 319, 320, 313, 313, 316, 
	313, 316, 313, 318, 313, 313, 313, 321, 
	321, 322, 323, 324, 326, 327, 329, 330, 
	335, 342, 321, 321, 321, 325, 321, 325, 
	321, 321, 328, 321, 321, 326, 331, 332, 
	333, 334, 336, 337, 340, 338, 339, 341, 
	343, 344, 345, 346, 347, 349, 350, 352, 
	353, 354, 355, 357, 359, 360, 363, 364, 
	389, 395, 396, 397, 398, 406, 407, 408, 
	409, 356, 411, 429, 434, 441, 446, 448, 
	454, 412, 457, 458, 462, 456, 466, 477, 
	481, 484, 492, 496, 499, 500, 345, 345, 
	50, 345, 345, 345, 345, 345, 351, 345, 
	351, 345, 345, 55, 345, 56, 345, 345, 
	356, 345, 361, 345, 362, 345, 345, 345, 
	365, 345, 63, 368, 369, 370, 345, 371, 
	65, 374, 375, 378, 66, 387, 388, 345, 
	345, 345, 372, 345, 376, 377, 367, 345, 
	376, 345, 376, 367, 379, 381, 345, 380, 
	345, 345, 382, 385, 386, 345, 383, 384, 
	345, 345, 345, 345, 67, 394, 345, 345, 
	345, 345, 345, 345, 76, 400, 345, 345, 
	402, 404, 405, 345, 403, 345, 345, 345, 
	78, 81, 345, 410, 345, 82, 83, 413, 
	414, 424, 427, 415, 416, 417, 418, 419, 
	420, 421, 422, 423, 425, 426, 428, 430, 
	433, 431, 432, 435, 438, 436, 437, 439, 
	440, 442, 444, 443, 445, 447, 449, 451, 
	450, 452, 453, 455, 423, 459, 460, 461, 
	463, 465, 464, 467, 468, 469, 474, 470, 
	471, 472, 345, 399, 412, 76, 473, 404, 
	475, 476, 478, 479, 480, 482, 483, 485, 
	486, 487, 490, 488, 489, 491, 493, 494, 
	495, 497, 498, 345, 356, 501, 501, 502, 
	503, 504, 506, 501, 501, 501, 505, 501, 
	505, 501, 507, 501, 508, 508, 509, 510, 
	508, 511, 513, 514, 508, 508, 508, 512, 
	508, 512, 508, 515, 508, 516, 516, 517, 
	518, 519, 516, 520, 522, 525, 526, 527, 
	528, 529, 516, 530, 531, 536, 564, 568, 
	516, 569, 571, 573, 516, 574, 575, 579, 
	583, 585, 586, 588, 589, 608, 613, 620, 
	628, 635, 642, 590, 647, 648, 652, 646, 
	657, 667, 673, 676, 685, 689, 693, 694, 
	695, 525, 516, 516, 516, 516, 516, 521, 
	516, 521, 516, 88, 523, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 532, 516, 
	533, 516, 516, 89, 91, 516, 92, 545, 
	556, 559, 538, 560, 561, 546, 550, 552, 
	516, 538, 92, 540, 542, 93, 516, 540, 
	516, 541, 516, 516, 94, 544, 516, 516, 
	547, 549, 516, 547, 548, 550, 552, 549, 
	516, 551, 516, 516, 553, 555, 516, 98, 
	516, 516, 516, 557, 549, 550, 552, 557, 
	558, 516, 547, 549, 550, 552, 516, 547, 
	549, 550, 552, 516, 562, 549, 550, 552, 
	562, 563, 516, 92, 564, 538, 565, 550, 
	552, 566, 549, 92, 566, 538, 567, 570, 
	572, 516, 101, 576, 102, 516, 577, 516, 
	516, 516, 580, 581, 582, 575, 584, 516, 
	516, 587, 516, 516, 516, 591, 592, 601, 
	606, 593, 594, 595, 596, 597, 598, 599, 
	600, 590, 602, 603, 604, 605, 590, 607, 
	609, 612, 610, 611, 590, 590, 614, 617, 
	615, 616, 618, 619, 590, 621, 623, 622, 
	624, 625, 626, 516, 516, 629, 590, 630, 
	516, 631, 632, 633, 634, 576, 636, 639, 
	637, 638, 640, 641, 643, 644, 645, 590, 
	649, 650, 651, 653, 655, 656, 654, 590, 
	658, 659, 660, 663, 661, 662, 664, 665, 
	666, 668, 670, 669, 671, 672, 674, 675, 
	677, 678, 680, 683, 679, 681, 682, 684, 
	686, 687, 688, 690, 691, 692, 516, 516, 
	696, 697, 701, 702, 703, 696, 696, 696, 
	700, 696, 696, 705, 704, 706, 704, 707, 
	708, 709, 704, 704, 710, 710, 711, 712, 
	713, 715, 717, 718, 710, 710, 710, 714, 
	710, 714, 710, 118, 710, 710, 710, 122
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	53, 0, 0, 0, 0, 0, 0, 0, 
	95, 65, 93, 71, 111, 101, 0, 99, 
	0, 0, 157, 727, 733, 161, 0, 0, 
	135, 1, 3, 481, 971, 3, 484, 971, 
	499, 971, 3, 3, 481, 3, 487, 3, 
	3, 3, 901, 3, 3, 3, 3, 3, 
	3, 0, 11, 925, 0, 13, 925, 139, 
	925, 0, 0, 11, 0, 15, 0, 0, 
	0, 0, 0, 0, 0, 0, 733, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 159, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 169, 0, 0, 
	742, 0, 742, 171, 163, 1, 3, 3, 
	905, 3, 905, 261, 0, 0, 0, 0, 
	0, 255, 201, 265, 223, 0, 1, 0, 
	195, 0, 3, 478, 3, 517, 3, 5, 
	547, 829, 547, 976, 547, 0, 7, 550, 
	7, 913, 7, 397, 263, 209, 0, 0, 
	0, 0, 751, 751, 0, 0, 0, 257, 
	0, 0, 17, 676, 0, 1, 0, 17, 
	751, 0, 217, 766, 0, 0, 0, 0, 
	0, 766, 259, 0, 219, 0, 1, 3, 
	520, 3, 287, 0, 275, 0, 0, 351, 
	295, 347, 0, 51, 51, 353, 805, 805, 
	349, 0, 0, 0, 0, 345, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	3, 478, 3, 3, 3, 5, 547, 829, 
	547, 547, 547, 0, 7, 550, 7, 7, 
	7, 917, 397, 291, 371, 0, 823, 0, 
	45, 45, 0, 369, 0, 373, 5, 981, 
	0, 921, 1, 909, 357, 393, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 381, 
	427, 395, 0, 0, 55, 59, 57, 75, 
	73, 0, 1, 0, 0, 51, 51, 0, 
	0, 0, 67, 0, 0, 0, 0, 721, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 724, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	490, 85, 833, 5, 553, 0, 91, 0, 
	0, 0, 83, 0, 87, 69, 0, 0, 
	97, 63, 79, 0, 0, 0, 718, 0, 
	81, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 718, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 77, 0, 0, 0, 0, 61, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 105, 103, 
	0, 0, 51, 51, 0, 107, 837, 5, 
	556, 0, 109, 0, 1, 493, 117, 115, 
	0, 1, 0, 0, 113, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	125, 496, 123, 841, 5, 559, 0, 0, 
	127, 0, 119, 0, 586, 0, 598, 121, 
	143, 141, 736, 1, 0, 733, 0, 0, 
	733, 0, 0, 0, 0, 0, 0, 51, 
	51, 51, 153, 151, 131, 406, 658, 147, 
	730, 0, 149, 133, 145, 137, 403, 646, 
	463, 505, 845, 5, 562, 0, 661, 155, 
	129, 400, 897, 502, 0, 0, 0, 165, 
	51, 51, 167, 664, 0, 739, 177, 175, 
	0, 0, 0, 0, 0, 179, 849, 5, 
	565, 0, 181, 1, 508, 173, 466, 185, 
	183, 0, 1, 0, 748, 0, 0, 0, 
	0, 0, 189, 514, 853, 5, 568, 0, 
	193, 191, 1, 511, 187, 745, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 225, 0, 712, 0, 0, 51, 
	757, 0, 0, 757, 757, 0, 0, 51, 
	772, 0, 772, 0, 772, 772, 772, 0, 
	0, 772, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 769, 0, 0, 249, 523, 
	3, 251, 221, 412, 253, 857, 5, 571, 
	0, 231, 199, 0, 241, 0, 667, 229, 
	757, 227, 0, 243, 0, 245, 409, 197, 
	0, 205, 0, 0, 0, 0, 215, 0, 
	0, 0, 0, 0, 0, 0, 0, 235, 
	207, 203, 0, 682, 19, 0, 19, 237, 
	0, 685, 21, 21, 0, 0, 589, 0, 
	601, 610, 0, 0, 0, 616, 0, 0, 
	634, 640, 628, 622, 0, 0, 233, 679, 
	239, 213, 211, 592, 9, 0, 604, 613, 
	0, 766, 0, 619, 0, 637, 631, 625, 
	0, 0, 649, 1, 247, 25, 25, 769, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 766, 769, 769, 769, 769, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 769, 763, 769, 769, 769, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 760, 688, 929, 933, 23, 23, 760, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 769, 769, 769, 769, 769, 
	769, 769, 769, 469, 754, 269, 267, 0, 
	1, 0, 0, 271, 529, 861, 5, 574, 
	0, 273, 1, 526, 281, 279, 0, 1, 
	277, 0, 51, 0, 283, 535, 865, 5, 
	577, 0, 285, 1, 532, 315, 313, 0, 
	1, 0, 293, 0, 51, 817, 0, 0, 
	0, 0, 307, 0, 0, 799, 799, 0, 
	309, 0, 0, 0, 305, 51, 808, 808, 
	808, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 811, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 820, 341, 541, 337, 301, 869, 5, 
	580, 0, 343, 0, 0, 327, 303, 335, 
	297, 670, 673, 333, 289, 329, 0, 339, 
	0, 415, 323, 0, 0, 966, 881, 37, 
	0, 0, 997, 0, 0, 37, 706, 706, 
	893, 802, 0, 43, 715, 0, 889, 41, 
	448, 0, 451, 454, 0, 0, 460, 457, 
	37, 37, 885, 0, 0, 39, 39, 0, 
	433, 0, 442, 430, 51, 0, 439, 0, 
	445, 436, 956, 33, 33, 700, 700, 0, 
	0, 946, 29, 29, 694, 694, 951, 31, 
	31, 697, 697, 941, 27, 27, 691, 691, 
	0, 0, 961, 877, 937, 991, 35, 703, 
	703, 937, 35, 709, 799, 986, 0, 0, 
	0, 299, 0, 814, 0, 595, 0, 607, 
	643, 325, 808, 808, 808, 796, 808, 652, 
	311, 1, 538, 655, 331, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 793, 0, 0, 0, 0, 796, 0, 
	0, 0, 0, 0, 778, 784, 0, 0, 
	0, 0, 0, 0, 787, 0, 0, 0, 
	0, 0, 784, 321, 319, 0, 775, 0, 
	317, 0, 0, 0, 0, 790, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 781, 
	0, 0, 0, 0, 0, 0, 0, 790, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 472, 475, 
	359, 826, 826, 45, 826, 367, 361, 365, 
	0, 363, 355, 0, 421, 0, 377, 0, 
	0, 0, 375, 418, 385, 383, 0, 1, 
	0, 51, 0, 51, 387, 544, 873, 5, 
	583, 0, 391, 0, 389, 379, 424, 0
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	47, 47, 0, 0, 0, 0, 47, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 47, 
	0, 0, 0, 0, 0, 0, 0, 47, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 47, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 47, 0, 0, 0, 0, 
	0, 47, 0, 0, 0, 0, 0, 0, 
	0, 47, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 47, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 47, 0, 0, 
	0, 0, 0, 0, 47, 0, 0, 0, 
	0, 0, 0, 0, 47, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	47, 0, 0, 0, 0, 0, 0, 0, 
	47, 0, 0, 0, 0, 0, 47, 0, 
	0, 0, 0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	49, 49, 0, 0, 0, 0, 49, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 49, 
	0, 0, 0, 0, 0, 0, 0, 49, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 49, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 49, 0, 0, 0, 0, 
	0, 49, 0, 0, 0, 0, 0, 0, 
	0, 49, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 49, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 49, 0, 0, 
	0, 0, 0, 0, 49, 0, 0, 0, 
	0, 0, 0, 0, 49, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	49, 0, 0, 0, 0, 0, 0, 0, 
	49, 0, 0, 0, 0, 0, 49, 0, 
	0, 0, 0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 0, 0, 0, 0, 9, 11, 13, 
	13, 13, 13, 19, 19, 22, 22, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 94, 100, 
	94, 94, 108, 108, 108, 108, 108, 114, 
	116, 116, 116, 116, 116, 116, 116, 141, 
	141, 141, 141, 141, 152, 116, 116, 152, 
	141, 141, 141, 116, 116, 116, 141, 141, 
	141, 141, 171, 171, 171, 179, 179, 179, 
	184, 186, 186, 186, 190, 190, 193, 193, 
	193, 193, 198, 198, 198, 184, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 229, 
	236, 238, 238, 238, 238, 229, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	0, 0, 261, 261, 262, 263, 0, 304, 
	305, 306, 307, 309, 311, 315, 315, 306, 
	306, 306, 306, 317, 306, 306, 311, 306, 
	306, 321, 323, 323, 323, 323, 323, 323, 
	311, 311, 329, 321, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 362, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 306, 0, 
	406, 407, 409, 411, 411, 411, 414, 0, 
	433, 434, 435, 436, 438, 435, 435, 435, 
	435, 435, 441, 435, 435, 443, 445, 447, 
	441, 441, 448, 435, 0, 467, 468, 22, 
	22, 471, 472, 22, 468, 468, 475, 477, 
	480, 468, 481, 468, 482, 483, 485, 487, 
	468, 475, 488, 488, 477, 488, 492, 488, 
	488, 488, 488, 0, 499, 500, 100, 499, 
	499, 0, 510, 511, 513, 515, 517, 515, 
	519, 0, 531, 532, 533, 535, 537, 538, 
	540, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 0, 599, 600, 602, 605, 606, 608, 
	610, 613, 615, 616, 116, 613, 618, 613, 
	605, 620, 622, 605, 605, 640, 640, 640, 
	640, 640, 640, 640, 640, 640, 640, 644, 
	648, 650, 640, 655, 657, 658, 662, 665, 
	666, 667, 668, 640, 640, 605, 671, 672, 
	671, 671, 605, 605, 605, 673, 116, 676, 
	679, 680, 684, 686, 687, 688, 605, 605, 
	691, 605, 600, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 116, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	747, 680, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 772, 605, 0, 780, 781, 
	782, 784, 786, 788, 0, 797, 798, 799, 
	801, 803, 803, 805, 0, 859, 860, 861, 
	863, 865, 867, 870, 870, 190, 872, 874, 
	875, 876, 872, 878, 880, 880, 883, 883, 
	886, 897, 190, 903, 905, 907, 908, 911, 
	912, 886, 886, 915, 915, 915, 921, 923, 
	924, 927, 929, 930, 931, 915, 915, 938, 
	943, 948, 915, 915, 955, 955, 915, 915, 
	880, 872, 872, 880, 872, 872, 867, 190, 
	974, 976, 977, 978, 978, 978, 978, 978, 
	978, 984, 867, 987, 988, 989, 190, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 1028, 1029, 989, 989, 1033, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 1087, 861, 1088, 
	0, 1094, 1095, 1096, 1098, 1094, 1094, 1094, 
	0, 1103, 1103, 1103, 1103, 1107, 0, 1117, 
	1118, 1119, 1121, 1123, 1125, 1123, 1123
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 128;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 129;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 134;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 247;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 255;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 276;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 307;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 313;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 321;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 345;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 501;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 508;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 516;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 696;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 704;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 710;
class << self
	attr_accessor :lex_en_inside_string
end
self.lex_en_inside_string = 128;


# line 82 "lib/parser/lexer.rl"
  # %

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :context, :command_start

  attr_accessor :tokens, :comments

  attr_reader :paren_nest, :cmdarg_stack, :cond_stack, :lambda_stack, :version

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    @_lex_actions =
      if self.class.respond_to?(:_lex_actions, true)
        self.class.send :_lex_actions
      else
        []
      end

    @emit_integer = lambda { |chars, p| emit(:tINTEGER,   chars); p }
    @emit_rational = lambda { |chars, p| emit(:tRATIONAL,  Rational(chars)); p }
    @emit_imaginary = lambda { |chars, p| emit(:tIMAGINARY, Complex(0, chars)); p }
    @emit_imaginary_rational = lambda { |chars, p| emit(:tIMAGINARY, Complex(0, Rational(chars))); p }
    @emit_integer_re = lambda { |chars, p| emit(:tINTEGER,   chars, @ts, @te - 2); p - 2 }
    @emit_integer_if = lambda { |chars, p| emit(:tINTEGER,   chars, @ts, @te - 2); p - 2 }
    @emit_integer_rescue = lambda { |chars, p| emit(:tINTEGER,   chars, @ts, @te - 6); p - 6 }

    @emit_float = lambda { |chars, p| emit(:tFLOAT,     Float(chars)); p }
    @emit_imaginary_float = lambda { |chars, p| emit(:tIMAGINARY, Complex(0, Float(chars))); p }
    @emit_float_if =     lambda { |chars, p| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p - 2 }
    @emit_float_rescue = lambda { |chars, p| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p - 6 }

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_start = true

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin

    @strings = Parser::LexerStrings.new(self, @version)
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end

    @strings.source_buffer = @source_buffer
    @strings.source_pts = @source_pts
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :inside_string => lex_en_inside_string
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    @strings.dedent_level
  end

  # Return next token: [type, value].
  def advance
    unless @token_queue.empty?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans
    _lex_actions            = @_lex_actions

    pe = @source_pts.size + 2
    p, eof = @p, pe

    cmd_state = @command_start
    @command_start = false

    
# line 8563 "lib/parser/lexer-F0.rb"
begin # ragel flat
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	_trigger_goto = false
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	_acts = _lex_from_state_actions[ @cs]
	_nacts = _lex_actions[_acts]
	_acts += 1
	while _nacts > 0
		_nacts -= 1
		_acts += 1
		case _lex_actions[_acts - 1]
	when 52 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 8598 "lib/parser/lexer-F0.rb"
		end # from state action switch
	end
	if _trigger_goto
		next
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
		_acts = _lex_trans_actions[_trans]
		_nacts = _lex_actions[_acts]
		_acts += 1
		while _nacts > 0
			_nacts -= 1
			_acts += 1
			case _lex_actions[_acts - 1]
	when 0 then
# line 539 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 1 then
# line 673 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_integer 		end
	when 2 then
# line 674 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_rational 		end
	when 3 then
# line 675 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_imaginary 		end
	when 4 then
# line 676 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_imaginary_rational 		end
	when 5 then
# line 677 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_integer_re 		end
	when 6 then
# line 678 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_integer_if 		end
	when 7 then
# line 679 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_integer_rescue 		end
	when 8 then
# line 682 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_float 		end
	when 9 then
# line 683 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_imaginary_float 		end
	when 10 then
# line 684 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_float_if 		end
	when 11 then
# line 688 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_rational 		end
	when 12 then
# line 689 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_imaginary_rational 		end
	when 13 then
# line 690 "lib/parser/lexer.rl"
		begin
 @num_xfrm = @emit_float_rescue 		end
	when 14 then
# line 696 "lib/parser/lexer.rl"
		begin

    e_lbrace
  		end
	when 15 then
# line 700 "lib/parser/lexer.rl"
		begin

    if @strings.close_interp_on_current_literal(p)
      p = p - 1;
       @cs = 128;
      	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    end

    @paren_nest -= 1
  		end
	when 16 then
# line 723 "lib/parser/lexer.rl"
		begin

    p = on_newline(p)
  		end
	when 17 then
# line 733 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 18 then
# line 736 "lib/parser/lexer.rl"
		begin
 emit_comment_from_range(p, pe) 		end
	when 19 then
# line 777 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 20 then
# line 778 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
	when 21 then
# line 783 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 22 then
# line 784 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
	when 23 then
# line 785 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
	when 24 then
# line 786 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
	when 25 then
# line 787 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
	when 26 then
# line 792 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
	when 27 then
# line 797 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
	when 28 then
# line 803 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
	when 29 then
# line 809 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
	when 30 then
# line 816 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
	when 31 then
# line 826 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
	when 32 then
# line 1061 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 33 then
# line 1074 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 1102 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 35 then
# line 1299 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 36 then
# line 1300 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
	when 37 then
# line 1400 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
	when 38 then
# line 1401 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
	when 39 then
# line 1488 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1595 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 41 then
# line 1781 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 42 then
# line 1782 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 43 then
# line 1783 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 44 then
# line 1784 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 45 then
# line 1785 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 46 then
# line 1786 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 47 then
# line 1787 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 48 then
# line 1830 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 49 then
# line 1831 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 50 then
# line 2034 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 53 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 54 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_global_var

         @cs = (stack_pop); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 55 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_global_var

         @cs = (stack_pop); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 56 then
# line 855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_class_var

         @cs = (stack_pop); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 57 then
# line 862 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_instance_var

         @cs = (stack_pop); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 58 then
# line 880 "lib/parser/lexer.rl"
		begin
 @act = 4;		end
	when 59 then
# line 884 "lib/parser/lexer.rl"
		begin
 @act = 5;		end
	when 60 then
# line 888 "lib/parser/lexer.rl"
		begin
 @act = 6;		end
	when 61 then
# line 880 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 62 then
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 63 then
# line 892 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 516; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 129
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 64 then
# line 901 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 65 then
# line 905 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 66 then
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          @strings.push_literal(type, delimiter, @ts)
          	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

        else
          p = @ts - 1
          	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

        end
       end
		end
	when 67 then
# line 925 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 68 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 69 then
# line 880 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 70 then
# line 884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 71 then
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 72 then
# line 892 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 516; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 129
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 73 then
# line 901 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 74 then
# line 908 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 75 then
# line 922 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 76 then
# line 925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 77 then
# line 901 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 78 then
# line 925 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 79 then
# line 1 "NONE"
		begin
	case  @act
	when 4 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 5 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 6 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
end 
			end
	when 80 then
# line 937 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 501; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 81 then
# line 941 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 31 && @context.in_argdef
          emit(:tBDOT3, '...'.freeze)
          # emit(:tNL, "\n".freeze, @te - 1, @te)
           @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
          p -= 3;
          	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

        end
       end
		end
	when 82 then
# line 955 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 83 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 84 then
# line 952 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 85 then
# line 955 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 86 then
# line 955 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 87 then
# line 981 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 276; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 88 then
# line 987 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 89 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 90 then
# line 966 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 91 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 92 then
# line 974 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 93 then
# line 981 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 276; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 94 then
# line 984 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 95 then
# line 987 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 96 then
# line 1065 "lib/parser/lexer.rl"
		begin
 @act = 33;		end
	when 97 then
# line 1075 "lib/parser/lexer.rl"
		begin
 @act = 34;		end
	when 98 then
# line 1114 "lib/parser/lexer.rl"
		begin
 @act = 39;		end
	when 99 then
# line 1119 "lib/parser/lexer.rl"
		begin
 @act = 40;		end
	when 100 then
# line 1047 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 101 then
# line 1065 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        check_ambiguous_slash(tm)

        p = tm - 1
        	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 102 then
# line 1086 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 103 then
# line 1094 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 104 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 105 then
# line 1114 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 106 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 107 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 108 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 109 then
# line 1016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 110 then
# line 1022 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 111 then
# line 1028 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
        @command_start = true
        @paren_nest += 1
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 112 then
# line 1056 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 113 then
# line 1075 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 114 then
# line 1091 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 115 then
# line 1114 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 116 then
# line 1119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 117 then
# line 1122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 118 then
# line 1125 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 119 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 120 then
# line 1119 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 121 then
# line 1128 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 122 then
# line 1 "NONE"
		begin
	case  @act
	when 33 then
	begin begin p = (( @te))-1; end

        check_ambiguous_slash(tm)

        p = tm - 1
        	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end

      end
	when 34 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end

      end
	when 39 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 123 then
# line 1151 "lib/parser/lexer.rl"
		begin
 @act = 46;		end
	when 124 then
# line 1164 "lib/parser/lexer.rl"
		begin
 @act = 47;		end
	when 125 then
# line 1164 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 276
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 126 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 127 then
# line 1141 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 128 then
# line 1164 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 276
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 129 then
# line 1164 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 276
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 130 then
# line 1 "NONE"
		begin
	case  @act
	when 46 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 47 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 276
		_trigger_goto = true
		_goto_level = _again
		break
	end
 end
end 
			end
	when 131 then
# line 1200 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 132 then
# line 1206 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 133 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 134 then
# line 1187 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
        @paren_nest += 1
        @command_start = true
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 135 then
# line 1203 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 136 then
# line 1206 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 137 then
# line 1218 "lib/parser/lexer.rl"
		begin
 @act = 54;		end
	when 138 then
# line 1222 "lib/parser/lexer.rl"
		begin
 @act = 55;		end
	when 139 then
# line 1230 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 140 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 141 then
# line 1222 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 142 then
# line 1224 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 143 then
# line 1227 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 144 then
# line 1230 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 145 then
# line 1 "NONE"
		begin
	case  @act
	when 54 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 55 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
 end
end 
			end
	when 146 then
# line 1245 "lib/parser/lexer.rl"
		begin
 @act = 60;		end
	when 147 then
# line 1348 "lib/parser/lexer.rl"
		begin
 @act = 67;		end
	when 148 then
# line 1442 "lib/parser/lexer.rl"
		begin
 @act = 76;		end
	when 149 then
# line 1483 "lib/parser/lexer.rl"
		begin
 @act = 80;		end
	when 150 then
# line 1489 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 151 then
# line 1495 "lib/parser/lexer.rl"
		begin
 @act = 82;		end
	when 152 then
# line 1586 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 153 then
# line 831 "lib/parser/lexer.rl"
		begin
 @act = 87;		end
	when 154 then
# line 1632 "lib/parser/lexer.rl"
		begin
 @act = 91;		end
	when 155 then
# line 1245 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 156 then
# line 1262 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        @strings.push_literal(type, delimiter, @ts)

        p = p - 1;
        	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 157 then
# line 1272 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts, 1).chr, tok[-1].chr
        @strings.push_literal(type, delimiter, @ts)
        	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 158 then
# line 1280 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        @strings.push_literal(type, delimiter, @ts)
        	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 159 then
# line 1357 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 134
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 160 then
# line 1365 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        @strings.push_literal(type, delimiter, @ts);

        	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 161 then
# line 1375 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 162 then
# line 1389 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        gvar_name = tok(@ts + 1)

        if @version >= 33 && gvar_name.start_with?('$0') && gvar_name.length > 2
          diagnostic :error, :gvar_name, { :name => gvar_name }, range(@ts + 1, @te)
        end

        emit(:tSYMBOL, gvar_name, @ts)
         @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 163 then
# line 1416 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p, next_state = @strings.read_character_constant(@ts)
        p = p - 1; # Ragel will do `p += 1` to consume input, prevent it

        # If strings lexer founds a character constant (?a) emit it,
        # otherwise read ternary operator
        if @token_queue.empty?
          	begin
		 @cs = (next_state)
		_trigger_goto = true
		_goto_level = _again
		break
	end

        else
           @cs = (next_state);
          	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 164 then
# line 1431 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 165 then
# line 1483 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 166 then
# line 1504 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts, 1) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 516;
          else
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 501;
        end

        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 167 then
# line 1542 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_argdef
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 168 then
# line 1597 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 247;
        else
           @cs = 307;
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 169 then
# line 1616 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 710
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 170 then
# line 1632 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 171 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 172 then
# line 1245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 173 then
# line 1252 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 174 then
# line 1287 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 175 then
# line 1301 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 27
          if delimiter.count("\n") > 0 || delimiter.count("\r") > 0
            diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
          end
        elsif @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
          @strings.push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body);
          @strings.herebody_s ||= new_herebody_s

          p = @strings.herebody_s - 1
           @cs = 128;
        end
       end
		end
	when 176 then
# line 1348 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 177 then
# line 1381 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 178 then
# line 1389 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        gvar_name = tok(@ts + 1)

        if @version >= 33 && gvar_name.start_with?('$0') && gvar_name.length > 2
          diagnostic :error, :gvar_name, { :name => gvar_name }, range(@ts + 1, @te)
        end

        emit(:tSYMBOL, gvar_name, @ts)
         @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 179 then
# line 1403 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_colon_with_digits(p, tm, diag_msg)

         @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 180 then
# line 1431 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 181 then
# line 1459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          @command_start = true
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        @paren_nest += 1
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 182 then
# line 1473 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 183 then
# line 1478 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 184 then
# line 1483 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 185 then
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 321; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 186 then
# line 1531 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 187 then
# line 1542 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_argdef
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 188 then
# line 1586 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 189 then
# line 831 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    elsif @version >= 32 && tok =~ /\A_[1-9]\z/
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    end
   end
		end
	when 190 then
# line 1613 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 191 then
# line 1616 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 710
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 192 then
# line 1632 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 193 then
# line 1287 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 194 then
# line 1348 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 195 then
# line 831 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    elsif @version >= 32 && tok =~ /\A_[1-9]\z/
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    end
   end
		end
	when 196 then
# line 1613 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 197 then
# line 1632 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 198 then
# line 1 "NONE"
		begin
	case  @act
	when 60 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 516; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 67 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 76 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
          p -= 2
          	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

        end
      end
	when 80 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 81 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 321; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 82 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 86 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
 end
	when 87 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    elsif @version >= 32 && tok =~ /\A_[1-9]\z/
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    end
  end
	when 91 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
 end
end 
			end
	when 199 then
# line 1652 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 200 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 201 then
# line 1640 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 202 then
# line 1643 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @context.in_kwarg
        p = p - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end

      else
        	begin
		 @cs = 710
		_trigger_goto = true
		_goto_level = _again
		break
	end

      end
     end
		end
	when 203 then
# line 1652 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 204 then
# line 1662 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 205 then
# line 1667 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        @strings.push_literal(tok, tok, @ts)
        	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 206 then
# line 1678 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 207 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 208 then
# line 1672 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 209 then
# line 1675 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 710
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 210 then
# line 1678 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 211 then
# line 1678 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 345
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 212 then
# line 1697 "lib/parser/lexer.rl"
		begin
 @act = 104;		end
	when 213 then
# line 1726 "lib/parser/lexer.rl"
		begin
 @act = 105;		end
	when 214 then
# line 1730 "lib/parser/lexer.rl"
		begin
 @act = 106;		end
	when 215 then
# line 1735 "lib/parser/lexer.rl"
		begin
 @act = 107;		end
	when 216 then
# line 1740 "lib/parser/lexer.rl"
		begin
 @act = 108;		end
	when 217 then
# line 1745 "lib/parser/lexer.rl"
		begin
 @act = 109;		end
	when 218 then
# line 1749 "lib/parser/lexer.rl"
		begin
 @act = 110;		end
	when 219 then
# line 1760 "lib/parser/lexer.rl"
		begin
 @act = 111;		end
	when 220 then
# line 1774 "lib/parser/lexer.rl"
		begin
 @act = 112;		end
	when 221 then
# line 1788 "lib/parser/lexer.rl"
		begin
 @act = 113;		end
	when 222 then
# line 1806 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 223 then
# line 1818 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 224 then
# line 1833 "lib/parser/lexer.rl"
		begin
 @act = 117;		end
	when 225 then
# line 1862 "lib/parser/lexer.rl"
		begin
 @act = 119;		end
	when 226 then
# line 831 "lib/parser/lexer.rl"
		begin
 @act = 123;		end
	when 227 then
# line 1884 "lib/parser/lexer.rl"
		begin
 @act = 124;		end
	when 228 then
# line 1910 "lib/parser/lexer.rl"
		begin
 @act = 126;		end
	when 229 then
# line 1916 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 230 then
# line 1689 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 231 then
# line 1730 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_singleton_class
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 232 then
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        @strings.push_literal(type, delimiter, @ts, nil, false, false, true);
        	begin
		 @cs = 128
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 233 then
# line 1870 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 129
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 234 then
# line 1877 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 255; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 235 then
# line 1901 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 236 then
# line 1910 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 237 then
# line 1937 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 238 then
# line 1941 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 239 then
# line 1949 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @paren_nest == 0
          diagnostic :warning, :triple_dot_at_eol, nil, range(@ts, @te - 1)
        end

        emit(:tDOT3, '...'.freeze, @ts, @te - 1)
        p = p - 1;
         @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 240 then
# line 1960 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 241 then
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
           @command_start = true
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 242 then
# line 1977 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 243 then
# line 1983 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 244 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 245 then
# line 1697 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 246 then
# line 1726 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 134; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 247 then
# line 1730 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_singleton_class
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 248 then
# line 1740 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
           @command_start = true
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 249 then
# line 1788 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = numeric_literal_int

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          p = @num_xfrm.call(digits.to_i(@num_base), p)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 250 then
# line 1801 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 251 then
# line 1833 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          p = @num_xfrm.call(digits, p)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 252 then
# line 1862 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 253 then
# line 1866 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 254 then
# line 1870 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 129
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 255 then
# line 1877 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 255; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 256 then
# line 831 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    elsif @version >= 32 && tok =~ /\A_[1-9]\z/
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    end
   end
		end
	when 257 then
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 276; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 258 then
# line 1901 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 259 then
# line 1910 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 260 then
# line 1916 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 261 then
# line 1920 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_rbrace_rparen_rbrack

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 516;
          else
             @cs = 313;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 262 then
# line 1945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 263 then
# line 1960 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 264 then
# line 1967 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 265 then
# line 1970 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 696
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 266 then
# line 1983 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 267 then
# line 1788 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = numeric_literal_int

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          p = @num_xfrm.call(digits.to_i(@num_base), p)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 268 then
# line 1801 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 269 then
# line 1833 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          p = @num_xfrm.call(digits, p)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
	when 270 then
# line 1983 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 271 then
# line 1 "NONE"
		begin
	case  @act
	when 104 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 105 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 134; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 106 then
	begin begin p = (( @te))-1; end
 emit_singleton_class
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 107 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 108 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 109 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 321; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 110 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
           @cs = 276; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
      end
	when 111 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 112 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 113 then
	begin begin p = (( @te))-1; end

        digits = numeric_literal_int

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          p = @num_xfrm.call(digits.to_i(@num_base), p)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 115 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
      end
	when 116 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
      end
	when 117 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          p = @num_xfrm.call(digits, p)
        end
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 119 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    elsif @version >= 32 && tok =~ /\A_[1-9]\z/
       @cs = 247; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

    end
  end
	when 124 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 276; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 126 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 508; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

      end
	when 127 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
end 
			end
	when 272 then
# line 1999 "lib/parser/lexer.rl"
		begin
 @act = 140;		end
	when 273 then
# line 2038 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 274 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
          emit(:tBDOT3)
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 275 then
# line 2035 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 276 then
# line 2038 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 277 then
# line 1999 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 278 then
# line 2013 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        else
          emit(:tBDOT2)
           @cs = 345; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 279 then
# line 2035 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = tm - 1; 	begin
		 @cs = 516
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 280 then
# line 2038 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 281 then
# line 1999 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
       end
		end
	when 282 then
# line 2038 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
  end
		end
	when 283 then
# line 1 "NONE"
		begin
	case  @act
	when 140 then
	begin begin p = (( @te))-1; end

        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end
 emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 710; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end
 end
end 
			end
	when 284 then
# line 2048 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 285 then
# line 2053 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 286 then
# line 2048 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_trigger_goto = true
		_goto_level = _again
		break
	end

       end
		end
	when 287 then
# line 2056 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 288 then
# line 2066 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 704
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 289 then
# line 2070 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 290 then
# line 2073 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 508
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 291 then
# line 566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

   end
		end
	when 292 then
# line 2063 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 293 then
# line 2066 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 704
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 294 then
# line 2073 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 508
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 295 then
# line 2073 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 508
		_trigger_goto = true
		_goto_level = _again
		break
	end
  end
		end
	when 296 then
# line 2080 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p, next_state = @strings.advance(p)

        p = p - 1; # Ragel will do `p += 1` to consume input, prevent it
         @cs = (next_state);
        	begin
		p += 1
		_trigger_goto = true
		_goto_level = _out
		break
	end

       end
		end
# line 12616 "lib/parser/lexer-F0.rb"
			end # action switch
		end
	end
	if _trigger_goto
		next
	end
	end
	if _goto_level <= _again
	_acts = _lex_to_state_actions[ @cs]
	_nacts = _lex_actions[_acts]
	_acts += 1
	while _nacts > 0
		_nacts -= 1
		_acts += 1
		case _lex_actions[_acts - 1]
	when 51 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 12636 "lib/parser/lexer-F0.rb"
		end # to state action switch
	end
	if _trigger_goto
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end
	end
	if _goto_level <= _out
		break
	end
	end
	end

# line 281 "lib/parser/lexer.rl"
    # %

    # Ragel creates a local variable called `testEof` but it doesn't use
    # it in any assignment. This dead code is here to swallow the warning.
    # It has no runtime cost because Ruby doesn't produce any instructions from it.
    if false
      testEof
    end

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s, e - s)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg(cmd_state)
    if cmd_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def emit_comment_from_range(p, pe)
    emit_comment(@sharp_s, p == pe ? p - 2 : p)
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end


  def e_lbrace
    @cond.push(false); @cmdarg.push(false)

    current_literal = @strings.literal
    if current_literal
      current_literal.start_interp_brace
    end
  end

  def numeric_literal_int
    digits = tok(@num_digits_s, @num_suffix_s)

    if digits.end_with? '_'.freeze
      diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                 range(@te - 1, @te)
    elsif digits.empty? && @num_base == 8 && version?(18)
      # 1.8 did not raise an error on 0o.
      digits = '0'.freeze
    elsif digits.empty?
      diagnostic :error, :empty_numeric
    elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
      invalid_s = @num_digits_s + invalid_idx
      diagnostic :error, :invalid_octal, nil,
                 range(invalid_s, invalid_s + 1)
    end
    digits
  end

  def on_newline(p)
    @strings.on_newline(p)
  end

  def check_ambiguous_slash(tm)
    if tok(tm, tm + 1) == '/'.freeze
      # Ambiguous regexp literal.
      if @version < 30
        diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
      else
        diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
      end
    end
  end

  def emit_global_var(ts = @ts, te = @te)
    if tok(ts, te) =~ /^\$([1-9][0-9]*)$/
      emit(:tNTH_REF, tok(ts + 1, te).to_i, ts, te)
    elsif tok =~ /^\$([&`'+])$/
      emit(:tBACK_REF, tok(ts, te), ts, te)
    else
      emit(:tGVAR, tok(ts, te), ts, te)
    end
  end

  def emit_class_var(ts = @ts, te = @te)
    if tok(ts, te) =~ /^@@[0-9]/
      diagnostic :error, :cvar_name, { :name => tok(ts, te) }
    end

    emit(:tCVAR, tok(ts, te), ts, te)
  end

  def emit_instance_var(ts = @ts, te = @te)
    if tok(ts, te) =~ /^@[0-9]/
      diagnostic :error, :ivar_name, { :name => tok(ts, te) }
    end

    emit(:tIVAR, tok(ts, te), ts, te)
  end

  def emit_rbrace_rparen_rbrack
    emit_table(PUNCTUATION)

    if @version < 24
      @cond.lexpop
      @cmdarg.lexpop
    else
      @cond.pop
      @cmdarg.pop
    end
  end

  def emit_colon_with_digits(p, tm, diag_msg)
    if @version >= 27
      diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
    else
      emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
      p = @ts
    end
    p
  end

  def emit_singleton_class
    emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
    emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  ESCAPE_WHITESPACE = {
    " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
    "\v" => '\v', "\f" => '\f'
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2089 "lib/parser/lexer.rl"

  # %
end
