/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class ResizeAtom
extends Atom {
    private Atom base;
    private int wunit;
    private int hunit;
    private float w;
    private float h;
    private boolean keepaspectratio;

    public ResizeAtom(Atom base, String ws, String hs, boolean keepaspectratio) {
        this.type = base.type;
        this.base = base;
        this.keepaspectratio = keepaspectratio;
        float[] w = SpaceAtom.getLength(ws == null ? "" : ws);
        float[] h2 = SpaceAtom.getLength(hs == null ? "" : hs);
        if (w.length != 2) {
            this.wunit = -1;
        } else {
            this.wunit = (int)w[0];
            this.w = w[1];
        }
        if (h2.length != 2) {
            this.hunit = -1;
        } else {
            this.hunit = (int)h2[0];
            this.h = h2[1];
        }
    }

    @Override
    public int getLeftType() {
        return this.base.getLeftType();
    }

    @Override
    public int getRightType() {
        return this.base.getRightType();
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box bbox = this.base.createBox(env);
        if (this.wunit == -1 && this.hunit == -1) {
            return bbox;
        }
        double xscl = 1.0;
        double yscl = 1.0;
        if (this.wunit != -1 && this.hunit != -1) {
            xscl = this.w * SpaceAtom.getFactor(this.wunit, env) / bbox.width;
            yscl = this.h * SpaceAtom.getFactor(this.hunit, env) / bbox.height;
            if (this.keepaspectratio) {
                yscl = xscl = Math.min(xscl, yscl);
            }
        } else if (this.wunit != -1 && this.hunit == -1) {
            yscl = xscl = (double)(this.w * SpaceAtom.getFactor(this.wunit, env) / bbox.width);
        } else {
            xscl = yscl = (double)(this.h * SpaceAtom.getFactor(this.hunit, env) / bbox.height);
        }
        return new ScaleBox(bbox, xscl, yscl);
    }
}

