/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.components;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.compaction.components.ComponentsToCGraphTransformer;
import org.eclipse.elk.alg.layered.compaction.components.IComponent;
import org.eclipse.elk.alg.layered.compaction.components.IConnectedComponents;
import org.eclipse.elk.alg.layered.compaction.components.IExternalExtension;
import org.eclipse.elk.alg.layered.compaction.oned.CGraph;
import org.eclipse.elk.alg.layered.compaction.oned.CGroup;
import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class OneDimensionalComponentsCompaction<N, E> {
    private CGraph compactionGraph;
    private ComponentsToCGraphTransformer<N, E> transformer;
    private List<Pair<CGroup, CNode>> verticalExternalExtensions;
    private List<Pair<CGroup, CNode>> horizontalExternalExtensions;
    private OneDimensionalCompactor compactor;
    private KVector topLeft;
    private KVector bottomRight;
    private static final int MAX_ITERATION = 10;
    private static final double EPSILON = 1.0E-4;
    private static final Set<Direction> LEFT_RIGHT = Sets.newHashSet(Direction.LEFT, Direction.RIGHT);
    private static final Set<Direction> UP_DOWN = Sets.newHashSet(Direction.UP, Direction.DOWN);

    private OneDimensionalComponentsCompaction() {
    }

    public static <N, E> OneDimensionalComponentsCompaction<N, E> init(IConnectedComponents<N, E> ccs, double spacing) {
        OneDimensionalComponentsCompaction<N, E> compaction = new OneDimensionalComponentsCompaction<N, E>();
        compaction.transformer = new ComponentsToCGraphTransformer(spacing);
        compaction.compactionGraph = compaction.transformer.transform(ccs);
        return compaction;
    }

    public void compact(IElkProgressMonitor monitor) {
        double delta;
        ArrayList<CNode> allNodes = Lists.newArrayList();
        this.verticalExternalExtensions = Lists.newArrayList();
        this.horizontalExternalExtensions = Lists.newArrayList();
        for (Map.Entry<IExternalExtension<E>, Pair<CGroup, CNode>> entry : this.transformer.getExternalExtensions().entrySet()) {
            allNodes.add(entry.getValue().getSecond());
            if (entry.getKey().getDirection().isHorizontal()) {
                this.horizontalExternalExtensions.add(entry.getValue());
                continue;
            }
            this.verticalExternalExtensions.add(entry.getValue());
        }
        this.addExternalEdgeRepresentations(this.horizontalExternalExtensions);
        this.addExternalEdgeRepresentations(this.verticalExternalExtensions);
        this.compactor = new OneDimensionalCompactor(this.compactionGraph);
        this.compactor.setSpacingsHandler(ComponentsToCGraphTransformer.SPACING_HANDLER);
        this.removeExternalEdgeRepresentations(this.horizontalExternalExtensions);
        this.removeExternalEdgeRepresentations(this.verticalExternalExtensions);
        allNodes.addAll(this.compactor.cGraph.cNodes);
        this.topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (CNode cNode : allNodes) {
            this.topLeft.x = Math.min(this.topLeft.x, cNode.hitbox.x);
            this.topLeft.y = Math.min(this.topLeft.y, cNode.hitbox.y);
            this.bottomRight.x = Math.max(this.bottomRight.x, cNode.hitbox.x + cNode.hitbox.width);
            this.bottomRight.y = Math.max(this.bottomRight.y, cNode.hitbox.y + cNode.hitbox.height);
        }
        this.compactor.setLockingStrategy(pair -> ((CNode)pair.getFirst()).cGroup.outDegree != 0);
        int run = 0;
        do {
            delta = this.compact(run);
        } while ((++run < 2 || delta > 1.0E-4) && run < 10);
        this.compactor.setLockingStrategy(pair -> ((CNode)pair.getFirst()).lock.get((Direction)((Object)((Object)pair.getSecond()))) || ((CNode)pair.getFirst()).cGroup.outDegree != 0 && ((CNode)pair.getFirst()).lock.get((Direction)((Object)((Object)pair.getSecond()))));
        this.compact(0);
        this.compactor.finish();
        this.transformer.applyLayout();
    }

    private double compact(int run) {
        double delta = 0.0;
        for (CGroup g2 : this.compactionGraph.cGroups) {
            g2.delta = 0.0;
            g2.deltaNormalized = 0.0;
        }
        this.addPlaceholders(Dir.HORZ);
        this.addExternalEdgeRepresentations(this.verticalExternalExtensions);
        this.compactor.calculateGroupOffsets();
        this.compactor.forceConstraintsRecalculation();
        Direction direction = Direction.LEFT;
        this.compactor.changeDirection(direction).compact().changeDirection(direction.opposite()).applyLockingStrategy().compact().changeDirection(direction).applyLockingStrategy().compact();
        this.compactor.changeDirection(Direction.LEFT);
        this.removeExternalEdgeRepresentations(this.verticalExternalExtensions);
        this.removePlaceholders(Dir.HORZ);
        this.updateExternalExtensionDimensions(Dir.HORZ);
        this.updatePlaceholders(Dir.VERT);
        this.addPlaceholders(Dir.VERT);
        this.addExternalEdgeRepresentations(this.horizontalExternalExtensions);
        this.compactor.calculateGroupOffsets();
        for (CGroup g3 : this.compactionGraph.cGroups) {
            delta += Math.abs(g3.deltaNormalized);
        }
        for (CGroup g3 : this.compactionGraph.cGroups) {
            g3.delta = 0.0;
            g3.deltaNormalized = 0.0;
        }
        direction = Direction.UP;
        this.compactor.changeDirection(direction).forceConstraintsRecalculation().compact().changeDirection(direction.opposite()).applyLockingStrategy().compact().changeDirection(direction).applyLockingStrategy().compact();
        this.compactor.changeDirection(Direction.LEFT);
        this.removeExternalEdgeRepresentations(this.horizontalExternalExtensions);
        this.removePlaceholders(Dir.VERT);
        this.updateExternalExtensionDimensions(Dir.VERT);
        this.updatePlaceholders(Dir.HORZ);
        this.compactor.forceConstraintsRecalculation();
        for (CGroup g3 : this.compactionGraph.cGroups) {
            delta += Math.abs(g3.deltaNormalized);
        }
        return delta;
    }

    public KVector getGraphSize() {
        return this.transformer.getGraphSize();
    }

    public KVector getOffset(IComponent<N, E> c) {
        KVector individual = this.transformer.getOffset(c);
        return individual.negate().add(this.transformer.getGlobalOffset());
    }

    private void addExternalEdgeRepresentations(List<Pair<CGroup, CNode>> ees) {
        for (Pair<CGroup, CNode> p : ees) {
            this.compactionGraph.cNodes.add(p.getSecond());
            p.getFirst().addCNode(p.getSecond());
        }
    }

    private void removeExternalEdgeRepresentations(List<Pair<CGroup, CNode>> ees) {
        for (Pair<CGroup, CNode> p : ees) {
            this.compactionGraph.cNodes.remove(p.getSecond());
            p.getFirst().removeCNode(p.getSecond());
        }
    }

    private void addPlaceholders(Dir dir) {
        Set<Direction> dirs = dir == Dir.VERT ? UP_DOWN : LEFT_RIGHT;
        for (Direction d : dirs) {
            for (Pair<CGroup, CNode> pair : this.transformer.getExternalPlaceholder().get(d)) {
                this.compactionGraph.cNodes.add(pair.getSecond());
                this.compactionGraph.cGroups.add(pair.getSecond().cGroup);
            }
        }
    }

    private void removePlaceholders(Dir dir) {
        Set<Direction> dirs = dir == Dir.VERT ? UP_DOWN : LEFT_RIGHT;
        for (Direction d : dirs) {
            for (Pair<CGroup, CNode> pair : this.transformer.getExternalPlaceholder().get(d)) {
                this.compactionGraph.cNodes.remove(pair.getSecond());
                this.compactionGraph.cGroups.remove(pair.getSecond().cGroup);
            }
        }
    }

    private void updatePlaceholders(Dir dir) {
        Set<Direction> dirs = dir == Dir.VERT ? UP_DOWN : LEFT_RIGHT;
        for (Direction d : dirs) {
            for (Pair<CGroup, CNode> pair : this.transformer.getExternalPlaceholder().get(d)) {
                CNode cNode = pair.getSecond();
                CGroup parentComponentGroup = pair.getFirst();
                double adelta = parentComponentGroup.deltaNormalized;
                switch (d) {
                    case RIGHT: 
                    case LEFT: {
                        cNode.hitbox.y += adelta;
                        break;
                    }
                    case DOWN: 
                    case UP: {
                        cNode.hitbox.x += adelta;
                    }
                }
            }
        }
    }

    private void updateExternalExtensionDimensions(Dir dir) {
        for (Map.Entry<IExternalExtension<E>, Pair<CGroup, CNode>> entry : this.transformer.getExternalExtensions().entrySet()) {
            IExternalExtension<E> ee = entry.getKey();
            if (dir == Dir.VERT ? ee.getDirection() != Direction.UP && ee.getDirection() != Direction.DOWN : ee.getDirection() != Direction.LEFT && ee.getDirection() != Direction.RIGHT) continue;
            CNode cNode = entry.getValue().getSecond();
            CGroup group = entry.getValue().getFirst();
            double adelta = group.deltaNormalized;
            switch (ee.getDirection()) {
                case LEFT: {
                    cNode.hitbox.x = this.topLeft.x;
                    cNode.hitbox.width = Math.max(1.0, cNode.hitbox.width + adelta);
                    break;
                }
                case RIGHT: {
                    cNode.hitbox.x += adelta;
                    cNode.hitbox.width = Math.max(1.0, cNode.hitbox.width - adelta);
                    break;
                }
                case UP: {
                    cNode.hitbox.y = this.topLeft.y;
                    cNode.hitbox.height = Math.max(1.0, cNode.hitbox.height + adelta);
                    break;
                }
                case DOWN: {
                    cNode.hitbox.y += adelta;
                    cNode.hitbox.height = Math.max(1.0, cNode.hitbox.height - adelta);
                }
            }
        }
    }

    private static enum Dir {
        HORZ,
        VERT;

    }
}

