/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sourceforge.plantuml.code.Upf9Decoder;
import net.sourceforge.plantuml.log.Logme;

public class Upf9Encoder {
    private Upf9Encoder() {
    }

    public static byte[] encodeChar(char c) {
        byte[] result = Upf9Encoder.encodeCharInternal(c);
        assert (Upf9Encoder.checkBack(c, result));
        return result;
    }

    private static boolean checkBack(char c, byte[] result) {
        try {
            if (c == Upf9Decoder.decodeChar(new ByteArrayInputStream(result))) {
                return true;
            }
        }
        catch (IOException e) {
            Logme.error(e);
        }
        return false;
    }

    private static byte[] encodeCharInternal(char c) {
        if (c == '\n' || c == '\r' || c == '\t') {
            return new byte[]{(byte)c};
        }
        if (c >= '\u000e' && c <= '\u0012') {
            return new byte[]{(byte)c};
        }
        if (c >= ' ' && c <= '~') {
            return new byte[]{(byte)c};
        }
        if (c >= '\u0080' && c <= '\u00ff') {
            return new byte[]{11, (byte)c};
        }
        if (c >= '\u0100' && c <= '\u08ff') {
            return new byte[]{Upf9Encoder.highByte(c), Upf9Encoder.lowByte(c)};
        }
        if (c >= '\u2000' && c <= '\u9fff') {
            return new byte[]{(byte)(96 + Upf9Encoder.highByte(c)), Upf9Encoder.lowByte(c)};
        }
        if (c >= '\ue000' && c <= '\ue07f') {
            return new byte[]{11, Upf9Encoder.lowByte(c)};
        }
        return new byte[]{12, Upf9Encoder.highByte(c), Upf9Encoder.lowByte(c)};
    }

    private static byte lowByte(char c) {
        return (byte)(c & 0xFF);
    }

    private static byte highByte(char c) {
        return (byte)((c & 0xFF00) >> 8);
    }

    public static byte[] getBytes(String s2) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < s2.length(); ++i) {
            baos.write(Upf9Encoder.encodeChar(s2.charAt(i)));
        }
        baos.close();
        byte[] result = baos.toByteArray();
        assert (s2.endsWith(Upf9Decoder.decodeString(result, result.length)));
        return result;
    }
}

