/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Properties;
import jcckit.graphic.BasicGraphicAttributes;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.ShapeAttributes;
import jcckit.graphic.TextAttributes;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.ConfigParametersBasedConfigData;
import jcckit.util.Factory;
import jcckit.util.Format;
import jcckit.util.PropertiesBasedConfigData;
import jcckit.util.TicLabelFormat;
import jcckit.util.Util;

public class AxisParameters {
    public static final String LOG_SCALE_KEY = "logScale";
    public static final String MINIMUM_KEY = "minimum";
    public static final String MAXIMUM_KEY = "maximum";
    public static final String AXIS_LENGTH_KEY = "axisLength";
    public static final String AXIS_ATTRIBUTES_KEY = "axisAttributes";
    public static final String AXIS_LABEL_KEY = "axisLabel";
    public static final String AXIS_LABEL_POSITION_KEY = "axisLabelPosition";
    public static final String AXIS_LABEL_ATTRIBUTES_KEY = "axisLabelAttributes";
    public static final String AUTOMATIC_TIC_CALCULATION_KEY = "automaticTicCalculation";
    public static final String MINIMUM_TIC_KEY = "minimumTic";
    public static final String MAXIMUM_TIC_KEY = "maximumTic";
    public static final String NUMBER_OF_TICS_KEY = "numberOfTics";
    public static final String TIC_LENGTH_KEY = "ticLength";
    public static final String TIC_ATTRIBUTES_KEY = "ticAttributes";
    public static final String TIC_LABEL_FORMAT_KEY = "ticLabelFormat";
    public static final String TIC_LABEL_POSITION_KEY = "ticLabelPosition";
    public static final String TIC_LABEL_ATTRIBUTES_KEY = "ticLabelAttributes";
    public static final String GRID_KEY = "grid";
    public static final String GRID_ATTRIBUTES_KEY = "gridAttributes";
    private static final double LN10 = Math.log(10.0);
    boolean logScale;
    double minimum;
    double maximum;
    double axisLength;
    LineAttributes axisAttributes;
    boolean automaticTicCalculation;
    double minimumTic;
    double maximumTic;
    int numberOfTics;
    double ticLength;
    LineAttributes ticAttributes;
    TicLabelFormat ticLabelFormat;
    GraphPoint ticLabelPosition;
    TextAttributes ticLabelAttributes;
    boolean grid;
    LineAttributes gridAttributes;
    String axisLabel;
    GraphPoint axisLabelPosition;
    TextAttributes axisLabelAttributes;

    double[] calculateTics() {
        if (this.automaticTicCalculation) {
            this.calculateTicsParameters();
        }
        double[] result = new double[this.numberOfTics];
        if (this.numberOfTics > 0) {
            double b = Util.log(this.minimumTic, this.logScale);
            double a = Util.log(this.maximumTic, this.logScale);
            a = this.numberOfTics > 1 ? (a - b) / (double)(this.numberOfTics - 1) : 0.0;
            for (int i = 0; i < result.length; ++i) {
                result[i] = Util.exp(a * (double)i + b, this.logScale);
            }
            result[0] = AxisParameters.adjust(this.minimum, result[0]);
            result[this.numberOfTics - 1] = AxisParameters.adjust(this.maximum, result[this.numberOfTics - 1]);
        }
        return result;
    }

    private void calculateTicsParameters() {
        double min2 = Math.min(this.minimum, this.maximum);
        double max = Math.max(this.minimum, this.maximum);
        if (this.logScale) {
            int minExponent = (int)(199.9999 + Math.log(min2) / LN10) - 199;
            int maxExponent = (int)(200.0001 + Math.log(max) / LN10) - 200;
            this.minimumTic = Math.exp(LN10 * (double)minExponent);
            this.maximumTic = Math.exp(LN10 * (double)maxExponent);
            this.numberOfTics = maxExponent - minExponent + 1;
        } else {
            int baseExponent = (int)(199.69 + Math.log(max - min2) / LN10) - 200;
            double base = 0.2 * Math.exp(LN10 * (double)baseExponent);
            do {
                int minInt = (int)(999999.999999 + min2 / (base *= 5.0)) - 999999;
                int maxInt = (int)(1000000.000001 + max / base) - 1000000;
                this.minimumTic = (double)minInt * base;
                this.maximumTic = (double)maxInt * base;
                this.numberOfTics = maxInt - minInt + 1;
            } while (this.numberOfTics > 11);
        }
    }

    private static double adjust(double adjustingValue, double value) {
        return value != 0.0 && Math.abs(adjustingValue / value - 1.0) < 1.0E-11 ? adjustingValue : value;
    }

    private static Properties createDefaultAxisProperties() {
        Properties p = new Properties();
        p.put(LOG_SCALE_KEY, "false");
        p.put(MINIMUM_KEY, "0");
        p.put(MAXIMUM_KEY, "1");
        p.put(AXIS_LENGTH_KEY, "0.8");
        p.put("axisAttributes/className", ShapeAttributes.class.getName());
        p.put(AXIS_LABEL_KEY, "x");
        p.put(AXIS_LABEL_POSITION_KEY, "0 -0.05");
        p.put("axisLabelAttributes/className", BasicGraphicAttributes.class.getName());
        p.put("axisLabelAttributes/horizontalAnchor", "center");
        p.put(AUTOMATIC_TIC_CALCULATION_KEY, "true");
        p.put(TIC_LENGTH_KEY, "0.01");
        p.put("ticAttributes/className", ShapeAttributes.class.getName());
        p.put(TIC_LABEL_POSITION_KEY, "0 -0.01");
        p.put(TIC_LABEL_FORMAT_KEY, "%1.1f");
        p.put("ticLabelAttributes/className", BasicGraphicAttributes.class.getName());
        p.put("ticLabelAttributes/horizontalAnchor", "center");
        p.put("ticLabelAttributes/verticalAnchor", "top");
        p.put(GRID_KEY, "false");
        p.put("gridAttributes/className", ShapeAttributes.class.getName());
        return p;
    }

    private static Properties createDefaultXAxisProperties() {
        Properties p = AxisParameters.createDefaultAxisProperties();
        p.put(AXIS_LABEL_KEY, "x");
        p.put(AXIS_LABEL_POSITION_KEY, "0 -0.05");
        p.put("axisLabelAttributes/verticalAnchor", "top");
        p.put(TIC_LABEL_POSITION_KEY, "0 -0.01");
        p.put("ticLabelAttributes/horizontalAnchor", "center");
        p.put("ticLabelAttributes/verticalAnchor", "top");
        return p;
    }

    public static AxisParameters createXAxis(ConfigParameters config) {
        return AxisParameters.createAxis(config, AxisParameters.createDefaultXAxisProperties());
    }

    private static Properties createDefaultYAxisProperties() {
        Properties p = AxisParameters.createDefaultAxisProperties();
        p.put(AXIS_LENGTH_KEY, "0.45");
        p.put(AXIS_LABEL_KEY, "y");
        p.put(AXIS_LABEL_POSITION_KEY, "-0.1 0");
        p.put("axisLabelAttributes/verticalAnchor", "bottom");
        p.put("axisLabelAttributes/orientationAngle", "90");
        p.put(TIC_LABEL_POSITION_KEY, "-0.01 0");
        p.put("ticLabelAttributes/horizontalAnchor", "right");
        p.put("ticLabelAttributes/verticalAnchor", "center");
        return p;
    }

    public static AxisParameters createYAxis(ConfigParameters config) {
        return AxisParameters.createAxis(config, AxisParameters.createDefaultYAxisProperties());
    }

    private static AxisParameters createAxis(ConfigParameters config, Properties p) {
        ConfigData cd2 = new PropertiesBasedConfigData(p);
        ConfigParameters c = new ConfigParameters(cd2);
        cd2 = new ConfigParametersBasedConfigData(config, c);
        c = new ConfigParameters(cd2);
        AxisParameters a = new AxisParameters();
        a.logScale = c.getBoolean(LOG_SCALE_KEY);
        a.minimum = c.getDouble(MINIMUM_KEY);
        a.maximum = c.getDouble(MAXIMUM_KEY);
        a.axisLength = c.getDouble(AXIS_LENGTH_KEY);
        a.axisAttributes = (LineAttributes)Factory.create(c.getNode(AXIS_ATTRIBUTES_KEY));
        a.axisLabel = c.get(AXIS_LABEL_KEY);
        a.axisLabelPosition = new GraphPoint(c.getDoubleArray(AXIS_LABEL_POSITION_KEY));
        a.axisLabelAttributes = (TextAttributes)Factory.create(c.getNode(AXIS_LABEL_ATTRIBUTES_KEY));
        a.ticLength = c.getDouble(TIC_LENGTH_KEY);
        a.automaticTicCalculation = c.getBoolean(AUTOMATIC_TIC_CALCULATION_KEY);
        if (!a.automaticTicCalculation) {
            a.calculateTicsParameters();
            a.minimumTic = c.getDouble(MINIMUM_TIC_KEY, a.minimumTic);
            a.maximumTic = c.getDouble(MAXIMUM_TIC_KEY, a.maximumTic);
            a.numberOfTics = c.getInt(NUMBER_OF_TICS_KEY, a.numberOfTics);
        }
        a.ticAttributes = (LineAttributes)Factory.create(c.getNode(TIC_ATTRIBUTES_KEY));
        a.ticLabelFormat = AxisParameters.createTicLabelFormat(c);
        a.ticLabelPosition = new GraphPoint(c.getDoubleArray(TIC_LABEL_POSITION_KEY));
        a.ticLabelAttributes = (TextAttributes)Factory.create(c.getNode(TIC_LABEL_ATTRIBUTES_KEY));
        a.grid = c.getBoolean(GRID_KEY);
        a.gridAttributes = (LineAttributes)Factory.create(c.getNode(GRID_ATTRIBUTES_KEY));
        return a;
    }

    private static TicLabelFormat createTicLabelFormat(ConfigParameters c) {
        TicLabelFormat result = Format.create(c, TIC_LABEL_FORMAT_KEY);
        ConfigParameters node = c.getNode(TIC_LABEL_FORMAT_KEY);
        if (node.get("className", null) != null) {
            result = (TicLabelFormat)Factory.create(node);
        }
        return result;
    }
}

