/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.ssl.CertificateType;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesActionType;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfoNodesRequest;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesNodesResponse;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.threadpool.ThreadPool;

public class CertificatesApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(CertificatesApiAction.class);
    private static final List<RestHandler.Route> ROUTES = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/certificates"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/certificates/{nodeId}")), "/_plugins/_security/api");

    public CertificatesApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.SSL, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::securitySSLCertsRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    @Override
    public String getName() {
        return "HTTP and Transport Certificates Actions";
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("nodeId");
        request.param("cert_type");
        request.param("timeout");
    }

    private void securitySSLCertsRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.withAccessHandler(this::accessHandler).allMethodsNotImplemented().verifyAccessForAllMethods().override(RestRequest.Method.GET, (channel, request, client) -> client.execute((ActionType)CertificatesActionType.INSTANCE, (ActionRequest)((CertificatesInfoNodesRequest)new CertificatesInfoNodesRequest(CertificateType.from(request.param("cert_type")), true, request.paramAsStringArrayOrEmptyIfAll("nodeId")).timeout(request.param("timeout"))), (ActionListener)new ActionListener<CertificatesNodesResponse>(){

            public void onResponse(CertificatesNodesResponse response) {
                Responses.ok(channel, (builder, params) -> {
                    builder.startObject();
                    RestActions.buildNodesHeader((XContentBuilder)builder, (ToXContent.Params)channel.request(), (BaseNodesResponse)response);
                    builder.field("cluster_name", response.getClusterName().value());
                    response.toXContent(builder, (ToXContent.Params)channel.request());
                    builder.endObject();
                    return builder;
                });
            }

            public void onFailure(Exception e) {
                LOGGER.error("Cannot load SSL certificates info due to", (Throwable)e);
                Responses.internalServerError(channel, "Cannot load SSL certificates info " + e.getMessage() + ".");
            }
        }));
    }

    boolean accessHandler(RestRequest request) {
        if (request.method() == RestRequest.Method.GET) {
            return this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint, "certs/info");
        }
        return false;
    }
}

