/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageReconstructor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageCorruptionDetector;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    private static final String HELP_OPT = "-h";
    private static final String HELP_LONGOPT = "--help";
    public static final Logger LOG = LoggerFactory.getLogger(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * ReverseXML: This processor takes an XML file and creates a\n    binary fsimage containing the same elements.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n    -format formats the output result in a human-readable fashion\n     rather than a number of bytes. (false by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n    It does not support secure mode nor HTTPS.\n  * Delimited (experimental): Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n    -sp print storage policy, used by delimiter only.\n  * DetectCorruption: Detect potential corruption of the image by\n    selectively loading parts of it and actively searching for\n    inconsistencies. Outputs a summary of the found corruptions\n    in a delimited format.\n    Note that the check is not exhaustive, and only catches\n    missing nodes during the namespace reconstruction.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage or XML file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n                       If the input file was an XML file, we\n                       will also create an <outputFile>.md5 file.\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|\n                       ReverseXML|Web|Delimited|DetectCorruption)\n                       The default is Web.\n-delimiter <arg>       Delimiting string to use with Delimited or \n                       DetectCorruption processor. \n-t,--temp <arg>        Use temporary dir to cache intermediate\n                       result to generate DetectCorruption or\n                       Delimited outputs. If not set, the processor\n                       constructs the namespace in memory \n                       before outputting text.\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"inputFile");
        options.addOption(OptionBuilder.create((String)"i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("format", false, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("sp", false, "");
        options.addOption("t", "temp", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        ExitUtil.terminate((int)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int run(String[] args) throws Exception {
        options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        if (args.length == 1 && OfflineImageViewerPB.isHelpOption(args[0])) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        inputFile = cmd.getOptionValue("i");
        processor = cmd.getOptionValue("p", "Web");
        outputFile = cmd.getOptionValue("o", "-");
        delimiter = cmd.getOptionValue("delimiter", "\t");
        tempPath = cmd.getOptionValue("t", "");
        conf = new Configuration();
        out = null;
        try {
            out = outputFile.equals("-") != false || "REVERSEXML".equalsIgnoreCase(processor) != false ? System.out : new PrintStream(outputFile, "UTF-8");
            var11_12 = StringUtils.toUpperCase((String)processor);
            var12_16 = -1;
            switch (var11_12.hashCode()) {
                case -796669440: {
                    if (!var11_12.equals("FILEDISTRIBUTION")) break;
                    var12_16 = 0;
                    break;
                }
                case 87031: {
                    if (!var11_12.equals("XML")) break;
                    var12_16 = 1;
                    break;
                }
                case -297081355: {
                    if (!var11_12.equals("REVERSEXML")) break;
                    var12_16 = 2;
                    break;
                }
                case 85812: {
                    if (!var11_12.equals("WEB")) break;
                    var12_16 = 3;
                    break;
                }
                case -1758890535: {
                    if (!var11_12.equals("DELIMITED")) break;
                    var12_16 = 4;
                    break;
                }
                case -447532610: {
                    if (!var11_12.equals("DETECTCORRUPTION")) break;
                    var12_16 = 5;
                }
            }
            switch (var12_16) {
                case 0: {
                    maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                    step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                    formatOutput = cmd.hasOption("format");
                    r = new RandomAccessFile(inputFile, "r");
                    var18_24 = null;
                    new FileDistributionCalculator(conf, maxSize, step, formatOutput, out).visit(r);
                    if (r == null) break;
                    if (var18_24 == null) ** GOTO lbl71
                    try {
                        r.close();
                    }
                    catch (Throwable var19_28) {
                        var18_24.addSuppressed(var19_28);
                    }
                    break;
lbl71:
                    // 1 sources

                    r.close();
                    break;
                    catch (Throwable var19_29) {
                        try {
                            var18_24 = var19_29;
                            throw var19_29;
                        }
                        catch (Throwable var20_36) {
                            if (r != null) {
                                if (var18_24 != null) {
                                    try {
                                        r.close();
                                    }
                                    catch (Throwable var21_41) {
                                        var18_24.addSuppressed(var21_41);
                                    }
                                } else {
                                    r.close();
                                }
                            }
                            throw var20_36;
                        }
                    }
                }
                case 1: {
                    r = new RandomAccessFile(inputFile, "r");
                    var18_25 = null;
                    new PBImageXmlWriter(conf, out).visit(r);
                    if (r == null) break;
                    if (var18_25 == null) ** GOTO lbl101
                    try {
                        r.close();
                    }
                    catch (Throwable var19_30) {
                        var18_25.addSuppressed(var19_30);
                    }
                    break;
lbl101:
                    // 1 sources

                    r.close();
                    break;
                    catch (Throwable var19_31) {
                        try {
                            var18_25 = var19_31;
                            throw var19_31;
                        }
                        catch (Throwable var22_47) {
                            if (r != null) {
                                if (var18_25 != null) {
                                    try {
                                        r.close();
                                    }
                                    catch (Throwable var23_49) {
                                        var18_25.addSuppressed(var23_49);
                                    }
                                } else {
                                    r.close();
                                }
                            }
                            throw var22_47;
                        }
                    }
                }
                case 2: {
                    try {
                        OfflineImageReconstructor.run(inputFile, outputFile);
                    }
                    catch (Exception e) {
                        System.err.println("OfflineImageReconstructor failed: " + e.getMessage());
                        e.printStackTrace(System.err);
                        ExitUtil.terminate((int)1);
                    }
                    break;
                }
                case 3: {
                    addr = cmd.getOptionValue("addr", "localhost:5978");
                    viewer = new WebImageViewer(NetUtils.createSocketAddr((String)addr), conf);
                    var19_32 = null;
                    viewer.start(inputFile);
                    if (viewer == null) break;
                    if (var19_32 == null) ** GOTO lbl141
                    try {
                        viewer.close();
                    }
                    catch (Throwable var20_37) {
                        var19_32.addSuppressed(var20_37);
                    }
                    break;
lbl141:
                    // 1 sources

                    viewer.close();
                    break;
                    catch (Throwable var20_38) {
                        try {
                            var19_32 = var20_38;
                            throw var20_38;
                        }
                        catch (Throwable var24_52) {
                            if (viewer != null) {
                                if (var19_32 != null) {
                                    try {
                                        viewer.close();
                                    }
                                    catch (Throwable var25_53) {
                                        var19_32.addSuppressed(var25_53);
                                    }
                                } else {
                                    viewer.close();
                                }
                            }
                            throw var24_52;
                        }
                    }
                }
                case 4: {
                    printStoragePolicy = cmd.hasOption("sp");
                    writer = new PBImageDelimitedTextWriter(out, delimiter, tempPath, printStoragePolicy);
                    var20_39 = null;
                    r = new RandomAccessFile(inputFile, "r");
                    var22_48 = null;
                    try {
                        writer.visit(r);
                    }
                    catch (Throwable var23_51) {
                        var22_48 = var23_51;
                        throw var23_51;
                    }
                    finally {
                        if (r != null) {
                            if (var22_48 != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable var23_50) {
                                    var22_48.addSuppressed(var23_50);
                                }
                            } else {
                                r.close();
                            }
                        }
                    }
                    if (writer == null) break;
                    if (var20_39 == null) ** GOTO lbl190
                    try {
                        writer.close();
                    }
                    catch (Throwable var21_43) {
                        var20_39.addSuppressed(var21_43);
                    }
                    break;
lbl190:
                    // 1 sources

                    writer.close();
                    break;
                    catch (Throwable var21_44) {
                        try {
                            var20_39 = var21_44;
                            throw var21_44;
                        }
                        catch (Throwable var28_56) {
                            if (writer != null) {
                                if (var20_39 != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable var29_57) {
                                        var20_39.addSuppressed(var29_57);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                            throw var28_56;
                        }
                    }
                }
                case 5: {
                    detector = new PBImageCorruptionDetector(out, delimiter, tempPath);
                    var20_40 = null;
                    detector.visit(new RandomAccessFile(inputFile, "r"));
                    if (detector == null) break;
                    if (var20_40 == null) ** GOTO lbl220
                    try {
                        detector.close();
                    }
                    catch (Throwable var21_45) {
                        var20_40.addSuppressed(var21_45);
                    }
                    break;
lbl220:
                    // 1 sources

                    detector.close();
                    break;
                    catch (Throwable var21_46) {
                        try {
                            var20_40 = var21_46;
                            throw var21_46;
                        }
                        catch (Throwable var30_58) {
                            if (detector != null) {
                                if (var20_40 != null) {
                                    try {
                                        detector.close();
                                    }
                                    catch (Throwable var31_59) {
                                        var20_40.addSuppressed(var31_59);
                                    }
                                } else {
                                    detector.close();
                                }
                            }
                            throw var30_58;
                        }
                    }
                }
                default: {
                    System.err.println("Invalid processor specified : " + processor);
                    OfflineImageViewerPB.printUsage();
                    var19_35 = -1;
                    return var19_35;
                }
            }
            var11_13 = 0;
            return var11_13;
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
        }
        catch (IOException e) {
            System.err.println("Encountered exception.  Exiting: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            if (out != null && out != System.out) {
                out.close();
            }
        }
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }

    private static boolean isHelpOption(String arg) {
        return arg.equalsIgnoreCase(HELP_OPT) || arg.equalsIgnoreCase(HELP_LONGOPT);
    }
}

