/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReader;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.DecodingValidator;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;

@InterfaceAudience.Private
abstract class StripedReconstructor {
    protected static final Logger LOG = DataNode.LOG;
    private final Configuration conf;
    private final DataNode datanode;
    private final ErasureCodingPolicy ecPolicy;
    private final ErasureCoderOptions coderOptions;
    private RawErasureDecoder decoder;
    private final ExtendedBlock blockGroup;
    private static final ByteBufferPool BUFFER_POOL = new ElasticByteBufferPool();
    private final boolean isValidationEnabled;
    private DecodingValidator validator;
    private long positionInBlock;
    private StripedReader stripedReader;
    private ErasureCodingWorker erasureCodingWorker;
    private final CachingStrategy cachingStrategy;
    private long maxTargetLength = 0L;
    private final BitSet liveBitSet;
    private final BitSet excludeBitSet;
    private AtomicLong bytesRead = new AtomicLong(0L);
    private AtomicLong bytesWritten = new AtomicLong(0L);
    private AtomicLong remoteBytesRead = new AtomicLong(0L);

    StripedReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo) {
        int i;
        this.erasureCodingWorker = worker;
        this.datanode = worker.getDatanode();
        this.conf = worker.getConf();
        this.ecPolicy = stripedReconInfo.getEcPolicy();
        this.liveBitSet = new BitSet(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
        for (i = 0; i < stripedReconInfo.getLiveIndices().length; ++i) {
            this.liveBitSet.set(stripedReconInfo.getLiveIndices()[i]);
        }
        this.excludeBitSet = new BitSet(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
        for (i = 0; i < stripedReconInfo.getExcludeReconstructedIndices().length; ++i) {
            this.excludeBitSet.set(stripedReconInfo.getExcludeReconstructedIndices()[i]);
        }
        this.blockGroup = stripedReconInfo.getBlockGroup();
        this.stripedReader = new StripedReader(this, this.datanode, this.conf, stripedReconInfo);
        this.cachingStrategy = CachingStrategy.newDefaultStrategy();
        this.positionInBlock = 0L;
        this.coderOptions = new ErasureCoderOptions(this.ecPolicy.getNumDataUnits(), this.ecPolicy.getNumParityUnits());
        this.isValidationEnabled = this.conf.getBoolean("dfs.datanode.ec.reconstruction.validation", false) && !this.coderOptions.allowChangeInputs();
    }

    public void incrBytesRead(boolean local, long delta) {
        if (local) {
            this.bytesRead.addAndGet(delta);
        } else {
            this.bytesRead.addAndGet(delta);
            this.remoteBytesRead.addAndGet(delta);
        }
    }

    public void incrBytesWritten(long delta) {
        this.bytesWritten.addAndGet(delta);
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public long getRemoteBytesRead() {
        return this.remoteBytesRead.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    abstract void reconstruct() throws IOException;

    boolean useDirectBuffer() {
        return this.decoder.preferDirectBuffer();
    }

    ByteBuffer allocateBuffer(int length) {
        return BUFFER_POOL.getBuffer(this.useDirectBuffer(), length);
    }

    void freeBuffer(ByteBuffer buffer) {
        BUFFER_POOL.putBuffer(buffer);
    }

    ExtendedBlock getBlock(int i) {
        return StripedBlockUtil.constructInternalBlock((ExtendedBlock)this.blockGroup, (ErasureCodingPolicy)this.ecPolicy, (int)i);
    }

    long getBlockLen(int i) {
        return StripedBlockUtil.getInternalBlockLength((long)this.blockGroup.getNumBytes(), (ErasureCodingPolicy)this.ecPolicy, (int)i);
    }

    protected void initDecoderIfNecessary() {
        if (this.decoder == null) {
            this.decoder = CodecUtil.createRawDecoder((Configuration)this.conf, (String)this.ecPolicy.getCodecName(), (ErasureCoderOptions)this.coderOptions);
        }
    }

    protected void initDecodingValidatorIfNecessary() {
        if (this.isValidationEnabled && this.validator == null) {
            this.validator = new DecodingValidator(this.decoder);
        }
    }

    long getPositionInBlock() {
        return this.positionInBlock;
    }

    InetSocketAddress getSocketAddress4Transfer(DatanodeInfo dnInfo) {
        return NetUtils.createSocketAddr((String)dnInfo.getXferAddr(this.datanode.getDnConf().getConnectToDnViaHostname()));
    }

    int getBufferSize() {
        return this.stripedReader.getBufferSize();
    }

    public DataChecksum getChecksum() {
        return this.stripedReader.getChecksum();
    }

    CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    CompletionService<StripedBlockUtil.BlockReadStats> createReadService() {
        return this.erasureCodingWorker.createReadService();
    }

    ExtendedBlock getBlockGroup() {
        return this.blockGroup;
    }

    int getXmits() {
        return this.stripedReader.getXmits();
    }

    BitSet getLiveBitSet() {
        return this.liveBitSet;
    }

    BitSet getExcludeBitSet() {
        return this.excludeBitSet;
    }

    long getMaxTargetLength() {
        return this.maxTargetLength;
    }

    void setMaxTargetLength(long maxTargetLength) {
        this.maxTargetLength = maxTargetLength;
    }

    void updatePositionInBlock(long positionInBlockArg) {
        this.positionInBlock += positionInBlockArg;
    }

    RawErasureDecoder getDecoder() {
        return this.decoder;
    }

    int getNumLiveBlocks() {
        return this.liveBitSet.cardinality();
    }

    void cleanup() {
        if (this.decoder != null) {
            this.decoder.release();
        }
    }

    StripedReader getStripedReader() {
        return this.stripedReader;
    }

    Configuration getConf() {
        return this.conf;
    }

    DataNode getDatanode() {
        return this.datanode;
    }

    public ErasureCodingWorker getErasureCodingWorker() {
        return this.erasureCodingWorker;
    }

    @VisibleForTesting
    static ByteBufferPool getBufferPool() {
        return BUFFER_POOL;
    }

    boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    DecodingValidator getValidator() {
        return this.validator;
    }

    protected static void markBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.mark();
        }
    }

    protected static void resetBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.reset();
        }
    }
}

