/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.action;

import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.reportsscheduler.index.ReportDefinitionsIndex;
import org.opensearch.reportsscheduler.index.ReportInstancesIndex;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.GetAllReportInstancesRequest;
import org.opensearch.reportsscheduler.model.GetAllReportInstancesResponse;
import org.opensearch.reportsscheduler.model.GetReportInstanceRequest;
import org.opensearch.reportsscheduler.model.GetReportInstanceResponse;
import org.opensearch.reportsscheduler.model.InContextReportCreateRequest;
import org.opensearch.reportsscheduler.model.InContextReportCreateResponse;
import org.opensearch.reportsscheduler.model.OnDemandReportCreateRequest;
import org.opensearch.reportsscheduler.model.OnDemandReportCreateResponse;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetails;
import org.opensearch.reportsscheduler.model.ReportInstance;
import org.opensearch.reportsscheduler.model.ReportInstanceSearchResults;
import org.opensearch.reportsscheduler.model.UpdateReportInstanceStatusRequest;
import org.opensearch.reportsscheduler.model.UpdateReportInstanceStatusResponse;
import org.opensearch.reportsscheduler.security.UserAccessManager;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/reportsscheduler/action/ReportInstanceActions;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createOnDemand", "Lorg/opensearch/reportsscheduler/model/InContextReportCreateResponse;", "request", "Lorg/opensearch/reportsscheduler/model/InContextReportCreateRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "createOnDemandFromDefinition", "Lorg/opensearch/reportsscheduler/model/OnDemandReportCreateResponse;", "Lorg/opensearch/reportsscheduler/model/OnDemandReportCreateRequest;", "update", "Lorg/opensearch/reportsscheduler/model/UpdateReportInstanceStatusResponse;", "Lorg/opensearch/reportsscheduler/model/UpdateReportInstanceStatusRequest;", "info", "Lorg/opensearch/reportsscheduler/model/GetReportInstanceResponse;", "Lorg/opensearch/reportsscheduler/model/GetReportInstanceRequest;", "getAll", "Lorg/opensearch/reportsscheduler/model/GetAllReportInstancesResponse;", "Lorg/opensearch/reportsscheduler/model/GetAllReportInstancesRequest;", "opensearch-reports-scheduler"})
public final class ReportInstanceActions {
    @NotNull
    public static final ReportInstanceActions INSTANCE = new ReportInstanceActions();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ReportInstanceActions.class);

    private ReportInstanceActions() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final InContextReportCreateResponse createOnDemand(@NotNull InContextReportCreateRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-createOnDemand");
        UserAccessManager.INSTANCE.validateUser(user);
        Instant currentTime = Instant.now();
        Intrinsics.checkNotNull((Object)currentTime);
        ReportInstance reportInstance = new ReportInstance("ignore", currentTime, currentTime, request.getBeginTime(), request.getEndTime(), UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getAllAccessInfo(user), request.getReportDefinitionDetails(), ReportInstance.Status.Success, request.getStatusText(), request.getInContextDownloadUrlPath());
        String docId = ReportInstancesIndex.INSTANCE.createReportInstance(reportInstance);
        if (docId == null) {
            ReportInstanceActions $this$createOnDemand_u24lambda_u240 = this;
            boolean bl = false;
            Metrics.REPORT_FROM_DEFINITION_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Report Instance Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        ReportInstance reportInstanceCopy = ReportInstance.copy$default(reportInstance, docId, null, null, null, null, null, null, null, null, null, null, 2046, null);
        return new InContextReportCreateResponse(reportInstanceCopy, true);
    }

    @NotNull
    public final OnDemandReportCreateResponse createOnDemandFromDefinition(@NotNull OnDemandReportCreateRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-createOnDemandFromDefinition " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        Instant currentTime = Instant.now();
        ReportDefinitionDetails reportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (reportDefinitionDetails == null) {
            ReportInstanceActions $this$createOnDemandFromDefinition_u24lambda_u241 = this;
            boolean bl = false;
            Metrics.REPORT_DEFINITION_INFO_USER_ERROR_MISSING_REPORT_DEF_DETAILS.getCounter().increment();
            throw new OpenSearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportDefinitionDetails.getTenant(), reportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Instant beginTime = null;
        Instant endTime = null;
        CharSequence bl = reportDefinitionDetails.getReportDefinition().getFormat().getTimeFrom();
        if (!(bl == null || StringsKt.isBlank((CharSequence)bl)) && !((bl = (CharSequence)reportDefinitionDetails.getReportDefinition().getFormat().getTimeTo()) == null || StringsKt.isBlank((CharSequence)bl))) {
            beginTime = Instant.parse(reportDefinitionDetails.getReportDefinition().getFormat().getTimeFrom());
            endTime = Instant.parse(reportDefinitionDetails.getReportDefinition().getFormat().getTimeTo());
        } else {
            beginTime = currentTime.minus(reportDefinitionDetails.getReportDefinition().getFormat().getDuration());
            endTime = currentTime;
        }
        ReportInstance.Status currentStatus = ReportInstance.Status.Success;
        Intrinsics.checkNotNull((Object)currentTime);
        ReportInstance reportInstance = new ReportInstance("ignore", currentTime, currentTime, beginTime, endTime, UserAccessManager.INSTANCE.getUserTenant(user), reportDefinitionDetails.getAccess(), reportDefinitionDetails, currentStatus, null, null, 1536, null);
        String docId = ReportInstancesIndex.INSTANCE.createReportInstance(reportInstance);
        if (docId == null) {
            ReportInstanceActions $this$createOnDemandFromDefinition_u24lambda_u242 = this;
            boolean bl2 = false;
            Metrics.REPORT_FROM_DEFINITION_ID_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Report Instance Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        ReportInstance reportInstanceCopy = ReportInstance.copy$default(reportInstance, docId, null, null, null, null, null, null, null, null, null, null, 2046, null);
        return new OnDemandReportCreateResponse(reportInstanceCopy, true);
    }

    @NotNull
    public final UpdateReportInstanceStatusResponse update(@NotNull UpdateReportInstanceStatusRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-update " + request.getReportInstanceId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportInstance currentReportInstance = ReportInstancesIndex.INSTANCE.getReportInstance(request.getReportInstanceId());
        if (currentReportInstance == null) {
            ReportInstanceActions $this$update_u24lambda_u243 = this;
            boolean bl = false;
            Metrics.REPORT_INSTANCE_UPDATE_USER_ERROR_MISSING_REPORT_INSTANCE.getCounter().increment();
            throw new OpenSearchStatusException("Report Instance " + request.getReportInstanceId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentReportInstance.getTenant(), currentReportInstance.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for Report Definition " + request.getReportInstanceId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (request.getStatus() == ReportInstance.Status.Scheduled) {
            Metrics.REPORT_INSTANCE_UPDATE_USER_ERROR_INVALID_STATUS.getCounter().increment();
            throw new OpenSearchStatusException("Status cannot be updated to " + ReportInstance.Status.Scheduled, RestStatus.BAD_REQUEST, new Object[0]);
        }
        Instant currentTime = Instant.now();
        Intrinsics.checkNotNull((Object)currentTime);
        ReportInstance updatedReportInstance = ReportInstance.copy$default(currentReportInstance, null, currentTime, null, null, null, null, null, null, request.getStatus(), request.getStatusText(), null, 1277, null);
        if (!ReportInstancesIndex.INSTANCE.updateReportInstance(updatedReportInstance)) {
            Metrics.REPORT_INSTANCE_UPDATE_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Report Instance state update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateReportInstanceStatusResponse(request.getReportInstanceId());
    }

    @NotNull
    public final GetReportInstanceResponse info(@NotNull GetReportInstanceRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-info " + request.getReportInstanceId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportInstance reportInstance = ReportInstancesIndex.INSTANCE.getReportInstance(request.getReportInstanceId());
        if (reportInstance == null) {
            ReportInstanceActions $this$info_u24lambda_u244 = this;
            boolean bl = false;
            Metrics.REPORT_INSTANCE_INFO_USER_ERROR_MISSING_REPORT_INSTANCE.getCounter().increment();
            throw new OpenSearchStatusException("Report Instance " + request.getReportInstanceId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportInstance.getTenant(), reportInstance.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for Report Definition " + request.getReportInstanceId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        return new GetReportInstanceResponse(reportInstance, true);
    }

    @NotNull
    public final GetAllReportInstancesResponse getAll(@NotNull GetAllReportInstancesRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-getAll fromIndex:" + request.getFromIndex() + " maxItems:" + request.getMaxItems());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportInstanceSearchResults reportInstanceList = ReportInstancesIndex.INSTANCE.getAllReportInstances(UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getSearchAccessInfo(user), request.getFromIndex(), request.getMaxItems());
        return new GetAllReportInstancesResponse(reportInstanceList, true);
    }
}

