/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModelGroup;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model_group.MLModelGroupGetRequest;
import org.opensearch.ml.common.transport.model_group.MLModelGroupGetResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetModelGroupTransportAction
extends HandledTransportAction<ActionRequest, MLModelGroupGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetModelGroupTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/model_groups/get", transportService, actionFilters, MLModelGroupGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGroupGetResponse> actionListener) {
        MLModelGroupGetRequest mlModelGroupGetRequest = MLModelGroupGetRequest.fromActionRequest((ActionRequest)request);
        String modelGroupId = mlModelGroupGetRequest.getModelGroupId();
        String tenantId = mlModelGroupGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> this.handleResponse((GetDataObjectResponse)r, (Throwable)throwable, modelGroupId, tenantId, user, (ActionListener<MLModelGroupGetResponse>)wrappedListener));
        }
        catch (Exception e) {
            log.error("Failed to get ML model group {}", (Object)modelGroupId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void handleResponse(GetDataObjectResponse getDataObjectResponse, Throwable throwable, String modelGroupId, String tenantId, User user, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        log.debug("Completed Get Model group Request, id:{}", (Object)modelGroupId);
        if (throwable != null) {
            this.handleThrowable(throwable, modelGroupId, wrappedListener);
        } else {
            this.processResponse(getDataObjectResponse, modelGroupId, tenantId, user, wrappedListener);
        }
    }

    private void handleThrowable(Throwable throwable, String modelGroupId, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to find model group index", (Throwable)cause);
            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model group index", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            log.error("Failed to get ML group {}", (Object)modelGroupId, (Object)cause);
            wrappedListener.onFailure(cause);
        }
    }

    private void processResponse(GetDataObjectResponse getDataObjectResponse, String modelGroupId, String tenantId, User user, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        block12: {
            try {
                GetResponse gr = getDataObjectResponse.getResponse();
                if (gr != null && gr.isExists()) {
                    try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                        if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlModelGroup.getTenantId(), wrappedListener)) {
                            this.validateModelGroupAccess(user, modelGroupId, mlModelGroup, wrappedListener);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml connector {}", (Object)getDataObjectResponse.id(), (Object)e);
                        wrappedListener.onFailure(e);
                    }
                    break block12;
                }
                wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model group with the provided model group id: " + modelGroupId, RestStatus.NOT_FOUND, new Object[0]));
            }
            catch (Exception e) {
                wrappedListener.onFailure(e);
            }
        }
    }

    private void validateModelGroupAccess(User user, String modelGroupId, MLModelGroup mlModelGroup, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        this.modelAccessControlHelper.validateModelGroupAccess(user, modelGroupId, this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (!access.booleanValue()) {
                wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model group", RestStatus.FORBIDDEN, new Object[0]));
            } else {
                wrappedListener.onResponse((Object)MLModelGroupGetResponse.builder().mlModelGroup(mlModelGroup).build());
            }
        }, e -> {
            log.error("Failed to validate access for Model Group {}", (Object)modelGroupId, e);
            wrappedListener.onFailure(e);
        }));
    }
}

