/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.SetView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AnyOfValidator.class);
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private Boolean canShortCircuit = null;

    public AnyOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), schemaNode.get(i), parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        Set<ValidationMessage> set;
        AnyOfValidator.debug(logger, node, rootNode, instanceLocation);
        ValidatorState state = executionContext.getValidatorState();
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
            executionContext.enterDiscriminatorContext(new DiscriminatorContext(), instanceLocation);
        }
        boolean initialHasMatchedNode = state.hasMatchedNode();
        SetView<ValidationMessage> allErrors = null;
        int numberOfValidSubSchemas = 0;
        try {
            boolean failFast = executionContext.isFailFast();
            try {
                executionContext.setFailFast(false);
                for (JsonSchema schema : this.schemas) {
                    DiscriminatorContext currentDiscriminatorContext;
                    Set<Object> errors = Collections.emptySet();
                    state.setMatchedNode(initialHasMatchedNode);
                    TypeValidator typeValidator = schema.getTypeValidator();
                    if (typeValidator != null && typeValidator.getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node)) {
                        if (allErrors == null) {
                            allErrors = new SetView<ValidationMessage>();
                        }
                        allErrors.union(typeValidator.validate(executionContext, node, rootNode, instanceLocation));
                        continue;
                    }
                    errors = !state.isWalkEnabled() ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
                    if (errors.isEmpty()) {
                        if (!state.hasMatchedNode()) continue;
                        ++numberOfValidSubSchemas;
                    }
                    if (errors.isEmpty() && !this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.canShortCircuit() && this.canShortCircuit(executionContext)) {
                        allErrors = null;
                        Set<Object> set2 = errors;
                        return set2;
                    }
                    if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && ((currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()).isDiscriminatorMatchFound() || currentDiscriminatorContext.isDiscriminatorIgnore())) {
                        if (!errors.isEmpty()) {
                            if (allErrors == null) {
                                allErrors = new SetView();
                            }
                            allErrors.union(Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(DISCRIMINATOR_REMARK)).build()));
                        } else {
                            allErrors = null;
                        }
                        Set<Object> set3 = errors;
                        return set3;
                    }
                    if (allErrors == null) {
                        allErrors = new SetView();
                    }
                    allErrors.union(errors);
                }
            }
            finally {
                executionContext.setFailFast(failFast);
            }
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && executionContext.getCurrentDiscriminatorContext().isActive() && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorIgnore()) {
                Set<ValidationMessage> set4 = Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments("based on the provided discriminator. No alternative could be chosen based on the discriminator property")).build());
                return set4;
            }
        }
        finally {
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                executionContext.leaveDiscriminatorContextImmediately(instanceLocation);
            }
            if (allErrors == null || allErrors.isEmpty()) {
                state.setMatchedNode(true);
            }
        }
        if (numberOfValidSubSchemas >= 1) {
            return Collections.emptySet();
        }
        if (allErrors != null) {
            set = allErrors;
            return set;
        }
        set = Collections.emptySet();
        return set;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return new LinkedHashSet<ValidationMessage>();
    }

    protected boolean canShortCircuit(ExecutionContext executionContext) {
        return !executionContext.getExecutionConfig().isAnnotationCollectionEnabled();
    }

    protected boolean canShortCircuit() {
        if (this.canShortCircuit == null) {
            boolean canShortCircuit = true;
            for (JsonValidator validator : this.getEvaluationParentSchema().getValidators()) {
                if (!"unevaluatedProperties".equals(validator.getKeyword()) && !"unevaluatedItems".equals(validator.getKeyword())) continue;
                canShortCircuit = false;
            }
            this.canShortCircuit = canShortCircuit;
        }
        return this.canShortCircuit;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
        this.canShortCircuit();
    }
}

