/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.Lifecycle;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.geospatial.action.IpEnrichmentAction;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONAction;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONTransportAction;
import org.opensearch.geospatial.index.mapper.xypoint.XYPointFieldTypeParser;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeFieldTypeParser;
import org.opensearch.geospatial.index.query.xyshape.XYShapeQueryBuilder;
import org.opensearch.geospatial.ip2geo.action.DeleteDatasourceAction;
import org.opensearch.geospatial.ip2geo.action.DeleteDatasourceTransportAction;
import org.opensearch.geospatial.ip2geo.action.GetDatasourceAction;
import org.opensearch.geospatial.ip2geo.action.GetDatasourceTransportAction;
import org.opensearch.geospatial.ip2geo.action.IpEnrichmentTransportAction;
import org.opensearch.geospatial.ip2geo.action.PutDatasourceAction;
import org.opensearch.geospatial.ip2geo.action.PutDatasourceTransportAction;
import org.opensearch.geospatial.ip2geo.action.RestDeleteDatasourceHandler;
import org.opensearch.geospatial.ip2geo.action.RestGetDatasourceHandler;
import org.opensearch.geospatial.ip2geo.action.RestPutDatasourceHandler;
import org.opensearch.geospatial.ip2geo.action.RestUpdateDatasourceHandler;
import org.opensearch.geospatial.ip2geo.action.UpdateDatasourceAction;
import org.opensearch.geospatial.ip2geo.action.UpdateDatasourceTransportAction;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoExecutor;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoLockService;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.geospatial.ip2geo.common.URLDenyListChecker;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.dao.Ip2GeoCachedDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceRunner;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceUpdateService;
import org.opensearch.geospatial.ip2geo.listener.Ip2GeoListener;
import org.opensearch.geospatial.ip2geo.processor.Ip2GeoProcessor;
import org.opensearch.geospatial.processor.FeatureProcessor;
import org.opensearch.geospatial.rest.action.upload.geojson.RestUploadGeoJSONAction;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGrid;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGridAggregationBuilder;
import org.opensearch.geospatial.stats.upload.RestUploadStatsAction;
import org.opensearch.geospatial.stats.upload.UploadStats;
import org.opensearch.geospatial.stats.upload.UploadStatsAction;
import org.opensearch.geospatial.stats.upload.UploadStatsTransportAction;
import org.opensearch.index.IndexModule;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.ingest.Processor;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class GeospatialPlugin
extends Plugin
implements IngestPlugin,
ActionPlugin,
MapperPlugin,
SearchPlugin,
SystemIndexPlugin,
ClusterPlugin {
    @Generated
    private static final Logger log = LogManager.getLogger(GeospatialPlugin.class);
    private Ip2GeoCachedDao ip2GeoCachedDao;
    private DatasourceDao datasourceDao;
    private GeoIpDataDao geoIpDataDao;
    private URLDenyListChecker urlDenyListChecker;
    private ClusterService clusterService;
    private Ip2GeoLockService ip2GeoLockService;
    private Ip2GeoExecutor ip2GeoExecutor;
    private DatasourceUpdateService datasourceUpdateService;

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(new SystemIndexDescriptor(".geospatial-ip2geo-data", "System index used for Ip2Geo data"));
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        this.urlDenyListChecker = new URLDenyListChecker(parameters.ingestService.getClusterService().getClusterSettings());
        this.datasourceDao = new DatasourceDao(parameters.client, parameters.ingestService.getClusterService());
        this.geoIpDataDao = new GeoIpDataDao(parameters.ingestService.getClusterService(), parameters.client, this.urlDenyListChecker);
        this.ip2GeoCachedDao = new Ip2GeoCachedDao(parameters.ingestService.getClusterService(), this.datasourceDao, this.geoIpDataDao);
        return MapBuilder.newMapBuilder().put((Object)"geojson-feature", (Object)new FeatureProcessor.Factory()).put((Object)"ip2geo", (Object)new Ip2GeoProcessor.Factory(parameters.ingestService, this.datasourceDao, this.geoIpDataDao, this.ip2GeoCachedDao)).immutableMap();
    }

    public void onIndexModule(IndexModule indexModule) {
        if (".scheduler-geospatial-ip2geo-datasource".equals(indexModule.getIndex().getName())) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.ip2GeoCachedDao);
            log.info("Ip2GeoListener started listening to operations on index {}", (Object)".scheduler-geospatial-ip2geo-datasource");
        }
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>(2);
        services.add(Ip2GeoListener.class);
        services.add(GuiceHolder.class);
        return services;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList executorBuilders = new ArrayList();
        executorBuilders.add(Ip2GeoExecutor.executorBuilder(settings));
        return executorBuilders;
    }

    public List<Setting<?>> getSettings() {
        return Ip2GeoSettings.settings();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        this.datasourceUpdateService = new DatasourceUpdateService(clusterService, this.datasourceDao, this.geoIpDataDao, this.urlDenyListChecker);
        this.ip2GeoExecutor = new Ip2GeoExecutor(threadPool);
        this.ip2GeoLockService = new Ip2GeoLockService(clusterService);
        return List.of(UploadStats.getInstance(), this.datasourceUpdateService, this.datasourceDao, this.ip2GeoExecutor, this.geoIpDataDao, this.ip2GeoLockService, this.ip2GeoCachedDao);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        List<RestUploadGeoJSONAction> geoJsonHandlers = List.of(new RestUploadStatsAction(), new RestUploadGeoJSONAction());
        List<RestDeleteDatasourceHandler> ip2geoHandlers = List.of(new RestPutDatasourceHandler(clusterSettings, this.urlDenyListChecker), new RestGetDatasourceHandler(), new RestUpdateDatasourceHandler(this.urlDenyListChecker), new RestDeleteDatasourceHandler());
        ArrayList<RestHandler> allHandlers = new ArrayList<RestHandler>();
        allHandlers.addAll(geoJsonHandlers);
        allHandlers.addAll(ip2geoHandlers);
        return allHandlers;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        List<ActionPlugin.ActionHandler> geoJsonHandlers = List.of(new ActionPlugin.ActionHandler((ActionType)UploadGeoJSONAction.INSTANCE, UploadGeoJSONTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UploadStatsAction.INSTANCE, UploadStatsTransportAction.class, new Class[0]));
        List<ActionPlugin.ActionHandler> ip2geoHandlers = List.of(new ActionPlugin.ActionHandler((ActionType)PutDatasourceAction.INSTANCE, PutDatasourceTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDatasourceAction.INSTANCE, GetDatasourceTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateDatasourceAction.INSTANCE, UpdateDatasourceTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDatasourceAction.INSTANCE, DeleteDatasourceTransportAction.class, new Class[0]));
        List<ActionPlugin.ActionHandler> ipEnrichmentHandlers = List.of(new ActionPlugin.ActionHandler((ActionType)IpEnrichmentAction.INSTANCE, IpEnrichmentTransportAction.class, new Class[0]));
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> allHandlers = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        allHandlers.addAll(geoJsonHandlers);
        allHandlers.addAll(ip2geoHandlers);
        allHandlers.addAll(ipEnrichmentHandlers);
        return allHandlers;
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Map.of("xy_shape", new XYShapeFieldTypeParser(), "xy_point", new XYPointFieldTypeParser());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return List.of(new SearchPlugin.QuerySpec("xy_shape", XYShapeQueryBuilder::new, XYShapeQueryBuilder::fromXContent));
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        SearchPlugin.AggregationSpec geoHexGridSpec = new SearchPlugin.AggregationSpec("geohex_grid", GeoHexGridAggregationBuilder::new, GeoHexGridAggregationBuilder.PARSER).addResultReader(GeoHexGrid::new).setAggregatorRegistrar(GeoHexGridAggregationBuilder::registerAggregators);
        return List.of(geoHexGridSpec);
    }

    public void onNodeStarted(DiscoveryNode localNode) {
        LockService lockService = GuiceHolder.getLockService();
        this.ip2GeoLockService.initialize(lockService);
        DatasourceRunner.getJobRunnerInstance().initialize(this.clusterService, this.datasourceUpdateService, this.ip2GeoExecutor, this.datasourceDao, this.ip2GeoLockService);
    }

    public static class GuiceHolder
    implements LifecycleComponent {
        private static LockService lockService;

        @Inject
        public GuiceHolder(LockService lockService) {
            GuiceHolder.lockService = lockService;
        }

        static LockService getLockService() {
            return lockService;
        }

        public void close() {
        }

        public Lifecycle.State lifecycleState() {
            return null;
        }

        public void addLifecycleListener(LifecycleListener listener) {
        }

        public void removeLifecycleListener(LifecycleListener listener) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

