"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTourStepIndicator", {
  enumerable: true,
  get: function get() {
    return _tour_step_indicator.EuiTourStepIndicator;
  }
});
exports.OuiTourStepIndicator = exports.STATUS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon = require("../icon");

var _i18n = require("../i18n");

var _tour_step_indicator = require("../../eui_components/tour/tour_step_indicator");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var statusToClassNameMap = {
  complete: 'ouiTourStepIndicator--complete',
  incomplete: 'ouiTourStepIndicator--incomplete',
  active: 'ouiTourStepIndicator--active'
};
var STATUS = (0, _common.keysOf)(statusToClassNameMap);
exports.STATUS = STATUS;

var OuiTourStepIndicator = function OuiTourStepIndicator(_ref) {
  var className = _ref.className,
      number = _ref.number,
      status = _ref.status,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "number", "status"]);
  var classes = (0, _classnames.default)('ouiTourStepIndicator', status ? statusToClassNameMap[status] : undefined, className);
  var indicatorIcon;

  if (status === 'active') {
    indicatorIcon = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiTourStepIndicator.isActive",
      default: "active"
    }, function (isActive) {
      return /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
        type: "dot",
        className: "ouiStepNumber__icon",
        "aria-label": isActive,
        color: "success",
        "aria-current": "step"
      });
    });
  } else if (status === 'complete') {
    indicatorIcon = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiTourStepIndicator.isComplete",
      default: "complete"
    }, function (isComplete) {
      return /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
        type: "dot",
        className: "ouiStepNumber__icon",
        "aria-label": isComplete,
        color: "subdued"
      });
    });
  } else if (status === 'incomplete') {
    indicatorIcon = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiTourStepIndicator.isIncomplete",
      default: "incomplete"
    }, function (isIncomplete) {
      return /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
        type: "dot",
        className: "ouiStepNumber__icon",
        "aria-label": isIncomplete,
        color: "subdued"
      });
    });
  }

  return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiTourStepIndicator.ariaLabel",
    default: "Step {number} {status}",
    values: {
      status: status,
      number: number
    }
  }, function (ariaLabel) {
    return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
      className: classes,
      "aria-label": ariaLabel
    }, rest), indicatorIcon);
  });
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiTourStepIndicator = OuiTourStepIndicator;
OuiTourStepIndicator.propTypes = {
  number: _propTypes.default.number.isRequired,
  status: _propTypes.default.oneOf(["complete", "incomplete", "active"]).isRequired,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */