/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Warn;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Zlib::ZStream"})
public abstract class ZStream
extends RubyObject {
    protected boolean closed = false;

    protected abstract int internalTotalIn();

    protected abstract int internalTotalOut();

    protected abstract boolean internalStreamEndP();

    @Deprecated(since="10.0")
    protected void internalReset() {
        this.internalReset(this.getCurrentContext());
    }

    protected void internalReset(ThreadContext context) {
        throw new RuntimeException("Missing internalReset Implementation");
    }

    protected abstract boolean internalFinished();

    protected abstract long internalAdler();

    @Deprecated(since="10.0")
    protected IRubyObject internalFinish(Block block) {
        return this.internalFinish(this.getCurrentContext(), block);
    }

    protected IRubyObject internalFinish(ThreadContext context, Block block) {
        throw new RuntimeException("Missing internalFinish Implementation");
    }

    protected abstract void internalClose();

    public ZStream(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block unusedBlock) {
        return this;
    }

    @JRubyMethod
    public IRubyObject flush_next_out(ThreadContext context, Block block) {
        return RubyString.newEmptyBinaryString(context.getRuntime());
    }

    @Deprecated
    public IRubyObject total_out() {
        return this.total_out(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject total_out(ThreadContext context) {
        this.checkClosed(context);
        return Convert.asFixnum(context, this.internalTotalOut());
    }

    @Deprecated(since="10.0")
    public IRubyObject stream_end_p() {
        return this.stream_end_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"stream_end?"})
    public IRubyObject stream_end_p(ThreadContext context) {
        return this.internalStreamEndP() ? context.tru : context.fals;
    }

    @Deprecated(since="10.0")
    public IRubyObject data_type() {
        return this.data_type(this.getCurrentContext());
    }

    @JRubyMethod(name={"data_type"})
    public IRubyObject data_type(ThreadContext context) {
        this.checkClosed(context);
        return Access.getModule(context, "Zlib").getConstant(context, "UNKNOWN");
    }

    @Deprecated(since="10.0")
    public IRubyObject closed_p() {
        return this.closed_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"closed?", "ended?"})
    public IRubyObject closed_p(ThreadContext context) {
        return this.closed ? context.tru : context.fals;
    }

    @Deprecated(since="10.0")
    public IRubyObject reset() {
        return this.reset(this.getCurrentContext());
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset(ThreadContext context) {
        this.checkClosed(context);
        this.internalReset(context);
        return context.nil;
    }

    @Deprecated(since="10.0")
    public IRubyObject avail_out() {
        return this.avail_out(this.getCurrentContext());
    }

    @JRubyMethod(name={"avail_out"})
    public IRubyObject avail_out(ThreadContext context) {
        return Convert.asFixnum(context, 0);
    }

    @Deprecated(since="10.0")
    public IRubyObject set_avail_out(IRubyObject p1) {
        return this.set_avail_out(this.getCurrentContext(), p1);
    }

    @JRubyMethod(name={"avail_out="})
    public IRubyObject set_avail_out(ThreadContext context, IRubyObject p1) {
        this.checkClosed(context);
        return p1;
    }

    @JRubyMethod(name={"adler"})
    public IRubyObject adler(ThreadContext context) {
        this.checkClosed(context);
        return Convert.asFixnum(context, this.internalAdler());
    }

    @Deprecated
    public IRubyObject adler() {
        return this.adler(this.getCurrentContext());
    }

    @JRubyMethod(name={"finish"})
    public IRubyObject finish(ThreadContext context, Block block) {
        this.checkClosed(context);
        IRubyObject result2 = this.internalFinish(context, block);
        return result2;
    }

    @Deprecated(since="10.0")
    public IRubyObject avail_in() {
        return this.avail_in(this.getCurrentContext());
    }

    @JRubyMethod(name={"avail_in"})
    public IRubyObject avail_in(ThreadContext context) {
        return Convert.asFixnum(context, 0);
    }

    @JRubyMethod(name={"flush_next_in"})
    public IRubyObject flush_next_in(ThreadContext context) {
        return RubyString.newEmptyBinaryString(context.getRuntime());
    }

    @Deprecated
    public IRubyObject total_in() {
        return this.total_in(this.getCurrentContext());
    }

    @JRubyMethod(name={"total_in"})
    public IRubyObject total_in(ThreadContext context) {
        this.checkClosed(context);
        return Convert.asFixnum(context, this.internalTotalIn());
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject finished_p(ThreadContext context) {
        this.checkClosed(context);
        return Convert.asBoolean(context, this.internalFinished());
    }

    @Deprecated(since="10.0")
    public IRubyObject close() {
        return this.close(this.getCurrentContext());
    }

    @JRubyMethod(name={"close", "end"})
    public IRubyObject close(ThreadContext context) {
        this.checkClosed(context);
        this.internalClose();
        this.closed = true;
        return context.nil;
    }

    @Deprecated(since="10.0")
    void checkClosed() {
        this.checkClosed(this.getCurrentContext());
    }

    void checkClosed(ThreadContext context) {
        if (this.closed) {
            throw RubyZlib.newZlibError(context, "stream is not ready");
        }
    }

    static int checkLevel(ThreadContext context, int level2) {
        if ((level2 < 0 || level2 > 9) && level2 != -1) {
            throw RubyZlib.newStreamError(context, "stream error: invalid level");
        }
        return level2;
    }

    static int checkWindowBits(ThreadContext context, int value2, boolean forInflate) {
        int wbits = Math.abs(value2);
        if ((wbits & 0xF) < 8) {
            throw RubyZlib.newStreamError(context, "stream error: invalid window bits");
        }
        if ((wbits & 0xF) != 15) {
            Warn.warn(context, "windowBits < 15 is ignored on this platform");
        }
        if (forInflate && wbits > 47) {
            throw RubyZlib.newStreamError(context, "stream error: invalid window bits");
        }
        if (!forInflate && wbits > 31) {
            throw RubyZlib.newStreamError(context, "stream error: invalid window bits");
        }
        return value2;
    }

    @Deprecated(since="10.0")
    static void checkStrategy(Ruby runtime2, int strategy) {
        ZStream.checkStrategy(runtime2.getCurrentContext(), strategy);
    }

    static void checkStrategy(ThreadContext context, int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw RubyZlib.newStreamError(context, "stream error: invalid strategy");
            }
        }
    }
}

