%% Generated by the Erlang ASN.1 BER compiler. Version: 5.3.1
%% Purpose: Encoding and decoding of the types in OTP-PUB-KEY.

-module('OTP-PUB-KEY').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("OTP-PUB-KEY.hrl").
-asn1_info([{vsn,'5.3.1'},
            {module,'OTP-PUB-KEY'},
            {options,[{i,"/build/erlang-nox/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/build/erlang-nox/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang-nox/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/build/erlang-nox/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_CurvePublicKey/2,
enc_CurvePrivateKey/2,
enc_ECPrivateKey/2,
enc_DSAPrivateKey/2,
enc_DHParameter/2,
enc_DigestAlgorithm/2,
'enc_DigestInfoPKCS-1'/2,
'enc_RSASSA-AlgorithmIdentifier'/2,
enc_TrailerField/2,
'enc_RSASSA-PSS-params'/2,
'enc_RSAES-AlgorithmIdentifier'/2,
'enc_RSAES-OAEP-params'/2,
enc_OtherPrimeInfo/2,
enc_OtherPrimeInfos/2,
'enc_VersionPKCS-1'/2,
enc_RSAPrivateKey/2,
enc_RSAPublicKey/2,
enc_PSourceAlgorithm/2,
enc_EncodingParameters/2,
enc_MaskGenAlgorithm/2,
enc_SHA1Parameters/2,
enc_HashAlgorithm/2,
enc_Curve/2,
enc_ECPVer/2,
enc_ECParameters/2,
enc_EcpkParameters/2,
enc_ECPoint/2,
enc_FieldElement/2,
enc_Pentanomial/2,
enc_Trinomial/2,
'enc_Characteristic-two'/2,
'enc_Prime-p'/2,
'enc_ECDSA-Sig-Value'/2,
enc_FieldID/2,
'enc_KEA-Parms-Id'/2,
enc_ValidationParms/2,
enc_DomainParameters/2,
enc_DHPublicKey/2,
'enc_Dss-Sig-Value'/2,
'enc_Dss-Parms'/2,
enc_DSAPublicKey/2,
enc_ProxyInfo/2,
enc_ACClearAttrs/2,
enc_AttrSpec/2,
enc_AAControls/2,
enc_SecurityCategory/2,
enc_ClassList/2,
enc_Clearance/2,
enc_RoleSyntax/2,
enc_SvceAuthInfo/2,
enc_IetfAttrSyntax/2,
enc_TargetCert/2,
enc_Target/2,
enc_Targets/2,
enc_AttCertValidityPeriod/2,
enc_IssuerSerial/2,
enc_V2Form/2,
enc_AttCertIssuer/2,
enc_ObjectDigestInfo/2,
enc_Holder/2,
enc_AttCertVersion/2,
enc_AttributeCertificateInfo/2,
enc_AttributeCertificate/2,
enc_InvalidityDate/2,
enc_HoldInstructionCode/2,
enc_CertificateIssuer/2,
enc_CRLReason/2,
enc_BaseCRLNumber/2,
enc_IssuingDistributionPoint/2,
enc_CRLNumber/2,
enc_SubjectInfoAccessSyntax/2,
enc_AccessDescription/2,
enc_AuthorityInfoAccessSyntax/2,
enc_FreshestCRL/2,
enc_InhibitAnyPolicy/2,
enc_KeyPurposeId/2,
enc_ExtKeyUsageSyntax/2,
enc_ReasonFlags/2,
enc_DistributionPointName/2,
enc_DistributionPoint/2,
enc_CRLDistributionPoints/2,
enc_SkipCerts/2,
enc_PolicyConstraints/2,
enc_BaseDistance/2,
enc_GeneralSubtree/2,
enc_GeneralSubtrees/2,
enc_NameConstraints/2,
enc_BasicConstraints/2,
enc_SubjectDirectoryAttributes/2,
enc_IssuerAltName/2,
enc_EDIPartyName/2,
enc_AnotherName/2,
enc_GeneralName/2,
enc_GeneralNames/2,
enc_SubjectAltName/2,
enc_PolicyMappings/2,
enc_DisplayText/2,
enc_NoticeReference/2,
enc_UserNotice/2,
enc_CPSuri/2,
enc_PolicyQualifierId/2,
enc_PolicyQualifierInfo/2,
enc_CertPolicyId/2,
enc_PolicyInformation/2,
enc_CertificatePolicies/2,
enc_PrivateKeyUsagePeriod/2,
enc_KeyUsage/2,
enc_SubjectKeyIdentifier/2,
enc_KeyIdentifier/2,
enc_AuthorityKeyIdentifier/2,
enc_EncryptedData/2,
enc_DigestedData/2,
enc_SignedAndEnvelopedData/2,
enc_EncryptedKey/2,
enc_RecipientInfo/2,
enc_EncryptedContent/2,
enc_EncryptedContentInfo/2,
enc_RecipientInfos/2,
enc_EnvelopedData/2,
enc_Digest/2,
'enc_DigestInfoPKCS-7'/2,
enc_EncryptedDigest/2,
enc_SignerInfo/2,
enc_DigestAlgorithmIdentifiers/2,
enc_SignerInfos/2,
enc_SignedData/2,
enc_Data/2,
enc_ContentType/2,
enc_ContentInfo/2,
enc_KeyEncryptionAlgorithmIdentifier/2,
enc_IssuerAndSerialNumber/2,
enc_ExtendedCertificatesAndCertificates/2,
enc_ExtendedCertificate/2,
enc_ExtendedCertificateOrCertificate/2,
enc_DigestEncryptionAlgorithmIdentifier/2,
enc_DigestAlgorithmIdentifier/2,
enc_ContentEncryptionAlgorithmIdentifier/2,
enc_CRLSequence/2,
enc_Certificates/2,
enc_CertificateRevocationLists/2,
enc_SignerInfoAuthenticatedAttributes/2,
enc_SigningTime/2,
enc_MessageDigest/2,
enc_CertificationRequest/2,
enc_CertificationRequestInfo/2,
enc_ExtensionRequest/2,
'enc_AES-IV'/2,
enc_Nonce/2,
enc_PreferredSignatureAlgorithm/2,
enc_PreferredSignatureAlgorithms/2,
enc_CrlID/2,
enc_ServiceLocator/2,
enc_AcceptableResponses/2,
enc_ArchiveCutoff/2,
enc_UnknownInfo/2,
enc_RevokedInfo/2,
enc_CertStatus/2,
enc_SingleResponse/2,
enc_KeyHash/2,
enc_ResponderID/2,
enc_ResponseData/2,
enc_BasicOCSPResponse/2,
enc_ResponseBytes/2,
enc_OCSPResponseStatus/2,
enc_OCSPResponse/2,
enc_CertID/2,
enc_Request/2,
'enc_VersionOCSP-2013-88'/2,
enc_Signature/2,
enc_TBSRequest/2,
enc_OCSPRequest/2,
enc_TeletexDomainDefinedAttribute/2,
enc_TeletexDomainDefinedAttributes/2,
enc_TerminalType/2,
enc_PresentationAddress/2,
enc_ExtendedNetworkAddress/2,
enc_PDSParameter/2,
enc_LocalPostalAttributes/2,
enc_UniquePostalName/2,
enc_PosteRestanteAddress/2,
enc_PostOfficeBoxAddress/2,
enc_StreetAddress/2,
enc_UnformattedPostalAddress/2,
enc_ExtensionPhysicalDeliveryAddressComponents/2,
enc_PhysicalDeliveryOrganizationName/2,
enc_PhysicalDeliveryPersonalName/2,
enc_ExtensionORAddressComponents/2,
enc_PhysicalDeliveryOfficeNumber/2,
enc_PhysicalDeliveryOfficeName/2,
enc_PostalCode/2,
enc_PhysicalDeliveryCountryName/2,
enc_PDSName/2,
enc_TeletexOrganizationalUnitName/2,
enc_TeletexOrganizationalUnitNames/2,
enc_TeletexPersonalName/2,
enc_TeletexOrganizationName/2,
enc_TeletexCommonName/2,
enc_CommonName/2,
enc_ExtensionAttribute/2,
enc_ExtensionAttributes/2,
enc_BuiltInDomainDefinedAttribute/2,
enc_BuiltInDomainDefinedAttributes/2,
enc_OrganizationalUnitName/2,
enc_OrganizationalUnitNames/2,
enc_PersonalName/2,
enc_NumericUserIdentifier/2,
enc_OrganizationName/2,
enc_PrivateDomainName/2,
enc_TerminalIdentifier/2,
enc_X121Address/2,
enc_NetworkAddress/2,
enc_AdministrationDomainName/2,
enc_CountryName/2,
enc_BuiltInStandardAttributes/2,
enc_ORAddress/2,
enc_AlgorithmIdentifier/2,
enc_TBSCertList/2,
enc_CertificateList/2,
enc_Extension/2,
enc_Extensions/2,
enc_SubjectPublicKeyInfo/2,
enc_UniqueIdentifier/2,
enc_Time/2,
enc_Validity/2,
enc_CertificateSerialNumber/2,
enc_VersionPKIX1Explicit88/2,
enc_TBSCertificate/2,
enc_Certificate/2,
enc_DirectoryString/2,
enc_RelativeDistinguishedName/2,
enc_DistinguishedName/2,
enc_RDNSequence/2,
enc_Name/2,
enc_EmailAddress/2,
enc_DomainComponent/2,
enc_X520Pseudonym/2,
enc_X520SerialNumber/2,
enc_X520countryName/2,
enc_X520dnQualifier/2,
enc_X520Title/2,
enc_X520OrganizationalUnitName/2,
enc_X520OrganizationName/2,
enc_X520StateOrProvinceName/2,
enc_X520LocalityName/2,
enc_X520CommonName/2,
enc_X520name/2,
enc_AttributeTypeAndValue/2,
enc_AttributeValue/2,
enc_AttributeType/2,
enc_Attribute/2,
enc_OTPDisplayText/2,
enc_OTPNoticeReference/2,
enc_OTPUserNotice/2,
'enc_Extension-Any'/2,
enc_Any/2,
enc_Boolean/2,
enc_ObjId/2,
enc_OTPExtension/2,
enc_OTPExtensions/2,
enc_OTPExtensionAttribute/2,
enc_OTPExtensionAttributes/2,
'enc_OTPCharacteristic-two'/2,
enc_OTPFieldID/2,
'enc_KEA-PublicKey'/2,
enc_DSAParams/2,
enc_PublicKeyAlgorithm/2,
'enc_SignatureAlgorithm-Any'/2,
enc_SignatureAlgorithm/2,
'enc_OTPSubjectPublicKeyInfo-Any'/2,
enc_OTPSubjectPublicKeyInfo/2,
enc_OTPOLDSubjectPublicKeyInfo/2,
'enc_OTP-emailAddress'/2,
'enc_OTP-X520countryname'/2,
enc_OTPAttributeTypeAndValue/2,
enc_OTPTBSCertificate/2,
enc_OTPCertificate/2
]).

-export([
dec_CurvePublicKey/2,
dec_CurvePrivateKey/2,
dec_ECPrivateKey/2,
dec_DSAPrivateKey/2,
dec_DHParameter/2,
dec_DigestAlgorithm/2,
'dec_DigestInfoPKCS-1'/2,
'dec_RSASSA-AlgorithmIdentifier'/2,
dec_TrailerField/2,
'dec_RSASSA-PSS-params'/2,
'dec_RSAES-AlgorithmIdentifier'/2,
'dec_RSAES-OAEP-params'/2,
dec_OtherPrimeInfo/2,
dec_OtherPrimeInfos/2,
'dec_VersionPKCS-1'/2,
dec_RSAPrivateKey/2,
dec_RSAPublicKey/2,
dec_PSourceAlgorithm/2,
dec_EncodingParameters/2,
dec_MaskGenAlgorithm/2,
dec_SHA1Parameters/2,
dec_HashAlgorithm/2,
dec_Curve/2,
dec_ECPVer/2,
dec_ECParameters/2,
dec_EcpkParameters/2,
dec_ECPoint/2,
dec_FieldElement/2,
dec_Pentanomial/2,
dec_Trinomial/2,
'dec_Characteristic-two'/2,
'dec_Prime-p'/2,
'dec_ECDSA-Sig-Value'/2,
dec_FieldID/2,
'dec_KEA-Parms-Id'/2,
dec_ValidationParms/2,
dec_DomainParameters/2,
dec_DHPublicKey/2,
'dec_Dss-Sig-Value'/2,
'dec_Dss-Parms'/2,
dec_DSAPublicKey/2,
dec_ProxyInfo/2,
dec_ACClearAttrs/2,
dec_AttrSpec/2,
dec_AAControls/2,
dec_SecurityCategory/2,
dec_ClassList/2,
dec_Clearance/2,
dec_RoleSyntax/2,
dec_SvceAuthInfo/2,
dec_IetfAttrSyntax/2,
dec_TargetCert/2,
dec_Target/2,
dec_Targets/2,
dec_AttCertValidityPeriod/2,
dec_IssuerSerial/2,
dec_V2Form/2,
dec_AttCertIssuer/2,
dec_ObjectDigestInfo/2,
dec_Holder/2,
dec_AttCertVersion/2,
dec_AttributeCertificateInfo/2,
dec_AttributeCertificate/2,
dec_InvalidityDate/2,
dec_HoldInstructionCode/2,
dec_CertificateIssuer/2,
dec_CRLReason/2,
dec_BaseCRLNumber/2,
dec_IssuingDistributionPoint/2,
dec_CRLNumber/2,
dec_SubjectInfoAccessSyntax/2,
dec_AccessDescription/2,
dec_AuthorityInfoAccessSyntax/2,
dec_FreshestCRL/2,
dec_InhibitAnyPolicy/2,
dec_KeyPurposeId/2,
dec_ExtKeyUsageSyntax/2,
dec_ReasonFlags/2,
dec_DistributionPointName/2,
dec_DistributionPoint/2,
dec_CRLDistributionPoints/2,
dec_SkipCerts/2,
dec_PolicyConstraints/2,
dec_BaseDistance/2,
dec_GeneralSubtree/2,
dec_GeneralSubtrees/2,
dec_NameConstraints/2,
dec_BasicConstraints/2,
dec_SubjectDirectoryAttributes/2,
dec_IssuerAltName/2,
dec_EDIPartyName/2,
dec_AnotherName/2,
dec_GeneralName/2,
dec_GeneralNames/2,
dec_SubjectAltName/2,
dec_PolicyMappings/2,
dec_DisplayText/2,
dec_NoticeReference/2,
dec_UserNotice/2,
dec_CPSuri/2,
dec_PolicyQualifierId/2,
dec_PolicyQualifierInfo/2,
dec_CertPolicyId/2,
dec_PolicyInformation/2,
dec_CertificatePolicies/2,
dec_PrivateKeyUsagePeriod/2,
dec_KeyUsage/2,
dec_SubjectKeyIdentifier/2,
dec_KeyIdentifier/2,
dec_AuthorityKeyIdentifier/2,
dec_EncryptedData/2,
dec_DigestedData/2,
dec_SignedAndEnvelopedData/2,
dec_EncryptedKey/2,
dec_RecipientInfo/2,
dec_EncryptedContent/2,
dec_EncryptedContentInfo/2,
dec_RecipientInfos/2,
dec_EnvelopedData/2,
dec_Digest/2,
'dec_DigestInfoPKCS-7'/2,
dec_EncryptedDigest/2,
dec_SignerInfo/2,
dec_DigestAlgorithmIdentifiers/2,
dec_SignerInfos/2,
dec_SignedData/2,
dec_Data/2,
dec_ContentType/2,
dec_ContentInfo/2,
dec_KeyEncryptionAlgorithmIdentifier/2,
dec_IssuerAndSerialNumber/2,
dec_ExtendedCertificatesAndCertificates/2,
dec_ExtendedCertificate/2,
dec_ExtendedCertificateOrCertificate/2,
dec_DigestEncryptionAlgorithmIdentifier/2,
dec_DigestAlgorithmIdentifier/2,
dec_ContentEncryptionAlgorithmIdentifier/2,
dec_CRLSequence/2,
dec_Certificates/2,
dec_CertificateRevocationLists/2,
dec_SignerInfoAuthenticatedAttributes/2,
dec_SigningTime/2,
dec_MessageDigest/2,
dec_CertificationRequest/2,
dec_CertificationRequestInfo/2,
dec_ExtensionRequest/2,
'dec_AES-IV'/2,
dec_Nonce/2,
dec_PreferredSignatureAlgorithm/2,
dec_PreferredSignatureAlgorithms/2,
dec_CrlID/2,
dec_ServiceLocator/2,
dec_AcceptableResponses/2,
dec_ArchiveCutoff/2,
dec_UnknownInfo/2,
dec_RevokedInfo/2,
dec_CertStatus/2,
dec_SingleResponse/2,
dec_KeyHash/2,
dec_ResponderID/2,
dec_ResponseData/2,
dec_BasicOCSPResponse/2,
dec_ResponseBytes/2,
dec_OCSPResponseStatus/2,
dec_OCSPResponse/2,
dec_CertID/2,
dec_Request/2,
'dec_VersionOCSP-2013-88'/2,
dec_Signature/2,
dec_TBSRequest/2,
dec_OCSPRequest/2,
dec_TeletexDomainDefinedAttribute/2,
dec_TeletexDomainDefinedAttributes/2,
dec_TerminalType/2,
dec_PresentationAddress/2,
dec_ExtendedNetworkAddress/2,
dec_PDSParameter/2,
dec_LocalPostalAttributes/2,
dec_UniquePostalName/2,
dec_PosteRestanteAddress/2,
dec_PostOfficeBoxAddress/2,
dec_StreetAddress/2,
dec_UnformattedPostalAddress/2,
dec_ExtensionPhysicalDeliveryAddressComponents/2,
dec_PhysicalDeliveryOrganizationName/2,
dec_PhysicalDeliveryPersonalName/2,
dec_ExtensionORAddressComponents/2,
dec_PhysicalDeliveryOfficeNumber/2,
dec_PhysicalDeliveryOfficeName/2,
dec_PostalCode/2,
dec_PhysicalDeliveryCountryName/2,
dec_PDSName/2,
dec_TeletexOrganizationalUnitName/2,
dec_TeletexOrganizationalUnitNames/2,
dec_TeletexPersonalName/2,
dec_TeletexOrganizationName/2,
dec_TeletexCommonName/2,
dec_CommonName/2,
dec_ExtensionAttribute/2,
dec_ExtensionAttributes/2,
dec_BuiltInDomainDefinedAttribute/2,
dec_BuiltInDomainDefinedAttributes/2,
dec_OrganizationalUnitName/2,
dec_OrganizationalUnitNames/2,
dec_PersonalName/2,
dec_NumericUserIdentifier/2,
dec_OrganizationName/2,
dec_PrivateDomainName/2,
dec_TerminalIdentifier/2,
dec_X121Address/2,
dec_NetworkAddress/2,
dec_AdministrationDomainName/2,
dec_CountryName/2,
dec_BuiltInStandardAttributes/2,
dec_ORAddress/2,
dec_AlgorithmIdentifier/2,
dec_TBSCertList/2,
dec_CertificateList/2,
dec_Extension/2,
dec_Extensions/2,
dec_SubjectPublicKeyInfo/2,
dec_UniqueIdentifier/2,
dec_Time/2,
dec_Validity/2,
dec_CertificateSerialNumber/2,
dec_VersionPKIX1Explicit88/2,
dec_TBSCertificate/2,
dec_Certificate/2,
dec_DirectoryString/2,
dec_RelativeDistinguishedName/2,
dec_DistinguishedName/2,
dec_RDNSequence/2,
dec_Name/2,
dec_EmailAddress/2,
dec_DomainComponent/2,
dec_X520Pseudonym/2,
dec_X520SerialNumber/2,
dec_X520countryName/2,
dec_X520dnQualifier/2,
dec_X520Title/2,
dec_X520OrganizationalUnitName/2,
dec_X520OrganizationName/2,
dec_X520StateOrProvinceName/2,
dec_X520LocalityName/2,
dec_X520CommonName/2,
dec_X520name/2,
dec_AttributeTypeAndValue/2,
dec_AttributeValue/2,
dec_AttributeType/2,
dec_Attribute/2,
dec_OTPDisplayText/2,
dec_OTPNoticeReference/2,
dec_OTPUserNotice/2,
'dec_Extension-Any'/2,
dec_Any/2,
dec_Boolean/2,
dec_ObjId/2,
dec_OTPExtension/2,
dec_OTPExtensions/2,
dec_OTPExtensionAttribute/2,
dec_OTPExtensionAttributes/2,
'dec_OTPCharacteristic-two'/2,
dec_OTPFieldID/2,
'dec_KEA-PublicKey'/2,
dec_DSAParams/2,
dec_PublicKeyAlgorithm/2,
'dec_SignatureAlgorithm-Any'/2,
dec_SignatureAlgorithm/2,
'dec_OTPSubjectPublicKeyInfo-Any'/2,
dec_OTPSubjectPublicKeyInfo/2,
dec_OTPOLDSubjectPublicKeyInfo/2,
'dec_OTP-emailAddress'/2,
'dec_OTP-X520countryname'/2,
dec_OTPAttributeTypeAndValue/2,
dec_OTPTBSCertificate/2,
dec_OTPCertificate/2
]).

-export([
enc_recipientNonce/3,
enc_senderNonce/3,
enc_failInfo/3,
enc_pkiStatus/3,
enc_messageType/3,
enc_transactionID/3,
enc_signingTime/3,
enc_messageDigest/3,
enc_counterSignature/3,
enc_contentType/3,
enc_extensionRequest/3,
enc_challengePassword/3,
enc_invalidityDate/3,
enc_holdInstructionCode/3,
enc_certificateIssuer/3,
enc_cRLReasons/3,
enc_deltaCRLIndicator/3,
enc_issuingDistributionPoint/3,
enc_cRLNumber/3,
enc_subjectInfoAccess/3,
enc_authorityInfoAccess/3,
enc_freshestCRL/3,
enc_inhibitAnyPolicy/3,
enc_extKeyUsage/3,
enc_cRLDistributionPoints/3,
enc_policyConstraints/3,
enc_nameConstraints/3,
enc_basicConstraints/3,
enc_subjectDirectoryAttributes/3,
enc_issuerAltName/3,
enc_subjectAltName/3,
enc_policyMappings/3,
enc_certificatePolicies/3,
enc_privateKeyUsagePeriod/3,
enc_keyUsage/3,
enc_subjectKeyIdentifier/3,
enc_authorityKeyIdentifier/3,
'enc_x400-teletex-domain-defined-attributes'/3,
'enc_x400-terminal-type'/3,
'enc_x400-extended-network-address'/3,
'enc_x400-local-postal-attributes'/3,
'enc_x400-unique-postal-name'/3,
'enc_x400-poste-restante-address'/3,
'enc_x400-post-office-box-address'/3,
'enc_x400-street-address'/3,
'enc_x400-unformatted-postal-address'/3,
'enc_x400-extension-physical-delivery-address-components'/3,
'enc_x400-physical-delivery-organization-name'/3,
'enc_x400-physical-delivery-personal-name'/3,
'enc_x400-extension-OR-address-components'/3,
'enc_x400-physical-delivery-office-number'/3,
'enc_x400-physical-delivery-office-name'/3,
'enc_x400-postal-code'/3,
'enc_x400-physical-delivery-country-name'/3,
'enc_x400-pds-name'/3,
'enc_x400-teletex-personal-name'/3,
'enc_x400-teletex-common-name'/3,
'enc_x400-common-name'/3,
'enc_ec-public-key'/3,
'enc_pp-basis'/3,
'enc_tp-basis'/3,
'enc_gn-basis'/3,
'enc_field-characteristic-two'/3,
'enc_field-prime-field'/3,
'enc_ecdsa-with-sha512'/3,
'enc_ecdsa-with-sha384'/3,
'enc_ecdsa-with-sha256'/3,
'enc_ecdsa-with-sha224'/3,
'enc_ecdsa-with-sha1'/3,
enc_kea/3,
enc_dh/3,
'enc_rsa-pss'/3,
'enc_rsa-encryption'/3,
'enc_rsassa-pss'/3,
'enc_sha512-with-rsa-encryption'/3,
'enc_sha384-with-rsa-encryption'/3,
'enc_sha256-with-rsa-encryption'/3,
'enc_sha224-with-rsa-encryption'/3,
'enc_sha-1with-rsa-encryption'/3,
'enc_sha1-with-rsa-encryption'/3,
'enc_md5-with-rsa-encryption'/3,
'enc_md2-with-rsa-encryption'/3,
'enc_dsa-with-sha256'/3,
'enc_dsa-with-sha224'/3,
enc_dsaWithSHA1/3,
'enc_dsa-with-sha1'/3,
enc_dsa/3,
enc_emailAddress/3,
enc_domainComponent/3,
enc_pseudonym/3,
enc_serialNumber/3,
enc_countryName/3,
enc_dnQualifier/3,
enc_title/3,
enc_organizationalUnitName/3,
enc_organizationName/3,
enc_stateOrProvinceName/3,
enc_localityName/3,
enc_commonName/3,
enc_generationQualifier/3,
enc_initials/3,
enc_givenName/3,
enc_surname/3,
enc_name/3
]).

-export([
dec_recipientNonce/3,
dec_senderNonce/3,
dec_failInfo/3,
dec_pkiStatus/3,
dec_messageType/3,
dec_transactionID/3,
dec_signingTime/3,
dec_messageDigest/3,
dec_counterSignature/3,
dec_contentType/3,
dec_extensionRequest/3,
dec_challengePassword/3,
dec_invalidityDate/3,
dec_holdInstructionCode/3,
dec_certificateIssuer/3,
dec_cRLReasons/3,
dec_deltaCRLIndicator/3,
dec_issuingDistributionPoint/3,
dec_cRLNumber/3,
dec_subjectInfoAccess/3,
dec_authorityInfoAccess/3,
dec_freshestCRL/3,
dec_inhibitAnyPolicy/3,
dec_extKeyUsage/3,
dec_cRLDistributionPoints/3,
dec_policyConstraints/3,
dec_nameConstraints/3,
dec_basicConstraints/3,
dec_subjectDirectoryAttributes/3,
dec_issuerAltName/3,
dec_subjectAltName/3,
dec_policyMappings/3,
dec_certificatePolicies/3,
dec_privateKeyUsagePeriod/3,
dec_keyUsage/3,
dec_subjectKeyIdentifier/3,
dec_authorityKeyIdentifier/3,
'dec_x400-teletex-domain-defined-attributes'/3,
'dec_x400-terminal-type'/3,
'dec_x400-extended-network-address'/3,
'dec_x400-local-postal-attributes'/3,
'dec_x400-unique-postal-name'/3,
'dec_x400-poste-restante-address'/3,
'dec_x400-post-office-box-address'/3,
'dec_x400-street-address'/3,
'dec_x400-unformatted-postal-address'/3,
'dec_x400-extension-physical-delivery-address-components'/3,
'dec_x400-physical-delivery-organization-name'/3,
'dec_x400-physical-delivery-personal-name'/3,
'dec_x400-extension-OR-address-components'/3,
'dec_x400-physical-delivery-office-number'/3,
'dec_x400-physical-delivery-office-name'/3,
'dec_x400-postal-code'/3,
'dec_x400-physical-delivery-country-name'/3,
'dec_x400-pds-name'/3,
'dec_x400-teletex-personal-name'/3,
'dec_x400-teletex-common-name'/3,
'dec_x400-common-name'/3,
'dec_ec-public-key'/3,
'dec_pp-basis'/3,
'dec_tp-basis'/3,
'dec_gn-basis'/3,
'dec_field-characteristic-two'/3,
'dec_field-prime-field'/3,
'dec_ecdsa-with-sha512'/3,
'dec_ecdsa-with-sha384'/3,
'dec_ecdsa-with-sha256'/3,
'dec_ecdsa-with-sha224'/3,
'dec_ecdsa-with-sha1'/3,
dec_kea/3,
dec_dh/3,
'dec_rsa-pss'/3,
'dec_rsa-encryption'/3,
'dec_rsassa-pss'/3,
'dec_sha512-with-rsa-encryption'/3,
'dec_sha384-with-rsa-encryption'/3,
'dec_sha256-with-rsa-encryption'/3,
'dec_sha224-with-rsa-encryption'/3,
'dec_sha-1with-rsa-encryption'/3,
'dec_sha1-with-rsa-encryption'/3,
'dec_md5-with-rsa-encryption'/3,
'dec_md2-with-rsa-encryption'/3,
'dec_dsa-with-sha256'/3,
'dec_dsa-with-sha224'/3,
dec_dsaWithSHA1/3,
'dec_dsa-with-sha1'/3,
dec_dsa/3,
dec_emailAddress/3,
dec_domainComponent/3,
dec_pseudonym/3,
dec_serialNumber/3,
dec_countryName/3,
dec_dnQualifier/3,
dec_title/3,
dec_organizationalUnitName/3,
dec_organizationName/3,
dec_stateOrProvinceName/3,
dec_localityName/3,
dec_commonName/3,
dec_generationQualifier/3,
dec_initials/3,
dec_givenName/3,
dec_surname/3,
dec_name/3
]).

-export([
getenc_PKCS1Algorithms/1,
getenc_PKCS1PSourceAlgorithms/1,
getenc_PKCS1MGFAlgorithms/1,
'getenc_PKCS1-v1-5DigestAlgorithms'/1,
'getenc_OAEP-PSSDigestAlgorithms'/1,
getenc_Unauthenticated/1,
getenc_Authenticated/1,
getenc_Contents/1,
getenc_KeyEncryptionAlgorithms/1,
getenc_DigestEncryptionAlgorithms/1,
getenc_DigestAlgorithms/1,
getenc_ContentEncryptionAlgorithms/1,
getenc_SignatureAlgorithms/1,
getenc_CRIAttributes/1,
getenc_PKInfoAlgorithms/1,
getenc_SupportedExtensions/1,
getenc_SupportedExtensionAttributes/1,
getenc_SupportedCharacteristicTwos/1,
getenc_SupportedFieldIds/1,
getenc_SupportedPublicKeyAlgorithms/1,
getenc_SupportedSignatureAlgorithms/1,
getenc_SupportedAttributeTypeAndValues/1,
getenc_internal_object_set_argument_9/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_1/1,
getenc_internal_object_set_argument_19/1,
getenc_internal_object_set_argument_18/1,
getenc_internal_object_set_argument_17/1,
getenc_internal_object_set_argument_16/1,
getenc_internal_object_set_argument_15/1,
getenc_internal_object_set_argument_14/1,
getenc_internal_object_set_argument_13/1,
getenc_internal_object_set_argument_12/1,
getenc_internal_object_set_argument_11/1,
getenc_internal_object_set_argument_10/1
]).

-export([
getdec_PKCS1Algorithms/1,
getdec_PKCS1PSourceAlgorithms/1,
getdec_PKCS1MGFAlgorithms/1,
'getdec_PKCS1-v1-5DigestAlgorithms'/1,
'getdec_OAEP-PSSDigestAlgorithms'/1,
getdec_Unauthenticated/1,
getdec_Authenticated/1,
getdec_Contents/1,
getdec_KeyEncryptionAlgorithms/1,
getdec_DigestEncryptionAlgorithms/1,
getdec_DigestAlgorithms/1,
getdec_ContentEncryptionAlgorithms/1,
getdec_SignatureAlgorithms/1,
getdec_CRIAttributes/1,
getdec_PKInfoAlgorithms/1,
getdec_SupportedExtensions/1,
getdec_SupportedExtensionAttributes/1,
getdec_SupportedCharacteristicTwos/1,
getdec_SupportedFieldIds/1,
getdec_SupportedPublicKeyAlgorithms/1,
getdec_SupportedSignatureAlgorithms/1,
getdec_SupportedAttributeTypeAndValues/1,
getdec_internal_object_set_argument_9/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_1/1,
getdec_internal_object_set_argument_19/1,
getdec_internal_object_set_argument_18/1,
getdec_internal_object_set_argument_17/1,
getdec_internal_object_set_argument_16/1,
getdec_internal_object_set_argument_15/1,
getdec_internal_object_set_argument_14/1,
getdec_internal_object_set_argument_13/1,
getdec_internal_object_set_argument_12/1,
getdec_internal_object_set_argument_11/1,
getdec_internal_object_set_argument_10/1
]).

-export([
dhKeyAgreement/0,
'pkcs-3'/0,
'rSASSA-PSS-Default-Identifier'/0,
'rSAES-OAEP-Default-Identifier'/0,
emptyString/0,
pSpecifiedEmpty/0,
mgf1SHA1/0,
sha1/0,
'id-mgf1'/0,
'id-sha512'/0,
'id-sha384'/0,
'id-sha256'/0,
'id-sha224'/0,
'id-hmacWithSHA512'/0,
'id-hmacWithSHA384'/0,
'id-hmacWithSHA256'/0,
'id-hmacWithSHA224'/0,
'id-md5'/0,
'id-md2'/0,
'id-sha1'/0,
'sha-1WithRSAEncryption'/0,
'sha512-256WithRSAEncryption'/0,
'sha512-224WithRSAEncryption'/0,
sha512WithRSAEncryption/0,
sha384WithRSAEncryption/0,
sha256WithRSAEncryption/0,
sha224WithRSAEncryption/0,
sha1WithRSAEncryption/0,
md5WithRSAEncryption/0,
md2WithRSAEncryption/0,
'id-RSASSA-PSS'/0,
'id-pSpecified'/0,
'id-RSAES-OAEP'/0,
rsaEncryption/0,
'pkcs-1'/0,
'id-Ed448'/0,
'id-Ed25519'/0,
'id-X448'/0,
'id-X25519'/0,
'id-edwards-curve-algs'/0,
sect571r1/0,
sect571k1/0,
sect409r1/0,
sect409k1/0,
secp521r1/0,
secp384r1/0,
secp224r1/0,
secp224k1/0,
secp192k1/0,
secp160r2/0,
secp128r2/0,
secp128r1/0,
sect233r1/0,
sect233k1/0,
sect193r2/0,
sect193r1/0,
sect131r2/0,
sect131r1/0,
sect283r1/0,
sect283k1/0,
sect163r2/0,
secp256k1/0,
secp160k1/0,
secp160r1/0,
secp112r2/0,
secp112r1/0,
sect113r2/0,
sect113r1/0,
sect239k1/0,
sect163r1/0,
sect163k1/0,
secp256r1/0,
secp192r1/0,
ellipticCurve/0,
'certicom-arc'/0,
'id-ecPublicKey'/0,
'id-publicKeyType'/0,
ppBasis/0,
tpBasis/0,
gnBasis/0,
'id-characteristic-two-basis'/0,
'characteristic-two-field'/0,
'prime-field'/0,
'id-fieldType'/0,
'ecdsa-with-SHA512'/0,
'ecdsa-with-SHA384'/0,
'ecdsa-with-SHA256'/0,
'ecdsa-with-SHA224'/0,
'ecdsa-with-SHA2'/0,
'ecdsa-with-SHA1'/0,
'id-ecSigType'/0,
'ansi-X9-62'/0,
'id-keyExchangeAlgorithm'/0,
dhpublicnumber/0,
'id-dsaWithSHA1'/0,
'id-dsa-with-sha1'/0,
'id-dsa'/0,
'id-at-clearance'/0,
'id-at-role'/0,
'id-aca-encAttrs'/0,
'id-aca-group'/0,
'id-aca-chargingIdentity'/0,
'id-aca-accessIdentity'/0,
'id-aca-authenticationInfo'/0,
'id-aca'/0,
'id-ce-targetInformation'/0,
'id-pe-ac-proxying'/0,
'id-pe-aaControls'/0,
'id-pe-ac-auditIdentity'/0,
'id-ce-invalidityDate'/0,
'id-holdinstruction-reject'/0,
'id-holdinstruction-callissuer'/0,
'id-holdinstruction-none'/0,
holdInstruction/0,
'id-ce-holdInstructionCode'/0,
'id-ce-certificateIssuer'/0,
'id-ce-cRLReasons'/0,
'id-ce-deltaCRLIndicator'/0,
'id-ce-issuingDistributionPoint'/0,
'id-ce-cRLNumber'/0,
'id-pe-subjectInfoAccess'/0,
'id-pe-authorityInfoAccess'/0,
'id-ce-freshestCRL'/0,
'id-ce-inhibitAnyPolicy'/0,
'id-kp-OCSPSigning'/0,
'id-kp-timeStamping'/0,
'id-kp-emailProtection'/0,
'id-kp-codeSigning'/0,
'id-kp-clientAuth'/0,
'id-kp-serverAuth'/0,
anyExtendedKeyUsage/0,
'id-ce-extKeyUsage'/0,
'id-ce-cRLDistributionPoints'/0,
'id-ce-policyConstraints'/0,
'id-ce-nameConstraints'/0,
'id-ce-basicConstraints'/0,
'id-ce-subjectDirectoryAttributes'/0,
'id-ce-issuerAltName'/0,
'id-ce-subjectAltName'/0,
'id-ce-policyMappings'/0,
anyPolicy/0,
'id-ce-certificatePolicies'/0,
'id-ce-privateKeyUsagePeriod'/0,
'id-ce-keyUsage'/0,
'id-ce-subjectKeyIdentifier'/0,
'id-ce-authorityKeyIdentifier'/0,
'id-ce'/0,
'id-extensionReq'/0,
'id-transId'/0,
'id-recipientNonce'/0,
'id-senderNonce'/0,
'id-failInfo'/0,
'id-pkiStatus'/0,
'id-messageType'/0,
'id-attributes'/0,
'id-pki'/0,
'id-VeriSign'/0,
encryptedData/0,
digestedData/0,
signedAndEnvelopedData/0,
envelopedData/0,
signedData/0,
data/0,
'pkcs-7'/0,
'pkcs-9-at-counterSignature'/0,
'pkcs-9-at-signingTime'/0,
'pkcs-9-at-messageDigest'/0,
'pkcs-9-at-contentType'/0,
'pkcs-9'/0,
'pkcs-9-at-extensionRequest'/0,
'pkcs-9-at-challengePassword'/0,
brainpoolP512t1/0,
brainpoolP512r1/0,
brainpoolP384t1/0,
brainpoolP384r1/0,
brainpoolP320t1/0,
brainpoolP320r1/0,
brainpoolP256t1/0,
brainpoolP256r1/0,
brainpoolP224t1/0,
brainpoolP224r1/0,
brainpoolP192t1/0,
brainpoolP192r1/0,
brainpoolP160t1/0,
brainpoolP160r1/0,
versionOne/0,
ellipticCurveRFC5639/0,
ecStdCurvesAndGeneration/0,
'id-aes256-wrap'/0,
'id-aes192-wrap'/0,
'id-aes128-wrap'/0,
'id-aes256-CBC'/0,
'id-aes192-CBC'/0,
'id-aes128-CBC'/0,
aes/0,
'id-pkix-ocsp-extended-revoke'/0,
'id-pkix-ocsp-pref-sig-algs'/0,
'id-pkix-ocsp-service-locator'/0,
'id-pkix-ocsp-archive-cutoff'/0,
'id-pkix-ocsp-nocheck'/0,
'id-pkix-ocsp-response'/0,
'id-pkix-ocsp-crl'/0,
'id-pkix-ocsp-nonce'/0,
'id-pkix-ocsp-basic'/0,
'id-pkix-ocsp'/0,
'ub-x121-address-length'/0,
'ub-unformatted-address-length'/0,
'ub-terminal-id-length'/0,
'ub-surname-length'/0,
'ub-pseudonym-universal'/0,
'ub-pseudonym-utf8'/0,
'ub-pseudonym'/0,
'ub-postal-code-length'/0,
'ub-pds-physical-address-lines'/0,
'ub-pds-parameter-length'/0,
'ub-pds-name-length'/0,
'ub-organizational-units'/0,
'ub-numeric-user-id-length'/0,
'ub-integer-options'/0,
'ub-initials-length'/0,
'ub-given-name-length'/0,
'ub-generation-qualifier-length'/0,
'ub-e163-4-sub-address-length'/0,
'ub-e163-4-number-length'/0,
'ub-extension-attributes'/0,
'ub-domain-name-length'/0,
'ub-domain-defined-attribute-value-length'/0,
'ub-domain-defined-attribute-type-length'/0,
'ub-domain-defined-attributes'/0,
'ub-country-name-numeric-length'/0,
'ub-country-name-alpha-length'/0,
'ub-emailaddress-length'/0,
'ub-match'/0,
'ub-serial-number'/0,
'ub-title-utf8'/0,
'ub-title-universal'/0,
'ub-title-printable'/0,
'ub-title-teletex'/0,
'ub-title'/0,
'ub-organizational-unit-name-utf8'/0,
'ub-organizational-unit-name-universal'/0,
'ub-organizational-unit-name-teletex'/0,
'ub-organizational-unit-name-printable'/0,
'ub-organizational-unit-name'/0,
'ub-organization-name-utf8'/0,
'ub-organization-name-universal'/0,
'ub-organization-name-teletex'/0,
'ub-organization-name-printable'/0,
'ub-organization-name'/0,
'ub-state-name-utf8'/0,
'ub-state-name-universal'/0,
'ub-state-name'/0,
'ub-locality-name-universal'/0,
'ub-locality-name-utf8'/0,
'ub-locality-name'/0,
'ub-common-name-utf8'/0,
'ub-common-name-universal'/0,
'ub-common-name-printable'/0,
'ub-common-name-teletex'/0,
'ub-common-name'/0,
'ub-name-utf8'/0,
'ub-name-universal'/0,
'ub-name-printable'/0,
'ub-name-teletex'/0,
'ub-name'/0,
'teletex-domain-defined-attributes'/0,
'terminal-type'/0,
'extended-network-address'/0,
'local-postal-attributes'/0,
'unique-postal-name'/0,
'poste-restante-address'/0,
'post-office-box-address'/0,
'street-address'/0,
'unformatted-postal-address'/0,
'extension-physical-delivery-address-components'/0,
'physical-delivery-organization-name'/0,
'physical-delivery-personal-name'/0,
'extension-OR-address-components'/0,
'physical-delivery-office-number'/0,
'physical-delivery-office-name'/0,
'postal-code'/0,
'physical-delivery-country-name'/0,
'pds-name'/0,
'teletex-organizational-unit-names'/0,
'teletex-personal-name'/0,
'teletex-organization-name'/0,
'teletex-common-name'/0,
'common-name'/0,
'id-emailAddress'/0,
'id-domainComponent'/0,
'id-at-pseudonym'/0,
'id-at-serialNumber'/0,
'id-at-countryName'/0,
'id-at-dnQualifier'/0,
'id-at-title'/0,
'id-at-organizationalUnitName'/0,
'id-at-organizationName'/0,
'id-at-stateOrProvinceName'/0,
'id-at-localityName'/0,
'id-at-commonName'/0,
'id-at-generationQualifier'/0,
'id-at-initials'/0,
'id-at-givenName'/0,
'id-at-surname'/0,
'id-at-name'/0,
'id-at'/0,
'id-ad-caRepository'/0,
'id-ad-timeStamping'/0,
'id-ad-caIssuers'/0,
'id-ad-ocsp'/0,
'id-qt-unotice'/0,
'id-qt-cps'/0,
'id-ad'/0,
'id-kp'/0,
'id-qt'/0,
'id-pe'/0,
'id-pkix'/0,
'id-dsa-with-sha256'/0,
'id-dsa-with-sha224'/0
]).

-export([info/0]).

-export([
decode_TBSCert_exclusive/1,
decode_TBSCertList_exclusive/1
]).

-export([decode_part/2]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_partial_incomplete(Type, Data0, Pattern) ->
  {Data,_RestBin} =
    decode_primitive_incomplete(Pattern, Data0),
  try {ok,decode_partial_inc_disp(Type, Data)}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_part(Type, Data0) when is_binary(Data0) ->
  try {ok,decode_inc_disp(Type, element(1, ber_decode_nif(Data0)))}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end;
decode_part(Type, Data0) ->
  try {ok,decode_inc_disp(Type, Data0)}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_partial_inc_disp('Certificate',Data) ->
  'dec-inc-Certificate'(Data);
decode_partial_inc_disp('CertificateList',Data) ->
  'dec-inc-CertificateList'(Data).
encode_disp('CurvePublicKey', Data) -> enc_CurvePublicKey(Data);
encode_disp('CurvePrivateKey', Data) -> enc_CurvePrivateKey(Data);
encode_disp('ECPrivateKey', Data) -> enc_ECPrivateKey(Data);
encode_disp('DSAPrivateKey', Data) -> enc_DSAPrivateKey(Data);
encode_disp('DHParameter', Data) -> enc_DHParameter(Data);
encode_disp('DigestAlgorithm', Data) -> enc_DigestAlgorithm(Data);
encode_disp('DigestInfoPKCS-1', Data) -> 'enc_DigestInfoPKCS-1'(Data);
encode_disp('RSASSA-AlgorithmIdentifier', Data) -> 'enc_RSASSA-AlgorithmIdentifier'(Data);
encode_disp('TrailerField', Data) -> enc_TrailerField(Data);
encode_disp('RSASSA-PSS-params', Data) -> 'enc_RSASSA-PSS-params'(Data);
encode_disp('RSAES-AlgorithmIdentifier', Data) -> 'enc_RSAES-AlgorithmIdentifier'(Data);
encode_disp('RSAES-OAEP-params', Data) -> 'enc_RSAES-OAEP-params'(Data);
encode_disp('OtherPrimeInfo', Data) -> enc_OtherPrimeInfo(Data);
encode_disp('OtherPrimeInfos', Data) -> enc_OtherPrimeInfos(Data);
encode_disp('VersionPKCS-1', Data) -> 'enc_VersionPKCS-1'(Data);
encode_disp('RSAPrivateKey', Data) -> enc_RSAPrivateKey(Data);
encode_disp('RSAPublicKey', Data) -> enc_RSAPublicKey(Data);
encode_disp('PSourceAlgorithm', Data) -> enc_PSourceAlgorithm(Data);
encode_disp('EncodingParameters', Data) -> enc_EncodingParameters(Data);
encode_disp('MaskGenAlgorithm', Data) -> enc_MaskGenAlgorithm(Data);
encode_disp('SHA1Parameters', Data) -> enc_SHA1Parameters(Data);
encode_disp('HashAlgorithm', Data) -> enc_HashAlgorithm(Data);
encode_disp('Curve', Data) -> enc_Curve(Data);
encode_disp('ECPVer', Data) -> enc_ECPVer(Data);
encode_disp('ECParameters', Data) -> enc_ECParameters(Data);
encode_disp('EcpkParameters', Data) -> enc_EcpkParameters(Data);
encode_disp('ECPoint', Data) -> enc_ECPoint(Data);
encode_disp('FieldElement', Data) -> enc_FieldElement(Data);
encode_disp('Pentanomial', Data) -> enc_Pentanomial(Data);
encode_disp('Trinomial', Data) -> enc_Trinomial(Data);
encode_disp('Characteristic-two', Data) -> 'enc_Characteristic-two'(Data);
encode_disp('Prime-p', Data) -> 'enc_Prime-p'(Data);
encode_disp('ECDSA-Sig-Value', Data) -> 'enc_ECDSA-Sig-Value'(Data);
encode_disp('FieldID', Data) -> enc_FieldID(Data);
encode_disp('KEA-Parms-Id', Data) -> 'enc_KEA-Parms-Id'(Data);
encode_disp('ValidationParms', Data) -> enc_ValidationParms(Data);
encode_disp('DomainParameters', Data) -> enc_DomainParameters(Data);
encode_disp('DHPublicKey', Data) -> enc_DHPublicKey(Data);
encode_disp('Dss-Sig-Value', Data) -> 'enc_Dss-Sig-Value'(Data);
encode_disp('Dss-Parms', Data) -> 'enc_Dss-Parms'(Data);
encode_disp('DSAPublicKey', Data) -> enc_DSAPublicKey(Data);
encode_disp('ProxyInfo', Data) -> enc_ProxyInfo(Data);
encode_disp('ACClearAttrs', Data) -> enc_ACClearAttrs(Data);
encode_disp('AttrSpec', Data) -> enc_AttrSpec(Data);
encode_disp('AAControls', Data) -> enc_AAControls(Data);
encode_disp('SecurityCategory', Data) -> enc_SecurityCategory(Data);
encode_disp('ClassList', Data) -> enc_ClassList(Data);
encode_disp('Clearance', Data) -> enc_Clearance(Data);
encode_disp('RoleSyntax', Data) -> enc_RoleSyntax(Data);
encode_disp('SvceAuthInfo', Data) -> enc_SvceAuthInfo(Data);
encode_disp('IetfAttrSyntax', Data) -> enc_IetfAttrSyntax(Data);
encode_disp('TargetCert', Data) -> enc_TargetCert(Data);
encode_disp('Target', Data) -> enc_Target(Data);
encode_disp('Targets', Data) -> enc_Targets(Data);
encode_disp('AttCertValidityPeriod', Data) -> enc_AttCertValidityPeriod(Data);
encode_disp('IssuerSerial', Data) -> enc_IssuerSerial(Data);
encode_disp('V2Form', Data) -> enc_V2Form(Data);
encode_disp('AttCertIssuer', Data) -> enc_AttCertIssuer(Data);
encode_disp('ObjectDigestInfo', Data) -> enc_ObjectDigestInfo(Data);
encode_disp('Holder', Data) -> enc_Holder(Data);
encode_disp('AttCertVersion', Data) -> enc_AttCertVersion(Data);
encode_disp('AttributeCertificateInfo', Data) -> enc_AttributeCertificateInfo(Data);
encode_disp('AttributeCertificate', Data) -> enc_AttributeCertificate(Data);
encode_disp('InvalidityDate', Data) -> enc_InvalidityDate(Data);
encode_disp('HoldInstructionCode', Data) -> enc_HoldInstructionCode(Data);
encode_disp('CertificateIssuer', Data) -> enc_CertificateIssuer(Data);
encode_disp('CRLReason', Data) -> enc_CRLReason(Data);
encode_disp('BaseCRLNumber', Data) -> enc_BaseCRLNumber(Data);
encode_disp('IssuingDistributionPoint', Data) -> enc_IssuingDistributionPoint(Data);
encode_disp('CRLNumber', Data) -> enc_CRLNumber(Data);
encode_disp('SubjectInfoAccessSyntax', Data) -> enc_SubjectInfoAccessSyntax(Data);
encode_disp('AccessDescription', Data) -> enc_AccessDescription(Data);
encode_disp('AuthorityInfoAccessSyntax', Data) -> enc_AuthorityInfoAccessSyntax(Data);
encode_disp('FreshestCRL', Data) -> enc_FreshestCRL(Data);
encode_disp('InhibitAnyPolicy', Data) -> enc_InhibitAnyPolicy(Data);
encode_disp('KeyPurposeId', Data) -> enc_KeyPurposeId(Data);
encode_disp('ExtKeyUsageSyntax', Data) -> enc_ExtKeyUsageSyntax(Data);
encode_disp('ReasonFlags', Data) -> enc_ReasonFlags(Data);
encode_disp('DistributionPointName', Data) -> enc_DistributionPointName(Data);
encode_disp('DistributionPoint', Data) -> enc_DistributionPoint(Data);
encode_disp('CRLDistributionPoints', Data) -> enc_CRLDistributionPoints(Data);
encode_disp('SkipCerts', Data) -> enc_SkipCerts(Data);
encode_disp('PolicyConstraints', Data) -> enc_PolicyConstraints(Data);
encode_disp('BaseDistance', Data) -> enc_BaseDistance(Data);
encode_disp('GeneralSubtree', Data) -> enc_GeneralSubtree(Data);
encode_disp('GeneralSubtrees', Data) -> enc_GeneralSubtrees(Data);
encode_disp('NameConstraints', Data) -> enc_NameConstraints(Data);
encode_disp('BasicConstraints', Data) -> enc_BasicConstraints(Data);
encode_disp('SubjectDirectoryAttributes', Data) -> enc_SubjectDirectoryAttributes(Data);
encode_disp('IssuerAltName', Data) -> enc_IssuerAltName(Data);
encode_disp('EDIPartyName', Data) -> enc_EDIPartyName(Data);
encode_disp('AnotherName', Data) -> enc_AnotherName(Data);
encode_disp('GeneralName', Data) -> enc_GeneralName(Data);
encode_disp('GeneralNames', Data) -> enc_GeneralNames(Data);
encode_disp('SubjectAltName', Data) -> enc_SubjectAltName(Data);
encode_disp('PolicyMappings', Data) -> enc_PolicyMappings(Data);
encode_disp('DisplayText', Data) -> enc_DisplayText(Data);
encode_disp('NoticeReference', Data) -> enc_NoticeReference(Data);
encode_disp('UserNotice', Data) -> enc_UserNotice(Data);
encode_disp('CPSuri', Data) -> enc_CPSuri(Data);
encode_disp('PolicyQualifierId', Data) -> enc_PolicyQualifierId(Data);
encode_disp('PolicyQualifierInfo', Data) -> enc_PolicyQualifierInfo(Data);
encode_disp('CertPolicyId', Data) -> enc_CertPolicyId(Data);
encode_disp('PolicyInformation', Data) -> enc_PolicyInformation(Data);
encode_disp('CertificatePolicies', Data) -> enc_CertificatePolicies(Data);
encode_disp('PrivateKeyUsagePeriod', Data) -> enc_PrivateKeyUsagePeriod(Data);
encode_disp('KeyUsage', Data) -> enc_KeyUsage(Data);
encode_disp('SubjectKeyIdentifier', Data) -> enc_SubjectKeyIdentifier(Data);
encode_disp('KeyIdentifier', Data) -> enc_KeyIdentifier(Data);
encode_disp('AuthorityKeyIdentifier', Data) -> enc_AuthorityKeyIdentifier(Data);
encode_disp('EncryptedData', Data) -> enc_EncryptedData(Data);
encode_disp('DigestedData', Data) -> enc_DigestedData(Data);
encode_disp('SignedAndEnvelopedData', Data) -> enc_SignedAndEnvelopedData(Data);
encode_disp('EncryptedKey', Data) -> enc_EncryptedKey(Data);
encode_disp('RecipientInfo', Data) -> enc_RecipientInfo(Data);
encode_disp('EncryptedContent', Data) -> enc_EncryptedContent(Data);
encode_disp('EncryptedContentInfo', Data) -> enc_EncryptedContentInfo(Data);
encode_disp('RecipientInfos', Data) -> enc_RecipientInfos(Data);
encode_disp('EnvelopedData', Data) -> enc_EnvelopedData(Data);
encode_disp('Digest', Data) -> enc_Digest(Data);
encode_disp('DigestInfoPKCS-7', Data) -> 'enc_DigestInfoPKCS-7'(Data);
encode_disp('EncryptedDigest', Data) -> enc_EncryptedDigest(Data);
encode_disp('SignerInfo', Data) -> enc_SignerInfo(Data);
encode_disp('DigestAlgorithmIdentifiers', Data) -> enc_DigestAlgorithmIdentifiers(Data);
encode_disp('SignerInfos', Data) -> enc_SignerInfos(Data);
encode_disp('SignedData', Data) -> enc_SignedData(Data);
encode_disp('Data', Data) -> enc_Data(Data);
encode_disp('ContentType', Data) -> enc_ContentType(Data);
encode_disp('ContentInfo', Data) -> enc_ContentInfo(Data);
encode_disp('KeyEncryptionAlgorithmIdentifier', Data) -> enc_KeyEncryptionAlgorithmIdentifier(Data);
encode_disp('IssuerAndSerialNumber', Data) -> enc_IssuerAndSerialNumber(Data);
encode_disp('ExtendedCertificatesAndCertificates', Data) -> enc_ExtendedCertificatesAndCertificates(Data);
encode_disp('ExtendedCertificate', Data) -> enc_ExtendedCertificate(Data);
encode_disp('ExtendedCertificateOrCertificate', Data) -> enc_ExtendedCertificateOrCertificate(Data);
encode_disp('DigestEncryptionAlgorithmIdentifier', Data) -> enc_DigestEncryptionAlgorithmIdentifier(Data);
encode_disp('DigestAlgorithmIdentifier', Data) -> enc_DigestAlgorithmIdentifier(Data);
encode_disp('ContentEncryptionAlgorithmIdentifier', Data) -> enc_ContentEncryptionAlgorithmIdentifier(Data);
encode_disp('CRLSequence', Data) -> enc_CRLSequence(Data);
encode_disp('Certificates', Data) -> enc_Certificates(Data);
encode_disp('CertificateRevocationLists', Data) -> enc_CertificateRevocationLists(Data);
encode_disp('SignerInfoAuthenticatedAttributes', Data) -> enc_SignerInfoAuthenticatedAttributes(Data);
encode_disp('SigningTime', Data) -> enc_SigningTime(Data);
encode_disp('MessageDigest', Data) -> enc_MessageDigest(Data);
encode_disp('CertificationRequest', Data) -> enc_CertificationRequest(Data);
encode_disp('CertificationRequestInfo', Data) -> enc_CertificationRequestInfo(Data);
encode_disp('ExtensionRequest', Data) -> enc_ExtensionRequest(Data);
encode_disp('AES-IV', Data) -> 'enc_AES-IV'(Data);
encode_disp('Nonce', Data) -> enc_Nonce(Data);
encode_disp('PreferredSignatureAlgorithm', Data) -> enc_PreferredSignatureAlgorithm(Data);
encode_disp('PreferredSignatureAlgorithms', Data) -> enc_PreferredSignatureAlgorithms(Data);
encode_disp('CrlID', Data) -> enc_CrlID(Data);
encode_disp('ServiceLocator', Data) -> enc_ServiceLocator(Data);
encode_disp('AcceptableResponses', Data) -> enc_AcceptableResponses(Data);
encode_disp('ArchiveCutoff', Data) -> enc_ArchiveCutoff(Data);
encode_disp('UnknownInfo', Data) -> enc_UnknownInfo(Data);
encode_disp('RevokedInfo', Data) -> enc_RevokedInfo(Data);
encode_disp('CertStatus', Data) -> enc_CertStatus(Data);
encode_disp('SingleResponse', Data) -> enc_SingleResponse(Data);
encode_disp('KeyHash', Data) -> enc_KeyHash(Data);
encode_disp('ResponderID', Data) -> enc_ResponderID(Data);
encode_disp('ResponseData', Data) -> enc_ResponseData(Data);
encode_disp('BasicOCSPResponse', Data) -> enc_BasicOCSPResponse(Data);
encode_disp('ResponseBytes', Data) -> enc_ResponseBytes(Data);
encode_disp('OCSPResponseStatus', Data) -> enc_OCSPResponseStatus(Data);
encode_disp('OCSPResponse', Data) -> enc_OCSPResponse(Data);
encode_disp('CertID', Data) -> enc_CertID(Data);
encode_disp('Request', Data) -> enc_Request(Data);
encode_disp('VersionOCSP-2013-88', Data) -> 'enc_VersionOCSP-2013-88'(Data);
encode_disp('Signature', Data) -> enc_Signature(Data);
encode_disp('TBSRequest', Data) -> enc_TBSRequest(Data);
encode_disp('OCSPRequest', Data) -> enc_OCSPRequest(Data);
encode_disp('TeletexDomainDefinedAttribute', Data) -> enc_TeletexDomainDefinedAttribute(Data);
encode_disp('TeletexDomainDefinedAttributes', Data) -> enc_TeletexDomainDefinedAttributes(Data);
encode_disp('TerminalType', Data) -> enc_TerminalType(Data);
encode_disp('PresentationAddress', Data) -> enc_PresentationAddress(Data);
encode_disp('ExtendedNetworkAddress', Data) -> enc_ExtendedNetworkAddress(Data);
encode_disp('PDSParameter', Data) -> enc_PDSParameter(Data);
encode_disp('LocalPostalAttributes', Data) -> enc_LocalPostalAttributes(Data);
encode_disp('UniquePostalName', Data) -> enc_UniquePostalName(Data);
encode_disp('PosteRestanteAddress', Data) -> enc_PosteRestanteAddress(Data);
encode_disp('PostOfficeBoxAddress', Data) -> enc_PostOfficeBoxAddress(Data);
encode_disp('StreetAddress', Data) -> enc_StreetAddress(Data);
encode_disp('UnformattedPostalAddress', Data) -> enc_UnformattedPostalAddress(Data);
encode_disp('ExtensionPhysicalDeliveryAddressComponents', Data) -> enc_ExtensionPhysicalDeliveryAddressComponents(Data);
encode_disp('PhysicalDeliveryOrganizationName', Data) -> enc_PhysicalDeliveryOrganizationName(Data);
encode_disp('PhysicalDeliveryPersonalName', Data) -> enc_PhysicalDeliveryPersonalName(Data);
encode_disp('ExtensionORAddressComponents', Data) -> enc_ExtensionORAddressComponents(Data);
encode_disp('PhysicalDeliveryOfficeNumber', Data) -> enc_PhysicalDeliveryOfficeNumber(Data);
encode_disp('PhysicalDeliveryOfficeName', Data) -> enc_PhysicalDeliveryOfficeName(Data);
encode_disp('PostalCode', Data) -> enc_PostalCode(Data);
encode_disp('PhysicalDeliveryCountryName', Data) -> enc_PhysicalDeliveryCountryName(Data);
encode_disp('PDSName', Data) -> enc_PDSName(Data);
encode_disp('TeletexOrganizationalUnitName', Data) -> enc_TeletexOrganizationalUnitName(Data);
encode_disp('TeletexOrganizationalUnitNames', Data) -> enc_TeletexOrganizationalUnitNames(Data);
encode_disp('TeletexPersonalName', Data) -> enc_TeletexPersonalName(Data);
encode_disp('TeletexOrganizationName', Data) -> enc_TeletexOrganizationName(Data);
encode_disp('TeletexCommonName', Data) -> enc_TeletexCommonName(Data);
encode_disp('CommonName', Data) -> enc_CommonName(Data);
encode_disp('ExtensionAttribute', Data) -> enc_ExtensionAttribute(Data);
encode_disp('ExtensionAttributes', Data) -> enc_ExtensionAttributes(Data);
encode_disp('BuiltInDomainDefinedAttribute', Data) -> enc_BuiltInDomainDefinedAttribute(Data);
encode_disp('BuiltInDomainDefinedAttributes', Data) -> enc_BuiltInDomainDefinedAttributes(Data);
encode_disp('OrganizationalUnitName', Data) -> enc_OrganizationalUnitName(Data);
encode_disp('OrganizationalUnitNames', Data) -> enc_OrganizationalUnitNames(Data);
encode_disp('PersonalName', Data) -> enc_PersonalName(Data);
encode_disp('NumericUserIdentifier', Data) -> enc_NumericUserIdentifier(Data);
encode_disp('OrganizationName', Data) -> enc_OrganizationName(Data);
encode_disp('PrivateDomainName', Data) -> enc_PrivateDomainName(Data);
encode_disp('TerminalIdentifier', Data) -> enc_TerminalIdentifier(Data);
encode_disp('X121Address', Data) -> enc_X121Address(Data);
encode_disp('NetworkAddress', Data) -> enc_NetworkAddress(Data);
encode_disp('AdministrationDomainName', Data) -> enc_AdministrationDomainName(Data);
encode_disp('CountryName', Data) -> enc_CountryName(Data);
encode_disp('BuiltInStandardAttributes', Data) -> enc_BuiltInStandardAttributes(Data);
encode_disp('ORAddress', Data) -> enc_ORAddress(Data);
encode_disp('AlgorithmIdentifier', Data) -> enc_AlgorithmIdentifier(Data);
encode_disp('TBSCertList', Data) -> enc_TBSCertList(Data);
encode_disp('CertificateList', Data) -> enc_CertificateList(Data);
encode_disp('Extension', Data) -> enc_Extension(Data);
encode_disp('Extensions', Data) -> enc_Extensions(Data);
encode_disp('SubjectPublicKeyInfo', Data) -> enc_SubjectPublicKeyInfo(Data);
encode_disp('UniqueIdentifier', Data) -> enc_UniqueIdentifier(Data);
encode_disp('Time', Data) -> enc_Time(Data);
encode_disp('Validity', Data) -> enc_Validity(Data);
encode_disp('CertificateSerialNumber', Data) -> enc_CertificateSerialNumber(Data);
encode_disp('VersionPKIX1Explicit88', Data) -> enc_VersionPKIX1Explicit88(Data);
encode_disp('TBSCertificate', Data) -> enc_TBSCertificate(Data);
encode_disp('Certificate', Data) -> enc_Certificate(Data);
encode_disp('DirectoryString', Data) -> enc_DirectoryString(Data);
encode_disp('RelativeDistinguishedName', Data) -> enc_RelativeDistinguishedName(Data);
encode_disp('DistinguishedName', Data) -> enc_DistinguishedName(Data);
encode_disp('RDNSequence', Data) -> enc_RDNSequence(Data);
encode_disp('Name', Data) -> enc_Name(Data);
encode_disp('EmailAddress', Data) -> enc_EmailAddress(Data);
encode_disp('DomainComponent', Data) -> enc_DomainComponent(Data);
encode_disp('X520Pseudonym', Data) -> enc_X520Pseudonym(Data);
encode_disp('X520SerialNumber', Data) -> enc_X520SerialNumber(Data);
encode_disp('X520countryName', Data) -> enc_X520countryName(Data);
encode_disp('X520dnQualifier', Data) -> enc_X520dnQualifier(Data);
encode_disp('X520Title', Data) -> enc_X520Title(Data);
encode_disp('X520OrganizationalUnitName', Data) -> enc_X520OrganizationalUnitName(Data);
encode_disp('X520OrganizationName', Data) -> enc_X520OrganizationName(Data);
encode_disp('X520StateOrProvinceName', Data) -> enc_X520StateOrProvinceName(Data);
encode_disp('X520LocalityName', Data) -> enc_X520LocalityName(Data);
encode_disp('X520CommonName', Data) -> enc_X520CommonName(Data);
encode_disp('X520name', Data) -> enc_X520name(Data);
encode_disp('AttributeTypeAndValue', Data) -> enc_AttributeTypeAndValue(Data);
encode_disp('AttributeValue', Data) -> enc_AttributeValue(Data);
encode_disp('AttributeType', Data) -> enc_AttributeType(Data);
encode_disp('Attribute', Data) -> enc_Attribute(Data);
encode_disp('OTPDisplayText', Data) -> enc_OTPDisplayText(Data);
encode_disp('OTPNoticeReference', Data) -> enc_OTPNoticeReference(Data);
encode_disp('OTPUserNotice', Data) -> enc_OTPUserNotice(Data);
encode_disp('Extension-Any', Data) -> 'enc_Extension-Any'(Data);
encode_disp('Any', Data) -> enc_Any(Data);
encode_disp('Boolean', Data) -> enc_Boolean(Data);
encode_disp('ObjId', Data) -> enc_ObjId(Data);
encode_disp('OTPExtension', Data) -> enc_OTPExtension(Data);
encode_disp('OTPExtensions', Data) -> enc_OTPExtensions(Data);
encode_disp('OTPExtensionAttribute', Data) -> enc_OTPExtensionAttribute(Data);
encode_disp('OTPExtensionAttributes', Data) -> enc_OTPExtensionAttributes(Data);
encode_disp('OTPCharacteristic-two', Data) -> 'enc_OTPCharacteristic-two'(Data);
encode_disp('OTPFieldID', Data) -> enc_OTPFieldID(Data);
encode_disp('KEA-PublicKey', Data) -> 'enc_KEA-PublicKey'(Data);
encode_disp('DSAParams', Data) -> enc_DSAParams(Data);
encode_disp('PublicKeyAlgorithm', Data) -> enc_PublicKeyAlgorithm(Data);
encode_disp('SignatureAlgorithm-Any', Data) -> 'enc_SignatureAlgorithm-Any'(Data);
encode_disp('SignatureAlgorithm', Data) -> enc_SignatureAlgorithm(Data);
encode_disp('OTPSubjectPublicKeyInfo-Any', Data) -> 'enc_OTPSubjectPublicKeyInfo-Any'(Data);
encode_disp('OTPSubjectPublicKeyInfo', Data) -> enc_OTPSubjectPublicKeyInfo(Data);
encode_disp('OTPOLDSubjectPublicKeyInfo', Data) -> enc_OTPOLDSubjectPublicKeyInfo(Data);
encode_disp('OTP-emailAddress', Data) -> 'enc_OTP-emailAddress'(Data);
encode_disp('OTP-X520countryname', Data) -> 'enc_OTP-X520countryname'(Data);
encode_disp('OTPAttributeTypeAndValue', Data) -> enc_OTPAttributeTypeAndValue(Data);
encode_disp('OTPTBSCertificate', Data) -> enc_OTPTBSCertificate(Data);
encode_disp('OTPCertificate', Data) -> enc_OTPCertificate(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('CurvePublicKey', Data) -> dec_CurvePublicKey(Data);
decode_disp('CurvePrivateKey', Data) -> dec_CurvePrivateKey(Data);
decode_disp('ECPrivateKey', Data) -> dec_ECPrivateKey(Data);
decode_disp('DSAPrivateKey', Data) -> dec_DSAPrivateKey(Data);
decode_disp('DHParameter', Data) -> dec_DHParameter(Data);
decode_disp('DigestAlgorithm', Data) -> dec_DigestAlgorithm(Data);
decode_disp('DigestInfoPKCS-1', Data) -> 'dec_DigestInfoPKCS-1'(Data);
decode_disp('RSASSA-AlgorithmIdentifier', Data) -> 'dec_RSASSA-AlgorithmIdentifier'(Data);
decode_disp('TrailerField', Data) -> dec_TrailerField(Data);
decode_disp('RSASSA-PSS-params', Data) -> 'dec_RSASSA-PSS-params'(Data);
decode_disp('RSAES-AlgorithmIdentifier', Data) -> 'dec_RSAES-AlgorithmIdentifier'(Data);
decode_disp('RSAES-OAEP-params', Data) -> 'dec_RSAES-OAEP-params'(Data);
decode_disp('OtherPrimeInfo', Data) -> dec_OtherPrimeInfo(Data);
decode_disp('OtherPrimeInfos', Data) -> dec_OtherPrimeInfos(Data);
decode_disp('VersionPKCS-1', Data) -> 'dec_VersionPKCS-1'(Data);
decode_disp('RSAPrivateKey', Data) -> dec_RSAPrivateKey(Data);
decode_disp('RSAPublicKey', Data) -> dec_RSAPublicKey(Data);
decode_disp('PSourceAlgorithm', Data) -> dec_PSourceAlgorithm(Data);
decode_disp('EncodingParameters', Data) -> dec_EncodingParameters(Data);
decode_disp('MaskGenAlgorithm', Data) -> dec_MaskGenAlgorithm(Data);
decode_disp('SHA1Parameters', Data) -> dec_SHA1Parameters(Data);
decode_disp('HashAlgorithm', Data) -> dec_HashAlgorithm(Data);
decode_disp('Curve', Data) -> dec_Curve(Data);
decode_disp('ECPVer', Data) -> dec_ECPVer(Data);
decode_disp('ECParameters', Data) -> dec_ECParameters(Data);
decode_disp('EcpkParameters', Data) -> dec_EcpkParameters(Data);
decode_disp('ECPoint', Data) -> dec_ECPoint(Data);
decode_disp('FieldElement', Data) -> dec_FieldElement(Data);
decode_disp('Pentanomial', Data) -> dec_Pentanomial(Data);
decode_disp('Trinomial', Data) -> dec_Trinomial(Data);
decode_disp('Characteristic-two', Data) -> 'dec_Characteristic-two'(Data);
decode_disp('Prime-p', Data) -> 'dec_Prime-p'(Data);
decode_disp('ECDSA-Sig-Value', Data) -> 'dec_ECDSA-Sig-Value'(Data);
decode_disp('FieldID', Data) -> dec_FieldID(Data);
decode_disp('KEA-Parms-Id', Data) -> 'dec_KEA-Parms-Id'(Data);
decode_disp('ValidationParms', Data) -> dec_ValidationParms(Data);
decode_disp('DomainParameters', Data) -> dec_DomainParameters(Data);
decode_disp('DHPublicKey', Data) -> dec_DHPublicKey(Data);
decode_disp('Dss-Sig-Value', Data) -> 'dec_Dss-Sig-Value'(Data);
decode_disp('Dss-Parms', Data) -> 'dec_Dss-Parms'(Data);
decode_disp('DSAPublicKey', Data) -> dec_DSAPublicKey(Data);
decode_disp('ProxyInfo', Data) -> dec_ProxyInfo(Data);
decode_disp('ACClearAttrs', Data) -> dec_ACClearAttrs(Data);
decode_disp('AttrSpec', Data) -> dec_AttrSpec(Data);
decode_disp('AAControls', Data) -> dec_AAControls(Data);
decode_disp('SecurityCategory', Data) -> dec_SecurityCategory(Data);
decode_disp('ClassList', Data) -> dec_ClassList(Data);
decode_disp('Clearance', Data) -> dec_Clearance(Data);
decode_disp('RoleSyntax', Data) -> dec_RoleSyntax(Data);
decode_disp('SvceAuthInfo', Data) -> dec_SvceAuthInfo(Data);
decode_disp('IetfAttrSyntax', Data) -> dec_IetfAttrSyntax(Data);
decode_disp('TargetCert', Data) -> dec_TargetCert(Data);
decode_disp('Target', Data) -> dec_Target(Data);
decode_disp('Targets', Data) -> dec_Targets(Data);
decode_disp('AttCertValidityPeriod', Data) -> dec_AttCertValidityPeriod(Data);
decode_disp('IssuerSerial', Data) -> dec_IssuerSerial(Data);
decode_disp('V2Form', Data) -> dec_V2Form(Data);
decode_disp('AttCertIssuer', Data) -> dec_AttCertIssuer(Data);
decode_disp('ObjectDigestInfo', Data) -> dec_ObjectDigestInfo(Data);
decode_disp('Holder', Data) -> dec_Holder(Data);
decode_disp('AttCertVersion', Data) -> dec_AttCertVersion(Data);
decode_disp('AttributeCertificateInfo', Data) -> dec_AttributeCertificateInfo(Data);
decode_disp('AttributeCertificate', Data) -> dec_AttributeCertificate(Data);
decode_disp('InvalidityDate', Data) -> dec_InvalidityDate(Data);
decode_disp('HoldInstructionCode', Data) -> dec_HoldInstructionCode(Data);
decode_disp('CertificateIssuer', Data) -> dec_CertificateIssuer(Data);
decode_disp('CRLReason', Data) -> dec_CRLReason(Data);
decode_disp('BaseCRLNumber', Data) -> dec_BaseCRLNumber(Data);
decode_disp('IssuingDistributionPoint', Data) -> dec_IssuingDistributionPoint(Data);
decode_disp('CRLNumber', Data) -> dec_CRLNumber(Data);
decode_disp('SubjectInfoAccessSyntax', Data) -> dec_SubjectInfoAccessSyntax(Data);
decode_disp('AccessDescription', Data) -> dec_AccessDescription(Data);
decode_disp('AuthorityInfoAccessSyntax', Data) -> dec_AuthorityInfoAccessSyntax(Data);
decode_disp('FreshestCRL', Data) -> dec_FreshestCRL(Data);
decode_disp('InhibitAnyPolicy', Data) -> dec_InhibitAnyPolicy(Data);
decode_disp('KeyPurposeId', Data) -> dec_KeyPurposeId(Data);
decode_disp('ExtKeyUsageSyntax', Data) -> dec_ExtKeyUsageSyntax(Data);
decode_disp('ReasonFlags', Data) -> dec_ReasonFlags(Data);
decode_disp('DistributionPointName', Data) -> dec_DistributionPointName(Data);
decode_disp('DistributionPoint', Data) -> dec_DistributionPoint(Data);
decode_disp('CRLDistributionPoints', Data) -> dec_CRLDistributionPoints(Data);
decode_disp('SkipCerts', Data) -> dec_SkipCerts(Data);
decode_disp('PolicyConstraints', Data) -> dec_PolicyConstraints(Data);
decode_disp('BaseDistance', Data) -> dec_BaseDistance(Data);
decode_disp('GeneralSubtree', Data) -> dec_GeneralSubtree(Data);
decode_disp('GeneralSubtrees', Data) -> dec_GeneralSubtrees(Data);
decode_disp('NameConstraints', Data) -> dec_NameConstraints(Data);
decode_disp('BasicConstraints', Data) -> dec_BasicConstraints(Data);
decode_disp('SubjectDirectoryAttributes', Data) -> dec_SubjectDirectoryAttributes(Data);
decode_disp('IssuerAltName', Data) -> dec_IssuerAltName(Data);
decode_disp('EDIPartyName', Data) -> dec_EDIPartyName(Data);
decode_disp('AnotherName', Data) -> dec_AnotherName(Data);
decode_disp('GeneralName', Data) -> dec_GeneralName(Data);
decode_disp('GeneralNames', Data) -> dec_GeneralNames(Data);
decode_disp('SubjectAltName', Data) -> dec_SubjectAltName(Data);
decode_disp('PolicyMappings', Data) -> dec_PolicyMappings(Data);
decode_disp('DisplayText', Data) -> dec_DisplayText(Data);
decode_disp('NoticeReference', Data) -> dec_NoticeReference(Data);
decode_disp('UserNotice', Data) -> dec_UserNotice(Data);
decode_disp('CPSuri', Data) -> dec_CPSuri(Data);
decode_disp('PolicyQualifierId', Data) -> dec_PolicyQualifierId(Data);
decode_disp('PolicyQualifierInfo', Data) -> dec_PolicyQualifierInfo(Data);
decode_disp('CertPolicyId', Data) -> dec_CertPolicyId(Data);
decode_disp('PolicyInformation', Data) -> dec_PolicyInformation(Data);
decode_disp('CertificatePolicies', Data) -> dec_CertificatePolicies(Data);
decode_disp('PrivateKeyUsagePeriod', Data) -> dec_PrivateKeyUsagePeriod(Data);
decode_disp('KeyUsage', Data) -> dec_KeyUsage(Data);
decode_disp('SubjectKeyIdentifier', Data) -> dec_SubjectKeyIdentifier(Data);
decode_disp('KeyIdentifier', Data) -> dec_KeyIdentifier(Data);
decode_disp('AuthorityKeyIdentifier', Data) -> dec_AuthorityKeyIdentifier(Data);
decode_disp('EncryptedData', Data) -> dec_EncryptedData(Data);
decode_disp('DigestedData', Data) -> dec_DigestedData(Data);
decode_disp('SignedAndEnvelopedData', Data) -> dec_SignedAndEnvelopedData(Data);
decode_disp('EncryptedKey', Data) -> dec_EncryptedKey(Data);
decode_disp('RecipientInfo', Data) -> dec_RecipientInfo(Data);
decode_disp('EncryptedContent', Data) -> dec_EncryptedContent(Data);
decode_disp('EncryptedContentInfo', Data) -> dec_EncryptedContentInfo(Data);
decode_disp('RecipientInfos', Data) -> dec_RecipientInfos(Data);
decode_disp('EnvelopedData', Data) -> dec_EnvelopedData(Data);
decode_disp('Digest', Data) -> dec_Digest(Data);
decode_disp('DigestInfoPKCS-7', Data) -> 'dec_DigestInfoPKCS-7'(Data);
decode_disp('EncryptedDigest', Data) -> dec_EncryptedDigest(Data);
decode_disp('SignerInfo', Data) -> dec_SignerInfo(Data);
decode_disp('DigestAlgorithmIdentifiers', Data) -> dec_DigestAlgorithmIdentifiers(Data);
decode_disp('SignerInfos', Data) -> dec_SignerInfos(Data);
decode_disp('SignedData', Data) -> dec_SignedData(Data);
decode_disp('Data', Data) -> dec_Data(Data);
decode_disp('ContentType', Data) -> dec_ContentType(Data);
decode_disp('ContentInfo', Data) -> dec_ContentInfo(Data);
decode_disp('KeyEncryptionAlgorithmIdentifier', Data) -> dec_KeyEncryptionAlgorithmIdentifier(Data);
decode_disp('IssuerAndSerialNumber', Data) -> dec_IssuerAndSerialNumber(Data);
decode_disp('ExtendedCertificatesAndCertificates', Data) -> dec_ExtendedCertificatesAndCertificates(Data);
decode_disp('ExtendedCertificate', Data) -> dec_ExtendedCertificate(Data);
decode_disp('ExtendedCertificateOrCertificate', Data) -> dec_ExtendedCertificateOrCertificate(Data);
decode_disp('DigestEncryptionAlgorithmIdentifier', Data) -> dec_DigestEncryptionAlgorithmIdentifier(Data);
decode_disp('DigestAlgorithmIdentifier', Data) -> dec_DigestAlgorithmIdentifier(Data);
decode_disp('ContentEncryptionAlgorithmIdentifier', Data) -> dec_ContentEncryptionAlgorithmIdentifier(Data);
decode_disp('CRLSequence', Data) -> dec_CRLSequence(Data);
decode_disp('Certificates', Data) -> dec_Certificates(Data);
decode_disp('CertificateRevocationLists', Data) -> dec_CertificateRevocationLists(Data);
decode_disp('SignerInfoAuthenticatedAttributes', Data) -> dec_SignerInfoAuthenticatedAttributes(Data);
decode_disp('SigningTime', Data) -> dec_SigningTime(Data);
decode_disp('MessageDigest', Data) -> dec_MessageDigest(Data);
decode_disp('CertificationRequest', Data) -> dec_CertificationRequest(Data);
decode_disp('CertificationRequestInfo', Data) -> dec_CertificationRequestInfo(Data);
decode_disp('ExtensionRequest', Data) -> dec_ExtensionRequest(Data);
decode_disp('AES-IV', Data) -> 'dec_AES-IV'(Data);
decode_disp('Nonce', Data) -> dec_Nonce(Data);
decode_disp('PreferredSignatureAlgorithm', Data) -> dec_PreferredSignatureAlgorithm(Data);
decode_disp('PreferredSignatureAlgorithms', Data) -> dec_PreferredSignatureAlgorithms(Data);
decode_disp('CrlID', Data) -> dec_CrlID(Data);
decode_disp('ServiceLocator', Data) -> dec_ServiceLocator(Data);
decode_disp('AcceptableResponses', Data) -> dec_AcceptableResponses(Data);
decode_disp('ArchiveCutoff', Data) -> dec_ArchiveCutoff(Data);
decode_disp('UnknownInfo', Data) -> dec_UnknownInfo(Data);
decode_disp('RevokedInfo', Data) -> dec_RevokedInfo(Data);
decode_disp('CertStatus', Data) -> dec_CertStatus(Data);
decode_disp('SingleResponse', Data) -> dec_SingleResponse(Data);
decode_disp('KeyHash', Data) -> dec_KeyHash(Data);
decode_disp('ResponderID', Data) -> dec_ResponderID(Data);
decode_disp('ResponseData', Data) -> dec_ResponseData(Data);
decode_disp('BasicOCSPResponse', Data) -> dec_BasicOCSPResponse(Data);
decode_disp('ResponseBytes', Data) -> dec_ResponseBytes(Data);
decode_disp('OCSPResponseStatus', Data) -> dec_OCSPResponseStatus(Data);
decode_disp('OCSPResponse', Data) -> dec_OCSPResponse(Data);
decode_disp('CertID', Data) -> dec_CertID(Data);
decode_disp('Request', Data) -> dec_Request(Data);
decode_disp('VersionOCSP-2013-88', Data) -> 'dec_VersionOCSP-2013-88'(Data);
decode_disp('Signature', Data) -> dec_Signature(Data);
decode_disp('TBSRequest', Data) -> dec_TBSRequest(Data);
decode_disp('OCSPRequest', Data) -> dec_OCSPRequest(Data);
decode_disp('TeletexDomainDefinedAttribute', Data) -> dec_TeletexDomainDefinedAttribute(Data);
decode_disp('TeletexDomainDefinedAttributes', Data) -> dec_TeletexDomainDefinedAttributes(Data);
decode_disp('TerminalType', Data) -> dec_TerminalType(Data);
decode_disp('PresentationAddress', Data) -> dec_PresentationAddress(Data);
decode_disp('ExtendedNetworkAddress', Data) -> dec_ExtendedNetworkAddress(Data);
decode_disp('PDSParameter', Data) -> dec_PDSParameter(Data);
decode_disp('LocalPostalAttributes', Data) -> dec_LocalPostalAttributes(Data);
decode_disp('UniquePostalName', Data) -> dec_UniquePostalName(Data);
decode_disp('PosteRestanteAddress', Data) -> dec_PosteRestanteAddress(Data);
decode_disp('PostOfficeBoxAddress', Data) -> dec_PostOfficeBoxAddress(Data);
decode_disp('StreetAddress', Data) -> dec_StreetAddress(Data);
decode_disp('UnformattedPostalAddress', Data) -> dec_UnformattedPostalAddress(Data);
decode_disp('ExtensionPhysicalDeliveryAddressComponents', Data) -> dec_ExtensionPhysicalDeliveryAddressComponents(Data);
decode_disp('PhysicalDeliveryOrganizationName', Data) -> dec_PhysicalDeliveryOrganizationName(Data);
decode_disp('PhysicalDeliveryPersonalName', Data) -> dec_PhysicalDeliveryPersonalName(Data);
decode_disp('ExtensionORAddressComponents', Data) -> dec_ExtensionORAddressComponents(Data);
decode_disp('PhysicalDeliveryOfficeNumber', Data) -> dec_PhysicalDeliveryOfficeNumber(Data);
decode_disp('PhysicalDeliveryOfficeName', Data) -> dec_PhysicalDeliveryOfficeName(Data);
decode_disp('PostalCode', Data) -> dec_PostalCode(Data);
decode_disp('PhysicalDeliveryCountryName', Data) -> dec_PhysicalDeliveryCountryName(Data);
decode_disp('PDSName', Data) -> dec_PDSName(Data);
decode_disp('TeletexOrganizationalUnitName', Data) -> dec_TeletexOrganizationalUnitName(Data);
decode_disp('TeletexOrganizationalUnitNames', Data) -> dec_TeletexOrganizationalUnitNames(Data);
decode_disp('TeletexPersonalName', Data) -> dec_TeletexPersonalName(Data);
decode_disp('TeletexOrganizationName', Data) -> dec_TeletexOrganizationName(Data);
decode_disp('TeletexCommonName', Data) -> dec_TeletexCommonName(Data);
decode_disp('CommonName', Data) -> dec_CommonName(Data);
decode_disp('ExtensionAttribute', Data) -> dec_ExtensionAttribute(Data);
decode_disp('ExtensionAttributes', Data) -> dec_ExtensionAttributes(Data);
decode_disp('BuiltInDomainDefinedAttribute', Data) -> dec_BuiltInDomainDefinedAttribute(Data);
decode_disp('BuiltInDomainDefinedAttributes', Data) -> dec_BuiltInDomainDefinedAttributes(Data);
decode_disp('OrganizationalUnitName', Data) -> dec_OrganizationalUnitName(Data);
decode_disp('OrganizationalUnitNames', Data) -> dec_OrganizationalUnitNames(Data);
decode_disp('PersonalName', Data) -> dec_PersonalName(Data);
decode_disp('NumericUserIdentifier', Data) -> dec_NumericUserIdentifier(Data);
decode_disp('OrganizationName', Data) -> dec_OrganizationName(Data);
decode_disp('PrivateDomainName', Data) -> dec_PrivateDomainName(Data);
decode_disp('TerminalIdentifier', Data) -> dec_TerminalIdentifier(Data);
decode_disp('X121Address', Data) -> dec_X121Address(Data);
decode_disp('NetworkAddress', Data) -> dec_NetworkAddress(Data);
decode_disp('AdministrationDomainName', Data) -> dec_AdministrationDomainName(Data);
decode_disp('CountryName', Data) -> dec_CountryName(Data);
decode_disp('BuiltInStandardAttributes', Data) -> dec_BuiltInStandardAttributes(Data);
decode_disp('ORAddress', Data) -> dec_ORAddress(Data);
decode_disp('AlgorithmIdentifier', Data) -> dec_AlgorithmIdentifier(Data);
decode_disp('TBSCertList', Data) -> dec_TBSCertList(Data);
decode_disp('CertificateList', Data) -> dec_CertificateList(Data);
decode_disp('Extension', Data) -> dec_Extension(Data);
decode_disp('Extensions', Data) -> dec_Extensions(Data);
decode_disp('SubjectPublicKeyInfo', Data) -> dec_SubjectPublicKeyInfo(Data);
decode_disp('UniqueIdentifier', Data) -> dec_UniqueIdentifier(Data);
decode_disp('Time', Data) -> dec_Time(Data);
decode_disp('Validity', Data) -> dec_Validity(Data);
decode_disp('CertificateSerialNumber', Data) -> dec_CertificateSerialNumber(Data);
decode_disp('VersionPKIX1Explicit88', Data) -> dec_VersionPKIX1Explicit88(Data);
decode_disp('TBSCertificate', Data) -> dec_TBSCertificate(Data);
decode_disp('Certificate', Data) -> dec_Certificate(Data);
decode_disp('DirectoryString', Data) -> dec_DirectoryString(Data);
decode_disp('RelativeDistinguishedName', Data) -> dec_RelativeDistinguishedName(Data);
decode_disp('DistinguishedName', Data) -> dec_DistinguishedName(Data);
decode_disp('RDNSequence', Data) -> dec_RDNSequence(Data);
decode_disp('Name', Data) -> dec_Name(Data);
decode_disp('EmailAddress', Data) -> dec_EmailAddress(Data);
decode_disp('DomainComponent', Data) -> dec_DomainComponent(Data);
decode_disp('X520Pseudonym', Data) -> dec_X520Pseudonym(Data);
decode_disp('X520SerialNumber', Data) -> dec_X520SerialNumber(Data);
decode_disp('X520countryName', Data) -> dec_X520countryName(Data);
decode_disp('X520dnQualifier', Data) -> dec_X520dnQualifier(Data);
decode_disp('X520Title', Data) -> dec_X520Title(Data);
decode_disp('X520OrganizationalUnitName', Data) -> dec_X520OrganizationalUnitName(Data);
decode_disp('X520OrganizationName', Data) -> dec_X520OrganizationName(Data);
decode_disp('X520StateOrProvinceName', Data) -> dec_X520StateOrProvinceName(Data);
decode_disp('X520LocalityName', Data) -> dec_X520LocalityName(Data);
decode_disp('X520CommonName', Data) -> dec_X520CommonName(Data);
decode_disp('X520name', Data) -> dec_X520name(Data);
decode_disp('AttributeTypeAndValue', Data) -> dec_AttributeTypeAndValue(Data);
decode_disp('AttributeValue', Data) -> dec_AttributeValue(Data);
decode_disp('AttributeType', Data) -> dec_AttributeType(Data);
decode_disp('Attribute', Data) -> dec_Attribute(Data);
decode_disp('OTPDisplayText', Data) -> dec_OTPDisplayText(Data);
decode_disp('OTPNoticeReference', Data) -> dec_OTPNoticeReference(Data);
decode_disp('OTPUserNotice', Data) -> dec_OTPUserNotice(Data);
decode_disp('Extension-Any', Data) -> 'dec_Extension-Any'(Data);
decode_disp('Any', Data) -> dec_Any(Data);
decode_disp('Boolean', Data) -> dec_Boolean(Data);
decode_disp('ObjId', Data) -> dec_ObjId(Data);
decode_disp('OTPExtension', Data) -> dec_OTPExtension(Data);
decode_disp('OTPExtensions', Data) -> dec_OTPExtensions(Data);
decode_disp('OTPExtensionAttribute', Data) -> dec_OTPExtensionAttribute(Data);
decode_disp('OTPExtensionAttributes', Data) -> dec_OTPExtensionAttributes(Data);
decode_disp('OTPCharacteristic-two', Data) -> 'dec_OTPCharacteristic-two'(Data);
decode_disp('OTPFieldID', Data) -> dec_OTPFieldID(Data);
decode_disp('KEA-PublicKey', Data) -> 'dec_KEA-PublicKey'(Data);
decode_disp('DSAParams', Data) -> dec_DSAParams(Data);
decode_disp('PublicKeyAlgorithm', Data) -> dec_PublicKeyAlgorithm(Data);
decode_disp('SignatureAlgorithm-Any', Data) -> 'dec_SignatureAlgorithm-Any'(Data);
decode_disp('SignatureAlgorithm', Data) -> dec_SignatureAlgorithm(Data);
decode_disp('OTPSubjectPublicKeyInfo-Any', Data) -> 'dec_OTPSubjectPublicKeyInfo-Any'(Data);
decode_disp('OTPSubjectPublicKeyInfo', Data) -> dec_OTPSubjectPublicKeyInfo(Data);
decode_disp('OTPOLDSubjectPublicKeyInfo', Data) -> dec_OTPOLDSubjectPublicKeyInfo(Data);
decode_disp('OTP-emailAddress', Data) -> 'dec_OTP-emailAddress'(Data);
decode_disp('OTP-X520countryname', Data) -> 'dec_OTP-X520countryname'(Data);
decode_disp('OTPAttributeTypeAndValue', Data) -> dec_OTPAttributeTypeAndValue(Data);
decode_disp('OTPTBSCertificate', Data) -> dec_OTPTBSCertificate(Data);
decode_disp('OTPCertificate', Data) -> dec_OTPCertificate(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  CurvePublicKey
%%================================
enc_CurvePublicKey(Val) ->
    enc_CurvePublicKey(Val, [<<3>>]).

enc_CurvePublicKey(Val, TagIn) ->
encode_unnamed_bit_string(Val, TagIn).


dec_CurvePublicKey(Tlv) ->
   dec_CurvePublicKey(Tlv, [3]).

dec_CurvePublicKey(Tlv, TagIn) ->
decode_native_bit_string(Tlv, TagIn).



%%================================
%%  CurvePrivateKey
%%================================
enc_CurvePrivateKey(Val) ->
    enc_CurvePrivateKey(Val, [<<4>>]).

enc_CurvePrivateKey(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CurvePrivateKey(Tlv) ->
   dec_CurvePrivateKey(Tlv, [4]).

dec_CurvePrivateKey(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  ECPrivateKey
%%================================
enc_ECPrivateKey(Val) ->
    enc_ECPrivateKey(Val, [<<48>>]).

enc_ECPrivateKey(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute privateKey(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute parameters(3)   External OTP-PUB-KEY:EcpkParameters OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EcpkParameters'(Cindex3, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute publicKey(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex4, [<<3>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute attributes(5) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_open_type(Cindex5, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ECPrivateKey(Tlv) ->
   dec_ECPrivateKey(Tlv, [16]).

dec_ECPrivateKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute privateKey(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

%%-------------------------------------------------
%% attribute parameters(3)   External OTP-PUB-KEY:EcpkParameters OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {'dec_EcpkParameters'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute publicKey(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131073,V4}|TempTlv5] ->
    {decode_native_bit_string(V4, [3]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute attributes(5) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[V5|TempTlv6] ->
    {decode_open_type_as_binary(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'ECPrivateKey',Term1,Term2,Term3,Term4,Term5},
Res1.


%%================================
%%  DSAPrivateKey
%%================================
enc_DSAPrivateKey(Val) ->
    enc_DSAPrivateKey(Val, [<<48>>]).

enc_DSAPrivateKey(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute p(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute g(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<2>>]),

%%-------------------------------------------------
%% attribute y(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute x(6) with type INTEGER
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_integer(Cindex6, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DSAPrivateKey(Tlv) ->
   dec_DSAPrivateKey(Tlv, [16]).

dec_DSAPrivateKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute p(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute g(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_integer(V4, [2]),

%%-------------------------------------------------
%% attribute y(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute x(6) with type INTEGER
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_integer(V6, [2]),

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'DSAPrivateKey',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.


%%================================
%%  DHParameter
%%================================
enc_DHParameter(Val) ->
    enc_DHParameter(Val, [<<48>>]).

enc_DHParameter(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute prime(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute base(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute privateValueLength(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<2>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DHParameter(Tlv) ->
   dec_DHParameter(Tlv, [16]).

dec_DHParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute prime(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute base(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute privateValueLength(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{2,V3}|TempTlv4] ->
    {decode_integer(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'DHParameter',Term1,Term2,Term3},
Res1.


%%================================
%%  DigestAlgorithm
%%================================
enc_DigestAlgorithm(Val) ->
    enc_DigestAlgorithm(Val, [<<48>>]).

enc_DigestAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_1'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestAlgorithm(Tlv) ->
   dec_DigestAlgorithm(Tlv, [16]).

dec_DigestAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_1'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestAlgorithm',Term1,Term2},
Res1.


%%================================
%%  DigestInfoPKCS-1
%%================================
'enc_DigestInfoPKCS-1'(Val) ->
    'enc_DigestInfoPKCS-1'(Val, [<<48>>]).

'enc_DigestInfoPKCS-1'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute digestAlgorithm(1)   External OTP-PUB-KEY:DigestAlgorithm
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DigestAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute digest(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DigestInfoPKCS-1'(Tlv) ->
   'dec_DigestInfoPKCS-1'(Tlv, [16]).

'dec_DigestInfoPKCS-1'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digestAlgorithm(1)   External OTP-PUB-KEY:DigestAlgorithm
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DigestAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute digest(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestInfoPKCS-1',Term1,Term2},
Res1.


%%================================
%%  RSASSA-AlgorithmIdentifier
%%================================
'enc_RSASSA-AlgorithmIdentifier'(Val) ->
    'enc_RSASSA-AlgorithmIdentifier'(Val, [<<48>>]).

'enc_RSASSA-AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSASSA-AlgorithmIdentifier'(Tlv) ->
   'dec_RSASSA-AlgorithmIdentifier'(Tlv, [16]).

'dec_RSASSA-AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RSASSA-AlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  TrailerField
%%================================
enc_TrailerField(Val) ->
    enc_TrailerField(Val, [<<2>>]).

enc_TrailerField(Val, TagIn) ->
encode_integer(Val, [{trailerFieldBC,1}], TagIn).


dec_TrailerField(Tlv) ->
   dec_TrailerField(Tlv, [2]).

dec_TrailerField(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{trailerFieldBC,1}])
end
.



%%================================
%%  RSASSA-PSS-params
%%================================
'enc_RSASSA-PSS-params'(Val) ->
    'enc_RSASSA-PSS-params'(Val, [<<48>>]).

'enc_RSASSA-PSS-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External OTP-PUB-KEY:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
'enc_HashAlgorithm'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External OTP-PUB-KEY:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
'enc_MaskGenAlgorithm'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute saltLength(3) with type INTEGER DEFAULT = 20
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_3(Cindex3) of
true -> {[],0};
false ->
encode_integer(Cindex3, [<<2>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute trailerField(4) with type INTEGER DEFAULT = 1
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_4(Cindex4) of
true -> {[],0};
false ->
encode_integer(Cindex4, [{trailerFieldBC,1}], [<<2>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSASSA-PSS-params'(Tlv) ->
   'dec_RSASSA-PSS-params'(Tlv, [16]).

'dec_RSASSA-PSS-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External OTP-PUB-KEY:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_HashAlgorithm'(V1, [16]), TempTlv2};
    _ ->
        {{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},Tlv1}
end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External OTP-PUB-KEY:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MaskGenAlgorithm'(V2, [16]), TempTlv3};
    _ ->
        {{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},Tlv2}
end,

%%-------------------------------------------------
%% attribute saltLength(3) with type INTEGER DEFAULT = 20
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_integer(V3, [2]), TempTlv4};
    _ ->
        {20,Tlv3}
end,

%%-------------------------------------------------
%% attribute trailerField(4) with type INTEGER DEFAULT = 1
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {begin
Val1 = decode_integer(V4, [2]),
number2name(Val1, [{trailerFieldBC,1}])
end
, TempTlv5};
    _ ->
        {1,Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'RSASSA-PSS-params',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  RSAES-AlgorithmIdentifier
%%================================
'enc_RSAES-AlgorithmIdentifier'(Val) ->
    'enc_RSAES-AlgorithmIdentifier'(Val, [<<48>>]).

'enc_RSAES-AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_5'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSAES-AlgorithmIdentifier'(Tlv) ->
   'dec_RSAES-AlgorithmIdentifier'(Tlv, [16]).

'dec_RSAES-AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_5'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RSAES-AlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  RSAES-OAEP-params
%%================================
'enc_RSAES-OAEP-params'(Val) ->
    'enc_RSAES-OAEP-params'(Val, [<<48>>]).

'enc_RSAES-OAEP-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External OTP-PUB-KEY:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_5(Cindex1) of
true -> {[],0};
false ->
'enc_HashAlgorithm'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External OTP-PUB-KEY:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_6(Cindex2) of
true -> {[],0};
false ->
'enc_MaskGenAlgorithm'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute pSourceAlgorithm(3)   External OTP-PUB-KEY:PSourceAlgorithm DEFAULT = {'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_7(Cindex3) of
true -> {[],0};
false ->
'enc_PSourceAlgorithm'(Cindex3, [<<48>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSAES-OAEP-params'(Tlv) ->
   'dec_RSAES-OAEP-params'(Tlv, [16]).

'dec_RSAES-OAEP-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External OTP-PUB-KEY:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_HashAlgorithm'(V1, [16]), TempTlv2};
    _ ->
        {{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},Tlv1}
end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External OTP-PUB-KEY:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MaskGenAlgorithm'(V2, [16]), TempTlv3};
    _ ->
        {{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},Tlv2}
end,

%%-------------------------------------------------
%% attribute pSourceAlgorithm(3)   External OTP-PUB-KEY:PSourceAlgorithm DEFAULT = {'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_PSourceAlgorithm'(V3, [16]), TempTlv4};
    _ ->
        {{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>},Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'RSAES-OAEP-params',Term1,Term2,Term3},
Res1.


%%================================
%%  OtherPrimeInfo
%%================================
enc_OtherPrimeInfo(Val) ->
    enc_OtherPrimeInfo(Val, [<<48>>]).

enc_OtherPrimeInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute prime(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute exponent(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute coefficient(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherPrimeInfo(Tlv) ->
   dec_OtherPrimeInfo(Tlv, [16]).

dec_OtherPrimeInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute prime(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute exponent(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute coefficient(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OtherPrimeInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  OtherPrimeInfos
%%================================
enc_OtherPrimeInfos(Val) ->
    enc_OtherPrimeInfos(Val, [<<48>>]).

enc_OtherPrimeInfos(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OtherPrimeInfos_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OtherPrimeInfos_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OtherPrimeInfos_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OtherPrimeInfo'(H, [<<48>>]),
   'enc_OtherPrimeInfos_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OtherPrimeInfos(Tlv) ->
   dec_OtherPrimeInfos(Tlv, [16]).

dec_OtherPrimeInfos(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OtherPrimeInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  VersionPKCS-1
%%================================
'enc_VersionPKCS-1'(Val) ->
    'enc_VersionPKCS-1'(Val, [<<2>>]).

'enc_VersionPKCS-1'(Val, TagIn) ->
encode_integer(Val, [{'two-prime',0},{multi,1}], TagIn).


'dec_VersionPKCS-1'(Tlv) ->
   'dec_VersionPKCS-1'(Tlv, [2]).

'dec_VersionPKCS-1'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{'two-prime',0},{multi,1}])
end
.



%%================================
%%  RSAPrivateKey
%%================================
enc_RSAPrivateKey(Val) ->
    enc_RSAPrivateKey(Val, [<<48>>]).

enc_RSAPrivateKey(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{'two-prime',0},{multi,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute modulus(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute publicExponent(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute privateExponent(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<2>>]),

%%-------------------------------------------------
%% attribute prime1(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute prime2(6) with type INTEGER
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_integer(Cindex6, [<<2>>]),

%%-------------------------------------------------
%% attribute exponent1(7) with type INTEGER
%%-------------------------------------------------
   {EncBytes7,EncLen7} = encode_integer(Cindex7, [<<2>>]),

%%-------------------------------------------------
%% attribute exponent2(8) with type INTEGER
%%-------------------------------------------------
   {EncBytes8,EncLen8} = encode_integer(Cindex8, [<<2>>]),

%%-------------------------------------------------
%% attribute coefficient(9) with type INTEGER
%%-------------------------------------------------
   {EncBytes9,EncLen9} = encode_integer(Cindex9, [<<2>>]),

%%-------------------------------------------------
%% attribute otherPrimeInfos(10)   External OTP-PUB-KEY:OtherPrimeInfos OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OtherPrimeInfos'(Cindex10, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RSAPrivateKey(Tlv) ->
   dec_RSAPrivateKey(Tlv, [16]).

dec_RSAPrivateKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{'two-prime',0},{multi,1}])
end
,

%%-------------------------------------------------
%% attribute modulus(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute publicExponent(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute privateExponent(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_integer(V4, [2]),

%%-------------------------------------------------
%% attribute prime1(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute prime2(6) with type INTEGER
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_integer(V6, [2]),

%%-------------------------------------------------
%% attribute exponent1(7) with type INTEGER
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = decode_integer(V7, [2]),

%%-------------------------------------------------
%% attribute exponent2(8) with type INTEGER
%%-------------------------------------------------
[V8|Tlv9] = Tlv8, 
Term8 = decode_integer(V8, [2]),

%%-------------------------------------------------
%% attribute coefficient(9) with type INTEGER
%%-------------------------------------------------
[V9|Tlv10] = Tlv9, 
Term9 = decode_integer(V9, [2]),

%%-------------------------------------------------
%% attribute otherPrimeInfos(10)   External OTP-PUB-KEY:OtherPrimeInfos OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{16,V10}|TempTlv11] ->
    {'dec_OtherPrimeInfos'(V10, []), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
Res1 = {'RSAPrivateKey',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.


%%================================
%%  RSAPublicKey
%%================================
enc_RSAPublicKey(Val) ->
    enc_RSAPublicKey(Val, [<<48>>]).

enc_RSAPublicKey(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute modulus(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute publicExponent(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RSAPublicKey(Tlv) ->
   dec_RSAPublicKey(Tlv, [16]).

dec_RSAPublicKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute modulus(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute publicExponent(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RSAPublicKey',Term1,Term2},
Res1.


%%================================
%%  PSourceAlgorithm
%%================================
enc_PSourceAlgorithm(Val) ->
    enc_PSourceAlgorithm(Val, [<<48>>]).

enc_PSourceAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PSourceAlgorithm(Tlv) ->
   dec_PSourceAlgorithm(Tlv, [16]).

dec_PSourceAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_6'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PSourceAlgorithm',Term1,Term2},
Res1.


%%================================
%%  EncodingParameters
%%================================
enc_EncodingParameters(Val) ->
    enc_EncodingParameters(Val, [<<4>>]).

enc_EncodingParameters(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncodingParameters(Tlv) ->
   dec_EncodingParameters(Tlv, [4]).

dec_EncodingParameters(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  MaskGenAlgorithm
%%================================
enc_MaskGenAlgorithm(Val) ->
    enc_MaskGenAlgorithm(Val, [<<48>>]).

enc_MaskGenAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_MaskGenAlgorithm(Tlv) ->
   dec_MaskGenAlgorithm(Tlv, [16]).

dec_MaskGenAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'MaskGenAlgorithm',Term1,Term2},
Res1.


%%================================
%%  SHA1Parameters
%%================================
enc_SHA1Parameters(Val) ->
    enc_SHA1Parameters(Val, [<<5>>]).

enc_SHA1Parameters(Val, TagIn) ->
encode_null(Val, TagIn).


dec_SHA1Parameters(Tlv) ->
   dec_SHA1Parameters(Tlv, [5]).

dec_SHA1Parameters(Tlv, TagIn) ->
decode_null(Tlv, TagIn).



%%================================
%%  HashAlgorithm
%%================================
enc_HashAlgorithm(Val) ->
    enc_HashAlgorithm(Val, [<<48>>]).

enc_HashAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_HashAlgorithm(Tlv) ->
   dec_HashAlgorithm(Tlv, [16]).

dec_HashAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_3'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'HashAlgorithm',Term1,Term2},
Res1.


%%================================
%%  Curve
%%================================
enc_Curve(Val) ->
    enc_Curve(Val, [<<48>>]).

enc_Curve(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute a(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute b(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute seed(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex3, [<<3>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Curve(Tlv) ->
   dec_Curve(Tlv, [16]).

dec_Curve(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute a(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute b(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

%%-------------------------------------------------
%% attribute seed(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{3,V3}|TempTlv4] ->
    {decode_native_bit_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Curve',Term1,Term2,Term3},
Res1.


%%================================
%%  ECPVer
%%================================
enc_ECPVer(Val) ->
    enc_ECPVer(Val, [<<2>>]).

enc_ECPVer(Val, TagIn) ->
encode_integer(Val, [{ecpVer1,1}], TagIn).


dec_ECPVer(Tlv) ->
   dec_ECPVer(Tlv, [2]).

dec_ECPVer(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{ecpVer1,1}])
end
.



%%================================
%%  ECParameters
%%================================
enc_ECParameters(Val) ->
    enc_ECParameters(Val, [<<48>>]).

enc_ECParameters(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{ecpVer1,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute fieldID(2)   External OTP-PUB-KEY:FieldID
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_FieldID'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute curve(3)   External OTP-PUB-KEY:Curve
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_Curve'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute base(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

%%-------------------------------------------------
%% attribute order(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute cofactor(6) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex6, [<<2>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ECParameters(Tlv) ->
   dec_ECParameters(Tlv, [16]).

dec_ECParameters(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{ecpVer1,1}])
end
,

%%-------------------------------------------------
%% attribute fieldID(2)   External OTP-PUB-KEY:FieldID
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_FieldID'(V2, [16]),

%%-------------------------------------------------
%% attribute curve(3)   External OTP-PUB-KEY:Curve
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_Curve'(V3, [16]),

%%-------------------------------------------------
%% attribute base(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

%%-------------------------------------------------
%% attribute order(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute cofactor(6) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{2,V6}|TempTlv7] ->
    {decode_integer(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'ECParameters',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.


%%================================
%%  EcpkParameters
%%================================
enc_EcpkParameters(Val) ->
    enc_EcpkParameters(Val, []).

enc_EcpkParameters(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ecParameters ->
         'enc_ECParameters'(element(2,Val), [<<48>>]);
      namedCurve ->
         encode_object_identifier(element(2,Val), [<<6>>]);
      implicitlyCA ->
         encode_null(element(2,Val), [<<5>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_EcpkParameters(Tlv) ->
   dec_EcpkParameters(Tlv, []).

dec_EcpkParameters(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ecParameters'
    {16, V1} -> 
        {ecParameters, 'dec_ECParameters'(V1, [])};


%% 'namedCurve'
    {6, V1} -> 
        {namedCurve, decode_object_identifier(V1, [])};


%% 'implicitlyCA'
    {5, V1} -> 
        {implicitlyCA, decode_null(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ECPoint
%%================================
enc_ECPoint(Val) ->
    enc_ECPoint(Val, [<<4>>]).

enc_ECPoint(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_ECPoint(Tlv) ->
   dec_ECPoint(Tlv, [4]).

dec_ECPoint(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  FieldElement
%%================================
enc_FieldElement(Val) ->
    enc_FieldElement(Val, [<<4>>]).

enc_FieldElement(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_FieldElement(Tlv) ->
   dec_FieldElement(Tlv, [4]).

dec_FieldElement(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  Pentanomial
%%================================
enc_Pentanomial(Val) ->
    enc_Pentanomial(Val, [<<48>>]).

enc_Pentanomial(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute k1(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute k2(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute k3(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Pentanomial(Tlv) ->
   dec_Pentanomial(Tlv, [16]).

dec_Pentanomial(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute k1(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute k2(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute k3(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Pentanomial',Term1,Term2,Term3},
Res1.


%%================================
%%  Trinomial
%%================================
enc_Trinomial(Val) ->
    enc_Trinomial(Val, [<<2>>]).

enc_Trinomial(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_Trinomial(Tlv) ->
   dec_Trinomial(Tlv, [2]).

dec_Trinomial(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  Characteristic-two
%%================================
'enc_Characteristic-two'(Val) ->
    'enc_Characteristic-two'(Val, [<<48>>]).

'enc_Characteristic-two'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute m(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute basis(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_open_type(Cindex3, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Characteristic-two'(Tlv) ->
   'dec_Characteristic-two'(Tlv, [16]).

'dec_Characteristic-two'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute m(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute basis(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

%%-------------------------------------------------
%% attribute parameters(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_open_type_as_binary(V3, []),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Characteristic-two',Term1,Term2,Term3},
Res1.


%%================================
%%  Prime-p
%%================================
'enc_Prime-p'(Val) ->
    'enc_Prime-p'(Val, [<<2>>]).

'enc_Prime-p'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_Prime-p'(Tlv) ->
   'dec_Prime-p'(Tlv, [2]).

'dec_Prime-p'(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  ECDSA-Sig-Value
%%================================
'enc_ECDSA-Sig-Value'(Val) ->
    'enc_ECDSA-Sig-Value'(Val, [<<48>>]).

'enc_ECDSA-Sig-Value'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ECDSA-Sig-Value'(Tlv) ->
   'dec_ECDSA-Sig-Value'(Tlv, [16]).

'dec_ECDSA-Sig-Value'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ECDSA-Sig-Value',Term1,Term2},
Res1.


%%================================
%%  FieldID
%%================================
enc_FieldID(Val) ->
    enc_FieldID(Val, [<<48>>]).

enc_FieldID(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute fieldType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_FieldID(Tlv) ->
   dec_FieldID(Tlv, [16]).

dec_FieldID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute fieldType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'FieldID',Term1,Term2},
Res1.


%%================================
%%  KEA-Parms-Id
%%================================
'enc_KEA-Parms-Id'(Val) ->
    'enc_KEA-Parms-Id'(Val, [<<4>>]).

'enc_KEA-Parms-Id'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_KEA-Parms-Id'(Tlv) ->
   'dec_KEA-Parms-Id'(Tlv, [4]).

'dec_KEA-Parms-Id'(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  ValidationParms
%%================================
enc_ValidationParms(Val) ->
    enc_ValidationParms(Val, [<<48>>]).

enc_ValidationParms(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute seed(1) with type BIT STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_unnamed_bit_string(Cindex1, [<<3>>]),

%%-------------------------------------------------
%% attribute pgenCounter(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ValidationParms(Tlv) ->
   dec_ValidationParms(Tlv, [16]).

dec_ValidationParms(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute seed(1) with type BIT STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_native_bit_string(V1, [3]),

%%-------------------------------------------------
%% attribute pgenCounter(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ValidationParms',Term1,Term2},
Res1.


%%================================
%%  DomainParameters
%%================================
enc_DomainParameters(Val) ->
    enc_DomainParameters(Val, [<<48>>]).

enc_DomainParameters(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute g(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute j(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex4, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute validationParms(5)   External OTP-PUB-KEY:ValidationParms OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ValidationParms'(Cindex5, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DomainParameters(Tlv) ->
   dec_DomainParameters(Tlv, [16]).

dec_DomainParameters(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute g(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute j(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{2,V4}|TempTlv5] ->
    {decode_integer(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute validationParms(5)   External OTP-PUB-KEY:ValidationParms OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{16,V5}|TempTlv6] ->
    {'dec_ValidationParms'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'DomainParameters',Term1,Term2,Term3,Term4,Term5},
Res1.


%%================================
%%  DHPublicKey
%%================================
enc_DHPublicKey(Val) ->
    enc_DHPublicKey(Val, [<<2>>]).

enc_DHPublicKey(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_DHPublicKey(Tlv) ->
   dec_DHPublicKey(Tlv, [2]).

dec_DHPublicKey(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  Dss-Sig-Value
%%================================
'enc_Dss-Sig-Value'(Val) ->
    'enc_Dss-Sig-Value'(Val, [<<48>>]).

'enc_Dss-Sig-Value'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Dss-Sig-Value'(Tlv) ->
   'dec_Dss-Sig-Value'(Tlv, [16]).

'dec_Dss-Sig-Value'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Dss-Sig-Value',Term1,Term2},
Res1.


%%================================
%%  Dss-Parms
%%================================
'enc_Dss-Parms'(Val) ->
    'enc_Dss-Parms'(Val, [<<48>>]).

'enc_Dss-Parms'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute q(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute g(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Dss-Parms'(Tlv) ->
   'dec_Dss-Parms'(Tlv, [16]).

'dec_Dss-Parms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute q(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute g(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Dss-Parms',Term1,Term2,Term3},
Res1.


%%================================
%%  DSAPublicKey
%%================================
enc_DSAPublicKey(Val) ->
    enc_DSAPublicKey(Val, [<<2>>]).

enc_DSAPublicKey(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_DSAPublicKey(Tlv) ->
   dec_DSAPublicKey(Tlv, [2]).

dec_DSAPublicKey(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  ProxyInfo
%%================================
enc_ProxyInfo(Val) ->
    enc_ProxyInfo(Val, [<<48>>]).

enc_ProxyInfo(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ProxyInfo_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ProxyInfo_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ProxyInfo_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Targets'(H, [<<48>>]),
   'enc_ProxyInfo_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ProxyInfo(Tlv) ->
   dec_ProxyInfo(Tlv, [16]).

dec_ProxyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Targets'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ACClearAttrs
%%================================
enc_ACClearAttrs(Val) ->
    enc_ACClearAttrs(Val, [<<48>>]).

enc_ACClearAttrs(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute acIssuer(1)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute acSerial(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute attrs(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ACClearAttrs_attrs'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ACClearAttrs_attrs
%%================================
enc_ACClearAttrs_attrs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ACClearAttrs_attrs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ACClearAttrs_attrs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ACClearAttrs_attrs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attribute'(H, [<<48>>]),
   'enc_ACClearAttrs_attrs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ACClearAttrs(Tlv) ->
   dec_ACClearAttrs(Tlv, [16]).

dec_ACClearAttrs(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute acIssuer(1)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute acSerial(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute attrs(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ACClearAttrs_attrs'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ACClearAttrs',Term1,Term2,Term3},
Res1.
'dec_ACClearAttrs_attrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AttrSpec
%%================================
enc_AttrSpec(Val) ->
    enc_AttrSpec(Val, [<<48>>]).

enc_AttrSpec(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttrSpec_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttrSpec_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttrSpec_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_object_identifier(H, [<<6>>]),
   'enc_AttrSpec_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AttrSpec(Tlv) ->
   dec_AttrSpec(Tlv, [16]).

dec_AttrSpec(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_object_identifier(V1, [6]) || V1 <- Tlv1].




%%================================
%%  AAControls
%%================================
enc_AAControls(Val) ->
    enc_AAControls(Val, [<<48>>]).

enc_AAControls(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute pathLenConstraint(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute permittedAttrs(2)   External OTP-PUB-KEY:AttrSpec OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttrSpec'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute excludedAttrs(3)   External OTP-PUB-KEY:AttrSpec OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttrSpec'(Cindex3, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute permitUnSpecified(4) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_8(Cindex4) of
true -> {[],0};
false ->
encode_boolean(Cindex4, [<<1>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AAControls(Tlv) ->
   dec_AAControls(Tlv, [16]).

dec_AAControls(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pathLenConstraint(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute permittedAttrs(2)   External OTP-PUB-KEY:AttrSpec OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_AttrSpec'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute excludedAttrs(3)   External OTP-PUB-KEY:AttrSpec OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_AttrSpec'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute permitUnSpecified(4) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{1,V4}|TempTlv5] ->
    {decode_boolean(V4, []), TempTlv5};
    _ ->
        {true,Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'AAControls',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  SecurityCategory
%%================================
enc_SecurityCategory(Val) ->
    enc_SecurityCategory(Val, [<<48>>]).

enc_SecurityCategory(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SecurityCategory(Tlv) ->
   dec_SecurityCategory(Tlv, [16]).

dec_SecurityCategory(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [131072]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SecurityCategory',Term1,Term2},
Res1.


%%================================
%%  ClassList
%%================================
enc_ClassList(Val) ->
    enc_ClassList(Val, [<<3>>]).

enc_ClassList(Val, TagIn) ->
encode_named_bit_string(Val, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], TagIn).


dec_ClassList(Tlv) ->
   dec_ClassList(Tlv, [3]).

dec_ClassList(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], TagIn).



%%================================
%%  Clearance
%%================================
enc_Clearance(Val) ->
    enc_Clearance(Val, [<<48>>]).

enc_Clearance(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_9(Cindex2) of
true -> {[],0};
false ->
encode_named_bit_string(Cindex2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Clearance_securityCategories'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Clearance_securityCategories
%%================================
enc_Clearance_securityCategories(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Clearance_securityCategories_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Clearance_securityCategories_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Clearance_securityCategories_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SecurityCategory'(H, [<<48>>]),
   'enc_Clearance_securityCategories_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Clearance(Tlv) ->
   dec_Clearance(Tlv, [16]).

dec_Clearance(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [131072]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_named_bit_string(V2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], []), TempTlv3};
    _ ->
        {[unclassified],Tlv2}
end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_Clearance_securityCategories'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Clearance',Term1,Term2,Term3},
Res1.
'dec_Clearance_securityCategories'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SecurityCategory'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  RoleSyntax
%%================================
enc_RoleSyntax(Val) ->
    enc_RoleSyntax(Val, [<<48>>]).

enc_RoleSyntax(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute roleAuthority(1)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute roleName(2)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_GeneralName'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RoleSyntax(Tlv) ->
   dec_RoleSyntax(Tlv, [16]).

dec_RoleSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute roleAuthority(1)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute roleName(2)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_GeneralName'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RoleSyntax',Term1,Term2},
Res1.


%%================================
%%  SvceAuthInfo
%%================================
enc_SvceAuthInfo(Val) ->
    enc_SvceAuthInfo(Val, [<<48>>]).

enc_SvceAuthInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute service(1)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute ident(2)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_GeneralName'(Cindex2, []),

%%-------------------------------------------------
%% attribute authInfo(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SvceAuthInfo(Tlv) ->
   dec_SvceAuthInfo(Tlv, [16]).

dec_SvceAuthInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute service(1)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute ident(2)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_GeneralName'(V2, []),

%%-------------------------------------------------
%% attribute authInfo(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{4,V3}|TempTlv4] ->
    {decode_octet_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'SvceAuthInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  IetfAttrSyntax
%%================================
enc_IetfAttrSyntax(Val) ->
    enc_IetfAttrSyntax(Val, [<<48>>]).

enc_IetfAttrSyntax(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyAuthority(1)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute values(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IetfAttrSyntax_values'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IetfAttrSyntax_values
%%================================
enc_IetfAttrSyntax_values(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_IetfAttrSyntax_values_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_IetfAttrSyntax_values_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IetfAttrSyntax_values_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IetfAttrSyntax_values_SEQOF'(H, []),
   'enc_IetfAttrSyntax_values_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  IetfAttrSyntax_values_SEQOF
%%================================
enc_IetfAttrSyntax_values_SEQOF(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      octets ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      oid ->
         encode_object_identifier(element(2,Val), [<<6>>]);
      string ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_IetfAttrSyntax(Tlv) ->
   dec_IetfAttrSyntax(Tlv, [16]).

dec_IetfAttrSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyAuthority(1)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute values(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IetfAttrSyntax_values'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'IetfAttrSyntax',Term1,Term2},
Res1.
'dec_IetfAttrSyntax_values'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IetfAttrSyntax_values_SEQOF'(V1, []) || V1 <- Tlv1].


'dec_IetfAttrSyntax_values_SEQOF'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'octets'
    {4, V1} -> 
        {octets, decode_octet_string(V1, [])};


%% 'oid'
    {6, V1} -> 
        {oid, decode_object_identifier(V1, [])};


%% 'string'
    {12, V1} -> 
        {string, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  TargetCert
%%================================
enc_TargetCert(Val) ->
    enc_TargetCert(Val, [<<48>>]).

enc_TargetCert(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute targetCertificate(1)   External OTP-PUB-KEY:IssuerSerial
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_IssuerSerial'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute targetName(2)   External OTP-PUB-KEY:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralName'(Cindex2, [])
       end,

%%-------------------------------------------------
%% attribute certDigestInfo(3)   External OTP-PUB-KEY:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TargetCert(Tlv) ->
   dec_TargetCert(Tlv, [16]).

dec_TargetCert(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute targetCertificate(1)   External OTP-PUB-KEY:IssuerSerial
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_IssuerSerial'(V1, [16]),

%%-------------------------------------------------
%% attribute targetName(2)   External OTP-PUB-KEY:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {131072,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131076,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131077,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131078,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131079,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131080,_}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute certDigestInfo(3)   External OTP-PUB-KEY:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'TargetCert',Term1,Term2,Term3},
Res1.


%%================================
%%  Target
%%================================
enc_Target(Val) ->
    enc_Target(Val, []).

enc_Target(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      targetName ->
         'enc_GeneralName'(element(2,Val), [<<160>>]);
      targetGroup ->
         'enc_GeneralName'(element(2,Val), [<<161>>]);
      targetCert ->
         'enc_TargetCert'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Target(Tlv) ->
   dec_Target(Tlv, []).

dec_Target(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'targetName'
    {131072, V1} -> 
        {targetName, 'dec_GeneralName'(V1, [])};


%% 'targetGroup'
    {131073, V1} -> 
        {targetGroup, 'dec_GeneralName'(V1, [])};


%% 'targetCert'
    {131074, V1} -> 
        {targetCert, 'dec_TargetCert'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Targets
%%================================
enc_Targets(Val) ->
    enc_Targets(Val, [<<48>>]).

enc_Targets(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Targets_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Targets_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Targets_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Target'(H, []),
   'enc_Targets_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Targets(Tlv) ->
   dec_Targets(Tlv, [16]).

dec_Targets(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Target'(V1, []) || V1 <- Tlv1].




%%================================
%%  AttCertValidityPeriod
%%================================
enc_AttCertValidityPeriod(Val) ->
    enc_AttCertValidityPeriod(Val, [<<48>>]).

enc_AttCertValidityPeriod(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBeforeTime(1) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<24>>]),

%%-------------------------------------------------
%% attribute notAfterTime(2) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<24>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttCertValidityPeriod(Tlv) ->
   dec_AttCertValidityPeriod(Tlv, [16]).

dec_AttCertValidityPeriod(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBeforeTime(1) with type GeneralizedTime
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [24]))
end
,

%%-------------------------------------------------
%% attribute notAfterTime(2) with type GeneralizedTime
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [24]))
end
,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttCertValidityPeriod',Term1,Term2},
Res1.


%%================================
%%  IssuerSerial
%%================================
enc_IssuerSerial(Val) ->
    enc_IssuerSerial(Val, [<<48>>]).

enc_IssuerSerial(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External OTP-PUB-KEY:GeneralNames
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_GeneralNames'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute serial(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute issuerUID(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex3, [<<3>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IssuerSerial(Tlv) ->
   dec_IssuerSerial(Tlv, [16]).

dec_IssuerSerial(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External OTP-PUB-KEY:GeneralNames
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_GeneralNames'(V1, [16]),

%%-------------------------------------------------
%% attribute serial(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute issuerUID(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{3,V3}|TempTlv4] ->
    {decode_native_bit_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'IssuerSerial',Term1,Term2,Term3},
Res1.


%%================================
%%  V2Form
%%================================
enc_V2Form(Val) ->
    enc_V2Form(Val, [<<48>>]).

enc_V2Form(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute issuerName(1)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute baseCertificateID(2)   External OTP-PUB-KEY:IssuerSerial OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IssuerSerial'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External OTP-PUB-KEY:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_V2Form(Tlv) ->
   dec_V2Form(Tlv, [16]).

dec_V2Form(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerName(1)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute baseCertificateID(2)   External OTP-PUB-KEY:IssuerSerial OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_IssuerSerial'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External OTP-PUB-KEY:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'V2Form',Term1,Term2,Term3},
Res1.


%%================================
%%  AttCertIssuer
%%================================
enc_AttCertIssuer(Val) ->
    enc_AttCertIssuer(Val, []).

enc_AttCertIssuer(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      v1Form ->
         'enc_GeneralNames'(element(2,Val), [<<48>>]);
      v2Form ->
         'enc_V2Form'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_AttCertIssuer(Tlv) ->
   dec_AttCertIssuer(Tlv, []).

dec_AttCertIssuer(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'v1Form'
    {16, V1} -> 
        {v1Form, 'dec_GeneralNames'(V1, [])};


%% 'v2Form'
    {131072, V1} -> 
        {v2Form, 'dec_V2Form'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ObjectDigestInfo
%%================================
enc_ObjectDigestInfo(Val) ->
    enc_ObjectDigestInfo(Val, [<<48>>]).

enc_ObjectDigestInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute digestedObjectType(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
publicKey -> encode_tags([<<10>>], [0], 1);
publicKeyCert -> encode_tags([<<10>>], [1], 1);
otherObjectTypes -> encode_tags([<<10>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute otherObjectTypeID(2) with type OBJECT IDENTIFIER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_object_identifier(Cindex2, [<<6>>])
       end,

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute objectDigest(4) with type BIT STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_unnamed_bit_string(Cindex4, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ObjectDigestInfo(Tlv) ->
   dec_ObjectDigestInfo(Tlv, [16]).

dec_ObjectDigestInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digestedObjectType(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> publicKey;
1 -> publicKeyCert;
2 -> otherObjectTypes;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end,

%%-------------------------------------------------
%% attribute otherObjectTypeID(2) with type OBJECT IDENTIFIER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{6,V2}|TempTlv3] ->
    {decode_object_identifier(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute objectDigest(4) with type BIT STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_native_bit_string(V4, [3]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'ObjectDigestInfo',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  Holder
%%================================
enc_Holder(Val) ->
    enc_Holder(Val, [<<48>>]).

enc_Holder(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute baseCertificateID(1)   External OTP-PUB-KEY:IssuerSerial OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IssuerSerial'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute entityName(2)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External OTP-PUB-KEY:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Holder(Tlv) ->
   dec_Holder(Tlv, [16]).

dec_Holder(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute baseCertificateID(1)   External OTP-PUB-KEY:IssuerSerial OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_IssuerSerial'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute entityName(2)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralNames'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External OTP-PUB-KEY:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Holder',Term1,Term2,Term3},
Res1.


%%================================
%%  AttCertVersion
%%================================
enc_AttCertVersion(Val) ->
    enc_AttCertVersion(Val, [<<2>>]).

enc_AttCertVersion(Val, TagIn) ->
encode_integer(Val, [{v2,1}], TagIn).


dec_AttCertVersion(Tlv) ->
   dec_AttCertVersion(Tlv, [2]).

dec_AttCertVersion(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v2,1}])
end
.



%%================================
%%  AttributeCertificateInfo
%%================================
enc_AttributeCertificateInfo(Val) ->
    enc_AttributeCertificateInfo(Val, [<<48>>]).

enc_AttributeCertificateInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v2,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute holder(2)   External OTP-PUB-KEY:Holder
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Holder'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(3)   External OTP-PUB-KEY:AttCertIssuer
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AttCertIssuer'(Cindex3, []),

%%-------------------------------------------------
%% attribute signature(4)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_AlgorithmIdentifier'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute attrCertValidityPeriod(6)   External OTP-PUB-KEY:AttCertValidityPeriod
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_AttCertValidityPeriod'(Cindex6, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_AttributeCertificateInfo_attributes'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<3>>])
       end,

%%-------------------------------------------------
%% attribute extensions(9)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex9, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfo_attributes
%%================================
enc_AttributeCertificateInfo_attributes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfo_attributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeCertificateInfo_attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attribute'(H, [<<48>>]),
   'enc_AttributeCertificateInfo_attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AttributeCertificateInfo(Tlv) ->
   dec_AttributeCertificateInfo(Tlv, [16]).

dec_AttributeCertificateInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v2,1}])
end
,

%%-------------------------------------------------
%% attribute holder(2)   External OTP-PUB-KEY:Holder
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Holder'(V2, [16]),

%%-------------------------------------------------
%% attribute issuer(3)   External OTP-PUB-KEY:AttCertIssuer
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AttCertIssuer'(V3, []),

%%-------------------------------------------------
%% attribute signature(4)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_AlgorithmIdentifier'(V4, [16]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute attrCertValidityPeriod(6)   External OTP-PUB-KEY:AttCertValidityPeriod
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_AttCertValidityPeriod'(V6, [16]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_AttributeCertificateInfo_attributes'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{3,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute extensions(9)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{16,V9}|TempTlv10] ->
    {'dec_Extensions'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateInfo',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
Res1.
'dec_AttributeCertificateInfo_attributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AttributeCertificate
%%================================
enc_AttributeCertificate(Val) ->
    enc_AttributeCertificate(Val, [<<48>>]).

enc_AttributeCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute acinfo(1)   External OTP-PUB-KEY:AttributeCertificateInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AttributeCertificateInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureValue(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeCertificate(Tlv) ->
   dec_AttributeCertificate(Tlv, [16]).

dec_AttributeCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute acinfo(1)   External OTP-PUB-KEY:AttributeCertificateInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AttributeCertificateInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signatureValue(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificate',Term1,Term2,Term3},
Res1.


%%================================
%%  InvalidityDate
%%================================
enc_InvalidityDate(Val) ->
    enc_InvalidityDate(Val, [<<24>>]).

enc_InvalidityDate(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_InvalidityDate(Tlv) ->
   dec_InvalidityDate(Tlv, [24]).

dec_InvalidityDate(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  HoldInstructionCode
%%================================
enc_HoldInstructionCode(Val) ->
    enc_HoldInstructionCode(Val, [<<6>>]).

enc_HoldInstructionCode(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_HoldInstructionCode(Tlv) ->
   dec_HoldInstructionCode(Tlv, [6]).

dec_HoldInstructionCode(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  CertificateIssuer
%%================================
enc_CertificateIssuer(Val) ->
    enc_CertificateIssuer(Val, [<<48>>]).

enc_CertificateIssuer(Val, TagIn) ->
   enc_GeneralNames(Val, TagIn).


dec_CertificateIssuer(Tlv) ->
   dec_CertificateIssuer(Tlv, [16]).

dec_CertificateIssuer(Tlv, TagIn) ->
'dec_GeneralNames'(Tlv, TagIn).



%%================================
%%  CRLReason
%%================================
enc_CRLReason(Val) ->
    enc_CRLReason(Val, [<<10>>]).

enc_CRLReason(Val, TagIn) ->
case Val of
unspecified -> encode_tags(TagIn, [0], 1);
keyCompromise -> encode_tags(TagIn, [1], 1);
cACompromise -> encode_tags(TagIn, [2], 1);
affiliationChanged -> encode_tags(TagIn, [3], 1);
superseded -> encode_tags(TagIn, [4], 1);
cessationOfOperation -> encode_tags(TagIn, [5], 1);
certificateHold -> encode_tags(TagIn, [6], 1);
removeFromCRL -> encode_tags(TagIn, [8], 1);
privilegeWithdrawn -> encode_tags(TagIn, [9], 1);
aACompromise -> encode_tags(TagIn, [10], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


dec_CRLReason(Tlv) ->
   dec_CRLReason(Tlv, [10]).

dec_CRLReason(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> unspecified;
1 -> keyCompromise;
2 -> cACompromise;
3 -> affiliationChanged;
4 -> superseded;
5 -> cessationOfOperation;
6 -> certificateHold;
8 -> removeFromCRL;
9 -> privilegeWithdrawn;
10 -> aACompromise;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end.



%%================================
%%  BaseCRLNumber
%%================================
enc_BaseCRLNumber(Val) ->
    enc_BaseCRLNumber(Val, [<<2>>]).

enc_BaseCRLNumber(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_BaseCRLNumber(Tlv) ->
   dec_BaseCRLNumber(Tlv, [2]).

dec_BaseCRLNumber(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  IssuingDistributionPoint
%%================================
enc_IssuingDistributionPoint(Val) ->
    enc_IssuingDistributionPoint(Val, [<<48>>]).

enc_IssuingDistributionPoint(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute distributionPoint(1)   External OTP-PUB-KEY:DistributionPointName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DistributionPointName'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsUserCerts(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_10(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsCACerts(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_11(Cindex3) of
true -> {[],0};
false ->
encode_boolean(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute onlySomeReasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_named_bit_string(Cindex4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<131>>])
       end,

%%-------------------------------------------------
%% attribute indirectCRL(5) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case is_default_12(Cindex5) of
true -> {[],0};
false ->
encode_boolean(Cindex5, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsAttributeCerts(6) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case is_default_13(Cindex6) of
true -> {[],0};
false ->
encode_boolean(Cindex6, [<<133>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IssuingDistributionPoint(Tlv) ->
   dec_IssuingDistributionPoint(Tlv, [16]).

dec_IssuingDistributionPoint(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute distributionPoint(1)   External OTP-PUB-KEY:DistributionPointName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DistributionPointName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute onlyContainsUserCerts(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute onlyContainsCACerts(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_boolean(V3, []), TempTlv4};
    _ ->
        {false,Tlv3}
end,

%%-------------------------------------------------
%% attribute onlySomeReasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {decode_named_bit_string(V4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute indirectCRL(5) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {decode_boolean(V5, []), TempTlv6};
    _ ->
        {false,Tlv5}
end,

%%-------------------------------------------------
%% attribute onlyContainsAttributeCerts(6) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131077,V6}|TempTlv7] ->
    {decode_boolean(V6, []), TempTlv7};
    _ ->
        {false,Tlv6}
end,

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'IssuingDistributionPoint',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.


%%================================
%%  CRLNumber
%%================================
enc_CRLNumber(Val) ->
    enc_CRLNumber(Val, [<<2>>]).

enc_CRLNumber(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_CRLNumber(Tlv) ->
   dec_CRLNumber(Tlv, [2]).

dec_CRLNumber(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  SubjectInfoAccessSyntax
%%================================
enc_SubjectInfoAccessSyntax(Val) ->
    enc_SubjectInfoAccessSyntax(Val, [<<48>>]).

enc_SubjectInfoAccessSyntax(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SubjectInfoAccessSyntax_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectInfoAccessSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubjectInfoAccessSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AccessDescription'(H, [<<48>>]),
   'enc_SubjectInfoAccessSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SubjectInfoAccessSyntax(Tlv) ->
   dec_SubjectInfoAccessSyntax(Tlv, [16]).

dec_SubjectInfoAccessSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AccessDescription'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AccessDescription
%%================================
enc_AccessDescription(Val) ->
    enc_AccessDescription(Val, [<<48>>]).

enc_AccessDescription(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute accessMethod(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute accessLocation(2)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_GeneralName'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AccessDescription(Tlv) ->
   dec_AccessDescription(Tlv, [16]).

dec_AccessDescription(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute accessMethod(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute accessLocation(2)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_GeneralName'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AccessDescription',Term1,Term2},
Res1.


%%================================
%%  AuthorityInfoAccessSyntax
%%================================
enc_AuthorityInfoAccessSyntax(Val) ->
    enc_AuthorityInfoAccessSyntax(Val, [<<48>>]).

enc_AuthorityInfoAccessSyntax(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AuthorityInfoAccessSyntax_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AuthorityInfoAccessSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AuthorityInfoAccessSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AccessDescription'(H, [<<48>>]),
   'enc_AuthorityInfoAccessSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AuthorityInfoAccessSyntax(Tlv) ->
   dec_AuthorityInfoAccessSyntax(Tlv, [16]).

dec_AuthorityInfoAccessSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AccessDescription'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  FreshestCRL
%%================================
enc_FreshestCRL(Val) ->
    enc_FreshestCRL(Val, [<<48>>]).

enc_FreshestCRL(Val, TagIn) ->
   enc_CRLDistributionPoints(Val, TagIn).


dec_FreshestCRL(Tlv) ->
   dec_FreshestCRL(Tlv, [16]).

dec_FreshestCRL(Tlv, TagIn) ->
'dec_CRLDistributionPoints'(Tlv, TagIn).



%%================================
%%  InhibitAnyPolicy
%%================================
enc_InhibitAnyPolicy(Val) ->
    enc_InhibitAnyPolicy(Val, [<<2>>]).

enc_InhibitAnyPolicy(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_InhibitAnyPolicy(Tlv) ->
   dec_InhibitAnyPolicy(Tlv, [2]).

dec_InhibitAnyPolicy(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  KeyPurposeId
%%================================
enc_KeyPurposeId(Val) ->
    enc_KeyPurposeId(Val, [<<6>>]).

enc_KeyPurposeId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_KeyPurposeId(Tlv) ->
   dec_KeyPurposeId(Tlv, [6]).

dec_KeyPurposeId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  ExtKeyUsageSyntax
%%================================
enc_ExtKeyUsageSyntax(Val) ->
    enc_ExtKeyUsageSyntax(Val, [<<48>>]).

enc_ExtKeyUsageSyntax(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtKeyUsageSyntax_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtKeyUsageSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ExtKeyUsageSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_object_identifier(H, [<<6>>]),
   'enc_ExtKeyUsageSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ExtKeyUsageSyntax(Tlv) ->
   dec_ExtKeyUsageSyntax(Tlv, [16]).

dec_ExtKeyUsageSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_object_identifier(V1, [6]) || V1 <- Tlv1].




%%================================
%%  ReasonFlags
%%================================
enc_ReasonFlags(Val) ->
    enc_ReasonFlags(Val, [<<3>>]).

enc_ReasonFlags(Val, TagIn) ->
encode_named_bit_string(Val, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], TagIn).


dec_ReasonFlags(Tlv) ->
   dec_ReasonFlags(Tlv, [3]).

dec_ReasonFlags(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], TagIn).



%%================================
%%  DistributionPointName
%%================================
enc_DistributionPointName(Val) ->
    enc_DistributionPointName(Val, []).

enc_DistributionPointName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      fullName ->
         'enc_GeneralNames'(element(2,Val), [<<160>>]);
      nameRelativeToCRLIssuer ->
         'enc_RelativeDistinguishedName'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_DistributionPointName(Tlv) ->
   dec_DistributionPointName(Tlv, []).

dec_DistributionPointName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'fullName'
    {131072, V1} -> 
        {fullName, 'dec_GeneralNames'(V1, [])};


%% 'nameRelativeToCRLIssuer'
    {131073, V1} -> 
        {nameRelativeToCRLIssuer, 'dec_RelativeDistinguishedName'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  DistributionPoint
%%================================
enc_DistributionPoint(Val) ->
    enc_DistributionPoint(Val, [<<48>>]).

enc_DistributionPoint(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute distributionPoint(1)   External OTP-PUB-KEY:DistributionPointName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DistributionPointName'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute reasons(2) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_named_bit_string(Cindex2, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute cRLIssuer(3)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DistributionPoint(Tlv) ->
   dec_DistributionPoint(Tlv, [16]).

dec_DistributionPoint(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute distributionPoint(1)   External OTP-PUB-KEY:DistributionPointName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DistributionPointName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute reasons(2) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_named_bit_string(V2, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute cRLIssuer(3)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_GeneralNames'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'DistributionPoint',Term1,Term2,Term3},
Res1.


%%================================
%%  CRLDistributionPoints
%%================================
enc_CRLDistributionPoints(Val) ->
    enc_CRLDistributionPoints(Val, [<<48>>]).

enc_CRLDistributionPoints(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CRLDistributionPoints_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CRLDistributionPoints_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CRLDistributionPoints_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_DistributionPoint'(H, [<<48>>]),
   'enc_CRLDistributionPoints_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CRLDistributionPoints(Tlv) ->
   dec_CRLDistributionPoints(Tlv, [16]).

dec_CRLDistributionPoints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_DistributionPoint'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SkipCerts
%%================================
enc_SkipCerts(Val) ->
    enc_SkipCerts(Val, [<<2>>]).

enc_SkipCerts(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_SkipCerts(Tlv) ->
   dec_SkipCerts(Tlv, [2]).

dec_SkipCerts(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PolicyConstraints
%%================================
enc_PolicyConstraints(Val) ->
    enc_PolicyConstraints(Val, [<<48>>]).

enc_PolicyConstraints(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute requireExplicitPolicy(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute inhibitPolicyMapping(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PolicyConstraints(Tlv) ->
   dec_PolicyConstraints(Tlv, [16]).

dec_PolicyConstraints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requireExplicitPolicy(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute inhibitPolicyMapping(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 'MAX' ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyConstraints',Term1,Term2},
Res1.


%%================================
%%  BaseDistance
%%================================
enc_BaseDistance(Val) ->
    enc_BaseDistance(Val, [<<2>>]).

enc_BaseDistance(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_BaseDistance(Tlv) ->
   dec_BaseDistance(Tlv, [2]).

dec_BaseDistance(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  GeneralSubtree
%%================================
enc_GeneralSubtree(Val) ->
    enc_GeneralSubtree(Val, [<<48>>]).

enc_GeneralSubtree(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute base(1)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute minimum(2) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_14(Cindex2) of
true -> {[],0};
false ->
encode_integer(Cindex2, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute maximum(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_GeneralSubtree(Tlv) ->
   dec_GeneralSubtree(Tlv, [16]).

dec_GeneralSubtree(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute base(1)   External OTP-PUB-KEY:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute minimum(2) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {begin
Val1 = decode_integer(V2, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        {0,Tlv2}
end,

%%-------------------------------------------------
%% attribute maximum(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {begin
Val2 = decode_integer(V3, []),
if 0 =< Val2, Val2 =< 'MAX' ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'GeneralSubtree',Term1,Term2,Term3},
Res1.


%%================================
%%  GeneralSubtrees
%%================================
enc_GeneralSubtrees(Val) ->
    enc_GeneralSubtrees(Val, [<<48>>]).

enc_GeneralSubtrees(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GeneralSubtrees_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_GeneralSubtrees_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GeneralSubtrees_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_GeneralSubtree'(H, [<<48>>]),
   'enc_GeneralSubtrees_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_GeneralSubtrees(Tlv) ->
   dec_GeneralSubtrees(Tlv, [16]).

dec_GeneralSubtrees(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_GeneralSubtree'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  NameConstraints
%%================================
enc_NameConstraints(Val) ->
    enc_NameConstraints(Val, [<<48>>]).

enc_NameConstraints(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute permittedSubtrees(1)   External OTP-PUB-KEY:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralSubtrees'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute excludedSubtrees(2)   External OTP-PUB-KEY:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralSubtrees'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_NameConstraints(Tlv) ->
   dec_NameConstraints(Tlv, [16]).

dec_NameConstraints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute permittedSubtrees(1)   External OTP-PUB-KEY:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_GeneralSubtrees'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute excludedSubtrees(2)   External OTP-PUB-KEY:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralSubtrees'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'NameConstraints',Term1,Term2},
Res1.


%%================================
%%  BasicConstraints
%%================================
enc_BasicConstraints(Val) ->
    enc_BasicConstraints(Val, [<<48>>]).

enc_BasicConstraints(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute cA(1) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_15(Cindex1) of
true -> {[],0};
false ->
encode_boolean(Cindex1, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute pathLenConstraint(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<2>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BasicConstraints(Tlv) ->
   dec_BasicConstraints(Tlv, [16]).

dec_BasicConstraints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute cA(1) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{1,V1}|TempTlv2] ->
    {decode_boolean(V1, []), TempTlv2};
    _ ->
        {false,Tlv1}
end,

%%-------------------------------------------------
%% attribute pathLenConstraint(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{2,V2}|TempTlv3] ->
    {begin
Val1 = decode_integer(V2, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'BasicConstraints',Term1,Term2},
Res1.


%%================================
%%  SubjectDirectoryAttributes
%%================================
enc_SubjectDirectoryAttributes(Val) ->
    enc_SubjectDirectoryAttributes(Val, [<<48>>]).

enc_SubjectDirectoryAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SubjectDirectoryAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectDirectoryAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubjectDirectoryAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attribute'(H, [<<48>>]),
   'enc_SubjectDirectoryAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SubjectDirectoryAttributes(Tlv) ->
   dec_SubjectDirectoryAttributes(Tlv, [16]).

dec_SubjectDirectoryAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  IssuerAltName
%%================================
enc_IssuerAltName(Val) ->
    enc_IssuerAltName(Val, [<<48>>]).

enc_IssuerAltName(Val, TagIn) ->
   enc_GeneralNames(Val, TagIn).


dec_IssuerAltName(Tlv) ->
   dec_IssuerAltName(Tlv, [16]).

dec_IssuerAltName(Tlv, TagIn) ->
'dec_GeneralNames'(Tlv, TagIn).



%%================================
%%  EDIPartyName
%%================================
enc_EDIPartyName(Val) ->
    enc_EDIPartyName(Val, [<<48>>]).

enc_EDIPartyName(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute nameAssigner(1)   External OTP-PUB-KEY:DirectoryString OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DirectoryString'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute partyName(2)   External OTP-PUB-KEY:DirectoryString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_DirectoryString'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EDIPartyName(Tlv) ->
   dec_EDIPartyName(Tlv, [16]).

dec_EDIPartyName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute nameAssigner(1)   External OTP-PUB-KEY:DirectoryString OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DirectoryString'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute partyName(2)   External OTP-PUB-KEY:DirectoryString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_DirectoryString'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EDIPartyName',Term1,Term2},
Res1.


%%================================
%%  AnotherName
%%================================
enc_AnotherName(Val) ->
    enc_AnotherName(Val, [<<48>>]).

enc_AnotherName(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type-id(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, [<<160>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AnotherName(Tlv) ->
   dec_AnotherName(Tlv, [16]).

dec_AnotherName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type-id(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, [131072]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AnotherName',Term1,Term2},
Res1.


%%================================
%%  GeneralName
%%================================
enc_GeneralName(Val) ->
    enc_GeneralName(Val, []).

enc_GeneralName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      otherName ->
         'enc_AnotherName'(element(2,Val), [<<160>>]);
      rfc822Name ->
         encode_restricted_string(element(2,Val), [<<129>>]);
      dNSName ->
         encode_restricted_string(element(2,Val), [<<130>>]);
      x400Address ->
         'enc_ORAddress'(element(2,Val), [<<163>>]);
      directoryName ->
         'enc_Name'(element(2,Val), [<<164>>]);
      ediPartyName ->
         'enc_EDIPartyName'(element(2,Val), [<<165>>]);
      uniformResourceIdentifier ->
         encode_restricted_string(element(2,Val), [<<134>>]);
      iPAddress ->
         encode_restricted_string(element(2,Val), [<<135>>]);
      registeredID ->
         encode_object_identifier(element(2,Val), [<<136>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_GeneralName(Tlv) ->
   dec_GeneralName(Tlv, []).

dec_GeneralName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'otherName'
    {131072, V1} -> 
        {otherName, 'dec_AnotherName'(V1, [])};


%% 'rfc822Name'
    {131073, V1} -> 
        {rfc822Name, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'dNSName'
    {131074, V1} -> 
        {dNSName, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'x400Address'
    {131075, V1} -> 
        {x400Address, 'dec_ORAddress'(V1, [])};


%% 'directoryName'
    {131076, V1} -> 
        {directoryName, 'dec_Name'(V1, [])};


%% 'ediPartyName'
    {131077, V1} -> 
        {ediPartyName, 'dec_EDIPartyName'(V1, [])};


%% 'uniformResourceIdentifier'
    {131078, V1} -> 
        {uniformResourceIdentifier, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'iPAddress'
    {131079, V1} -> 
        {iPAddress, decode_octet_string(V1, [])};


%% 'registeredID'
    {131080, V1} -> 
        {registeredID, decode_object_identifier(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  GeneralNames
%%================================
enc_GeneralNames(Val) ->
    enc_GeneralNames(Val, [<<48>>]).

enc_GeneralNames(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GeneralNames_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_GeneralNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GeneralNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_GeneralName'(H, []),
   'enc_GeneralNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_GeneralNames(Tlv) ->
   dec_GeneralNames(Tlv, [16]).

dec_GeneralNames(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_GeneralName'(V1, []) || V1 <- Tlv1].




%%================================
%%  SubjectAltName
%%================================
enc_SubjectAltName(Val) ->
    enc_SubjectAltName(Val, [<<48>>]).

enc_SubjectAltName(Val, TagIn) ->
   enc_GeneralNames(Val, TagIn).


dec_SubjectAltName(Tlv) ->
   dec_SubjectAltName(Tlv, [16]).

dec_SubjectAltName(Tlv, TagIn) ->
'dec_GeneralNames'(Tlv, TagIn).



%%================================
%%  PolicyMappings
%%================================
enc_PolicyMappings(Val) ->
    enc_PolicyMappings(Val, [<<48>>]).

enc_PolicyMappings(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PolicyMappings_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PolicyMappings_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PolicyMappings_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyMappings_SEQOF'(H, [<<48>>]),
   'enc_PolicyMappings_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PolicyMappings_SEQOF
%%================================
enc_PolicyMappings_SEQOF(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuerDomainPolicy(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute subjectDomainPolicy(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PolicyMappings(Tlv) ->
   dec_PolicyMappings(Tlv, [16]).

dec_PolicyMappings(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PolicyMappings_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_PolicyMappings_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerDomainPolicy(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute subjectDomainPolicy(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyMappings_SEQOF',Term1,Term2},
Res1.


%%================================
%%  DisplayText
%%================================
enc_DisplayText(Val) ->
    enc_DisplayText(Val, []).

enc_DisplayText(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ia5String ->
         encode_restricted_string(element(2,Val), [<<22>>]);
      visibleString ->
         encode_restricted_string(element(2,Val), [<<26>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_DisplayText(Tlv) ->
   dec_DisplayText(Tlv, []).

dec_DisplayText(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ia5String'
    {22, V1} -> 
        {ia5String, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 200 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'visibleString'
    {26, V1} -> 
        {visibleString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 200 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 200 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  NoticeReference
%%================================
enc_NoticeReference(Val) ->
    enc_NoticeReference(Val, [<<48>>]).

enc_NoticeReference(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute organization(1)   External OTP-PUB-KEY:DisplayText
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DisplayText'(Cindex1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_NoticeReference_noticeNumbers'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  NoticeReference_noticeNumbers
%%================================
enc_NoticeReference_noticeNumbers(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_NoticeReference_noticeNumbers_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_NoticeReference_noticeNumbers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_NoticeReference_noticeNumbers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_NoticeReference_noticeNumbers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_NoticeReference(Tlv) ->
   dec_NoticeReference(Tlv, [16]).

dec_NoticeReference(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute organization(1)   External OTP-PUB-KEY:DisplayText
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DisplayText'(V1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_NoticeReference_noticeNumbers'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'NoticeReference',Term1,Term2},
Res1.
'dec_NoticeReference_noticeNumbers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_integer(V1, [2]) || V1 <- Tlv1].




%%================================
%%  UserNotice
%%================================
enc_UserNotice(Val) ->
    enc_UserNotice(Val, [<<48>>]).

enc_UserNotice(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute noticeRef(1)   External OTP-PUB-KEY:NoticeReference OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_NoticeReference'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute explicitText(2)   External OTP-PUB-KEY:DisplayText OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DisplayText'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_UserNotice(Tlv) ->
   dec_UserNotice(Tlv, [16]).

dec_UserNotice(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute noticeRef(1)   External OTP-PUB-KEY:NoticeReference OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'dec_NoticeReference'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute explicitText(2)   External OTP-PUB-KEY:DisplayText OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {22,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {26,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {30,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {12,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'UserNotice',Term1,Term2},
Res1.


%%================================
%%  CPSuri
%%================================
enc_CPSuri(Val) ->
    enc_CPSuri(Val, [<<22>>]).

enc_CPSuri(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CPSuri(Tlv) ->
   dec_CPSuri(Tlv, [22]).

dec_CPSuri(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  PolicyQualifierId
%%================================
enc_PolicyQualifierId(Val) ->
    enc_PolicyQualifierId(Val, [<<6>>]).

enc_PolicyQualifierId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_PolicyQualifierId(Tlv) ->
   dec_PolicyQualifierId(Tlv, [6]).

dec_PolicyQualifierId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  PolicyQualifierInfo
%%================================
enc_PolicyQualifierInfo(Val) ->
    enc_PolicyQualifierInfo(Val, [<<48>>]).

enc_PolicyQualifierInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute qualifier(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PolicyQualifierInfo(Tlv) ->
   dec_PolicyQualifierInfo(Tlv, [16]).

dec_PolicyQualifierInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute qualifier(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyQualifierInfo',Term1,Term2},
Res1.


%%================================
%%  CertPolicyId
%%================================
enc_CertPolicyId(Val) ->
    enc_CertPolicyId(Val, [<<6>>]).

enc_CertPolicyId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_CertPolicyId(Tlv) ->
   dec_CertPolicyId(Tlv, [6]).

dec_CertPolicyId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  PolicyInformation
%%================================
enc_PolicyInformation(Val) ->
    enc_PolicyInformation(Val, [<<48>>]).

enc_PolicyInformation(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PolicyInformation_policyQualifiers'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PolicyInformation_policyQualifiers
%%================================
enc_PolicyInformation_policyQualifiers(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PolicyInformation_policyQualifiers_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PolicyInformation_policyQualifiers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PolicyInformation_policyQualifiers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyQualifierInfo'(H, [<<48>>]),
   'enc_PolicyInformation_policyQualifiers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PolicyInformation(Tlv) ->
   dec_PolicyInformation(Tlv, [16]).

dec_PolicyInformation(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_PolicyInformation_policyQualifiers'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyInformation',Term1,Term2},
Res1.
'dec_PolicyInformation_policyQualifiers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PolicyQualifierInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertificatePolicies
%%================================
enc_CertificatePolicies(Val) ->
    enc_CertificatePolicies(Val, [<<48>>]).

enc_CertificatePolicies(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertificatePolicies_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificatePolicies_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertificatePolicies_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyInformation'(H, [<<48>>]),
   'enc_CertificatePolicies_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertificatePolicies(Tlv) ->
   dec_CertificatePolicies(Tlv, [16]).

dec_CertificatePolicies(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PolicyInformation'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PrivateKeyUsagePeriod
%%================================
enc_PrivateKeyUsagePeriod(Val) ->
    enc_PrivateKeyUsagePeriod(Val, [<<48>>]).

enc_PrivateKeyUsagePeriod(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute notAfter(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PrivateKeyUsagePeriod(Tlv) ->
   dec_PrivateKeyUsagePeriod(Tlv, [16]).

dec_PrivateKeyUsagePeriod(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBefore(1) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, []))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute notAfter(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PrivateKeyUsagePeriod',Term1,Term2},
Res1.


%%================================
%%  KeyUsage
%%================================
enc_KeyUsage(Val) ->
    enc_KeyUsage(Val, [<<3>>]).

enc_KeyUsage(Val, TagIn) ->
encode_named_bit_string(Val, [{digitalSignature,0},{nonRepudiation,1},{keyEncipherment,2},{dataEncipherment,3},{keyAgreement,4},{keyCertSign,5},{cRLSign,6},{encipherOnly,7},{decipherOnly,8}], TagIn).


dec_KeyUsage(Tlv) ->
   dec_KeyUsage(Tlv, [3]).

dec_KeyUsage(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{digitalSignature,0},{nonRepudiation,1},{keyEncipherment,2},{dataEncipherment,3},{keyAgreement,4},{keyCertSign,5},{cRLSign,6},{encipherOnly,7},{decipherOnly,8}], TagIn).



%%================================
%%  SubjectKeyIdentifier
%%================================
enc_SubjectKeyIdentifier(Val) ->
    enc_SubjectKeyIdentifier(Val, [<<4>>]).

enc_SubjectKeyIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_SubjectKeyIdentifier(Tlv) ->
   dec_SubjectKeyIdentifier(Tlv, [4]).

dec_SubjectKeyIdentifier(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  KeyIdentifier
%%================================
enc_KeyIdentifier(Val) ->
    enc_KeyIdentifier(Val, [<<4>>]).

enc_KeyIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_KeyIdentifier(Tlv) ->
   dec_KeyIdentifier(Tlv, [4]).

dec_KeyIdentifier(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  AuthorityKeyIdentifier
%%================================
enc_AuthorityKeyIdentifier(Val) ->
    enc_AuthorityKeyIdentifier(Val, [<<48>>]).

enc_AuthorityKeyIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute authorityCertIssuer(2)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute authorityCertSerialNumber(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AuthorityKeyIdentifier(Tlv) ->
   dec_AuthorityKeyIdentifier(Tlv, [16]).

dec_AuthorityKeyIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_octet_string(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute authorityCertIssuer(2)   External OTP-PUB-KEY:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralNames'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute authorityCertSerialNumber(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_integer(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'AuthorityKeyIdentifier',Term1,Term2,Term3},
Res1.


%%================================
%%  EncryptedData
%%================================
enc_EncryptedData(Val) ->
    enc_EncryptedData(Val, [<<48>>]).

enc_EncryptedData(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{edVer0,0}], [<<2>>]),

%%-------------------------------------------------
%% attribute encryptedContentInfo(2)   External OTP-PUB-KEY:EncryptedContentInfo
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_EncryptedContentInfo'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncryptedData(Tlv) ->
   dec_EncryptedData(Tlv, [16]).

dec_EncryptedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{edVer0,0}])
end
,

%%-------------------------------------------------
%% attribute encryptedContentInfo(2)   External OTP-PUB-KEY:EncryptedContentInfo
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_EncryptedContentInfo'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedData',Term1,Term2},
Res1.


%%================================
%%  DigestedData
%%================================
enc_DigestedData(Val) ->
    enc_DigestedData(Val, [<<48>>]).

enc_DigestedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{ddVer0,0}], [<<2>>]),

%%-------------------------------------------------
%% attribute digestAlgorithm(2)   External OTP-PUB-KEY:DigestAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_DigestAlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute contentInfo(3)   External OTP-PUB-KEY:ContentInfo
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ContentInfo'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute digest(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestedData(Tlv) ->
   dec_DigestedData(Tlv, [16]).

dec_DigestedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{ddVer0,0}])
end
,

%%-------------------------------------------------
%% attribute digestAlgorithm(2)   External OTP-PUB-KEY:DigestAlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_DigestAlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute contentInfo(3)   External OTP-PUB-KEY:ContentInfo
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ContentInfo'(V3, [16]),

%%-------------------------------------------------
%% attribute digest(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'DigestedData',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  SignedAndEnvelopedData
%%================================
enc_SignedAndEnvelopedData(Val) ->
    enc_SignedAndEnvelopedData(Val, [<<48>>]).

enc_SignedAndEnvelopedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{seVer1,1},{seVer2,2}], [<<2>>]),

%%-------------------------------------------------
%% attribute recipientInfos(2)   External OTP-PUB-KEY:RecipientInfos
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_RecipientInfos'(Cindex2, []),

%%-------------------------------------------------
%% attribute digestAlgorithms(3)   External OTP-PUB-KEY:DigestAlgorithmIdentifiers
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_DigestAlgorithmIdentifiers'(Cindex3, []),

%%-------------------------------------------------
%% attribute encryptedContentInfo(4)   External OTP-PUB-KEY:EncryptedContentInfo
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_EncryptedContentInfo'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute certificates(5) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignedAndEnvelopedData_certificates'(Cindex5, [])
       end,

%%-------------------------------------------------
%% attribute crls(6) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignedAndEnvelopedData_crls'(Cindex6, [])
       end,

%%-------------------------------------------------
%% attribute signerInfos(7)   External OTP-PUB-KEY:SignerInfos
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_SignerInfos'(Cindex7, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignedAndEnvelopedData_certificates
%%================================
enc_SignedAndEnvelopedData_certificates(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      certSet ->
         'enc_ExtendedCertificatesAndCertificates'(element(2,Val), [<<160>>]);
      certSequence ->
         'enc_Certificates'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  SignedAndEnvelopedData_crls
%%================================
enc_SignedAndEnvelopedData_crls(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      crlSet ->
         'enc_CertificateRevocationLists'(element(2,Val), [<<161>>]);
      crlSequence ->
         'enc_CRLSequence'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_SignedAndEnvelopedData(Tlv) ->
   dec_SignedAndEnvelopedData(Tlv, [16]).

dec_SignedAndEnvelopedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{seVer1,1},{seVer2,2}])
end
,

%%-------------------------------------------------
%% attribute recipientInfos(2)   External OTP-PUB-KEY:RecipientInfos
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_RecipientInfos'(V2, []),

%%-------------------------------------------------
%% attribute digestAlgorithms(3)   External OTP-PUB-KEY:DigestAlgorithmIdentifiers
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_DigestAlgorithmIdentifiers'(V3, []),

%%-------------------------------------------------
%% attribute encryptedContentInfo(4)   External OTP-PUB-KEY:EncryptedContentInfo
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_EncryptedContentInfo'(V4, [16]),

%%-------------------------------------------------
%% attribute certificates(5) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[V5 = {131072,_}|TempTlv6] ->
    {'dec_SignedAndEnvelopedData_certificates'(V5, []), TempTlv6};
[V5 = {131074,_}|TempTlv6] ->
    {'dec_SignedAndEnvelopedData_certificates'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute crls(6) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[V6 = {131073,_}|TempTlv7] ->
    {'dec_SignedAndEnvelopedData_crls'(V6, []), TempTlv7};
[V6 = {131075,_}|TempTlv7] ->
    {'dec_SignedAndEnvelopedData_crls'(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute signerInfos(7)   External OTP-PUB-KEY:SignerInfos
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_SignerInfos'(V7, []),

case Tlv8 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv8}}}) % extra fields not allowed
end,
Res1 = {'SignedAndEnvelopedData',Term1,Term2,Term3,Term4,Term5,Term6,Term7},
Res1.
'dec_SignedAndEnvelopedData_certificates'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'certSet'
    {131072, V1} -> 
        {certSet, 'dec_ExtendedCertificatesAndCertificates'(V1, [])};


%% 'certSequence'
    {131074, V1} -> 
        {certSequence, 'dec_Certificates'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_SignedAndEnvelopedData_crls'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'crlSet'
    {131073, V1} -> 
        {crlSet, 'dec_CertificateRevocationLists'(V1, [])};


%% 'crlSequence'
    {131075, V1} -> 
        {crlSequence, 'dec_CRLSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  EncryptedKey
%%================================
enc_EncryptedKey(Val) ->
    enc_EncryptedKey(Val, [<<4>>]).

enc_EncryptedKey(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncryptedKey(Tlv) ->
   dec_EncryptedKey(Tlv, [4]).

dec_EncryptedKey(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  RecipientInfo
%%================================
enc_RecipientInfo(Val) ->
    enc_RecipientInfo(Val, [<<48>>]).

enc_RecipientInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{riVer0,0}], [<<2>>]),

%%-------------------------------------------------
%% attribute issuerAndSerialNumber(2)   External OTP-PUB-KEY:IssuerAndSerialNumber
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IssuerAndSerialNumber'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3)   External OTP-PUB-KEY:KeyEncryptionAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_KeyEncryptionAlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RecipientInfo(Tlv) ->
   dec_RecipientInfo(Tlv, [16]).

dec_RecipientInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{riVer0,0}])
end
,

%%-------------------------------------------------
%% attribute issuerAndSerialNumber(2)   External OTP-PUB-KEY:IssuerAndSerialNumber
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IssuerAndSerialNumber'(V2, [16]),

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3)   External OTP-PUB-KEY:KeyEncryptionAlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_KeyEncryptionAlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'RecipientInfo',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  EncryptedContent
%%================================
enc_EncryptedContent(Val) ->
    enc_EncryptedContent(Val, [<<4>>]).

enc_EncryptedContent(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncryptedContent(Tlv) ->
   dec_EncryptedContent(Tlv, [4]).

dec_EncryptedContent(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  EncryptedContentInfo
%%================================
enc_EncryptedContentInfo(Val) ->
    enc_EncryptedContentInfo(Val, [<<48>>]).

enc_EncryptedContentInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute contentEncryptionAlgorithm(2)   External OTP-PUB-KEY:ContentEncryptionAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ContentEncryptionAlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedContent(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<128>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncryptedContentInfo(Tlv) ->
   dec_EncryptedContentInfo(Tlv, [16]).

dec_EncryptedContentInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute contentEncryptionAlgorithm(2)   External OTP-PUB-KEY:ContentEncryptionAlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ContentEncryptionAlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute encryptedContent(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {decode_octet_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'EncryptedContentInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  RecipientInfos
%%================================
enc_RecipientInfos(Val) ->
    enc_RecipientInfos(Val, []).

enc_RecipientInfos(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      riSet ->
         'enc_RecipientInfos_riSet'(element(2,Val), [<<49>>]);
      riSequence ->
         'enc_RecipientInfos_riSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  RecipientInfos_riSet
%%================================
enc_RecipientInfos_riSet(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RecipientInfos_riSet_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RecipientInfos_riSet_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_RecipientInfos_riSet_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RecipientInfo'(H, [<<48>>]),
   'enc_RecipientInfos_riSet_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  RecipientInfos_riSequence
%%================================
enc_RecipientInfos_riSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RecipientInfos_riSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RecipientInfos_riSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RecipientInfos_riSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RecipientInfo'(H, [<<48>>]),
   'enc_RecipientInfos_riSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RecipientInfos(Tlv) ->
   dec_RecipientInfos(Tlv, []).

dec_RecipientInfos(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'riSet'
    {17, V1} -> 
        {riSet, 'dec_RecipientInfos_riSet'(V1, [])};


%% 'riSequence'
    {16, V1} -> 
        {riSequence, 'dec_RecipientInfos_riSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_RecipientInfos_riSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RecipientInfo'(V1, [16]) || V1 <- Tlv1].


'dec_RecipientInfos_riSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RecipientInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  EnvelopedData
%%================================
enc_EnvelopedData(Val) ->
    enc_EnvelopedData(Val, [<<48>>]).

enc_EnvelopedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{edVer0,0},{edVer1,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute recipientInfos(2)   External OTP-PUB-KEY:RecipientInfos
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_RecipientInfos'(Cindex2, []),

%%-------------------------------------------------
%% attribute encryptedContentInfo(3)   External OTP-PUB-KEY:EncryptedContentInfo
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_EncryptedContentInfo'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EnvelopedData(Tlv) ->
   dec_EnvelopedData(Tlv, [16]).

dec_EnvelopedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{edVer0,0},{edVer1,1}])
end
,

%%-------------------------------------------------
%% attribute recipientInfos(2)   External OTP-PUB-KEY:RecipientInfos
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_RecipientInfos'(V2, []),

%%-------------------------------------------------
%% attribute encryptedContentInfo(3)   External OTP-PUB-KEY:EncryptedContentInfo
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_EncryptedContentInfo'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'EnvelopedData',Term1,Term2,Term3},
Res1.


%%================================
%%  Digest
%%================================
enc_Digest(Val) ->
    enc_Digest(Val, [<<4>>]).

enc_Digest(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_Digest(Tlv) ->
   dec_Digest(Tlv, [4]).

dec_Digest(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  DigestInfoPKCS-7
%%================================
'enc_DigestInfoPKCS-7'(Val) ->
    'enc_DigestInfoPKCS-7'(Val, [<<48>>]).

'enc_DigestInfoPKCS-7'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute digestAlgorithm(1)   External OTP-PUB-KEY:DigestAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DigestAlgorithmIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute digest(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DigestInfoPKCS-7'(Tlv) ->
   'dec_DigestInfoPKCS-7'(Tlv, [16]).

'dec_DigestInfoPKCS-7'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digestAlgorithm(1)   External OTP-PUB-KEY:DigestAlgorithmIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DigestAlgorithmIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute digest(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestInfoPKCS-7',Term1,Term2},
Res1.


%%================================
%%  EncryptedDigest
%%================================
enc_EncryptedDigest(Val) ->
    enc_EncryptedDigest(Val, [<<4>>]).

enc_EncryptedDigest(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncryptedDigest(Tlv) ->
   dec_EncryptedDigest(Tlv, [4]).

dec_EncryptedDigest(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  SignerInfo
%%================================
enc_SignerInfo(Val) ->
    enc_SignerInfo(Val, [<<48>>]).

enc_SignerInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{siVer1,1},{siVer2,2}], [<<2>>]),

%%-------------------------------------------------
%% attribute issuerAndSerialNumber(2)   External OTP-PUB-KEY:IssuerAndSerialNumber
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IssuerAndSerialNumber'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External OTP-PUB-KEY:DigestAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_DigestAlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute authenticatedAttributes(4)   External OTP-PUB-KEY:SignerInfoAuthenticatedAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignerInfoAuthenticatedAttributes'(Cindex4, [])
       end,

%%-------------------------------------------------
%% attribute digestEncryptionAlgorithm(5)   External OTP-PUB-KEY:DigestEncryptionAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_DigestEncryptionAlgorithmIdentifier'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedDigest(6) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_restricted_string(Cindex6, [<<4>>]),

%%-------------------------------------------------
%% attribute unauthenticatedAttributes(7) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignerInfo_unauthenticatedAttributes'(Cindex7, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfo_unauthenticatedAttributes
%%================================
enc_SignerInfo_unauthenticatedAttributes(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      uaSet ->
         'enc_SignerInfo_unauthenticatedAttributes_uaSet'(element(2,Val), [<<161>>]);
      uaSequence ->
         'enc_SignerInfo_unauthenticatedAttributes_uaSequence'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  SignerInfo_unauthenticatedAttributes_uaSet
%%================================
enc_SignerInfo_unauthenticatedAttributes_uaSet(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfo_unauthenticatedAttributes_uaSet_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfo_unauthenticatedAttributes_uaSet_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfo_unauthenticatedAttributes_uaSet_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7'(H, [<<48>>]),
   'enc_SignerInfo_unauthenticatedAttributes_uaSet_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7
%%================================
'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_13'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values
%%================================
'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values'(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfo_unauthenticatedAttributes_uaSequence
%%================================
enc_SignerInfo_unauthenticatedAttributes_uaSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfo_unauthenticatedAttributes_uaSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfo_unauthenticatedAttributes_uaSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SignerInfo_unauthenticatedAttributes_uaSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7'(H, [<<48>>]),
   'enc_SignerInfo_unauthenticatedAttributes_uaSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7
%%================================
'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_14'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values
%%================================
'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values'(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignerInfo(Tlv) ->
   dec_SignerInfo(Tlv, [16]).

dec_SignerInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{siVer1,1},{siVer2,2}])
end
,

%%-------------------------------------------------
%% attribute issuerAndSerialNumber(2)   External OTP-PUB-KEY:IssuerAndSerialNumber
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IssuerAndSerialNumber'(V2, [16]),

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External OTP-PUB-KEY:DigestAlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_DigestAlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute authenticatedAttributes(4)   External OTP-PUB-KEY:SignerInfoAuthenticatedAttributes OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[V4 = {131072,_}|TempTlv5] ->
    {'dec_SignerInfoAuthenticatedAttributes'(V4, []), TempTlv5};
[V4 = {131074,_}|TempTlv5] ->
    {'dec_SignerInfoAuthenticatedAttributes'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute digestEncryptionAlgorithm(5)   External OTP-PUB-KEY:DigestEncryptionAlgorithmIdentifier
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_DigestEncryptionAlgorithmIdentifier'(V5, [16]),

%%-------------------------------------------------
%% attribute encryptedDigest(6) with type OCTET STRING
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_octet_string(V6, [4]),

%%-------------------------------------------------
%% attribute unauthenticatedAttributes(7) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[V7 = {131073,_}|TempTlv8] ->
    {'dec_SignerInfo_unauthenticatedAttributes'(V7, []), TempTlv8};
[V7 = {131075,_}|TempTlv8] ->
    {'dec_SignerInfo_unauthenticatedAttributes'(V7, []), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

case Tlv8 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv8}}}) % extra fields not allowed
end,
Res1 = {'SignerInfo',Term1,Term2,Term3,Term4,Term5,Term6,Term7},
Res1.
'dec_SignerInfo_unauthenticatedAttributes'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'uaSet'
    {131073, V1} -> 
        {uaSet, 'dec_SignerInfo_unauthenticatedAttributes_uaSet'(V1, [])};


%% 'uaSequence'
    {131075, V1} -> 
        {uaSequence, 'dec_SignerInfo_unauthenticatedAttributes_uaSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_SignerInfo_unauthenticatedAttributes_uaSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7'(V1, [16]) || V1 <- Tlv1].


'dec_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'OTP-PUB-KEY':'getdec_internal_object_set_argument_13'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributePKCS-7',Term1,Term2},
Res1.
'dec_SignerInfo_unauthenticatedAttributes_uaSet_AttributePKCS-7_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'dec_SignerInfo_unauthenticatedAttributes_uaSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7'(V1, [16]) || V1 <- Tlv1].


'dec_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'OTP-PUB-KEY':'getdec_internal_object_set_argument_14'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributePKCS-7',Term1,Term2},
Res1.
'dec_SignerInfo_unauthenticatedAttributes_uaSequence_AttributePKCS-7_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  DigestAlgorithmIdentifiers
%%================================
enc_DigestAlgorithmIdentifiers(Val) ->
    enc_DigestAlgorithmIdentifiers(Val, []).

enc_DigestAlgorithmIdentifiers(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      daSet ->
         'enc_DigestAlgorithmIdentifiers_daSet'(element(2,Val), [<<49>>]);
      daSequence ->
         'enc_DigestAlgorithmIdentifiers_daSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  DigestAlgorithmIdentifiers_daSet
%%================================
enc_DigestAlgorithmIdentifiers_daSet(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_DigestAlgorithmIdentifiers_daSet_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_DigestAlgorithmIdentifiers_daSet_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_DigestAlgorithmIdentifiers_daSet_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_DigestAlgorithmIdentifier'(H, [<<48>>]),
   'enc_DigestAlgorithmIdentifiers_daSet_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  DigestAlgorithmIdentifiers_daSequence
%%================================
enc_DigestAlgorithmIdentifiers_daSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_DigestAlgorithmIdentifiers_daSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_DigestAlgorithmIdentifiers_daSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_DigestAlgorithmIdentifiers_daSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_DigestAlgorithmIdentifier'(H, [<<48>>]),
   'enc_DigestAlgorithmIdentifiers_daSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_DigestAlgorithmIdentifiers(Tlv) ->
   dec_DigestAlgorithmIdentifiers(Tlv, []).

dec_DigestAlgorithmIdentifiers(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'daSet'
    {17, V1} -> 
        {daSet, 'dec_DigestAlgorithmIdentifiers_daSet'(V1, [])};


%% 'daSequence'
    {16, V1} -> 
        {daSequence, 'dec_DigestAlgorithmIdentifiers_daSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_DigestAlgorithmIdentifiers_daSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_DigestAlgorithmIdentifier'(V1, [16]) || V1 <- Tlv1].


'dec_DigestAlgorithmIdentifiers_daSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_DigestAlgorithmIdentifier'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SignerInfos
%%================================
enc_SignerInfos(Val) ->
    enc_SignerInfos(Val, []).

enc_SignerInfos(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      siSet ->
         'enc_SignerInfos_siSet'(element(2,Val), [<<49>>]);
      siSequence ->
         'enc_SignerInfos_siSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  SignerInfos_siSet
%%================================
enc_SignerInfos_siSet(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfos_siSet_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfos_siSet_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfos_siSet_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfo'(H, [<<48>>]),
   'enc_SignerInfos_siSet_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfos_siSequence
%%================================
enc_SignerInfos_siSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfos_siSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfos_siSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SignerInfos_siSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfo'(H, [<<48>>]),
   'enc_SignerInfos_siSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignerInfos(Tlv) ->
   dec_SignerInfos(Tlv, []).

dec_SignerInfos(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'siSet'
    {17, V1} -> 
        {siSet, 'dec_SignerInfos_siSet'(V1, [])};


%% 'siSequence'
    {16, V1} -> 
        {siSequence, 'dec_SignerInfos_siSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_SignerInfos_siSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfo'(V1, [16]) || V1 <- Tlv1].


'dec_SignerInfos_siSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SignedData
%%================================
enc_SignedData(Val) ->
    enc_SignedData(Val, [<<48>>]).

enc_SignedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{sdVer1,1},{sdVer2,2}], [<<2>>]),

%%-------------------------------------------------
%% attribute digestAlgorithms(2)   External OTP-PUB-KEY:DigestAlgorithmIdentifiers
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_DigestAlgorithmIdentifiers'(Cindex2, []),

%%-------------------------------------------------
%% attribute contentInfo(3)   External OTP-PUB-KEY:ContentInfo
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ContentInfo'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute certificates(4) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignedData_certificates'(Cindex4, [])
       end,

%%-------------------------------------------------
%% attribute crls(5) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignedData_crls'(Cindex5, [])
       end,

%%-------------------------------------------------
%% attribute signerInfos(6)   External OTP-PUB-KEY:SignerInfos
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_SignerInfos'(Cindex6, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignedData_certificates
%%================================
enc_SignedData_certificates(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      certSet ->
         'enc_ExtendedCertificatesAndCertificates'(element(2,Val), [<<160>>]);
      certSequence ->
         'enc_Certificates'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  SignedData_crls
%%================================
enc_SignedData_crls(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      crlSet ->
         'enc_CertificateRevocationLists'(element(2,Val), [<<161>>]);
      crlSequence ->
         'enc_CRLSequence'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_SignedData(Tlv) ->
   dec_SignedData(Tlv, [16]).

dec_SignedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{sdVer1,1},{sdVer2,2}])
end
,

%%-------------------------------------------------
%% attribute digestAlgorithms(2)   External OTP-PUB-KEY:DigestAlgorithmIdentifiers
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_DigestAlgorithmIdentifiers'(V2, []),

%%-------------------------------------------------
%% attribute contentInfo(3)   External OTP-PUB-KEY:ContentInfo
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ContentInfo'(V3, [16]),

%%-------------------------------------------------
%% attribute certificates(4) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[V4 = {131072,_}|TempTlv5] ->
    {'dec_SignedData_certificates'(V4, []), TempTlv5};
[V4 = {131074,_}|TempTlv5] ->
    {'dec_SignedData_certificates'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute crls(5) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[V5 = {131073,_}|TempTlv6] ->
    {'dec_SignedData_crls'(V5, []), TempTlv6};
[V5 = {131075,_}|TempTlv6] ->
    {'dec_SignedData_crls'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute signerInfos(6)   External OTP-PUB-KEY:SignerInfos
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_SignerInfos'(V6, []),

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'SignedData',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.
'dec_SignedData_certificates'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'certSet'
    {131072, V1} -> 
        {certSet, 'dec_ExtendedCertificatesAndCertificates'(V1, [])};


%% 'certSequence'
    {131074, V1} -> 
        {certSequence, 'dec_Certificates'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_SignedData_crls'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'crlSet'
    {131073, V1} -> 
        {crlSet, 'dec_CertificateRevocationLists'(V1, [])};


%% 'crlSequence'
    {131075, V1} -> 
        {crlSequence, 'dec_CRLSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Data
%%================================
enc_Data(Val) ->
    enc_Data(Val, [<<4>>]).

enc_Data(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_Data(Tlv) ->
   dec_Data(Tlv, [4]).

dec_Data(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  ContentType
%%================================
enc_ContentType(Val) ->
    enc_ContentType(Val, [<<6>>]).

enc_ContentType(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_ContentType(Tlv) ->
   dec_ContentType(Tlv, [6]).

dec_ContentType(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  ContentInfo
%%================================
enc_ContentInfo(Val) ->
    enc_ContentInfo(Val, [<<48>>]).

enc_ContentInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjcontentType = 
   'OTP-PUB-KEY':'getenc_Contents'(                                   Cindex1),

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute content(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = ObjcontentType('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ContentInfo(Tlv) ->
   dec_ContentInfo(Tlv, [16]).

dec_ContentInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute content(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjcontentTypeTerm1 =
   'OTP-PUB-KEY':'getdec_Contents'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjcontentTypeTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ContentInfo',Term1,Term2},
Res1.


%%================================
%%  KeyEncryptionAlgorithmIdentifier
%%================================
enc_KeyEncryptionAlgorithmIdentifier(Val) ->
    enc_KeyEncryptionAlgorithmIdentifier(Val, [<<48>>]).

enc_KeyEncryptionAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_9'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KeyEncryptionAlgorithmIdentifier(Tlv) ->
   dec_KeyEncryptionAlgorithmIdentifier(Tlv, [16]).

dec_KeyEncryptionAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_9'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KeyEncryptionAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  IssuerAndSerialNumber
%%================================
enc_IssuerAndSerialNumber(Val) ->
    enc_IssuerAndSerialNumber(Val, [<<48>>]).

enc_IssuerAndSerialNumber(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Name'(Cindex1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IssuerAndSerialNumber(Tlv) ->
   dec_IssuerAndSerialNumber(Tlv, [16]).

dec_IssuerAndSerialNumber(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Name'(V1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'IssuerAndSerialNumber',Term1,Term2},
Res1.


%%================================
%%  ExtendedCertificatesAndCertificates
%%================================
enc_ExtendedCertificatesAndCertificates(Val) ->
    enc_ExtendedCertificatesAndCertificates(Val, [<<49>>]).

enc_ExtendedCertificatesAndCertificates(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtendedCertificatesAndCertificates_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtendedCertificatesAndCertificates_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_ExtendedCertificatesAndCertificates_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtendedCertificateOrCertificate'(H, []),
   'enc_ExtendedCertificatesAndCertificates_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ExtendedCertificatesAndCertificates(Tlv) ->
   dec_ExtendedCertificatesAndCertificates(Tlv, [17]).

dec_ExtendedCertificatesAndCertificates(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ExtendedCertificateOrCertificate'(V1, []) || V1 <- Tlv1].




%%================================
%%  ExtendedCertificate
%%================================
enc_ExtendedCertificate(Val) ->
    enc_ExtendedCertificate(Val, [<<48>>]).

enc_ExtendedCertificate(Val, TagIn) ->
   enc_Certificate(Val, TagIn).


dec_ExtendedCertificate(Tlv) ->
   dec_ExtendedCertificate(Tlv, [16]).

dec_ExtendedCertificate(Tlv, TagIn) ->
'dec_Certificate'(Tlv, TagIn).



%%================================
%%  ExtendedCertificateOrCertificate
%%================================
enc_ExtendedCertificateOrCertificate(Val) ->
    enc_ExtendedCertificateOrCertificate(Val, []).

enc_ExtendedCertificateOrCertificate(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      certificate ->
         'enc_Certificate'(element(2,Val), [<<48>>]);
      extendedCertificate ->
         'enc_ExtendedCertificate'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_ExtendedCertificateOrCertificate(Tlv) ->
   dec_ExtendedCertificateOrCertificate(Tlv, []).

dec_ExtendedCertificateOrCertificate(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'certificate'
    {16, V1} -> 
        {certificate, 'dec_Certificate'(V1, [])};


%% 'extendedCertificate'
    {131072, V1} -> 
        {extendedCertificate, 'dec_ExtendedCertificate'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  DigestEncryptionAlgorithmIdentifier
%%================================
enc_DigestEncryptionAlgorithmIdentifier(Val) ->
    enc_DigestEncryptionAlgorithmIdentifier(Val, [<<48>>]).

enc_DigestEncryptionAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_12'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestEncryptionAlgorithmIdentifier(Tlv) ->
   dec_DigestEncryptionAlgorithmIdentifier(Tlv, [16]).

dec_DigestEncryptionAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_12'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestEncryptionAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  DigestAlgorithmIdentifier
%%================================
enc_DigestAlgorithmIdentifier(Val) ->
    enc_DigestAlgorithmIdentifier(Val, [<<48>>]).

enc_DigestAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_8'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestAlgorithmIdentifier(Tlv) ->
   dec_DigestAlgorithmIdentifier(Tlv, [16]).

dec_DigestAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_8'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  ContentEncryptionAlgorithmIdentifier
%%================================
enc_ContentEncryptionAlgorithmIdentifier(Val) ->
    enc_ContentEncryptionAlgorithmIdentifier(Val, [<<48>>]).

enc_ContentEncryptionAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_7'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ContentEncryptionAlgorithmIdentifier(Tlv) ->
   dec_ContentEncryptionAlgorithmIdentifier(Tlv, [16]).

dec_ContentEncryptionAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_7'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ContentEncryptionAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  CRLSequence
%%================================
enc_CRLSequence(Val) ->
    enc_CRLSequence(Val, [<<48>>]).

enc_CRLSequence(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CRLSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CRLSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CRLSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertificateList'(H, [<<48>>]),
   'enc_CRLSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CRLSequence(Tlv) ->
   dec_CRLSequence(Tlv, [16]).

dec_CRLSequence(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertificateList'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Certificates
%%================================
enc_Certificates(Val) ->
    enc_Certificates(Val, [<<48>>]).

enc_Certificates(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Certificates_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Certificates_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Certificates_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Certificate'(H, [<<48>>]),
   'enc_Certificates_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Certificates(Tlv) ->
   dec_Certificates(Tlv, [16]).

dec_Certificates(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Certificate'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertificateRevocationLists
%%================================
enc_CertificateRevocationLists(Val) ->
    enc_CertificateRevocationLists(Val, [<<49>>]).

enc_CertificateRevocationLists(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertificateRevocationLists_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificateRevocationLists_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_CertificateRevocationLists_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertificateList'(H, [<<48>>]),
   'enc_CertificateRevocationLists_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertificateRevocationLists(Tlv) ->
   dec_CertificateRevocationLists(Tlv, [17]).

dec_CertificateRevocationLists(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertificateList'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SignerInfoAuthenticatedAttributes
%%================================
enc_SignerInfoAuthenticatedAttributes(Val) ->
    enc_SignerInfoAuthenticatedAttributes(Val, []).

enc_SignerInfoAuthenticatedAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      aaSet ->
         'enc_SignerInfoAuthenticatedAttributes_aaSet'(element(2,Val), [<<160>>]);
      aaSequence ->
         'enc_SignerInfoAuthenticatedAttributes_aaSequence'(element(2,Val), [<<48>>,<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  SignerInfoAuthenticatedAttributes_aaSet
%%================================
enc_SignerInfoAuthenticatedAttributes_aaSet(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfoAuthenticatedAttributes_aaSet_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfoAuthenticatedAttributes_aaSet_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfoAuthenticatedAttributes_aaSet_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7'(H, [<<48>>]),
   'enc_SignerInfoAuthenticatedAttributes_aaSet_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7
%%================================
'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_10'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values
%%================================
'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values'(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfoAuthenticatedAttributes_aaSequence
%%================================
enc_SignerInfoAuthenticatedAttributes_aaSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfoAuthenticatedAttributes_aaSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfoAuthenticatedAttributes_aaSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SignerInfoAuthenticatedAttributes_aaSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7'(H, [<<48>>]),
   'enc_SignerInfoAuthenticatedAttributes_aaSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7
%%================================
'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_11'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values
%%================================
'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values'(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignerInfoAuthenticatedAttributes(Tlv) ->
   dec_SignerInfoAuthenticatedAttributes(Tlv, []).

dec_SignerInfoAuthenticatedAttributes(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'aaSet'
    {131072, V1} -> 
        {aaSet, 'dec_SignerInfoAuthenticatedAttributes_aaSet'(V1, [])};


%% 'aaSequence'
    {131074, V1} -> 
        {aaSequence, 'dec_SignerInfoAuthenticatedAttributes_aaSequence'(V1, [16])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_SignerInfoAuthenticatedAttributes_aaSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7'(V1, [16]) || V1 <- Tlv1].


'dec_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'OTP-PUB-KEY':'getdec_internal_object_set_argument_10'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributePKCS-7',Term1,Term2},
Res1.
'dec_SignerInfoAuthenticatedAttributes_aaSet_AttributePKCS-7_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'dec_SignerInfoAuthenticatedAttributes_aaSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7'(V1, [16]) || V1 <- Tlv1].


'dec_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'OTP-PUB-KEY':'getdec_internal_object_set_argument_11'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributePKCS-7',Term1,Term2},
Res1.
'dec_SignerInfoAuthenticatedAttributes_aaSequence_AttributePKCS-7_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  SigningTime
%%================================
enc_SigningTime(Val) ->
    enc_SigningTime(Val, []).

enc_SigningTime(Val, TagIn) ->
   enc_Time(Val, TagIn).


dec_SigningTime(Tlv) ->
   dec_SigningTime(Tlv, []).

dec_SigningTime(Tlv, TagIn) ->
'dec_Time'(Tlv, TagIn).



%%================================
%%  MessageDigest
%%================================
enc_MessageDigest(Val) ->
    enc_MessageDigest(Val, [<<4>>]).

enc_MessageDigest(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_MessageDigest(Tlv) ->
   dec_MessageDigest(Tlv, [4]).

dec_MessageDigest(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  CertificationRequest
%%================================
enc_CertificationRequest(Val) ->
    enc_CertificationRequest(Val, [<<48>>]).

enc_CertificationRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute certificationRequestInfo(1)   External OTP-PUB-KEY:CertificationRequestInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertificationRequestInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertificationRequest_signatureAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequest_signatureAlgorithm
%%================================
enc_CertificationRequest_signatureAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_19'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertificationRequest(Tlv) ->
   dec_CertificationRequest(Tlv, [16]).

dec_CertificationRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certificationRequestInfo(1)   External OTP-PUB-KEY:CertificationRequestInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertificationRequestInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificationRequest_signatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest',Term1,Term2,Term3},
Res1.
'dec_CertificationRequest_signatureAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_19'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest_signatureAlgorithm',Term1,Term2},
Res1.


%%================================
%%  CertificationRequestInfo
%%================================
enc_CertificationRequestInfo(Val) ->
    enc_CertificationRequestInfo(Val, [<<48>>]).

enc_CertificationRequestInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v1,0}], [<<2>>]),

%%-------------------------------------------------
%% attribute subject(2)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Name'(Cindex2, []),

%%-------------------------------------------------
%% attribute subjectPKInfo(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_CertificationRequestInfo_subjectPKInfo'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(4) with type SET OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_CertificationRequestInfo_attributes'(Cindex4, [<<160>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequestInfo_subjectPKInfo
%%================================
enc_CertificationRequestInfo_subjectPKInfo(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertificationRequestInfo_subjectPKInfo_algorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequestInfo_subjectPKInfo_algorithm
%%================================
enc_CertificationRequestInfo_subjectPKInfo_algorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_16'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequestInfo_attributes
%%================================
enc_CertificationRequestInfo_attributes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CertificationRequestInfo_attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificationRequestInfo_attributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_CertificationRequestInfo_attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertificationRequestInfo_attributes_AttributePKCS-10'(H, [<<48>>]),
   'enc_CertificationRequestInfo_attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CertificationRequestInfo_attributes_AttributePKCS-10
%%================================
'enc_CertificationRequestInfo_attributes_AttributePKCS-10'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PUB-KEY':'getenc_internal_object_set_argument_18'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertificationRequestInfo_attributes_AttributePKCS-10_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequestInfo_attributes_AttributePKCS-10_values
%%================================
'enc_CertificationRequestInfo_attributes_AttributePKCS-10_values'(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_CertificationRequestInfo_attributes_AttributePKCS-10_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificationRequestInfo_attributes_AttributePKCS-10_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_CertificationRequestInfo_attributes_AttributePKCS-10_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_CertificationRequestInfo_attributes_AttributePKCS-10_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertificationRequestInfo(Tlv) ->
   dec_CertificationRequestInfo(Tlv, [16]).

dec_CertificationRequestInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0}])
end
,

%%-------------------------------------------------
%% attribute subject(2)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Name'(V2, []),

%%-------------------------------------------------
%% attribute subjectPKInfo(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_CertificationRequestInfo_subjectPKInfo'(V3, [16]),

%%-------------------------------------------------
%% attribute attributes(4) with type SET OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_CertificationRequestInfo_attributes'(V4, [131072]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequestInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_CertificationRequestInfo_subjectPKInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertificationRequestInfo_subjectPKInfo_algorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequestInfo_subjectPKInfo',Term1,Term2},
Res1.
'dec_CertificationRequestInfo_subjectPKInfo_algorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_internal_object_set_argument_16'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequestInfo_subjectPKInfo_algorithm',Term1,Term2},
Res1.
'dec_CertificationRequestInfo_attributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertificationRequestInfo_attributes_AttributePKCS-10'(V1, [16]) || V1 <- Tlv1].


'dec_CertificationRequestInfo_attributes_AttributePKCS-10'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'OTP-PUB-KEY':'getdec_internal_object_set_argument_18'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificationRequestInfo_attributes_AttributePKCS-10_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributePKCS-10',Term1,Term2},
Res1.
'dec_CertificationRequestInfo_attributes_AttributePKCS-10_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  ExtensionRequest
%%================================
enc_ExtensionRequest(Val) ->
    enc_ExtensionRequest(Val, [<<48>>]).

enc_ExtensionRequest(Val, TagIn) ->
   enc_Extensions(Val, TagIn).


dec_ExtensionRequest(Tlv) ->
   dec_ExtensionRequest(Tlv, [16]).

dec_ExtensionRequest(Tlv, TagIn) ->
'dec_Extensions'(Tlv, TagIn).



%%================================
%%  AES-IV
%%================================
'enc_AES-IV'(Val) ->
    'enc_AES-IV'(Val, [<<4>>]).

'enc_AES-IV'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_AES-IV'(Tlv) ->
   'dec_AES-IV'(Tlv, [4]).

'dec_AES-IV'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 16 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  Nonce
%%================================
enc_Nonce(Val) ->
    enc_Nonce(Val, [<<4>>]).

enc_Nonce(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_Nonce(Tlv) ->
   dec_Nonce(Tlv, [4]).

dec_Nonce(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  PreferredSignatureAlgorithm
%%================================
enc_PreferredSignatureAlgorithm(Val) ->
    enc_PreferredSignatureAlgorithm(Val, [<<48>>]).

enc_PreferredSignatureAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute sigIdentifier(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AlgorithmIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certIdentifier(2)   External OTP-PUB-KEY:AlgorithmIdentifier OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AlgorithmIdentifier'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PreferredSignatureAlgorithm(Tlv) ->
   dec_PreferredSignatureAlgorithm(Tlv, [16]).

dec_PreferredSignatureAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute sigIdentifier(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AlgorithmIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute certIdentifier(2)   External OTP-PUB-KEY:AlgorithmIdentifier OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_AlgorithmIdentifier'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PreferredSignatureAlgorithm',Term1,Term2},
Res1.


%%================================
%%  PreferredSignatureAlgorithms
%%================================
enc_PreferredSignatureAlgorithms(Val) ->
    enc_PreferredSignatureAlgorithms(Val, [<<48>>]).

enc_PreferredSignatureAlgorithms(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PreferredSignatureAlgorithms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PreferredSignatureAlgorithms_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PreferredSignatureAlgorithms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PreferredSignatureAlgorithm'(H, [<<48>>]),
   'enc_PreferredSignatureAlgorithms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PreferredSignatureAlgorithms(Tlv) ->
   dec_PreferredSignatureAlgorithms(Tlv, [16]).

dec_PreferredSignatureAlgorithms(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PreferredSignatureAlgorithm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CrlID
%%================================
enc_CrlID(Val) ->
    enc_CrlID(Val, [<<48>>]).

enc_CrlID(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute crlUrl(1) with type IA5String OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<22>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute crlNum(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<2>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute crlTime(3) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<24>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CrlID(Tlv) ->
   dec_CrlID(Tlv, [16]).

dec_CrlID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute crlUrl(1) with type IA5String OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, [22]))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute crlNum(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_integer(V2, [2]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute crlTime(3) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
binary_to_list(decode_restricted_string(V3, [24]))
end
, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CrlID',Term1,Term2,Term3},
Res1.


%%================================
%%  ServiceLocator
%%================================
enc_ServiceLocator(Val) ->
    enc_ServiceLocator(Val, [<<48>>]).

enc_ServiceLocator(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Name'(Cindex1, []),

%%-------------------------------------------------
%% attribute locator(2)   External OTP-PUB-KEY:AuthorityInfoAccessSyntax
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AuthorityInfoAccessSyntax'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ServiceLocator(Tlv) ->
   dec_ServiceLocator(Tlv, [16]).

dec_ServiceLocator(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Name'(V1, []),

%%-------------------------------------------------
%% attribute locator(2)   External OTP-PUB-KEY:AuthorityInfoAccessSyntax
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AuthorityInfoAccessSyntax'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ServiceLocator',Term1,Term2},
Res1.


%%================================
%%  AcceptableResponses
%%================================
enc_AcceptableResponses(Val) ->
    enc_AcceptableResponses(Val, [<<48>>]).

enc_AcceptableResponses(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AcceptableResponses_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AcceptableResponses_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AcceptableResponses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_object_identifier(H, [<<6>>]),
   'enc_AcceptableResponses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AcceptableResponses(Tlv) ->
   dec_AcceptableResponses(Tlv, [16]).

dec_AcceptableResponses(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_object_identifier(V1, [6]) || V1 <- Tlv1].




%%================================
%%  ArchiveCutoff
%%================================
enc_ArchiveCutoff(Val) ->
    enc_ArchiveCutoff(Val, [<<24>>]).

enc_ArchiveCutoff(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_ArchiveCutoff(Tlv) ->
   dec_ArchiveCutoff(Tlv, [24]).

dec_ArchiveCutoff(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  UnknownInfo
%%================================
enc_UnknownInfo(Val) ->
    enc_UnknownInfo(Val, [<<5>>]).

enc_UnknownInfo(Val, TagIn) ->
encode_null(Val, TagIn).


dec_UnknownInfo(Tlv) ->
   dec_UnknownInfo(Tlv, [5]).

dec_UnknownInfo(Tlv, TagIn) ->
decode_null(Tlv, TagIn).



%%================================
%%  RevokedInfo
%%================================
enc_RevokedInfo(Val) ->
    enc_RevokedInfo(Val, [<<48>>]).

enc_RevokedInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute revocationTime(1) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<24>>]),

%%-------------------------------------------------
%% attribute revocationReason(2) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            case Cindex2 of
unspecified -> encode_tags([<<10>>,<<160>>], [0], 1);
keyCompromise -> encode_tags([<<10>>,<<160>>], [1], 1);
cACompromise -> encode_tags([<<10>>,<<160>>], [2], 1);
affiliationChanged -> encode_tags([<<10>>,<<160>>], [3], 1);
superseded -> encode_tags([<<10>>,<<160>>], [4], 1);
cessationOfOperation -> encode_tags([<<10>>,<<160>>], [5], 1);
certificateHold -> encode_tags([<<10>>,<<160>>], [6], 1);
removeFromCRL -> encode_tags([<<10>>,<<160>>], [8], 1);
privilegeWithdrawn -> encode_tags([<<10>>,<<160>>], [9], 1);
aACompromise -> encode_tags([<<10>>,<<160>>], [10], 1);
Enumval2 -> exit({error,{asn1, {enumerated_not_in_range,Enumval2}}})
end
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RevokedInfo(Tlv) ->
   dec_RevokedInfo(Tlv, [16]).

dec_RevokedInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute revocationTime(1) with type GeneralizedTime
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [24]))
end
,

%%-------------------------------------------------
%% attribute revocationReason(2) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {case decode_integer(V2, [10]) of
0 -> unspecified;
1 -> keyCompromise;
2 -> cACompromise;
3 -> affiliationChanged;
4 -> superseded;
5 -> cessationOfOperation;
6 -> certificateHold;
8 -> removeFromCRL;
9 -> privilegeWithdrawn;
10 -> aACompromise;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RevokedInfo',Term1,Term2},
Res1.


%%================================
%%  CertStatus
%%================================
enc_CertStatus(Val) ->
    enc_CertStatus(Val, []).

enc_CertStatus(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      good ->
         encode_null(element(2,Val), [<<128>>]);
      revoked ->
         'enc_RevokedInfo'(element(2,Val), [<<161>>]);
      unknown ->
         encode_null(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CertStatus(Tlv) ->
   dec_CertStatus(Tlv, []).

dec_CertStatus(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'good'
    {131072, V1} -> 
        {good, decode_null(V1, [])};


%% 'revoked'
    {131073, V1} -> 
        {revoked, 'dec_RevokedInfo'(V1, [])};


%% 'unknown'
    {131074, V1} -> 
        {unknown, decode_null(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  SingleResponse
%%================================
enc_SingleResponse(Val) ->
    enc_SingleResponse(Val, [<<48>>]).

enc_SingleResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute certID(1)   External OTP-PUB-KEY:CertID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertID'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certStatus(2)   External OTP-PUB-KEY:CertStatus
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertStatus'(Cindex2, []),

%%-------------------------------------------------
%% attribute thisUpdate(3) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<24>>]),

%%-------------------------------------------------
%% attribute nextUpdate(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<24>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute singleExtensions(5)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex5, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SingleResponse(Tlv) ->
   dec_SingleResponse(Tlv, [16]).

dec_SingleResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certID(1)   External OTP-PUB-KEY:CertID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertID'(V1, [16]),

%%-------------------------------------------------
%% attribute certStatus(2)   External OTP-PUB-KEY:CertStatus
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertStatus'(V2, []),

%%-------------------------------------------------
%% attribute thisUpdate(3) with type GeneralizedTime
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [24]))
end
,

%%-------------------------------------------------
%% attribute nextUpdate(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {begin
binary_to_list(decode_restricted_string(V4, [24]))
end
, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute singleExtensions(5)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_Extensions'(V5, [16]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'SingleResponse',Term1,Term2,Term3,Term4,Term5},
Res1.


%%================================
%%  KeyHash
%%================================
enc_KeyHash(Val) ->
    enc_KeyHash(Val, [<<4>>]).

enc_KeyHash(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_KeyHash(Tlv) ->
   dec_KeyHash(Tlv, [4]).

dec_KeyHash(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  ResponderID
%%================================
enc_ResponderID(Val) ->
    enc_ResponderID(Val, []).

enc_ResponderID(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      byName ->
         'enc_Name'(element(2,Val), [<<161>>]);
      byKey ->
         encode_restricted_string(element(2,Val), [<<4>>,<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_ResponderID(Tlv) ->
   dec_ResponderID(Tlv, []).

dec_ResponderID(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'byName'
    {131073, V1} -> 
        {byName, 'dec_Name'(V1, [])};


%% 'byKey'
    {131074, V1} -> 
        {byKey, decode_octet_string(V1, [4])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ResponseData
%%================================
enc_ResponseData(Val) ->
    enc_ResponseData(Val, [<<48>>]).

enc_ResponseData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_16(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute responderID(2)   External OTP-PUB-KEY:ResponderID
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ResponderID'(Cindex2, []),

%%-------------------------------------------------
%% attribute producedAt(3) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<24>>]),

%%-------------------------------------------------
%% attribute responses(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_ResponseData_responses'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute responseExtensions(5)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex5, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ResponseData_responses
%%================================
enc_ResponseData_responses(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ResponseData_responses_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ResponseData_responses_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ResponseData_responses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SingleResponse'(H, [<<48>>]),
   'enc_ResponseData_responses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ResponseData(Tlv) ->
   dec_ResponseData(Tlv, [16]).

dec_ResponseData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute responderID(2)   External OTP-PUB-KEY:ResponderID
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ResponderID'(V2, []),

%%-------------------------------------------------
%% attribute producedAt(3) with type GeneralizedTime
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [24]))
end
,

%%-------------------------------------------------
%% attribute responses(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_ResponseData_responses'(V4, [16]),

%%-------------------------------------------------
%% attribute responseExtensions(5)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_Extensions'(V5, [16]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'ResponseData',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_ResponseData_responses'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SingleResponse'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  BasicOCSPResponse
%%================================
enc_BasicOCSPResponse(Val) ->
    enc_BasicOCSPResponse(Val, [<<48>>]).

enc_BasicOCSPResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute tbsResponseData(1)   External OTP-PUB-KEY:ResponseData
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_ResponseData'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

%%-------------------------------------------------
%% attribute certs(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_BasicOCSPResponse_certs'(Cindex4, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  BasicOCSPResponse_certs
%%================================
enc_BasicOCSPResponse_certs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_BasicOCSPResponse_certs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_BasicOCSPResponse_certs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BasicOCSPResponse_certs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Certificate'(H, [<<48>>]),
   'enc_BasicOCSPResponse_certs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_BasicOCSPResponse(Tlv) ->
   dec_BasicOCSPResponse(Tlv, [16]).

dec_BasicOCSPResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsResponseData(1)   External OTP-PUB-KEY:ResponseData
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_ResponseData'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

%%-------------------------------------------------
%% attribute certs(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_BasicOCSPResponse_certs'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'BasicOCSPResponse',Term1,Term2,Term3,Term4},
Res1.
'dec_BasicOCSPResponse_certs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Certificate'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ResponseBytes
%%================================
enc_ResponseBytes(Val) ->
    enc_ResponseBytes(Val, [<<48>>]).

enc_ResponseBytes(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute responseType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute response(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ResponseBytes(Tlv) ->
   dec_ResponseBytes(Tlv, [16]).

dec_ResponseBytes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute responseType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute response(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ResponseBytes',Term1,Term2},
Res1.


%%================================
%%  OCSPResponseStatus
%%================================
enc_OCSPResponseStatus(Val) ->
    enc_OCSPResponseStatus(Val, [<<10>>]).

enc_OCSPResponseStatus(Val, TagIn) ->
case Val of
successful -> encode_tags(TagIn, [0], 1);
malformedRequest -> encode_tags(TagIn, [1], 1);
internalError -> encode_tags(TagIn, [2], 1);
tryLater -> encode_tags(TagIn, [3], 1);
sigRequired -> encode_tags(TagIn, [5], 1);
unauthorized -> encode_tags(TagIn, [6], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


dec_OCSPResponseStatus(Tlv) ->
   dec_OCSPResponseStatus(Tlv, [10]).

dec_OCSPResponseStatus(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> successful;
1 -> malformedRequest;
2 -> internalError;
3 -> tryLater;
5 -> sigRequired;
6 -> unauthorized;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end.



%%================================
%%  OCSPResponse
%%================================
enc_OCSPResponse(Val) ->
    enc_OCSPResponse(Val, [<<48>>]).

enc_OCSPResponse(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute responseStatus(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
successful -> encode_tags([<<10>>], [0], 1);
malformedRequest -> encode_tags([<<10>>], [1], 1);
internalError -> encode_tags([<<10>>], [2], 1);
tryLater -> encode_tags([<<10>>], [3], 1);
sigRequired -> encode_tags([<<10>>], [5], 1);
unauthorized -> encode_tags([<<10>>], [6], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute responseBytes(2)   External OTP-PUB-KEY:ResponseBytes OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ResponseBytes'(Cindex2, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OCSPResponse(Tlv) ->
   dec_OCSPResponse(Tlv, [16]).

dec_OCSPResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute responseStatus(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> successful;
1 -> malformedRequest;
2 -> internalError;
3 -> tryLater;
5 -> sigRequired;
6 -> unauthorized;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end,

%%-------------------------------------------------
%% attribute responseBytes(2)   External OTP-PUB-KEY:ResponseBytes OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_ResponseBytes'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OCSPResponse',Term1,Term2},
Res1.


%%================================
%%  CertID
%%================================
enc_CertID(Val) ->
    enc_CertID(Val, [<<48>>]).

enc_CertID(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AlgorithmIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerNameHash(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute issuerKeyHash(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute serialNumber(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertID(Tlv) ->
   dec_CertID(Tlv, [16]).

dec_CertID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AlgorithmIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute issuerNameHash(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

%%-------------------------------------------------
%% attribute issuerKeyHash(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

%%-------------------------------------------------
%% attribute serialNumber(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_integer(V4, [2]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CertID',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  Request
%%================================
enc_Request(Val) ->
    enc_Request(Val, [<<48>>]).

enc_Request(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute reqCert(1)   External OTP-PUB-KEY:CertID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertID'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute singleRequestExtensions(2)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex2, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Request(Tlv) ->
   dec_Request(Tlv, [16]).

dec_Request(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute reqCert(1)   External OTP-PUB-KEY:CertID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertID'(V1, [16]),

%%-------------------------------------------------
%% attribute singleRequestExtensions(2)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_Extensions'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Request',Term1,Term2},
Res1.


%%================================
%%  VersionOCSP-2013-88
%%================================
'enc_VersionOCSP-2013-88'(Val) ->
    'enc_VersionOCSP-2013-88'(Val, [<<2>>]).

'enc_VersionOCSP-2013-88'(Val, TagIn) ->
encode_integer(Val, [{v1,0}], TagIn).


'dec_VersionOCSP-2013-88'(Tlv) ->
   'dec_VersionOCSP-2013-88'(Tlv, [2]).

'dec_VersionOCSP-2013-88'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v1,0}])
end
.



%%================================
%%  Signature
%%================================
enc_Signature(Val) ->
    enc_Signature(Val, [<<48>>]).

enc_Signature(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute signatureAlgorithm(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AlgorithmIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

%%-------------------------------------------------
%% attribute certs(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Signature_certs'(Cindex3, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Signature_certs
%%================================
enc_Signature_certs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Signature_certs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Signature_certs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Signature_certs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Certificate'(H, [<<48>>]),
   'enc_Signature_certs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Signature(Tlv) ->
   dec_Signature(Tlv, [16]).

dec_Signature(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute signatureAlgorithm(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AlgorithmIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute signature(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

%%-------------------------------------------------
%% attribute certs(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {'dec_Signature_certs'(V3, [16]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Signature',Term1,Term2,Term3},
Res1.
'dec_Signature_certs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Certificate'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TBSRequest
%%================================
enc_TBSRequest(Val) ->
    enc_TBSRequest(Val, [<<48>>]).

enc_TBSRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_16(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute requestorName(2)   External OTP-PUB-KEY:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralName'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute requestList(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_TBSRequest_requestList'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute requestExtensions(4)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex4, [<<48>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSRequest_requestList
%%================================
enc_TBSRequest_requestList(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSRequest_requestList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSRequest_requestList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSRequest_requestList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Request'(H, [<<48>>]),
   'enc_TBSRequest_requestList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_TBSRequest(Tlv) ->
   dec_TBSRequest(Tlv, [16]).

dec_TBSRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute requestorName(2)   External OTP-PUB-KEY:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute requestList(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_TBSRequest_requestList'(V3, [16]),

%%-------------------------------------------------
%% attribute requestExtensions(4)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131074,V4}|TempTlv5] ->
    {'dec_Extensions'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'TBSRequest',Term1,Term2,Term3,Term4},
Res1.
'dec_TBSRequest_requestList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Request'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OCSPRequest
%%================================
enc_OCSPRequest(Val) ->
    enc_OCSPRequest(Val, [<<48>>]).

enc_OCSPRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute tbsRequest(1)   External OTP-PUB-KEY:TBSRequest
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSRequest'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute optionalSignature(2)   External OTP-PUB-KEY:Signature OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Signature'(Cindex2, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OCSPRequest(Tlv) ->
   dec_OCSPRequest(Tlv, [16]).

dec_OCSPRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsRequest(1)   External OTP-PUB-KEY:TBSRequest
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSRequest'(V1, [16]),

%%-------------------------------------------------
%% attribute optionalSignature(2)   External OTP-PUB-KEY:Signature OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_Signature'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OCSPRequest',Term1,Term2},
Res1.


%%================================
%%  TeletexDomainDefinedAttribute
%%================================
enc_TeletexDomainDefinedAttribute(Val) ->
    enc_TeletexDomainDefinedAttribute(Val, [<<48>>]).

enc_TeletexDomainDefinedAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type TeletexString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<20>>]),

%%-------------------------------------------------
%% attribute value(2) with type TeletexString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<20>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TeletexDomainDefinedAttribute(Tlv) ->
   dec_TeletexDomainDefinedAttribute(Tlv, [16]).

dec_TeletexDomainDefinedAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type TeletexString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [20]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2) with type TeletexString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [20]),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'TeletexDomainDefinedAttribute',Term1,Term2},
Res1.


%%================================
%%  TeletexDomainDefinedAttributes
%%================================
enc_TeletexDomainDefinedAttributes(Val) ->
    enc_TeletexDomainDefinedAttributes(Val, [<<48>>]).

enc_TeletexDomainDefinedAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TeletexDomainDefinedAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TeletexDomainDefinedAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TeletexDomainDefinedAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TeletexDomainDefinedAttribute'(H, [<<48>>]),
   'enc_TeletexDomainDefinedAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_TeletexDomainDefinedAttributes(Tlv) ->
   dec_TeletexDomainDefinedAttributes(Tlv, [16]).

dec_TeletexDomainDefinedAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TeletexDomainDefinedAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TerminalType
%%================================
enc_TerminalType(Val) ->
    enc_TerminalType(Val, [<<2>>]).

enc_TerminalType(Val, TagIn) ->
encode_integer(Val, [{telex,3},{teletex,4},{'g3-facsimile',5},{'g4-facsimile',6},{'ia5-terminal',7},{videotex,8}], TagIn).


dec_TerminalType(Tlv) ->
   dec_TerminalType(Tlv, [2]).

dec_TerminalType(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 256 ->
Val2 = Val1,
number2name(Val2, [{telex,3},{teletex,4},{'g3-facsimile',5},{'g4-facsimile',6},{'ia5-terminal',7},{videotex,8}]);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PresentationAddress
%%================================
enc_PresentationAddress(Val) ->
    enc_PresentationAddress(Val, [<<48>>]).

enc_PresentationAddress(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute pSelector(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<4>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute sSelector(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<4>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute tSelector(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute nAddresses(4) with type SET OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_PresentationAddress_nAddresses'(Cindex4, [<<49>>,<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PresentationAddress_nAddresses
%%================================
enc_PresentationAddress_nAddresses(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PresentationAddress_nAddresses_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PresentationAddress_nAddresses_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_PresentationAddress_nAddresses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_PresentationAddress_nAddresses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PresentationAddress(Tlv) ->
   dec_PresentationAddress(Tlv, [16]).

dec_PresentationAddress(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pSelector(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_octet_string(V1, [4]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute sSelector(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_octet_string(V2, [4]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute tSelector(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_octet_string(V3, [4]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute nAddresses(4) with type SET OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_PresentationAddress_nAddresses'(V4, [131075,17]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PresentationAddress',Term1,Term2,Term3,Term4},
Res1.
'dec_PresentationAddress_nAddresses'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_octet_string(V1, [4]) || V1 <- Tlv1].




%%================================
%%  ExtendedNetworkAddress
%%================================
enc_ExtendedNetworkAddress(Val) ->
    enc_ExtendedNetworkAddress(Val, []).

enc_ExtendedNetworkAddress(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'e163-4-address' ->
         'enc_ExtendedNetworkAddress_e163-4-address'(element(2,Val), [<<48>>]);
      'psap-address' ->
         'enc_PresentationAddress'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  ExtendedNetworkAddress_e163-4-address
%%================================
'enc_ExtendedNetworkAddress_e163-4-address'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute number(1) with type NumericString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute sub-address(2) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtendedNetworkAddress(Tlv) ->
   dec_ExtendedNetworkAddress(Tlv, []).

dec_ExtendedNetworkAddress(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'e163-4-address'
    {16, V1} -> 
        {'e163-4-address', 'dec_ExtendedNetworkAddress_e163-4-address'(V1, [])};


%% 'psap-address'
    {131072, V1} -> 
        {'psap-address', 'dec_PresentationAddress'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_ExtendedNetworkAddress_e163-4-address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute number(1) with type NumericString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 15 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute sub-address(2) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 40 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ExtendedNetworkAddress_e163-4-address',Term1,Term2},
Res1.


%%================================
%%  PDSParameter
%%================================
enc_PDSParameter(Val) ->
    enc_PDSParameter(Val, [<<49>>]).

enc_PDSParameter(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute printable-string(1) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<19>>])
       end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<20>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PDSParameter(Tlv) ->
   dec_PDSParameter(Tlv, [17]).

dec_PDSParameter(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %printable-string
TTlv = {19,_} ->
    {1, TTlv};
      %teletex-string
TTlv = {20,_} ->
    {2, TTlv};
      Else -> 
         {3, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute printable-string(1) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term1,Tlv3} = case Tlv2 of
[{19,V1}|TempTlv3] ->
    {begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 30 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{20,V2}|TempTlv4] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 30 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PDSParameter',Term1,Term2},
Res1.


%%================================
%%  LocalPostalAttributes
%%================================
enc_LocalPostalAttributes(Val) ->
    enc_LocalPostalAttributes(Val, [<<49>>]).

enc_LocalPostalAttributes(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_LocalPostalAttributes(Tlv) ->
   dec_LocalPostalAttributes(Tlv, [17]).

dec_LocalPostalAttributes(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  UniquePostalName
%%================================
enc_UniquePostalName(Val) ->
    enc_UniquePostalName(Val, [<<49>>]).

enc_UniquePostalName(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_UniquePostalName(Tlv) ->
   dec_UniquePostalName(Tlv, [17]).

dec_UniquePostalName(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PosteRestanteAddress
%%================================
enc_PosteRestanteAddress(Val) ->
    enc_PosteRestanteAddress(Val, [<<49>>]).

enc_PosteRestanteAddress(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_PosteRestanteAddress(Tlv) ->
   dec_PosteRestanteAddress(Tlv, [17]).

dec_PosteRestanteAddress(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PostOfficeBoxAddress
%%================================
enc_PostOfficeBoxAddress(Val) ->
    enc_PostOfficeBoxAddress(Val, [<<49>>]).

enc_PostOfficeBoxAddress(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_PostOfficeBoxAddress(Tlv) ->
   dec_PostOfficeBoxAddress(Tlv, [17]).

dec_PostOfficeBoxAddress(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  StreetAddress
%%================================
enc_StreetAddress(Val) ->
    enc_StreetAddress(Val, [<<49>>]).

enc_StreetAddress(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_StreetAddress(Tlv) ->
   dec_StreetAddress(Tlv, [17]).

dec_StreetAddress(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  UnformattedPostalAddress
%%================================
enc_UnformattedPostalAddress(Val) ->
    enc_UnformattedPostalAddress(Val, [<<49>>]).

enc_UnformattedPostalAddress(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute printable-address(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_UnformattedPostalAddress_printable-address'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<20>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  UnformattedPostalAddress_printable-address
%%================================
'enc_UnformattedPostalAddress_printable-address'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_UnformattedPostalAddress_printable-address_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_UnformattedPostalAddress_printable-address_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_UnformattedPostalAddress_printable-address_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<19>>]),
   'enc_UnformattedPostalAddress_printable-address_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_UnformattedPostalAddress(Tlv) ->
   dec_UnformattedPostalAddress(Tlv, [17]).

dec_UnformattedPostalAddress(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %printable-address
TTlv = {16,_} ->
    {1, TTlv};
      %teletex-string
TTlv = {20,_} ->
    {2, TTlv};
      Else -> 
         {3, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute printable-address(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term1,Tlv3} = case Tlv2 of
[{16,V1}|TempTlv3] ->
    {'dec_UnformattedPostalAddress_printable-address'(V1, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{20,V2}|TempTlv4] ->
    {begin
Val1 = decode_restricted_string(V2, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 180 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'UnformattedPostalAddress',Term1,Term2},
Res1.
'dec_UnformattedPostalAddress_printable-address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 30 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  ExtensionPhysicalDeliveryAddressComponents
%%================================
enc_ExtensionPhysicalDeliveryAddressComponents(Val) ->
    enc_ExtensionPhysicalDeliveryAddressComponents(Val, [<<49>>]).

enc_ExtensionPhysicalDeliveryAddressComponents(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_ExtensionPhysicalDeliveryAddressComponents(Tlv) ->
   dec_ExtensionPhysicalDeliveryAddressComponents(Tlv, [17]).

dec_ExtensionPhysicalDeliveryAddressComponents(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryOrganizationName
%%================================
enc_PhysicalDeliveryOrganizationName(Val) ->
    enc_PhysicalDeliveryOrganizationName(Val, [<<49>>]).

enc_PhysicalDeliveryOrganizationName(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_PhysicalDeliveryOrganizationName(Tlv) ->
   dec_PhysicalDeliveryOrganizationName(Tlv, [17]).

dec_PhysicalDeliveryOrganizationName(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryPersonalName
%%================================
enc_PhysicalDeliveryPersonalName(Val) ->
    enc_PhysicalDeliveryPersonalName(Val, [<<49>>]).

enc_PhysicalDeliveryPersonalName(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_PhysicalDeliveryPersonalName(Tlv) ->
   dec_PhysicalDeliveryPersonalName(Tlv, [17]).

dec_PhysicalDeliveryPersonalName(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  ExtensionORAddressComponents
%%================================
enc_ExtensionORAddressComponents(Val) ->
    enc_ExtensionORAddressComponents(Val, [<<49>>]).

enc_ExtensionORAddressComponents(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_ExtensionORAddressComponents(Tlv) ->
   dec_ExtensionORAddressComponents(Tlv, [17]).

dec_ExtensionORAddressComponents(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryOfficeNumber
%%================================
enc_PhysicalDeliveryOfficeNumber(Val) ->
    enc_PhysicalDeliveryOfficeNumber(Val, [<<49>>]).

enc_PhysicalDeliveryOfficeNumber(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_PhysicalDeliveryOfficeNumber(Tlv) ->
   dec_PhysicalDeliveryOfficeNumber(Tlv, [17]).

dec_PhysicalDeliveryOfficeNumber(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryOfficeName
%%================================
enc_PhysicalDeliveryOfficeName(Val) ->
    enc_PhysicalDeliveryOfficeName(Val, [<<49>>]).

enc_PhysicalDeliveryOfficeName(Val, TagIn) ->
   enc_PDSParameter(Val, TagIn).


dec_PhysicalDeliveryOfficeName(Tlv) ->
   dec_PhysicalDeliveryOfficeName(Tlv, [17]).

dec_PhysicalDeliveryOfficeName(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PostalCode
%%================================
enc_PostalCode(Val) ->
    enc_PostalCode(Val, []).

enc_PostalCode(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'numeric-code' ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      'printable-code' ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_PostalCode(Tlv) ->
   dec_PostalCode(Tlv, []).

dec_PostalCode(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric-code'
    {18, V1} -> 
        {'numeric-code', begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printable-code'
    {19, V1} -> 
        {'printable-code', begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PhysicalDeliveryCountryName
%%================================
enc_PhysicalDeliveryCountryName(Val) ->
    enc_PhysicalDeliveryCountryName(Val, []).

enc_PhysicalDeliveryCountryName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'x121-dcc-code' ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      'iso-3166-alpha2-code' ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_PhysicalDeliveryCountryName(Tlv) ->
   dec_PhysicalDeliveryCountryName(Tlv, []).

dec_PhysicalDeliveryCountryName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x121-dcc-code'
    {18, V1} -> 
        {'x121-dcc-code', begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 3 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'iso-3166-alpha2-code'
    {19, V1} -> 
        {'iso-3166-alpha2-code', begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 2 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PDSName
%%================================
enc_PDSName(Val) ->
    enc_PDSName(Val, [<<19>>]).

enc_PDSName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_PDSName(Tlv) ->
   dec_PDSName(Tlv, [19]).

dec_PDSName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  TeletexOrganizationalUnitName
%%================================
enc_TeletexOrganizationalUnitName(Val) ->
    enc_TeletexOrganizationalUnitName(Val, [<<20>>]).

enc_TeletexOrganizationalUnitName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_TeletexOrganizationalUnitName(Tlv) ->
   dec_TeletexOrganizationalUnitName(Tlv, [20]).

dec_TeletexOrganizationalUnitName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  TeletexOrganizationalUnitNames
%%================================
enc_TeletexOrganizationalUnitNames(Val) ->
    enc_TeletexOrganizationalUnitNames(Val, [<<48>>]).

enc_TeletexOrganizationalUnitNames(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TeletexOrganizationalUnitNames_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TeletexOrganizationalUnitNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TeletexOrganizationalUnitNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<20>>]),
   'enc_TeletexOrganizationalUnitNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_TeletexOrganizationalUnitNames(Tlv) ->
   dec_TeletexOrganizationalUnitNames(Tlv, [16]).

dec_TeletexOrganizationalUnitNames(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [20]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  TeletexPersonalName
%%================================
enc_TeletexPersonalName(Val) ->
    enc_TeletexPersonalName(Val, [<<49>>]).

enc_TeletexPersonalName(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute surname(1) with type TeletexString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute given-name(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute initials(3) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TeletexPersonalName(Tlv) ->
   dec_TeletexPersonalName(Tlv, [17]).

dec_TeletexPersonalName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %surname
TTlv = {131072,_} ->
    {1, TTlv};
      %given-name
TTlv = {131073,_} ->
    {2, TTlv};
      %initials
TTlv = {131074,_} ->
    {3, TTlv};
      %generation-qualifier
TTlv = {131075,_} ->
    {4, TTlv};
      Else -> 
         {5, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute surname(1) with type TeletexString
%%-------------------------------------------------
[V1|Tlv3] = Tlv2, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 40 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute given-name(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{131073,V2}|TempTlv4] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute initials(3) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv5} = case Tlv4 of
[{131074,V3}|TempTlv5] ->
    {begin
Val3 = decode_restricted_string(V3, []),
C3 = byte_size(Val3),
if 1 =< C3, C3 =< 5 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv6} = case Tlv5 of
[{131075,V4}|TempTlv6] ->
    {begin
Val4 = decode_restricted_string(V4, []),
C4 = byte_size(Val4),
if 1 =< C4, C4 =< 3 ->
binary_to_list(Val4);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'TeletexPersonalName',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  TeletexOrganizationName
%%================================
enc_TeletexOrganizationName(Val) ->
    enc_TeletexOrganizationName(Val, [<<20>>]).

enc_TeletexOrganizationName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_TeletexOrganizationName(Tlv) ->
   dec_TeletexOrganizationName(Tlv, [20]).

dec_TeletexOrganizationName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  TeletexCommonName
%%================================
enc_TeletexCommonName(Val) ->
    enc_TeletexCommonName(Val, [<<20>>]).

enc_TeletexCommonName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_TeletexCommonName(Tlv) ->
   dec_TeletexCommonName(Tlv, [20]).

dec_TeletexCommonName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  CommonName
%%================================
enc_CommonName(Val) ->
    enc_CommonName(Val, [<<19>>]).

enc_CommonName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CommonName(Tlv) ->
   dec_CommonName(Tlv, [19]).

dec_CommonName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ExtensionAttribute
%%================================
enc_ExtensionAttribute(Val) ->
    enc_ExtensionAttribute(Val, [<<48>>]).

enc_ExtensionAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute extension-attribute-type(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute extension-attribute-value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtensionAttribute(Tlv) ->
   dec_ExtensionAttribute(Tlv, [16]).

dec_ExtensionAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extension-attribute-type(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 256 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute extension-attribute-value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ExtensionAttribute',Term1,Term2},
Res1.


%%================================
%%  ExtensionAttributes
%%================================
enc_ExtensionAttributes(Val) ->
    enc_ExtensionAttributes(Val, [<<49>>]).

enc_ExtensionAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtensionAttributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_ExtensionAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttribute'(H, [<<48>>]),
   'enc_ExtensionAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ExtensionAttributes(Tlv) ->
   dec_ExtensionAttributes(Tlv, [17]).

dec_ExtensionAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ExtensionAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  BuiltInDomainDefinedAttribute
%%================================
enc_BuiltInDomainDefinedAttribute(Val) ->
    enc_BuiltInDomainDefinedAttribute(Val, [<<48>>]).

enc_BuiltInDomainDefinedAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type PrintableString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<19>>]),

%%-------------------------------------------------
%% attribute value(2) with type PrintableString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<19>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BuiltInDomainDefinedAttribute(Tlv) ->
   dec_BuiltInDomainDefinedAttribute(Tlv, [16]).

dec_BuiltInDomainDefinedAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type PrintableString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2) with type PrintableString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [19]),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'BuiltInDomainDefinedAttribute',Term1,Term2},
Res1.


%%================================
%%  BuiltInDomainDefinedAttributes
%%================================
enc_BuiltInDomainDefinedAttributes(Val) ->
    enc_BuiltInDomainDefinedAttributes(Val, [<<48>>]).

enc_BuiltInDomainDefinedAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_BuiltInDomainDefinedAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_BuiltInDomainDefinedAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BuiltInDomainDefinedAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_BuiltInDomainDefinedAttribute'(H, [<<48>>]),
   'enc_BuiltInDomainDefinedAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_BuiltInDomainDefinedAttributes(Tlv) ->
   dec_BuiltInDomainDefinedAttributes(Tlv, [16]).

dec_BuiltInDomainDefinedAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_BuiltInDomainDefinedAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OrganizationalUnitName
%%================================
enc_OrganizationalUnitName(Val) ->
    enc_OrganizationalUnitName(Val, [<<19>>]).

enc_OrganizationalUnitName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_OrganizationalUnitName(Tlv) ->
   dec_OrganizationalUnitName(Tlv, [19]).

dec_OrganizationalUnitName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  OrganizationalUnitNames
%%================================
enc_OrganizationalUnitNames(Val) ->
    enc_OrganizationalUnitNames(Val, [<<48>>]).

enc_OrganizationalUnitNames(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OrganizationalUnitNames_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OrganizationalUnitNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OrganizationalUnitNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<19>>]),
   'enc_OrganizationalUnitNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OrganizationalUnitNames(Tlv) ->
   dec_OrganizationalUnitNames(Tlv, [16]).

dec_OrganizationalUnitNames(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  PersonalName
%%================================
enc_PersonalName(Val) ->
    enc_PersonalName(Val, [<<49>>]).

enc_PersonalName(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute surname(1) with type PrintableString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute given-name(2) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute initials(3) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PersonalName(Tlv) ->
   dec_PersonalName(Tlv, [17]).

dec_PersonalName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
SetFun = fun(FunTlv) ->
case FunTlv of 
      %surname
TTlv = {131072,_} ->
    {1, TTlv};
      %given-name
TTlv = {131073,_} ->
    {2, TTlv};
      %initials
TTlv = {131074,_} ->
    {3, TTlv};
      %generation-qualifier
TTlv = {131075,_} ->
    {4, TTlv};
      Else -> 
         {5, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute surname(1) with type PrintableString
%%-------------------------------------------------
[V1|Tlv3] = Tlv2, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 40 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute given-name(2) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{131073,V2}|TempTlv4] ->
    {begin
Val2 = decode_restricted_string(V2, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute initials(3) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv5} = case Tlv4 of
[{131074,V3}|TempTlv5] ->
    {begin
Val3 = decode_restricted_string(V3, []),
C3 = byte_size(Val3),
if 1 =< C3, C3 =< 5 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv6} = case Tlv5 of
[{131075,V4}|TempTlv6] ->
    {begin
Val4 = decode_restricted_string(V4, []),
C4 = byte_size(Val4),
if 1 =< C4, C4 =< 3 ->
binary_to_list(Val4);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'PersonalName',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  NumericUserIdentifier
%%================================
enc_NumericUserIdentifier(Val) ->
    enc_NumericUserIdentifier(Val, [<<18>>]).

enc_NumericUserIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_NumericUserIdentifier(Tlv) ->
   dec_NumericUserIdentifier(Tlv, [18]).

dec_NumericUserIdentifier(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  OrganizationName
%%================================
enc_OrganizationName(Val) ->
    enc_OrganizationName(Val, [<<19>>]).

enc_OrganizationName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_OrganizationName(Tlv) ->
   dec_OrganizationName(Tlv, [19]).

dec_OrganizationName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PrivateDomainName
%%================================
enc_PrivateDomainName(Val) ->
    enc_PrivateDomainName(Val, []).

enc_PrivateDomainName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      numeric ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      printable ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_PrivateDomainName(Tlv) ->
   dec_PrivateDomainName(Tlv, []).

dec_PrivateDomainName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric'
    {18, V1} -> 
        {numeric, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printable'
    {19, V1} -> 
        {printable, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  TerminalIdentifier
%%================================
enc_TerminalIdentifier(Val) ->
    enc_TerminalIdentifier(Val, [<<19>>]).

enc_TerminalIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_TerminalIdentifier(Tlv) ->
   dec_TerminalIdentifier(Tlv, [19]).

dec_TerminalIdentifier(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 24 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  X121Address
%%================================
enc_X121Address(Val) ->
    enc_X121Address(Val, [<<18>>]).

enc_X121Address(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_X121Address(Tlv) ->
   dec_X121Address(Tlv, [18]).

dec_X121Address(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  NetworkAddress
%%================================
enc_NetworkAddress(Val) ->
    enc_NetworkAddress(Val, [<<18>>]).

enc_NetworkAddress(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_NetworkAddress(Tlv) ->
   dec_NetworkAddress(Tlv, [18]).

dec_NetworkAddress(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  AdministrationDomainName
%%================================
enc_AdministrationDomainName(Val) ->
    enc_AdministrationDomainName(Val, [<<98>>]).

enc_AdministrationDomainName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      numeric ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      printable ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_AdministrationDomainName(Tlv) ->
   dec_AdministrationDomainName(Tlv, [65538]).

dec_AdministrationDomainName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric'
    {18, V1} -> 
        {numeric, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 0 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printable'
    {19, V1} -> 
        {printable, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 0 =< C2, C2 =< 16 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  CountryName
%%================================
enc_CountryName(Val) ->
    enc_CountryName(Val, [<<97>>]).

enc_CountryName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'x121-dcc-code' ->
         encode_restricted_string(element(2,Val), [<<18>>]);
      'iso-3166-alpha2-code' ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CountryName(Tlv) ->
   dec_CountryName(Tlv, [65537]).

dec_CountryName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x121-dcc-code'
    {18, V1} -> 
        {'x121-dcc-code', begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 3 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'iso-3166-alpha2-code'
    {19, V1} -> 
        {'iso-3166-alpha2-code', begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 2 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  BuiltInStandardAttributes
%%================================
enc_BuiltInStandardAttributes(Val) ->
    enc_BuiltInStandardAttributes(Val, [<<48>>]).

enc_BuiltInStandardAttributes(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9} = Val,

%%-------------------------------------------------
%% attribute country-name(1)   External OTP-PUB-KEY:CountryName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CountryName'(Cindex1, [<<97>>])
       end,

%%-------------------------------------------------
%% attribute administration-domain-name(2)   External OTP-PUB-KEY:AdministrationDomainName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AdministrationDomainName'(Cindex2, [<<98>>])
       end,

%%-------------------------------------------------
%% attribute network-address(3) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute terminal-identifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute private-domain-name(5)   External OTP-PUB-KEY:PrivateDomainName OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PrivateDomainName'(Cindex5, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute organization-name(6) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex6, [<<131>>])
       end,

%%-------------------------------------------------
%% attribute numeric-user-identifier(7) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex7, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute personal-name(8)   External OTP-PUB-KEY:PersonalName OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PersonalName'(Cindex8, [<<165>>])
       end,

%%-------------------------------------------------
%% attribute organizational-unit-names(9)   External OTP-PUB-KEY:OrganizationalUnitNames OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OrganizationalUnitNames'(Cindex9, [<<166>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BuiltInStandardAttributes(Tlv) ->
   dec_BuiltInStandardAttributes(Tlv, [16]).

dec_BuiltInStandardAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute country-name(1)   External OTP-PUB-KEY:CountryName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{65537,V1}|TempTlv2] ->
    {'dec_CountryName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute administration-domain-name(2)   External OTP-PUB-KEY:AdministrationDomainName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{65538,V2}|TempTlv3] ->
    {'dec_AdministrationDomainName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute network-address(3) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {begin
Val1 = decode_restricted_string(V3, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute terminal-identifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131073,V4}|TempTlv5] ->
    {begin
Val2 = decode_restricted_string(V4, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 24 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute private-domain-name(5)   External OTP-PUB-KEY:PrivateDomainName OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131074,V5}|TempTlv6] ->
    {'dec_PrivateDomainName'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute organization-name(6) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131075,V6}|TempTlv7] ->
    {begin
Val3 = decode_restricted_string(V6, []),
C3 = byte_size(Val3),
if 1 =< C3, C3 =< 128 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute numeric-user-identifier(7) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131076,V7}|TempTlv8] ->
    {begin
Val4 = decode_restricted_string(V7, []),
C4 = byte_size(Val4),
if 1 =< C4, C4 =< 32 ->
binary_to_list(Val4);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute personal-name(8)   External OTP-PUB-KEY:PersonalName OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131077,V8}|TempTlv9] ->
    {'dec_PersonalName'(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute organizational-unit-names(9)   External OTP-PUB-KEY:OrganizationalUnitNames OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131078,V9}|TempTlv10] ->
    {'dec_OrganizationalUnitNames'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
Res1 = {'BuiltInStandardAttributes',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
Res1.


%%================================
%%  ORAddress
%%================================
enc_ORAddress(Val) ->
    enc_ORAddress(Val, [<<48>>]).

enc_ORAddress(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute built-in-standard-attributes(1)   External OTP-PUB-KEY:BuiltInStandardAttributes
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_BuiltInStandardAttributes'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute built-in-domain-defined-attributes(2)   External OTP-PUB-KEY:BuiltInDomainDefinedAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_BuiltInDomainDefinedAttributes'(Cindex2, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute extension-attributes(3)   External OTP-PUB-KEY:ExtensionAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ExtensionAttributes'(Cindex3, [<<49>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ORAddress(Tlv) ->
   dec_ORAddress(Tlv, [16]).

dec_ORAddress(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute built-in-standard-attributes(1)   External OTP-PUB-KEY:BuiltInStandardAttributes
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_BuiltInStandardAttributes'(V1, [16]),

%%-------------------------------------------------
%% attribute built-in-domain-defined-attributes(2)   External OTP-PUB-KEY:BuiltInDomainDefinedAttributes OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_BuiltInDomainDefinedAttributes'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute extension-attributes(3)   External OTP-PUB-KEY:ExtensionAttributes OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{17,V3}|TempTlv4] ->
    {'dec_ExtensionAttributes'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ORAddress',Term1,Term2,Term3},
Res1.


%%================================
%%  AlgorithmIdentifier
%%================================
enc_AlgorithmIdentifier(Val) ->
    enc_AlgorithmIdentifier(Val, [<<48>>]).

enc_AlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_open_type(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AlgorithmIdentifier(Tlv) ->
   dec_AlgorithmIdentifier(Tlv, [16]).

dec_AlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type_as_binary(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  TBSCertList
%%================================
enc_TBSCertList(Val) ->
    enc_TBSCertList(Val, [<<48>>]).

enc_TBSCertList(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>])
       end,

%%-------------------------------------------------
%% attribute signature(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(3)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_Name'(Cindex3, []),

%%-------------------------------------------------
%% attribute thisUpdate(4)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Time'(Cindex4, []),

%%-------------------------------------------------
%% attribute nextUpdate(5)   External OTP-PUB-KEY:Time OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Time'(Cindex5, [])
       end,

%%-------------------------------------------------
%% attribute revokedCertificates(6) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSCertList_revokedCertificates'(Cindex6, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute crlExtensions(7)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex7, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertList_revokedCertificates
%%================================
enc_TBSCertList_revokedCertificates(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSCertList_revokedCertificates_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSCertList_revokedCertificates_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_SEQOF'(H, [<<48>>]),
   'enc_TBSCertList_revokedCertificates_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSCertList_revokedCertificates_SEQOF
%%================================
enc_TBSCertList_revokedCertificates_SEQOF(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute userCertificate(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute revocationDate(2)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Time'(Cindex2, []),

%%-------------------------------------------------
%% attribute crlEntryExtensions(3)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TBSCertList(Tlv) ->
   dec_TBSCertList(Tlv, [16]).

dec_TBSCertList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute signature(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute issuer(3)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_Name'(V3, []),

%%-------------------------------------------------
%% attribute thisUpdate(4)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Time'(V4, []),

%%-------------------------------------------------
%% attribute nextUpdate(5)   External OTP-PUB-KEY:Time OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[V5 = {23,_}|TempTlv6] ->
    {'dec_Time'(V5, []), TempTlv6};
[V5 = {24,_}|TempTlv6] ->
    {'dec_Time'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute revokedCertificates(6) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{16,V6}|TempTlv7] ->
    {'dec_TBSCertList_revokedCertificates'(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute crlExtensions(7)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131072,V7}|TempTlv8] ->
    {'dec_Extensions'(V7, [16]), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

case Tlv8 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv8}}}) % extra fields not allowed
end,
Res1 = {'TBSCertList',Term1,Term2,Term3,Term4,Term5,Term6,Term7},
Res1.
'dec_TBSCertList_revokedCertificates'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TBSCertList_revokedCertificates_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_TBSCertList_revokedCertificates_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute userCertificate(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute revocationDate(2)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Time'(V2, []),

%%-------------------------------------------------
%% attribute crlEntryExtensions(3)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_Extensions'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'TBSCertList_revokedCertificates_SEQOF',Term1,Term2,Term3},
Res1.


%%================================
%%  CertificateList
%%================================
enc_CertificateList(Val) ->
    enc_CertificateList(Val, [<<48>>]).

enc_CertificateList(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertList(1)   External OTP-PUB-KEY:TBSCertList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertList'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertificateList(Tlv) ->
   dec_CertificateList(Tlv, [16]).

dec_CertificateList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertList(1)   External OTP-PUB-KEY:TBSCertList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertList'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertificateList',Term1,Term2,Term3},
Res1.


%%================================
%%  Extension
%%================================
enc_Extension(Val) ->
    enc_Extension(Val, [<<48>>]).

enc_Extension(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_15(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Extension(Tlv) ->
   dec_Extension(Tlv, [16]).

dec_Extension(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  Extensions
%%================================
enc_Extensions(Val) ->
    enc_Extensions(Val, [<<48>>]).

enc_Extensions(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Extension'(H, [<<48>>]),
   'enc_Extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Extensions(Tlv) ->
   dec_Extensions(Tlv, [16]).

dec_Extensions(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Extension'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SubjectPublicKeyInfo
%%================================
enc_SubjectPublicKeyInfo(Val) ->
    enc_SubjectPublicKeyInfo(Val, [<<48>>]).

enc_SubjectPublicKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AlgorithmIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SubjectPublicKeyInfo(Tlv) ->
   dec_SubjectPublicKeyInfo(Tlv, [16]).

dec_SubjectPublicKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AlgorithmIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SubjectPublicKeyInfo',Term1,Term2},
Res1.


%%================================
%%  UniqueIdentifier
%%================================
enc_UniqueIdentifier(Val) ->
    enc_UniqueIdentifier(Val, [<<3>>]).

enc_UniqueIdentifier(Val, TagIn) ->
encode_unnamed_bit_string(Val, TagIn).


dec_UniqueIdentifier(Tlv) ->
   dec_UniqueIdentifier(Tlv, [3]).

dec_UniqueIdentifier(Tlv, TagIn) ->
decode_native_bit_string(Tlv, TagIn).



%%================================
%%  Time
%%================================
enc_Time(Val) ->
    enc_Time(Val, []).

enc_Time(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      utcTime ->
         encode_restricted_string(element(2,Val), [<<23>>]);
      generalTime ->
         encode_restricted_string(element(2,Val), [<<24>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Time(Tlv) ->
   dec_Time(Tlv, []).

dec_Time(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'utcTime'
    {23, V1} -> 
        {utcTime, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'generalTime'
    {24, V1} -> 
        {generalTime, begin
binary_to_list(decode_restricted_string(V1, []))
end
};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Validity
%%================================
enc_Validity(Val) ->
    enc_Validity(Val, [<<48>>]).

enc_Validity(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Time'(Cindex1, []),

%%-------------------------------------------------
%% attribute notAfter(2)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Time'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Validity(Tlv) ->
   dec_Validity(Tlv, [16]).

dec_Validity(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBefore(1)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Time'(V1, []),

%%-------------------------------------------------
%% attribute notAfter(2)   External OTP-PUB-KEY:Time
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Time'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Validity',Term1,Term2},
Res1.


%%================================
%%  CertificateSerialNumber
%%================================
enc_CertificateSerialNumber(Val) ->
    enc_CertificateSerialNumber(Val, [<<2>>]).

enc_CertificateSerialNumber(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_CertificateSerialNumber(Tlv) ->
   dec_CertificateSerialNumber(Tlv, [2]).

dec_CertificateSerialNumber(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  VersionPKIX1Explicit88
%%================================
enc_VersionPKIX1Explicit88(Val) ->
    enc_VersionPKIX1Explicit88(Val, [<<2>>]).

enc_VersionPKIX1Explicit88(Val, TagIn) ->
encode_integer(Val, [{v1,0},{v2,1},{v3,2}], TagIn).


dec_VersionPKIX1Explicit88(Tlv) ->
   dec_VersionPKIX1Explicit88(Tlv, [2]).

dec_VersionPKIX1Explicit88(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
.



%%================================
%%  TBSCertificate
%%================================
enc_TBSCertificate(Val) ->
    enc_TBSCertificate(Val, [<<48>>]).

enc_TBSCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_17(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute signature(3)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(4)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Name'(Cindex4, []),

%%-------------------------------------------------
%% attribute validity(5)   External OTP-PUB-KEY:Validity
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_Validity'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute subject(6)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_Name'(Cindex6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External OTP-PUB-KEY:SubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_SubjectPublicKeyInfo'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex9, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex10, [<<48>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TBSCertificate(Tlv) ->
   dec_TBSCertificate(Tlv, [16]).

dec_TBSCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute signature(3)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute issuer(4)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Name'(V4, []),

%%-------------------------------------------------
%% attribute validity(5)   External OTP-PUB-KEY:Validity
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_Validity'(V5, [16]),

%%-------------------------------------------------
%% attribute subject(6)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_Name'(V6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External OTP-PUB-KEY:SubjectPublicKeyInfo
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_SubjectPublicKeyInfo'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131073,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131074,V9}|TempTlv10] ->
    {decode_native_bit_string(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131075,V10}|TempTlv11] ->
    {'dec_Extensions'(V10, [16]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
Res1 = {'TBSCertificate',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.


%%================================
%%  Certificate
%%================================
enc_Certificate(Val) ->
    enc_Certificate(Val, [<<48>>]).

enc_Certificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PUB-KEY:TBSCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Certificate(Tlv) ->
   dec_Certificate(Tlv, [16]).

dec_Certificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PUB-KEY:TBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Certificate',Term1,Term2,Term3},
Res1.


%%================================
%%  DirectoryString
%%================================
enc_DirectoryString(Val) ->
    enc_DirectoryString(Val, []).

enc_DirectoryString(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_DirectoryString(Tlv) ->
   dec_DirectoryString(Tlv, []).

dec_DirectoryString(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 'MAX' ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 'MAX' ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 'MAX' ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 'MAX' ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RelativeDistinguishedName
%%================================
enc_RelativeDistinguishedName(Val) ->
    enc_RelativeDistinguishedName(Val, [<<49>>]).

enc_RelativeDistinguishedName(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RelativeDistinguishedName_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_RelativeDistinguishedName_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeTypeAndValue'(H, [<<48>>]),
   'enc_RelativeDistinguishedName_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RelativeDistinguishedName(Tlv) ->
   dec_RelativeDistinguishedName(Tlv, [17]).

dec_RelativeDistinguishedName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AttributeTypeAndValue'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  DistinguishedName
%%================================
enc_DistinguishedName(Val) ->
    enc_DistinguishedName(Val, [<<48>>]).

enc_DistinguishedName(Val, TagIn) ->
   enc_RDNSequence(Val, TagIn).


dec_DistinguishedName(Tlv) ->
   dec_DistinguishedName(Tlv, [16]).

dec_DistinguishedName(Tlv, TagIn) ->
'dec_RDNSequence'(Tlv, TagIn).



%%================================
%%  RDNSequence
%%================================
enc_RDNSequence(Val) ->
    enc_RDNSequence(Val, [<<48>>]).

enc_RDNSequence(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RDNSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RDNSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RDNSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName'(H, [<<49>>]),
   'enc_RDNSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RDNSequence(Tlv) ->
   dec_RDNSequence(Tlv, [16]).

dec_RDNSequence(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RelativeDistinguishedName'(V1, [17]) || V1 <- Tlv1].




%%================================
%%  Name
%%================================
enc_Name(Val) ->
    enc_Name(Val, []).

enc_Name(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      rdnSequence ->
         'enc_RDNSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Name(Tlv) ->
   dec_Name(Tlv, []).

dec_Name(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'rdnSequence'
    {16, V1} -> 
        {rdnSequence, 'dec_RDNSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  EmailAddress
%%================================
enc_EmailAddress(Val) ->
    enc_EmailAddress(Val, [<<22>>]).

enc_EmailAddress(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EmailAddress(Tlv) ->
   dec_EmailAddress(Tlv, [22]).

dec_EmailAddress(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 255 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  DomainComponent
%%================================
enc_DomainComponent(Val) ->
    enc_DomainComponent(Val, [<<22>>]).

enc_DomainComponent(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_DomainComponent(Tlv) ->
   dec_DomainComponent(Tlv, [22]).

dec_DomainComponent(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  X520Pseudonym
%%================================
enc_X520Pseudonym(Val) ->
    enc_X520Pseudonym(Val, []).

enc_X520Pseudonym(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520Pseudonym(Tlv) ->
   dec_X520Pseudonym(Tlv, []).

dec_X520Pseudonym(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520SerialNumber
%%================================
enc_X520SerialNumber(Val) ->
    enc_X520SerialNumber(Val, [<<19>>]).

enc_X520SerialNumber(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_X520SerialNumber(Tlv) ->
   dec_X520SerialNumber(Tlv, [19]).

dec_X520SerialNumber(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  X520countryName
%%================================
enc_X520countryName(Val) ->
    enc_X520countryName(Val, [<<19>>]).

enc_X520countryName(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_X520countryName(Tlv) ->
   dec_X520countryName(Tlv, [19]).

dec_X520countryName(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  X520dnQualifier
%%================================
enc_X520dnQualifier(Val) ->
    enc_X520dnQualifier(Val, [<<19>>]).

enc_X520dnQualifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_X520dnQualifier(Tlv) ->
   dec_X520dnQualifier(Tlv, [19]).

dec_X520dnQualifier(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  X520Title
%%================================
enc_X520Title(Val) ->
    enc_X520Title(Val, []).

enc_X520Title(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520Title(Tlv) ->
   dec_X520Title(Tlv, []).

dec_X520Title(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520OrganizationalUnitName
%%================================
enc_X520OrganizationalUnitName(Val) ->
    enc_X520OrganizationalUnitName(Val, []).

enc_X520OrganizationalUnitName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520OrganizationalUnitName(Tlv) ->
   dec_X520OrganizationalUnitName(Tlv, []).

dec_X520OrganizationalUnitName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520OrganizationName
%%================================
enc_X520OrganizationName(Val) ->
    enc_X520OrganizationName(Val, []).

enc_X520OrganizationName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520OrganizationName(Tlv) ->
   dec_X520OrganizationName(Tlv, []).

dec_X520OrganizationName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520StateOrProvinceName
%%================================
enc_X520StateOrProvinceName(Val) ->
    enc_X520StateOrProvinceName(Val, []).

enc_X520StateOrProvinceName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520StateOrProvinceName(Tlv) ->
   dec_X520StateOrProvinceName(Tlv, []).

dec_X520StateOrProvinceName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520LocalityName
%%================================
enc_X520LocalityName(Val) ->
    enc_X520LocalityName(Val, []).

enc_X520LocalityName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520LocalityName(Tlv) ->
   dec_X520LocalityName(Tlv, []).

dec_X520LocalityName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520CommonName
%%================================
enc_X520CommonName(Val) ->
    enc_X520CommonName(Val, []).

enc_X520CommonName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520CommonName(Tlv) ->
   dec_X520CommonName(Tlv, []).

dec_X520CommonName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 256 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 256 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520name
%%================================
enc_X520name(Val) ->
    enc_X520name(Val, []).

enc_X520name(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520name(Tlv) ->
   dec_X520name(Tlv, []).

dec_X520name(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 65536 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 65536 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val3 = decode_universal_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 131072 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val4 = decode_BMP_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 131072 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  AttributeTypeAndValue
%%================================
enc_AttributeTypeAndValue(Val) ->
    enc_AttributeTypeAndValue(Val, [<<48>>]).

enc_AttributeTypeAndValue(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2)   External OTP-PUB-KEY:AttributeValue
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeValue'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeTypeAndValue(Tlv) ->
   dec_AttributeTypeAndValue(Tlv, [16]).

dec_AttributeTypeAndValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2)   External OTP-PUB-KEY:AttributeValue
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeValue'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeTypeAndValue',Term1,Term2},
Res1.


%%================================
%%  AttributeValue
%%================================
enc_AttributeValue(Val) ->
    enc_AttributeValue(Val, []).

enc_AttributeValue(Val, TagIn) ->
%% OPEN TYPE
encode_open_type(Val, TagIn).


dec_AttributeValue(Tlv) ->
   dec_AttributeValue(Tlv, []).

dec_AttributeValue(Tlv, TagIn) ->
decode_open_type_as_binary(Tlv, TagIn).



%%================================
%%  AttributeType
%%================================
enc_AttributeType(Val) ->
    enc_AttributeType(Val, [<<6>>]).

enc_AttributeType(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_AttributeType(Tlv) ->
   dec_AttributeType(Tlv, [6]).

dec_AttributeType(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  Attribute
%%================================
enc_Attribute(Val) ->
    enc_Attribute(Val, [<<48>>]).

enc_Attribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Attribute_values'(Cindex2, [<<49>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Attribute_values
%%================================
enc_Attribute_values(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Attribute_values_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attribute_values_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attribute_values_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeValue'(H, []),
   'enc_Attribute_values_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Attribute(Tlv) ->
   dec_Attribute(Tlv, [16]).

dec_Attribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Attribute_values'(V2, [17]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_Attribute_values'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AttributeValue'(V1, []) || V1 <- Tlv1].




%%================================
%%  OTPDisplayText
%%================================
enc_OTPDisplayText(Val) ->
    enc_OTPDisplayText(Val, []).

enc_OTPDisplayText(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ia5String ->
         encode_restricted_string(element(2,Val), [<<22>>]);
      visibleString ->
         encode_restricted_string(element(2,Val), [<<26>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_OTPDisplayText(Tlv) ->
   dec_OTPDisplayText(Tlv, []).

dec_OTPDisplayText(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ia5String'
    {22, V1} -> 
        {ia5String, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 350 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'visibleString'
    {26, V1} -> 
        {visibleString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 350 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 350 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OTPNoticeReference
%%================================
enc_OTPNoticeReference(Val) ->
    enc_OTPNoticeReference(Val, [<<48>>]).

enc_OTPNoticeReference(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute organization(1)   External OTP-PUB-KEY:OTPDisplayText
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_OTPDisplayText'(Cindex1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_OTPNoticeReference_noticeNumbers'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OTPNoticeReference_noticeNumbers
%%================================
enc_OTPNoticeReference_noticeNumbers(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_OTPNoticeReference_noticeNumbers_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPNoticeReference_noticeNumbers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OTPNoticeReference_noticeNumbers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_OTPNoticeReference_noticeNumbers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OTPNoticeReference(Tlv) ->
   dec_OTPNoticeReference(Tlv, [16]).

dec_OTPNoticeReference(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute organization(1)   External OTP-PUB-KEY:OTPDisplayText
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_OTPDisplayText'(V1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_OTPNoticeReference_noticeNumbers'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPNoticeReference',Term1,Term2},
Res1.
'dec_OTPNoticeReference_noticeNumbers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_integer(V1, [2]) || V1 <- Tlv1].




%%================================
%%  OTPUserNotice
%%================================
enc_OTPUserNotice(Val) ->
    enc_OTPUserNotice(Val, [<<48>>]).

enc_OTPUserNotice(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute noticeRef(1)   External OTP-PUB-KEY:OTPNoticeReference OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OTPNoticeReference'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute explicitText(2)   External OTP-PUB-KEY:OTPDisplayText OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OTPDisplayText'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPUserNotice(Tlv) ->
   dec_OTPUserNotice(Tlv, [16]).

dec_OTPUserNotice(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute noticeRef(1)   External OTP-PUB-KEY:OTPNoticeReference OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'dec_OTPNoticeReference'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute explicitText(2)   External OTP-PUB-KEY:OTPDisplayText OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {22,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
[V2 = {26,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
[V2 = {30,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
[V2 = {12,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPUserNotice',Term1,Term2},
Res1.


%%================================
%%  Extension-Any
%%================================
'enc_Extension-Any'(Val) ->
    'enc_Extension-Any'(Val, [<<48>>]).

'enc_Extension-Any'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_15(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_open_type(Cindex3, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Extension-Any'(Tlv) ->
   'dec_Extension-Any'(Tlv, [16]).

'dec_Extension-Any'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_open_type_as_binary(V3, []),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension-Any',Term1,Term2,Term3},
Res1.


%%================================
%%  Any
%%================================
enc_Any(Val) ->
    enc_Any(Val, []).

enc_Any(Val, TagIn) ->
%% OPEN TYPE
encode_open_type(Val, TagIn).


dec_Any(Tlv) ->
   dec_Any(Tlv, []).

dec_Any(Tlv, TagIn) ->
decode_open_type_as_binary(Tlv, TagIn).



%%================================
%%  Boolean
%%================================
enc_Boolean(Val) ->
    enc_Boolean(Val, [<<1>>]).

enc_Boolean(Val, TagIn) ->
encode_boolean(Val, TagIn).


dec_Boolean(Tlv) ->
   dec_Boolean(Tlv, [1]).

dec_Boolean(Tlv, TagIn) ->
decode_boolean(Tlv, TagIn).



%%================================
%%  ObjId
%%================================
enc_ObjId(Val) ->
    enc_ObjId(Val, [<<6>>]).

enc_ObjId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_ObjId(Tlv) ->
   dec_ObjId(Tlv, [6]).

dec_ObjId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  OTPExtension
%%================================
enc_OTPExtension(Val) ->
    enc_OTPExtension(Val, [<<48>>]).

enc_OTPExtension(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,
ObjextnID = 
   'OTP-PUB-KEY':'getenc_SupportedExtensions'(                                   Cindex1),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_15(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type typefieldType
%%-------------------------------------------------
   {TmpBytes3,_} = ObjextnID('Type', Cindex3, []),
   {EncBytes3,EncLen3} = encode_open_type(TmpBytes3, [])
,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPExtension(Tlv) ->
   dec_OTPExtension(Tlv, [16]).

dec_OTPExtension(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type typefieldType
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 

  Tmpterm1 = decode_open_type(V3, []),

DecObjextnIDTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedExtensions'(Term1),
Term3 = 
   case (catch DecObjextnIDTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OTPExtension',Term1,Term2,Term3},
Res1.


%%================================
%%  OTPExtensions
%%================================
enc_OTPExtensions(Val) ->
    enc_OTPExtensions(Val, [<<48>>]).

enc_OTPExtensions(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OTPExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OTPExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Extension'(H, [<<48>>]),
   'enc_OTPExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OTPExtensions(Tlv) ->
   dec_OTPExtensions(Tlv, [16]).

dec_OTPExtensions(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Extension'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OTPExtensionAttribute
%%================================
enc_OTPExtensionAttribute(Val) ->
    enc_OTPExtensionAttribute(Val, [<<48>>]).

enc_OTPExtensionAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjextensionAttributeType = 
   'OTP-PUB-KEY':'getenc_SupportedExtensionAttributes'(                                   Cindex1),

%%-------------------------------------------------
%% attribute extensionAttributeType(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute extensionAttributeValue(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjextensionAttributeType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [<<161>>])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPExtensionAttribute(Tlv) ->
   dec_OTPExtensionAttribute(Tlv, [16]).

dec_OTPExtensionAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extensionAttributeType(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [131072]),

%%-------------------------------------------------
%% attribute extensionAttributeValue(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, [131073]),

DecObjextensionAttributeTypeTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedExtensionAttributes'(Term1),
Term2 = 
   case (catch DecObjextensionAttributeTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPExtensionAttribute',Term1,Term2},
Res1.


%%================================
%%  OTPExtensionAttributes
%%================================
enc_OTPExtensionAttributes(Val) ->
    enc_OTPExtensionAttributes(Val, [<<49>>]).

enc_OTPExtensionAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OTPExtensionAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPExtensionAttributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_OTPExtensionAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttribute'(H, [<<48>>]),
   'enc_OTPExtensionAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OTPExtensionAttributes(Tlv) ->
   dec_OTPExtensionAttributes(Tlv, [17]).

dec_OTPExtensionAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ExtensionAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OTPCharacteristic-two
%%================================
'enc_OTPCharacteristic-two'(Val) ->
    'enc_OTPCharacteristic-two'(Val, [<<48>>]).

'enc_OTPCharacteristic-two'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,
Objbasis = 
   'OTP-PUB-KEY':'getenc_SupportedCharacteristicTwos'(                                   Cindex2),

%%-------------------------------------------------
%% attribute m(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute basis(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(3) with type typefieldType
%%-------------------------------------------------
   {TmpBytes3,_} = Objbasis('Type', Cindex3, []),
   {EncBytes3,EncLen3} = encode_open_type(TmpBytes3, [])
,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_OTPCharacteristic-two'(Tlv) ->
   'dec_OTPCharacteristic-two'(Tlv, [16]).

'dec_OTPCharacteristic-two'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute m(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute basis(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

%%-------------------------------------------------
%% attribute parameters(3) with type typefieldType
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 

  Tmpterm1 = decode_open_type(V3, []),

DecObjbasisTerm2 =
   'OTP-PUB-KEY':'getdec_SupportedCharacteristicTwos'(Term2),
Term3 = 
   case (catch DecObjbasisTerm2('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OTPCharacteristic-two',Term1,Term2,Term3},
Res1.


%%================================
%%  OTPFieldID
%%================================
enc_OTPFieldID(Val) ->
    enc_OTPFieldID(Val, [<<48>>]).

enc_OTPFieldID(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjfieldType = 
   'OTP-PUB-KEY':'getenc_SupportedFieldIds'(                                   Cindex1),

%%-------------------------------------------------
%% attribute fieldType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjfieldType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPFieldID(Tlv) ->
   dec_OTPFieldID(Tlv, [16]).

dec_OTPFieldID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute fieldType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjfieldTypeTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedFieldIds'(Term1),
Term2 = 
   case (catch DecObjfieldTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPFieldID',Term1,Term2},
Res1.


%%================================
%%  KEA-PublicKey
%%================================
'enc_KEA-PublicKey'(Val) ->
    'enc_KEA-PublicKey'(Val, [<<2>>]).

'enc_KEA-PublicKey'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_KEA-PublicKey'(Tlv) ->
   'dec_KEA-PublicKey'(Tlv, [2]).

'dec_KEA-PublicKey'(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  DSAParams
%%================================
enc_DSAParams(Val) ->
    enc_DSAParams(Val, []).

enc_DSAParams(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      params ->
         'enc_Dss-Parms'(element(2,Val), [<<48>>]);
      null ->
         encode_null(element(2,Val), [<<5>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_DSAParams(Tlv) ->
   dec_DSAParams(Tlv, []).

dec_DSAParams(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'params'
    {16, V1} -> 
        {params, 'dec_Dss-Parms'(V1, [])};


%% 'null'
    {5, V1} -> 
        {null, decode_null(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PublicKeyAlgorithm
%%================================
enc_PublicKeyAlgorithm(Val) ->
    enc_PublicKeyAlgorithm(Val, [<<48>>]).

enc_PublicKeyAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_SupportedPublicKeyAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PublicKeyAlgorithm(Tlv) ->
   dec_PublicKeyAlgorithm(Tlv, [16]).

dec_PublicKeyAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedPublicKeyAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PublicKeyAlgorithm',Term1,Term2},
Res1.


%%================================
%%  SignatureAlgorithm-Any
%%================================
'enc_SignatureAlgorithm-Any'(Val) ->
    'enc_SignatureAlgorithm-Any'(Val, [<<48>>]).

'enc_SignatureAlgorithm-Any'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_open_type(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SignatureAlgorithm-Any'(Tlv) ->
   'dec_SignatureAlgorithm-Any'(Tlv, [16]).

'dec_SignatureAlgorithm-Any'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type_as_binary(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SignatureAlgorithm-Any',Term1,Term2},
Res1.


%%================================
%%  SignatureAlgorithm
%%================================
enc_SignatureAlgorithm(Val) ->
    enc_SignatureAlgorithm(Val, [<<48>>]).

enc_SignatureAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_SupportedSignatureAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SignatureAlgorithm(Tlv) ->
   dec_SignatureAlgorithm(Tlv, [16]).

dec_SignatureAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedSignatureAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SignatureAlgorithm',Term1,Term2},
Res1.


%%================================
%%  OTPSubjectPublicKeyInfo-Any
%%================================
'enc_OTPSubjectPublicKeyInfo-Any'(Val) ->
    'enc_OTPSubjectPublicKeyInfo-Any'(Val, [<<48>>]).

'enc_OTPSubjectPublicKeyInfo-Any'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1)   External OTP-PUB-KEY:PublicKeyAlgorithm
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PublicKeyAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_OTPSubjectPublicKeyInfo-Any'(Tlv) ->
   'dec_OTPSubjectPublicKeyInfo-Any'(Tlv, [16]).

'dec_OTPSubjectPublicKeyInfo-Any'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1)   External OTP-PUB-KEY:PublicKeyAlgorithm
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PublicKeyAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPSubjectPublicKeyInfo-Any',Term1,Term2},
Res1.


%%================================
%%  OTPSubjectPublicKeyInfo
%%================================
enc_OTPSubjectPublicKeyInfo(Val) ->
    enc_OTPSubjectPublicKeyInfo(Val, [<<48>>]).

enc_OTPSubjectPublicKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1)   External OTP-PUB-KEY:PublicKeyAlgorithm
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PublicKeyAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPSubjectPublicKeyInfo(Tlv) ->
   dec_OTPSubjectPublicKeyInfo(Tlv, [16]).

dec_OTPSubjectPublicKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1)   External OTP-PUB-KEY:PublicKeyAlgorithm
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PublicKeyAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPSubjectPublicKeyInfo',Term1,Term2},
Res1.


%%================================
%%  OTPOLDSubjectPublicKeyInfo
%%================================
enc_OTPOLDSubjectPublicKeyInfo(Val) ->
    enc_OTPOLDSubjectPublicKeyInfo(Val, [<<48>>]).

enc_OTPOLDSubjectPublicKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PUB-KEY':'getenc_SupportedPublicKeyAlgorithms'(                                   element(2, Cindex1)),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_OTPOLDSubjectPublicKeyInfo_algorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type typefieldPublicKeyType
%%-------------------------------------------------
   {TmpBytes2,_} = Objalgorithm('PublicKeyType', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OTPOLDSubjectPublicKeyInfo_algorithm
%%================================
enc_OTPOLDSubjectPublicKeyInfo_algorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgo = 
   'OTP-PUB-KEY':'getenc_SupportedPublicKeyAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algo(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgo('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPOLDSubjectPublicKeyInfo(Tlv) ->
   dec_OTPOLDSubjectPublicKeyInfo(Tlv, [16]).

dec_OTPOLDSubjectPublicKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_OTPOLDSubjectPublicKeyInfo_algorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type typefieldPublicKeyType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjalgorithmTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedPublicKeyAlgorithms'(element(2, Term1)),
Term2 = 
   case (catch DecObjalgorithmTerm1('PublicKeyType', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPOLDSubjectPublicKeyInfo',Term1,Term2},
Res1.
'dec_OTPOLDSubjectPublicKeyInfo_algorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algo(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgoTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedPublicKeyAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgoTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPOLDSubjectPublicKeyInfo_algorithm',Term1,Term2},
Res1.


%%================================
%%  OTP-emailAddress
%%================================
'enc_OTP-emailAddress'(Val) ->
    'enc_OTP-emailAddress'(Val, []).

'enc_OTP-emailAddress'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ia5String ->
         encode_restricted_string(element(2,Val), [<<22>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_OTP-emailAddress'(Tlv) ->
   'dec_OTP-emailAddress'(Tlv, []).

'dec_OTP-emailAddress'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ia5String'
    {22, V1} -> 
        {ia5String, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 255 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OTP-X520countryname
%%================================
'enc_OTP-X520countryname'(Val) ->
    'enc_OTP-X520countryname'(Val, []).

'enc_OTP-X520countryname'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_OTP-X520countryname'(Tlv) ->
   'dec_OTP-X520countryname'(Tlv, []).

'dec_OTP-X520countryname'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 2 =< C1, C1 =< 3 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OTPAttributeTypeAndValue
%%================================
enc_OTPAttributeTypeAndValue(Val) ->
    enc_OTPAttributeTypeAndValue(Val, [<<48>>]).

enc_OTPAttributeTypeAndValue(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PUB-KEY':'getenc_SupportedAttributeTypeAndValues'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPAttributeTypeAndValue(Tlv) ->
   dec_OTPAttributeTypeAndValue(Tlv, [16]).

dec_OTPAttributeTypeAndValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjtypeTerm1 =
   'OTP-PUB-KEY':'getdec_SupportedAttributeTypeAndValues'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPAttributeTypeAndValue',Term1,Term2},
Res1.


%%================================
%%  OTPTBSCertificate
%%================================
enc_OTPTBSCertificate(Val) ->
    enc_OTPTBSCertificate(Val, [<<48>>]).

enc_OTPTBSCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_17(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute signature(3)   External OTP-PUB-KEY:SignatureAlgorithm
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_SignatureAlgorithm'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(4)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Name'(Cindex4, []),

%%-------------------------------------------------
%% attribute validity(5)   External OTP-PUB-KEY:Validity
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_Validity'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute subject(6)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_Name'(Cindex6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External OTP-PUB-KEY:OTPSubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_OTPSubjectPublicKeyInfo'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex9, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex10, [<<48>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPTBSCertificate(Tlv) ->
   dec_OTPTBSCertificate(Tlv, [16]).

dec_OTPTBSCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute signature(3)   External OTP-PUB-KEY:SignatureAlgorithm
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_SignatureAlgorithm'(V3, [16]),

%%-------------------------------------------------
%% attribute issuer(4)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Name'(V4, []),

%%-------------------------------------------------
%% attribute validity(5)   External OTP-PUB-KEY:Validity
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_Validity'(V5, [16]),

%%-------------------------------------------------
%% attribute subject(6)   External OTP-PUB-KEY:Name
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_Name'(V6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External OTP-PUB-KEY:OTPSubjectPublicKeyInfo
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_OTPSubjectPublicKeyInfo'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131073,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131074,V9}|TempTlv10] ->
    {decode_native_bit_string(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10)   External OTP-PUB-KEY:Extensions OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131075,V10}|TempTlv11] ->
    {'dec_Extensions'(V10, [16]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
Res1 = {'OTPTBSCertificate',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.


%%================================
%%  OTPCertificate
%%================================
enc_OTPCertificate(Val) ->
    enc_OTPCertificate(Val, [<<48>>]).

enc_OTPCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PUB-KEY:OTPTBSCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_OTPTBSCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:SignatureAlgorithm
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignatureAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPCertificate(Tlv) ->
   dec_OTPCertificate(Tlv, [16]).

dec_OTPCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PUB-KEY:OTPTBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_OTPTBSCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:SignatureAlgorithm
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OTPCertificate',Term1,Term2,Term3},
Res1.
dhKeyAgreement() ->
{1,2,840,113549,1,3,1}.

'pkcs-3'() ->
{1,2,840,113549,1,3}.

'rSASSA-PSS-Default-Identifier'() ->
{'RSASSA-AlgorithmIdentifier',{1,2,840,113549,1,1,10},{'RSASSA-PSS-params',{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},20,1}}.

'rSAES-OAEP-Default-Identifier'() ->
{'RSAES-AlgorithmIdentifier',{1,2,840,113549,1,1,7},{'RSAES-OAEP-params',{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}}}.

emptyString() ->
<<>>.

pSpecifiedEmpty() ->
{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}.

mgf1SHA1() ->
{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}.

sha1() ->
{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}.

'id-mgf1'() ->
{1,2,840,113549,1,1,8}.

'id-sha512'() ->
{2,16,840,1,101,3,4,2,3}.

'id-sha384'() ->
{2,16,840,1,101,3,4,2,2}.

'id-sha256'() ->
{2,16,840,1,101,3,4,2,1}.

'id-sha224'() ->
{2,16,840,1,101,3,4,2,4}.

'id-hmacWithSHA512'() ->
{1,2,840,113549,2,11}.

'id-hmacWithSHA384'() ->
{1,2,840,113549,2,10}.

'id-hmacWithSHA256'() ->
{1,2,840,113549,2,9}.

'id-hmacWithSHA224'() ->
{1,2,840,113549,2,8}.

'id-md5'() ->
{1,2,840,113549,2,5}.

'id-md2'() ->
{1,2,840,113549,2,2}.

'id-sha1'() ->
{1,3,14,3,2,26}.

'sha-1WithRSAEncryption'() ->
{1,3,14,3,2,29}.

'sha512-256WithRSAEncryption'() ->
{1,2,840,113549,1,1,16}.

'sha512-224WithRSAEncryption'() ->
{1,2,840,113549,1,1,15}.

sha512WithRSAEncryption() ->
{1,2,840,113549,1,1,13}.

sha384WithRSAEncryption() ->
{1,2,840,113549,1,1,12}.

sha256WithRSAEncryption() ->
{1,2,840,113549,1,1,11}.

sha224WithRSAEncryption() ->
{1,2,840,113549,1,1,14}.

sha1WithRSAEncryption() ->
{1,2,840,113549,1,1,5}.

md5WithRSAEncryption() ->
{1,2,840,113549,1,1,4}.

md2WithRSAEncryption() ->
{1,2,840,113549,1,1,2}.

'id-RSASSA-PSS'() ->
{1,2,840,113549,1,1,10}.

'id-pSpecified'() ->
{1,2,840,113549,1,1,9}.

'id-RSAES-OAEP'() ->
{1,2,840,113549,1,1,7}.

rsaEncryption() ->
{1,2,840,113549,1,1,1}.

'pkcs-1'() ->
{1,2,840,113549,1,1}.

'id-Ed448'() ->
{1,3,101,113}.

'id-Ed25519'() ->
{1,3,101,112}.

'id-X448'() ->
{1,3,101,111}.

'id-X25519'() ->
{1,3,101,110}.

'id-edwards-curve-algs'() ->
{1,3,101}.

sect571r1() ->
{1,3,132,0,39}.

sect571k1() ->
{1,3,132,0,38}.

sect409r1() ->
{1,3,132,0,37}.

sect409k1() ->
{1,3,132,0,36}.

secp521r1() ->
{1,3,132,0,35}.

secp384r1() ->
{1,3,132,0,34}.

secp224r1() ->
{1,3,132,0,33}.

secp224k1() ->
{1,3,132,0,32}.

secp192k1() ->
{1,3,132,0,31}.

secp160r2() ->
{1,3,132,0,30}.

secp128r2() ->
{1,3,132,0,29}.

secp128r1() ->
{1,3,132,0,28}.

sect233r1() ->
{1,3,132,0,27}.

sect233k1() ->
{1,3,132,0,26}.

sect193r2() ->
{1,3,132,0,25}.

sect193r1() ->
{1,3,132,0,24}.

sect131r2() ->
{1,3,132,0,23}.

sect131r1() ->
{1,3,132,0,22}.

sect283r1() ->
{1,3,132,0,17}.

sect283k1() ->
{1,3,132,0,16}.

sect163r2() ->
{1,3,132,0,15}.

secp256k1() ->
{1,3,132,0,10}.

secp160k1() ->
{1,3,132,0,9}.

secp160r1() ->
{1,3,132,0,8}.

secp112r2() ->
{1,3,132,0,7}.

secp112r1() ->
{1,3,132,0,6}.

sect113r2() ->
{1,3,132,0,5}.

sect113r1() ->
{1,3,132,0,4}.

sect239k1() ->
{1,3,132,0,3}.

sect163r1() ->
{1,3,132,0,2}.

sect163k1() ->
{1,3,132,0,1}.

secp256r1() ->
{1,2,840,10045,3,1,7}.

secp192r1() ->
{1,2,840,10045,3,1,1}.

ellipticCurve() ->
{1,3,132,0}.

'certicom-arc'() ->
{1,3,132}.

'id-ecPublicKey'() ->
{1,2,840,10045,2,1}.

'id-publicKeyType'() ->
{1,2,840,10045,2}.

ppBasis() ->
{1,2,840,10045,1,2,3,3}.

tpBasis() ->
{1,2,840,10045,1,2,3,2}.

gnBasis() ->
{1,2,840,10045,1,2,3,1}.

'id-characteristic-two-basis'() ->
{1,2,840,10045,1,2,3}.

'characteristic-two-field'() ->
{1,2,840,10045,1,2}.

'prime-field'() ->
{1,2,840,10045,1,1}.

'id-fieldType'() ->
{1,2,840,10045,1}.

'ecdsa-with-SHA512'() ->
{1,2,840,10045,4,3,4}.

'ecdsa-with-SHA384'() ->
{1,2,840,10045,4,3,3}.

'ecdsa-with-SHA256'() ->
{1,2,840,10045,4,3,2}.

'ecdsa-with-SHA224'() ->
{1,2,840,10045,4,3,1}.

'ecdsa-with-SHA2'() ->
{1,2,840,10045,4,3}.

'ecdsa-with-SHA1'() ->
{1,2,840,10045,4,1}.

'id-ecSigType'() ->
{1,2,840,10045,4}.

'ansi-X9-62'() ->
{1,2,840,10045}.

'id-keyExchangeAlgorithm'() ->
{2,16,840,1,101,2,1,1,22}.

dhpublicnumber() ->
{1,2,840,10046,2,1}.

'id-dsaWithSHA1'() ->
{1,3,14,3,2,27}.

'id-dsa-with-sha1'() ->
{1,2,840,10040,4,3}.

'id-dsa'() ->
{1,2,840,10040,4,1}.

'id-at-clearance'() ->
{2,5,1,5,55}.

'id-at-role'() ->
{2,5,4,72}.

'id-aca-encAttrs'() ->
{1,3,6,1,5,5,7,10,6}.

'id-aca-group'() ->
{1,3,6,1,5,5,7,10,4}.

'id-aca-chargingIdentity'() ->
{1,3,6,1,5,5,7,10,3}.

'id-aca-accessIdentity'() ->
{1,3,6,1,5,5,7,10,2}.

'id-aca-authenticationInfo'() ->
{1,3,6,1,5,5,7,10,1}.

'id-aca'() ->
{1,3,6,1,5,5,7,10}.

'id-ce-targetInformation'() ->
{2,5,29,55}.

'id-pe-ac-proxying'() ->
{1,3,6,1,5,5,7,1,10}.

'id-pe-aaControls'() ->
{1,3,6,1,5,5,7,1,6}.

'id-pe-ac-auditIdentity'() ->
{1,3,6,1,5,5,7,1,4}.

'id-ce-invalidityDate'() ->
{2,5,29,24}.

'id-holdinstruction-reject'() ->
{2,2,840,10040,2,3}.

'id-holdinstruction-callissuer'() ->
{2,2,840,10040,2,2}.

'id-holdinstruction-none'() ->
{2,2,840,10040,2,1}.

holdInstruction() ->
{2,2,840,10040,2}.

'id-ce-holdInstructionCode'() ->
{2,5,29,23}.

'id-ce-certificateIssuer'() ->
{2,5,29,29}.

'id-ce-cRLReasons'() ->
{2,5,29,21}.

'id-ce-deltaCRLIndicator'() ->
{2,5,29,27}.

'id-ce-issuingDistributionPoint'() ->
{2,5,29,28}.

'id-ce-cRLNumber'() ->
{2,5,29,20}.

'id-pe-subjectInfoAccess'() ->
{1,3,6,1,5,5,7,1,11}.

'id-pe-authorityInfoAccess'() ->
{1,3,6,1,5,5,7,1,1}.

'id-ce-freshestCRL'() ->
{2,5,29,46}.

'id-ce-inhibitAnyPolicy'() ->
{2,5,29,54}.

'id-kp-OCSPSigning'() ->
{1,3,6,1,5,5,7,3,9}.

'id-kp-timeStamping'() ->
{1,3,6,1,5,5,7,3,8}.

'id-kp-emailProtection'() ->
{1,3,6,1,5,5,7,3,4}.

'id-kp-codeSigning'() ->
{1,3,6,1,5,5,7,3,3}.

'id-kp-clientAuth'() ->
{1,3,6,1,5,5,7,3,2}.

'id-kp-serverAuth'() ->
{1,3,6,1,5,5,7,3,1}.

anyExtendedKeyUsage() ->
{2,5,29,37,0}.

'id-ce-extKeyUsage'() ->
{2,5,29,37}.

'id-ce-cRLDistributionPoints'() ->
{2,5,29,31}.

'id-ce-policyConstraints'() ->
{2,5,29,36}.

'id-ce-nameConstraints'() ->
{2,5,29,30}.

'id-ce-basicConstraints'() ->
{2,5,29,19}.

'id-ce-subjectDirectoryAttributes'() ->
{2,5,29,9}.

'id-ce-issuerAltName'() ->
{2,5,29,18}.

'id-ce-subjectAltName'() ->
{2,5,29,17}.

'id-ce-policyMappings'() ->
{2,5,29,33}.

anyPolicy() ->
{2,5,29,32,0}.

'id-ce-certificatePolicies'() ->
{2,5,29,32}.

'id-ce-privateKeyUsagePeriod'() ->
{2,5,29,16}.

'id-ce-keyUsage'() ->
{2,5,29,15}.

'id-ce-subjectKeyIdentifier'() ->
{2,5,29,14}.

'id-ce-authorityKeyIdentifier'() ->
{2,5,29,35}.

'id-ce'() ->
{2,5,29}.

'id-extensionReq'() ->
{2,16,840,1,113733,1,9,8}.

'id-transId'() ->
{2,16,840,1,113733,1,9,7}.

'id-recipientNonce'() ->
{2,16,840,1,113733,1,9,6}.

'id-senderNonce'() ->
{2,16,840,1,113733,1,9,5}.

'id-failInfo'() ->
{2,16,840,1,113733,1,9,4}.

'id-pkiStatus'() ->
{2,16,840,1,113733,1,9,3}.

'id-messageType'() ->
{2,16,840,1,113733,1,9,2}.

'id-attributes'() ->
{2,16,840,1,113733,1,9}.

'id-pki'() ->
{2,16,840,1,113733,1}.

'id-VeriSign'() ->
{2,16,840,1,113733}.

encryptedData() ->
{1,2,840,113549,1,7,6}.

digestedData() ->
{1,2,840,113549,1,7,5}.

signedAndEnvelopedData() ->
{1,2,840,113549,1,7,4}.

envelopedData() ->
{1,2,840,113549,1,7,3}.

signedData() ->
{1,2,840,113549,1,7,2}.

data() ->
{1,2,840,113549,1,7,1}.

'pkcs-7'() ->
{1,2,840,113549,1,7}.

'pkcs-9-at-counterSignature'() ->
{1,2,840,113549,1,9,6}.

'pkcs-9-at-signingTime'() ->
{1,2,840,113549,1,9,5}.

'pkcs-9-at-messageDigest'() ->
{1,2,840,113549,1,9,4}.

'pkcs-9-at-contentType'() ->
{1,2,840,113549,1,9,3}.

'pkcs-9'() ->
{1,2,840,113549,1,9}.

'pkcs-9-at-extensionRequest'() ->
{1,2,840,113549,1,9,14}.

'pkcs-9-at-challengePassword'() ->
{1,2,840,113549,1,9,7}.

brainpoolP512t1() ->
{1,3,36,3,3,2,8,1,1,14}.

brainpoolP512r1() ->
{1,3,36,3,3,2,8,1,1,13}.

brainpoolP384t1() ->
{1,3,36,3,3,2,8,1,1,12}.

brainpoolP384r1() ->
{1,3,36,3,3,2,8,1,1,11}.

brainpoolP320t1() ->
{1,3,36,3,3,2,8,1,1,10}.

brainpoolP320r1() ->
{1,3,36,3,3,2,8,1,1,9}.

brainpoolP256t1() ->
{1,3,36,3,3,2,8,1,1,8}.

brainpoolP256r1() ->
{1,3,36,3,3,2,8,1,1,7}.

brainpoolP224t1() ->
{1,3,36,3,3,2,8,1,1,6}.

brainpoolP224r1() ->
{1,3,36,3,3,2,8,1,1,5}.

brainpoolP192t1() ->
{1,3,36,3,3,2,8,1,1,4}.

brainpoolP192r1() ->
{1,3,36,3,3,2,8,1,1,3}.

brainpoolP160t1() ->
{1,3,36,3,3,2,8,1,1,2}.

brainpoolP160r1() ->
{1,3,36,3,3,2,8,1,1,1}.

versionOne() ->
{1,3,36,3,3,2,8,1,1}.

ellipticCurveRFC5639() ->
{1,3,36,3,3,2,8,1}.

ecStdCurvesAndGeneration() ->
{1,3,36,3,3,2,8}.

'id-aes256-wrap'() ->
{2,16,840,1,101,3,4,1,45}.

'id-aes192-wrap'() ->
{2,16,840,1,101,3,4,1,25}.

'id-aes128-wrap'() ->
{2,16,840,1,101,3,4,1,5}.

'id-aes256-CBC'() ->
{2,16,840,1,101,3,4,1,42}.

'id-aes192-CBC'() ->
{2,16,840,1,101,3,4,1,22}.

'id-aes128-CBC'() ->
{2,16,840,1,101,3,4,1,2}.

aes() ->
{2,16,840,1,101,3,4,1}.

'id-pkix-ocsp-extended-revoke'() ->
{1,3,6,1,5,5,7,48,1,9}.

'id-pkix-ocsp-pref-sig-algs'() ->
{1,3,6,1,5,5,7,48,1,8}.

'id-pkix-ocsp-service-locator'() ->
{1,3,6,1,5,5,7,48,1,7}.

'id-pkix-ocsp-archive-cutoff'() ->
{1,3,6,1,5,5,7,48,1,6}.

'id-pkix-ocsp-nocheck'() ->
{1,3,6,1,5,5,7,48,1,5}.

'id-pkix-ocsp-response'() ->
{1,3,6,1,5,5,7,48,1,4}.

'id-pkix-ocsp-crl'() ->
{1,3,6,1,5,5,7,48,1,3}.

'id-pkix-ocsp-nonce'() ->
{1,3,6,1,5,5,7,48,1,2}.

'id-pkix-ocsp-basic'() ->
{1,3,6,1,5,5,7,48,1,1}.

'id-pkix-ocsp'() ->
{1,3,6,1,5,5,7,48,1}.

'ub-x121-address-length'() ->
16.

'ub-unformatted-address-length'() ->
180.

'ub-terminal-id-length'() ->
24.

'ub-surname-length'() ->
40.

'ub-pseudonym-universal'() ->
256.

'ub-pseudonym-utf8'() ->
256.

'ub-pseudonym'() ->
128.

'ub-postal-code-length'() ->
16.

'ub-pds-physical-address-lines'() ->
6.

'ub-pds-parameter-length'() ->
30.

'ub-pds-name-length'() ->
16.

'ub-organizational-units'() ->
4.

'ub-numeric-user-id-length'() ->
32.

'ub-integer-options'() ->
256.

'ub-initials-length'() ->
5.

'ub-given-name-length'() ->
16.

'ub-generation-qualifier-length'() ->
3.

'ub-e163-4-sub-address-length'() ->
40.

'ub-e163-4-number-length'() ->
15.

'ub-extension-attributes'() ->
256.

'ub-domain-name-length'() ->
16.

'ub-domain-defined-attribute-value-length'() ->
128.

'ub-domain-defined-attribute-type-length'() ->
8.

'ub-domain-defined-attributes'() ->
4.

'ub-country-name-numeric-length'() ->
3.

'ub-country-name-alpha-length'() ->
2.

'ub-emailaddress-length'() ->
255.

'ub-match'() ->
128.

'ub-serial-number'() ->
64.

'ub-title-utf8'() ->
256.

'ub-title-universal'() ->
256.

'ub-title-printable'() ->
128.

'ub-title-teletex'() ->
128.

'ub-title'() ->
64.

'ub-organizational-unit-name-utf8'() ->
256.

'ub-organizational-unit-name-universal'() ->
256.

'ub-organizational-unit-name-teletex'() ->
128.

'ub-organizational-unit-name-printable'() ->
128.

'ub-organizational-unit-name'() ->
64.

'ub-organization-name-utf8'() ->
256.

'ub-organization-name-universal'() ->
256.

'ub-organization-name-teletex'() ->
128.

'ub-organization-name-printable'() ->
128.

'ub-organization-name'() ->
64.

'ub-state-name-utf8'() ->
256.

'ub-state-name-universal'() ->
256.

'ub-state-name'() ->
128.

'ub-locality-name-universal'() ->
256.

'ub-locality-name-utf8'() ->
256.

'ub-locality-name'() ->
128.

'ub-common-name-utf8'() ->
256.

'ub-common-name-universal'() ->
256.

'ub-common-name-printable'() ->
128.

'ub-common-name-teletex'() ->
128.

'ub-common-name'() ->
64.

'ub-name-utf8'() ->
131072.

'ub-name-universal'() ->
131072.

'ub-name-printable'() ->
65536.

'ub-name-teletex'() ->
65536.

'ub-name'() ->
32768.

'teletex-domain-defined-attributes'() ->
6.

'terminal-type'() ->
23.

'extended-network-address'() ->
22.

'local-postal-attributes'() ->
21.

'unique-postal-name'() ->
20.

'poste-restante-address'() ->
19.

'post-office-box-address'() ->
18.

'street-address'() ->
17.

'unformatted-postal-address'() ->
16.

'extension-physical-delivery-address-components'() ->
15.

'physical-delivery-organization-name'() ->
14.

'physical-delivery-personal-name'() ->
13.

'extension-OR-address-components'() ->
12.

'physical-delivery-office-number'() ->
11.

'physical-delivery-office-name'() ->
10.

'postal-code'() ->
9.

'physical-delivery-country-name'() ->
8.

'pds-name'() ->
7.

'teletex-organizational-unit-names'() ->
5.

'teletex-personal-name'() ->
4.

'teletex-organization-name'() ->
3.

'teletex-common-name'() ->
2.

'common-name'() ->
1.

'id-emailAddress'() ->
{1,2,840,113549,1,9,1}.

'id-domainComponent'() ->
{0,9,2342,19200300,100,1,25}.

'id-at-pseudonym'() ->
{2,5,4,65}.

'id-at-serialNumber'() ->
{2,5,4,5}.

'id-at-countryName'() ->
{2,5,4,6}.

'id-at-dnQualifier'() ->
{2,5,4,46}.

'id-at-title'() ->
{2,5,4,12}.

'id-at-organizationalUnitName'() ->
{2,5,4,11}.

'id-at-organizationName'() ->
{2,5,4,10}.

'id-at-stateOrProvinceName'() ->
{2,5,4,8}.

'id-at-localityName'() ->
{2,5,4,7}.

'id-at-commonName'() ->
{2,5,4,3}.

'id-at-generationQualifier'() ->
{2,5,4,44}.

'id-at-initials'() ->
{2,5,4,43}.

'id-at-givenName'() ->
{2,5,4,42}.

'id-at-surname'() ->
{2,5,4,4}.

'id-at-name'() ->
{2,5,4,41}.

'id-at'() ->
{2,5,4}.

'id-ad-caRepository'() ->
{1,3,6,1,5,5,7,48,5}.

'id-ad-timeStamping'() ->
{1,3,6,1,5,5,7,48,3}.

'id-ad-caIssuers'() ->
{1,3,6,1,5,5,7,48,2}.

'id-ad-ocsp'() ->
{1,3,6,1,5,5,7,48,1}.

'id-qt-unotice'() ->
{1,3,6,1,5,5,7,2,2}.

'id-qt-cps'() ->
{1,3,6,1,5,5,7,2,1}.

'id-ad'() ->
{1,3,6,1,5,5,7,48}.

'id-kp'() ->
{1,3,6,1,5,5,7,3}.

'id-qt'() ->
{1,3,6,1,5,5,7,2}.

'id-pe'() ->
{1,3,6,1,5,5,7,1}.

'id-pkix'() ->
{1,3,6,1,5,5,7}.

'id-dsa-with-sha256'() ->
{2,16,840,1,101,3,4,3,2}.

'id-dsa-with-sha224'() ->
{2,16,840,1,101,3,4,3,1}.




%%================================
%%  recipientNonce
%%================================
enc_recipientNonce(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_recipientNonce('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]);
enc_recipientNonce('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_recipientNonce('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_recipientNonce('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_recipientNonce(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_recipientNonce('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]);
dec_recipientNonce('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_recipientNonce('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_recipientNonce('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  senderNonce
%%================================
enc_senderNonce(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_senderNonce('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]);
enc_senderNonce('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_senderNonce('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_senderNonce('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_senderNonce(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_senderNonce('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]);
dec_senderNonce('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_senderNonce('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_senderNonce('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  failInfo
%%================================
enc_failInfo(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_failInfo('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
enc_failInfo('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_failInfo('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_failInfo('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_failInfo(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_failInfo('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [19]))
end
;
dec_failInfo('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_failInfo('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_failInfo('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  pkiStatus
%%================================
enc_pkiStatus(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_pkiStatus('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
enc_pkiStatus('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_pkiStatus('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_pkiStatus('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_pkiStatus(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_pkiStatus('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [19]))
end
;
dec_pkiStatus('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_pkiStatus('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_pkiStatus('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  messageType
%%================================
enc_messageType(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_messageType('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
enc_messageType('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_messageType('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_messageType('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_messageType(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_messageType('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [19]))
end
;
dec_messageType('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_messageType('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_messageType('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  transactionID
%%================================
enc_transactionID(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_transactionID('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
enc_transactionID('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_transactionID('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_transactionID('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_transactionID(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_transactionID('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [19]))
end
;
dec_transactionID('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_transactionID('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_transactionID('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  signingTime
%%================================
enc_signingTime(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_signingTime('Type', Val, _RestPrimFieldName) ->
   enc_SigningTime(Val, []);
enc_signingTime('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_signingTime('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_signingTime('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_signingTime(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_signingTime('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SigningTime(Tlv, []);
dec_signingTime('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_signingTime('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_signingTime('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  messageDigest
%%================================
enc_messageDigest(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_messageDigest('Type', Val, _RestPrimFieldName) ->
   enc_MessageDigest(Val, [<<4>>]);
enc_messageDigest('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_messageDigest('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_messageDigest('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_messageDigest(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_messageDigest('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_MessageDigest(Tlv, [4]);
dec_messageDigest('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_messageDigest('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_messageDigest('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  counterSignature
%%================================
enc_counterSignature(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_counterSignature('Type', Val, _RestPrimFieldName) ->
   enc_SignerInfo(Val, [<<48>>]);
enc_counterSignature('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_counterSignature('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_counterSignature('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_counterSignature(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_counterSignature('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SignerInfo(Tlv, [16]);
dec_counterSignature('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_counterSignature('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_counterSignature('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  contentType
%%================================
enc_contentType(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_contentType('Type', Val, _RestPrimFieldName) ->
   enc_ContentType(Val, [<<6>>]);
enc_contentType('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_contentType('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_contentType('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_contentType(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_contentType('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ContentType(Tlv, [6]);
dec_contentType('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_contentType('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_contentType('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  extensionRequest
%%================================
enc_extensionRequest(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_extensionRequest('Type', Val, _RestPrimFieldName) ->
   enc_ExtensionRequest(Val, [<<48>>]);
enc_extensionRequest('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_extensionRequest('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_extensionRequest('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_extensionRequest(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_extensionRequest('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtensionRequest(Tlv, [16]);
dec_extensionRequest('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_extensionRequest('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_extensionRequest('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  challengePassword
%%================================
enc_challengePassword(derivation, _,_) ->
  exit({error,{'use of missing field in object', derivation}});
enc_challengePassword('Type', Val, _RestPrimFieldName) ->
   enc_DirectoryString(Val, []);
enc_challengePassword('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}});
enc_challengePassword('ordering-match', _,_) ->
  exit({error,{'use of missing field in object', 'ordering-match'}});
enc_challengePassword('substrings-match', _,_) ->
  exit({error,{'use of missing field in object', 'substrings-match'}}).


dec_challengePassword(derivation, _,_) ->
  exit({error,{'illegal use of missing field in object', derivation}});
dec_challengePassword('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DirectoryString(Tlv, []);
dec_challengePassword('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}});
dec_challengePassword('ordering-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'ordering-match'}});
dec_challengePassword('substrings-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'substrings-match'}}).




%%================================
%%  invalidityDate
%%================================
enc_invalidityDate('Type', Val, _RestPrimFieldName) ->
   enc_InvalidityDate(Val, [<<24>>]).


dec_invalidityDate('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_InvalidityDate(Tlv, [24]).




%%================================
%%  holdInstructionCode
%%================================
enc_holdInstructionCode('Type', Val, _RestPrimFieldName) ->
   enc_HoldInstructionCode(Val, [<<6>>]).


dec_holdInstructionCode('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_HoldInstructionCode(Tlv, [6]).




%%================================
%%  certificateIssuer
%%================================
enc_certificateIssuer('Type', Val, _RestPrimFieldName) ->
   enc_CertificateIssuer(Val, [<<48>>]).


dec_certificateIssuer('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CertificateIssuer(Tlv, [16]).




%%================================
%%  cRLReasons
%%================================
enc_cRLReasons('Type', Val, _RestPrimFieldName) ->
   enc_CRLReason(Val, [<<10>>]).


dec_cRLReasons('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLReason(Tlv, [10]).




%%================================
%%  deltaCRLIndicator
%%================================
enc_deltaCRLIndicator('Type', Val, _RestPrimFieldName) ->
   enc_BaseCRLNumber(Val, [<<2>>]).


dec_deltaCRLIndicator('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_BaseCRLNumber(Tlv, [2]).




%%================================
%%  issuingDistributionPoint
%%================================
enc_issuingDistributionPoint('Type', Val, _RestPrimFieldName) ->
   enc_IssuingDistributionPoint(Val, [<<48>>]).


dec_issuingDistributionPoint('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IssuingDistributionPoint(Tlv, [16]).




%%================================
%%  cRLNumber
%%================================
enc_cRLNumber('Type', Val, _RestPrimFieldName) ->
   enc_CRLNumber(Val, [<<2>>]).


dec_cRLNumber('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLNumber(Tlv, [2]).




%%================================
%%  subjectInfoAccess
%%================================
enc_subjectInfoAccess('Type', Val, _RestPrimFieldName) ->
   enc_SubjectInfoAccessSyntax(Val, [<<48>>]).


dec_subjectInfoAccess('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SubjectInfoAccessSyntax(Tlv, [16]).




%%================================
%%  authorityInfoAccess
%%================================
enc_authorityInfoAccess('Type', Val, _RestPrimFieldName) ->
   enc_AuthorityInfoAccessSyntax(Val, [<<48>>]).


dec_authorityInfoAccess('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AuthorityInfoAccessSyntax(Tlv, [16]).




%%================================
%%  freshestCRL
%%================================
enc_freshestCRL('Type', Val, _RestPrimFieldName) ->
   enc_FreshestCRL(Val, [<<48>>]).


dec_freshestCRL('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_FreshestCRL(Tlv, [16]).




%%================================
%%  inhibitAnyPolicy
%%================================
enc_inhibitAnyPolicy('Type', Val, _RestPrimFieldName) ->
   enc_InhibitAnyPolicy(Val, [<<2>>]).


dec_inhibitAnyPolicy('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_InhibitAnyPolicy(Tlv, [2]).




%%================================
%%  extKeyUsage
%%================================
enc_extKeyUsage('Type', Val, _RestPrimFieldName) ->
   enc_ExtKeyUsageSyntax(Val, [<<48>>]).


dec_extKeyUsage('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtKeyUsageSyntax(Tlv, [16]).




%%================================
%%  cRLDistributionPoints
%%================================
enc_cRLDistributionPoints('Type', Val, _RestPrimFieldName) ->
   enc_CRLDistributionPoints(Val, [<<48>>]).


dec_cRLDistributionPoints('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLDistributionPoints(Tlv, [16]).




%%================================
%%  policyConstraints
%%================================
enc_policyConstraints('Type', Val, _RestPrimFieldName) ->
   enc_PolicyConstraints(Val, [<<48>>]).


dec_policyConstraints('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PolicyConstraints(Tlv, [16]).




%%================================
%%  nameConstraints
%%================================
enc_nameConstraints('Type', Val, _RestPrimFieldName) ->
   enc_NameConstraints(Val, [<<48>>]).


dec_nameConstraints('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_NameConstraints(Tlv, [16]).




%%================================
%%  basicConstraints
%%================================
enc_basicConstraints('Type', Val, _RestPrimFieldName) ->
   enc_BasicConstraints(Val, [<<48>>]).


dec_basicConstraints('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_BasicConstraints(Tlv, [16]).




%%================================
%%  subjectDirectoryAttributes
%%================================
enc_subjectDirectoryAttributes('Type', Val, _RestPrimFieldName) ->
   enc_SubjectDirectoryAttributes(Val, [<<48>>]).


dec_subjectDirectoryAttributes('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SubjectDirectoryAttributes(Tlv, [16]).




%%================================
%%  issuerAltName
%%================================
enc_issuerAltName('Type', Val, _RestPrimFieldName) ->
   enc_IssuerAltName(Val, [<<48>>]).


dec_issuerAltName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IssuerAltName(Tlv, [16]).




%%================================
%%  subjectAltName
%%================================
enc_subjectAltName('Type', Val, _RestPrimFieldName) ->
   enc_SubjectAltName(Val, [<<48>>]).


dec_subjectAltName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SubjectAltName(Tlv, [16]).




%%================================
%%  policyMappings
%%================================
enc_policyMappings('Type', Val, _RestPrimFieldName) ->
   enc_PolicyMappings(Val, [<<48>>]).


dec_policyMappings('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PolicyMappings(Tlv, [16]).




%%================================
%%  certificatePolicies
%%================================
enc_certificatePolicies('Type', Val, _RestPrimFieldName) ->
   enc_CertificatePolicies(Val, [<<48>>]).


dec_certificatePolicies('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CertificatePolicies(Tlv, [16]).




%%================================
%%  privateKeyUsagePeriod
%%================================
enc_privateKeyUsagePeriod('Type', Val, _RestPrimFieldName) ->
   enc_PrivateKeyUsagePeriod(Val, [<<48>>]).


dec_privateKeyUsagePeriod('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PrivateKeyUsagePeriod(Tlv, [16]).




%%================================
%%  keyUsage
%%================================
enc_keyUsage('Type', Val, _RestPrimFieldName) ->
   enc_KeyUsage(Val, [<<3>>]).


dec_keyUsage('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyUsage(Tlv, [3]).




%%================================
%%  subjectKeyIdentifier
%%================================
enc_subjectKeyIdentifier('Type', Val, _RestPrimFieldName) ->
   enc_SubjectKeyIdentifier(Val, [<<4>>]).


dec_subjectKeyIdentifier('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SubjectKeyIdentifier(Tlv, [4]).




%%================================
%%  authorityKeyIdentifier
%%================================
enc_authorityKeyIdentifier('Type', Val, _RestPrimFieldName) ->
   enc_AuthorityKeyIdentifier(Val, [<<48>>]).


dec_authorityKeyIdentifier('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AuthorityKeyIdentifier(Tlv, [16]).




%%================================
%%  x400-teletex-domain-defined-attributes
%%================================
'enc_x400-teletex-domain-defined-attributes'('Type', Val, _RestPrimFieldName) ->
   enc_TeletexDomainDefinedAttributes(Val, [<<48>>]).


'dec_x400-teletex-domain-defined-attributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_TeletexDomainDefinedAttributes(Tlv, [16]).




%%================================
%%  x400-terminal-type
%%================================
'enc_x400-terminal-type'('Type', Val, _RestPrimFieldName) ->
   enc_TerminalType(Val, [<<2>>]).


'dec_x400-terminal-type'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_TerminalType(Tlv, [2]).




%%================================
%%  x400-extended-network-address
%%================================
'enc_x400-extended-network-address'('Type', Val, _RestPrimFieldName) ->
   enc_ExtendedNetworkAddress(Val, []).


'dec_x400-extended-network-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtendedNetworkAddress(Tlv, []).




%%================================
%%  x400-local-postal-attributes
%%================================
'enc_x400-local-postal-attributes'('Type', Val, _RestPrimFieldName) ->
   enc_LocalPostalAttributes(Val, [<<49>>]).


'dec_x400-local-postal-attributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_LocalPostalAttributes(Tlv, [17]).




%%================================
%%  x400-unique-postal-name
%%================================
'enc_x400-unique-postal-name'('Type', Val, _RestPrimFieldName) ->
   enc_UniquePostalName(Val, [<<49>>]).


'dec_x400-unique-postal-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_UniquePostalName(Tlv, [17]).




%%================================
%%  x400-poste-restante-address
%%================================
'enc_x400-poste-restante-address'('Type', Val, _RestPrimFieldName) ->
   enc_PosteRestanteAddress(Val, [<<49>>]).


'dec_x400-poste-restante-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PosteRestanteAddress(Tlv, [17]).




%%================================
%%  x400-post-office-box-address
%%================================
'enc_x400-post-office-box-address'('Type', Val, _RestPrimFieldName) ->
   enc_PostOfficeBoxAddress(Val, [<<49>>]).


'dec_x400-post-office-box-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PostOfficeBoxAddress(Tlv, [17]).




%%================================
%%  x400-street-address
%%================================
'enc_x400-street-address'('Type', Val, _RestPrimFieldName) ->
   enc_StreetAddress(Val, [<<49>>]).


'dec_x400-street-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_StreetAddress(Tlv, [17]).




%%================================
%%  x400-unformatted-postal-address
%%================================
'enc_x400-unformatted-postal-address'('Type', Val, _RestPrimFieldName) ->
   enc_UnformattedPostalAddress(Val, [<<49>>]).


'dec_x400-unformatted-postal-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_UnformattedPostalAddress(Tlv, [17]).




%%================================
%%  x400-extension-physical-delivery-address-components
%%================================
'enc_x400-extension-physical-delivery-address-components'('Type', Val, _RestPrimFieldName) ->
   enc_ExtensionPhysicalDeliveryAddressComponents(Val, [<<49>>]).


'dec_x400-extension-physical-delivery-address-components'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtensionPhysicalDeliveryAddressComponents(Tlv, [17]).




%%================================
%%  x400-physical-delivery-organization-name
%%================================
'enc_x400-physical-delivery-organization-name'('Type', Val, _RestPrimFieldName) ->
   enc_PhysicalDeliveryOrganizationName(Val, [<<49>>]).


'dec_x400-physical-delivery-organization-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PhysicalDeliveryOrganizationName(Tlv, [17]).




%%================================
%%  x400-physical-delivery-personal-name
%%================================
'enc_x400-physical-delivery-personal-name'('Type', Val, _RestPrimFieldName) ->
   enc_PhysicalDeliveryPersonalName(Val, [<<49>>]).


'dec_x400-physical-delivery-personal-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PhysicalDeliveryPersonalName(Tlv, [17]).




%%================================
%%  x400-extension-OR-address-components
%%================================
'enc_x400-extension-OR-address-components'('Type', Val, _RestPrimFieldName) ->
   enc_ExtensionORAddressComponents(Val, [<<49>>]).


'dec_x400-extension-OR-address-components'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtensionORAddressComponents(Tlv, [17]).




%%================================
%%  x400-physical-delivery-office-number
%%================================
'enc_x400-physical-delivery-office-number'('Type', Val, _RestPrimFieldName) ->
   enc_PhysicalDeliveryOfficeNumber(Val, [<<49>>]).


'dec_x400-physical-delivery-office-number'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PhysicalDeliveryOfficeNumber(Tlv, [17]).




%%================================
%%  x400-physical-delivery-office-name
%%================================
'enc_x400-physical-delivery-office-name'('Type', Val, _RestPrimFieldName) ->
   enc_PhysicalDeliveryOfficeName(Val, [<<49>>]).


'dec_x400-physical-delivery-office-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PhysicalDeliveryOfficeName(Tlv, [17]).




%%================================
%%  x400-postal-code
%%================================
'enc_x400-postal-code'('Type', Val, _RestPrimFieldName) ->
   enc_PostalCode(Val, []).


'dec_x400-postal-code'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PostalCode(Tlv, []).




%%================================
%%  x400-physical-delivery-country-name
%%================================
'enc_x400-physical-delivery-country-name'('Type', Val, _RestPrimFieldName) ->
   enc_PhysicalDeliveryCountryName(Val, []).


'dec_x400-physical-delivery-country-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PhysicalDeliveryCountryName(Tlv, []).




%%================================
%%  x400-pds-name
%%================================
'enc_x400-pds-name'('Type', Val, _RestPrimFieldName) ->
   enc_PDSName(Val, [<<19>>]).


'dec_x400-pds-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PDSName(Tlv, [19]).




%%================================
%%  x400-teletex-personal-name
%%================================
'enc_x400-teletex-personal-name'('Type', Val, _RestPrimFieldName) ->
   enc_TeletexPersonalName(Val, [<<49>>]).


'dec_x400-teletex-personal-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_TeletexPersonalName(Tlv, [17]).




%%================================
%%  x400-teletex-common-name
%%================================
'enc_x400-teletex-common-name'('Type', Val, _RestPrimFieldName) ->
   enc_TeletexCommonName(Val, [<<20>>]).


'dec_x400-teletex-common-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_TeletexCommonName(Tlv, [20]).




%%================================
%%  x400-common-name
%%================================
'enc_x400-common-name'('Type', Val, _RestPrimFieldName) ->
   enc_CommonName(Val, [<<19>>]).


'dec_x400-common-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CommonName(Tlv, [19]).




%%================================
%%  ec-public-key
%%================================
'enc_ec-public-key'('Type', Val, _RestPrimFieldName) ->
   enc_EcpkParameters(Val, []);
'enc_ec-public-key'('PublicKeyType', Val, _RestPrimFieldName) ->
   enc_ECPoint(Val, [<<4>>]).


'dec_ec-public-key'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EcpkParameters(Tlv, []);
'dec_ec-public-key'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECPoint(Tlv, [4]).




%%================================
%%  pp-basis
%%================================
'enc_pp-basis'('Type', Val, _RestPrimFieldName) ->
   enc_Pentanomial(Val, [<<48>>]).


'dec_pp-basis'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Pentanomial(Tlv, [16]).




%%================================
%%  tp-basis
%%================================
'enc_tp-basis'('Type', Val, _RestPrimFieldName) ->
   enc_Trinomial(Val, [<<2>>]).


'dec_tp-basis'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Trinomial(Tlv, [2]).




%%================================
%%  gn-basis
%%================================
'enc_gn-basis'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_gn-basis'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  field-characteristic-two
%%================================
'enc_field-characteristic-two'('Type', Val, _RestPrimFieldName) ->
   'enc_Characteristic-two'(Val, [<<48>>]).


'dec_field-characteristic-two'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_Characteristic-two'(Tlv, [16]).




%%================================
%%  field-prime-field
%%================================
'enc_field-prime-field'('Type', Val, _RestPrimFieldName) ->
   'enc_Prime-p'(Val, [<<2>>]).


'dec_field-prime-field'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_Prime-p'(Tlv, [2]).




%%================================
%%  ecdsa-with-sha512
%%================================
'enc_ecdsa-with-sha512'('Type', Val, _RestPrimFieldName) ->
   enc_EcpkParameters(Val, []).


'dec_ecdsa-with-sha512'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EcpkParameters(Tlv, []).




%%================================
%%  ecdsa-with-sha384
%%================================
'enc_ecdsa-with-sha384'('Type', Val, _RestPrimFieldName) ->
   enc_EcpkParameters(Val, []).


'dec_ecdsa-with-sha384'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EcpkParameters(Tlv, []).




%%================================
%%  ecdsa-with-sha256
%%================================
'enc_ecdsa-with-sha256'('Type', Val, _RestPrimFieldName) ->
   enc_EcpkParameters(Val, []).


'dec_ecdsa-with-sha256'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EcpkParameters(Tlv, []).




%%================================
%%  ecdsa-with-sha224
%%================================
'enc_ecdsa-with-sha224'('Type', Val, _RestPrimFieldName) ->
   enc_EcpkParameters(Val, []).


'dec_ecdsa-with-sha224'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EcpkParameters(Tlv, []).




%%================================
%%  ecdsa-with-sha1
%%================================
'enc_ecdsa-with-sha1'('Type', Val, _RestPrimFieldName) ->
   enc_EcpkParameters(Val, []).


'dec_ecdsa-with-sha1'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EcpkParameters(Tlv, []).




%%================================
%%  kea
%%================================
enc_kea('Type', Val, _RestPrimFieldName) ->
   'enc_KEA-Parms-Id'(Val, [<<4>>]);
enc_kea('PublicKeyType', Val, _RestPrimFieldName) ->
   'enc_KEA-PublicKey'(Val, [<<2>>]).


dec_kea('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_KEA-Parms-Id'(Tlv, [4]);
dec_kea('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_KEA-PublicKey'(Tlv, [2]).




%%================================
%%  dh
%%================================
enc_dh('Type', Val, _RestPrimFieldName) ->
   enc_DomainParameters(Val, [<<48>>]);
enc_dh('PublicKeyType', Val, _RestPrimFieldName) ->
   enc_DHPublicKey(Val, [<<2>>]).


dec_dh('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DomainParameters(Tlv, [16]);
dec_dh('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DHPublicKey(Tlv, [2]).




%%================================
%%  rsa-pss
%%================================
'enc_rsa-pss'('Type', Val, _RestPrimFieldName) ->
   'enc_RSASSA-PSS-params'(Val, [<<48>>]);
'enc_rsa-pss'('PublicKeyType', Val, _RestPrimFieldName) ->
   enc_RSAPublicKey(Val, [<<48>>]).


'dec_rsa-pss'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSASSA-PSS-params'(Tlv, [16]);
'dec_rsa-pss'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RSAPublicKey(Tlv, [16]).




%%================================
%%  rsa-encryption
%%================================
'enc_rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_rsa-encryption'('PublicKeyType', Val, _RestPrimFieldName) ->
   enc_RSAPublicKey(Val, [<<48>>]).


'dec_rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_rsa-encryption'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RSAPublicKey(Tlv, [16]).




%%================================
%%  rsassa-pss
%%================================
'enc_rsassa-pss'('Type', Val, _RestPrimFieldName) ->
   'enc_RSASSA-PSS-params'(Val, [<<48>>]).


'dec_rsassa-pss'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSASSA-PSS-params'(Tlv, [16]).




%%================================
%%  sha512-with-rsa-encryption
%%================================
'enc_sha512-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_sha512-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sha384-with-rsa-encryption
%%================================
'enc_sha384-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_sha384-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sha256-with-rsa-encryption
%%================================
'enc_sha256-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_sha256-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sha224-with-rsa-encryption
%%================================
'enc_sha224-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_sha224-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sha-1with-rsa-encryption
%%================================
'enc_sha-1with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_sha-1with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sha1-with-rsa-encryption
%%================================
'enc_sha1-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_sha1-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  md5-with-rsa-encryption
%%================================
'enc_md5-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_md5-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  md2-with-rsa-encryption
%%================================
'enc_md2-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_md2-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  dsa-with-sha256
%%================================
'enc_dsa-with-sha256'('Type', Val, _RestPrimFieldName) ->
   enc_DSAParams(Val, []).


'dec_dsa-with-sha256'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAParams(Tlv, []).




%%================================
%%  dsa-with-sha224
%%================================
'enc_dsa-with-sha224'('Type', Val, _RestPrimFieldName) ->
   enc_DSAParams(Val, []).


'dec_dsa-with-sha224'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAParams(Tlv, []).




%%================================
%%  dsaWithSHA1
%%================================
enc_dsaWithSHA1('Type', Val, _RestPrimFieldName) ->
   enc_DSAParams(Val, []).


dec_dsaWithSHA1('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAParams(Tlv, []).




%%================================
%%  dsa-with-sha1
%%================================
'enc_dsa-with-sha1'('Type', Val, _RestPrimFieldName) ->
   enc_DSAParams(Val, []).


'dec_dsa-with-sha1'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAParams(Tlv, []).




%%================================
%%  dsa
%%================================
enc_dsa('Type', Val, _RestPrimFieldName) ->
   enc_DSAParams(Val, []);
enc_dsa('PublicKeyType', Val, _RestPrimFieldName) ->
   enc_DSAPublicKey(Val, [<<2>>]).


dec_dsa('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAParams(Tlv, []);
dec_dsa('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAPublicKey(Tlv, [2]).




%%================================
%%  emailAddress
%%================================
enc_emailAddress('Type', Val, _RestPrimFieldName) ->
   enc_EmailAddress(Val, [<<22>>]).


dec_emailAddress('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EmailAddress(Tlv, [22]).




%%================================
%%  domainComponent
%%================================
enc_domainComponent('Type', Val, _RestPrimFieldName) ->
   enc_DomainComponent(Val, [<<22>>]).


dec_domainComponent('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DomainComponent(Tlv, [22]).




%%================================
%%  pseudonym
%%================================
enc_pseudonym('Type', Val, _RestPrimFieldName) ->
   enc_X520Pseudonym(Val, []).


dec_pseudonym('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520Pseudonym(Tlv, []).




%%================================
%%  serialNumber
%%================================
enc_serialNumber('Type', Val, _RestPrimFieldName) ->
   enc_X520SerialNumber(Val, [<<19>>]).


dec_serialNumber('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520SerialNumber(Tlv, [19]).




%%================================
%%  countryName
%%================================
enc_countryName('Type', Val, _RestPrimFieldName) ->
   enc_X520countryName(Val, [<<19>>]).


dec_countryName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520countryName(Tlv, [19]).




%%================================
%%  dnQualifier
%%================================
enc_dnQualifier('Type', Val, _RestPrimFieldName) ->
   enc_X520dnQualifier(Val, [<<19>>]).


dec_dnQualifier('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520dnQualifier(Tlv, [19]).




%%================================
%%  title
%%================================
enc_title('Type', Val, _RestPrimFieldName) ->
   enc_X520Title(Val, []).


dec_title('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520Title(Tlv, []).




%%================================
%%  organizationalUnitName
%%================================
enc_organizationalUnitName('Type', Val, _RestPrimFieldName) ->
   enc_X520OrganizationalUnitName(Val, []).


dec_organizationalUnitName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520OrganizationalUnitName(Tlv, []).




%%================================
%%  organizationName
%%================================
enc_organizationName('Type', Val, _RestPrimFieldName) ->
   enc_X520OrganizationName(Val, []).


dec_organizationName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520OrganizationName(Tlv, []).




%%================================
%%  stateOrProvinceName
%%================================
enc_stateOrProvinceName('Type', Val, _RestPrimFieldName) ->
   enc_X520StateOrProvinceName(Val, []).


dec_stateOrProvinceName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520StateOrProvinceName(Tlv, []).




%%================================
%%  localityName
%%================================
enc_localityName('Type', Val, _RestPrimFieldName) ->
   enc_X520LocalityName(Val, []).


dec_localityName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520LocalityName(Tlv, []).




%%================================
%%  commonName
%%================================
enc_commonName('Type', Val, _RestPrimFieldName) ->
   enc_X520CommonName(Val, []).


dec_commonName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520CommonName(Tlv, []).




%%================================
%%  generationQualifier
%%================================
enc_generationQualifier('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []).


dec_generationQualifier('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []).




%%================================
%%  initials
%%================================
enc_initials('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []).


dec_initials('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []).




%%================================
%%  givenName
%%================================
enc_givenName('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []).


dec_givenName('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []).




%%================================
%%  surname
%%================================
enc_surname('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []).


dec_surname('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []).




%%================================
%%  name
%%================================
enc_name('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []).


dec_name('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []).




%%================================
%%  PKCS1Algorithms
%%================================
getenc_PKCS1Algorithms({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSASSA-PSS-params'(Val)
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSASSA-PSS-params'(Bytes)
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_PKCS1Algorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKCS1PSourceAlgorithms
%%================================
getenc_PKCS1PSourceAlgorithms({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_PKCS1PSourceAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1PSourceAlgorithms'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
getdec_PKCS1PSourceAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKCS1MGFAlgorithms
%%================================
getenc_PKCS1MGFAlgorithms({1,2,840,113549,1,1,8}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_HashAlgorithm'(Val)
      end
   end;
getenc_PKCS1MGFAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1MGFAlgorithms'({1,2,840,113549,1,1,8}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_HashAlgorithm'(Bytes)
      end
   end;
getdec_PKCS1MGFAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKCS1-v1-5DigestAlgorithms
%%================================
'getenc_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  OAEP-PSSDigestAlgorithms
%%================================
'getenc_OAEP-PSSDigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_OAEP-PSSDigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  Unauthenticated
%%================================
getenc_Unauthenticated(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun enc_contentType/3;
getenc_Unauthenticated(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun enc_messageDigest/3;
getenc_Unauthenticated(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun enc_counterSignature/3;
getenc_Unauthenticated(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_Unauthenticated(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_contentType'/3;
getdec_Unauthenticated(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_messageDigest'/3;
getdec_Unauthenticated(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'dec_counterSignature'/3;
getdec_Unauthenticated(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  Authenticated
%%================================
getenc_Authenticated(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun enc_contentType/3;
getenc_Authenticated(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun enc_messageDigest/3;
getenc_Authenticated(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun enc_signingTime/3;
getenc_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,2} ->
    fun enc_messageType/3;
getenc_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,3} ->
    fun enc_pkiStatus/3;
getenc_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,4} ->
    fun enc_failInfo/3;
getenc_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,5} ->
    fun enc_senderNonce/3;
getenc_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,6} ->
    fun enc_recipientNonce/3;
getenc_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,7} ->
    fun enc_transactionID/3;
getenc_Authenticated(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_Authenticated(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_contentType'/3;
getdec_Authenticated(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_messageDigest'/3;
getdec_Authenticated(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_signingTime'/3;
getdec_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,2} ->
    fun 'dec_messageType'/3;
getdec_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,3} ->
    fun 'dec_pkiStatus'/3;
getdec_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,4} ->
    fun 'dec_failInfo'/3;
getdec_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,5} ->
    fun 'dec_senderNonce'/3;
getdec_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,6} ->
    fun 'dec_recipientNonce'/3;
getdec_Authenticated(Id) when Id =:= {2,16,840,1,113733,1,9,7} ->
    fun 'dec_transactionID'/3;
getdec_Authenticated(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  Contents
%%================================
getenc_Contents({1,2,840,113549,1,7,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_Data'(Val)
      end
   end;
getenc_Contents({1,2,840,113549,1,7,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_SignedData'(Val)
      end
   end;
getenc_Contents({1,2,840,113549,1,7,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EnvelopedData'(Val)
      end
   end;
getenc_Contents({1,2,840,113549,1,7,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_SignedAndEnvelopedData'(Val)
      end
   end;
getenc_Contents({1,2,840,113549,1,7,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_DigestedData'(Val)
      end
   end;
getenc_Contents({1,2,840,113549,1,7,6}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncryptedData'(Val)
      end
   end;
getenc_Contents(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_Contents'({1,2,840,113549,1,7,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_Data'(Bytes)
      end
   end;
'getdec_Contents'({1,2,840,113549,1,7,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_SignedData'(Bytes)
      end
   end;
'getdec_Contents'({1,2,840,113549,1,7,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EnvelopedData'(Bytes)
      end
   end;
'getdec_Contents'({1,2,840,113549,1,7,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_SignedAndEnvelopedData'(Bytes)
      end
   end;
'getdec_Contents'({1,2,840,113549,1,7,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_DigestedData'(Bytes)
      end
   end;
'getdec_Contents'({1,2,840,113549,1,7,6}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncryptedData'(Bytes)
      end
   end;
getdec_Contents(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyEncryptionAlgorithms
%%================================
getenc_KeyEncryptionAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyEncryptionAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  DigestEncryptionAlgorithms
%%================================
getenc_DigestEncryptionAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_DigestEncryptionAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  DigestAlgorithms
%%================================
getenc_DigestAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_DigestAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  ContentEncryptionAlgorithms
%%================================
getenc_ContentEncryptionAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ContentEncryptionAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgorithms
%%================================
getenc_SignatureAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  CRIAttributes
%%================================
getenc_CRIAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_CRIAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKInfoAlgorithms
%%================================
getenc_PKInfoAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PKInfoAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedExtensions
%%================================
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,9} ->
    fun enc_subjectDirectoryAttributes/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,14} ->
    fun enc_subjectKeyIdentifier/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,15} ->
    fun enc_keyUsage/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,16} ->
    fun enc_privateKeyUsagePeriod/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,17} ->
    fun enc_subjectAltName/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,18} ->
    fun enc_issuerAltName/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,19} ->
    fun enc_basicConstraints/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,20} ->
    fun enc_cRLNumber/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,21} ->
    fun enc_cRLReasons/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,23} ->
    fun enc_holdInstructionCode/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,24} ->
    fun enc_invalidityDate/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,27} ->
    fun enc_deltaCRLIndicator/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,28} ->
    fun enc_issuingDistributionPoint/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,29} ->
    fun enc_certificateIssuer/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,30} ->
    fun enc_nameConstraints/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,31} ->
    fun enc_cRLDistributionPoints/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,32} ->
    fun enc_certificatePolicies/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,33} ->
    fun enc_policyMappings/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,35} ->
    fun enc_authorityKeyIdentifier/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,36} ->
    fun enc_policyConstraints/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,37} ->
    fun enc_extKeyUsage/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,46} ->
    fun enc_freshestCRL/3;
getenc_SupportedExtensions(Id) when Id =:= {2,5,29,54} ->
    fun enc_inhibitAnyPolicy/3;
getenc_SupportedExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
    fun enc_authorityInfoAccess/3;
getenc_SupportedExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
    fun enc_subjectInfoAccess/3;
getenc_SupportedExtensions(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedExtensions(Id) when Id =:= {2,5,29,9} ->
    fun 'dec_subjectDirectoryAttributes'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,14} ->
    fun 'dec_subjectKeyIdentifier'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,15} ->
    fun 'dec_keyUsage'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,16} ->
    fun 'dec_privateKeyUsagePeriod'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,17} ->
    fun 'dec_subjectAltName'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,18} ->
    fun 'dec_issuerAltName'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,19} ->
    fun 'dec_basicConstraints'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,20} ->
    fun 'dec_cRLNumber'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,21} ->
    fun 'dec_cRLReasons'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,23} ->
    fun 'dec_holdInstructionCode'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,24} ->
    fun 'dec_invalidityDate'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,27} ->
    fun 'dec_deltaCRLIndicator'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,28} ->
    fun 'dec_issuingDistributionPoint'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,29} ->
    fun 'dec_certificateIssuer'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,30} ->
    fun 'dec_nameConstraints'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,31} ->
    fun 'dec_cRLDistributionPoints'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,32} ->
    fun 'dec_certificatePolicies'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,33} ->
    fun 'dec_policyMappings'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,35} ->
    fun 'dec_authorityKeyIdentifier'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,36} ->
    fun 'dec_policyConstraints'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,37} ->
    fun 'dec_extKeyUsage'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,46} ->
    fun 'dec_freshestCRL'/3;
getdec_SupportedExtensions(Id) when Id =:= {2,5,29,54} ->
    fun 'dec_inhibitAnyPolicy'/3;
getdec_SupportedExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
    fun 'dec_authorityInfoAccess'/3;
getdec_SupportedExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
    fun 'dec_subjectInfoAccess'/3;
'getdec_SupportedExtensions'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  SupportedExtensionAttributes
%%================================
getenc_SupportedExtensionAttributes(Id) when Id =:= 1 ->
    fun 'enc_x400-common-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 2 ->
    fun 'enc_x400-teletex-common-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 4 ->
    fun 'enc_x400-teletex-personal-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 6 ->
    fun 'enc_x400-teletex-domain-defined-attributes'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 7 ->
    fun 'enc_x400-pds-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 8 ->
    fun 'enc_x400-physical-delivery-country-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 9 ->
    fun 'enc_x400-postal-code'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 10 ->
    fun 'enc_x400-physical-delivery-office-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 11 ->
    fun 'enc_x400-physical-delivery-office-number'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 12 ->
    fun 'enc_x400-extension-OR-address-components'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 13 ->
    fun 'enc_x400-physical-delivery-personal-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 14 ->
    fun 'enc_x400-physical-delivery-organization-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 15 ->
    fun 'enc_x400-extension-physical-delivery-address-components'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 16 ->
    fun 'enc_x400-unformatted-postal-address'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 17 ->
    fun 'enc_x400-street-address'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 18 ->
    fun 'enc_x400-post-office-box-address'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 19 ->
    fun 'enc_x400-poste-restante-address'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 20 ->
    fun 'enc_x400-unique-postal-name'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 21 ->
    fun 'enc_x400-local-postal-attributes'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 22 ->
    fun 'enc_x400-extended-network-address'/3;
getenc_SupportedExtensionAttributes(Id) when Id =:= 23 ->
    fun 'enc_x400-terminal-type'/3;
getenc_SupportedExtensionAttributes(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedExtensionAttributes(Id) when Id =:= 1 ->
    fun 'dec_x400-common-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 2 ->
    fun 'dec_x400-teletex-common-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 4 ->
    fun 'dec_x400-teletex-personal-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 6 ->
    fun 'dec_x400-teletex-domain-defined-attributes'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 7 ->
    fun 'dec_x400-pds-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 8 ->
    fun 'dec_x400-physical-delivery-country-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 9 ->
    fun 'dec_x400-postal-code'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 10 ->
    fun 'dec_x400-physical-delivery-office-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 11 ->
    fun 'dec_x400-physical-delivery-office-number'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 12 ->
    fun 'dec_x400-extension-OR-address-components'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 13 ->
    fun 'dec_x400-physical-delivery-personal-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 14 ->
    fun 'dec_x400-physical-delivery-organization-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 15 ->
    fun 'dec_x400-extension-physical-delivery-address-components'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 16 ->
    fun 'dec_x400-unformatted-postal-address'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 17 ->
    fun 'dec_x400-street-address'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 18 ->
    fun 'dec_x400-post-office-box-address'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 19 ->
    fun 'dec_x400-poste-restante-address'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 20 ->
    fun 'dec_x400-unique-postal-name'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 21 ->
    fun 'dec_x400-local-postal-attributes'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 22 ->
    fun 'dec_x400-extended-network-address'/3;
getdec_SupportedExtensionAttributes(Id) when Id =:= 23 ->
    fun 'dec_x400-terminal-type'/3;
'getdec_SupportedExtensionAttributes'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  SupportedCharacteristicTwos
%%================================
getenc_SupportedCharacteristicTwos(Id) when Id =:= {1,2,840,10045,1,2,3,1} ->
    fun 'enc_gn-basis'/3;
getenc_SupportedCharacteristicTwos(Id) when Id =:= {1,2,840,10045,1,2,3,2} ->
    fun 'enc_tp-basis'/3;
getenc_SupportedCharacteristicTwos(Id) when Id =:= {1,2,840,10045,1,2,3,3} ->
    fun 'enc_pp-basis'/3;
getenc_SupportedCharacteristicTwos(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedCharacteristicTwos(Id) when Id =:= {1,2,840,10045,1,2,3,1} ->
    fun 'dec_gn-basis'/3;
getdec_SupportedCharacteristicTwos(Id) when Id =:= {1,2,840,10045,1,2,3,2} ->
    fun 'dec_tp-basis'/3;
getdec_SupportedCharacteristicTwos(Id) when Id =:= {1,2,840,10045,1,2,3,3} ->
    fun 'dec_pp-basis'/3;
'getdec_SupportedCharacteristicTwos'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  SupportedFieldIds
%%================================
getenc_SupportedFieldIds(Id) when Id =:= {1,2,840,10045,1,1} ->
    fun 'enc_field-prime-field'/3;
getenc_SupportedFieldIds(Id) when Id =:= {1,2,840,10045,1,2} ->
    fun 'enc_field-characteristic-two'/3;
getenc_SupportedFieldIds(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedFieldIds(Id) when Id =:= {1,2,840,10045,1,1} ->
    fun 'dec_field-prime-field'/3;
getdec_SupportedFieldIds(Id) when Id =:= {1,2,840,10045,1,2} ->
    fun 'dec_field-characteristic-two'/3;
'getdec_SupportedFieldIds'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  SupportedPublicKeyAlgorithms
%%================================
getenc_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,10040,4,1} ->
    fun enc_dsa/3;
getenc_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,10045,2,1} ->
    fun 'enc_ec-public-key'/3;
getenc_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,10046,2,1} ->
    fun enc_dh/3;
getenc_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,1} ->
    fun 'enc_rsa-encryption'/3;
getenc_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'enc_rsa-pss'/3;
getenc_SupportedPublicKeyAlgorithms(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
    fun enc_kea/3;
getenc_SupportedPublicKeyAlgorithms(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,10040,4,1} ->
    fun 'dec_dsa'/3;
getdec_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,10045,2,1} ->
    fun 'dec_ec-public-key'/3;
getdec_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,10046,2,1} ->
    fun 'dec_dh'/3;
getdec_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,1} ->
    fun 'dec_rsa-encryption'/3;
getdec_SupportedPublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'dec_rsa-pss'/3;
getdec_SupportedPublicKeyAlgorithms(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
    fun 'dec_kea'/3;
'getdec_SupportedPublicKeyAlgorithms'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  SupportedSignatureAlgorithms
%%================================
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'enc_dsa-with-sha1'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,1} ->
    fun 'enc_ecdsa-with-sha1'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,3,14,3,2,27} ->
    fun enc_dsaWithSHA1/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,3,14,3,2,29} ->
    fun 'enc_sha-1with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,1} ->
    fun 'enc_ecdsa-with-sha224'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,2} ->
    fun 'enc_ecdsa-with-sha256'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,3} ->
    fun 'enc_ecdsa-with-sha384'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,4} ->
    fun 'enc_ecdsa-with-sha512'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,2} ->
    fun 'enc_md2-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,4} ->
    fun 'enc_md5-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,5} ->
    fun 'enc_sha1-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'enc_rsassa-pss'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,11} ->
    fun 'enc_sha256-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,12} ->
    fun 'enc_sha384-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,13} ->
    fun 'enc_sha512-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,14} ->
    fun 'enc_sha224-with-rsa-encryption'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
    fun 'enc_dsa-with-sha224'/3;
getenc_SupportedSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
    fun 'enc_dsa-with-sha256'/3;
getenc_SupportedSignatureAlgorithms(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'dec_dsa-with-sha1'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,1} ->
    fun 'dec_ecdsa-with-sha1'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,3,14,3,2,27} ->
    fun 'dec_dsaWithSHA1'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,3,14,3,2,29} ->
    fun 'dec_sha-1with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,1} ->
    fun 'dec_ecdsa-with-sha224'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,2} ->
    fun 'dec_ecdsa-with-sha256'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,3} ->
    fun 'dec_ecdsa-with-sha384'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,4} ->
    fun 'dec_ecdsa-with-sha512'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,2} ->
    fun 'dec_md2-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,4} ->
    fun 'dec_md5-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,5} ->
    fun 'dec_sha1-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'dec_rsassa-pss'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,11} ->
    fun 'dec_sha256-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,12} ->
    fun 'dec_sha384-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,13} ->
    fun 'dec_sha512-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,14} ->
    fun 'dec_sha224-with-rsa-encryption'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
    fun 'dec_dsa-with-sha224'/3;
getdec_SupportedSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
    fun 'dec_dsa-with-sha256'/3;
'getdec_SupportedSignatureAlgorithms'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  SupportedAttributeTypeAndValues
%%================================
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,3} ->
    fun enc_commonName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,4} ->
    fun enc_surname/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,5} ->
    fun enc_serialNumber/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,6} ->
    fun enc_countryName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,7} ->
    fun enc_localityName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,8} ->
    fun enc_stateOrProvinceName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,10} ->
    fun enc_organizationName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,11} ->
    fun enc_organizationalUnitName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,12} ->
    fun enc_title/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,41} ->
    fun enc_name/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,42} ->
    fun enc_givenName/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,43} ->
    fun enc_initials/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,44} ->
    fun enc_generationQualifier/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,46} ->
    fun enc_dnQualifier/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,65} ->
    fun enc_pseudonym/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
    fun enc_domainComponent/3;
getenc_SupportedAttributeTypeAndValues(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun enc_emailAddress/3;
getenc_SupportedAttributeTypeAndValues(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,3} ->
    fun 'dec_commonName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,4} ->
    fun 'dec_surname'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,5} ->
    fun 'dec_serialNumber'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,6} ->
    fun 'dec_countryName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,7} ->
    fun 'dec_localityName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,8} ->
    fun 'dec_stateOrProvinceName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,10} ->
    fun 'dec_organizationName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,11} ->
    fun 'dec_organizationalUnitName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,12} ->
    fun 'dec_title'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,41} ->
    fun 'dec_name'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,42} ->
    fun 'dec_givenName'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,43} ->
    fun 'dec_initials'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,44} ->
    fun 'dec_generationQualifier'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,46} ->
    fun 'dec_dnQualifier'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {2,5,4,65} ->
    fun 'dec_pseudonym'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
    fun 'dec_domainComponent'/3;
getdec_SupportedAttributeTypeAndValues(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'dec_emailAddress'/3;
'getdec_SupportedAttributeTypeAndValues'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  internal_object_set_argument_9
%%================================
getenc_internal_object_set_argument_9(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_9(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_6'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSASSA-PSS-params'(Val)
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSASSA-PSS-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,8}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_HashAlgorithm'(Val)
      end
   end;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,8}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_HashAlgorithm'(Bytes)
      end
   end;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_3({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_3({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_3({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_3'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_3'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_3'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_3'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSASSA-PSS-params'(Val)
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSASSA-PSS-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_1
%%================================
getenc_internal_object_set_argument_1({1,2,840,113549,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({1,2,840,113549,2,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_internal_object_set_argument_1'({1,2,840,113549,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({1,2,840,113549,2,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  internal_object_set_argument_19
%%================================
getenc_internal_object_set_argument_19(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_19(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_18
%%================================
getenc_internal_object_set_argument_18(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_18(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_17
%%================================
getenc_internal_object_set_argument_17(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_17(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_16
%%================================
getenc_internal_object_set_argument_16(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_16(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_15
%%================================
getenc_internal_object_set_argument_15(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_15(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_14
%%================================
getenc_internal_object_set_argument_14(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun enc_contentType/3;
getenc_internal_object_set_argument_14(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun enc_messageDigest/3;
getenc_internal_object_set_argument_14(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun enc_counterSignature/3;
getenc_internal_object_set_argument_14(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_14(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_contentType'/3;
getdec_internal_object_set_argument_14(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_messageDigest'/3;
getdec_internal_object_set_argument_14(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'dec_counterSignature'/3;
getdec_internal_object_set_argument_14(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_13
%%================================
getenc_internal_object_set_argument_13(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun enc_contentType/3;
getenc_internal_object_set_argument_13(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun enc_messageDigest/3;
getenc_internal_object_set_argument_13(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun enc_counterSignature/3;
getenc_internal_object_set_argument_13(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_13(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_contentType'/3;
getdec_internal_object_set_argument_13(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_messageDigest'/3;
getdec_internal_object_set_argument_13(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'dec_counterSignature'/3;
getdec_internal_object_set_argument_13(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_12
%%================================
getenc_internal_object_set_argument_12(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_12(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_11
%%================================
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun enc_contentType/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun enc_messageDigest/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun enc_signingTime/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,2} ->
    fun enc_messageType/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,3} ->
    fun enc_pkiStatus/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,4} ->
    fun enc_failInfo/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,5} ->
    fun enc_senderNonce/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,6} ->
    fun enc_recipientNonce/3;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,7} ->
    fun enc_transactionID/3;
getenc_internal_object_set_argument_11(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_contentType'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_messageDigest'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_signingTime'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,2} ->
    fun 'dec_messageType'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,3} ->
    fun 'dec_pkiStatus'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,4} ->
    fun 'dec_failInfo'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,5} ->
    fun 'dec_senderNonce'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,6} ->
    fun 'dec_recipientNonce'/3;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,113733,1,9,7} ->
    fun 'dec_transactionID'/3;
getdec_internal_object_set_argument_11(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_10
%%================================
getenc_internal_object_set_argument_10(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun enc_contentType/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun enc_messageDigest/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun enc_signingTime/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,2} ->
    fun enc_messageType/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,3} ->
    fun enc_pkiStatus/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,4} ->
    fun enc_failInfo/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,5} ->
    fun enc_senderNonce/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,6} ->
    fun enc_recipientNonce/3;
getenc_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,7} ->
    fun enc_transactionID/3;
getenc_internal_object_set_argument_10(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_10(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_contentType'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_messageDigest'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_signingTime'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,2} ->
    fun 'dec_messageType'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,3} ->
    fun 'dec_pkiStatus'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,4} ->
    fun 'dec_failInfo'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,5} ->
    fun 'dec_senderNonce'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,6} ->
    fun 'dec_recipientNonce'/3;
getdec_internal_object_set_argument_10(Id) when Id =:= {2,16,840,1,113733,1,9,7} ->
    fun 'dec_transactionID'/3;
getdec_internal_object_set_argument_10(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.




'dec-inc-Certificate'(Tlv) ->
   'dec-inc-Certificate'(Tlv, [16]).

'dec-inc-Certificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PUB-KEY:TBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = {'Certificate_tbsCertificate',V1},

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Certificate',Term1,Term2,Term3},
Res1.


'dec-inc-CertificateList'(Tlv) ->
   'dec-inc-CertificateList'(Tlv, [16]).

'dec-inc-CertificateList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertList(1)   External OTP-PUB-KEY:TBSCertList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = {'CertificateList_tbsCertList',V1},

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External OTP-PUB-KEY:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertificateList',Term1,Term2,Term3},
Res1.
decode_TBSCert_exclusive(Bytes) ->
  decode_partial_incomplete('Certificate', Bytes, [mandatory,{undecoded,[16]}]).
decode_TBSCertList_exclusive(Bytes) ->
  decode_partial_incomplete('CertificateList', Bytes, [mandatory,{undecoded,[16]}]).
decode_inc_disp('CertificateList_tbsCertList',Data) ->
  'dec_TBSCertList'(Data,[16]);
decode_inc_disp('Certificate_tbsCertificate',Data) ->
  'dec_TBSCertificate'(Data,[16]).

%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    _ = decode_primitive_incomplete([{undecoded,0},{alt_parts,0}], element(6, Arg)),
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try is_default_cs_18(Value) of
_ -> true
catch throw:false -> false
end.


is_default_10(asn1_DEFAULT) ->
true;
is_default_10(Def) when Def =:= false ->
true;
is_default_10(_) ->
false.


is_default_11(asn1_DEFAULT) ->
true;
is_default_11(Def) when Def =:= false ->
true;
is_default_11(_) ->
false.


is_default_12(asn1_DEFAULT) ->
true;
is_default_12(Def) when Def =:= false ->
true;
is_default_12(_) ->
false.


is_default_13(asn1_DEFAULT) ->
true;
is_default_13(Def) when Def =:= false ->
true;
is_default_13(_) ->
false.


is_default_14(asn1_DEFAULT) ->
true;
is_default_14(Def) when Def =:= 0 ->
true;
is_default_14(_) ->
false.


is_default_15(asn1_DEFAULT) ->
true;
is_default_15(Def) when Def =:= false ->
true;
is_default_15(_) ->
false.


is_default_16(asn1_DEFAULT) ->
true;
is_default_16(Value) ->
try check_int(Value, 0, [{v1,0}]) of
_ -> true
catch throw:false -> false
end.


is_default_17(asn1_DEFAULT) ->
true;
is_default_17(Value) ->
try check_int(Value, 0, [{v1,0},{v2,1},{v3,2}]) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Value) ->
try is_default_cs_19(Value) of
_ -> true
catch throw:false -> false
end.


is_default_3(asn1_DEFAULT) ->
true;
is_default_3(Def) when Def =:= 20 ->
true;
is_default_3(_) ->
false.


is_default_4(asn1_DEFAULT) ->
true;
is_default_4(Value) ->
try check_int(Value, 1, [{trailerFieldBC,1}]) of
_ -> true
catch throw:false -> false
end.


is_default_5(asn1_DEFAULT) ->
true;
is_default_5(Value) ->
try is_default_cs_18(Value) of
_ -> true
catch throw:false -> false
end.


is_default_6(asn1_DEFAULT) ->
true;
is_default_6(Value) ->
try is_default_cs_19(Value) of
_ -> true
catch throw:false -> false
end.


is_default_7(asn1_DEFAULT) ->
true;
is_default_7(Value) ->
try is_default_cs_20(Value) of
_ -> true
catch throw:false -> false
end.


is_default_8(asn1_DEFAULT) ->
true;
is_default_8(Def) when Def =:= true ->
true;
is_default_8(_) ->
false.


is_default_9(asn1_DEFAULT) ->
true;
is_default_9(Value) ->
try check_named_bitstring(Value, [unclassified], <<1:2>>, 2) of
_ -> true
catch throw:false -> false
end.


is_default_cs_18(Value) ->
case Value of
{'HashAlgorithm',
E1,
'NULL'} ->
check_objectidentifier(E1, {[[1,iso],[3,'identified-organization']],[14,3,2,26]});
_ ->
throw(false)
end.

is_default_cs_19(Value) ->
case Value of
{'MaskGenAlgorithm',
E1,
{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,1,1,8]});
_ ->
throw(false)
end.

is_default_cs_20(Value) ->
case Value of
{'PSourceAlgorithm',
E1,
<<>>} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,1,1,9]});
_ ->
throw(false)
end.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_int(Value, Value, _) when is_integer(Value) ->
    true;
check_int(Value, DefValue, NNL) when is_atom(Value) ->
    case lists:keyfind(Value, 1, NNL) of
        {_, DefValue} ->
            true;
        _ ->
            throw(false)
    end;
check_int(_, _, _) ->
    throw(false).

check_named_bitstring([_ | _] = Val, Names, _, _) ->
    case lists:sort(Val) of
        Names ->
            true;
        _ ->
            throw(false)
    end;
check_named_bitstring(Bs, _, Bs, _) ->
    true;
check_named_bitstring(Val, _, Bs, BsSize) ->
    Rest = bit_size(Val) - BsSize,
    case Val of
        <<Bs:BsSize/bits,0:Rest>> ->
            true;
        _ ->
            throw(false)
    end.

check_objectidentifier(Value, {Prefix, Tail}) when is_tuple(Value) ->
    check_oid(tuple_to_list(Value), Prefix, Tail);
check_objectidentifier(_, _) ->
    throw(false).

check_oid([H | T], [K | Ks], Tail) ->
    case lists:member(H, K) of
        false ->
            throw(false);
        true ->
            check_oid(T, Ks, Tail)
    end;
check_oid(Tail, [], Tail) ->
    true;
check_oid(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_BMP_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_BMP_string(binary_to_list(Bin)).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_bitstring2(1, Unused,
                  <<B7:1,B6:1,B5:1,B4:1,B3:1,B2:1,B1:1,B0:1,_/binary>>) ->
    lists:sublist([B7, B6, B5, B4, B3, B2, B1, B0], 8 - Unused);
decode_bitstring2(Len, Unused,
                  <<B7:1,
                    B6:1,
                    B5:1,
                    B4:1,
                    B3:1,
                    B2:1,
                    B1:1,
                    B0:1,
                    Buffer/binary>>) ->
    [B7, B6, B5, B4, B3, B2, B1, B0 |
     decode_bitstring2(Len - 1, Unused, Buffer)].

decode_bitstring_NNL(BitList, NamedNumberList) ->
    decode_bitstring_NNL(BitList, NamedNumberList, 0, []).

decode_bitstring_NNL([], _, _No, Result) ->
    lists:reverse(Result);
decode_bitstring_NNL([B | BitList],
                     [{Name, No} | NamedNumberList],
                     No, Result) ->
    if
        B =:= 0 ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 Result);
        true ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 [Name | Result])
    end;
decode_bitstring_NNL([1 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList,
                         No + 1,
                         [{bit, No} | Result]);
decode_bitstring_NNL([0 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList, No + 1, Result).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_constr_indef_incomplete(_TagMatch, <<0,0,Rest/binary>>, Acc) ->
    {lists:reverse(Acc), Rest};
decode_constr_indef_incomplete([Tag | RestTags], Bin, Acc) ->
    case decode_primitive_incomplete([Tag], Bin) of
        {Tlv, Rest} ->
            decode_constr_indef_incomplete(RestTags, Rest, [Tlv | Acc]);
        asn1_NOVALUE ->
            decode_constr_indef_incomplete(RestTags, Bin, Acc)
    end.

decode_constructed(Bin) when byte_size(Bin) =:= 0 ->
    [];
decode_constructed(Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed(Rest)].

decode_constructed_incomplete([Tags = [Ts]], Bin) when is_list(Ts) ->
    decode_constructed_incomplete(Tags, Bin);
decode_constructed_incomplete(_TagMatch, <<>>) ->
    [];
decode_constructed_incomplete([mandatory | RestTag], Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed_incomplete(RestTag, Rest)];
decode_constructed_incomplete([{Alt, _} | _] = Directives, Bin)
    when Alt =:= alt_undecoded; Alt =:= alt; Alt =:= alt_parts ->
    {_Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    case incomplete_choice_alt(TagNo, Directives) of
        {alt_undecoded, _} ->
            LenA = byte_size(Bin) - byte_size(Rest),
            <<A:LenA/binary,Rest/binary>> = Bin,
            A;
        {alt, InnerDirectives} ->
            {Tlv, Rest} =
                decode_primitive_incomplete(InnerDirectives, V),
            {TagNo, Tlv};
        {alt_parts, _} ->
            [{TagNo, decode_parts_incomplete(V)}];
        no_match ->
            {Tlv, _} = decode_primitive(Bin),
            Tlv
    end;
decode_constructed_incomplete([TagNo | RestTag], Bin) ->
    case decode_primitive_incomplete([TagNo], Bin) of
        {Tlv, Rest} ->
            [Tlv | decode_constructed_incomplete(RestTag, Rest)];
        asn1_NOVALUE ->
            decode_constructed_incomplete(RestTag, Bin)
    end;
decode_constructed_incomplete([], Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed_incomplete([], Rest)].

decode_constructed_indefinite(<<0,0,Rest/binary>>, Acc) ->
    {lists:reverse(Acc), Rest};
decode_constructed_indefinite(Bin, Acc) ->
    {Tlv, Rest} = decode_primitive(Bin),
    decode_constructed_indefinite(Rest, [Tlv | Acc]).

decode_incomplete2(_Form = 2, TagNo, V, TagMatch, _) ->
    {Vlist, Rest2} = decode_constr_indef_incomplete(TagMatch, V, []),
    {{TagNo, Vlist}, Rest2};
decode_incomplete2(1, TagNo, V, [TagMatch], Rest) when is_list(TagMatch) ->
    {{TagNo, decode_constructed_incomplete(TagMatch, V)}, Rest};
decode_incomplete2(1, TagNo, V, TagMatch, Rest) ->
    {{TagNo, decode_constructed_incomplete(TagMatch, V)}, Rest};
decode_incomplete2(0, TagNo, V, _TagMatch, Rest) ->
    {{TagNo, V}, Rest}.

decode_incomplete_bin(Bin) ->
    {ok, Rest} = skip_tag(Bin),
    {ok, Rest2} = skip_length_and_value(Rest),
    IncLen = byte_size(Bin) - byte_size(Rest2),
    <<IncBin:IncLen/binary,Ret/binary>> = Bin,
    {IncBin, Ret}.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_length(<<1:1,0:7,T/binary>>) ->
    {indefinite, T};
decode_length(<<0:1,Length:7,T/binary>>) ->
    {Length, T};
decode_length(<<1:1,LL:7,Length:LL/unit:8,T/binary>>) ->
    {Length, T}.

decode_named_bit_string(Buffer, NamedNumberList, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            [];
        <<Unused,Bits/binary>> ->
            BitString = decode_bitstring2(byte_size(Bits), Unused, Bits),
            decode_bitstring_NNL(BitString, NamedNumberList)
    end.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_open_type_as_binary(Tlv, TagIn) ->
    ber_encode(match_tags(Tlv, TagIn)).

decode_parts_incomplete(<<>>) ->
    [];
decode_parts_incomplete(Bin) ->
    {ok, Rest} = skip_tag(Bin),
    {ok, Rest2} = skip_length_and_value(Rest),
    LenPart = byte_size(Bin) - byte_size(Rest2),
    <<Part:LenPart/binary,RestBin/binary>> = Bin,
    [Part | decode_parts_incomplete(RestBin)].

decode_primitive(Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    case Form of
        1 ->
            {{TagNo, decode_constructed(V)}, Rest};
        0 ->
            {{TagNo, V}, Rest};
        2 ->
            {Vlist, Rest2} = decode_constructed_indefinite(V, []),
            {{TagNo, Vlist}, Rest2}
    end.

decode_primitive_incomplete([{default, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, [], Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{default, TagNo, Directives}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{default_undecoded, [Tag | _]}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, Tag, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, [], Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt, TagNo, Directives}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt_undecoded, [Tag | _]}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, Tag, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{alt_undecoded, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, TagNo, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, V}, Rest};
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt, TagNo, Directives} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt_parts, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, V}, Rest};
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{alt_parts, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, decode_parts_incomplete(V)}, Rest};
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{undecoded, _TagNo} | _RestTag], Bin) ->
    decode_incomplete_bin(Bin);
decode_primitive_incomplete([{parts, [TagNo | MoreTags]} | _RestTag],
                            Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            case MoreTags of
                [] ->
                    {{TagNo, decode_parts_incomplete(V)}, Rest};
                [TagNo2] ->
                    {_, TagNo2, V2, <<>>} = decode_tag_and_length(V),
                    {{TagNo, {TagNo2, decode_parts_incomplete(V2)}},
                     Rest}
            end;
        Err ->
            {error, {asn1, "tag failure", TagNo, Err}}
    end;
decode_primitive_incomplete([mandatory | RestTag], Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    decode_incomplete2(Form, TagNo, V, RestTag, Rest);
decode_primitive_incomplete([{mandatory, Directives}], Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    decode_incomplete2(Form, TagNo, V, Directives, Rest);
decode_primitive_incomplete([], Bin) ->
    decode_primitive(Bin).

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

decode_tag(<<0:1,PartialTag:7,Buffer/binary>>, TagAck) ->
    TagNo = TagAck bsl 7 bor PartialTag,
    {TagNo, Buffer};
decode_tag(<<_:1,PartialTag:7,Buffer/binary>>, TagAck) ->
    TagAck1 = TagAck bsl 7 bor PartialTag,
    decode_tag(Buffer, TagAck1).

decode_tag_and_length(<<Class:2,
                        Form:1,
                        TagNo:5,
                        0:1,
                        Length:7,
                        V:Length/binary,
                        RestBuffer/binary>>)
    when TagNo < 31 ->
    {Form, Class bsl 16 bor TagNo, V, RestBuffer};
decode_tag_and_length(<<Class:2,1:1,TagNo:5,1:1,0:7,T/binary>>)
    when TagNo < 31 ->
    {2, Class bsl 16 + TagNo, T, <<>>};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        TagNo:5,
                        1:1,
                        LL:7,
                        Length:LL/unit:8,
                        V:Length/binary,
                        T/binary>>)
    when TagNo < 31 ->
    {Form, Class bsl 16 bor TagNo, V, T};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        0:1,
                        TagNo:7,
                        0:1,
                        Length:7,
                        V:Length/binary,
                        RestBuffer/binary>>) ->
    {Form, Class bsl 16 bor TagNo, V, RestBuffer};
decode_tag_and_length(<<Class:2,1:1,31:5,0:1,TagNo:7,1:1,0:7,T/binary>>) ->
    {2, Class bsl 16 bor TagNo, T, <<>>};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        0:1,
                        TagNo:7,
                        1:1,
                        LL:7,
                        Length:LL/unit:8,
                        V:Length/binary,
                        T/binary>>) ->
    {Form, Class bsl 16 bor TagNo, V, T};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        1:1,
                        TagPart1:7,
                        0:1,
                        TagPartLast,
                        Buffer/binary>>) ->
    TagNo = TagPart1 bsl 7 bor TagPartLast,
    {Length, RestBuffer} = decode_length(Buffer),
    <<V:Length/binary,RestBuffer2/binary>> = RestBuffer,
    {Form, Class bsl 16 bor TagNo, V, RestBuffer2};
decode_tag_and_length(<<Class:2,Form:1,31:5,Buffer/binary>>) ->
    {TagNo, Buffer1} = decode_tag(Buffer, 0),
    {Length, RestBuffer} = decode_length(Buffer1),
    <<V:Length/binary,RestBuffer2/binary>> = RestBuffer,
    {Form, Class bsl 16 bor TagNo, V, RestBuffer2}.

decode_universal_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_universal_string(binary_to_list(Bin)).

do_encode_named_bit_string([FirstVal | RestVal], NamedBitList, TagIn) ->
    ToSetPos = get_all_bitposes([FirstVal | RestVal], NamedBitList, []),
    Size = lists:max(ToSetPos) + 1,
    BitList = make_and_set_list(Size, ToSetPos, 0),
    {Len, Unused, OctetList} = encode_bitstring(BitList),
    encode_tags(TagIn, [Unused | OctetList], Len + 1).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_BMP_string(BMPString, TagIn) ->
    OctetList = mk_BMP_list(BMPString),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest]) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Val], 1);
encode_bitstring(Val) ->
    {Unused, Octet} = unused_bitlist(Val, 7, 0),
    {1, Unused, [Octet]}.

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest], Ack, Len) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Ack, Val], Len + 1);
encode_bitstring([], Ack, Len) ->
    {Len, 0, Ack};
encode_bitstring(Rest, Ack, Len) ->
    {Unused, Val} = unused_bitlist(Rest, 7, 0),
    {Len + 1, Unused, [Ack, Val]}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_named_bit_string([H | _] = Bits, NamedBitList, TagIn)
    when is_atom(H) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([{bit, _} | _] = Bits, NamedBitList, TagIn) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([], _NamedBitList, TagIn) ->
    encode_unnamed_bit_string(<<>>, TagIn);
encode_named_bit_string(Bits, _NamedBitList, TagIn)
    when is_bitstring(Bits) ->
    encode_unnamed_bit_string(Bits, TagIn).

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_universal_string(Universal, TagIn) ->
    OctetList = mk_uni_list(Universal),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

get_all_bitposes([{bit, ValPos} | Rest], NamedBitList, Ack) ->
    get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
get_all_bitposes([Val | Rest], NamedBitList, Ack) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedBitList) of
        {_ValName, ValPos} ->
            get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
        _ ->
            exit({error, {asn1, {bitstring_namedbit, Val}}})
    end;
get_all_bitposes([], _NamedBitList, Ack) ->
    lists:sort(Ack).

incomplete_choice_alt(TagNo, [{Alt, TagNo} | Directives]) ->
    {Alt, Directives};
incomplete_choice_alt(TagNo, [D]) when is_list(D) ->
    incomplete_choice_alt(TagNo, D);
incomplete_choice_alt(TagNo, [_H | Directives]) ->
    incomplete_choice_alt(TagNo, Directives);
incomplete_choice_alt(_, []) ->
    no_match.

make_and_set_list(0, [], _) ->
    [];
make_and_set_list(0, _, _) ->
    exit({error, {asn1, bitstring_sizeconstraint}});
make_and_set_list(Len, [XPos | SetPos], XPos) ->
    [1 | make_and_set_list(Len - 1, SetPos, XPos + 1)];
make_and_set_list(Len, [Pos | SetPos], XPos) ->
    [0 | make_and_set_list(Len - 1, [Pos | SetPos], XPos + 1)];
make_and_set_list(Len, [], XPos) ->
    [0 | make_and_set_list(Len - 1, [], XPos + 1)].

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_BMP_list(In) ->
    mk_BMP_list(In, []).

mk_BMP_list([], List) ->
    lists:reverse(List);
mk_BMP_list([{0, 0, C, D} | T], List) ->
    mk_BMP_list(T, [D, C | List]);
mk_BMP_list([H | T], List) ->
    mk_BMP_list(T, [H, 0 | List]).

mk_BMP_string(In) ->
    mk_BMP_string(In, []).

mk_BMP_string([], US) ->
    lists:reverse(US);
mk_BMP_string([0, B | T], US) ->
    mk_BMP_string(T, [B | US]);
mk_BMP_string([C, D | T], US) ->
    mk_BMP_string(T, [{0, 0, C, D} | US]).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

mk_uni_list(In) ->
    mk_uni_list(In, []).

mk_uni_list([], List) ->
    lists:reverse(List);
mk_uni_list([{A, B, C, D} | T], List) ->
    mk_uni_list(T, [D, C, B, A | List]);
mk_uni_list([H | T], List) ->
    mk_uni_list(T, [H, 0, 0, 0 | List]).

mk_universal_string(In) ->
    mk_universal_string(In, []).

mk_universal_string([], Acc) ->
    lists:reverse(Acc);
mk_universal_string([0, 0, 0, D | T], Acc) ->
    mk_universal_string(T, [D | Acc]);
mk_universal_string([A, B, C, D | T], Acc) ->
    mk_universal_string(T, [{A, B, C, D} | Acc]).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.

skip_indefinite_value(<<0,0,Rest/binary>>) ->
    {ok, Rest};
skip_indefinite_value(Binary) ->
    {ok, RestBinary} = skip_tag(Binary),
    {ok, RestBinary2} = skip_length_and_value(RestBinary),
    skip_indefinite_value(RestBinary2).

skip_length_and_value(Binary) ->
    case decode_length(Binary) of
        {indefinite, RestBinary} ->
            skip_indefinite_value(RestBinary);
        {Length, RestBinary} ->
            <<_:Length/unit:8,Rest/binary>> = RestBinary,
            {ok, Rest}
    end.

skip_long_tag(<<1:1,_:7,Rest/binary>>) ->
    skip_long_tag(Rest);
skip_long_tag(<<0:1,_:7,Rest/binary>>) ->
    {ok, Rest}.

skip_tag(<<_:3,31:5,Rest/binary>>) ->
    skip_long_tag(Rest);
skip_tag(<<_:3,_Tag:5,Rest/binary>>) ->
    {ok, Rest}.

unused_bitlist([], Trail, Ack) ->
    {Trail + 1, Ack};
unused_bitlist([Bit | Rest], Trail, Ack) ->
    unused_bitlist(Rest, Trail - 1, Bit bsl Trail bor Ack).
